## 2.9.21.20241019 (2024-10-19)

[psycopg2] Bump to 2.9.10 (#12835)

Mark all error codes as `Final`

## 2.9.21.20240819 (2024-08-19)

Forbid extremely long line lengths in non-autogenerated stubs (#12537)

Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 2.9.21.20240417 (2024-04-17)

Remove remaining bare `Incomplete`s (#11768)

Enable Y065

## 2.9.21.20240311 (2024-03-11)

Use PEP 570 syntax in third party stubs (#11554)

## 2.9.21.20240218 (2024-02-18)

psycopg2: make Range generic (#11435)

And some other small fixes

## 2.9.21.20240201 (2024-02-01)

issue-11282: psycopg2 ReplicationConnection.cursor() return type (#11298)

Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>

## 2.9.21.20240118 (2024-01-18)

psycopg2: Add ReplicationCursor.consume_stream (#11283)

## 2.9.21.20240106 (2024-01-06)

Update typing_extensions imports in third-party stubs (#11245)

Remove Python 3.7 branches (#11238)

## 2.9.21.20 (2023-12-07)

psycopg2: improve `cursor_factory` params (#11085)

fix(psycopg2): fix copy_expert signature (#11099)

## 2.9.21.19 (2023-11-30)

Use `ConvertibleToInt`/`ConvertibleToFloat` in many third-party stubs (#11022)

Note: this may make the latest version of certain stubs packages incompatible with older versions of mypy and pyright.

## 2.9.21.18 (2023-11-28)

psycopg2: fix range annotations (#11071)

## 2.9.21.17 (2023-11-24)

Third-party stubs: remove unused `type: ignore`s (#11063)

## 2.9.21.16 (2023-11-15)

psycopg2: Accept `Composable` for `cursor.mogrify` (#11028)

Signed-off-by: Anders Kaseorg <andersk@mit.edu>

## 2.9.21.15 (2023-10-29)

psycopg2: Fix missing `Protocol` base class in file protocols (#10943)

This is an error I introduced in #10630 because I didn't know protocols
need to be explicitly inherited from in other protocol subclasses.

The added test shows the change. Basically these protocols were unusable.

## 2.9.21.14 (2023-09-24)

Complete psycopg2 (#10760)

## 2.9.21.13 (2023-09-15)

Fix `psycopg2.sql.SQL.join` annotation (#10716)

## 2.9.21.12 (2023-09-13)

psycopg2: Add missing modules, add annotations (#10630)

## 2.9.21.11 (2023-07-20)

Add an upstream_repository field to METADATA.toml (#10487)

Closes: #10478

## 2.9.21.10 (2023-05-10)

Add `partial_stub` metadata field (#10157)

## 2.9.21.9 (2023-03-27)

Add default values for third-party stubs beginning with 'P' (#9957)

## 2.9.21.8 (2023-02-26)

Improve many `__(a)exit__` annotations (#9696)

## 2.9.21.7 (2023-02-23)

Remove unused `type: ignore` comments (#9801)

## 2.9.21.6 (2023-02-21)

Stubtest settings: change `ignore_missing_stub` default to `false` (#9779)

If you're reading about this commit from an autogenerated changelog entry, this should have no user-visible impact on how the stubs are interpreted by a type checker; it's just an internal change to how typeshed's tests work.

## 2.9.21.5 (2023-02-15)

Use `typing_extensions.Self` instead of `_typeshed.Self` (#9702)

## 2.9.21.4 (2023-01-18)

Improve pre-commit config (#9563)

- Add a few more hooks. These are all very fast, and I've found them useful in other projects:
  - Autofixes:
    - `trailing-whitespace`: fixes trailing whitespace
    - `requirements-txt-fixer`: alphabetises items in `requirements.txt` files
    - `end-of-file-fixer`: makes sure every file ends with a single newline character
    - `mixed-line-ending`: Makes sure Windows users don't accidentally introduce CRLF line endings into a file that uses LF line endings
  - None-autofixes:
    - `check-yaml`: loads YAML files to validate syntax
    - `check-toml`: loads TOML files to validate syntax
    - `check-merge-conflict`: detects merge-conflict strings in files and blocks them from accidentally being committed
    - `check-case-conflict`: checks for files with names that would conflict on a case-insensitive filesystem like MacOS HFS+ or Windows FAT; blocks them from being committed.
  - Change the bot schedule to quarterly, to reduce noisy PRs
  - Change the `black` language target-version to Python 3.10, synching the setting here with the changes that were made to our `pyproject.toml` file in #7538

## 2.9.21.3 (2023-01-18)

Replace `Any` with `Incomplete` in many places (#9558)

## 2.9.21.2 (2022-11-09)

Annotate known magic-method return types (#9131)

## 2.9.21.1 (2022-10-07)

psycopg2: __nonzero__ was removed (#8863)

Fixes #8862

## 2.9.21 (2022-08-21)

Improve return type for psycopg2 connect function (#8567)

When a `connection_factory` argument is provided to psycopg2's `connect` function, the function's return type now matches that of the factory output class. However, if `cursor_factory` is set and has a non-`None` value and/or `connection_factory` is not set or is `None`, the return type is simply `connection`, as before.

## 2.9.20 (2022-08-17)

Additional return types for psycopg2 connections (#8528)

* Return types for psycopg2 dict connections

DB connection and cursor methods that deal with `dict`-style results now indicate the expected return types as implemented.

* Return types for psycopg2 namedtuple connections

DB connection and cursor methods that deal with `namedtuple` results now indicate the expected return types as implemented.

* Use ABC iterator

As required by flake8, the `Iterator` referenced in psycopg2's `extras` module has been switched to the `collections.abc.Iterator[T]` variant.

* Fix base psycopg2 cursor iter return type

The previous return type of `Self` is wrong; `cursor`'s `__iter__` method returns an `Iterator`.

* Correct return type for cursor iter and next methods

The previous attempt to fix the return type of `cursor`'s (and subclasses) `__iter__` method was misguided; they should indeed return `Self`. It's the `__next__` methods that had to be updated to return the correct record/row instance type.

* Comprehensive overloads for psycopg2 extra connections

Provides full method signatures for the `cursor` methods of the `DictConnection`, `RealDictConnection` and `NamedTupleConnection` types. Notably this includes a default value for `cursor_factory` in each case, while preserving the option to override the parameter manually.

* Have mypy ignore incompatible psycopg2 return types

The return types of the `fetch*` and `__next__` methods of `DictCursor`, `RealDictCursor` and `NamedTupleCursor` are incompatible with the base `cursor` class's corresponding methods' return types. However, this does accurately reflect reality, so ignore the mypy errors in those cases.

* Use ABC callable for psycopg2 extras module

As required by flake8, the `Callable` referenced in psycopg2's `extras` module has been switched to the `Callable` variant.

* Remove superfluous psycopg2 member overrides

Several members in the `DictCursorBase` type definition were entirely unnecessary, so they have been removed. In addition, adds a type to the `size` param of the `cursor`'s `fetchmany` method.

## 2.9.19 (2022-08-08)

Enhanced type hinting for psycopg2 stubs (#8500)

## 2.9.18 (2022-07-19)

Third-party stubs: enforce CamelCase for type alias names (#8256)

Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>

## 2.9.17 (2022-07-11)

Extend annotations for `psycopg2.sql` (#8263)

## 2.9.16 (2022-06-03)

psycopg2: stub improvements (#7964)

Fixes an entry from #7928 along with a number of other improvements.

I went off the C code:
https://github.com/psycopg/psycopg2/blob/master/psycopg/connection_type.c

## 2.9.15 (2022-05-30)

psycopg2: Fix the return type of Composable.as_string (#7984)

Signed-off-by: Zixuan James Li <359101898@qq.com>

## 2.9.14 (2022-05-21)

Annotations for psycopg2.ConnectionInfo (#7834)

* Annotations for psycopg2.ConnectionInfo

These annotations come from the documentation here:

https://www.psycopg.org/docs/extensions.html#psycopg2.extensions.ConnectionInfo
If there was doubt, I referred to the libpq documentation cited by
psycopg2's docs.

I wasn't completely sure about `dsn_parameters`. Psycopg2's docs list it
as an `dict`, and the example suggests it's a `dict[str, str]` at that.
From psycopg2's source I found

    https://github.com/psycopg/psycopg2/blob/1d3a89a0bba621dc1cc9b32db6d241bd2da85ad1/psycopg/conninfo_type.c#L183-L206

which is implemented here:

    https://github.com/psycopg/psycopg2/blob/1d3a89a0bba621dc1cc9b32db6d241bd2da85ad1/psycopg/utils.c#L251-L279

I'm no expert in CPython's API, but this looks to me like it's building
a `dict[str, str]`.

Additionally, the libpq docs

https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PQCONNINFO
https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PQCONNDEFAULTS

show that the underlying data just consists of strings.

Additionally, I'm pretty sure from this chunk of source

    https://github.com/psycopg/psycopg2/blob/1d3a89a0bba621dc1cc9b32db6d241bd2da85ad1/psycopg/conninfo_type.c#L581-L598

That `ConnectionInfo.__init__` takes one positional-only argument, which
must be a `psycopg2.connection`. But I don't think users are intended to
be constructing this type, so I've not added that annotation.

* Annotate `connection.info` and related attributes

* Make ConnectionInfo attributes properties

According to https://github.com/psycopg/psycopg2/blob/1d3a89a0bba621dc1cc9b32db6d241bd2da85ad1/psycopg/conninfo_type.c#L534-L563

* Mark connection attributes as readonly

according to https://github.com/psycopg/psycopg2/blob/8ef195f2ff187454cc709d7857235676bb4176ee/psycopg/connection_type.c#L1244

* Explain why some properties aren't `T | None`

## 2.9.13 (2022-04-22)

Annotate Error and Diagnostics (#7671)

Move cursor class to top of file so it can be used as base class

## 2.9.12 (2022-04-20)

Use `TypeAlias` for type aliases where possible, part II (#7667)

## 2.9.11 (2022-04-16)

Use `TypeAlias` where possible for type aliases (#7630)

## 2.9.10 (2022-04-08)

psycopg2: correct return type (#7607)

Fixes the return type of `psycopg2.cursor.fetchone()` to match the psycopg2 code:

https://github.com/psycopg/psycopg2/blob/1d3a89a0bba621dc1cc9b32db6d241bd2da85ad1/psycopg/cursor_type.c#L647-L651
https://github.com/psycopg/psycopg2/blob/1d3a89a0bba621dc1cc9b32db6d241bd2da85ad1/psycopg/cursor_type.c#L748-L786

It also matches the [psycopg2 documentation](https://www.psycopg.org/docs/cursor.html?highlight=copy_from#cursor.fetchone) as well as the [DB-API](https://peps.python.org/pep-0249/#fetchone)

## 2.9.9 (2022-03-16)

psycopg2: Accept Composable in place of query string (#7494)

https://www.psycopg.org/docs/sql.html#psycopg2.sql.Composable
“Composable objects can be passed directly to execute(),
executemany(), copy_expert() in place of the query string.”

Signed-off-by: Anders Kaseorg <andersk@mit.edu>

## 2.9.8 (2022-03-08)

psycopg2: Annotate cursor execute* and dunder methods (#7460)

## 2.9.7 (2022-02-22)

Correct several positional-only differences in third-party stubs (#7352)

## 2.9.5 (2021-12-28)

Use PEP 585 syntax wherever possible (#6717)

## 2.9.4 (2021-12-02)

Fix psycopg2 connection.cursor() stub (#6470)

Adds `scrollable=` argument missing since psycopg2 2.5 and prevents `Any` from being hinted when `cursor_factory=` is passed.

## 2.9.3 (2021-11-30)

psycopg2: use Error and Warning from _psycopg.pyi in errors.pyi (#6454)

## 2.9.2 (2021-11-23)

Move abstract methods to AbstractConnectionPool (#6340)

## 2.9.1 (2021-10-12)

Add star to all non-0.1 versions (#6146)

