use serde::Serialize;
use std::fmt::Display;

#[derive(Debug, Clone, PartialEq, Eq, Hash, PartialOrd, Ord, Serialize)]
pub struct Key(String);
impl Key {
    pub fn new(name: &str) -> Self {
        Key(name.to_string())
    }

    pub fn str(&self) -> &str {
        &self.0
    }
}

impl Display for Key {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.0)
    }
}
