% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serializer.R
\name{Serializer}
\alias{Serializer}
\title{Serializer class - base class for JSON/YAML serializers}
\description{
Serializer class - base class for JSON/YAML serializers

Serializer class - base class for JSON/YAML serializers
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{file_extension}}{(character) A file extension}

\item{\code{path}}{(character) full path to the yaml file}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Serializer-new}{\code{Serializer$new()}}
\item \href{#method-Serializer-serialize}{\code{Serializer$serialize()}}
\item \href{#method-Serializer-deserialize}{\code{Serializer$deserialize()}}
\item \href{#method-Serializer-clone}{\code{Serializer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Serializer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Serializer-new}{}}}
\subsection{Method \code{new()}}{
Create a new YAML object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Serializer$new(file_extension = NULL, path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_extension}}{(character) A file extension}

\item{\code{path}}{(character) path to the cassette, excluding the cassette
directory and the file extension}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{YAML} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Serializer-serialize"></a>}}
\if{latex}{\out{\hypertarget{method-Serializer-serialize}{}}}
\subsection{Method \code{serialize()}}{
Serializes a hash - REPLACED BY YAML/JSON METHODS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Serializer$serialize(x, path, bytes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(list) the object to serialize}

\item{\code{path}}{(character) the file path}

\item{\code{bytes}}{(logical) whether to preserve exact body bytes or not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(character) the YAML or JSON string to write to disk
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Serializer-deserialize"></a>}}
\if{latex}{\out{\hypertarget{method-Serializer-deserialize}{}}}
\subsection{Method \code{deserialize()}}{
Serializes a file - REPLACED BY YAML/JSON METHODS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Serializer$deserialize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Serializer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Serializer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Serializer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
