% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_smooth.R
\name{find_smooth}
\alias{find_smooth}
\title{Find smooth terms from a model object}
\usage{
find_smooth(x, flatten = FALSE)
}
\arguments{
\item{x}{A (gam) model.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned as character
vector, not as list. Duplicated values are removed.}
}
\value{
A character vector with the name(s) of the smooth terms.
}
\description{
Return the names of smooth terms from a model object.
}
\examples{
\dontshow{if (require("mgcv")) withAutoprint(\{ # examplesIf}
data(iris)
model <- mgcv::gam(Petal.Length ~ Petal.Width + s(Sepal.Length), data = iris)
find_smooth(model)
\dontshow{\}) # examplesIf}
}
