% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfcLocation.R
\name{getTximetaBFC}
\alias{getTximetaBFC}
\alias{setTximetaBFC}
\title{Get or set the directory of the BiocFileCache used by tximeta}
\usage{
getTximetaBFC()

setTximetaBFC(dir, quiet = FALSE)
}
\arguments{
\item{dir}{the location for tximeta's BiocFileCache. can be missing
in which case the function will call \code{file.choose} for choosing
location interactively}

\item{quiet}{whether to suppress feedback message}
}
\value{
the directory of the BiocFileCache used by tximeta
(or nothing, in the case of \code{setTximetaBFC})
}
\description{
Running \code{getTximetaBFC} will report the saved directory,
if it has been determined, or will return NULL.
Running \code{setTximetaBFC} will ask the user to specify a
BiocFileCache directory for accessing and saving TxDb sqlite files.
Note that tximeta's BiocFileCache can be set by the environmental
variable \code{TXIMETA_HUB_CACHE}, which will reset the cache location.
}
\examples{

# getting the BiocFileCache used by tximeta
# (may not be set, which uses BiocFileCache default or temp directory)
getTximetaBFC()

# don't want to actually change user settings so this is not run:
# setTximetaBFC()

}
