# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.connectedcache.aio import ConnectedCacheMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestConnectedCacheMgmtIspCacheNodesOperationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ConnectedCacheMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_get(self, resource_group):
        response = await self.client.isp_cache_nodes_operations.get(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
            cache_node_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.isp_cache_nodes_operations.begin_create_or_update(
                resource_group_name=resource_group.name,
                customer_resource_name="str",
                cache_node_resource_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "additionalCacheNodeProperties": {
                            "aggregatedStatusCode": 0,
                            "aggregatedStatusDetails": "str",
                            "aggregatedStatusText": "str",
                            "autoUpdateAppliedVersion": "str",
                            "autoUpdateLastAppliedDateTime": "2020-02-20 00:00:00",
                            "autoUpdateLastAppliedDetails": "str",
                            "autoUpdateLastAppliedState": "str",
                            "autoUpdateLastTriggeredDateTime": "2020-02-20 00:00:00",
                            "autoUpdateNextAvailableDateTime": "2020-02-20 00:00:00",
                            "autoUpdateNextAvailableVersion": "str",
                            "autoUpdateVersion": "str",
                            "bgpConfiguration": {"asnToIpAddressMapping": "str"},
                            "cacheNodePropertiesDetailsIssuesList": ["str"],
                            "cacheNodeState": 0,
                            "cacheNodeStateDetailedText": "str",
                            "cacheNodeStateShortText": "str",
                            "creationMethod": 0,
                            "currentTlsCertificate": {
                                "actionRequired": "str",
                                "certificateFileName": "str",
                                "expiryDate": "2020-02-20 00:00:00",
                                "notBeforeDate": "2020-02-20 00:00:00",
                                "subject": "str",
                                "subjectAltName": "str",
                                "thumbprint": "str",
                            },
                            "driveConfiguration": [
                                {"cacheNumber": 0, "nginxMapping": "str", "physicalPath": "str", "sizeInGb": 0}
                            ],
                            "isProvisioned": bool,
                            "isProxyRequired": "str",
                            "issuesCount": 0,
                            "issuesList": ["str"],
                            "lastAutoUpdateInfo": {
                                "autoUpdateLastAppliedStatus": 0,
                                "autoUpdateLastAppliedStatusDetailedText": "str",
                                "autoUpdateLastAppliedStatusText": "str",
                                "autoUpdateRingType": 0,
                                "createdDateTimeUtc": "2020-02-20 00:00:00",
                                "imageUriBeforeUpdate": "str",
                                "imageUriTargeted": "str",
                                "imageUriTerminal": "str",
                                "movedToTerminalStateDateTime": "2020-02-20 00:00:00",
                                "planChangeLogText": "str",
                                "planId": 0,
                                "ruleRequestedDay": 0,
                                "ruleRequestedHour": "str",
                                "ruleRequestedMinute": "str",
                                "ruleRequestedWeek": 0,
                                "timeToGoLiveDateTime": "str",
                                "updatedRegistryDateTimeUtc": "2020-02-20 00:00:00",
                            },
                            "optionalProperty1": "str",
                            "optionalProperty2": "str",
                            "optionalProperty3": "str",
                            "optionalProperty4": "str",
                            "optionalProperty5": "str",
                            "osType": "str",
                            "productVersion": "str",
                            "proxyUrlConfiguration": {"proxyUrl": "str"},
                            "tlsStatus": "str",
                            "updateInfoDetails": "str",
                            "updateRequestedDateTime": "2020-02-20 00:00:00",
                        },
                        "cacheNode": {
                            "addressSpace": 0,
                            "autoUpdateRequestedDay": 0,
                            "autoUpdateRequestedTime": "str",
                            "autoUpdateRequestedWeek": 0,
                            "autoUpdateRingType": "str",
                            "bgpAddressSpace": 0,
                            "bgpCidrBlocksCount": 0,
                            "bgpCidrCsvLastUpdateTime": "2020-02-20 00:00:00",
                            "bgpFileBytesTruncated": 0,
                            "bgpLastReportedTime": "2020-02-20 00:00:00",
                            "bgpNumberOfRecords": 0,
                            "bgpNumberOfTimesUpdated": 0,
                            "bgpReviewFeedback": "str",
                            "bgpReviewState": "str",
                            "bgpReviewStateText": "str",
                            "cacheNodeId": "str",
                            "cacheNodeName": "str",
                            "category": "str",
                            "cidrCsv": ["str"],
                            "cidrCsvLastUpdateTime": "2020-02-20 00:00:00",
                            "cidrSelectionType": 0,
                            "clientTenantId": "str",
                            "configurationState": "str",
                            "configurationStateText": "str",
                            "containerConfigurations": "str",
                            "containerResyncTrigger": 0,
                            "createAsyncOperationId": "str",
                            "customerAsn": 0,
                            "customerId": "str",
                            "customerIndex": "str",
                            "customerName": "str",
                            "deleteAsyncOperationId": "str",
                            "fullyQualifiedDomainName": "str",
                            "fullyQualifiedResourceId": "str",
                            "imageUri": "str",
                            "ipAddress": "str",
                            "isEnabled": bool,
                            "isEnterpriseManaged": bool,
                            "isFrozen": bool,
                            "lastSyncWithAzureTimestamp": "2020-02-20 00:00:00",
                            "lastUpdatedTimestamp": "2020-02-20 00:00:00",
                            "maxAllowableEgressInMbps": 0,
                            "maxAllowableProbability": 0.0,
                            "releaseVersion": 0,
                            "reviewFeedback": "str",
                            "reviewState": 0,
                            "reviewStateText": "str",
                            "shouldMigrate": bool,
                            "synchWithAzureAttemptsCount": 0,
                            "workerConnections": 0,
                            "workerConnectionsLastUpdatedDateTime": "2020-02-20 00:00:00",
                            "xCid": "str",
                        },
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "provisioningState": "str",
                        "status": "str",
                        "statusCode": "str",
                        "statusDetails": "str",
                        "statusText": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_update(self, resource_group):
        response = await self.client.isp_cache_nodes_operations.update(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
            cache_node_resource_name="str",
            properties={"tags": {"str": "str"}},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_begin_delete(self, resource_group):
        response = await (
            await self.client.isp_cache_nodes_operations.begin_delete(
                resource_group_name=resource_group.name,
                customer_resource_name="str",
                cache_node_resource_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_list_by_isp_customer_resource(self, resource_group):
        response = self.client.isp_cache_nodes_operations.list_by_isp_customer_resource(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_get_bgp_cidrs(self, resource_group):
        response = await self.client.isp_cache_nodes_operations.get_bgp_cidrs(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
            cache_node_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_get_cache_node_install_details(self, resource_group):
        response = await self.client.isp_cache_nodes_operations.get_cache_node_install_details(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
            cache_node_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_get_cache_node_auto_update_history(self, resource_group):
        response = await self.client.isp_cache_nodes_operations.get_cache_node_auto_update_history(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
            cache_node_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_isp_cache_nodes_operations_get_cache_node_mcc_issue_details_history(self, resource_group):
        response = await self.client.isp_cache_nodes_operations.get_cache_node_mcc_issue_details_history(
            resource_group_name=resource_group.name,
            customer_resource_name="str",
            cache_node_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...
