# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSWorkloadNetworksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get(self, resource_group):
        response = self.client.workload_networks.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list(self, resource_group):
        response = self.client.workload_networks.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_dhcp(self, resource_group):
        response = self.client.workload_networks.list_dhcp(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_dhcp(self, resource_group):
        response = self.client.workload_networks.get_dhcp(
            resource_group_name=resource_group.name,
            dhcp_id="str",
            private_cloud_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_dhcp(self, resource_group):
        response = self.client.workload_networks.begin_create_dhcp(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dhcp_id="str",
            workload_network_dhcp={
                "id": "str",
                "name": "str",
                "properties": "workload_network_dhcp_entity",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_update_dhcp(self, resource_group):
        response = self.client.workload_networks.begin_update_dhcp(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dhcp_id="str",
            workload_network_dhcp={
                "id": "str",
                "name": "str",
                "properties": "workload_network_dhcp_entity",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_dhcp(self, resource_group):
        response = self.client.workload_networks.begin_delete_dhcp(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dhcp_id="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_dns_services(self, resource_group):
        response = self.client.workload_networks.list_dns_services(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_dns_service(self, resource_group):
        response = self.client.workload_networks.get_dns_service(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dns_service_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_dns_service(self, resource_group):
        response = self.client.workload_networks.begin_create_dns_service(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dns_service_id="str",
            workload_network_dns_service={
                "id": "str",
                "name": "str",
                "properties": {
                    "defaultDnsZone": "str",
                    "displayName": "str",
                    "dnsServiceIp": "str",
                    "fqdnZones": ["str"],
                    "logLevel": "str",
                    "provisioningState": "str",
                    "revision": 0,
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_update_dns_service(self, resource_group):
        response = self.client.workload_networks.begin_update_dns_service(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dns_service_id="str",
            workload_network_dns_service={
                "id": "str",
                "name": "str",
                "properties": {
                    "defaultDnsZone": "str",
                    "displayName": "str",
                    "dnsServiceIp": "str",
                    "fqdnZones": ["str"],
                    "logLevel": "str",
                    "provisioningState": "str",
                    "revision": 0,
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_dns_service(self, resource_group):
        response = self.client.workload_networks.begin_delete_dns_service(
            resource_group_name=resource_group.name,
            dns_service_id="str",
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_dns_zones(self, resource_group):
        response = self.client.workload_networks.list_dns_zones(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_dns_zone(self, resource_group):
        response = self.client.workload_networks.get_dns_zone(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dns_zone_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_dns_zone(self, resource_group):
        response = self.client.workload_networks.begin_create_dns_zone(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dns_zone_id="str",
            workload_network_dns_zone={
                "id": "str",
                "name": "str",
                "properties": {
                    "displayName": "str",
                    "dnsServerIps": ["str"],
                    "dnsServices": 0,
                    "domain": ["str"],
                    "provisioningState": "str",
                    "revision": 0,
                    "sourceIp": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_update_dns_zone(self, resource_group):
        response = self.client.workload_networks.begin_update_dns_zone(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            dns_zone_id="str",
            workload_network_dns_zone={
                "id": "str",
                "name": "str",
                "properties": {
                    "displayName": "str",
                    "dnsServerIps": ["str"],
                    "dnsServices": 0,
                    "domain": ["str"],
                    "provisioningState": "str",
                    "revision": 0,
                    "sourceIp": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_dns_zone(self, resource_group):
        response = self.client.workload_networks.begin_delete_dns_zone(
            resource_group_name=resource_group.name,
            dns_zone_id="str",
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_gateways(self, resource_group):
        response = self.client.workload_networks.list_gateways(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_gateway(self, resource_group):
        response = self.client.workload_networks.get_gateway(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            gateway_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_port_mirroring(self, resource_group):
        response = self.client.workload_networks.list_port_mirroring(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_port_mirroring(self, resource_group):
        response = self.client.workload_networks.get_port_mirroring(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            port_mirroring_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_port_mirroring(self, resource_group):
        response = self.client.workload_networks.begin_create_port_mirroring(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            port_mirroring_id="str",
            workload_network_port_mirroring={
                "id": "str",
                "name": "str",
                "properties": {
                    "destination": "str",
                    "direction": "str",
                    "displayName": "str",
                    "provisioningState": "str",
                    "revision": 0,
                    "source": "str",
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_update_port_mirroring(self, resource_group):
        response = self.client.workload_networks.begin_update_port_mirroring(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            port_mirroring_id="str",
            workload_network_port_mirroring={
                "id": "str",
                "name": "str",
                "properties": {
                    "destination": "str",
                    "direction": "str",
                    "displayName": "str",
                    "provisioningState": "str",
                    "revision": 0,
                    "source": "str",
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_port_mirroring(self, resource_group):
        response = self.client.workload_networks.begin_delete_port_mirroring(
            resource_group_name=resource_group.name,
            port_mirroring_id="str",
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_public_ips(self, resource_group):
        response = self.client.workload_networks.list_public_ips(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_public_ip(self, resource_group):
        response = self.client.workload_networks.get_public_ip(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            public_ip_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_public_ip(self, resource_group):
        response = self.client.workload_networks.begin_create_public_ip(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            public_ip_id="str",
            workload_network_public_ip={
                "id": "str",
                "name": "str",
                "properties": {
                    "displayName": "str",
                    "numberOfPublicIPs": 0,
                    "provisioningState": "str",
                    "publicIPBlock": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_public_ip(self, resource_group):
        response = self.client.workload_networks.begin_delete_public_ip(
            resource_group_name=resource_group.name,
            public_ip_id="str",
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_segments(self, resource_group):
        response = self.client.workload_networks.list_segments(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_segment(self, resource_group):
        response = self.client.workload_networks.get_segment(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            segment_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_segments(self, resource_group):
        response = self.client.workload_networks.begin_create_segments(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            segment_id="str",
            workload_network_segment={
                "id": "str",
                "name": "str",
                "properties": {
                    "connectedGateway": "str",
                    "displayName": "str",
                    "portVif": [{"portName": "str"}],
                    "provisioningState": "str",
                    "revision": 0,
                    "status": "str",
                    "subnet": {"dhcpRanges": ["str"], "gatewayAddress": "str"},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_update_segments(self, resource_group):
        response = self.client.workload_networks.begin_update_segments(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            segment_id="str",
            workload_network_segment={
                "id": "str",
                "name": "str",
                "properties": {
                    "connectedGateway": "str",
                    "displayName": "str",
                    "portVif": [{"portName": "str"}],
                    "provisioningState": "str",
                    "revision": 0,
                    "status": "str",
                    "subnet": {"dhcpRanges": ["str"], "gatewayAddress": "str"},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_segment(self, resource_group):
        response = self.client.workload_networks.begin_delete_segment(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            segment_id="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_virtual_machines(self, resource_group):
        response = self.client.workload_networks.list_virtual_machines(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_virtual_machine(self, resource_group):
        response = self.client.workload_networks.get_virtual_machine(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            virtual_machine_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_list_vm_groups(self, resource_group):
        response = self.client.workload_networks.list_vm_groups(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_get_vm_group(self, resource_group):
        response = self.client.workload_networks.get_vm_group(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            vm_group_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_create_vm_group(self, resource_group):
        response = self.client.workload_networks.begin_create_vm_group(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            vm_group_id="str",
            workload_network_vm_group={
                "id": "str",
                "name": "str",
                "properties": {
                    "displayName": "str",
                    "members": ["str"],
                    "provisioningState": "str",
                    "revision": 0,
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_update_vm_group(self, resource_group):
        response = self.client.workload_networks.begin_update_vm_group(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            vm_group_id="str",
            workload_network_vm_group={
                "id": "str",
                "name": "str",
                "properties": {
                    "displayName": "str",
                    "members": ["str"],
                    "provisioningState": "str",
                    "revision": 0,
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workload_networks_begin_delete_vm_group(self, resource_group):
        response = self.client.workload_networks.begin_delete_vm_group(
            resource_group_name=resource_group.name,
            vm_group_id="str",
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
