# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ContainerGroupInstanceCountSummary(_model_base.Model):
    """Displays the counts of container groups in each state, as known by the StandbyPool resource
    provider.


    :ivar instance_counts_by_state: The count of pooled resources in each state. Required.
    :vartype instance_counts_by_state: list[~azure.mgmt.standbypool.models.PoolResourceStateCount]
    """

    instance_counts_by_state: List["_models.PoolResourceStateCount"] = rest_field(name="instanceCountsByState")
    """The count of pooled resources in each state. Required."""

    @overload
    def __init__(
        self,
        *,
        instance_counts_by_state: List["_models.PoolResourceStateCount"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContainerGroupProfile(_model_base.Model):
    """Details of the ContainerGroupProfile.


    :ivar id: Specifies container group profile id of standby container groups. Required.
    :vartype id: str
    :ivar revision: Specifies revision of container group profile.
    :vartype revision: int
    """

    id: str = rest_field()
    """Specifies container group profile id of standby container groups. Required."""
    revision: Optional[int] = rest_field()
    """Specifies revision of container group profile."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        revision: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContainerGroupProperties(_model_base.Model):
    """Details of the ContainerGroupProperties.


    :ivar container_group_profile: Specifies container group profile of standby container groups.
     Required.
    :vartype container_group_profile: ~azure.mgmt.standbypool.models.ContainerGroupProfile
    :ivar subnet_ids: Specifies subnet Ids for container group.
    :vartype subnet_ids: list[~azure.mgmt.standbypool.models.Subnet]
    """

    container_group_profile: "_models.ContainerGroupProfile" = rest_field(name="containerGroupProfile")
    """Specifies container group profile of standby container groups. Required."""
    subnet_ids: Optional[List["_models.Subnet"]] = rest_field(name="subnetIds")
    """Specifies subnet Ids for container group."""

    @overload
    def __init__(
        self,
        *,
        container_group_profile: "_models.ContainerGroupProfile",
        subnet_ids: Optional[List["_models.Subnet"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.standbypool.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.standbypool.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.standbypool.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.standbypool.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.standbypool.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.standbypool.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PoolResourceStateCount(_model_base.Model):
    """Displays the counts of pooled resources in each state, as known by the StandbyPool resource
    provider.


    :ivar state: The state that the pooled resources count is for. Required.
    :vartype state: str
    :ivar count: The count of pooled resources in the given state. Required.
    :vartype count: int
    """

    state: str = rest_field()
    """The state that the pooled resources count is for. Required."""
    count: int = rest_field()
    """The count of pooled resources in the given state. Required."""

    @overload
    def __init__(
        self,
        *,
        state: str,
        count: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    """


class StandbyContainerGroupPoolElasticityProfile(_model_base.Model):  # pylint: disable=name-too-long
    """Specifies the elasticity profile of the standby container group pools.


    :ivar max_ready_capacity: Specifies maximum number of standby container groups in the standby
     pool. Required.
    :vartype max_ready_capacity: int
    :ivar refill_policy: Specifies refill policy of the pool. "always"
    :vartype refill_policy: str or ~azure.mgmt.standbypool.models.RefillPolicy
    """

    max_ready_capacity: int = rest_field(name="maxReadyCapacity")
    """Specifies maximum number of standby container groups in the standby pool. Required."""
    refill_policy: Optional[Union[str, "_models.RefillPolicy"]] = rest_field(name="refillPolicy")
    """Specifies refill policy of the pool. \"always\""""

    @overload
    def __init__(
        self,
        *,
        max_ready_capacity: int,
        refill_policy: Optional[Union[str, "_models.RefillPolicy"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResource(TrackedResource):
    """A StandbyContainerGroupPoolResource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceProperties
    """

    properties: Optional["_models.StandbyContainerGroupPoolResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyContainerGroupPoolResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Details of the StandbyContainerGroupPool.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar elasticity_profile: Specifies elasticity profile of standby container group pools.
     Required.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfile
    :ivar container_group_properties: Specifies container group properties of standby container
     group pools. Required.
    :vartype container_group_properties: ~azure.mgmt.standbypool.models.ContainerGroupProperties
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    elasticity_profile: "_models.StandbyContainerGroupPoolElasticityProfile" = rest_field(name="elasticityProfile")
    """Specifies elasticity profile of standby container group pools. Required."""
    container_group_properties: "_models.ContainerGroupProperties" = rest_field(name="containerGroupProperties")
    """Specifies container group properties of standby container group pools. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        elasticity_profile: "_models.StandbyContainerGroupPoolElasticityProfile",
        container_group_properties: "_models.ContainerGroupProperties",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResourceUpdate(_model_base.Model):
    """The type used for update operations of the StandbyContainerGroupPoolResource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.StandbyContainerGroupPoolResourceUpdateProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyContainerGroupPoolResourceUpdateProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResourceUpdateProperties(_model_base.Model):  # pylint: disable=name-too-long
    """The updatable properties of the StandbyContainerGroupPoolResource.

    :ivar elasticity_profile: Specifies elasticity profile of standby container group pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfile
    :ivar container_group_properties: Specifies container group properties of standby container
     group pools.
    :vartype container_group_properties: ~azure.mgmt.standbypool.models.ContainerGroupProperties
    """

    elasticity_profile: Optional["_models.StandbyContainerGroupPoolElasticityProfile"] = rest_field(
        name="elasticityProfile"
    )
    """Specifies elasticity profile of standby container group pools."""
    container_group_properties: Optional["_models.ContainerGroupProperties"] = rest_field(
        name="containerGroupProperties"
    )
    """Specifies container group properties of standby container group pools."""

    @overload
    def __init__(
        self,
        *,
        elasticity_profile: Optional["_models.StandbyContainerGroupPoolElasticityProfile"] = None,
        container_group_properties: Optional["_models.ContainerGroupProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolRuntimeViewResource(ProxyResource):  # pylint: disable=name-too-long
    """Contains information about a standby container group pool as last known by the StandbyPool
    resource provider.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolRuntimeViewResourceProperties
    """

    properties: Optional["_models.StandbyContainerGroupPoolRuntimeViewResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StandbyContainerGroupPoolRuntimeViewResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolRuntimeViewResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Contains information about a standby pool as last known by the StandbyPool resource provider.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar instance_count_summary: A list containing the counts of container groups in each possible
     state, as known by the StandbyPool resource provider. Required.
    :vartype instance_count_summary:
     list[~azure.mgmt.standbypool.models.ContainerGroupInstanceCountSummary]
    :ivar provisioning_state: Displays the provisioning state of the standby pool. Known values
     are: "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    instance_count_summary: List["_models.ContainerGroupInstanceCountSummary"] = rest_field(
        name="instanceCountSummary", visibility=["read"]
    )
    """A list containing the counts of container groups in each possible state, as known by the
     StandbyPool resource provider. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Displays the provisioning state of the standby pool. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", and \"Deleting\"."""


class StandbyVirtualMachinePoolElasticityProfile(_model_base.Model):  # pylint: disable=name-too-long
    """Details of the elasticity profile.


    :ivar max_ready_capacity: Specifies the maximum number of virtual machines in the standby
     virtual machine pool. Required.
    :vartype max_ready_capacity: int
    :ivar min_ready_capacity: Specifies the desired minimum number of virtual machines in the
     standby virtual machine pool. MinReadyCapacity cannot exceed MaxReadyCapacity.
    :vartype min_ready_capacity: int
    """

    max_ready_capacity: int = rest_field(name="maxReadyCapacity")
    """Specifies the maximum number of virtual machines in the standby virtual machine pool. Required."""
    min_ready_capacity: Optional[int] = rest_field(name="minReadyCapacity")
    """Specifies the desired minimum number of virtual machines in the standby virtual machine pool.
     MinReadyCapacity cannot exceed MaxReadyCapacity."""

    @overload
    def __init__(
        self,
        *,
        max_ready_capacity: int,
        min_ready_capacity: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResource(TrackedResource):
    """A StandbyVirtualMachinePoolResource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceProperties
    """

    properties: Optional["_models.StandbyVirtualMachinePoolResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyVirtualMachinePoolResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Details of the StandbyVirtualMachinePool.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar elasticity_profile: Specifies the elasticity profile of the standby virtual machine
     pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfile
    :ivar virtual_machine_state: Specifies the desired state of virtual machines in the pool.
     Required. Known values are: "Running" and "Deallocated".
    :vartype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
    :ivar attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
     virtual machine scale set the pool is attached to.
    :vartype attached_virtual_machine_scale_set_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = rest_field(
        name="elasticityProfile"
    )
    """Specifies the elasticity profile of the standby virtual machine pools."""
    virtual_machine_state: Union[str, "_models.VirtualMachineState"] = rest_field(name="virtualMachineState")
    """Specifies the desired state of virtual machines in the pool. Required. Known values are:
     \"Running\" and \"Deallocated\"."""
    attached_virtual_machine_scale_set_id: Optional[str] = rest_field(name="attachedVirtualMachineScaleSetId")
    """Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached
     to."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine_state: Union[str, "_models.VirtualMachineState"],
        elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = None,
        attached_virtual_machine_scale_set_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResourceUpdate(_model_base.Model):
    """The type used for update operations of the StandbyVirtualMachinePoolResource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.StandbyVirtualMachinePoolResourceUpdateProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyVirtualMachinePoolResourceUpdateProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResourceUpdateProperties(_model_base.Model):  # pylint: disable=name-too-long
    """The updatable properties of the StandbyVirtualMachinePoolResource.

    :ivar elasticity_profile: Specifies the elasticity profile of the standby virtual machine
     pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfile
    :ivar virtual_machine_state: Specifies the desired state of virtual machines in the pool. Known
     values are: "Running" and "Deallocated".
    :vartype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
    :ivar attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
     virtual machine scale set the pool is attached to.
    :vartype attached_virtual_machine_scale_set_id: str
    """

    elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = rest_field(
        name="elasticityProfile"
    )
    """Specifies the elasticity profile of the standby virtual machine pools."""
    virtual_machine_state: Optional[Union[str, "_models.VirtualMachineState"]] = rest_field(name="virtualMachineState")
    """Specifies the desired state of virtual machines in the pool. Known values are: \"Running\" and
     \"Deallocated\"."""
    attached_virtual_machine_scale_set_id: Optional[str] = rest_field(name="attachedVirtualMachineScaleSetId")
    """Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached
     to."""

    @overload
    def __init__(
        self,
        *,
        elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = None,
        virtual_machine_state: Optional[Union[str, "_models.VirtualMachineState"]] = None,
        attached_virtual_machine_scale_set_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolRuntimeViewResource(ProxyResource):  # pylint: disable=name-too-long
    """Contains information about a standby virtual machine pool as last known by the StandbyPool
    resource provider.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolRuntimeViewResourceProperties
    """

    properties: Optional["_models.StandbyVirtualMachinePoolRuntimeViewResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StandbyVirtualMachinePoolRuntimeViewResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolRuntimeViewResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Contains information about a standby pool as last known by the StandbyPool resource provider.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar instance_count_summary: A list containing the counts of virtual machines in each possible
     power state for each zone if enabled, as known by the StandbyPool resource provider.
     If zones are not enabled on the attached VMSS, the list will contain a single entry with null
     zone values.
     Note: any updates to pool resources outside of StandbyPoolRP (i.e deleting a VM through
     portal) are not reflected here.
     Note: any resources in the Running state may still be installing extensions / not fully
     provisioned. Required.
    :vartype instance_count_summary:
     list[~azure.mgmt.standbypool.models.VirtualMachineInstanceCountSummary]
    :ivar provisioning_state: Displays the provisioning state of the standby pool. Known values
     are: "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    instance_count_summary: List["_models.VirtualMachineInstanceCountSummary"] = rest_field(
        name="instanceCountSummary", visibility=["read"]
    )
    """A list containing the counts of virtual machines in each possible power state for each zone if
     enabled, as known by the StandbyPool resource provider.
     If zones are not enabled on the attached VMSS, the list will contain a single entry with null
     zone values.
     Note: any updates to pool resources outside of StandbyPoolRP (i.e deleting a VM through portal)
     are not reflected here.
     Note: any resources in the Running state may still be installing extensions / not fully
     provisioned. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Displays the provisioning state of the standby pool. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", and \"Deleting\"."""


class StandbyVirtualMachineResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachineResourceProperties
    """

    properties: Optional["_models.StandbyVirtualMachineResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StandbyVirtualMachineResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StandbyVirtualMachineResourceProperties(_model_base.Model):
    """Details of the StandbyVirtualMachine.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar virtual_machine_resource_id: Resource id of the virtual machine. Required.
    :vartype virtual_machine_resource_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    virtual_machine_resource_id: str = rest_field(name="virtualMachineResourceId")
    """Resource id of the virtual machine. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine_resource_id: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Subnet(_model_base.Model):
    """Subnet of container group.


    :ivar id: Specifies ARM resource id of the subnet. Required.
    :vartype id: str
    """

    id: str = rest_field()
    """Specifies ARM resource id of the subnet. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceCountSummary(_model_base.Model):
    """Contains the counts of VMs in each power state in a given zone, fault domain, as known by the
    StandbyPool resource provider.
    Note: any updates to pool resources outside of StandbyPoolRP (i.e deleting a VM through portal)
    are not reflected here.
    Note: any resources in the Running state may still be installing extensions / not fully
    provisioned.


    :ivar zone: The zone that the provided counts are in. This is null if zones are not enabled on
     the attached VMSS.
    :vartype zone: int
    :ivar instance_counts_by_state: The count of pooled resources in each state for the given zone.
     Required.
    :vartype instance_counts_by_state: list[~azure.mgmt.standbypool.models.PoolResourceStateCount]
    """

    zone: Optional[int] = rest_field()
    """The zone that the provided counts are in. This is null if zones are not enabled on the attached
     VMSS."""
    instance_counts_by_state: List["_models.PoolResourceStateCount"] = rest_field(name="instanceCountsByState")
    """The count of pooled resources in each state for the given zone. Required."""

    @overload
    def __init__(
        self,
        *,
        instance_counts_by_state: List["_models.PoolResourceStateCount"],
        zone: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
