# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._discovery_solution_nlp_operations import (
    build_discover_solutions_by_subscription_request,
    build_discover_solutions_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DiscoverySolutionNLPOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.selfhelp.aio.SelfHelpMgmtClient`'s
        :attr:`discovery_solution_nlp` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def discover_solutions(
        self,
        discover_solution_request: Optional[_models.DiscoveryNlpRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DiscoveryNlpResponse:
        """Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language
        issue summary.

        :param discover_solution_request: Request body for discovering solutions using NLP. Default
         value is None.
        :type discover_solution_request: ~azure.mgmt.selfhelp.models.DiscoveryNlpRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DiscoveryNlpResponse or the result of cls(response)
        :rtype: ~azure.mgmt.selfhelp.models.DiscoveryNlpResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def discover_solutions(
        self,
        discover_solution_request: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DiscoveryNlpResponse:
        """Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language
        issue summary.

        :param discover_solution_request: Request body for discovering solutions using NLP. Default
         value is None.
        :type discover_solution_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DiscoveryNlpResponse or the result of cls(response)
        :rtype: ~azure.mgmt.selfhelp.models.DiscoveryNlpResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def discover_solutions(
        self, discover_solution_request: Optional[Union[_models.DiscoveryNlpRequest, IO[bytes]]] = None, **kwargs: Any
    ) -> _models.DiscoveryNlpResponse:
        """Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language
        issue summary.

        :param discover_solution_request: Request body for discovering solutions using NLP. Is either a
         DiscoveryNlpRequest type or a IO[bytes] type. Default value is None.
        :type discover_solution_request: ~azure.mgmt.selfhelp.models.DiscoveryNlpRequest or IO[bytes]
        :return: DiscoveryNlpResponse or the result of cls(response)
        :rtype: ~azure.mgmt.selfhelp.models.DiscoveryNlpResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DiscoveryNlpResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(discover_solution_request, (IOBase, bytes)):
            _content = discover_solution_request
        else:
            if discover_solution_request is not None:
                _json = self._serialize.body(discover_solution_request, "DiscoveryNlpRequest")
            else:
                _json = None

        _request = build_discover_solutions_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DiscoveryNlpResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def discover_solutions_by_subscription(
        self,
        subscription_id: str,
        discover_solution_request: Optional[_models.DiscoveryNlpRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DiscoveryNlpResponse:
        """Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language
        issue summary and subscription.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param discover_solution_request: Request body for discovering solutions using NLP. Default
         value is None.
        :type discover_solution_request: ~azure.mgmt.selfhelp.models.DiscoveryNlpRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DiscoveryNlpResponse or the result of cls(response)
        :rtype: ~azure.mgmt.selfhelp.models.DiscoveryNlpResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def discover_solutions_by_subscription(
        self,
        subscription_id: str,
        discover_solution_request: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DiscoveryNlpResponse:
        """Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language
        issue summary and subscription.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param discover_solution_request: Request body for discovering solutions using NLP. Default
         value is None.
        :type discover_solution_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DiscoveryNlpResponse or the result of cls(response)
        :rtype: ~azure.mgmt.selfhelp.models.DiscoveryNlpResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def discover_solutions_by_subscription(
        self,
        subscription_id: str,
        discover_solution_request: Optional[Union[_models.DiscoveryNlpRequest, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.DiscoveryNlpResponse:
        """Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language
        issue summary and subscription.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param discover_solution_request: Request body for discovering solutions using NLP. Is either a
         DiscoveryNlpRequest type or a IO[bytes] type. Default value is None.
        :type discover_solution_request: ~azure.mgmt.selfhelp.models.DiscoveryNlpRequest or IO[bytes]
        :return: DiscoveryNlpResponse or the result of cls(response)
        :rtype: ~azure.mgmt.selfhelp.models.DiscoveryNlpResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DiscoveryNlpResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(discover_solution_request, (IOBase, bytes)):
            _content = discover_solution_request
        else:
            if discover_solution_request is not None:
                _json = self._serialize.body(discover_solution_request, "DiscoveryNlpRequest")
            else:
                _json = None

        _request = build_discover_solutions_by_subscription_request(
            subscription_id=subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DiscoveryNlpResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
