# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class DataflowType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    JSON = "Json"
    YAML = "Yaml"

class FieldType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    STRING = "String"
    BOOLEAN = "Boolean"
    INTEGER = "Integer"
    DECIMAL = "Decimal"
    DATE = "Date"
    UNKNOWN = "Unknown"
    ERROR = "Error"
    NULL = "Null"
    DATA_ROW = "DataRow"
    LIST = "List"
    STREAM = "Stream"

class HttpStatusCode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CONTINUE_ENUM = "Continue"
    SWITCHING_PROTOCOLS = "SwitchingProtocols"
    PROCESSING = "Processing"
    EARLY_HINTS = "EarlyHints"
    OK = "OK"
    CREATED = "Created"
    ACCEPTED = "Accepted"
    NON_AUTHORITATIVE_INFORMATION = "NonAuthoritativeInformation"
    NO_CONTENT = "NoContent"
    RESET_CONTENT = "ResetContent"
    PARTIAL_CONTENT = "PartialContent"
    MULTI_STATUS = "MultiStatus"
    ALREADY_REPORTED = "AlreadyReported"
    IM_USED = "IMUsed"
    AMBIGUOUS = "Ambiguous"
    MOVED = "Moved"
    REDIRECT = "Redirect"
    REDIRECT_METHOD = "RedirectMethod"
    NOT_MODIFIED = "NotModified"
    USE_PROXY = "UseProxy"
    UNUSED = "Unused"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"
    BAD_REQUEST = "BadRequest"
    UNAUTHORIZED = "Unauthorized"
    PAYMENT_REQUIRED = "PaymentRequired"
    FORBIDDEN = "Forbidden"
    NOT_FOUND = "NotFound"
    METHOD_NOT_ALLOWED = "MethodNotAllowed"
    NOT_ACCEPTABLE = "NotAcceptable"
    PROXY_AUTHENTICATION_REQUIRED = "ProxyAuthenticationRequired"
    REQUEST_TIMEOUT = "RequestTimeout"
    CONFLICT = "Conflict"
    GONE = "Gone"
    LENGTH_REQUIRED = "LengthRequired"
    PRECONDITION_FAILED = "PreconditionFailed"
    REQUEST_ENTITY_TOO_LARGE = "RequestEntityTooLarge"
    REQUEST_URI_TOO_LONG = "RequestUriTooLong"
    UNSUPPORTED_MEDIA_TYPE = "UnsupportedMediaType"
    REQUESTED_RANGE_NOT_SATISFIABLE = "RequestedRangeNotSatisfiable"
    EXPECTATION_FAILED = "ExpectationFailed"
    MISDIRECTED_REQUEST = "MisdirectedRequest"
    UNPROCESSABLE_ENTITY = "UnprocessableEntity"
    LOCKED = "Locked"
    FAILED_DEPENDENCY = "FailedDependency"
    UPGRADE_REQUIRED = "UpgradeRequired"
    PRECONDITION_REQUIRED = "PreconditionRequired"
    TOO_MANY_REQUESTS = "TooManyRequests"
    REQUEST_HEADER_FIELDS_TOO_LARGE = "RequestHeaderFieldsTooLarge"
    UNAVAILABLE_FOR_LEGAL_REASONS = "UnavailableForLegalReasons"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    NOT_IMPLEMENTED = "NotImplemented"
    BAD_GATEWAY = "BadGateway"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    GATEWAY_TIMEOUT = "GatewayTimeout"
    HTTP_VERSION_NOT_SUPPORTED = "HttpVersionNotSupported"
    VARIANT_ALSO_NEGOTIATES = "VariantAlsoNegotiates"
    INSUFFICIENT_STORAGE = "InsufficientStorage"
    LOOP_DETECTED = "LoopDetected"
    NOT_EXTENDED = "NotExtended"
    NETWORK_AUTHENTICATION_REQUIRED = "NetworkAuthenticationRequired"

class HttpVersionPolicy(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    REQUEST_VERSION_OR_LOWER = "RequestVersionOrLower"
    REQUEST_VERSION_OR_HIGHER = "RequestVersionOrHigher"
    REQUEST_VERSION_EXACT = "RequestVersionExact"

class StoredProcedureParameterType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    STRING = "String"
    INT = "Int"
    DECIMAL = "Decimal"
    GUID = "Guid"
    BOOLEAN = "Boolean"
    DATE = "Date"

class SType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    EMAIL_ADDRESS = "EmailAddress"
    GEOGRAPHIC_COORDINATE = "GeographicCoordinate"
    IPV4_ADDRESS = "Ipv4Address"
    IPV6_ADDRESS = "Ipv6Address"
    US_PHONE_NUMBER = "UsPhoneNumber"
    ZIP_CODE = "ZipCode"
