// SPDX-License-Identifier: LGPL-2.1-or-later
//
// SPDX-FileCopyrightText: 2013 Mohammed Nafees <nafees.technocool@gmail.com>
//

#include "KmlBottomFovTagHandler.h"

#include "GeoDataViewVolume.h"
#include "KmlElementDictionary.h"

namespace Marble
{
namespace kml
{
KML_DEFINE_TAG_HANDLER(bottomFov)

GeoNode *KmlbottomFovTagHandler::parse(GeoParser &parser) const
{
    Q_ASSERT(parser.isStartElement() && parser.isValidElement(QLatin1StringView(kmlTag_bottomFov)));

    GeoStackItem parentItem = parser.parentElement();

    if (parentItem.represents(kmlTag_ViewVolume)) {
        qreal bottomFov = parser.readElementText().toDouble();

        parentItem.nodeAs<GeoDataViewVolume>()->setBottomFov(bottomFov);
    }
    return nullptr;
}

}
}
