// license:GPL
// copyright-holders: dsp56300 <dsp56300@users.noreply.github.com>

// Generated file, use python utdsp563xx.py dsp563xx.lst dsp563xx.ipp to regenerate

const utdsp563xx_state::testblock utdsp563xx_state::testblocks[] = {
	{ "conditionCodes", 0, 72 },
	{ "aguModulo", 72, 78 },
	{ "aguMultiWrapModulo", 78, 591 },
	{ "aguBitreverse", 591, 597 },
	{ "x0x1Combinations", 597, 601 },
	{ "abs", 601, 602 },
	{ "add", 602, 607 },
	{ "addShortImmediate", 607, 608 },
	{ "addLongImmediate", 608, 609 },
	{ "addl", 609, 610 },
	{ "addr", 610, 612 },
	{ "and", 612, 613 },
	{ "andi", 613, 614 },
	{ "asl", 614, 618 },
	{ "asl_D", 618, 620 },
	{ "asl_ii", 620, 621 },
	{ "asl_S1S2D", 621, 622 },
	{ "asr", 622, 623 },
	{ "asr_D", 623, 624 },
	{ "asr_ii", 624, 626 },
	{ "asr_S1S2D", 626, 628 },
	{ "bchg_aa", 628, 630 },
	{ "bclr_ea", 630, 631 },
	{ "bclr_aa", 631, 632 },
	{ "bclr_qqpp", 632, 633 },
	{ "bclr_D", 633, 636 },
	{ "bset_aa", 636, 637 },
	{ "btst_aa", 637, 639 },
	{ "clb", 639, 643 },
	{ "clr", 643, 645 },
	{ "cmp", 645, 648 },
	{ "cmpm", 648, 649 },
	{ "dec", 649, 652 },
	{ "div", 652, 702 },
	{ "dmac", 702, 705 },
	{ "eor", 705, 707 },
	{ "extractu", 707, 712 },
	{ "extractu_co", 712, 713 },
	{ "ifcc", 713, 717 },
	{ "inc", 717, 719 },
	{ "insert", 719, 722 },
	{ "lra", 722, 723 },
	{ "lsl", 723, 727 },
	{ "lsr", 727, 731 },
	{ "lua_ea", 731, 733 },
	{ "lua_rn", 733, 736 },
	{ "mac", 736, 740 },
	{ "mac_S", 740, 741 },
	{ "max", 741, 747 },
	{ "maxm", 747, 755 },
	{ "mpy", 755, 762 },
	{ "mpyr", 762, 763 },
	{ "mpy_SD", 763, 764 },
	{ "neg", 764, 766 },
	{ "normf", 766, 767 },
	{ "not", 767, 769 },
	{ "or", 769, 772 },
	{ "ori", 772, 773 },
	{ "rnd", 773, 780 },
	{ "rol", 780, 783 },
	{ "sub", 783, 786 },
	{ "subl", 786, 790 },
	{ "tfr", 790, 791 },
	{ "tcc", 791, 797 },
	{ "move", 797, 849 },
	{ "movel", 849, 855 },
	{ "parallel", 855, 860 },
	{ nullptr, 0, 0 }
};

const utdsp563xx_state::testlist utdsp563xx_state::testlists[] = {
	{ 0, 2, 0, 3, 3, 4 },
	{ 2, 4, 4, 7, 7, 8 },
	{ 4, 6, 8, 11, 11, 12 },
	{ 6, 8, 12, 15, 15, 16 },
	{ 8, 10, 16, 19, 19, 20 },
	{ 10, 12, 20, 23, 23, 24 },
	{ 12, 14, 24, 27, 27, 28 },
	{ 14, 16, 28, 31, 31, 32 },
	{ 16, 18, 32, 35, 35, 36 },
	{ 18, 20, 36, 39, 39, 40 },
	{ 20, 22, 40, 43, 43, 44 },
	{ 22, 24, 44, 47, 47, 48 },
	{ 24, 26, 48, 51, 51, 52 },
	{ 26, 28, 52, 55, 55, 56 },
	{ 28, 30, 56, 59, 59, 60 },
	{ 30, 32, 60, 63, 63, 64 },
	{ 32, 34, 64, 67, 67, 68 },
	{ 34, 36, 68, 71, 71, 72 },
	{ 36, 38, 72, 75, 75, 76 },
	{ 38, 40, 76, 79, 79, 80 },
	{ 40, 42, 80, 83, 83, 84 },
	{ 42, 44, 84, 87, 87, 88 },
	{ 44, 46, 88, 91, 91, 92 },
	{ 46, 48, 92, 95, 95, 96 },
	{ 48, 50, 96, 99, 99, 100 },
	{ 50, 52, 100, 103, 103, 104 },
	{ 52, 54, 104, 107, 107, 108 },
	{ 54, 56, 108, 111, 111, 112 },
	{ 56, 58, 112, 115, 115, 116 },
	{ 58, 60, 116, 119, 119, 120 },
	{ 60, 62, 120, 123, 123, 124 },
	{ 62, 64, 124, 127, 127, 128 },
	{ 64, 66, 128, 131, 131, 132 },
	{ 66, 68, 132, 135, 135, 136 },
	{ 68, 70, 136, 139, 139, 140 },
	{ 70, 72, 140, 143, 143, 144 },
	{ 72, 74, 144, 147, 147, 148 },
	{ 74, 76, 148, 151, 151, 152 },
	{ 76, 78, 152, 155, 155, 156 },
	{ 78, 80, 156, 159, 159, 160 },
	{ 80, 82, 160, 163, 163, 164 },
	{ 82, 84, 164, 167, 167, 168 },
	{ 84, 86, 168, 171, 171, 172 },
	{ 86, 88, 172, 175, 175, 176 },
	{ 88, 90, 176, 179, 179, 180 },
	{ 90, 92, 180, 183, 183, 184 },
	{ 92, 94, 184, 187, 187, 188 },
	{ 94, 96, 188, 191, 191, 192 },
	{ 96, 98, 192, 195, 195, 196 },
	{ 98, 100, 196, 199, 199, 200 },
	{ 100, 102, 200, 203, 203, 204 },
	{ 102, 104, 204, 207, 207, 208 },
	{ 104, 106, 208, 211, 211, 212 },
	{ 106, 108, 212, 215, 215, 216 },
	{ 108, 110, 216, 219, 219, 220 },
	{ 110, 112, 220, 223, 223, 224 },
	{ 112, 114, 224, 227, 227, 228 },
	{ 114, 116, 228, 231, 231, 232 },
	{ 116, 118, 232, 235, 235, 236 },
	{ 118, 120, 236, 239, 239, 240 },
	{ 120, 122, 240, 243, 243, 244 },
	{ 122, 124, 244, 247, 247, 248 },
	{ 124, 126, 248, 251, 251, 252 },
	{ 126, 128, 252, 255, 255, 256 },
	{ 128, 130, 256, 259, 259, 260 },
	{ 130, 132, 260, 263, 263, 264 },
	{ 132, 134, 264, 267, 267, 268 },
	{ 134, 136, 268, 271, 271, 272 },
	{ 136, 138, 272, 275, 275, 276 },
	{ 138, 140, 276, 279, 279, 280 },
	{ 140, 142, 280, 283, 283, 284 },
	{ 142, 144, 284, 287, 287, 288 },
	{ 144, 145, 288, 291, 291, 292 },
	{ 145, 146, 292, 295, 295, 296 },
	{ 146, 147, 296, 299, 299, 300 },
	{ 147, 148, 300, 303, 303, 304 },
	{ 148, 149, 304, 307, 307, 308 },
	{ 149, 150, 308, 311, 311, 312 },
	{ 150, 155, 312, 325, 325, 330 },
	{ 155, 160, 330, 343, 343, 348 },
	{ 160, 165, 348, 361, 361, 366 },
	{ 165, 170, 366, 379, 379, 384 },
	{ 170, 175, 384, 397, 397, 402 },
	{ 175, 180, 402, 415, 415, 420 },
	{ 180, 185, 420, 433, 433, 438 },
	{ 185, 190, 438, 451, 451, 456 },
	{ 190, 195, 456, 469, 469, 474 },
	{ 195, 200, 474, 487, 487, 492 },
	{ 200, 205, 492, 505, 505, 510 },
	{ 205, 210, 510, 523, 523, 528 },
	{ 210, 215, 528, 541, 541, 546 },
	{ 215, 220, 546, 559, 559, 564 },
	{ 220, 225, 564, 577, 577, 582 },
	{ 225, 230, 582, 595, 595, 600 },
	{ 230, 235, 600, 613, 613, 618 },
	{ 235, 240, 618, 631, 631, 636 },
	{ 240, 245, 636, 649, 649, 654 },
	{ 245, 250, 654, 667, 667, 672 },
	{ 250, 255, 672, 685, 685, 690 },
	{ 255, 260, 690, 703, 703, 708 },
	{ 260, 265, 708, 721, 721, 726 },
	{ 265, 270, 726, 739, 739, 744 },
	{ 270, 275, 744, 757, 757, 762 },
	{ 275, 280, 762, 775, 775, 780 },
	{ 280, 285, 780, 793, 793, 798 },
	{ 285, 290, 798, 811, 811, 816 },
	{ 290, 295, 816, 829, 829, 834 },
	{ 295, 300, 834, 847, 847, 852 },
	{ 300, 305, 852, 865, 865, 870 },
	{ 305, 310, 870, 883, 883, 888 },
	{ 310, 315, 888, 901, 901, 906 },
	{ 315, 320, 906, 919, 919, 924 },
	{ 320, 325, 924, 937, 937, 942 },
	{ 325, 330, 942, 955, 955, 960 },
	{ 330, 335, 960, 973, 973, 978 },
	{ 335, 340, 978, 991, 991, 996 },
	{ 340, 345, 996, 1009, 1009, 1014 },
	{ 345, 350, 1014, 1027, 1027, 1032 },
	{ 350, 355, 1032, 1045, 1045, 1050 },
	{ 355, 360, 1050, 1063, 1063, 1068 },
	{ 360, 365, 1068, 1081, 1081, 1086 },
	{ 365, 370, 1086, 1099, 1099, 1104 },
	{ 370, 375, 1104, 1117, 1117, 1122 },
	{ 375, 380, 1122, 1135, 1135, 1140 },
	{ 380, 385, 1140, 1153, 1153, 1158 },
	{ 385, 390, 1158, 1171, 1171, 1176 },
	{ 390, 395, 1176, 1189, 1189, 1194 },
	{ 395, 400, 1194, 1207, 1207, 1212 },
	{ 400, 405, 1212, 1225, 1225, 1230 },
	{ 405, 410, 1230, 1243, 1243, 1248 },
	{ 410, 415, 1248, 1261, 1261, 1266 },
	{ 415, 420, 1266, 1279, 1279, 1284 },
	{ 420, 425, 1284, 1297, 1297, 1302 },
	{ 425, 430, 1302, 1315, 1315, 1320 },
	{ 430, 435, 1320, 1333, 1333, 1338 },
	{ 435, 440, 1338, 1351, 1351, 1356 },
	{ 440, 445, 1356, 1369, 1369, 1374 },
	{ 445, 450, 1374, 1387, 1387, 1392 },
	{ 450, 455, 1392, 1405, 1405, 1410 },
	{ 455, 460, 1410, 1423, 1423, 1428 },
	{ 460, 465, 1428, 1441, 1441, 1446 },
	{ 465, 470, 1446, 1459, 1459, 1464 },
	{ 470, 475, 1464, 1477, 1477, 1482 },
	{ 475, 480, 1482, 1495, 1495, 1500 },
	{ 480, 485, 1500, 1513, 1513, 1518 },
	{ 485, 490, 1518, 1531, 1531, 1536 },
	{ 490, 495, 1536, 1549, 1549, 1554 },
	{ 495, 500, 1554, 1567, 1567, 1572 },
	{ 500, 505, 1572, 1585, 1585, 1590 },
	{ 505, 510, 1590, 1603, 1603, 1608 },
	{ 510, 515, 1608, 1621, 1621, 1626 },
	{ 515, 520, 1626, 1639, 1639, 1644 },
	{ 520, 525, 1644, 1657, 1657, 1662 },
	{ 525, 530, 1662, 1675, 1675, 1680 },
	{ 530, 535, 1680, 1693, 1693, 1698 },
	{ 535, 540, 1698, 1711, 1711, 1716 },
	{ 540, 545, 1716, 1729, 1729, 1734 },
	{ 545, 550, 1734, 1747, 1747, 1752 },
	{ 550, 555, 1752, 1765, 1765, 1770 },
	{ 555, 560, 1770, 1783, 1783, 1788 },
	{ 560, 565, 1788, 1801, 1801, 1806 },
	{ 565, 570, 1806, 1819, 1819, 1824 },
	{ 570, 575, 1824, 1837, 1837, 1842 },
	{ 575, 580, 1842, 1855, 1855, 1860 },
	{ 580, 585, 1860, 1873, 1873, 1878 },
	{ 585, 590, 1878, 1891, 1891, 1896 },
	{ 590, 595, 1896, 1909, 1909, 1914 },
	{ 595, 600, 1914, 1927, 1927, 1932 },
	{ 600, 605, 1932, 1945, 1945, 1950 },
	{ 605, 610, 1950, 1963, 1963, 1968 },
	{ 610, 615, 1968, 1981, 1981, 1986 },
	{ 615, 620, 1986, 1999, 1999, 2004 },
	{ 620, 625, 2004, 2017, 2017, 2022 },
	{ 625, 630, 2022, 2035, 2035, 2040 },
	{ 630, 635, 2040, 2053, 2053, 2058 },
	{ 635, 640, 2058, 2071, 2071, 2076 },
	{ 640, 645, 2076, 2089, 2089, 2094 },
	{ 645, 650, 2094, 2107, 2107, 2112 },
	{ 650, 655, 2112, 2125, 2125, 2130 },
	{ 655, 660, 2130, 2143, 2143, 2148 },
	{ 660, 665, 2148, 2161, 2161, 2166 },
	{ 665, 670, 2166, 2179, 2179, 2184 },
	{ 670, 675, 2184, 2197, 2197, 2202 },
	{ 675, 680, 2202, 2215, 2215, 2220 },
	{ 680, 685, 2220, 2233, 2233, 2238 },
	{ 685, 690, 2238, 2251, 2251, 2256 },
	{ 690, 695, 2256, 2269, 2269, 2274 },
	{ 695, 700, 2274, 2287, 2287, 2292 },
	{ 700, 705, 2292, 2305, 2305, 2310 },
	{ 705, 710, 2310, 2323, 2323, 2328 },
	{ 710, 715, 2328, 2341, 2341, 2346 },
	{ 715, 720, 2346, 2359, 2359, 2364 },
	{ 720, 725, 2364, 2377, 2377, 2382 },
	{ 725, 730, 2382, 2395, 2395, 2400 },
	{ 730, 735, 2400, 2413, 2413, 2418 },
	{ 735, 740, 2418, 2431, 2431, 2436 },
	{ 740, 745, 2436, 2449, 2449, 2454 },
	{ 745, 750, 2454, 2467, 2467, 2472 },
	{ 750, 755, 2472, 2485, 2485, 2490 },
	{ 755, 760, 2490, 2503, 2503, 2508 },
	{ 760, 765, 2508, 2521, 2521, 2526 },
	{ 765, 770, 2526, 2539, 2539, 2544 },
	{ 770, 775, 2544, 2557, 2557, 2562 },
	{ 775, 780, 2562, 2575, 2575, 2580 },
	{ 780, 785, 2580, 2593, 2593, 2598 },
	{ 785, 790, 2598, 2611, 2611, 2616 },
	{ 790, 795, 2616, 2629, 2629, 2634 },
	{ 795, 800, 2634, 2647, 2647, 2652 },
	{ 800, 805, 2652, 2665, 2665, 2670 },
	{ 805, 810, 2670, 2683, 2683, 2688 },
	{ 810, 815, 2688, 2701, 2701, 2706 },
	{ 815, 820, 2706, 2719, 2719, 2724 },
	{ 820, 825, 2724, 2737, 2737, 2742 },
	{ 825, 830, 2742, 2755, 2755, 2760 },
	{ 830, 835, 2760, 2773, 2773, 2778 },
	{ 835, 840, 2778, 2791, 2791, 2796 },
	{ 840, 845, 2796, 2809, 2809, 2814 },
	{ 845, 850, 2814, 2827, 2827, 2832 },
	{ 850, 855, 2832, 2845, 2845, 2850 },
	{ 855, 860, 2850, 2863, 2863, 2868 },
	{ 860, 865, 2868, 2881, 2881, 2886 },
	{ 865, 870, 2886, 2899, 2899, 2904 },
	{ 870, 875, 2904, 2917, 2917, 2922 },
	{ 875, 880, 2922, 2935, 2935, 2940 },
	{ 880, 885, 2940, 2953, 2953, 2958 },
	{ 885, 890, 2958, 2971, 2971, 2976 },
	{ 890, 895, 2976, 2989, 2989, 2994 },
	{ 895, 900, 2994, 3007, 3007, 3012 },
	{ 900, 905, 3012, 3025, 3025, 3030 },
	{ 905, 910, 3030, 3043, 3043, 3048 },
	{ 910, 915, 3048, 3061, 3061, 3066 },
	{ 915, 920, 3066, 3079, 3079, 3084 },
	{ 920, 925, 3084, 3097, 3097, 3102 },
	{ 925, 930, 3102, 3115, 3115, 3120 },
	{ 930, 935, 3120, 3133, 3133, 3138 },
	{ 935, 940, 3138, 3151, 3151, 3156 },
	{ 940, 945, 3156, 3169, 3169, 3174 },
	{ 945, 950, 3174, 3187, 3187, 3192 },
	{ 950, 955, 3192, 3205, 3205, 3210 },
	{ 955, 960, 3210, 3223, 3223, 3228 },
	{ 960, 965, 3228, 3241, 3241, 3246 },
	{ 965, 970, 3246, 3259, 3259, 3264 },
	{ 970, 975, 3264, 3277, 3277, 3282 },
	{ 975, 980, 3282, 3295, 3295, 3300 },
	{ 980, 985, 3300, 3313, 3313, 3318 },
	{ 985, 990, 3318, 3331, 3331, 3336 },
	{ 990, 995, 3336, 3349, 3349, 3354 },
	{ 995, 1000, 3354, 3367, 3367, 3372 },
	{ 1000, 1005, 3372, 3385, 3385, 3390 },
	{ 1005, 1010, 3390, 3403, 3403, 3408 },
	{ 1010, 1015, 3408, 3421, 3421, 3426 },
	{ 1015, 1020, 3426, 3439, 3439, 3444 },
	{ 1020, 1025, 3444, 3457, 3457, 3462 },
	{ 1025, 1030, 3462, 3475, 3475, 3480 },
	{ 1030, 1035, 3480, 3493, 3493, 3498 },
	{ 1035, 1040, 3498, 3511, 3511, 3516 },
	{ 1040, 1045, 3516, 3529, 3529, 3534 },
	{ 1045, 1050, 3534, 3547, 3547, 3552 },
	{ 1050, 1055, 3552, 3565, 3565, 3570 },
	{ 1055, 1060, 3570, 3583, 3583, 3588 },
	{ 1060, 1065, 3588, 3601, 3601, 3606 },
	{ 1065, 1070, 3606, 3619, 3619, 3624 },
	{ 1070, 1075, 3624, 3637, 3637, 3642 },
	{ 1075, 1080, 3642, 3655, 3655, 3660 },
	{ 1080, 1085, 3660, 3673, 3673, 3678 },
	{ 1085, 1090, 3678, 3691, 3691, 3696 },
	{ 1090, 1095, 3696, 3709, 3709, 3714 },
	{ 1095, 1100, 3714, 3727, 3727, 3732 },
	{ 1100, 1105, 3732, 3745, 3745, 3750 },
	{ 1105, 1110, 3750, 3763, 3763, 3768 },
	{ 1110, 1115, 3768, 3781, 3781, 3786 },
	{ 1115, 1120, 3786, 3799, 3799, 3804 },
	{ 1120, 1125, 3804, 3817, 3817, 3822 },
	{ 1125, 1130, 3822, 3835, 3835, 3840 },
	{ 1130, 1135, 3840, 3853, 3853, 3858 },
	{ 1135, 1140, 3858, 3871, 3871, 3876 },
	{ 1140, 1145, 3876, 3889, 3889, 3894 },
	{ 1145, 1150, 3894, 3907, 3907, 3912 },
	{ 1150, 1155, 3912, 3925, 3925, 3930 },
	{ 1155, 1160, 3930, 3943, 3943, 3948 },
	{ 1160, 1165, 3948, 3961, 3961, 3966 },
	{ 1165, 1170, 3966, 3979, 3979, 3984 },
	{ 1170, 1175, 3984, 3997, 3997, 4002 },
	{ 1175, 1180, 4002, 4015, 4015, 4020 },
	{ 1180, 1185, 4020, 4033, 4033, 4038 },
	{ 1185, 1190, 4038, 4051, 4051, 4056 },
	{ 1190, 1195, 4056, 4069, 4069, 4074 },
	{ 1195, 1200, 4074, 4087, 4087, 4092 },
	{ 1200, 1205, 4092, 4105, 4105, 4110 },
	{ 1205, 1210, 4110, 4123, 4123, 4128 },
	{ 1210, 1215, 4128, 4141, 4141, 4146 },
	{ 1215, 1220, 4146, 4159, 4159, 4164 },
	{ 1220, 1225, 4164, 4177, 4177, 4182 },
	{ 1225, 1230, 4182, 4195, 4195, 4200 },
	{ 1230, 1235, 4200, 4213, 4213, 4218 },
	{ 1235, 1240, 4218, 4231, 4231, 4236 },
	{ 1240, 1245, 4236, 4249, 4249, 4254 },
	{ 1245, 1250, 4254, 4267, 4267, 4272 },
	{ 1250, 1255, 4272, 4285, 4285, 4290 },
	{ 1255, 1260, 4290, 4303, 4303, 4308 },
	{ 1260, 1265, 4308, 4321, 4321, 4326 },
	{ 1265, 1270, 4326, 4339, 4339, 4344 },
	{ 1270, 1275, 4344, 4357, 4357, 4362 },
	{ 1275, 1280, 4362, 4375, 4375, 4380 },
	{ 1280, 1285, 4380, 4393, 4393, 4398 },
	{ 1285, 1290, 4398, 4411, 4411, 4416 },
	{ 1290, 1295, 4416, 4429, 4429, 4434 },
	{ 1295, 1300, 4434, 4447, 4447, 4452 },
	{ 1300, 1305, 4452, 4465, 4465, 4470 },
	{ 1305, 1310, 4470, 4483, 4483, 4488 },
	{ 1310, 1315, 4488, 4501, 4501, 4506 },
	{ 1315, 1320, 4506, 4519, 4519, 4524 },
	{ 1320, 1325, 4524, 4537, 4537, 4542 },
	{ 1325, 1330, 4542, 4555, 4555, 4560 },
	{ 1330, 1335, 4560, 4573, 4573, 4578 },
	{ 1335, 1340, 4578, 4591, 4591, 4596 },
	{ 1340, 1345, 4596, 4609, 4609, 4614 },
	{ 1345, 1350, 4614, 4627, 4627, 4632 },
	{ 1350, 1355, 4632, 4645, 4645, 4650 },
	{ 1355, 1360, 4650, 4663, 4663, 4668 },
	{ 1360, 1365, 4668, 4681, 4681, 4686 },
	{ 1365, 1370, 4686, 4699, 4699, 4704 },
	{ 1370, 1375, 4704, 4717, 4717, 4722 },
	{ 1375, 1380, 4722, 4735, 4735, 4740 },
	{ 1380, 1385, 4740, 4753, 4753, 4758 },
	{ 1385, 1390, 4758, 4771, 4771, 4776 },
	{ 1390, 1395, 4776, 4789, 4789, 4794 },
	{ 1395, 1400, 4794, 4807, 4807, 4812 },
	{ 1400, 1405, 4812, 4825, 4825, 4830 },
	{ 1405, 1410, 4830, 4843, 4843, 4848 },
	{ 1410, 1415, 4848, 4861, 4861, 4866 },
	{ 1415, 1420, 4866, 4879, 4879, 4884 },
	{ 1420, 1425, 4884, 4897, 4897, 4902 },
	{ 1425, 1430, 4902, 4915, 4915, 4920 },
	{ 1430, 1435, 4920, 4933, 4933, 4938 },
	{ 1435, 1440, 4938, 4951, 4951, 4956 },
	{ 1440, 1445, 4956, 4969, 4969, 4974 },
	{ 1445, 1450, 4974, 4987, 4987, 4992 },
	{ 1450, 1455, 4992, 5005, 5005, 5010 },
	{ 1455, 1460, 5010, 5023, 5023, 5028 },
	{ 1460, 1465, 5028, 5041, 5041, 5046 },
	{ 1465, 1470, 5046, 5059, 5059, 5064 },
	{ 1470, 1475, 5064, 5077, 5077, 5082 },
	{ 1475, 1480, 5082, 5095, 5095, 5100 },
	{ 1480, 1485, 5100, 5113, 5113, 5118 },
	{ 1485, 1490, 5118, 5131, 5131, 5136 },
	{ 1490, 1495, 5136, 5149, 5149, 5154 },
	{ 1495, 1500, 5154, 5167, 5167, 5172 },
	{ 1500, 1505, 5172, 5185, 5185, 5190 },
	{ 1505, 1510, 5190, 5203, 5203, 5208 },
	{ 1510, 1515, 5208, 5221, 5221, 5226 },
	{ 1515, 1520, 5226, 5239, 5239, 5244 },
	{ 1520, 1525, 5244, 5257, 5257, 5262 },
	{ 1525, 1530, 5262, 5275, 5275, 5280 },
	{ 1530, 1535, 5280, 5293, 5293, 5298 },
	{ 1535, 1540, 5298, 5311, 5311, 5316 },
	{ 1540, 1545, 5316, 5329, 5329, 5334 },
	{ 1545, 1550, 5334, 5347, 5347, 5352 },
	{ 1550, 1555, 5352, 5365, 5365, 5370 },
	{ 1555, 1560, 5370, 5383, 5383, 5388 },
	{ 1560, 1565, 5388, 5401, 5401, 5406 },
	{ 1565, 1570, 5406, 5419, 5419, 5424 },
	{ 1570, 1575, 5424, 5437, 5437, 5442 },
	{ 1575, 1580, 5442, 5455, 5455, 5460 },
	{ 1580, 1585, 5460, 5473, 5473, 5478 },
	{ 1585, 1590, 5478, 5491, 5491, 5496 },
	{ 1590, 1595, 5496, 5509, 5509, 5514 },
	{ 1595, 1600, 5514, 5527, 5527, 5532 },
	{ 1600, 1605, 5532, 5545, 5545, 5550 },
	{ 1605, 1610, 5550, 5563, 5563, 5568 },
	{ 1610, 1615, 5568, 5581, 5581, 5586 },
	{ 1615, 1620, 5586, 5599, 5599, 5604 },
	{ 1620, 1625, 5604, 5617, 5617, 5622 },
	{ 1625, 1630, 5622, 5635, 5635, 5640 },
	{ 1630, 1635, 5640, 5653, 5653, 5658 },
	{ 1635, 1640, 5658, 5671, 5671, 5676 },
	{ 1640, 1645, 5676, 5689, 5689, 5694 },
	{ 1645, 1650, 5694, 5707, 5707, 5712 },
	{ 1650, 1655, 5712, 5725, 5725, 5730 },
	{ 1655, 1660, 5730, 5743, 5743, 5748 },
	{ 1660, 1665, 5748, 5761, 5761, 5766 },
	{ 1665, 1670, 5766, 5779, 5779, 5784 },
	{ 1670, 1675, 5784, 5797, 5797, 5802 },
	{ 1675, 1680, 5802, 5815, 5815, 5820 },
	{ 1680, 1685, 5820, 5833, 5833, 5838 },
	{ 1685, 1690, 5838, 5851, 5851, 5856 },
	{ 1690, 1695, 5856, 5869, 5869, 5874 },
	{ 1695, 1700, 5874, 5887, 5887, 5892 },
	{ 1700, 1705, 5892, 5905, 5905, 5910 },
	{ 1705, 1710, 5910, 5923, 5923, 5928 },
	{ 1710, 1715, 5928, 5941, 5941, 5946 },
	{ 1715, 1720, 5946, 5959, 5959, 5964 },
	{ 1720, 1725, 5964, 5977, 5977, 5982 },
	{ 1725, 1730, 5982, 5995, 5995, 6000 },
	{ 1730, 1735, 6000, 6013, 6013, 6018 },
	{ 1735, 1740, 6018, 6031, 6031, 6036 },
	{ 1740, 1745, 6036, 6049, 6049, 6054 },
	{ 1745, 1750, 6054, 6067, 6067, 6072 },
	{ 1750, 1755, 6072, 6085, 6085, 6090 },
	{ 1755, 1760, 6090, 6103, 6103, 6108 },
	{ 1760, 1765, 6108, 6121, 6121, 6126 },
	{ 1765, 1770, 6126, 6139, 6139, 6144 },
	{ 1770, 1775, 6144, 6157, 6157, 6162 },
	{ 1775, 1780, 6162, 6175, 6175, 6180 },
	{ 1780, 1785, 6180, 6193, 6193, 6198 },
	{ 1785, 1790, 6198, 6211, 6211, 6216 },
	{ 1790, 1795, 6216, 6229, 6229, 6234 },
	{ 1795, 1800, 6234, 6247, 6247, 6252 },
	{ 1800, 1805, 6252, 6265, 6265, 6270 },
	{ 1805, 1810, 6270, 6283, 6283, 6288 },
	{ 1810, 1815, 6288, 6301, 6301, 6306 },
	{ 1815, 1820, 6306, 6319, 6319, 6324 },
	{ 1820, 1825, 6324, 6337, 6337, 6342 },
	{ 1825, 1830, 6342, 6355, 6355, 6360 },
	{ 1830, 1835, 6360, 6373, 6373, 6378 },
	{ 1835, 1840, 6378, 6391, 6391, 6396 },
	{ 1840, 1845, 6396, 6409, 6409, 6414 },
	{ 1845, 1850, 6414, 6427, 6427, 6432 },
	{ 1850, 1855, 6432, 6445, 6445, 6450 },
	{ 1855, 1860, 6450, 6463, 6463, 6468 },
	{ 1860, 1865, 6468, 6481, 6481, 6486 },
	{ 1865, 1870, 6486, 6499, 6499, 6504 },
	{ 1870, 1875, 6504, 6517, 6517, 6522 },
	{ 1875, 1880, 6522, 6535, 6535, 6540 },
	{ 1880, 1885, 6540, 6553, 6553, 6558 },
	{ 1885, 1890, 6558, 6571, 6571, 6576 },
	{ 1890, 1895, 6576, 6589, 6589, 6594 },
	{ 1895, 1900, 6594, 6607, 6607, 6612 },
	{ 1900, 1905, 6612, 6625, 6625, 6630 },
	{ 1905, 1910, 6630, 6643, 6643, 6648 },
	{ 1910, 1915, 6648, 6661, 6661, 6666 },
	{ 1915, 1920, 6666, 6679, 6679, 6684 },
	{ 1920, 1925, 6684, 6697, 6697, 6702 },
	{ 1925, 1930, 6702, 6715, 6715, 6720 },
	{ 1930, 1935, 6720, 6733, 6733, 6738 },
	{ 1935, 1940, 6738, 6751, 6751, 6756 },
	{ 1940, 1945, 6756, 6769, 6769, 6774 },
	{ 1945, 1950, 6774, 6787, 6787, 6792 },
	{ 1950, 1955, 6792, 6805, 6805, 6810 },
	{ 1955, 1960, 6810, 6823, 6823, 6828 },
	{ 1960, 1965, 6828, 6841, 6841, 6846 },
	{ 1965, 1970, 6846, 6859, 6859, 6864 },
	{ 1970, 1975, 6864, 6877, 6877, 6882 },
	{ 1975, 1980, 6882, 6895, 6895, 6900 },
	{ 1980, 1985, 6900, 6913, 6913, 6918 },
	{ 1985, 1990, 6918, 6931, 6931, 6936 },
	{ 1990, 1995, 6936, 6949, 6949, 6954 },
	{ 1995, 2000, 6954, 6967, 6967, 6972 },
	{ 2000, 2005, 6972, 6985, 6985, 6990 },
	{ 2005, 2010, 6990, 7003, 7003, 7008 },
	{ 2010, 2015, 7008, 7021, 7021, 7026 },
	{ 2015, 2020, 7026, 7039, 7039, 7044 },
	{ 2020, 2025, 7044, 7057, 7057, 7062 },
	{ 2025, 2030, 7062, 7075, 7075, 7080 },
	{ 2030, 2035, 7080, 7093, 7093, 7098 },
	{ 2035, 2040, 7098, 7111, 7111, 7116 },
	{ 2040, 2045, 7116, 7129, 7129, 7134 },
	{ 2045, 2050, 7134, 7147, 7147, 7152 },
	{ 2050, 2055, 7152, 7165, 7165, 7170 },
	{ 2055, 2060, 7170, 7183, 7183, 7188 },
	{ 2060, 2065, 7188, 7201, 7201, 7206 },
	{ 2065, 2070, 7206, 7219, 7219, 7224 },
	{ 2070, 2075, 7224, 7237, 7237, 7242 },
	{ 2075, 2080, 7242, 7255, 7255, 7260 },
	{ 2080, 2085, 7260, 7273, 7273, 7278 },
	{ 2085, 2090, 7278, 7291, 7291, 7296 },
	{ 2090, 2095, 7296, 7309, 7309, 7314 },
	{ 2095, 2100, 7314, 7327, 7327, 7332 },
	{ 2100, 2105, 7332, 7345, 7345, 7350 },
	{ 2105, 2110, 7350, 7363, 7363, 7368 },
	{ 2110, 2115, 7368, 7381, 7381, 7386 },
	{ 2115, 2120, 7386, 7399, 7399, 7404 },
	{ 2120, 2125, 7404, 7417, 7417, 7422 },
	{ 2125, 2130, 7422, 7435, 7435, 7440 },
	{ 2130, 2135, 7440, 7453, 7453, 7458 },
	{ 2135, 2140, 7458, 7471, 7471, 7476 },
	{ 2140, 2145, 7476, 7489, 7489, 7494 },
	{ 2145, 2150, 7494, 7507, 7507, 7512 },
	{ 2150, 2155, 7512, 7525, 7525, 7530 },
	{ 2155, 2160, 7530, 7543, 7543, 7548 },
	{ 2160, 2165, 7548, 7561, 7561, 7566 },
	{ 2165, 2170, 7566, 7579, 7579, 7584 },
	{ 2170, 2175, 7584, 7597, 7597, 7602 },
	{ 2175, 2180, 7602, 7615, 7615, 7620 },
	{ 2180, 2185, 7620, 7633, 7633, 7638 },
	{ 2185, 2190, 7638, 7651, 7651, 7656 },
	{ 2190, 2195, 7656, 7669, 7669, 7674 },
	{ 2195, 2200, 7674, 7687, 7687, 7692 },
	{ 2200, 2205, 7692, 7705, 7705, 7710 },
	{ 2205, 2210, 7710, 7723, 7723, 7728 },
	{ 2210, 2215, 7728, 7741, 7741, 7746 },
	{ 2215, 2220, 7746, 7759, 7759, 7764 },
	{ 2220, 2225, 7764, 7777, 7777, 7782 },
	{ 2225, 2230, 7782, 7795, 7795, 7800 },
	{ 2230, 2235, 7800, 7813, 7813, 7818 },
	{ 2235, 2240, 7818, 7831, 7831, 7836 },
	{ 2240, 2245, 7836, 7849, 7849, 7854 },
	{ 2245, 2250, 7854, 7867, 7867, 7872 },
	{ 2250, 2255, 7872, 7885, 7885, 7890 },
	{ 2255, 2260, 7890, 7903, 7903, 7908 },
	{ 2260, 2265, 7908, 7921, 7921, 7926 },
	{ 2265, 2270, 7926, 7939, 7939, 7944 },
	{ 2270, 2275, 7944, 7957, 7957, 7962 },
	{ 2275, 2280, 7962, 7975, 7975, 7980 },
	{ 2280, 2285, 7980, 7993, 7993, 7998 },
	{ 2285, 2290, 7998, 8011, 8011, 8016 },
	{ 2290, 2295, 8016, 8029, 8029, 8034 },
	{ 2295, 2300, 8034, 8047, 8047, 8052 },
	{ 2300, 2305, 8052, 8065, 8065, 8070 },
	{ 2305, 2310, 8070, 8083, 8083, 8088 },
	{ 2310, 2315, 8088, 8101, 8101, 8106 },
	{ 2315, 2320, 8106, 8119, 8119, 8124 },
	{ 2320, 2325, 8124, 8137, 8137, 8142 },
	{ 2325, 2330, 8142, 8155, 8155, 8160 },
	{ 2330, 2335, 8160, 8173, 8173, 8178 },
	{ 2335, 2340, 8178, 8191, 8191, 8196 },
	{ 2340, 2345, 8196, 8209, 8209, 8214 },
	{ 2345, 2350, 8214, 8227, 8227, 8232 },
	{ 2350, 2355, 8232, 8245, 8245, 8250 },
	{ 2355, 2360, 8250, 8263, 8263, 8268 },
	{ 2360, 2365, 8268, 8281, 8281, 8286 },
	{ 2365, 2370, 8286, 8299, 8299, 8304 },
	{ 2370, 2375, 8304, 8317, 8317, 8322 },
	{ 2375, 2380, 8322, 8335, 8335, 8340 },
	{ 2380, 2385, 8340, 8353, 8353, 8358 },
	{ 2385, 2390, 8358, 8371, 8371, 8376 },
	{ 2390, 2395, 8376, 8389, 8389, 8394 },
	{ 2395, 2400, 8394, 8407, 8407, 8412 },
	{ 2400, 2405, 8412, 8425, 8425, 8430 },
	{ 2405, 2410, 8430, 8443, 8443, 8448 },
	{ 2410, 2415, 8448, 8461, 8461, 8466 },
	{ 2415, 2420, 8466, 8479, 8479, 8484 },
	{ 2420, 2425, 8484, 8497, 8497, 8502 },
	{ 2425, 2430, 8502, 8515, 8515, 8520 },
	{ 2430, 2435, 8520, 8533, 8533, 8538 },
	{ 2435, 2440, 8538, 8551, 8551, 8556 },
	{ 2440, 2445, 8556, 8569, 8569, 8574 },
	{ 2445, 2450, 8574, 8587, 8587, 8592 },
	{ 2450, 2455, 8592, 8605, 8605, 8610 },
	{ 2455, 2460, 8610, 8623, 8623, 8628 },
	{ 2460, 2465, 8628, 8641, 8641, 8646 },
	{ 2465, 2470, 8646, 8659, 8659, 8664 },
	{ 2470, 2475, 8664, 8677, 8677, 8682 },
	{ 2475, 2480, 8682, 8695, 8695, 8700 },
	{ 2480, 2485, 8700, 8713, 8713, 8718 },
	{ 2485, 2490, 8718, 8731, 8731, 8736 },
	{ 2490, 2495, 8736, 8749, 8749, 8754 },
	{ 2495, 2500, 8754, 8767, 8767, 8772 },
	{ 2500, 2505, 8772, 8785, 8785, 8790 },
	{ 2505, 2510, 8790, 8803, 8803, 8808 },
	{ 2510, 2515, 8808, 8821, 8821, 8826 },
	{ 2515, 2520, 8826, 8839, 8839, 8844 },
	{ 2520, 2525, 8844, 8857, 8857, 8862 },
	{ 2525, 2530, 8862, 8875, 8875, 8880 },
	{ 2530, 2535, 8880, 8893, 8893, 8898 },
	{ 2535, 2540, 8898, 8911, 8911, 8916 },
	{ 2540, 2545, 8916, 8929, 8929, 8934 },
	{ 2545, 2550, 8934, 8947, 8947, 8952 },
	{ 2550, 2555, 8952, 8965, 8965, 8970 },
	{ 2555, 2560, 8970, 8983, 8983, 8988 },
	{ 2560, 2565, 8988, 9001, 9001, 9006 },
	{ 2565, 2570, 9006, 9019, 9019, 9024 },
	{ 2570, 2575, 9024, 9037, 9037, 9042 },
	{ 2575, 2580, 9042, 9055, 9055, 9060 },
	{ 2580, 2585, 9060, 9073, 9073, 9078 },
	{ 2585, 2590, 9078, 9091, 9091, 9096 },
	{ 2590, 2595, 9096, 9109, 9109, 9114 },
	{ 2595, 2600, 9114, 9127, 9127, 9132 },
	{ 2600, 2605, 9132, 9145, 9145, 9150 },
	{ 2605, 2610, 9150, 9163, 9163, 9168 },
	{ 2610, 2615, 9168, 9181, 9181, 9186 },
	{ 2615, 2620, 9186, 9199, 9199, 9204 },
	{ 2620, 2625, 9204, 9217, 9217, 9222 },
	{ 2625, 2630, 9222, 9235, 9235, 9240 },
	{ 2630, 2635, 9240, 9253, 9253, 9258 },
	{ 2635, 2640, 9258, 9271, 9271, 9276 },
	{ 2640, 2645, 9276, 9289, 9289, 9294 },
	{ 2645, 2650, 9294, 9307, 9307, 9312 },
	{ 2650, 2655, 9312, 9325, 9325, 9330 },
	{ 2655, 2660, 9330, 9343, 9343, 9348 },
	{ 2660, 2665, 9348, 9361, 9361, 9366 },
	{ 2665, 2670, 9366, 9379, 9379, 9384 },
	{ 2670, 2675, 9384, 9397, 9397, 9402 },
	{ 2675, 2680, 9402, 9415, 9415, 9420 },
	{ 2680, 2685, 9420, 9433, 9433, 9438 },
	{ 2685, 2690, 9438, 9451, 9451, 9456 },
	{ 2690, 2695, 9456, 9469, 9469, 9474 },
	{ 2695, 2700, 9474, 9487, 9487, 9492 },
	{ 2700, 2705, 9492, 9505, 9505, 9510 },
	{ 2705, 2710, 9510, 9523, 9523, 9528 },
	{ 2710, 2712, 9528, 9534, 9534, 9536 },
	{ 2712, 2713, 9536, 9539, 9539, 9540 },
	{ 2713, 2714, 9540, 9543, 9543, 9544 },
	{ 2714, 2715, 9544, 9547, 9547, 9548 },
	{ 2715, 2716, 9548, 9551, 9551, 9552 },
	{ 2716, 2717, 9552, 9555, 9555, 9556 },
	{ 2717, 2718, 9556, 9559, 9559, 9560 },
	{ 2718, 2720, 9560, 9564, 9564, 9566 },
	{ 2720, 2724, 9566, 9570, 9570, 9572 },
	{ 2724, 2728, 9572, 9576, 9576, 9578 },
	{ 2728, 2734, 9578, 9584, 9584, 9586 },
	{ 2734, 2736, 9586, 9588, 9588, 9590 },
	{ 2736, 2737, 9590, 9592, 9592, 9596 },
	{ 2737, 2738, 9596, 9598, 9598, 9599 },
	{ 2738, 2739, 9599, 9601, 9601, 9602 },
	{ 2739, 2740, 9602, 9604, 9604, 9605 },
	{ 2740, 2741, 9605, 9607, 9607, 9610 },
	{ 2741, 2742, 9610, 9611, 9611, 9615 },
	{ 2742, 2744, 9615, 9616, 9616, 9620 },
	{ 2744, 2745, 9620, 9622, 9622, 9626 },
	{ 2745, 2746, 9626, 9629, 9629, 9631 },
	{ 2746, 2747, 9631, 9634, 9634, 9636 },
	{ 2747, 2749, 9636, 9640, 9640, 9642 },
	{ 2749, 2753, 9642, 9645, 9645, 9647 },
	{ 2753, 2754, 9647, 9648, 9648, 9649 },
	{ 2754, 2755, 9649, 9650, 9650, 9651 },
	{ 2755, 2756, 9651, 9652, 9652, 9653 },
	{ 2756, 2757, 9653, 9655, 9655, 9657 },
	{ 2757, 2758, 9657, 9659, 9659, 9663 },
	{ 2758, 2759, 9663, 9665, 9665, 9669 },
	{ 2759, 2760, 9669, 9671, 9671, 9675 },
	{ 2760, 2761, 9675, 9681, 9681, 9683 },
	{ 2761, 2762, 9683, 9684, 9684, 9685 },
	{ 2762, 2763, 9685, 9687, 9687, 9688 },
	{ 2763, 2764, 9688, 9689, 9689, 9690 },
	{ 2764, 2765, 9690, 9691, 9691, 9692 },
	{ 2765, 2767, 9692, 9698, 9698, 9700 },
	{ 2767, 2768, 9700, 9704, 9704, 9706 },
	{ 2768, 2769, 9706, 9707, 9707, 9709 },
	{ 2769, 2770, 9709, 9710, 9710, 9712 },
	{ 2770, 2772, 9712, 9720, 9720, 9722 },
	{ 2772, 2774, 9722, 9724, 9724, 9726 },
	{ 2774, 2776, 9726, 9728, 9728, 9730 },
	{ 2776, 2777, 9730, 9732, 9732, 9734 },
	{ 2777, 2778, 9734, 9736, 9736, 9738 },
	{ 2778, 2779, 9738, 9739, 9739, 9741 },
	{ 2779, 2781, 9741, 9743, 9743, 9745 },
	{ 2781, 2782, 9745, 9746, 9746, 9747 },
	{ 2782, 2783, 9747, 9748, 9748, 9749 },
	{ 2783, 2784, 9749, 9751, 9751, 9752 },
	{ 2784, 2785, 9752, 9754, 9754, 9755 },
	{ 2785, 2786, 9755, 9757, 9757, 9758 },
	{ 2786, 2787, 9758, 9760, 9760, 9761 },
	{ 2787, 2789, 9761, 9764, 9764, 9771 },
	{ 2789, 2790, 9771, 9772, 9772, 9773 },
	{ 2790, 2791, 9773, 9777, 9777, 9782 },
	{ 2791, 2792, 9782, 9785, 9785, 9786 },
	{ 2792, 2794, 9786, 9788, 9788, 9789 },
	{ 2794, 2795, 9789, 9792, 9792, 9793 },
	{ 2795, 2796, 9793, 9794, 9794, 9800 },
	{ 2796, 2797, 9800, 9801, 9801, 9807 },
	{ 2797, 2798, 9807, 9808, 9808, 9814 },
	{ 2798, 2799, 9814, 9816, 9816, 9817 },
	{ 2799, 2801, 9817, 9819, 9819, 9820 },
	{ 2801, 2804, 9820, 9822, 9822, 9823 },
	{ 2804, 2808, 9823, 9825, 9825, 9826 },
	{ 2808, 2813, 9826, 9828, 9828, 9829 },
	{ 2813, 2819, 9829, 9831, 9831, 9832 },
	{ 2819, 2826, 9832, 9834, 9834, 9835 },
	{ 2826, 2834, 9835, 9837, 9837, 9838 },
	{ 2834, 2843, 9838, 9840, 9840, 9841 },
	{ 2843, 2853, 9841, 9843, 9843, 9844 },
	{ 2853, 2864, 9844, 9846, 9846, 9847 },
	{ 2864, 2876, 9847, 9849, 9849, 9850 },
	{ 2876, 2889, 9850, 9852, 9852, 9853 },
	{ 2889, 2903, 9853, 9855, 9855, 9856 },
	{ 2903, 2918, 9856, 9858, 9858, 9859 },
	{ 2918, 2934, 9859, 9861, 9861, 9862 },
	{ 2934, 2951, 9862, 9864, 9864, 9865 },
	{ 2951, 2969, 9865, 9867, 9867, 9868 },
	{ 2969, 2988, 9868, 9870, 9870, 9871 },
	{ 2988, 3008, 9871, 9873, 9873, 9874 },
	{ 3008, 3029, 9874, 9876, 9876, 9877 },
	{ 3029, 3051, 9877, 9879, 9879, 9880 },
	{ 3051, 3074, 9880, 9882, 9882, 9883 },
	{ 3074, 3098, 9883, 9885, 9885, 9886 },
	{ 3098, 3123, 9886, 9888, 9888, 9889 },
	{ 3123, 3124, 9889, 9891, 9891, 9892 },
	{ 3124, 3126, 9892, 9894, 9894, 9895 },
	{ 3126, 3129, 9895, 9897, 9897, 9898 },
	{ 3129, 3133, 9898, 9900, 9900, 9901 },
	{ 3133, 3138, 9901, 9903, 9903, 9904 },
	{ 3138, 3144, 9904, 9906, 9906, 9907 },
	{ 3144, 3151, 9907, 9909, 9909, 9910 },
	{ 3151, 3159, 9910, 9912, 9912, 9913 },
	{ 3159, 3168, 9913, 9915, 9915, 9916 },
	{ 3168, 3178, 9916, 9918, 9918, 9919 },
	{ 3178, 3189, 9919, 9921, 9921, 9922 },
	{ 3189, 3201, 9922, 9924, 9924, 9925 },
	{ 3201, 3214, 9925, 9927, 9927, 9928 },
	{ 3214, 3228, 9928, 9930, 9930, 9931 },
	{ 3228, 3243, 9931, 9933, 9933, 9934 },
	{ 3243, 3259, 9934, 9936, 9936, 9937 },
	{ 3259, 3276, 9937, 9939, 9939, 9940 },
	{ 3276, 3294, 9940, 9942, 9942, 9943 },
	{ 3294, 3313, 9943, 9945, 9945, 9946 },
	{ 3313, 3333, 9946, 9948, 9948, 9949 },
	{ 3333, 3354, 9949, 9951, 9951, 9952 },
	{ 3354, 3376, 9952, 9954, 9954, 9955 },
	{ 3376, 3399, 9955, 9957, 9957, 9958 },
	{ 3399, 3423, 9958, 9960, 9960, 9961 },
	{ 3423, 3424, 9961, 9964, 9964, 9966 },
	{ 3424, 3425, 9966, 9969, 9969, 9970 },
	{ 3425, 3426, 9970, 9973, 9973, 9974 },
	{ 3426, 3427, 9974, 9977, 9977, 9978 },
	{ 3427, 3428, 9978, 9980, 9980, 9981 },
	{ 3428, 3429, 9981, 9983, 9983, 9984 },
	{ 3429, 3430, 9984, 9987, 9987, 9988 },
	{ 3430, 3432, 9988, 9991, 9991, 9993 },
	{ 3432, 3433, 9993, 9995, 9995, 9996 },
	{ 3433, 3435, 9996, 9998, 9998, 9999 },
	{ 3435, 3437, 9999, 10002, 10002, 10003 },
	{ 3437, 3439, 10003, 10004, 10004, 10005 },
	{ 3439, 3440, 10005, 10008, 10008, 10009 },
	{ 3440, 3441, 10009, 10012, 10012, 10013 },
	{ 3441, 3443, 10013, 10017, 10017, 10019 },
	{ 3443, 3445, 10019, 10023, 10023, 10025 },
	{ 3445, 3446, 10025, 10026, 10026, 10032 },
	{ 3446, 3447, 10032, 10033, 10033, 10039 },
	{ 3447, 3449, 10039, 10041, 10041, 10042 },
	{ 3449, 3450, 10042, 10045, 10045, 10046 },
	{ 3450, 3451, 10046, 10051, 10051, 10052 },
	{ 3451, 3454, 10052, 10053, 10053, 10054 },
	{ 3454, 3455, 10054, 10055, 10055, 10057 },
	{ 3455, 3456, 10057, 10058, 10058, 10060 },
	{ 3456, 3457, 10060, 10062, 10062, 10063 },
	{ 3457, 3458, 10063, 10065, 10065, 10066 },
	{ 3458, 3459, 10066, 10067, 10067, 10069 },
	{ 3459, 3460, 10069, 10070, 10070, 10072 },
	{ 3460, 3461, 10072, 10074, 10074, 10075 },
	{ 3461, 3462, 10075, 10077, 10077, 10078 },
	{ 3462, 3463, 10078, 10080, 10080, 10082 },
	{ 3463, 3464, 10082, 10084, 10084, 10086 },
	{ 3464, 3465, 10086, 10088, 10088, 10090 },
	{ 3465, 3466, 10090, 10092, 10092, 10094 },
	{ 3466, 3467, 10094, 10096, 10096, 10098 },
	{ 3467, 3468, 10098, 10102, 10102, 10103 },
	{ 3468, 3469, 10103, 10107, 10107, 10108 },
	{ 3469, 3470, 10108, 10113, 10113, 10115 },
	{ 3470, 3471, 10115, 10121, 10121, 10125 },
	{ 3471, 3472, 10125, 10127, 10127, 10128 },
	{ 3472, 3473, 10128, 10130, 10130, 10133 },
	{ 3473, 3474, 10133, 10135, 10135, 10138 },
	{ 3474, 3475, 10138, 10140, 10140, 10143 },
	{ 3475, 3476, 10143, 10145, 10145, 10148 },
	{ 3476, 3477, 10148, 10150, 10150, 10153 },
	{ 3477, 3478, 10153, 10155, 10155, 10158 },
	{ 3478, 3479, 10158, 10160, 10160, 10163 },
	{ 3479, 3480, 10163, 10165, 10165, 10168 },
	{ 3480, 3481, 10168, 10170, 10170, 10173 },
	{ 3481, 3482, 10173, 10175, 10175, 10178 },
	{ 3482, 3483, 10178, 10180, 10180, 10183 },
	{ 3483, 3484, 10183, 10185, 10185, 10188 },
	{ 3484, 3485, 10188, 10190, 10190, 10193 },
	{ 3485, 3486, 10193, 10195, 10195, 10198 },
	{ 3486, 3487, 10198, 10200, 10200, 10201 },
	{ 3487, 3488, 10201, 10203, 10203, 10204 },
	{ 3488, 3489, 10204, 10206, 10206, 10207 },
	{ 3489, 3490, 10207, 10209, 10209, 10210 },
	{ 3490, 3491, 10210, 10212, 10212, 10213 },
	{ 3491, 3492, 10213, 10218, 10218, 10220 },
	{ 3492, 3494, 10220, 10224, 10224, 10226 },
	{ 3494, 3495, 10226, 10231, 10231, 10232 },
	{ 3495, 3496, 10232, 10234, 10234, 10235 },
	{ 3496, 3497, 10235, 10236, 10236, 10239 },
	{ 3497, 3498, 10239, 10240, 10240, 10243 },
	{ 3498, 3500, 10243, 10245, 10245, 10247 },
	{ 3500, 3501, 10247, 10248, 10248, 10249 },
	{ 3501, 3502, 10249, 10251, 10251, 10253 },
	{ 3502, 3503, 10253, 10255, 10255, 10256 },
	{ 3503, 3505, 10256, 10257, 10257, 10258 },
	{ 3505, 3506, 10258, 10259, 10259, 10260 },
	{ 3506, 3510, 10260, 10262, 10262, 10264 },
	{ 3510, 3511, 10264, 10265, 10265, 10266 },
	{ 3511, 3512, 10266, 10267, 10267, 10268 },
	{ 3512, 3513, 10268, 10269, 10269, 10273 },
	{ 3513, 3514, 10273, 10274, 10274, 10275 },
	{ 3514, 3515, 10275, 10278, 10278, 10279 },
	{ 3515, 3516, 10279, 10282, 10282, 10283 },
	{ 3516, 3517, 10283, 10286, 10286, 10287 },
	{ 3517, 3518, 10287, 10289, 10289, 10291 },
	{ 3518, 3519, 10291, 10294, 10294, 10296 },
	{ 3519, 3520, 10296, 10299, 10299, 10301 },
	{ 3520, 3521, 10301, 10303, 10303, 10306 },
	{ 3521, 3522, 10306, 10308, 10308, 10311 },
	{ 3522, 3523, 10311, 10313, 10313, 10316 },
	{ 3523, 3524, 10316, 10318, 10318, 10320 },
	{ 3524, 3525, 10320, 10322, 10322, 10324 },
	{ 3525, 3526, 10324, 10326, 10326, 10328 },
	{ 3526, 3527, 10328, 10330, 10330, 10333 },
	{ 3527, 3528, 10333, 10335, 10335, 10336 },
	{ 3528, 3529, 10336, 10339, 10339, 10340 },
	{ 3529, 3530, 10340, 10343, 10343, 10344 },
	{ 3530, 3531, 10344, 10347, 10347, 10348 },
	{ 3531, 3532, 10348, 10351, 10351, 10352 },
	{ 3532, 3533, 10352, 10357, 10357, 10359 },
	{ 3533, 3534, 10359, 10364, 10364, 10366 },
	{ 3534, 3535, 10366, 10367, 10367, 10368 },
	{ 3535, 3536, 10368, 10369, 10369, 10370 },
	{ 3536, 3537, 10370, 10371, 10371, 10373 },
	{ 3537, 3538, 10373, 10374, 10374, 10375 },
	{ 3538, 3543, 10375, 10376, 10376, 10377 },
	{ 3543, 3544, 10377, 10378, 10378, 10379 },
	{ 3544, 3545, 10379, 10382, 10382, 10384 },
	{ 3545, 3546, 10384, 10389, 10389, 10394 },
	{ 3546, 3547, 10394, 10396, 10396, 10397 },
	{ 3547, 3548, 10397, 10399, 10399, 10400 },
	{ 3548, 3549, 10400, 10402, 10402, 10404 },
	{ 3549, 3551, 10404, 10406, 10406, 10408 },
	{ 3551, 3552, 10408, 10410, 10410, 10411 },
	{ 3552, 3553, 10411, 10414, 10414, 10415 },
	{ 3553, 3555, 10415, 10417, 10417, 10418 },
	{ 3555, 3557, 10418, 10419, 10419, 10420 },
	{ 3557, 3558, 10420, 10422, 10422, 10423 },
	{ 3558, 3559, 10423, 10426, 10426, 10427 },
	{ 3559, 3560, 10427, 10428, 10428, 10429 },
	{ 3560, 3561, 10429, 10430, 10430, 10431 },
	{ 3561, 3563, 10431, 10432, 10432, 10433 },
	{ 3563, 3564, 10433, 10435, 10435, 10436 },
	{ 3564, 3565, 10436, 10437, 10437, 10438 },
	{ 3565, 3566, 10438, 10440, 10440, 10441 },
	{ 3566, 3567, 10441, 10443, 10443, 10444 },
	{ 3567, 3569, 10444, 10447, 10447, 10449 },
	{ 3569, 3571, 10449, 10452, 10452, 10453 },
	{ 3571, 3573, 10453, 10455, 10455, 10457 },
	{ 3573, 3574, 10457, 10460, 10460, 10461 },
	{ 3574, 3575, 10461, 10464, 10464, 10465 },
	{ 3575, 3576, 10465, 10469, 10469, 10470 },
	{ 3576, 3577, 10470, 10473, 10473, 10474 },
	{ 3577, 3578, 10474, 10479, 10479, 10482 },
	{ 3578, 3579, 10482, 10485, 10485, 10486 },
	{ 3579, 3580, 10486, 10491, 10491, 10494 },
	{ 3580, 3581, 10494, 10498, 10498, 10500 },
	{ 3581, 3582, 10500, 10504, 10504, 10506 },
	{ 3582, 3583, 10506, 10513, 10513, 10517 },
	{ 3583, 3584, 10517, 10523, 10523, 10525 },
	{ 3584, 3585, 10525, 10528, 10528, 10529 },
	{ 3585, 3586, 10529, 10531, 10531, 10532 },
	{ 3586, 3587, 10532, 10534, 10534, 10535 },
	{ 3587, 3588, 10535, 10537, 10537, 10538 },
	{ 3588, 3590, 10538, 10539, 10539, 10540 },
	{ 3590, 3591, 10540, 10541, 10541, 10542 },
	{ 3591, 3593, 10542, 10543, 10543, 10544 },
	{ 3593, 3595, 10544, 10546, 10546, 10547 },
	{ 3595, 3597, 10547, 10548, 10548, 10549 },
	{ 3597, 3599, 10549, 10550, 10550, 10551 },
	{ 3599, 3600, 10551, 10553, 10553, 10554 },
	{ 3600, 3601, 10554, 10556, 10556, 10557 },
	{ 3601, 3602, 10557, 10559, 10559, 10560 },
	{ 3602, 3603, 10560, 10563, 10563, 10565 },
	{ 3603, 3604, 10565, 10569, 10569, 10570 },
	{ 3604, 3606, 10570, 10577, 10577, 10580 },
	{ 3606, 3610, 10580, 10596, 10596, 10604 },
	{ 3610, 3611, 10604, 10608, 10608, 10610 },
	{ 3611, 3612, 10610, 10613, 10613, 10614 },
	{ 3612, 3613, 10614, 10618, 10618, 10622 },
	{ 3613, 3614, 10622, 10626, 10626, 10630 },
	{ 3614, 3615, 10630, 10634, 10634, 10638 },
	{ 3615, 3616, 10638, 10642, 10642, 10646 },
	{ 3616, 3617, 10646, 10650, 10650, 10654 },
};

const u32 utdsp563xx_state::code[] = {
	0x200003, 0x023801, 0x200003, 0x02b801, 0x200003, 0x021801, 0x200003, 0x029801, 0x200003, 0x027801, 0x200003, 0x02f801, 0x200003, 0x022801, 0x200003, 0x02a801,
	0x200003, 0x020801, 0x200003, 0x028801, 0x200003, 0x025801, 0x200003, 0x02d801, 0x200003, 0x02b801, 0x200003, 0x023801, 0x200003, 0x02f801, 0x200003, 0x027801,
	0x200003, 0x029801, 0x200003, 0x021801, 0x200003, 0x022801, 0x200003, 0x02a801, 0x200003, 0x020801, 0x200003, 0x028801, 0x200003, 0x025801, 0x200003, 0x02d801,
	0x200003, 0x02a801, 0x200003, 0x022801, 0x200003, 0x02f801, 0x200003, 0x027801, 0x200003, 0x021801, 0x200003, 0x029801, 0x200003, 0x020801, 0x200003, 0x028801,
	0x200003, 0x025801, 0x200003, 0x02d801, 0x200003, 0x024801, 0x200003, 0x02c801, 0x200003, 0x02b801, 0x200003, 0x023801, 0x200003, 0x025801, 0x200003, 0x02d801,
	0x200003, 0x02b801, 0x200003, 0x023801, 0x200003, 0x025801, 0x200003, 0x02d801, 0x200003, 0x02b801, 0x200003, 0x023801, 0x200003, 0x02d801, 0x200003, 0x025801,
	0x200003, 0x023801, 0x200003, 0x02b801, 0x200003, 0x025801, 0x200003, 0x02d801, 0x200003, 0x023801, 0x200003, 0x02b801, 0x200003, 0x02d801, 0x200003, 0x025801,
	0x200003, 0x023801, 0x200003, 0x02b801, 0x200003, 0x024801, 0x200003, 0x02c801, 0x200003, 0x023801, 0x200003, 0x02b801, 0x200003, 0x024801, 0x200003, 0x02c801,
	0x200003, 0x02b801, 0x200003, 0x023801, 0x200003, 0x02c801, 0x200003, 0x024801, 0x200003, 0x023801, 0x200003, 0x02b801, 0x200003, 0x02c801, 0x200003, 0x024801,
	0x204800, 0x204500, 0x204500, 0x204d00, 0x204d00, 0x204800, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400,
	0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800,
	0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900,
	0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00,
	0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x205800, 0x024900, 0x204a00, 0x204300,
	0x205400, 0x205800, 0x024900, 0x204a00, 0x204300, 0x205400, 0x204900, 0x204a00, 0x204800, 0x204800, 0x204000, 0x204000, 0x204800, 0x204000, 0x44f400, 0xbabecc,
	0x44f400, 0xaaaaaa, 0x47f400, 0xdddddd, 0x44f400, 0xaaaaaa, 0x45f400, 0xbbbbbb, 0x44f400, 0xaaaaaa, 0x47f400, 0xdddddd, 0x200020, 0x200038, 0x200026, 0x20002e,
	0x200010, 0x200050, 0x200050, 0x200050, 0x200010, 0x017280, 0x0140c0, 0x000032, 0x20001a, 0x200002, 0x20000a, 0x200046, 0x20007e, 0x0033ba, 0x0033bb, 0x0033b8,
	0x0033b9, 0x0c1d02, 0x0c1c02, 0x20003a, 0x0c1d50, 0x200032, 0x200032, 0x0c1d02, 0x0c1e48, 0x200022, 0x200022, 0x0c1c02, 0x0c1c2a, 0x0c1e68, 0x0c1e7f, 0x0c1e6f,
	0x0b0203, 0x0b0343, 0x0a6014, 0x0a6150, 0x001114, 0x0a2250, 0x011002, 0x0a9004, 0x0afa47, 0x0afa47, 0x0acf56, 0x0a0223, 0x0a0363, 0x0b0222, 0x0b0223, 0x0c1e01,
	0x0c1e01, 0x0c1e01, 0x0c1e01, 0x44f41b, 0x000128, 0x200013, 0x20004d, 0x200045, 0x0140c5, 0x0000aa, 0x20004f, 0x00000a, 0x00000a, 0x00000a, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050, 0x018050,
	0x01248f, 0x01248f, 0x012586, 0x200043, 0x200043, 0x0c1a8d, 0x0c1890, 0x008028, 0x0c1a8d, 0x0c1890, 0x020000, 0x0c1890, 0x020000, 0x0c1890, 0x00c028, 0x202a10,
	0x202a10, 0x200003, 0x20310d, 0x200003, 0x203105, 0x000008, 0x000008, 0x0c1960, 0x00c008, 0x0c1b78, 0x0c1b3c, 0x044058, 0x00000a, 0x000020, 0x200033, 0x0c1e88,
	0x0c1e1c, 0x0c1e1c, 0x200023, 0x0c1ec8, 0x0c1e3c, 0x0c1e3c, 0x045818, 0x044818, 0x04180b, 0x04180b, 0x0430f6, 0x2000e2, 0x2000da, 0x2000da, 0x46d5bb, 0x0102f2,
	0x20001d, 0x20001d, 0x20001d, 0x20001d, 0x20001d, 0x20001d, 0x200015, 0x200015, 0x200015, 0x200015, 0x200015, 0x200015, 0x200015, 0x200015, 0x2000a0, 0x2000a0,
	0x2000d0, 0x2000d0, 0x2000d0, 0x2000d0, 0x0113f0, 0x0101d8, 0x2000d1, 0x0102f0, 0x200036, 0x200036, 0x0c1e28, 0x0c1e2b, 0x200017, 0x200017, 0x200042, 0x0140c2,
	0x444444, 0x014482, 0x0022fa, 0x0022fb, 0x0022f9, 0x0022f8, 0x200011, 0x200011, 0x200019, 0x200011, 0x200011, 0x200011, 0x200011, 0x200037, 0x200037, 0x200037,
	0x200014, 0x200014, 0x200044, 0x200016, 0x200016, 0x20001e, 0x200016, 0x200009, 0x022008, 0x022008, 0x022801, 0x022801, 0x032009, 0x032009, 0x2eff00, 0x2e0f00,
	0x24ff00, 0x32ff00, 0x2a1200, 0x54f400, 0x345678, 0x50f400, 0xabcdef, 0x21cf00, 0x5ffd00, 0xbada00, 0x21da00, 0x21d000, 0x21ee00, 0x214400, 0x216600, 0x21c700,
	0x07ea92, 0x56f000, 0x000010, 0x57f400, 0x03a800, 0x02209f, 0x02108f, 0x24ff00, 0x2eff00, 0x4ff000, 0x000020, 0x204c00, 0x205c00, 0x628700, 0x6a0600, 0x0a73dd,
	0x000004, 0x0a72d1, 0xfffffc, 0x0b729b, 0x000004, 0x02139e, 0x03f29e, 0x03f29e, 0x0212ae, 0x1a9a00, 0x1aa200, 0x1ada00, 0x082100, 0x09a600, 0xf0ca00, 0x806300,
	0x05e03a, 0x058339, 0x04c7b0, 0x0445aa, 0x05f43f, 0xaabbcc, 0x0555be, 0x08f485, 0xffeeff, 0x087045, 0x000023, 0x07f045, 0x334455, 0x07b48c, 0x556677, 0x04c784,
	0x044f26, 0x094705, 0x4ae000, 0x49e000, 0x42d900, 0x498300, 0x426100, 0x436200, 0x486300, 0x496400, 0x4a8300, 0x483400, 0x243c44, 0x210541, 0x21cf51, 0x21ee59,
	0x210741,
};

const utdsp563xx_state::reg utdsp563xx_state::regs[] = {
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xff000000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xff000000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xff000000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xff000000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x700000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x700000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x700000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x700000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xc00000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xc00000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xc00000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xc00000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x1 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_M0, 0xfff },
	{ DSP563XX_R0, 0x123f00 },
	{ DSP563XX_N0, 0x200 },
	{ DSP563XX_R0, 0x123100 },
	{ DSP563XX_M5, 0x3ffd },
	{ DSP563XX_R5, 0x9c000 },
	{ DSP563XX_N5, 0x3ffe },
	{ DSP563XX_R5, 0x9c000 },
	{ DSP563XX_M5, 0x3ffd },
	{ DSP563XX_R5, 0x9c000 },
	{ DSP563XX_N5, 0x1000 },
	{ DSP563XX_R5, 0x9effe },
	{ DSP563XX_M5, 0x3ffd },
	{ DSP563XX_R5, 0x9c000 },
	{ DSP563XX_N5, 0x4000 },
	{ DSP563XX_R5, 0xa0000 },
	{ DSP563XX_M5, 0x80 },
	{ DSP563XX_R5, 0x0 },
	{ DSP563XX_N5, 0x190 },
	{ DSP563XX_R5, 0x10f },
	{ DSP563XX_M0, 0x3ffd },
	{ DSP563XX_R0, 0xbbc3a },
	{ DSP563XX_N0, 0xffe9c7 },
	{ DSP563XX_R0, 0xba601 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123400 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123400 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123400 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123400 },
	{ DSP563XX_R0, 0x123401 },
	{ DSP563XX_R1, 0x123488 },
	{ DSP563XX_R2, 0x123400 },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_R4, 0x1234ff },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123401 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123401 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123401 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ff },
	{ DSP563XX_R0, 0x123402 },
	{ DSP563XX_R1, 0x123489 },
	{ DSP563XX_R2, 0x123401 },
	{ DSP563XX_R3, 0x1234ff },
	{ DSP563XX_R4, 0x1234fe },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123402 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123402 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123402 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fe },
	{ DSP563XX_R0, 0x123403 },
	{ DSP563XX_R1, 0x12348a },
	{ DSP563XX_R2, 0x123402 },
	{ DSP563XX_R3, 0x1234fe },
	{ DSP563XX_R4, 0x1234fd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123403 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123403 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123403 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fd },
	{ DSP563XX_R0, 0x123404 },
	{ DSP563XX_R1, 0x12348b },
	{ DSP563XX_R2, 0x123403 },
	{ DSP563XX_R3, 0x1234fd },
	{ DSP563XX_R4, 0x1234fc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123404 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123404 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123404 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fc },
	{ DSP563XX_R0, 0x123405 },
	{ DSP563XX_R1, 0x12348c },
	{ DSP563XX_R2, 0x123404 },
	{ DSP563XX_R3, 0x1234fc },
	{ DSP563XX_R4, 0x1234fb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123405 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123405 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123405 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fb },
	{ DSP563XX_R0, 0x123406 },
	{ DSP563XX_R1, 0x12348d },
	{ DSP563XX_R2, 0x123405 },
	{ DSP563XX_R3, 0x1234fb },
	{ DSP563XX_R4, 0x1234fa },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123406 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123406 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123406 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fa },
	{ DSP563XX_R0, 0x123407 },
	{ DSP563XX_R1, 0x12348e },
	{ DSP563XX_R2, 0x123406 },
	{ DSP563XX_R3, 0x1234fa },
	{ DSP563XX_R4, 0x1234f9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123407 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123407 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123407 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f9 },
	{ DSP563XX_R0, 0x123408 },
	{ DSP563XX_R1, 0x12348f },
	{ DSP563XX_R2, 0x123407 },
	{ DSP563XX_R3, 0x1234f9 },
	{ DSP563XX_R4, 0x1234f8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123408 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123408 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123408 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f8 },
	{ DSP563XX_R0, 0x123409 },
	{ DSP563XX_R1, 0x123490 },
	{ DSP563XX_R2, 0x123408 },
	{ DSP563XX_R3, 0x1234f8 },
	{ DSP563XX_R4, 0x1234f7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123409 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123409 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123409 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f7 },
	{ DSP563XX_R0, 0x12340a },
	{ DSP563XX_R1, 0x123491 },
	{ DSP563XX_R2, 0x123409 },
	{ DSP563XX_R3, 0x1234f7 },
	{ DSP563XX_R4, 0x1234f6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f6 },
	{ DSP563XX_R0, 0x12340b },
	{ DSP563XX_R1, 0x123492 },
	{ DSP563XX_R2, 0x12340a },
	{ DSP563XX_R3, 0x1234f6 },
	{ DSP563XX_R4, 0x1234f5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f5 },
	{ DSP563XX_R0, 0x12340c },
	{ DSP563XX_R1, 0x123493 },
	{ DSP563XX_R2, 0x12340b },
	{ DSP563XX_R3, 0x1234f5 },
	{ DSP563XX_R4, 0x1234f4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f4 },
	{ DSP563XX_R0, 0x12340d },
	{ DSP563XX_R1, 0x123494 },
	{ DSP563XX_R2, 0x12340c },
	{ DSP563XX_R3, 0x1234f4 },
	{ DSP563XX_R4, 0x1234f3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f3 },
	{ DSP563XX_R0, 0x12340e },
	{ DSP563XX_R1, 0x123495 },
	{ DSP563XX_R2, 0x12340d },
	{ DSP563XX_R3, 0x1234f3 },
	{ DSP563XX_R4, 0x1234f2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f2 },
	{ DSP563XX_R0, 0x12340f },
	{ DSP563XX_R1, 0x123496 },
	{ DSP563XX_R2, 0x12340e },
	{ DSP563XX_R3, 0x1234f2 },
	{ DSP563XX_R4, 0x1234f1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f1 },
	{ DSP563XX_R0, 0x123410 },
	{ DSP563XX_R1, 0x123497 },
	{ DSP563XX_R2, 0x12340f },
	{ DSP563XX_R3, 0x1234f1 },
	{ DSP563XX_R4, 0x1234f0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123410 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123410 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123410 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f0 },
	{ DSP563XX_R0, 0x123411 },
	{ DSP563XX_R1, 0x123498 },
	{ DSP563XX_R2, 0x123410 },
	{ DSP563XX_R3, 0x1234f0 },
	{ DSP563XX_R4, 0x1234ef },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123411 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123411 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123411 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ef },
	{ DSP563XX_R0, 0x123412 },
	{ DSP563XX_R1, 0x123499 },
	{ DSP563XX_R2, 0x123411 },
	{ DSP563XX_R3, 0x1234ef },
	{ DSP563XX_R4, 0x1234ee },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123412 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123412 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123412 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ee },
	{ DSP563XX_R0, 0x123413 },
	{ DSP563XX_R1, 0x12349a },
	{ DSP563XX_R2, 0x123412 },
	{ DSP563XX_R3, 0x1234ee },
	{ DSP563XX_R4, 0x1234ed },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123413 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123413 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123413 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ed },
	{ DSP563XX_R0, 0x123414 },
	{ DSP563XX_R1, 0x12349b },
	{ DSP563XX_R2, 0x123413 },
	{ DSP563XX_R3, 0x1234ed },
	{ DSP563XX_R4, 0x1234ec },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123414 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123414 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123414 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ec },
	{ DSP563XX_R0, 0x123415 },
	{ DSP563XX_R1, 0x12349c },
	{ DSP563XX_R2, 0x123414 },
	{ DSP563XX_R3, 0x1234ec },
	{ DSP563XX_R4, 0x1234eb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123415 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123415 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123415 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234eb },
	{ DSP563XX_R0, 0x123416 },
	{ DSP563XX_R1, 0x12349d },
	{ DSP563XX_R2, 0x123415 },
	{ DSP563XX_R3, 0x1234eb },
	{ DSP563XX_R4, 0x1234ea },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123416 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123416 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123416 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ea },
	{ DSP563XX_R0, 0x123417 },
	{ DSP563XX_R1, 0x12349e },
	{ DSP563XX_R2, 0x123416 },
	{ DSP563XX_R3, 0x1234ea },
	{ DSP563XX_R4, 0x1234e9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123417 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123417 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123417 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e9 },
	{ DSP563XX_R0, 0x123418 },
	{ DSP563XX_R1, 0x12349f },
	{ DSP563XX_R2, 0x123417 },
	{ DSP563XX_R3, 0x1234e9 },
	{ DSP563XX_R4, 0x1234e8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123418 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123418 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123418 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e8 },
	{ DSP563XX_R0, 0x123419 },
	{ DSP563XX_R1, 0x1234a0 },
	{ DSP563XX_R2, 0x123418 },
	{ DSP563XX_R3, 0x1234e8 },
	{ DSP563XX_R4, 0x1234e7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123419 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123419 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123419 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e7 },
	{ DSP563XX_R0, 0x12341a },
	{ DSP563XX_R1, 0x1234a1 },
	{ DSP563XX_R2, 0x123419 },
	{ DSP563XX_R3, 0x1234e7 },
	{ DSP563XX_R4, 0x1234e6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e6 },
	{ DSP563XX_R0, 0x12341b },
	{ DSP563XX_R1, 0x1234a2 },
	{ DSP563XX_R2, 0x12341a },
	{ DSP563XX_R3, 0x1234e6 },
	{ DSP563XX_R4, 0x1234e5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e5 },
	{ DSP563XX_R0, 0x12341c },
	{ DSP563XX_R1, 0x1234a3 },
	{ DSP563XX_R2, 0x12341b },
	{ DSP563XX_R3, 0x1234e5 },
	{ DSP563XX_R4, 0x1234e4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e4 },
	{ DSP563XX_R0, 0x12341d },
	{ DSP563XX_R1, 0x1234a4 },
	{ DSP563XX_R2, 0x12341c },
	{ DSP563XX_R3, 0x1234e4 },
	{ DSP563XX_R4, 0x1234e3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e3 },
	{ DSP563XX_R0, 0x12341e },
	{ DSP563XX_R1, 0x1234a5 },
	{ DSP563XX_R2, 0x12341d },
	{ DSP563XX_R3, 0x1234e3 },
	{ DSP563XX_R4, 0x1234e2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e2 },
	{ DSP563XX_R0, 0x12341f },
	{ DSP563XX_R1, 0x1234a6 },
	{ DSP563XX_R2, 0x12341e },
	{ DSP563XX_R3, 0x1234e2 },
	{ DSP563XX_R4, 0x1234e1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e1 },
	{ DSP563XX_R0, 0x123420 },
	{ DSP563XX_R1, 0x1234a7 },
	{ DSP563XX_R2, 0x12341f },
	{ DSP563XX_R3, 0x1234e1 },
	{ DSP563XX_R4, 0x1234e0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123420 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123420 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123420 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x20 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e0 },
	{ DSP563XX_R0, 0x123421 },
	{ DSP563XX_R1, 0x1234a8 },
	{ DSP563XX_R2, 0x123420 },
	{ DSP563XX_R3, 0x1234e0 },
	{ DSP563XX_R4, 0x1234df },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123421 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123421 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123421 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x21 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234df },
	{ DSP563XX_R0, 0x123422 },
	{ DSP563XX_R1, 0x1234a9 },
	{ DSP563XX_R2, 0x123421 },
	{ DSP563XX_R3, 0x1234df },
	{ DSP563XX_R4, 0x1234de },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123422 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123422 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123422 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x22 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234de },
	{ DSP563XX_R0, 0x123423 },
	{ DSP563XX_R1, 0x1234aa },
	{ DSP563XX_R2, 0x123422 },
	{ DSP563XX_R3, 0x1234de },
	{ DSP563XX_R4, 0x1234dd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123423 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123423 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123423 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x23 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234dd },
	{ DSP563XX_R0, 0x123424 },
	{ DSP563XX_R1, 0x1234ab },
	{ DSP563XX_R2, 0x123423 },
	{ DSP563XX_R3, 0x1234dd },
	{ DSP563XX_R4, 0x1234dc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123424 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123424 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123424 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x24 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234dc },
	{ DSP563XX_R0, 0x123425 },
	{ DSP563XX_R1, 0x1234ac },
	{ DSP563XX_R2, 0x123424 },
	{ DSP563XX_R3, 0x1234dc },
	{ DSP563XX_R4, 0x1234db },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123425 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123425 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123425 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x25 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234db },
	{ DSP563XX_R0, 0x123426 },
	{ DSP563XX_R1, 0x1234ad },
	{ DSP563XX_R2, 0x123425 },
	{ DSP563XX_R3, 0x1234db },
	{ DSP563XX_R4, 0x1234da },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123426 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123426 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123426 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x26 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234da },
	{ DSP563XX_R0, 0x123427 },
	{ DSP563XX_R1, 0x1234ae },
	{ DSP563XX_R2, 0x123426 },
	{ DSP563XX_R3, 0x1234da },
	{ DSP563XX_R4, 0x1234d9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123427 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123427 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123427 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x27 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d9 },
	{ DSP563XX_R0, 0x123428 },
	{ DSP563XX_R1, 0x1234af },
	{ DSP563XX_R2, 0x123427 },
	{ DSP563XX_R3, 0x1234d9 },
	{ DSP563XX_R4, 0x1234d8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123428 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123428 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123428 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x28 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d8 },
	{ DSP563XX_R0, 0x123429 },
	{ DSP563XX_R1, 0x1234b0 },
	{ DSP563XX_R2, 0x123428 },
	{ DSP563XX_R3, 0x1234d8 },
	{ DSP563XX_R4, 0x1234d7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123429 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123429 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123429 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x29 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d7 },
	{ DSP563XX_R0, 0x12342a },
	{ DSP563XX_R1, 0x1234b1 },
	{ DSP563XX_R2, 0x123429 },
	{ DSP563XX_R3, 0x1234d7 },
	{ DSP563XX_R4, 0x1234d6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d6 },
	{ DSP563XX_R0, 0x12342b },
	{ DSP563XX_R1, 0x1234b2 },
	{ DSP563XX_R2, 0x12342a },
	{ DSP563XX_R3, 0x1234d6 },
	{ DSP563XX_R4, 0x1234d5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d5 },
	{ DSP563XX_R0, 0x12342c },
	{ DSP563XX_R1, 0x1234b3 },
	{ DSP563XX_R2, 0x12342b },
	{ DSP563XX_R3, 0x1234d5 },
	{ DSP563XX_R4, 0x1234d4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d4 },
	{ DSP563XX_R0, 0x12342d },
	{ DSP563XX_R1, 0x1234b4 },
	{ DSP563XX_R2, 0x12342c },
	{ DSP563XX_R3, 0x1234d4 },
	{ DSP563XX_R4, 0x1234d3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d3 },
	{ DSP563XX_R0, 0x12342e },
	{ DSP563XX_R1, 0x1234b5 },
	{ DSP563XX_R2, 0x12342d },
	{ DSP563XX_R3, 0x1234d3 },
	{ DSP563XX_R4, 0x1234d2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d2 },
	{ DSP563XX_R0, 0x12342f },
	{ DSP563XX_R1, 0x1234b6 },
	{ DSP563XX_R2, 0x12342e },
	{ DSP563XX_R3, 0x1234d2 },
	{ DSP563XX_R4, 0x1234d1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x2f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d1 },
	{ DSP563XX_R0, 0x123430 },
	{ DSP563XX_R1, 0x1234b7 },
	{ DSP563XX_R2, 0x12342f },
	{ DSP563XX_R3, 0x1234d1 },
	{ DSP563XX_R4, 0x1234d0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123430 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123430 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123430 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x30 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d0 },
	{ DSP563XX_R0, 0x123431 },
	{ DSP563XX_R1, 0x1234b8 },
	{ DSP563XX_R2, 0x123430 },
	{ DSP563XX_R3, 0x1234d0 },
	{ DSP563XX_R4, 0x1234cf },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123431 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123431 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123431 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x31 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cf },
	{ DSP563XX_R0, 0x123432 },
	{ DSP563XX_R1, 0x1234b9 },
	{ DSP563XX_R2, 0x123431 },
	{ DSP563XX_R3, 0x1234cf },
	{ DSP563XX_R4, 0x1234ce },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123432 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123432 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123432 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x32 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ce },
	{ DSP563XX_R0, 0x123433 },
	{ DSP563XX_R1, 0x1234ba },
	{ DSP563XX_R2, 0x123432 },
	{ DSP563XX_R3, 0x1234ce },
	{ DSP563XX_R4, 0x1234cd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123433 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123433 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123433 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x33 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cd },
	{ DSP563XX_R0, 0x123434 },
	{ DSP563XX_R1, 0x1234bb },
	{ DSP563XX_R2, 0x123433 },
	{ DSP563XX_R3, 0x1234cd },
	{ DSP563XX_R4, 0x1234cc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123434 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123434 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123434 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x34 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cc },
	{ DSP563XX_R0, 0x123435 },
	{ DSP563XX_R1, 0x1234bc },
	{ DSP563XX_R2, 0x123434 },
	{ DSP563XX_R3, 0x1234cc },
	{ DSP563XX_R4, 0x1234cb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123435 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123435 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123435 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x35 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cb },
	{ DSP563XX_R0, 0x123436 },
	{ DSP563XX_R1, 0x1234bd },
	{ DSP563XX_R2, 0x123435 },
	{ DSP563XX_R3, 0x1234cb },
	{ DSP563XX_R4, 0x1234ca },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123436 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123436 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123436 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x36 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ca },
	{ DSP563XX_R0, 0x123437 },
	{ DSP563XX_R1, 0x1234be },
	{ DSP563XX_R2, 0x123436 },
	{ DSP563XX_R3, 0x1234ca },
	{ DSP563XX_R4, 0x1234c9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123437 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123437 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123437 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x37 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c9 },
	{ DSP563XX_R0, 0x123438 },
	{ DSP563XX_R1, 0x1234bf },
	{ DSP563XX_R2, 0x123437 },
	{ DSP563XX_R3, 0x1234c9 },
	{ DSP563XX_R4, 0x1234c8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123438 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123438 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123438 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x38 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c8 },
	{ DSP563XX_R0, 0x123439 },
	{ DSP563XX_R1, 0x1234c0 },
	{ DSP563XX_R2, 0x123438 },
	{ DSP563XX_R3, 0x1234c8 },
	{ DSP563XX_R4, 0x1234c7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123439 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123439 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123439 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x39 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c7 },
	{ DSP563XX_R0, 0x12343a },
	{ DSP563XX_R1, 0x1234c1 },
	{ DSP563XX_R2, 0x123439 },
	{ DSP563XX_R3, 0x1234c7 },
	{ DSP563XX_R4, 0x1234c6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c6 },
	{ DSP563XX_R0, 0x12343b },
	{ DSP563XX_R1, 0x1234c2 },
	{ DSP563XX_R2, 0x12343a },
	{ DSP563XX_R3, 0x1234c6 },
	{ DSP563XX_R4, 0x1234c5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c5 },
	{ DSP563XX_R0, 0x12343c },
	{ DSP563XX_R1, 0x1234c3 },
	{ DSP563XX_R2, 0x12343b },
	{ DSP563XX_R3, 0x1234c5 },
	{ DSP563XX_R4, 0x1234c4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c4 },
	{ DSP563XX_R0, 0x12343d },
	{ DSP563XX_R1, 0x1234c4 },
	{ DSP563XX_R2, 0x12343c },
	{ DSP563XX_R3, 0x1234c4 },
	{ DSP563XX_R4, 0x1234c3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c3 },
	{ DSP563XX_R0, 0x12343e },
	{ DSP563XX_R1, 0x1234c5 },
	{ DSP563XX_R2, 0x12343d },
	{ DSP563XX_R3, 0x1234c3 },
	{ DSP563XX_R4, 0x1234c2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c2 },
	{ DSP563XX_R0, 0x12343f },
	{ DSP563XX_R1, 0x1234c6 },
	{ DSP563XX_R2, 0x12343e },
	{ DSP563XX_R3, 0x1234c2 },
	{ DSP563XX_R4, 0x1234c1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x3f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c1 },
	{ DSP563XX_R0, 0x123440 },
	{ DSP563XX_R1, 0x1234c7 },
	{ DSP563XX_R2, 0x12343f },
	{ DSP563XX_R3, 0x1234c1 },
	{ DSP563XX_R4, 0x1234c0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123440 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123440 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123440 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x40 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c0 },
	{ DSP563XX_R0, 0x123441 },
	{ DSP563XX_R1, 0x1234c8 },
	{ DSP563XX_R2, 0x123440 },
	{ DSP563XX_R3, 0x1234c0 },
	{ DSP563XX_R4, 0x1234bf },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123441 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123441 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123441 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x41 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bf },
	{ DSP563XX_R0, 0x123442 },
	{ DSP563XX_R1, 0x1234c9 },
	{ DSP563XX_R2, 0x123441 },
	{ DSP563XX_R3, 0x1234bf },
	{ DSP563XX_R4, 0x1234be },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123442 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123442 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123442 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x42 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234be },
	{ DSP563XX_R0, 0x123443 },
	{ DSP563XX_R1, 0x1234ca },
	{ DSP563XX_R2, 0x123442 },
	{ DSP563XX_R3, 0x1234be },
	{ DSP563XX_R4, 0x1234bd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123443 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123443 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123443 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x43 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bd },
	{ DSP563XX_R0, 0x123444 },
	{ DSP563XX_R1, 0x1234cb },
	{ DSP563XX_R2, 0x123443 },
	{ DSP563XX_R3, 0x1234bd },
	{ DSP563XX_R4, 0x1234bc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123444 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123444 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123444 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x44 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bc },
	{ DSP563XX_R0, 0x123445 },
	{ DSP563XX_R1, 0x1234cc },
	{ DSP563XX_R2, 0x123444 },
	{ DSP563XX_R3, 0x1234bc },
	{ DSP563XX_R4, 0x1234bb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123445 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123445 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123445 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x45 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bb },
	{ DSP563XX_R0, 0x123446 },
	{ DSP563XX_R1, 0x1234cd },
	{ DSP563XX_R2, 0x123445 },
	{ DSP563XX_R3, 0x1234bb },
	{ DSP563XX_R4, 0x1234ba },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123446 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123446 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123446 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x46 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ba },
	{ DSP563XX_R0, 0x123447 },
	{ DSP563XX_R1, 0x1234ce },
	{ DSP563XX_R2, 0x123446 },
	{ DSP563XX_R3, 0x1234ba },
	{ DSP563XX_R4, 0x1234b9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123447 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123447 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123447 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x47 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b9 },
	{ DSP563XX_R0, 0x123448 },
	{ DSP563XX_R1, 0x1234cf },
	{ DSP563XX_R2, 0x123447 },
	{ DSP563XX_R3, 0x1234b9 },
	{ DSP563XX_R4, 0x1234b8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123448 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123448 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123448 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x48 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b8 },
	{ DSP563XX_R0, 0x123449 },
	{ DSP563XX_R1, 0x1234d0 },
	{ DSP563XX_R2, 0x123448 },
	{ DSP563XX_R3, 0x1234b8 },
	{ DSP563XX_R4, 0x1234b7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123449 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123449 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123449 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x49 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b7 },
	{ DSP563XX_R0, 0x12344a },
	{ DSP563XX_R1, 0x1234d1 },
	{ DSP563XX_R2, 0x123449 },
	{ DSP563XX_R3, 0x1234b7 },
	{ DSP563XX_R4, 0x1234b6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b6 },
	{ DSP563XX_R0, 0x12344b },
	{ DSP563XX_R1, 0x1234d2 },
	{ DSP563XX_R2, 0x12344a },
	{ DSP563XX_R3, 0x1234b6 },
	{ DSP563XX_R4, 0x1234b5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b5 },
	{ DSP563XX_R0, 0x12344c },
	{ DSP563XX_R1, 0x1234d3 },
	{ DSP563XX_R2, 0x12344b },
	{ DSP563XX_R3, 0x1234b5 },
	{ DSP563XX_R4, 0x1234b4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b4 },
	{ DSP563XX_R0, 0x12344d },
	{ DSP563XX_R1, 0x1234d4 },
	{ DSP563XX_R2, 0x12344c },
	{ DSP563XX_R3, 0x1234b4 },
	{ DSP563XX_R4, 0x1234b3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b3 },
	{ DSP563XX_R0, 0x12344e },
	{ DSP563XX_R1, 0x1234d5 },
	{ DSP563XX_R2, 0x12344d },
	{ DSP563XX_R3, 0x1234b3 },
	{ DSP563XX_R4, 0x1234b2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b2 },
	{ DSP563XX_R0, 0x12344f },
	{ DSP563XX_R1, 0x1234d6 },
	{ DSP563XX_R2, 0x12344e },
	{ DSP563XX_R3, 0x1234b2 },
	{ DSP563XX_R4, 0x1234b1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x4f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b1 },
	{ DSP563XX_R0, 0x123450 },
	{ DSP563XX_R1, 0x1234d7 },
	{ DSP563XX_R2, 0x12344f },
	{ DSP563XX_R3, 0x1234b1 },
	{ DSP563XX_R4, 0x1234b0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123450 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123450 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123450 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x50 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b0 },
	{ DSP563XX_R0, 0x123451 },
	{ DSP563XX_R1, 0x1234d8 },
	{ DSP563XX_R2, 0x123450 },
	{ DSP563XX_R3, 0x1234b0 },
	{ DSP563XX_R4, 0x1234af },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123451 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123451 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123451 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x51 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234af },
	{ DSP563XX_R0, 0x123452 },
	{ DSP563XX_R1, 0x1234d9 },
	{ DSP563XX_R2, 0x123451 },
	{ DSP563XX_R3, 0x1234af },
	{ DSP563XX_R4, 0x1234ae },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123452 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123452 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123452 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x52 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ae },
	{ DSP563XX_R0, 0x123453 },
	{ DSP563XX_R1, 0x1234da },
	{ DSP563XX_R2, 0x123452 },
	{ DSP563XX_R3, 0x1234ae },
	{ DSP563XX_R4, 0x1234ad },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123453 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123453 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123453 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x53 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ad },
	{ DSP563XX_R0, 0x123454 },
	{ DSP563XX_R1, 0x1234db },
	{ DSP563XX_R2, 0x123453 },
	{ DSP563XX_R3, 0x1234ad },
	{ DSP563XX_R4, 0x1234ac },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123454 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123454 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123454 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x54 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ac },
	{ DSP563XX_R0, 0x123455 },
	{ DSP563XX_R1, 0x1234dc },
	{ DSP563XX_R2, 0x123454 },
	{ DSP563XX_R3, 0x1234ac },
	{ DSP563XX_R4, 0x1234ab },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123455 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123455 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123455 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x55 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ab },
	{ DSP563XX_R0, 0x123456 },
	{ DSP563XX_R1, 0x1234dd },
	{ DSP563XX_R2, 0x123455 },
	{ DSP563XX_R3, 0x1234ab },
	{ DSP563XX_R4, 0x1234aa },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123456 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123456 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123456 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x56 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234aa },
	{ DSP563XX_R0, 0x123457 },
	{ DSP563XX_R1, 0x1234de },
	{ DSP563XX_R2, 0x123456 },
	{ DSP563XX_R3, 0x1234aa },
	{ DSP563XX_R4, 0x1234a9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123457 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123457 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123457 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x57 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a9 },
	{ DSP563XX_R0, 0x123458 },
	{ DSP563XX_R1, 0x1234df },
	{ DSP563XX_R2, 0x123457 },
	{ DSP563XX_R3, 0x1234a9 },
	{ DSP563XX_R4, 0x1234a8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123458 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123458 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123458 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x58 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a8 },
	{ DSP563XX_R0, 0x123459 },
	{ DSP563XX_R1, 0x1234e0 },
	{ DSP563XX_R2, 0x123458 },
	{ DSP563XX_R3, 0x1234a8 },
	{ DSP563XX_R4, 0x1234a7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123459 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123459 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123459 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x59 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a7 },
	{ DSP563XX_R0, 0x12345a },
	{ DSP563XX_R1, 0x1234e1 },
	{ DSP563XX_R2, 0x123459 },
	{ DSP563XX_R3, 0x1234a7 },
	{ DSP563XX_R4, 0x1234a6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a6 },
	{ DSP563XX_R0, 0x12345b },
	{ DSP563XX_R1, 0x1234e2 },
	{ DSP563XX_R2, 0x12345a },
	{ DSP563XX_R3, 0x1234a6 },
	{ DSP563XX_R4, 0x1234a5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a5 },
	{ DSP563XX_R0, 0x12345c },
	{ DSP563XX_R1, 0x1234e3 },
	{ DSP563XX_R2, 0x12345b },
	{ DSP563XX_R3, 0x1234a5 },
	{ DSP563XX_R4, 0x1234a4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a4 },
	{ DSP563XX_R0, 0x12345d },
	{ DSP563XX_R1, 0x1234e4 },
	{ DSP563XX_R2, 0x12345c },
	{ DSP563XX_R3, 0x1234a4 },
	{ DSP563XX_R4, 0x1234a3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a3 },
	{ DSP563XX_R0, 0x12345e },
	{ DSP563XX_R1, 0x1234e5 },
	{ DSP563XX_R2, 0x12345d },
	{ DSP563XX_R3, 0x1234a3 },
	{ DSP563XX_R4, 0x1234a2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a2 },
	{ DSP563XX_R0, 0x12345f },
	{ DSP563XX_R1, 0x1234e6 },
	{ DSP563XX_R2, 0x12345e },
	{ DSP563XX_R3, 0x1234a2 },
	{ DSP563XX_R4, 0x1234a1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x5f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a1 },
	{ DSP563XX_R0, 0x123460 },
	{ DSP563XX_R1, 0x1234e7 },
	{ DSP563XX_R2, 0x12345f },
	{ DSP563XX_R3, 0x1234a1 },
	{ DSP563XX_R4, 0x1234a0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123460 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123460 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123460 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x60 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a0 },
	{ DSP563XX_R0, 0x123461 },
	{ DSP563XX_R1, 0x1234e8 },
	{ DSP563XX_R2, 0x123460 },
	{ DSP563XX_R3, 0x1234a0 },
	{ DSP563XX_R4, 0x12349f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123461 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123461 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123461 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x61 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349f },
	{ DSP563XX_R0, 0x123462 },
	{ DSP563XX_R1, 0x1234e9 },
	{ DSP563XX_R2, 0x123461 },
	{ DSP563XX_R3, 0x12349f },
	{ DSP563XX_R4, 0x12349e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123462 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123462 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123462 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x62 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349e },
	{ DSP563XX_R0, 0x123463 },
	{ DSP563XX_R1, 0x1234ea },
	{ DSP563XX_R2, 0x123462 },
	{ DSP563XX_R3, 0x12349e },
	{ DSP563XX_R4, 0x12349d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123463 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123463 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123463 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x63 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349d },
	{ DSP563XX_R0, 0x123464 },
	{ DSP563XX_R1, 0x1234eb },
	{ DSP563XX_R2, 0x123463 },
	{ DSP563XX_R3, 0x12349d },
	{ DSP563XX_R4, 0x12349c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123464 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123464 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123464 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x64 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349c },
	{ DSP563XX_R0, 0x123465 },
	{ DSP563XX_R1, 0x1234ec },
	{ DSP563XX_R2, 0x123464 },
	{ DSP563XX_R3, 0x12349c },
	{ DSP563XX_R4, 0x12349b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123465 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123465 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123465 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x65 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349b },
	{ DSP563XX_R0, 0x123466 },
	{ DSP563XX_R1, 0x1234ed },
	{ DSP563XX_R2, 0x123465 },
	{ DSP563XX_R3, 0x12349b },
	{ DSP563XX_R4, 0x12349a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123466 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123466 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123466 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x66 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349a },
	{ DSP563XX_R0, 0x123467 },
	{ DSP563XX_R1, 0x1234ee },
	{ DSP563XX_R2, 0x123466 },
	{ DSP563XX_R3, 0x12349a },
	{ DSP563XX_R4, 0x123499 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123467 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123467 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123467 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x67 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123499 },
	{ DSP563XX_R0, 0x123468 },
	{ DSP563XX_R1, 0x1234ef },
	{ DSP563XX_R2, 0x123467 },
	{ DSP563XX_R3, 0x123499 },
	{ DSP563XX_R4, 0x123498 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123468 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123468 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123468 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x68 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123498 },
	{ DSP563XX_R0, 0x123469 },
	{ DSP563XX_R1, 0x1234f0 },
	{ DSP563XX_R2, 0x123468 },
	{ DSP563XX_R3, 0x123498 },
	{ DSP563XX_R4, 0x123497 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123469 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123469 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123469 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x69 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123497 },
	{ DSP563XX_R0, 0x12346a },
	{ DSP563XX_R1, 0x1234f1 },
	{ DSP563XX_R2, 0x123469 },
	{ DSP563XX_R3, 0x123497 },
	{ DSP563XX_R4, 0x123496 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123496 },
	{ DSP563XX_R0, 0x12346b },
	{ DSP563XX_R1, 0x1234f2 },
	{ DSP563XX_R2, 0x12346a },
	{ DSP563XX_R3, 0x123496 },
	{ DSP563XX_R4, 0x123495 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123495 },
	{ DSP563XX_R0, 0x12346c },
	{ DSP563XX_R1, 0x1234f3 },
	{ DSP563XX_R2, 0x12346b },
	{ DSP563XX_R3, 0x123495 },
	{ DSP563XX_R4, 0x123494 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123494 },
	{ DSP563XX_R0, 0x12346d },
	{ DSP563XX_R1, 0x1234f4 },
	{ DSP563XX_R2, 0x12346c },
	{ DSP563XX_R3, 0x123494 },
	{ DSP563XX_R4, 0x123493 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123493 },
	{ DSP563XX_R0, 0x12346e },
	{ DSP563XX_R1, 0x1234f5 },
	{ DSP563XX_R2, 0x12346d },
	{ DSP563XX_R3, 0x123493 },
	{ DSP563XX_R4, 0x123492 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123492 },
	{ DSP563XX_R0, 0x12346f },
	{ DSP563XX_R1, 0x1234f6 },
	{ DSP563XX_R2, 0x12346e },
	{ DSP563XX_R3, 0x123492 },
	{ DSP563XX_R4, 0x123491 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x6f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123491 },
	{ DSP563XX_R0, 0x123470 },
	{ DSP563XX_R1, 0x1234f7 },
	{ DSP563XX_R2, 0x12346f },
	{ DSP563XX_R3, 0x123491 },
	{ DSP563XX_R4, 0x123490 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123470 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123470 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123470 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x70 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123490 },
	{ DSP563XX_R0, 0x123471 },
	{ DSP563XX_R1, 0x1234f8 },
	{ DSP563XX_R2, 0x123470 },
	{ DSP563XX_R3, 0x123490 },
	{ DSP563XX_R4, 0x12348f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123471 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123471 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123471 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x71 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348f },
	{ DSP563XX_R0, 0x123472 },
	{ DSP563XX_R1, 0x1234f9 },
	{ DSP563XX_R2, 0x123471 },
	{ DSP563XX_R3, 0x12348f },
	{ DSP563XX_R4, 0x12348e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123472 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123472 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123472 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x72 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348e },
	{ DSP563XX_R0, 0x123473 },
	{ DSP563XX_R1, 0x1234fa },
	{ DSP563XX_R2, 0x123472 },
	{ DSP563XX_R3, 0x12348e },
	{ DSP563XX_R4, 0x12348d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123473 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123473 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123473 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x73 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348d },
	{ DSP563XX_R0, 0x123474 },
	{ DSP563XX_R1, 0x1234fb },
	{ DSP563XX_R2, 0x123473 },
	{ DSP563XX_R3, 0x12348d },
	{ DSP563XX_R4, 0x12348c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123474 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123474 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123474 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x74 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348c },
	{ DSP563XX_R0, 0x123475 },
	{ DSP563XX_R1, 0x1234fc },
	{ DSP563XX_R2, 0x123474 },
	{ DSP563XX_R3, 0x12348c },
	{ DSP563XX_R4, 0x12348b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123475 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123475 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123475 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x75 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348b },
	{ DSP563XX_R0, 0x123476 },
	{ DSP563XX_R1, 0x1234fd },
	{ DSP563XX_R2, 0x123475 },
	{ DSP563XX_R3, 0x12348b },
	{ DSP563XX_R4, 0x12348a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123476 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123476 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123476 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x76 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348a },
	{ DSP563XX_R0, 0x123477 },
	{ DSP563XX_R1, 0x1234fe },
	{ DSP563XX_R2, 0x123476 },
	{ DSP563XX_R3, 0x12348a },
	{ DSP563XX_R4, 0x123489 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123477 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123477 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123477 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x77 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123489 },
	{ DSP563XX_R0, 0x123478 },
	{ DSP563XX_R1, 0x1234ff },
	{ DSP563XX_R2, 0x123477 },
	{ DSP563XX_R3, 0x123489 },
	{ DSP563XX_R4, 0x123488 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123478 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123478 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123478 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x78 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123488 },
	{ DSP563XX_R0, 0x123479 },
	{ DSP563XX_R1, 0x123400 },
	{ DSP563XX_R2, 0x123478 },
	{ DSP563XX_R3, 0x123488 },
	{ DSP563XX_R4, 0x123487 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123479 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123479 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123479 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x79 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123487 },
	{ DSP563XX_R0, 0x12347a },
	{ DSP563XX_R1, 0x123401 },
	{ DSP563XX_R2, 0x123479 },
	{ DSP563XX_R3, 0x123487 },
	{ DSP563XX_R4, 0x123486 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123486 },
	{ DSP563XX_R0, 0x12347b },
	{ DSP563XX_R1, 0x123402 },
	{ DSP563XX_R2, 0x12347a },
	{ DSP563XX_R3, 0x123486 },
	{ DSP563XX_R4, 0x123485 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123485 },
	{ DSP563XX_R0, 0x12347c },
	{ DSP563XX_R1, 0x123403 },
	{ DSP563XX_R2, 0x12347b },
	{ DSP563XX_R3, 0x123485 },
	{ DSP563XX_R4, 0x123484 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123484 },
	{ DSP563XX_R0, 0x12347d },
	{ DSP563XX_R1, 0x123404 },
	{ DSP563XX_R2, 0x12347c },
	{ DSP563XX_R3, 0x123484 },
	{ DSP563XX_R4, 0x123483 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123483 },
	{ DSP563XX_R0, 0x12347e },
	{ DSP563XX_R1, 0x123405 },
	{ DSP563XX_R2, 0x12347d },
	{ DSP563XX_R3, 0x123483 },
	{ DSP563XX_R4, 0x123482 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123482 },
	{ DSP563XX_R0, 0x12347f },
	{ DSP563XX_R1, 0x123406 },
	{ DSP563XX_R2, 0x12347e },
	{ DSP563XX_R3, 0x123482 },
	{ DSP563XX_R4, 0x123481 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x7f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123481 },
	{ DSP563XX_R0, 0x123480 },
	{ DSP563XX_R1, 0x123407 },
	{ DSP563XX_R2, 0x12347f },
	{ DSP563XX_R3, 0x123481 },
	{ DSP563XX_R4, 0x123480 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123480 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123480 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123480 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x80 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123480 },
	{ DSP563XX_R0, 0x123481 },
	{ DSP563XX_R1, 0x123408 },
	{ DSP563XX_R2, 0x123480 },
	{ DSP563XX_R3, 0x123480 },
	{ DSP563XX_R4, 0x12347f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123481 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123481 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123481 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x81 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347f },
	{ DSP563XX_R0, 0x123482 },
	{ DSP563XX_R1, 0x123409 },
	{ DSP563XX_R2, 0x123481 },
	{ DSP563XX_R3, 0x12347f },
	{ DSP563XX_R4, 0x12347e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123482 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123482 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123482 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x82 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347e },
	{ DSP563XX_R0, 0x123483 },
	{ DSP563XX_R1, 0x12340a },
	{ DSP563XX_R2, 0x123482 },
	{ DSP563XX_R3, 0x12347e },
	{ DSP563XX_R4, 0x12347d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123483 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123483 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123483 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x83 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347d },
	{ DSP563XX_R0, 0x123484 },
	{ DSP563XX_R1, 0x12340b },
	{ DSP563XX_R2, 0x123483 },
	{ DSP563XX_R3, 0x12347d },
	{ DSP563XX_R4, 0x12347c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123484 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123484 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123484 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x84 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347c },
	{ DSP563XX_R0, 0x123485 },
	{ DSP563XX_R1, 0x12340c },
	{ DSP563XX_R2, 0x123484 },
	{ DSP563XX_R3, 0x12347c },
	{ DSP563XX_R4, 0x12347b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123485 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123485 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123485 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x85 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347b },
	{ DSP563XX_R0, 0x123486 },
	{ DSP563XX_R1, 0x12340d },
	{ DSP563XX_R2, 0x123485 },
	{ DSP563XX_R3, 0x12347b },
	{ DSP563XX_R4, 0x12347a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123486 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123486 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123486 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x86 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347a },
	{ DSP563XX_R0, 0x123487 },
	{ DSP563XX_R1, 0x12340e },
	{ DSP563XX_R2, 0x123486 },
	{ DSP563XX_R3, 0x12347a },
	{ DSP563XX_R4, 0x123479 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123487 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123487 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123487 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x87 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123479 },
	{ DSP563XX_R0, 0x123488 },
	{ DSP563XX_R1, 0x12340f },
	{ DSP563XX_R2, 0x123487 },
	{ DSP563XX_R3, 0x123479 },
	{ DSP563XX_R4, 0x123478 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123488 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123488 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123488 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x88 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123478 },
	{ DSP563XX_R0, 0x123489 },
	{ DSP563XX_R1, 0x123410 },
	{ DSP563XX_R2, 0x123488 },
	{ DSP563XX_R3, 0x123478 },
	{ DSP563XX_R4, 0x123477 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123489 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123489 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123489 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x89 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123477 },
	{ DSP563XX_R0, 0x12348a },
	{ DSP563XX_R1, 0x123411 },
	{ DSP563XX_R2, 0x123489 },
	{ DSP563XX_R3, 0x123477 },
	{ DSP563XX_R4, 0x123476 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123476 },
	{ DSP563XX_R0, 0x12348b },
	{ DSP563XX_R1, 0x123412 },
	{ DSP563XX_R2, 0x12348a },
	{ DSP563XX_R3, 0x123476 },
	{ DSP563XX_R4, 0x123475 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123475 },
	{ DSP563XX_R0, 0x12348c },
	{ DSP563XX_R1, 0x123413 },
	{ DSP563XX_R2, 0x12348b },
	{ DSP563XX_R3, 0x123475 },
	{ DSP563XX_R4, 0x123474 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123474 },
	{ DSP563XX_R0, 0x12348d },
	{ DSP563XX_R1, 0x123414 },
	{ DSP563XX_R2, 0x12348c },
	{ DSP563XX_R3, 0x123474 },
	{ DSP563XX_R4, 0x123473 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123473 },
	{ DSP563XX_R0, 0x12348e },
	{ DSP563XX_R1, 0x123415 },
	{ DSP563XX_R2, 0x12348d },
	{ DSP563XX_R3, 0x123473 },
	{ DSP563XX_R4, 0x123472 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123472 },
	{ DSP563XX_R0, 0x12348f },
	{ DSP563XX_R1, 0x123416 },
	{ DSP563XX_R2, 0x12348e },
	{ DSP563XX_R3, 0x123472 },
	{ DSP563XX_R4, 0x123471 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x8f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123471 },
	{ DSP563XX_R0, 0x123490 },
	{ DSP563XX_R1, 0x123417 },
	{ DSP563XX_R2, 0x12348f },
	{ DSP563XX_R3, 0x123471 },
	{ DSP563XX_R4, 0x123470 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123490 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123490 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123490 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x90 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123470 },
	{ DSP563XX_R0, 0x123491 },
	{ DSP563XX_R1, 0x123418 },
	{ DSP563XX_R2, 0x123490 },
	{ DSP563XX_R3, 0x123470 },
	{ DSP563XX_R4, 0x12346f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123491 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123491 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123491 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x91 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346f },
	{ DSP563XX_R0, 0x123492 },
	{ DSP563XX_R1, 0x123419 },
	{ DSP563XX_R2, 0x123491 },
	{ DSP563XX_R3, 0x12346f },
	{ DSP563XX_R4, 0x12346e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123492 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123492 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123492 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x92 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346e },
	{ DSP563XX_R0, 0x123493 },
	{ DSP563XX_R1, 0x12341a },
	{ DSP563XX_R2, 0x123492 },
	{ DSP563XX_R3, 0x12346e },
	{ DSP563XX_R4, 0x12346d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123493 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123493 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123493 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x93 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346d },
	{ DSP563XX_R0, 0x123494 },
	{ DSP563XX_R1, 0x12341b },
	{ DSP563XX_R2, 0x123493 },
	{ DSP563XX_R3, 0x12346d },
	{ DSP563XX_R4, 0x12346c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123494 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123494 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123494 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x94 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346c },
	{ DSP563XX_R0, 0x123495 },
	{ DSP563XX_R1, 0x12341c },
	{ DSP563XX_R2, 0x123494 },
	{ DSP563XX_R3, 0x12346c },
	{ DSP563XX_R4, 0x12346b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123495 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123495 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123495 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x95 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346b },
	{ DSP563XX_R0, 0x123496 },
	{ DSP563XX_R1, 0x12341d },
	{ DSP563XX_R2, 0x123495 },
	{ DSP563XX_R3, 0x12346b },
	{ DSP563XX_R4, 0x12346a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123496 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123496 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123496 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x96 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346a },
	{ DSP563XX_R0, 0x123497 },
	{ DSP563XX_R1, 0x12341e },
	{ DSP563XX_R2, 0x123496 },
	{ DSP563XX_R3, 0x12346a },
	{ DSP563XX_R4, 0x123469 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123497 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123497 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123497 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x97 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123469 },
	{ DSP563XX_R0, 0x123498 },
	{ DSP563XX_R1, 0x12341f },
	{ DSP563XX_R2, 0x123497 },
	{ DSP563XX_R3, 0x123469 },
	{ DSP563XX_R4, 0x123468 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123498 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123498 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123498 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x98 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123468 },
	{ DSP563XX_R0, 0x123499 },
	{ DSP563XX_R1, 0x123420 },
	{ DSP563XX_R2, 0x123498 },
	{ DSP563XX_R3, 0x123468 },
	{ DSP563XX_R4, 0x123467 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123499 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123499 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123499 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x99 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123467 },
	{ DSP563XX_R0, 0x12349a },
	{ DSP563XX_R1, 0x123421 },
	{ DSP563XX_R2, 0x123499 },
	{ DSP563XX_R3, 0x123467 },
	{ DSP563XX_R4, 0x123466 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123466 },
	{ DSP563XX_R0, 0x12349b },
	{ DSP563XX_R1, 0x123422 },
	{ DSP563XX_R2, 0x12349a },
	{ DSP563XX_R3, 0x123466 },
	{ DSP563XX_R4, 0x123465 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123465 },
	{ DSP563XX_R0, 0x12349c },
	{ DSP563XX_R1, 0x123423 },
	{ DSP563XX_R2, 0x12349b },
	{ DSP563XX_R3, 0x123465 },
	{ DSP563XX_R4, 0x123464 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123464 },
	{ DSP563XX_R0, 0x12349d },
	{ DSP563XX_R1, 0x123424 },
	{ DSP563XX_R2, 0x12349c },
	{ DSP563XX_R3, 0x123464 },
	{ DSP563XX_R4, 0x123463 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123463 },
	{ DSP563XX_R0, 0x12349e },
	{ DSP563XX_R1, 0x123425 },
	{ DSP563XX_R2, 0x12349d },
	{ DSP563XX_R3, 0x123463 },
	{ DSP563XX_R4, 0x123462 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123462 },
	{ DSP563XX_R0, 0x12349f },
	{ DSP563XX_R1, 0x123426 },
	{ DSP563XX_R2, 0x12349e },
	{ DSP563XX_R3, 0x123462 },
	{ DSP563XX_R4, 0x123461 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x9f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123461 },
	{ DSP563XX_R0, 0x1234a0 },
	{ DSP563XX_R1, 0x123427 },
	{ DSP563XX_R2, 0x12349f },
	{ DSP563XX_R3, 0x123461 },
	{ DSP563XX_R4, 0x123460 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123460 },
	{ DSP563XX_R0, 0x1234a1 },
	{ DSP563XX_R1, 0x123428 },
	{ DSP563XX_R2, 0x1234a0 },
	{ DSP563XX_R3, 0x123460 },
	{ DSP563XX_R4, 0x12345f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345f },
	{ DSP563XX_R0, 0x1234a2 },
	{ DSP563XX_R1, 0x123429 },
	{ DSP563XX_R2, 0x1234a1 },
	{ DSP563XX_R3, 0x12345f },
	{ DSP563XX_R4, 0x12345e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345e },
	{ DSP563XX_R0, 0x1234a3 },
	{ DSP563XX_R1, 0x12342a },
	{ DSP563XX_R2, 0x1234a2 },
	{ DSP563XX_R3, 0x12345e },
	{ DSP563XX_R4, 0x12345d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345d },
	{ DSP563XX_R0, 0x1234a4 },
	{ DSP563XX_R1, 0x12342b },
	{ DSP563XX_R2, 0x1234a3 },
	{ DSP563XX_R3, 0x12345d },
	{ DSP563XX_R4, 0x12345c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345c },
	{ DSP563XX_R0, 0x1234a5 },
	{ DSP563XX_R1, 0x12342c },
	{ DSP563XX_R2, 0x1234a4 },
	{ DSP563XX_R3, 0x12345c },
	{ DSP563XX_R4, 0x12345b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345b },
	{ DSP563XX_R0, 0x1234a6 },
	{ DSP563XX_R1, 0x12342d },
	{ DSP563XX_R2, 0x1234a5 },
	{ DSP563XX_R3, 0x12345b },
	{ DSP563XX_R4, 0x12345a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345a },
	{ DSP563XX_R0, 0x1234a7 },
	{ DSP563XX_R1, 0x12342e },
	{ DSP563XX_R2, 0x1234a6 },
	{ DSP563XX_R3, 0x12345a },
	{ DSP563XX_R4, 0x123459 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123459 },
	{ DSP563XX_R0, 0x1234a8 },
	{ DSP563XX_R1, 0x12342f },
	{ DSP563XX_R2, 0x1234a7 },
	{ DSP563XX_R3, 0x123459 },
	{ DSP563XX_R4, 0x123458 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123458 },
	{ DSP563XX_R0, 0x1234a9 },
	{ DSP563XX_R1, 0x123430 },
	{ DSP563XX_R2, 0x1234a8 },
	{ DSP563XX_R3, 0x123458 },
	{ DSP563XX_R4, 0x123457 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xa9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123457 },
	{ DSP563XX_R0, 0x1234aa },
	{ DSP563XX_R1, 0x123431 },
	{ DSP563XX_R2, 0x1234a9 },
	{ DSP563XX_R3, 0x123457 },
	{ DSP563XX_R4, 0x123456 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234aa },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234aa },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234aa },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xaa },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123456 },
	{ DSP563XX_R0, 0x1234ab },
	{ DSP563XX_R1, 0x123432 },
	{ DSP563XX_R2, 0x1234aa },
	{ DSP563XX_R3, 0x123456 },
	{ DSP563XX_R4, 0x123455 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ab },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ab },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ab },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xab },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123455 },
	{ DSP563XX_R0, 0x1234ac },
	{ DSP563XX_R1, 0x123433 },
	{ DSP563XX_R2, 0x1234ab },
	{ DSP563XX_R3, 0x123455 },
	{ DSP563XX_R4, 0x123454 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ac },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ac },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ac },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xac },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123454 },
	{ DSP563XX_R0, 0x1234ad },
	{ DSP563XX_R1, 0x123434 },
	{ DSP563XX_R2, 0x1234ac },
	{ DSP563XX_R3, 0x123454 },
	{ DSP563XX_R4, 0x123453 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ad },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ad },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ad },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xad },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123453 },
	{ DSP563XX_R0, 0x1234ae },
	{ DSP563XX_R1, 0x123435 },
	{ DSP563XX_R2, 0x1234ad },
	{ DSP563XX_R3, 0x123453 },
	{ DSP563XX_R4, 0x123452 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ae },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ae },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ae },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xae },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123452 },
	{ DSP563XX_R0, 0x1234af },
	{ DSP563XX_R1, 0x123436 },
	{ DSP563XX_R2, 0x1234ae },
	{ DSP563XX_R3, 0x123452 },
	{ DSP563XX_R4, 0x123451 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234af },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234af },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234af },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xaf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123451 },
	{ DSP563XX_R0, 0x1234b0 },
	{ DSP563XX_R1, 0x123437 },
	{ DSP563XX_R2, 0x1234af },
	{ DSP563XX_R3, 0x123451 },
	{ DSP563XX_R4, 0x123450 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123450 },
	{ DSP563XX_R0, 0x1234b1 },
	{ DSP563XX_R1, 0x123438 },
	{ DSP563XX_R2, 0x1234b0 },
	{ DSP563XX_R3, 0x123450 },
	{ DSP563XX_R4, 0x12344f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344f },
	{ DSP563XX_R0, 0x1234b2 },
	{ DSP563XX_R1, 0x123439 },
	{ DSP563XX_R2, 0x1234b1 },
	{ DSP563XX_R3, 0x12344f },
	{ DSP563XX_R4, 0x12344e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344e },
	{ DSP563XX_R0, 0x1234b3 },
	{ DSP563XX_R1, 0x12343a },
	{ DSP563XX_R2, 0x1234b2 },
	{ DSP563XX_R3, 0x12344e },
	{ DSP563XX_R4, 0x12344d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344d },
	{ DSP563XX_R0, 0x1234b4 },
	{ DSP563XX_R1, 0x12343b },
	{ DSP563XX_R2, 0x1234b3 },
	{ DSP563XX_R3, 0x12344d },
	{ DSP563XX_R4, 0x12344c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344c },
	{ DSP563XX_R0, 0x1234b5 },
	{ DSP563XX_R1, 0x12343c },
	{ DSP563XX_R2, 0x1234b4 },
	{ DSP563XX_R3, 0x12344c },
	{ DSP563XX_R4, 0x12344b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344b },
	{ DSP563XX_R0, 0x1234b6 },
	{ DSP563XX_R1, 0x12343d },
	{ DSP563XX_R2, 0x1234b5 },
	{ DSP563XX_R3, 0x12344b },
	{ DSP563XX_R4, 0x12344a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344a },
	{ DSP563XX_R0, 0x1234b7 },
	{ DSP563XX_R1, 0x12343e },
	{ DSP563XX_R2, 0x1234b6 },
	{ DSP563XX_R3, 0x12344a },
	{ DSP563XX_R4, 0x123449 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123449 },
	{ DSP563XX_R0, 0x1234b8 },
	{ DSP563XX_R1, 0x12343f },
	{ DSP563XX_R2, 0x1234b7 },
	{ DSP563XX_R3, 0x123449 },
	{ DSP563XX_R4, 0x123448 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123448 },
	{ DSP563XX_R0, 0x1234b9 },
	{ DSP563XX_R1, 0x123440 },
	{ DSP563XX_R2, 0x1234b8 },
	{ DSP563XX_R3, 0x123448 },
	{ DSP563XX_R4, 0x123447 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xb9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123447 },
	{ DSP563XX_R0, 0x1234ba },
	{ DSP563XX_R1, 0x123441 },
	{ DSP563XX_R2, 0x1234b9 },
	{ DSP563XX_R3, 0x123447 },
	{ DSP563XX_R4, 0x123446 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ba },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ba },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ba },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xba },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123446 },
	{ DSP563XX_R0, 0x1234bb },
	{ DSP563XX_R1, 0x123442 },
	{ DSP563XX_R2, 0x1234ba },
	{ DSP563XX_R3, 0x123446 },
	{ DSP563XX_R4, 0x123445 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xbb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123445 },
	{ DSP563XX_R0, 0x1234bc },
	{ DSP563XX_R1, 0x123443 },
	{ DSP563XX_R2, 0x1234bb },
	{ DSP563XX_R3, 0x123445 },
	{ DSP563XX_R4, 0x123444 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xbc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123444 },
	{ DSP563XX_R0, 0x1234bd },
	{ DSP563XX_R1, 0x123444 },
	{ DSP563XX_R2, 0x1234bc },
	{ DSP563XX_R3, 0x123444 },
	{ DSP563XX_R4, 0x123443 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xbd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123443 },
	{ DSP563XX_R0, 0x1234be },
	{ DSP563XX_R1, 0x123445 },
	{ DSP563XX_R2, 0x1234bd },
	{ DSP563XX_R3, 0x123443 },
	{ DSP563XX_R4, 0x123442 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234be },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234be },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234be },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xbe },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123442 },
	{ DSP563XX_R0, 0x1234bf },
	{ DSP563XX_R1, 0x123446 },
	{ DSP563XX_R2, 0x1234be },
	{ DSP563XX_R3, 0x123442 },
	{ DSP563XX_R4, 0x123441 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bf },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bf },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bf },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xbf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123441 },
	{ DSP563XX_R0, 0x1234c0 },
	{ DSP563XX_R1, 0x123447 },
	{ DSP563XX_R2, 0x1234bf },
	{ DSP563XX_R3, 0x123441 },
	{ DSP563XX_R4, 0x123440 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123440 },
	{ DSP563XX_R0, 0x1234c1 },
	{ DSP563XX_R1, 0x123448 },
	{ DSP563XX_R2, 0x1234c0 },
	{ DSP563XX_R3, 0x123440 },
	{ DSP563XX_R4, 0x12343f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343f },
	{ DSP563XX_R0, 0x1234c2 },
	{ DSP563XX_R1, 0x123449 },
	{ DSP563XX_R2, 0x1234c1 },
	{ DSP563XX_R3, 0x12343f },
	{ DSP563XX_R4, 0x12343e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343e },
	{ DSP563XX_R0, 0x1234c3 },
	{ DSP563XX_R1, 0x12344a },
	{ DSP563XX_R2, 0x1234c2 },
	{ DSP563XX_R3, 0x12343e },
	{ DSP563XX_R4, 0x12343d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343d },
	{ DSP563XX_R0, 0x1234c4 },
	{ DSP563XX_R1, 0x12344b },
	{ DSP563XX_R2, 0x1234c3 },
	{ DSP563XX_R3, 0x12343d },
	{ DSP563XX_R4, 0x12343c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343c },
	{ DSP563XX_R0, 0x1234c5 },
	{ DSP563XX_R1, 0x12344c },
	{ DSP563XX_R2, 0x1234c4 },
	{ DSP563XX_R3, 0x12343c },
	{ DSP563XX_R4, 0x12343b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343b },
	{ DSP563XX_R0, 0x1234c6 },
	{ DSP563XX_R1, 0x12344d },
	{ DSP563XX_R2, 0x1234c5 },
	{ DSP563XX_R3, 0x12343b },
	{ DSP563XX_R4, 0x12343a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343a },
	{ DSP563XX_R0, 0x1234c7 },
	{ DSP563XX_R1, 0x12344e },
	{ DSP563XX_R2, 0x1234c6 },
	{ DSP563XX_R3, 0x12343a },
	{ DSP563XX_R4, 0x123439 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123439 },
	{ DSP563XX_R0, 0x1234c8 },
	{ DSP563XX_R1, 0x12344f },
	{ DSP563XX_R2, 0x1234c7 },
	{ DSP563XX_R3, 0x123439 },
	{ DSP563XX_R4, 0x123438 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123438 },
	{ DSP563XX_R0, 0x1234c9 },
	{ DSP563XX_R1, 0x123450 },
	{ DSP563XX_R2, 0x1234c8 },
	{ DSP563XX_R3, 0x123438 },
	{ DSP563XX_R4, 0x123437 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xc9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123437 },
	{ DSP563XX_R0, 0x1234ca },
	{ DSP563XX_R1, 0x123451 },
	{ DSP563XX_R2, 0x1234c9 },
	{ DSP563XX_R3, 0x123437 },
	{ DSP563XX_R4, 0x123436 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ca },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ca },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ca },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xca },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123436 },
	{ DSP563XX_R0, 0x1234cb },
	{ DSP563XX_R1, 0x123452 },
	{ DSP563XX_R2, 0x1234ca },
	{ DSP563XX_R3, 0x123436 },
	{ DSP563XX_R4, 0x123435 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xcb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123435 },
	{ DSP563XX_R0, 0x1234cc },
	{ DSP563XX_R1, 0x123453 },
	{ DSP563XX_R2, 0x1234cb },
	{ DSP563XX_R3, 0x123435 },
	{ DSP563XX_R4, 0x123434 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xcc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123434 },
	{ DSP563XX_R0, 0x1234cd },
	{ DSP563XX_R1, 0x123454 },
	{ DSP563XX_R2, 0x1234cc },
	{ DSP563XX_R3, 0x123434 },
	{ DSP563XX_R4, 0x123433 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xcd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123433 },
	{ DSP563XX_R0, 0x1234ce },
	{ DSP563XX_R1, 0x123455 },
	{ DSP563XX_R2, 0x1234cd },
	{ DSP563XX_R3, 0x123433 },
	{ DSP563XX_R4, 0x123432 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ce },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ce },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ce },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xce },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123432 },
	{ DSP563XX_R0, 0x1234cf },
	{ DSP563XX_R1, 0x123456 },
	{ DSP563XX_R2, 0x1234ce },
	{ DSP563XX_R3, 0x123432 },
	{ DSP563XX_R4, 0x123431 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cf },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cf },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cf },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xcf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123431 },
	{ DSP563XX_R0, 0x1234d0 },
	{ DSP563XX_R1, 0x123457 },
	{ DSP563XX_R2, 0x1234cf },
	{ DSP563XX_R3, 0x123431 },
	{ DSP563XX_R4, 0x123430 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123430 },
	{ DSP563XX_R0, 0x1234d1 },
	{ DSP563XX_R1, 0x123458 },
	{ DSP563XX_R2, 0x1234d0 },
	{ DSP563XX_R3, 0x123430 },
	{ DSP563XX_R4, 0x12342f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342f },
	{ DSP563XX_R0, 0x1234d2 },
	{ DSP563XX_R1, 0x123459 },
	{ DSP563XX_R2, 0x1234d1 },
	{ DSP563XX_R3, 0x12342f },
	{ DSP563XX_R4, 0x12342e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342e },
	{ DSP563XX_R0, 0x1234d3 },
	{ DSP563XX_R1, 0x12345a },
	{ DSP563XX_R2, 0x1234d2 },
	{ DSP563XX_R3, 0x12342e },
	{ DSP563XX_R4, 0x12342d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342d },
	{ DSP563XX_R0, 0x1234d4 },
	{ DSP563XX_R1, 0x12345b },
	{ DSP563XX_R2, 0x1234d3 },
	{ DSP563XX_R3, 0x12342d },
	{ DSP563XX_R4, 0x12342c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342c },
	{ DSP563XX_R0, 0x1234d5 },
	{ DSP563XX_R1, 0x12345c },
	{ DSP563XX_R2, 0x1234d4 },
	{ DSP563XX_R3, 0x12342c },
	{ DSP563XX_R4, 0x12342b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342b },
	{ DSP563XX_R0, 0x1234d6 },
	{ DSP563XX_R1, 0x12345d },
	{ DSP563XX_R2, 0x1234d5 },
	{ DSP563XX_R3, 0x12342b },
	{ DSP563XX_R4, 0x12342a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342a },
	{ DSP563XX_R0, 0x1234d7 },
	{ DSP563XX_R1, 0x12345e },
	{ DSP563XX_R2, 0x1234d6 },
	{ DSP563XX_R3, 0x12342a },
	{ DSP563XX_R4, 0x123429 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123429 },
	{ DSP563XX_R0, 0x1234d8 },
	{ DSP563XX_R1, 0x12345f },
	{ DSP563XX_R2, 0x1234d7 },
	{ DSP563XX_R3, 0x123429 },
	{ DSP563XX_R4, 0x123428 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123428 },
	{ DSP563XX_R0, 0x1234d9 },
	{ DSP563XX_R1, 0x123460 },
	{ DSP563XX_R2, 0x1234d8 },
	{ DSP563XX_R3, 0x123428 },
	{ DSP563XX_R4, 0x123427 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xd9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123427 },
	{ DSP563XX_R0, 0x1234da },
	{ DSP563XX_R1, 0x123461 },
	{ DSP563XX_R2, 0x1234d9 },
	{ DSP563XX_R3, 0x123427 },
	{ DSP563XX_R4, 0x123426 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234da },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234da },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234da },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xda },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123426 },
	{ DSP563XX_R0, 0x1234db },
	{ DSP563XX_R1, 0x123462 },
	{ DSP563XX_R2, 0x1234da },
	{ DSP563XX_R3, 0x123426 },
	{ DSP563XX_R4, 0x123425 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234db },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234db },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234db },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xdb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123425 },
	{ DSP563XX_R0, 0x1234dc },
	{ DSP563XX_R1, 0x123463 },
	{ DSP563XX_R2, 0x1234db },
	{ DSP563XX_R3, 0x123425 },
	{ DSP563XX_R4, 0x123424 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234dc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234dc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234dc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xdc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123424 },
	{ DSP563XX_R0, 0x1234dd },
	{ DSP563XX_R1, 0x123464 },
	{ DSP563XX_R2, 0x1234dc },
	{ DSP563XX_R3, 0x123424 },
	{ DSP563XX_R4, 0x123423 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234dd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234dd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234dd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xdd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123423 },
	{ DSP563XX_R0, 0x1234de },
	{ DSP563XX_R1, 0x123465 },
	{ DSP563XX_R2, 0x1234dd },
	{ DSP563XX_R3, 0x123423 },
	{ DSP563XX_R4, 0x123422 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234de },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234de },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234de },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xde },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123422 },
	{ DSP563XX_R0, 0x1234df },
	{ DSP563XX_R1, 0x123466 },
	{ DSP563XX_R2, 0x1234de },
	{ DSP563XX_R3, 0x123422 },
	{ DSP563XX_R4, 0x123421 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234df },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234df },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234df },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xdf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123421 },
	{ DSP563XX_R0, 0x1234e0 },
	{ DSP563XX_R1, 0x123467 },
	{ DSP563XX_R2, 0x1234df },
	{ DSP563XX_R3, 0x123421 },
	{ DSP563XX_R4, 0x123420 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123420 },
	{ DSP563XX_R0, 0x1234e1 },
	{ DSP563XX_R1, 0x123468 },
	{ DSP563XX_R2, 0x1234e0 },
	{ DSP563XX_R3, 0x123420 },
	{ DSP563XX_R4, 0x12341f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341f },
	{ DSP563XX_R0, 0x1234e2 },
	{ DSP563XX_R1, 0x123469 },
	{ DSP563XX_R2, 0x1234e1 },
	{ DSP563XX_R3, 0x12341f },
	{ DSP563XX_R4, 0x12341e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341e },
	{ DSP563XX_R0, 0x1234e3 },
	{ DSP563XX_R1, 0x12346a },
	{ DSP563XX_R2, 0x1234e2 },
	{ DSP563XX_R3, 0x12341e },
	{ DSP563XX_R4, 0x12341d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341d },
	{ DSP563XX_R0, 0x1234e4 },
	{ DSP563XX_R1, 0x12346b },
	{ DSP563XX_R2, 0x1234e3 },
	{ DSP563XX_R3, 0x12341d },
	{ DSP563XX_R4, 0x12341c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341c },
	{ DSP563XX_R0, 0x1234e5 },
	{ DSP563XX_R1, 0x12346c },
	{ DSP563XX_R2, 0x1234e4 },
	{ DSP563XX_R3, 0x12341c },
	{ DSP563XX_R4, 0x12341b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341b },
	{ DSP563XX_R0, 0x1234e6 },
	{ DSP563XX_R1, 0x12346d },
	{ DSP563XX_R2, 0x1234e5 },
	{ DSP563XX_R3, 0x12341b },
	{ DSP563XX_R4, 0x12341a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341a },
	{ DSP563XX_R0, 0x1234e7 },
	{ DSP563XX_R1, 0x12346e },
	{ DSP563XX_R2, 0x1234e6 },
	{ DSP563XX_R3, 0x12341a },
	{ DSP563XX_R4, 0x123419 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123419 },
	{ DSP563XX_R0, 0x1234e8 },
	{ DSP563XX_R1, 0x12346f },
	{ DSP563XX_R2, 0x1234e7 },
	{ DSP563XX_R3, 0x123419 },
	{ DSP563XX_R4, 0x123418 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123418 },
	{ DSP563XX_R0, 0x1234e9 },
	{ DSP563XX_R1, 0x123470 },
	{ DSP563XX_R2, 0x1234e8 },
	{ DSP563XX_R3, 0x123418 },
	{ DSP563XX_R4, 0x123417 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xe9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123417 },
	{ DSP563XX_R0, 0x1234ea },
	{ DSP563XX_R1, 0x123471 },
	{ DSP563XX_R2, 0x1234e9 },
	{ DSP563XX_R3, 0x123417 },
	{ DSP563XX_R4, 0x123416 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ea },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ea },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ea },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xea },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123416 },
	{ DSP563XX_R0, 0x1234eb },
	{ DSP563XX_R1, 0x123472 },
	{ DSP563XX_R2, 0x1234ea },
	{ DSP563XX_R3, 0x123416 },
	{ DSP563XX_R4, 0x123415 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234eb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234eb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234eb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xeb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123415 },
	{ DSP563XX_R0, 0x1234ec },
	{ DSP563XX_R1, 0x123473 },
	{ DSP563XX_R2, 0x1234eb },
	{ DSP563XX_R3, 0x123415 },
	{ DSP563XX_R4, 0x123414 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ec },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ec },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ec },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xec },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123414 },
	{ DSP563XX_R0, 0x1234ed },
	{ DSP563XX_R1, 0x123474 },
	{ DSP563XX_R2, 0x1234ec },
	{ DSP563XX_R3, 0x123414 },
	{ DSP563XX_R4, 0x123413 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ed },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ed },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ed },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xed },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123413 },
	{ DSP563XX_R0, 0x1234ee },
	{ DSP563XX_R1, 0x123475 },
	{ DSP563XX_R2, 0x1234ed },
	{ DSP563XX_R3, 0x123413 },
	{ DSP563XX_R4, 0x123412 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ee },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ee },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ee },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xee },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123412 },
	{ DSP563XX_R0, 0x1234ef },
	{ DSP563XX_R1, 0x123476 },
	{ DSP563XX_R2, 0x1234ee },
	{ DSP563XX_R3, 0x123412 },
	{ DSP563XX_R4, 0x123411 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ef },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ef },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ef },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xef },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123411 },
	{ DSP563XX_R0, 0x1234f0 },
	{ DSP563XX_R1, 0x123477 },
	{ DSP563XX_R2, 0x1234ef },
	{ DSP563XX_R3, 0x123411 },
	{ DSP563XX_R4, 0x123410 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123410 },
	{ DSP563XX_R0, 0x1234f1 },
	{ DSP563XX_R1, 0x123478 },
	{ DSP563XX_R2, 0x1234f0 },
	{ DSP563XX_R3, 0x123410 },
	{ DSP563XX_R4, 0x12340f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340f },
	{ DSP563XX_R0, 0x1234f2 },
	{ DSP563XX_R1, 0x123479 },
	{ DSP563XX_R2, 0x1234f1 },
	{ DSP563XX_R3, 0x12340f },
	{ DSP563XX_R4, 0x12340e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340e },
	{ DSP563XX_R0, 0x1234f3 },
	{ DSP563XX_R1, 0x12347a },
	{ DSP563XX_R2, 0x1234f2 },
	{ DSP563XX_R3, 0x12340e },
	{ DSP563XX_R4, 0x12340d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340d },
	{ DSP563XX_R0, 0x1234f4 },
	{ DSP563XX_R1, 0x12347b },
	{ DSP563XX_R2, 0x1234f3 },
	{ DSP563XX_R3, 0x12340d },
	{ DSP563XX_R4, 0x12340c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340c },
	{ DSP563XX_R0, 0x1234f5 },
	{ DSP563XX_R1, 0x12347c },
	{ DSP563XX_R2, 0x1234f4 },
	{ DSP563XX_R3, 0x12340c },
	{ DSP563XX_R4, 0x12340b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340b },
	{ DSP563XX_R0, 0x1234f6 },
	{ DSP563XX_R1, 0x12347d },
	{ DSP563XX_R2, 0x1234f5 },
	{ DSP563XX_R3, 0x12340b },
	{ DSP563XX_R4, 0x12340a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340a },
	{ DSP563XX_R0, 0x1234f7 },
	{ DSP563XX_R1, 0x12347e },
	{ DSP563XX_R2, 0x1234f6 },
	{ DSP563XX_R3, 0x12340a },
	{ DSP563XX_R4, 0x123409 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123409 },
	{ DSP563XX_R0, 0x1234f8 },
	{ DSP563XX_R1, 0x12347f },
	{ DSP563XX_R2, 0x1234f7 },
	{ DSP563XX_R3, 0x123409 },
	{ DSP563XX_R4, 0x123408 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123408 },
	{ DSP563XX_R0, 0x1234f9 },
	{ DSP563XX_R1, 0x123480 },
	{ DSP563XX_R2, 0x1234f8 },
	{ DSP563XX_R3, 0x123408 },
	{ DSP563XX_R4, 0x123407 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xf9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123407 },
	{ DSP563XX_R0, 0x1234fa },
	{ DSP563XX_R1, 0x123481 },
	{ DSP563XX_R2, 0x1234f9 },
	{ DSP563XX_R3, 0x123407 },
	{ DSP563XX_R4, 0x123406 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fa },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fa },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fa },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xfa },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123406 },
	{ DSP563XX_R0, 0x1234fb },
	{ DSP563XX_R1, 0x123482 },
	{ DSP563XX_R2, 0x1234fa },
	{ DSP563XX_R3, 0x123406 },
	{ DSP563XX_R4, 0x123405 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xfb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123405 },
	{ DSP563XX_R0, 0x1234fc },
	{ DSP563XX_R1, 0x123483 },
	{ DSP563XX_R2, 0x1234fb },
	{ DSP563XX_R3, 0x123405 },
	{ DSP563XX_R4, 0x123404 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xfc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123404 },
	{ DSP563XX_R0, 0x1234fd },
	{ DSP563XX_R1, 0x123484 },
	{ DSP563XX_R2, 0x1234fc },
	{ DSP563XX_R3, 0x123404 },
	{ DSP563XX_R4, 0x123403 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xfd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123403 },
	{ DSP563XX_R0, 0x1234fe },
	{ DSP563XX_R1, 0x123485 },
	{ DSP563XX_R2, 0x1234fd },
	{ DSP563XX_R3, 0x123403 },
	{ DSP563XX_R4, 0x123402 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fe },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fe },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fe },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xfe },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123402 },
	{ DSP563XX_R0, 0x1234ff },
	{ DSP563XX_R1, 0x123486 },
	{ DSP563XX_R2, 0x1234fe },
	{ DSP563XX_R3, 0x123402 },
	{ DSP563XX_R4, 0x123401 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ff },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ff },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ff },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0xff },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123401 },
	{ DSP563XX_R0, 0x123400 },
	{ DSP563XX_R1, 0x123487 },
	{ DSP563XX_R2, 0x1234ff },
	{ DSP563XX_R3, 0x123401 },
	{ DSP563XX_R4, 0x123400 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123400 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123400 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123400 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x100 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123400 },
	{ DSP563XX_R0, 0x123401 },
	{ DSP563XX_R1, 0x123488 },
	{ DSP563XX_R2, 0x123400 },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_R4, 0x1234ff },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123401 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123401 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123401 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x101 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ff },
	{ DSP563XX_R0, 0x123402 },
	{ DSP563XX_R1, 0x123489 },
	{ DSP563XX_R2, 0x123401 },
	{ DSP563XX_R3, 0x1234ff },
	{ DSP563XX_R4, 0x1234fe },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123402 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123402 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123402 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x102 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fe },
	{ DSP563XX_R0, 0x123403 },
	{ DSP563XX_R1, 0x12348a },
	{ DSP563XX_R2, 0x123402 },
	{ DSP563XX_R3, 0x1234fe },
	{ DSP563XX_R4, 0x1234fd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123403 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123403 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123403 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x103 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fd },
	{ DSP563XX_R0, 0x123404 },
	{ DSP563XX_R1, 0x12348b },
	{ DSP563XX_R2, 0x123403 },
	{ DSP563XX_R3, 0x1234fd },
	{ DSP563XX_R4, 0x1234fc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123404 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123404 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123404 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x104 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fc },
	{ DSP563XX_R0, 0x123405 },
	{ DSP563XX_R1, 0x12348c },
	{ DSP563XX_R2, 0x123404 },
	{ DSP563XX_R3, 0x1234fc },
	{ DSP563XX_R4, 0x1234fb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123405 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123405 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123405 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x105 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fb },
	{ DSP563XX_R0, 0x123406 },
	{ DSP563XX_R1, 0x12348d },
	{ DSP563XX_R2, 0x123405 },
	{ DSP563XX_R3, 0x1234fb },
	{ DSP563XX_R4, 0x1234fa },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123406 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123406 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123406 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x106 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234fa },
	{ DSP563XX_R0, 0x123407 },
	{ DSP563XX_R1, 0x12348e },
	{ DSP563XX_R2, 0x123406 },
	{ DSP563XX_R3, 0x1234fa },
	{ DSP563XX_R4, 0x1234f9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123407 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123407 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123407 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x107 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f9 },
	{ DSP563XX_R0, 0x123408 },
	{ DSP563XX_R1, 0x12348f },
	{ DSP563XX_R2, 0x123407 },
	{ DSP563XX_R3, 0x1234f9 },
	{ DSP563XX_R4, 0x1234f8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123408 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123408 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123408 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x108 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f8 },
	{ DSP563XX_R0, 0x123409 },
	{ DSP563XX_R1, 0x123490 },
	{ DSP563XX_R2, 0x123408 },
	{ DSP563XX_R3, 0x1234f8 },
	{ DSP563XX_R4, 0x1234f7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123409 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123409 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123409 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x109 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f7 },
	{ DSP563XX_R0, 0x12340a },
	{ DSP563XX_R1, 0x123491 },
	{ DSP563XX_R2, 0x123409 },
	{ DSP563XX_R3, 0x1234f7 },
	{ DSP563XX_R4, 0x1234f6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f6 },
	{ DSP563XX_R0, 0x12340b },
	{ DSP563XX_R1, 0x123492 },
	{ DSP563XX_R2, 0x12340a },
	{ DSP563XX_R3, 0x1234f6 },
	{ DSP563XX_R4, 0x1234f5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f5 },
	{ DSP563XX_R0, 0x12340c },
	{ DSP563XX_R1, 0x123493 },
	{ DSP563XX_R2, 0x12340b },
	{ DSP563XX_R3, 0x1234f5 },
	{ DSP563XX_R4, 0x1234f4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f4 },
	{ DSP563XX_R0, 0x12340d },
	{ DSP563XX_R1, 0x123494 },
	{ DSP563XX_R2, 0x12340c },
	{ DSP563XX_R3, 0x1234f4 },
	{ DSP563XX_R4, 0x1234f3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f3 },
	{ DSP563XX_R0, 0x12340e },
	{ DSP563XX_R1, 0x123495 },
	{ DSP563XX_R2, 0x12340d },
	{ DSP563XX_R3, 0x1234f3 },
	{ DSP563XX_R4, 0x1234f2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f2 },
	{ DSP563XX_R0, 0x12340f },
	{ DSP563XX_R1, 0x123496 },
	{ DSP563XX_R2, 0x12340e },
	{ DSP563XX_R3, 0x1234f2 },
	{ DSP563XX_R4, 0x1234f1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12340f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12340f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12340f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x10f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f1 },
	{ DSP563XX_R0, 0x123410 },
	{ DSP563XX_R1, 0x123497 },
	{ DSP563XX_R2, 0x12340f },
	{ DSP563XX_R3, 0x1234f1 },
	{ DSP563XX_R4, 0x1234f0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123410 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123410 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123410 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x110 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234f0 },
	{ DSP563XX_R0, 0x123411 },
	{ DSP563XX_R1, 0x123498 },
	{ DSP563XX_R2, 0x123410 },
	{ DSP563XX_R3, 0x1234f0 },
	{ DSP563XX_R4, 0x1234ef },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123411 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123411 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123411 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x111 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ef },
	{ DSP563XX_R0, 0x123412 },
	{ DSP563XX_R1, 0x123499 },
	{ DSP563XX_R2, 0x123411 },
	{ DSP563XX_R3, 0x1234ef },
	{ DSP563XX_R4, 0x1234ee },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123412 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123412 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123412 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x112 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ee },
	{ DSP563XX_R0, 0x123413 },
	{ DSP563XX_R1, 0x12349a },
	{ DSP563XX_R2, 0x123412 },
	{ DSP563XX_R3, 0x1234ee },
	{ DSP563XX_R4, 0x1234ed },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123413 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123413 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123413 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x113 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ed },
	{ DSP563XX_R0, 0x123414 },
	{ DSP563XX_R1, 0x12349b },
	{ DSP563XX_R2, 0x123413 },
	{ DSP563XX_R3, 0x1234ed },
	{ DSP563XX_R4, 0x1234ec },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123414 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123414 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123414 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x114 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ec },
	{ DSP563XX_R0, 0x123415 },
	{ DSP563XX_R1, 0x12349c },
	{ DSP563XX_R2, 0x123414 },
	{ DSP563XX_R3, 0x1234ec },
	{ DSP563XX_R4, 0x1234eb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123415 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123415 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123415 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x115 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234eb },
	{ DSP563XX_R0, 0x123416 },
	{ DSP563XX_R1, 0x12349d },
	{ DSP563XX_R2, 0x123415 },
	{ DSP563XX_R3, 0x1234eb },
	{ DSP563XX_R4, 0x1234ea },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123416 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123416 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123416 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x116 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ea },
	{ DSP563XX_R0, 0x123417 },
	{ DSP563XX_R1, 0x12349e },
	{ DSP563XX_R2, 0x123416 },
	{ DSP563XX_R3, 0x1234ea },
	{ DSP563XX_R4, 0x1234e9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123417 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123417 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123417 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x117 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e9 },
	{ DSP563XX_R0, 0x123418 },
	{ DSP563XX_R1, 0x12349f },
	{ DSP563XX_R2, 0x123417 },
	{ DSP563XX_R3, 0x1234e9 },
	{ DSP563XX_R4, 0x1234e8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123418 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123418 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123418 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x118 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e8 },
	{ DSP563XX_R0, 0x123419 },
	{ DSP563XX_R1, 0x1234a0 },
	{ DSP563XX_R2, 0x123418 },
	{ DSP563XX_R3, 0x1234e8 },
	{ DSP563XX_R4, 0x1234e7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123419 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123419 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123419 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x119 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e7 },
	{ DSP563XX_R0, 0x12341a },
	{ DSP563XX_R1, 0x1234a1 },
	{ DSP563XX_R2, 0x123419 },
	{ DSP563XX_R3, 0x1234e7 },
	{ DSP563XX_R4, 0x1234e6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e6 },
	{ DSP563XX_R0, 0x12341b },
	{ DSP563XX_R1, 0x1234a2 },
	{ DSP563XX_R2, 0x12341a },
	{ DSP563XX_R3, 0x1234e6 },
	{ DSP563XX_R4, 0x1234e5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e5 },
	{ DSP563XX_R0, 0x12341c },
	{ DSP563XX_R1, 0x1234a3 },
	{ DSP563XX_R2, 0x12341b },
	{ DSP563XX_R3, 0x1234e5 },
	{ DSP563XX_R4, 0x1234e4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e4 },
	{ DSP563XX_R0, 0x12341d },
	{ DSP563XX_R1, 0x1234a4 },
	{ DSP563XX_R2, 0x12341c },
	{ DSP563XX_R3, 0x1234e4 },
	{ DSP563XX_R4, 0x1234e3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e3 },
	{ DSP563XX_R0, 0x12341e },
	{ DSP563XX_R1, 0x1234a5 },
	{ DSP563XX_R2, 0x12341d },
	{ DSP563XX_R3, 0x1234e3 },
	{ DSP563XX_R4, 0x1234e2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e2 },
	{ DSP563XX_R0, 0x12341f },
	{ DSP563XX_R1, 0x1234a6 },
	{ DSP563XX_R2, 0x12341e },
	{ DSP563XX_R3, 0x1234e2 },
	{ DSP563XX_R4, 0x1234e1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12341f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12341f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12341f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x11f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e1 },
	{ DSP563XX_R0, 0x123420 },
	{ DSP563XX_R1, 0x1234a7 },
	{ DSP563XX_R2, 0x12341f },
	{ DSP563XX_R3, 0x1234e1 },
	{ DSP563XX_R4, 0x1234e0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123420 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123420 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123420 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x120 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234e0 },
	{ DSP563XX_R0, 0x123421 },
	{ DSP563XX_R1, 0x1234a8 },
	{ DSP563XX_R2, 0x123420 },
	{ DSP563XX_R3, 0x1234e0 },
	{ DSP563XX_R4, 0x1234df },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123421 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123421 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123421 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x121 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234df },
	{ DSP563XX_R0, 0x123422 },
	{ DSP563XX_R1, 0x1234a9 },
	{ DSP563XX_R2, 0x123421 },
	{ DSP563XX_R3, 0x1234df },
	{ DSP563XX_R4, 0x1234de },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123422 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123422 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123422 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x122 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234de },
	{ DSP563XX_R0, 0x123423 },
	{ DSP563XX_R1, 0x1234aa },
	{ DSP563XX_R2, 0x123422 },
	{ DSP563XX_R3, 0x1234de },
	{ DSP563XX_R4, 0x1234dd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123423 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123423 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123423 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x123 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234dd },
	{ DSP563XX_R0, 0x123424 },
	{ DSP563XX_R1, 0x1234ab },
	{ DSP563XX_R2, 0x123423 },
	{ DSP563XX_R3, 0x1234dd },
	{ DSP563XX_R4, 0x1234dc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123424 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123424 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123424 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x124 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234dc },
	{ DSP563XX_R0, 0x123425 },
	{ DSP563XX_R1, 0x1234ac },
	{ DSP563XX_R2, 0x123424 },
	{ DSP563XX_R3, 0x1234dc },
	{ DSP563XX_R4, 0x1234db },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123425 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123425 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123425 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x125 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234db },
	{ DSP563XX_R0, 0x123426 },
	{ DSP563XX_R1, 0x1234ad },
	{ DSP563XX_R2, 0x123425 },
	{ DSP563XX_R3, 0x1234db },
	{ DSP563XX_R4, 0x1234da },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123426 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123426 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123426 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x126 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234da },
	{ DSP563XX_R0, 0x123427 },
	{ DSP563XX_R1, 0x1234ae },
	{ DSP563XX_R2, 0x123426 },
	{ DSP563XX_R3, 0x1234da },
	{ DSP563XX_R4, 0x1234d9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123427 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123427 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123427 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x127 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d9 },
	{ DSP563XX_R0, 0x123428 },
	{ DSP563XX_R1, 0x1234af },
	{ DSP563XX_R2, 0x123427 },
	{ DSP563XX_R3, 0x1234d9 },
	{ DSP563XX_R4, 0x1234d8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123428 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123428 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123428 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x128 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d8 },
	{ DSP563XX_R0, 0x123429 },
	{ DSP563XX_R1, 0x1234b0 },
	{ DSP563XX_R2, 0x123428 },
	{ DSP563XX_R3, 0x1234d8 },
	{ DSP563XX_R4, 0x1234d7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123429 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123429 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123429 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x129 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d7 },
	{ DSP563XX_R0, 0x12342a },
	{ DSP563XX_R1, 0x1234b1 },
	{ DSP563XX_R2, 0x123429 },
	{ DSP563XX_R3, 0x1234d7 },
	{ DSP563XX_R4, 0x1234d6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d6 },
	{ DSP563XX_R0, 0x12342b },
	{ DSP563XX_R1, 0x1234b2 },
	{ DSP563XX_R2, 0x12342a },
	{ DSP563XX_R3, 0x1234d6 },
	{ DSP563XX_R4, 0x1234d5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d5 },
	{ DSP563XX_R0, 0x12342c },
	{ DSP563XX_R1, 0x1234b3 },
	{ DSP563XX_R2, 0x12342b },
	{ DSP563XX_R3, 0x1234d5 },
	{ DSP563XX_R4, 0x1234d4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d4 },
	{ DSP563XX_R0, 0x12342d },
	{ DSP563XX_R1, 0x1234b4 },
	{ DSP563XX_R2, 0x12342c },
	{ DSP563XX_R3, 0x1234d4 },
	{ DSP563XX_R4, 0x1234d3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d3 },
	{ DSP563XX_R0, 0x12342e },
	{ DSP563XX_R1, 0x1234b5 },
	{ DSP563XX_R2, 0x12342d },
	{ DSP563XX_R3, 0x1234d3 },
	{ DSP563XX_R4, 0x1234d2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d2 },
	{ DSP563XX_R0, 0x12342f },
	{ DSP563XX_R1, 0x1234b6 },
	{ DSP563XX_R2, 0x12342e },
	{ DSP563XX_R3, 0x1234d2 },
	{ DSP563XX_R4, 0x1234d1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12342f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12342f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12342f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x12f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d1 },
	{ DSP563XX_R0, 0x123430 },
	{ DSP563XX_R1, 0x1234b7 },
	{ DSP563XX_R2, 0x12342f },
	{ DSP563XX_R3, 0x1234d1 },
	{ DSP563XX_R4, 0x1234d0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123430 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123430 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123430 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x130 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234d0 },
	{ DSP563XX_R0, 0x123431 },
	{ DSP563XX_R1, 0x1234b8 },
	{ DSP563XX_R2, 0x123430 },
	{ DSP563XX_R3, 0x1234d0 },
	{ DSP563XX_R4, 0x1234cf },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123431 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123431 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123431 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x131 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cf },
	{ DSP563XX_R0, 0x123432 },
	{ DSP563XX_R1, 0x1234b9 },
	{ DSP563XX_R2, 0x123431 },
	{ DSP563XX_R3, 0x1234cf },
	{ DSP563XX_R4, 0x1234ce },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123432 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123432 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123432 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x132 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ce },
	{ DSP563XX_R0, 0x123433 },
	{ DSP563XX_R1, 0x1234ba },
	{ DSP563XX_R2, 0x123432 },
	{ DSP563XX_R3, 0x1234ce },
	{ DSP563XX_R4, 0x1234cd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123433 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123433 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123433 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x133 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cd },
	{ DSP563XX_R0, 0x123434 },
	{ DSP563XX_R1, 0x1234bb },
	{ DSP563XX_R2, 0x123433 },
	{ DSP563XX_R3, 0x1234cd },
	{ DSP563XX_R4, 0x1234cc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123434 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123434 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123434 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x134 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cc },
	{ DSP563XX_R0, 0x123435 },
	{ DSP563XX_R1, 0x1234bc },
	{ DSP563XX_R2, 0x123434 },
	{ DSP563XX_R3, 0x1234cc },
	{ DSP563XX_R4, 0x1234cb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123435 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123435 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123435 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x135 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234cb },
	{ DSP563XX_R0, 0x123436 },
	{ DSP563XX_R1, 0x1234bd },
	{ DSP563XX_R2, 0x123435 },
	{ DSP563XX_R3, 0x1234cb },
	{ DSP563XX_R4, 0x1234ca },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123436 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123436 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123436 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x136 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ca },
	{ DSP563XX_R0, 0x123437 },
	{ DSP563XX_R1, 0x1234be },
	{ DSP563XX_R2, 0x123436 },
	{ DSP563XX_R3, 0x1234ca },
	{ DSP563XX_R4, 0x1234c9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123437 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123437 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123437 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x137 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c9 },
	{ DSP563XX_R0, 0x123438 },
	{ DSP563XX_R1, 0x1234bf },
	{ DSP563XX_R2, 0x123437 },
	{ DSP563XX_R3, 0x1234c9 },
	{ DSP563XX_R4, 0x1234c8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123438 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123438 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123438 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x138 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c8 },
	{ DSP563XX_R0, 0x123439 },
	{ DSP563XX_R1, 0x1234c0 },
	{ DSP563XX_R2, 0x123438 },
	{ DSP563XX_R3, 0x1234c8 },
	{ DSP563XX_R4, 0x1234c7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123439 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123439 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123439 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x139 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c7 },
	{ DSP563XX_R0, 0x12343a },
	{ DSP563XX_R1, 0x1234c1 },
	{ DSP563XX_R2, 0x123439 },
	{ DSP563XX_R3, 0x1234c7 },
	{ DSP563XX_R4, 0x1234c6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c6 },
	{ DSP563XX_R0, 0x12343b },
	{ DSP563XX_R1, 0x1234c2 },
	{ DSP563XX_R2, 0x12343a },
	{ DSP563XX_R3, 0x1234c6 },
	{ DSP563XX_R4, 0x1234c5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c5 },
	{ DSP563XX_R0, 0x12343c },
	{ DSP563XX_R1, 0x1234c3 },
	{ DSP563XX_R2, 0x12343b },
	{ DSP563XX_R3, 0x1234c5 },
	{ DSP563XX_R4, 0x1234c4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c4 },
	{ DSP563XX_R0, 0x12343d },
	{ DSP563XX_R1, 0x1234c4 },
	{ DSP563XX_R2, 0x12343c },
	{ DSP563XX_R3, 0x1234c4 },
	{ DSP563XX_R4, 0x1234c3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c3 },
	{ DSP563XX_R0, 0x12343e },
	{ DSP563XX_R1, 0x1234c5 },
	{ DSP563XX_R2, 0x12343d },
	{ DSP563XX_R3, 0x1234c3 },
	{ DSP563XX_R4, 0x1234c2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c2 },
	{ DSP563XX_R0, 0x12343f },
	{ DSP563XX_R1, 0x1234c6 },
	{ DSP563XX_R2, 0x12343e },
	{ DSP563XX_R3, 0x1234c2 },
	{ DSP563XX_R4, 0x1234c1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12343f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12343f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12343f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x13f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c1 },
	{ DSP563XX_R0, 0x123440 },
	{ DSP563XX_R1, 0x1234c7 },
	{ DSP563XX_R2, 0x12343f },
	{ DSP563XX_R3, 0x1234c1 },
	{ DSP563XX_R4, 0x1234c0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123440 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123440 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123440 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x140 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234c0 },
	{ DSP563XX_R0, 0x123441 },
	{ DSP563XX_R1, 0x1234c8 },
	{ DSP563XX_R2, 0x123440 },
	{ DSP563XX_R3, 0x1234c0 },
	{ DSP563XX_R4, 0x1234bf },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123441 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123441 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123441 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x141 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bf },
	{ DSP563XX_R0, 0x123442 },
	{ DSP563XX_R1, 0x1234c9 },
	{ DSP563XX_R2, 0x123441 },
	{ DSP563XX_R3, 0x1234bf },
	{ DSP563XX_R4, 0x1234be },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123442 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123442 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123442 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x142 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234be },
	{ DSP563XX_R0, 0x123443 },
	{ DSP563XX_R1, 0x1234ca },
	{ DSP563XX_R2, 0x123442 },
	{ DSP563XX_R3, 0x1234be },
	{ DSP563XX_R4, 0x1234bd },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123443 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123443 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123443 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x143 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bd },
	{ DSP563XX_R0, 0x123444 },
	{ DSP563XX_R1, 0x1234cb },
	{ DSP563XX_R2, 0x123443 },
	{ DSP563XX_R3, 0x1234bd },
	{ DSP563XX_R4, 0x1234bc },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123444 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123444 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123444 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x144 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bc },
	{ DSP563XX_R0, 0x123445 },
	{ DSP563XX_R1, 0x1234cc },
	{ DSP563XX_R2, 0x123444 },
	{ DSP563XX_R3, 0x1234bc },
	{ DSP563XX_R4, 0x1234bb },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123445 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123445 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123445 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x145 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234bb },
	{ DSP563XX_R0, 0x123446 },
	{ DSP563XX_R1, 0x1234cd },
	{ DSP563XX_R2, 0x123445 },
	{ DSP563XX_R3, 0x1234bb },
	{ DSP563XX_R4, 0x1234ba },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123446 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123446 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123446 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x146 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ba },
	{ DSP563XX_R0, 0x123447 },
	{ DSP563XX_R1, 0x1234ce },
	{ DSP563XX_R2, 0x123446 },
	{ DSP563XX_R3, 0x1234ba },
	{ DSP563XX_R4, 0x1234b9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123447 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123447 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123447 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x147 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b9 },
	{ DSP563XX_R0, 0x123448 },
	{ DSP563XX_R1, 0x1234cf },
	{ DSP563XX_R2, 0x123447 },
	{ DSP563XX_R3, 0x1234b9 },
	{ DSP563XX_R4, 0x1234b8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123448 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123448 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123448 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x148 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b8 },
	{ DSP563XX_R0, 0x123449 },
	{ DSP563XX_R1, 0x1234d0 },
	{ DSP563XX_R2, 0x123448 },
	{ DSP563XX_R3, 0x1234b8 },
	{ DSP563XX_R4, 0x1234b7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123449 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123449 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123449 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x149 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b7 },
	{ DSP563XX_R0, 0x12344a },
	{ DSP563XX_R1, 0x1234d1 },
	{ DSP563XX_R2, 0x123449 },
	{ DSP563XX_R3, 0x1234b7 },
	{ DSP563XX_R4, 0x1234b6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b6 },
	{ DSP563XX_R0, 0x12344b },
	{ DSP563XX_R1, 0x1234d2 },
	{ DSP563XX_R2, 0x12344a },
	{ DSP563XX_R3, 0x1234b6 },
	{ DSP563XX_R4, 0x1234b5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b5 },
	{ DSP563XX_R0, 0x12344c },
	{ DSP563XX_R1, 0x1234d3 },
	{ DSP563XX_R2, 0x12344b },
	{ DSP563XX_R3, 0x1234b5 },
	{ DSP563XX_R4, 0x1234b4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b4 },
	{ DSP563XX_R0, 0x12344d },
	{ DSP563XX_R1, 0x1234d4 },
	{ DSP563XX_R2, 0x12344c },
	{ DSP563XX_R3, 0x1234b4 },
	{ DSP563XX_R4, 0x1234b3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b3 },
	{ DSP563XX_R0, 0x12344e },
	{ DSP563XX_R1, 0x1234d5 },
	{ DSP563XX_R2, 0x12344d },
	{ DSP563XX_R3, 0x1234b3 },
	{ DSP563XX_R4, 0x1234b2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b2 },
	{ DSP563XX_R0, 0x12344f },
	{ DSP563XX_R1, 0x1234d6 },
	{ DSP563XX_R2, 0x12344e },
	{ DSP563XX_R3, 0x1234b2 },
	{ DSP563XX_R4, 0x1234b1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12344f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12344f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12344f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x14f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b1 },
	{ DSP563XX_R0, 0x123450 },
	{ DSP563XX_R1, 0x1234d7 },
	{ DSP563XX_R2, 0x12344f },
	{ DSP563XX_R3, 0x1234b1 },
	{ DSP563XX_R4, 0x1234b0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123450 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123450 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123450 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x150 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234b0 },
	{ DSP563XX_R0, 0x123451 },
	{ DSP563XX_R1, 0x1234d8 },
	{ DSP563XX_R2, 0x123450 },
	{ DSP563XX_R3, 0x1234b0 },
	{ DSP563XX_R4, 0x1234af },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123451 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123451 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123451 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x151 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234af },
	{ DSP563XX_R0, 0x123452 },
	{ DSP563XX_R1, 0x1234d9 },
	{ DSP563XX_R2, 0x123451 },
	{ DSP563XX_R3, 0x1234af },
	{ DSP563XX_R4, 0x1234ae },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123452 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123452 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123452 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x152 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ae },
	{ DSP563XX_R0, 0x123453 },
	{ DSP563XX_R1, 0x1234da },
	{ DSP563XX_R2, 0x123452 },
	{ DSP563XX_R3, 0x1234ae },
	{ DSP563XX_R4, 0x1234ad },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123453 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123453 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123453 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x153 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ad },
	{ DSP563XX_R0, 0x123454 },
	{ DSP563XX_R1, 0x1234db },
	{ DSP563XX_R2, 0x123453 },
	{ DSP563XX_R3, 0x1234ad },
	{ DSP563XX_R4, 0x1234ac },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123454 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123454 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123454 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x154 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ac },
	{ DSP563XX_R0, 0x123455 },
	{ DSP563XX_R1, 0x1234dc },
	{ DSP563XX_R2, 0x123454 },
	{ DSP563XX_R3, 0x1234ac },
	{ DSP563XX_R4, 0x1234ab },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123455 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123455 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123455 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x155 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234ab },
	{ DSP563XX_R0, 0x123456 },
	{ DSP563XX_R1, 0x1234dd },
	{ DSP563XX_R2, 0x123455 },
	{ DSP563XX_R3, 0x1234ab },
	{ DSP563XX_R4, 0x1234aa },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123456 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123456 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123456 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x156 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234aa },
	{ DSP563XX_R0, 0x123457 },
	{ DSP563XX_R1, 0x1234de },
	{ DSP563XX_R2, 0x123456 },
	{ DSP563XX_R3, 0x1234aa },
	{ DSP563XX_R4, 0x1234a9 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123457 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123457 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123457 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x157 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a9 },
	{ DSP563XX_R0, 0x123458 },
	{ DSP563XX_R1, 0x1234df },
	{ DSP563XX_R2, 0x123457 },
	{ DSP563XX_R3, 0x1234a9 },
	{ DSP563XX_R4, 0x1234a8 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123458 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123458 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123458 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x158 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a8 },
	{ DSP563XX_R0, 0x123459 },
	{ DSP563XX_R1, 0x1234e0 },
	{ DSP563XX_R2, 0x123458 },
	{ DSP563XX_R3, 0x1234a8 },
	{ DSP563XX_R4, 0x1234a7 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123459 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123459 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123459 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x159 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a7 },
	{ DSP563XX_R0, 0x12345a },
	{ DSP563XX_R1, 0x1234e1 },
	{ DSP563XX_R2, 0x123459 },
	{ DSP563XX_R3, 0x1234a7 },
	{ DSP563XX_R4, 0x1234a6 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a6 },
	{ DSP563XX_R0, 0x12345b },
	{ DSP563XX_R1, 0x1234e2 },
	{ DSP563XX_R2, 0x12345a },
	{ DSP563XX_R3, 0x1234a6 },
	{ DSP563XX_R4, 0x1234a5 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a5 },
	{ DSP563XX_R0, 0x12345c },
	{ DSP563XX_R1, 0x1234e3 },
	{ DSP563XX_R2, 0x12345b },
	{ DSP563XX_R3, 0x1234a5 },
	{ DSP563XX_R4, 0x1234a4 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a4 },
	{ DSP563XX_R0, 0x12345d },
	{ DSP563XX_R1, 0x1234e4 },
	{ DSP563XX_R2, 0x12345c },
	{ DSP563XX_R3, 0x1234a4 },
	{ DSP563XX_R4, 0x1234a3 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a3 },
	{ DSP563XX_R0, 0x12345e },
	{ DSP563XX_R1, 0x1234e5 },
	{ DSP563XX_R2, 0x12345d },
	{ DSP563XX_R3, 0x1234a3 },
	{ DSP563XX_R4, 0x1234a2 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a2 },
	{ DSP563XX_R0, 0x12345f },
	{ DSP563XX_R1, 0x1234e6 },
	{ DSP563XX_R2, 0x12345e },
	{ DSP563XX_R3, 0x1234a2 },
	{ DSP563XX_R4, 0x1234a1 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12345f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12345f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12345f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x15f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a1 },
	{ DSP563XX_R0, 0x123460 },
	{ DSP563XX_R1, 0x1234e7 },
	{ DSP563XX_R2, 0x12345f },
	{ DSP563XX_R3, 0x1234a1 },
	{ DSP563XX_R4, 0x1234a0 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123460 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123460 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123460 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x160 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x1234a0 },
	{ DSP563XX_R0, 0x123461 },
	{ DSP563XX_R1, 0x1234e8 },
	{ DSP563XX_R2, 0x123460 },
	{ DSP563XX_R3, 0x1234a0 },
	{ DSP563XX_R4, 0x12349f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123461 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123461 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123461 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x161 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349f },
	{ DSP563XX_R0, 0x123462 },
	{ DSP563XX_R1, 0x1234e9 },
	{ DSP563XX_R2, 0x123461 },
	{ DSP563XX_R3, 0x12349f },
	{ DSP563XX_R4, 0x12349e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123462 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123462 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123462 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x162 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349e },
	{ DSP563XX_R0, 0x123463 },
	{ DSP563XX_R1, 0x1234ea },
	{ DSP563XX_R2, 0x123462 },
	{ DSP563XX_R3, 0x12349e },
	{ DSP563XX_R4, 0x12349d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123463 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123463 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123463 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x163 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349d },
	{ DSP563XX_R0, 0x123464 },
	{ DSP563XX_R1, 0x1234eb },
	{ DSP563XX_R2, 0x123463 },
	{ DSP563XX_R3, 0x12349d },
	{ DSP563XX_R4, 0x12349c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123464 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123464 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123464 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x164 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349c },
	{ DSP563XX_R0, 0x123465 },
	{ DSP563XX_R1, 0x1234ec },
	{ DSP563XX_R2, 0x123464 },
	{ DSP563XX_R3, 0x12349c },
	{ DSP563XX_R4, 0x12349b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123465 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123465 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123465 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x165 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349b },
	{ DSP563XX_R0, 0x123466 },
	{ DSP563XX_R1, 0x1234ed },
	{ DSP563XX_R2, 0x123465 },
	{ DSP563XX_R3, 0x12349b },
	{ DSP563XX_R4, 0x12349a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123466 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123466 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123466 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x166 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12349a },
	{ DSP563XX_R0, 0x123467 },
	{ DSP563XX_R1, 0x1234ee },
	{ DSP563XX_R2, 0x123466 },
	{ DSP563XX_R3, 0x12349a },
	{ DSP563XX_R4, 0x123499 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123467 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123467 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123467 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x167 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123499 },
	{ DSP563XX_R0, 0x123468 },
	{ DSP563XX_R1, 0x1234ef },
	{ DSP563XX_R2, 0x123467 },
	{ DSP563XX_R3, 0x123499 },
	{ DSP563XX_R4, 0x123498 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123468 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123468 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123468 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x168 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123498 },
	{ DSP563XX_R0, 0x123469 },
	{ DSP563XX_R1, 0x1234f0 },
	{ DSP563XX_R2, 0x123468 },
	{ DSP563XX_R3, 0x123498 },
	{ DSP563XX_R4, 0x123497 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123469 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123469 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123469 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x169 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123497 },
	{ DSP563XX_R0, 0x12346a },
	{ DSP563XX_R1, 0x1234f1 },
	{ DSP563XX_R2, 0x123469 },
	{ DSP563XX_R3, 0x123497 },
	{ DSP563XX_R4, 0x123496 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123496 },
	{ DSP563XX_R0, 0x12346b },
	{ DSP563XX_R1, 0x1234f2 },
	{ DSP563XX_R2, 0x12346a },
	{ DSP563XX_R3, 0x123496 },
	{ DSP563XX_R4, 0x123495 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123495 },
	{ DSP563XX_R0, 0x12346c },
	{ DSP563XX_R1, 0x1234f3 },
	{ DSP563XX_R2, 0x12346b },
	{ DSP563XX_R3, 0x123495 },
	{ DSP563XX_R4, 0x123494 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123494 },
	{ DSP563XX_R0, 0x12346d },
	{ DSP563XX_R1, 0x1234f4 },
	{ DSP563XX_R2, 0x12346c },
	{ DSP563XX_R3, 0x123494 },
	{ DSP563XX_R4, 0x123493 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123493 },
	{ DSP563XX_R0, 0x12346e },
	{ DSP563XX_R1, 0x1234f5 },
	{ DSP563XX_R2, 0x12346d },
	{ DSP563XX_R3, 0x123493 },
	{ DSP563XX_R4, 0x123492 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123492 },
	{ DSP563XX_R0, 0x12346f },
	{ DSP563XX_R1, 0x1234f6 },
	{ DSP563XX_R2, 0x12346e },
	{ DSP563XX_R3, 0x123492 },
	{ DSP563XX_R4, 0x123491 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12346f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12346f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12346f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x16f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123491 },
	{ DSP563XX_R0, 0x123470 },
	{ DSP563XX_R1, 0x1234f7 },
	{ DSP563XX_R2, 0x12346f },
	{ DSP563XX_R3, 0x123491 },
	{ DSP563XX_R4, 0x123490 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123470 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123470 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123470 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x170 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123490 },
	{ DSP563XX_R0, 0x123471 },
	{ DSP563XX_R1, 0x1234f8 },
	{ DSP563XX_R2, 0x123470 },
	{ DSP563XX_R3, 0x123490 },
	{ DSP563XX_R4, 0x12348f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123471 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123471 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123471 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x171 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348f },
	{ DSP563XX_R0, 0x123472 },
	{ DSP563XX_R1, 0x1234f9 },
	{ DSP563XX_R2, 0x123471 },
	{ DSP563XX_R3, 0x12348f },
	{ DSP563XX_R4, 0x12348e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123472 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123472 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123472 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x172 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348e },
	{ DSP563XX_R0, 0x123473 },
	{ DSP563XX_R1, 0x1234fa },
	{ DSP563XX_R2, 0x123472 },
	{ DSP563XX_R3, 0x12348e },
	{ DSP563XX_R4, 0x12348d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123473 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123473 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123473 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x173 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348d },
	{ DSP563XX_R0, 0x123474 },
	{ DSP563XX_R1, 0x1234fb },
	{ DSP563XX_R2, 0x123473 },
	{ DSP563XX_R3, 0x12348d },
	{ DSP563XX_R4, 0x12348c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123474 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123474 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123474 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x174 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348c },
	{ DSP563XX_R0, 0x123475 },
	{ DSP563XX_R1, 0x1234fc },
	{ DSP563XX_R2, 0x123474 },
	{ DSP563XX_R3, 0x12348c },
	{ DSP563XX_R4, 0x12348b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123475 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123475 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123475 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x175 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348b },
	{ DSP563XX_R0, 0x123476 },
	{ DSP563XX_R1, 0x1234fd },
	{ DSP563XX_R2, 0x123475 },
	{ DSP563XX_R3, 0x12348b },
	{ DSP563XX_R4, 0x12348a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123476 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123476 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123476 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x176 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12348a },
	{ DSP563XX_R0, 0x123477 },
	{ DSP563XX_R1, 0x1234fe },
	{ DSP563XX_R2, 0x123476 },
	{ DSP563XX_R3, 0x12348a },
	{ DSP563XX_R4, 0x123489 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123477 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123477 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123477 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x177 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123489 },
	{ DSP563XX_R0, 0x123478 },
	{ DSP563XX_R1, 0x1234ff },
	{ DSP563XX_R2, 0x123477 },
	{ DSP563XX_R3, 0x123489 },
	{ DSP563XX_R4, 0x123488 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123478 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123478 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123478 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x178 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123488 },
	{ DSP563XX_R0, 0x123479 },
	{ DSP563XX_R1, 0x123400 },
	{ DSP563XX_R2, 0x123478 },
	{ DSP563XX_R3, 0x123488 },
	{ DSP563XX_R4, 0x123487 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123479 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123479 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123479 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x179 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123487 },
	{ DSP563XX_R0, 0x12347a },
	{ DSP563XX_R1, 0x123401 },
	{ DSP563XX_R2, 0x123479 },
	{ DSP563XX_R3, 0x123487 },
	{ DSP563XX_R4, 0x123486 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123486 },
	{ DSP563XX_R0, 0x12347b },
	{ DSP563XX_R1, 0x123402 },
	{ DSP563XX_R2, 0x12347a },
	{ DSP563XX_R3, 0x123486 },
	{ DSP563XX_R4, 0x123485 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123485 },
	{ DSP563XX_R0, 0x12347c },
	{ DSP563XX_R1, 0x123403 },
	{ DSP563XX_R2, 0x12347b },
	{ DSP563XX_R3, 0x123485 },
	{ DSP563XX_R4, 0x123484 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123484 },
	{ DSP563XX_R0, 0x12347d },
	{ DSP563XX_R1, 0x123404 },
	{ DSP563XX_R2, 0x12347c },
	{ DSP563XX_R3, 0x123484 },
	{ DSP563XX_R4, 0x123483 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123483 },
	{ DSP563XX_R0, 0x12347e },
	{ DSP563XX_R1, 0x123405 },
	{ DSP563XX_R2, 0x12347d },
	{ DSP563XX_R3, 0x123483 },
	{ DSP563XX_R4, 0x123482 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123482 },
	{ DSP563XX_R0, 0x12347f },
	{ DSP563XX_R1, 0x123406 },
	{ DSP563XX_R2, 0x12347e },
	{ DSP563XX_R3, 0x123482 },
	{ DSP563XX_R4, 0x123481 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12347f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12347f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12347f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x17f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123481 },
	{ DSP563XX_R0, 0x123480 },
	{ DSP563XX_R1, 0x123407 },
	{ DSP563XX_R2, 0x12347f },
	{ DSP563XX_R3, 0x123481 },
	{ DSP563XX_R4, 0x123480 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123480 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123480 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123480 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x180 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123480 },
	{ DSP563XX_R0, 0x123481 },
	{ DSP563XX_R1, 0x123408 },
	{ DSP563XX_R2, 0x123480 },
	{ DSP563XX_R3, 0x123480 },
	{ DSP563XX_R4, 0x12347f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123481 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123481 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123481 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x181 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347f },
	{ DSP563XX_R0, 0x123482 },
	{ DSP563XX_R1, 0x123409 },
	{ DSP563XX_R2, 0x123481 },
	{ DSP563XX_R3, 0x12347f },
	{ DSP563XX_R4, 0x12347e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123482 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123482 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123482 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x182 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347e },
	{ DSP563XX_R0, 0x123483 },
	{ DSP563XX_R1, 0x12340a },
	{ DSP563XX_R2, 0x123482 },
	{ DSP563XX_R3, 0x12347e },
	{ DSP563XX_R4, 0x12347d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123483 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123483 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123483 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x183 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347d },
	{ DSP563XX_R0, 0x123484 },
	{ DSP563XX_R1, 0x12340b },
	{ DSP563XX_R2, 0x123483 },
	{ DSP563XX_R3, 0x12347d },
	{ DSP563XX_R4, 0x12347c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123484 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123484 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123484 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x184 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347c },
	{ DSP563XX_R0, 0x123485 },
	{ DSP563XX_R1, 0x12340c },
	{ DSP563XX_R2, 0x123484 },
	{ DSP563XX_R3, 0x12347c },
	{ DSP563XX_R4, 0x12347b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123485 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123485 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123485 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x185 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347b },
	{ DSP563XX_R0, 0x123486 },
	{ DSP563XX_R1, 0x12340d },
	{ DSP563XX_R2, 0x123485 },
	{ DSP563XX_R3, 0x12347b },
	{ DSP563XX_R4, 0x12347a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123486 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123486 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123486 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x186 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12347a },
	{ DSP563XX_R0, 0x123487 },
	{ DSP563XX_R1, 0x12340e },
	{ DSP563XX_R2, 0x123486 },
	{ DSP563XX_R3, 0x12347a },
	{ DSP563XX_R4, 0x123479 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123487 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123487 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123487 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x187 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123479 },
	{ DSP563XX_R0, 0x123488 },
	{ DSP563XX_R1, 0x12340f },
	{ DSP563XX_R2, 0x123487 },
	{ DSP563XX_R3, 0x123479 },
	{ DSP563XX_R4, 0x123478 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123488 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123488 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123488 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x188 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123478 },
	{ DSP563XX_R0, 0x123489 },
	{ DSP563XX_R1, 0x123410 },
	{ DSP563XX_R2, 0x123488 },
	{ DSP563XX_R3, 0x123478 },
	{ DSP563XX_R4, 0x123477 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123489 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123489 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123489 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x189 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123477 },
	{ DSP563XX_R0, 0x12348a },
	{ DSP563XX_R1, 0x123411 },
	{ DSP563XX_R2, 0x123489 },
	{ DSP563XX_R3, 0x123477 },
	{ DSP563XX_R4, 0x123476 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123476 },
	{ DSP563XX_R0, 0x12348b },
	{ DSP563XX_R1, 0x123412 },
	{ DSP563XX_R2, 0x12348a },
	{ DSP563XX_R3, 0x123476 },
	{ DSP563XX_R4, 0x123475 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123475 },
	{ DSP563XX_R0, 0x12348c },
	{ DSP563XX_R1, 0x123413 },
	{ DSP563XX_R2, 0x12348b },
	{ DSP563XX_R3, 0x123475 },
	{ DSP563XX_R4, 0x123474 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123474 },
	{ DSP563XX_R0, 0x12348d },
	{ DSP563XX_R1, 0x123414 },
	{ DSP563XX_R2, 0x12348c },
	{ DSP563XX_R3, 0x123474 },
	{ DSP563XX_R4, 0x123473 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123473 },
	{ DSP563XX_R0, 0x12348e },
	{ DSP563XX_R1, 0x123415 },
	{ DSP563XX_R2, 0x12348d },
	{ DSP563XX_R3, 0x123473 },
	{ DSP563XX_R4, 0x123472 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123472 },
	{ DSP563XX_R0, 0x12348f },
	{ DSP563XX_R1, 0x123416 },
	{ DSP563XX_R2, 0x12348e },
	{ DSP563XX_R3, 0x123472 },
	{ DSP563XX_R4, 0x123471 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12348f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12348f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12348f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x18f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123471 },
	{ DSP563XX_R0, 0x123490 },
	{ DSP563XX_R1, 0x123417 },
	{ DSP563XX_R2, 0x12348f },
	{ DSP563XX_R3, 0x123471 },
	{ DSP563XX_R4, 0x123470 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123490 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123490 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123490 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x190 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123470 },
	{ DSP563XX_R0, 0x123491 },
	{ DSP563XX_R1, 0x123418 },
	{ DSP563XX_R2, 0x123490 },
	{ DSP563XX_R3, 0x123470 },
	{ DSP563XX_R4, 0x12346f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123491 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123491 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123491 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x191 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346f },
	{ DSP563XX_R0, 0x123492 },
	{ DSP563XX_R1, 0x123419 },
	{ DSP563XX_R2, 0x123491 },
	{ DSP563XX_R3, 0x12346f },
	{ DSP563XX_R4, 0x12346e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123492 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123492 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123492 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x192 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346e },
	{ DSP563XX_R0, 0x123493 },
	{ DSP563XX_R1, 0x12341a },
	{ DSP563XX_R2, 0x123492 },
	{ DSP563XX_R3, 0x12346e },
	{ DSP563XX_R4, 0x12346d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123493 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123493 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123493 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x193 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346d },
	{ DSP563XX_R0, 0x123494 },
	{ DSP563XX_R1, 0x12341b },
	{ DSP563XX_R2, 0x123493 },
	{ DSP563XX_R3, 0x12346d },
	{ DSP563XX_R4, 0x12346c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123494 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123494 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123494 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x194 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346c },
	{ DSP563XX_R0, 0x123495 },
	{ DSP563XX_R1, 0x12341c },
	{ DSP563XX_R2, 0x123494 },
	{ DSP563XX_R3, 0x12346c },
	{ DSP563XX_R4, 0x12346b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123495 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123495 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123495 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x195 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346b },
	{ DSP563XX_R0, 0x123496 },
	{ DSP563XX_R1, 0x12341d },
	{ DSP563XX_R2, 0x123495 },
	{ DSP563XX_R3, 0x12346b },
	{ DSP563XX_R4, 0x12346a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123496 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123496 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123496 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x196 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12346a },
	{ DSP563XX_R0, 0x123497 },
	{ DSP563XX_R1, 0x12341e },
	{ DSP563XX_R2, 0x123496 },
	{ DSP563XX_R3, 0x12346a },
	{ DSP563XX_R4, 0x123469 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123497 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123497 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123497 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x197 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123469 },
	{ DSP563XX_R0, 0x123498 },
	{ DSP563XX_R1, 0x12341f },
	{ DSP563XX_R2, 0x123497 },
	{ DSP563XX_R3, 0x123469 },
	{ DSP563XX_R4, 0x123468 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123498 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123498 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123498 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x198 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123468 },
	{ DSP563XX_R0, 0x123499 },
	{ DSP563XX_R1, 0x123420 },
	{ DSP563XX_R2, 0x123498 },
	{ DSP563XX_R3, 0x123468 },
	{ DSP563XX_R4, 0x123467 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x123499 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x123499 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x123499 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x199 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123467 },
	{ DSP563XX_R0, 0x12349a },
	{ DSP563XX_R1, 0x123421 },
	{ DSP563XX_R2, 0x123499 },
	{ DSP563XX_R3, 0x123467 },
	{ DSP563XX_R4, 0x123466 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349a },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349a },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349a },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19a },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123466 },
	{ DSP563XX_R0, 0x12349b },
	{ DSP563XX_R1, 0x123422 },
	{ DSP563XX_R2, 0x12349a },
	{ DSP563XX_R3, 0x123466 },
	{ DSP563XX_R4, 0x123465 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349b },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349b },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349b },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19b },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123465 },
	{ DSP563XX_R0, 0x12349c },
	{ DSP563XX_R1, 0x123423 },
	{ DSP563XX_R2, 0x12349b },
	{ DSP563XX_R3, 0x123465 },
	{ DSP563XX_R4, 0x123464 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349c },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349c },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349c },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19c },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123464 },
	{ DSP563XX_R0, 0x12349d },
	{ DSP563XX_R1, 0x123424 },
	{ DSP563XX_R2, 0x12349c },
	{ DSP563XX_R3, 0x123464 },
	{ DSP563XX_R4, 0x123463 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349d },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349d },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349d },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19d },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123463 },
	{ DSP563XX_R0, 0x12349e },
	{ DSP563XX_R1, 0x123425 },
	{ DSP563XX_R2, 0x12349d },
	{ DSP563XX_R3, 0x123463 },
	{ DSP563XX_R4, 0x123462 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349e },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349e },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349e },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19e },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123462 },
	{ DSP563XX_R0, 0x12349f },
	{ DSP563XX_R1, 0x123426 },
	{ DSP563XX_R2, 0x12349e },
	{ DSP563XX_R3, 0x123462 },
	{ DSP563XX_R4, 0x123461 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x12349f },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x12349f },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x12349f },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x19f },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123461 },
	{ DSP563XX_R0, 0x1234a0 },
	{ DSP563XX_R1, 0x123427 },
	{ DSP563XX_R2, 0x12349f },
	{ DSP563XX_R3, 0x123461 },
	{ DSP563XX_R4, 0x123460 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123460 },
	{ DSP563XX_R0, 0x1234a1 },
	{ DSP563XX_R1, 0x123428 },
	{ DSP563XX_R2, 0x1234a0 },
	{ DSP563XX_R3, 0x123460 },
	{ DSP563XX_R4, 0x12345f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345f },
	{ DSP563XX_R0, 0x1234a2 },
	{ DSP563XX_R1, 0x123429 },
	{ DSP563XX_R2, 0x1234a1 },
	{ DSP563XX_R3, 0x12345f },
	{ DSP563XX_R4, 0x12345e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345e },
	{ DSP563XX_R0, 0x1234a3 },
	{ DSP563XX_R1, 0x12342a },
	{ DSP563XX_R2, 0x1234a2 },
	{ DSP563XX_R3, 0x12345e },
	{ DSP563XX_R4, 0x12345d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345d },
	{ DSP563XX_R0, 0x1234a4 },
	{ DSP563XX_R1, 0x12342b },
	{ DSP563XX_R2, 0x1234a3 },
	{ DSP563XX_R3, 0x12345d },
	{ DSP563XX_R4, 0x12345c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345c },
	{ DSP563XX_R0, 0x1234a5 },
	{ DSP563XX_R1, 0x12342c },
	{ DSP563XX_R2, 0x1234a4 },
	{ DSP563XX_R3, 0x12345c },
	{ DSP563XX_R4, 0x12345b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345b },
	{ DSP563XX_R0, 0x1234a6 },
	{ DSP563XX_R1, 0x12342d },
	{ DSP563XX_R2, 0x1234a5 },
	{ DSP563XX_R3, 0x12345b },
	{ DSP563XX_R4, 0x12345a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12345a },
	{ DSP563XX_R0, 0x1234a7 },
	{ DSP563XX_R1, 0x12342e },
	{ DSP563XX_R2, 0x1234a6 },
	{ DSP563XX_R3, 0x12345a },
	{ DSP563XX_R4, 0x123459 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123459 },
	{ DSP563XX_R0, 0x1234a8 },
	{ DSP563XX_R1, 0x12342f },
	{ DSP563XX_R2, 0x1234a7 },
	{ DSP563XX_R3, 0x123459 },
	{ DSP563XX_R4, 0x123458 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123458 },
	{ DSP563XX_R0, 0x1234a9 },
	{ DSP563XX_R1, 0x123430 },
	{ DSP563XX_R2, 0x1234a8 },
	{ DSP563XX_R3, 0x123458 },
	{ DSP563XX_R4, 0x123457 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234a9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234a9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234a9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1a9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123457 },
	{ DSP563XX_R0, 0x1234aa },
	{ DSP563XX_R1, 0x123431 },
	{ DSP563XX_R2, 0x1234a9 },
	{ DSP563XX_R3, 0x123457 },
	{ DSP563XX_R4, 0x123456 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234aa },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234aa },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234aa },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1aa },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123456 },
	{ DSP563XX_R0, 0x1234ab },
	{ DSP563XX_R1, 0x123432 },
	{ DSP563XX_R2, 0x1234aa },
	{ DSP563XX_R3, 0x123456 },
	{ DSP563XX_R4, 0x123455 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ab },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ab },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ab },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ab },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123455 },
	{ DSP563XX_R0, 0x1234ac },
	{ DSP563XX_R1, 0x123433 },
	{ DSP563XX_R2, 0x1234ab },
	{ DSP563XX_R3, 0x123455 },
	{ DSP563XX_R4, 0x123454 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ac },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ac },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ac },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ac },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123454 },
	{ DSP563XX_R0, 0x1234ad },
	{ DSP563XX_R1, 0x123434 },
	{ DSP563XX_R2, 0x1234ac },
	{ DSP563XX_R3, 0x123454 },
	{ DSP563XX_R4, 0x123453 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ad },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ad },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ad },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ad },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123453 },
	{ DSP563XX_R0, 0x1234ae },
	{ DSP563XX_R1, 0x123435 },
	{ DSP563XX_R2, 0x1234ad },
	{ DSP563XX_R3, 0x123453 },
	{ DSP563XX_R4, 0x123452 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ae },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ae },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ae },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ae },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123452 },
	{ DSP563XX_R0, 0x1234af },
	{ DSP563XX_R1, 0x123436 },
	{ DSP563XX_R2, 0x1234ae },
	{ DSP563XX_R3, 0x123452 },
	{ DSP563XX_R4, 0x123451 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234af },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234af },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234af },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1af },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123451 },
	{ DSP563XX_R0, 0x1234b0 },
	{ DSP563XX_R1, 0x123437 },
	{ DSP563XX_R2, 0x1234af },
	{ DSP563XX_R3, 0x123451 },
	{ DSP563XX_R4, 0x123450 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123450 },
	{ DSP563XX_R0, 0x1234b1 },
	{ DSP563XX_R1, 0x123438 },
	{ DSP563XX_R2, 0x1234b0 },
	{ DSP563XX_R3, 0x123450 },
	{ DSP563XX_R4, 0x12344f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344f },
	{ DSP563XX_R0, 0x1234b2 },
	{ DSP563XX_R1, 0x123439 },
	{ DSP563XX_R2, 0x1234b1 },
	{ DSP563XX_R3, 0x12344f },
	{ DSP563XX_R4, 0x12344e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344e },
	{ DSP563XX_R0, 0x1234b3 },
	{ DSP563XX_R1, 0x12343a },
	{ DSP563XX_R2, 0x1234b2 },
	{ DSP563XX_R3, 0x12344e },
	{ DSP563XX_R4, 0x12344d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344d },
	{ DSP563XX_R0, 0x1234b4 },
	{ DSP563XX_R1, 0x12343b },
	{ DSP563XX_R2, 0x1234b3 },
	{ DSP563XX_R3, 0x12344d },
	{ DSP563XX_R4, 0x12344c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344c },
	{ DSP563XX_R0, 0x1234b5 },
	{ DSP563XX_R1, 0x12343c },
	{ DSP563XX_R2, 0x1234b4 },
	{ DSP563XX_R3, 0x12344c },
	{ DSP563XX_R4, 0x12344b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344b },
	{ DSP563XX_R0, 0x1234b6 },
	{ DSP563XX_R1, 0x12343d },
	{ DSP563XX_R2, 0x1234b5 },
	{ DSP563XX_R3, 0x12344b },
	{ DSP563XX_R4, 0x12344a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12344a },
	{ DSP563XX_R0, 0x1234b7 },
	{ DSP563XX_R1, 0x12343e },
	{ DSP563XX_R2, 0x1234b6 },
	{ DSP563XX_R3, 0x12344a },
	{ DSP563XX_R4, 0x123449 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123449 },
	{ DSP563XX_R0, 0x1234b8 },
	{ DSP563XX_R1, 0x12343f },
	{ DSP563XX_R2, 0x1234b7 },
	{ DSP563XX_R3, 0x123449 },
	{ DSP563XX_R4, 0x123448 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123448 },
	{ DSP563XX_R0, 0x1234b9 },
	{ DSP563XX_R1, 0x123440 },
	{ DSP563XX_R2, 0x1234b8 },
	{ DSP563XX_R3, 0x123448 },
	{ DSP563XX_R4, 0x123447 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234b9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234b9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234b9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1b9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123447 },
	{ DSP563XX_R0, 0x1234ba },
	{ DSP563XX_R1, 0x123441 },
	{ DSP563XX_R2, 0x1234b9 },
	{ DSP563XX_R3, 0x123447 },
	{ DSP563XX_R4, 0x123446 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ba },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ba },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ba },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ba },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123446 },
	{ DSP563XX_R0, 0x1234bb },
	{ DSP563XX_R1, 0x123442 },
	{ DSP563XX_R2, 0x1234ba },
	{ DSP563XX_R3, 0x123446 },
	{ DSP563XX_R4, 0x123445 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1bb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123445 },
	{ DSP563XX_R0, 0x1234bc },
	{ DSP563XX_R1, 0x123443 },
	{ DSP563XX_R2, 0x1234bb },
	{ DSP563XX_R3, 0x123445 },
	{ DSP563XX_R4, 0x123444 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1bc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123444 },
	{ DSP563XX_R0, 0x1234bd },
	{ DSP563XX_R1, 0x123444 },
	{ DSP563XX_R2, 0x1234bc },
	{ DSP563XX_R3, 0x123444 },
	{ DSP563XX_R4, 0x123443 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1bd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123443 },
	{ DSP563XX_R0, 0x1234be },
	{ DSP563XX_R1, 0x123445 },
	{ DSP563XX_R2, 0x1234bd },
	{ DSP563XX_R3, 0x123443 },
	{ DSP563XX_R4, 0x123442 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234be },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234be },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234be },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1be },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123442 },
	{ DSP563XX_R0, 0x1234bf },
	{ DSP563XX_R1, 0x123446 },
	{ DSP563XX_R2, 0x1234be },
	{ DSP563XX_R3, 0x123442 },
	{ DSP563XX_R4, 0x123441 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234bf },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234bf },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234bf },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1bf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123441 },
	{ DSP563XX_R0, 0x1234c0 },
	{ DSP563XX_R1, 0x123447 },
	{ DSP563XX_R2, 0x1234bf },
	{ DSP563XX_R3, 0x123441 },
	{ DSP563XX_R4, 0x123440 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123440 },
	{ DSP563XX_R0, 0x1234c1 },
	{ DSP563XX_R1, 0x123448 },
	{ DSP563XX_R2, 0x1234c0 },
	{ DSP563XX_R3, 0x123440 },
	{ DSP563XX_R4, 0x12343f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343f },
	{ DSP563XX_R0, 0x1234c2 },
	{ DSP563XX_R1, 0x123449 },
	{ DSP563XX_R2, 0x1234c1 },
	{ DSP563XX_R3, 0x12343f },
	{ DSP563XX_R4, 0x12343e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343e },
	{ DSP563XX_R0, 0x1234c3 },
	{ DSP563XX_R1, 0x12344a },
	{ DSP563XX_R2, 0x1234c2 },
	{ DSP563XX_R3, 0x12343e },
	{ DSP563XX_R4, 0x12343d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343d },
	{ DSP563XX_R0, 0x1234c4 },
	{ DSP563XX_R1, 0x12344b },
	{ DSP563XX_R2, 0x1234c3 },
	{ DSP563XX_R3, 0x12343d },
	{ DSP563XX_R4, 0x12343c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343c },
	{ DSP563XX_R0, 0x1234c5 },
	{ DSP563XX_R1, 0x12344c },
	{ DSP563XX_R2, 0x1234c4 },
	{ DSP563XX_R3, 0x12343c },
	{ DSP563XX_R4, 0x12343b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343b },
	{ DSP563XX_R0, 0x1234c6 },
	{ DSP563XX_R1, 0x12344d },
	{ DSP563XX_R2, 0x1234c5 },
	{ DSP563XX_R3, 0x12343b },
	{ DSP563XX_R4, 0x12343a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12343a },
	{ DSP563XX_R0, 0x1234c7 },
	{ DSP563XX_R1, 0x12344e },
	{ DSP563XX_R2, 0x1234c6 },
	{ DSP563XX_R3, 0x12343a },
	{ DSP563XX_R4, 0x123439 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123439 },
	{ DSP563XX_R0, 0x1234c8 },
	{ DSP563XX_R1, 0x12344f },
	{ DSP563XX_R2, 0x1234c7 },
	{ DSP563XX_R3, 0x123439 },
	{ DSP563XX_R4, 0x123438 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123438 },
	{ DSP563XX_R0, 0x1234c9 },
	{ DSP563XX_R1, 0x123450 },
	{ DSP563XX_R2, 0x1234c8 },
	{ DSP563XX_R3, 0x123438 },
	{ DSP563XX_R4, 0x123437 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234c9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234c9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234c9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1c9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123437 },
	{ DSP563XX_R0, 0x1234ca },
	{ DSP563XX_R1, 0x123451 },
	{ DSP563XX_R2, 0x1234c9 },
	{ DSP563XX_R3, 0x123437 },
	{ DSP563XX_R4, 0x123436 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ca },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ca },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ca },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ca },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123436 },
	{ DSP563XX_R0, 0x1234cb },
	{ DSP563XX_R1, 0x123452 },
	{ DSP563XX_R2, 0x1234ca },
	{ DSP563XX_R3, 0x123436 },
	{ DSP563XX_R4, 0x123435 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1cb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123435 },
	{ DSP563XX_R0, 0x1234cc },
	{ DSP563XX_R1, 0x123453 },
	{ DSP563XX_R2, 0x1234cb },
	{ DSP563XX_R3, 0x123435 },
	{ DSP563XX_R4, 0x123434 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1cc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123434 },
	{ DSP563XX_R0, 0x1234cd },
	{ DSP563XX_R1, 0x123454 },
	{ DSP563XX_R2, 0x1234cc },
	{ DSP563XX_R3, 0x123434 },
	{ DSP563XX_R4, 0x123433 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1cd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123433 },
	{ DSP563XX_R0, 0x1234ce },
	{ DSP563XX_R1, 0x123455 },
	{ DSP563XX_R2, 0x1234cd },
	{ DSP563XX_R3, 0x123433 },
	{ DSP563XX_R4, 0x123432 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ce },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ce },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ce },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ce },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123432 },
	{ DSP563XX_R0, 0x1234cf },
	{ DSP563XX_R1, 0x123456 },
	{ DSP563XX_R2, 0x1234ce },
	{ DSP563XX_R3, 0x123432 },
	{ DSP563XX_R4, 0x123431 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234cf },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234cf },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234cf },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1cf },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123431 },
	{ DSP563XX_R0, 0x1234d0 },
	{ DSP563XX_R1, 0x123457 },
	{ DSP563XX_R2, 0x1234cf },
	{ DSP563XX_R3, 0x123431 },
	{ DSP563XX_R4, 0x123430 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123430 },
	{ DSP563XX_R0, 0x1234d1 },
	{ DSP563XX_R1, 0x123458 },
	{ DSP563XX_R2, 0x1234d0 },
	{ DSP563XX_R3, 0x123430 },
	{ DSP563XX_R4, 0x12342f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342f },
	{ DSP563XX_R0, 0x1234d2 },
	{ DSP563XX_R1, 0x123459 },
	{ DSP563XX_R2, 0x1234d1 },
	{ DSP563XX_R3, 0x12342f },
	{ DSP563XX_R4, 0x12342e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342e },
	{ DSP563XX_R0, 0x1234d3 },
	{ DSP563XX_R1, 0x12345a },
	{ DSP563XX_R2, 0x1234d2 },
	{ DSP563XX_R3, 0x12342e },
	{ DSP563XX_R4, 0x12342d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342d },
	{ DSP563XX_R0, 0x1234d4 },
	{ DSP563XX_R1, 0x12345b },
	{ DSP563XX_R2, 0x1234d3 },
	{ DSP563XX_R3, 0x12342d },
	{ DSP563XX_R4, 0x12342c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342c },
	{ DSP563XX_R0, 0x1234d5 },
	{ DSP563XX_R1, 0x12345c },
	{ DSP563XX_R2, 0x1234d4 },
	{ DSP563XX_R3, 0x12342c },
	{ DSP563XX_R4, 0x12342b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342b },
	{ DSP563XX_R0, 0x1234d6 },
	{ DSP563XX_R1, 0x12345d },
	{ DSP563XX_R2, 0x1234d5 },
	{ DSP563XX_R3, 0x12342b },
	{ DSP563XX_R4, 0x12342a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12342a },
	{ DSP563XX_R0, 0x1234d7 },
	{ DSP563XX_R1, 0x12345e },
	{ DSP563XX_R2, 0x1234d6 },
	{ DSP563XX_R3, 0x12342a },
	{ DSP563XX_R4, 0x123429 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123429 },
	{ DSP563XX_R0, 0x1234d8 },
	{ DSP563XX_R1, 0x12345f },
	{ DSP563XX_R2, 0x1234d7 },
	{ DSP563XX_R3, 0x123429 },
	{ DSP563XX_R4, 0x123428 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123428 },
	{ DSP563XX_R0, 0x1234d9 },
	{ DSP563XX_R1, 0x123460 },
	{ DSP563XX_R2, 0x1234d8 },
	{ DSP563XX_R3, 0x123428 },
	{ DSP563XX_R4, 0x123427 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234d9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234d9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234d9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1d9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123427 },
	{ DSP563XX_R0, 0x1234da },
	{ DSP563XX_R1, 0x123461 },
	{ DSP563XX_R2, 0x1234d9 },
	{ DSP563XX_R3, 0x123427 },
	{ DSP563XX_R4, 0x123426 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234da },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234da },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234da },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1da },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123426 },
	{ DSP563XX_R0, 0x1234db },
	{ DSP563XX_R1, 0x123462 },
	{ DSP563XX_R2, 0x1234da },
	{ DSP563XX_R3, 0x123426 },
	{ DSP563XX_R4, 0x123425 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234db },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234db },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234db },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1db },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123425 },
	{ DSP563XX_R0, 0x1234dc },
	{ DSP563XX_R1, 0x123463 },
	{ DSP563XX_R2, 0x1234db },
	{ DSP563XX_R3, 0x123425 },
	{ DSP563XX_R4, 0x123424 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234dc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234dc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234dc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1dc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123424 },
	{ DSP563XX_R0, 0x1234dd },
	{ DSP563XX_R1, 0x123464 },
	{ DSP563XX_R2, 0x1234dc },
	{ DSP563XX_R3, 0x123424 },
	{ DSP563XX_R4, 0x123423 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234dd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234dd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234dd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1dd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123423 },
	{ DSP563XX_R0, 0x1234de },
	{ DSP563XX_R1, 0x123465 },
	{ DSP563XX_R2, 0x1234dd },
	{ DSP563XX_R3, 0x123423 },
	{ DSP563XX_R4, 0x123422 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234de },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234de },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234de },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1de },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123422 },
	{ DSP563XX_R0, 0x1234df },
	{ DSP563XX_R1, 0x123466 },
	{ DSP563XX_R2, 0x1234de },
	{ DSP563XX_R3, 0x123422 },
	{ DSP563XX_R4, 0x123421 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234df },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234df },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234df },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1df },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123421 },
	{ DSP563XX_R0, 0x1234e0 },
	{ DSP563XX_R1, 0x123467 },
	{ DSP563XX_R2, 0x1234df },
	{ DSP563XX_R3, 0x123421 },
	{ DSP563XX_R4, 0x123420 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123420 },
	{ DSP563XX_R0, 0x1234e1 },
	{ DSP563XX_R1, 0x123468 },
	{ DSP563XX_R2, 0x1234e0 },
	{ DSP563XX_R3, 0x123420 },
	{ DSP563XX_R4, 0x12341f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341f },
	{ DSP563XX_R0, 0x1234e2 },
	{ DSP563XX_R1, 0x123469 },
	{ DSP563XX_R2, 0x1234e1 },
	{ DSP563XX_R3, 0x12341f },
	{ DSP563XX_R4, 0x12341e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341e },
	{ DSP563XX_R0, 0x1234e3 },
	{ DSP563XX_R1, 0x12346a },
	{ DSP563XX_R2, 0x1234e2 },
	{ DSP563XX_R3, 0x12341e },
	{ DSP563XX_R4, 0x12341d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341d },
	{ DSP563XX_R0, 0x1234e4 },
	{ DSP563XX_R1, 0x12346b },
	{ DSP563XX_R2, 0x1234e3 },
	{ DSP563XX_R3, 0x12341d },
	{ DSP563XX_R4, 0x12341c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341c },
	{ DSP563XX_R0, 0x1234e5 },
	{ DSP563XX_R1, 0x12346c },
	{ DSP563XX_R2, 0x1234e4 },
	{ DSP563XX_R3, 0x12341c },
	{ DSP563XX_R4, 0x12341b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341b },
	{ DSP563XX_R0, 0x1234e6 },
	{ DSP563XX_R1, 0x12346d },
	{ DSP563XX_R2, 0x1234e5 },
	{ DSP563XX_R3, 0x12341b },
	{ DSP563XX_R4, 0x12341a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12341a },
	{ DSP563XX_R0, 0x1234e7 },
	{ DSP563XX_R1, 0x12346e },
	{ DSP563XX_R2, 0x1234e6 },
	{ DSP563XX_R3, 0x12341a },
	{ DSP563XX_R4, 0x123419 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123419 },
	{ DSP563XX_R0, 0x1234e8 },
	{ DSP563XX_R1, 0x12346f },
	{ DSP563XX_R2, 0x1234e7 },
	{ DSP563XX_R3, 0x123419 },
	{ DSP563XX_R4, 0x123418 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123418 },
	{ DSP563XX_R0, 0x1234e9 },
	{ DSP563XX_R1, 0x123470 },
	{ DSP563XX_R2, 0x1234e8 },
	{ DSP563XX_R3, 0x123418 },
	{ DSP563XX_R4, 0x123417 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234e9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234e9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234e9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1e9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123417 },
	{ DSP563XX_R0, 0x1234ea },
	{ DSP563XX_R1, 0x123471 },
	{ DSP563XX_R2, 0x1234e9 },
	{ DSP563XX_R3, 0x123417 },
	{ DSP563XX_R4, 0x123416 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ea },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ea },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ea },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ea },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123416 },
	{ DSP563XX_R0, 0x1234eb },
	{ DSP563XX_R1, 0x123472 },
	{ DSP563XX_R2, 0x1234ea },
	{ DSP563XX_R3, 0x123416 },
	{ DSP563XX_R4, 0x123415 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234eb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234eb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234eb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1eb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123415 },
	{ DSP563XX_R0, 0x1234ec },
	{ DSP563XX_R1, 0x123473 },
	{ DSP563XX_R2, 0x1234eb },
	{ DSP563XX_R3, 0x123415 },
	{ DSP563XX_R4, 0x123414 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ec },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ec },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ec },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ec },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123414 },
	{ DSP563XX_R0, 0x1234ed },
	{ DSP563XX_R1, 0x123474 },
	{ DSP563XX_R2, 0x1234ec },
	{ DSP563XX_R3, 0x123414 },
	{ DSP563XX_R4, 0x123413 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ed },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ed },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ed },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ed },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123413 },
	{ DSP563XX_R0, 0x1234ee },
	{ DSP563XX_R1, 0x123475 },
	{ DSP563XX_R2, 0x1234ed },
	{ DSP563XX_R3, 0x123413 },
	{ DSP563XX_R4, 0x123412 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ee },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ee },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ee },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ee },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123412 },
	{ DSP563XX_R0, 0x1234ef },
	{ DSP563XX_R1, 0x123476 },
	{ DSP563XX_R2, 0x1234ee },
	{ DSP563XX_R3, 0x123412 },
	{ DSP563XX_R4, 0x123411 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ef },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ef },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ef },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ef },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123411 },
	{ DSP563XX_R0, 0x1234f0 },
	{ DSP563XX_R1, 0x123477 },
	{ DSP563XX_R2, 0x1234ef },
	{ DSP563XX_R3, 0x123411 },
	{ DSP563XX_R4, 0x123410 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f0 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f0 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f0 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f0 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123410 },
	{ DSP563XX_R0, 0x1234f1 },
	{ DSP563XX_R1, 0x123478 },
	{ DSP563XX_R2, 0x1234f0 },
	{ DSP563XX_R3, 0x123410 },
	{ DSP563XX_R4, 0x12340f },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f1 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f1 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f1 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f1 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340f },
	{ DSP563XX_R0, 0x1234f2 },
	{ DSP563XX_R1, 0x123479 },
	{ DSP563XX_R2, 0x1234f1 },
	{ DSP563XX_R3, 0x12340f },
	{ DSP563XX_R4, 0x12340e },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f2 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f2 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f2 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f2 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340e },
	{ DSP563XX_R0, 0x1234f3 },
	{ DSP563XX_R1, 0x12347a },
	{ DSP563XX_R2, 0x1234f2 },
	{ DSP563XX_R3, 0x12340e },
	{ DSP563XX_R4, 0x12340d },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f3 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f3 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f3 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f3 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340d },
	{ DSP563XX_R0, 0x1234f4 },
	{ DSP563XX_R1, 0x12347b },
	{ DSP563XX_R2, 0x1234f3 },
	{ DSP563XX_R3, 0x12340d },
	{ DSP563XX_R4, 0x12340c },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f4 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f4 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f4 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f4 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340c },
	{ DSP563XX_R0, 0x1234f5 },
	{ DSP563XX_R1, 0x12347c },
	{ DSP563XX_R2, 0x1234f4 },
	{ DSP563XX_R3, 0x12340c },
	{ DSP563XX_R4, 0x12340b },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f5 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f5 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f5 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f5 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340b },
	{ DSP563XX_R0, 0x1234f6 },
	{ DSP563XX_R1, 0x12347d },
	{ DSP563XX_R2, 0x1234f5 },
	{ DSP563XX_R3, 0x12340b },
	{ DSP563XX_R4, 0x12340a },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f6 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f6 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f6 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f6 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x12340a },
	{ DSP563XX_R0, 0x1234f7 },
	{ DSP563XX_R1, 0x12347e },
	{ DSP563XX_R2, 0x1234f6 },
	{ DSP563XX_R3, 0x12340a },
	{ DSP563XX_R4, 0x123409 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f7 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f7 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f7 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f7 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123409 },
	{ DSP563XX_R0, 0x1234f8 },
	{ DSP563XX_R1, 0x12347f },
	{ DSP563XX_R2, 0x1234f7 },
	{ DSP563XX_R3, 0x123409 },
	{ DSP563XX_R4, 0x123408 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f8 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f8 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f8 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f8 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123408 },
	{ DSP563XX_R0, 0x1234f9 },
	{ DSP563XX_R1, 0x123480 },
	{ DSP563XX_R2, 0x1234f8 },
	{ DSP563XX_R3, 0x123408 },
	{ DSP563XX_R4, 0x123407 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234f9 },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234f9 },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234f9 },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1f9 },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123407 },
	{ DSP563XX_R0, 0x1234fa },
	{ DSP563XX_R1, 0x123481 },
	{ DSP563XX_R2, 0x1234f9 },
	{ DSP563XX_R3, 0x123407 },
	{ DSP563XX_R4, 0x123406 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fa },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fa },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fa },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1fa },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123406 },
	{ DSP563XX_R0, 0x1234fb },
	{ DSP563XX_R1, 0x123482 },
	{ DSP563XX_R2, 0x1234fa },
	{ DSP563XX_R3, 0x123406 },
	{ DSP563XX_R4, 0x123405 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fb },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fb },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fb },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1fb },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123405 },
	{ DSP563XX_R0, 0x1234fc },
	{ DSP563XX_R1, 0x123483 },
	{ DSP563XX_R2, 0x1234fb },
	{ DSP563XX_R3, 0x123405 },
	{ DSP563XX_R4, 0x123404 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fc },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fc },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fc },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1fc },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123404 },
	{ DSP563XX_R0, 0x1234fd },
	{ DSP563XX_R1, 0x123484 },
	{ DSP563XX_R2, 0x1234fc },
	{ DSP563XX_R3, 0x123404 },
	{ DSP563XX_R4, 0x123403 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fd },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fd },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fd },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1fd },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123403 },
	{ DSP563XX_R0, 0x1234fe },
	{ DSP563XX_R1, 0x123485 },
	{ DSP563XX_R2, 0x1234fd },
	{ DSP563XX_R3, 0x123403 },
	{ DSP563XX_R4, 0x123402 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234fe },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234fe },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234fe },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1fe },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123402 },
	{ DSP563XX_R0, 0x1234ff },
	{ DSP563XX_R1, 0x123486 },
	{ DSP563XX_R2, 0x1234fe },
	{ DSP563XX_R3, 0x123402 },
	{ DSP563XX_R4, 0x123401 },
	{ DSP563XX_M0, 0x80ff },
	{ DSP563XX_R0, 0x1234ff },
	{ DSP563XX_M1, 0x80ff },
	{ DSP563XX_R1, 0x1234ff },
	{ DSP563XX_N1, 0x88 },
	{ DSP563XX_M2, 0x80ff },
	{ DSP563XX_R2, 0x1234ff },
	{ DSP563XX_N2, 0x100 },
	{ DSP563XX_M3, 0x80ff },
	{ DSP563XX_R3, 0x123400 },
	{ DSP563XX_N3, 0x1ff },
	{ DSP563XX_M4, 0x80ff },
	{ DSP563XX_R4, 0x123401 },
	{ DSP563XX_R0, 0x123400 },
	{ DSP563XX_R1, 0x123487 },
	{ DSP563XX_R2, 0x1234ff },
	{ DSP563XX_R3, 0x123401 },
	{ DSP563XX_R4, 0x123400 },
	{ DSP563XX_R1, 0x3c8 },
	{ DSP563XX_N1, 0x5 },
	{ DSP563XX_M1, 0x801f },
	{ DSP563XX_R2, 0x3c8 },
	{ DSP563XX_N2, 0x1 },
	{ DSP563XX_M2, 0x801f },
	{ DSP563XX_R1, 0x3cd },
	{ DSP563XX_R2, 0x3c9 },
	{ DSP563XX_M0, 0x0 },
	{ DSP563XX_R0, 0x0 },
	{ DSP563XX_N0, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_M0, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_N0, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_M0, 0x0 },
	{ DSP563XX_R0, 0x0 },
	{ DSP563XX_N0, 0x1 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_M0, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_N0, 0x0 },
	{ DSP563XX_R0, 0x1 },
	{ DSP563XX_M0, 0x0 },
	{ DSP563XX_R0, 0xaabbcc },
	{ DSP563XX_N0, 0x123456 },
	{ DSP563XX_R0, 0xb99079 },
	{ DSP563XX_M0, 0x0 },
	{ DSP563XX_R0, 0xaabbcc },
	{ DSP563XX_N0, 0x123456 },
	{ DSP563XX_R0, 0xb08d93 },
	{ DSP563XX_X0, 0xaabbcc },
	{ DSP563XX_X1, 0xddeeff },
	{ DSP563XX_Y0, 0xabcdef },
	{ DSP563XX_Y1, 0x123456 },
	{ DSP563XX_X, 0xddeeffbabecc },
	{ DSP563XX_Y, 0x123456abcdef },
	{ DSP563XX_X0, 0x111111 },
	{ DSP563XX_X1, 0x222222 },
	{ DSP563XX_Y0, 0x333333 },
	{ DSP563XX_Y1, 0x444444 },
	{ DSP563XX_X, 0x222222aaaaaa },
	{ DSP563XX_Y, 0xdddddd333333 },
	{ DSP563XX_X0, 0x111111 },
	{ DSP563XX_X1, 0x222222 },
	{ DSP563XX_Y0, 0x333333 },
	{ DSP563XX_Y1, 0x444444 },
	{ DSP563XX_X, 0xbbbbbbaaaaaa },
	{ DSP563XX_Y, 0x444444333333 },
	{ DSP563XX_X0, 0x111111 },
	{ DSP563XX_X1, 0x222222 },
	{ DSP563XX_Y0, 0x333333 },
	{ DSP563XX_Y1, 0x444444 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_A, 0x222222aaaaaa },
	{ DSP563XX_B, 0xffdddddd333333 },
	{ DSP563XX_A, 0xff112233445566 },
	{ DSP563XX_B, 0xaabbccddeeff },
	{ DSP563XX_A, 0xeeddccbbaa9a },
	{ DSP563XX_B, 0xaabbccddeeff },
	{ DSP563XX_A, 0x1e000000000 },
	{ DSP563XX_B, 0xfffe2000000000 },
	{ DSP563XX_A, 0x0 },
	{ F_CCR_C, 0x1 },
	{ F_CCR_Z, 0x1 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_Y, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x123456 },
	{ DSP563XX_Y, 0xabc },
	{ DSP563XX_A, 0xabc123456 },
	{ DSP563XX_A, 0x123456 },
	{ DSP563XX_Y, 0xabcdef },
	{ DSP563XX_A, 0xffabcdef123456 },
	{ DSP563XX_A, 0x1e000000000 },
	{ DSP563XX_B, 0xfffe2000000000 },
	{ DSP563XX_A, 0x0 },
	{ F_CCR_C, 0x1 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x32000000 },
	{ F_CCR_C, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x32000000 },
	{ F_CCR_C, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x222222 },
	{ DSP563XX_B, 0x333333 },
	{ DSP563XX_B, 0x888888 },
	{ F_CCR_C, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x4edffe000000 },
	{ DSP563XX_B, 0xff89fe13000000 },
	{ DSP563XX_SR, 0x800d0 },
	{ DSP563XX_A, 0xffb16e12000000 },
	{ DSP563XX_SR, 0x800c8 },
	{ DSP563XX_A, 0xffb16e12000000 },
	{ DSP563XX_B, 0xff89fe13000000 },
	{ DSP563XX_SR, 0x800c8 },
	{ DSP563XX_B, 0xff766d1b800000 },
	{ DSP563XX_SR, 0x800e9 },
	{ DSP563XX_A, 0xffcccccc112233 },
	{ DSP563XX_X, 0x777777 },
	{ DSP563XX_B, 0xaaaabbcc334455 },
	{ DSP563XX_Y, 0x667788000000 },
	{ DSP563XX_A, 0xff444444112233 },
	{ DSP563XX_B, 0xaa223388334455 },
	{ DSP563XX_LA, 0x800000 },
	{ DSP563XX_OMR, 0xff6666 },
	{ DSP563XX_SR, 0xff4666 },
	{ DSP563XX_OMR, 0xff2222 },
	{ DSP563XX_SR, 0xfb0222 },
	{ DSP563XX_A, 0xaaabcdef123456 },
	{ DSP563XX_A, 0x55579bde2468ac },
	{ DSP563XX_A, 0x55579bde2468ac },
	{ DSP563XX_A, 0x2aabcdef123456 },
	{ DSP563XX_B, 0x599f2204000 },
	{ DSP563XX_B, 0xb33e4408000 },
	{ DSP563XX_A, 0xf4 },
	{ DSP563XX_SR, 0x800d0 },
	{ DSP563XX_A, 0xf40000000000 },
	{ DSP563XX_SR, 0x800f0 },
	{ DSP563XX_A, 0xaaabcdef123456 },
	{ DSP563XX_SR, 0x0 },
	{ DSP563XX_A, 0x55579bde2468ac },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x1 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_SR, 0x0 },
	{ DSP563XX_A, 0x800000000000 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x0 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0xaaabcdef123456 },
	{ DSP563XX_SR, 0x0 },
	{ DSP563XX_A, 0x55579bde2468ac },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x1 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x11aabbccddeeff },
	{ DSP563XX_B, 0xff112233445566 },
	{ DSP563XX_X, 0xffffffffffff },
	{ DSP563XX_Y, 0xffffffffffff },
	{ DSP563XX_X0, 0x4 },
	{ DSP563XX_Y1, 0x8 },
	{ DSP563XX_A, 0x1aabbccddeeff0 },
	{ DSP563XX_B, 0x11223344556600 },
	{ DSP563XX_A, 0x599f2204000 },
	{ DSP563XX_A, 0x2ccf9102000 },
	{ DSP563XX_A, 0x599f2204000 },
	{ DSP563XX_SR, 0x0 },
	{ DSP563XX_A, 0x2ccf9102000 },
	{ DSP563XX_A, 0x599f2204000 },
	{ DSP563XX_A, 0x2ccf9102000 },
	{ DSP563XX_A, 0xfffffdff000000 },
	{ DSP563XX_A, 0xffffffffffeff8 },
	{ DSP563XX_A, 0x11aabbccddeeff },
	{ DSP563XX_B, 0xff112233445566 },
	{ DSP563XX_X, 0xffffffffffff },
	{ DSP563XX_Y, 0xffffffffffff },
	{ DSP563XX_X0, 0x4 },
	{ DSP563XX_Y1, 0x8 },
	{ DSP563XX_A, 0x11aabbccddeef },
	{ DSP563XX_B, 0xffff1122334455 },
	{ DSP563XX_A, 0x200000000 },
	{ DSP563XX_B, 0x7000000 },
	{ DSP563XX_Y, 0xffffffffffff },
	{ DSP563XX_Y1, 0x9 },
	{ DSP563XX_A, 0x200000000 },
	{ DSP563XX_B, 0x1000000 },
	{ MEM_X, 0x2556677 },
	{ MEM_X, 0x255667f },
	{ F_CCR_C, 0x0 },
	{ MEM_Y, 0x3ddeeff },
	{ MEM_Y, 0x3ddeef7 },
	{ F_CCR_C, 0x1 },
	{ MEM_X, 0x11ffffff },
	{ MEM_Y, 0x22ffffff },
	{ DSP563XX_R0, 0x11 },
	{ DSP563XX_R1, 0x22 },
	{ DSP563XX_N0, 0x0 },
	{ DSP563XX_N1, 0x0 },
	{ DSP563XX_M0, 0xffffff },
	{ DSP563XX_M1, 0xffffff },
	{ MEM_X, 0x11efffff },
	{ MEM_Y, 0x22feffff },
	{ MEM_X, 0x11ffaaaa },
	{ MEM_Y, 0x22ffbbbb },
	{ MEM_X, 0x11efaaaa },
	{ MEM_Y, 0x22febbbb },
	{ MEM_X, 0xffff90334455 },
	{ MEM_X, 0xffffd0556677 },
	{ MEM_X, 0xffff90334451 },
	{ MEM_Y, 0xffffd0556667 },
	{ DSP563XX_OMR, 0xddeeff },
	{ F_CCR_C, 0x0 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_OMR, 0xddee7f },
	{ DSP563XX_OMR, 0xddee7f },
	{ F_CCR_C, 0x1 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_OMR, 0xddee7f },
	{ DSP563XX_B, 0xffffffffffffff },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_B, 0xffbfffff000000 },
	{ MEM_X, 0x255667f },
	{ MEM_Y, 0x3ddeef0 },
	{ MEM_X, 0x255667f },
	{ MEM_Y, 0x3ddeef8 },
	{ MEM_X, 0x2aabbc4 },
	{ F_CCR_C, 0x1 },
	{ MEM_X, 0x2aabbc4 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0xffffffd1000000 },
	{ DSP563XX_A, 0xffffff000000 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x1000000 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0xffffffd2000000 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x99aabbccddeeff },
	{ DSP563XX_X0, 0x0 },
	{ DSP563XX_SR, 0x80000 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_X0, 0x128 },
	{ F_CCR_U, 0x1 },
	{ F_CCR_Z, 0x1 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0xbada55c0deba5e },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B1, 0x123456 },
	{ DSP563XX_X, 0x0 },
	{ DSP563XX_X0, 0x123456 },
	{ F_CCR_Z, 0x1 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_V, 0x0 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_X0, 0xf00000 },
	{ DSP563XX_A, 0xfff40000000000 },
	{ DSP563XX_SR, 0x800d8 },
	{ DSP563XX_SR, 0x800d0 },
	{ DSP563XX_SR, 0x80099 },
	{ DSP563XX_A, 0xfffffc6c000000 },
	{ DSP563XX_SR, 0x80098 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_X0, 0x1 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_A, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_V, 0x0 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_A, 0x0 },
	{ F_CCR_Z, 0x1 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_V, 0x0 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_N, 0x1 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_V, 0x0 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xffef590e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xffef590e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xffef790e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xffefb90e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff0390e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff1390e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff3390e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff7390e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xffff390e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xf390e000000 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xdab2a000001 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xa8f62000003 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0x457d2000007 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff7e8b200000f },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0x985600001e },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff069ba00003d },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff19a6600007a },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff3fbbe0000f4 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff8be6e0001e8 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0x243ce0003d0 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff3c0aa0007a1 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff84846000f42 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0x1577e001e84 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff1e80a003d09 },
	{ DSP563XX_A, 0x1000000000 },
	{ DSP563XX_Y, 0x4444410c6f2 },
	{ DSP563XX_A, 0xfff49706007a12 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffdf7214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe07214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe27214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe67214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffee7214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xfffe7214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0x1e7214000000 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0x1b563c000001 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0x151e8c000003 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0x8af2c000007 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffefd06c00000f },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0x12ec400001e },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe0cf9c00003d },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe32d2400007a },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe7e8340000f4 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xfff15e540001e8 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0x44a940003d0 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe7073c0007a1 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffef9c64000f42 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xc6b4001e84 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffdfff7c003d09 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe18ce4007a12 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffe4a7b400f424 },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_Y, 0x44444218dec },
	{ DSP563XX_A, 0xffeadd5401e848 },
	{ DSP563XX_Y0, 0x218dec },
	{ DSP563XX_A, 0x8000000000 },
	{ DSP563XX_SR, 0x800d4 },
	{ DSP563XX_A, 0xffdf7214000000 },
	{ DSP563XX_SR, 0x800d4 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_X1, 0x20 },
	{ DSP563XX_Y1, 0x20 },
	{ DSP563XX_A, 0x800 },
	{ DSP563XX_A, 0xfff00000000000 },
	{ DSP563XX_X1, 0x20 },
	{ DSP563XX_Y1, 0x20 },
	{ DSP563XX_A, 0xfffffffff00800 },
	{ DSP563XX_A, 0x5f1bbfa0e440 },
	{ DSP563XX_X, 0x15555555555 },
	{ DSP563XX_Y, 0x8ea9a0 },
	{ DSP563XX_A, 0x17c6effffff },
	{ DSP563XX_A, 0xf799428000000 },
	{ DSP563XX_X0, 0x799428 },
	{ DSP563XX_A, 0xf000000000000 },
	{ DSP563XX_A, 0xf000428000123 },
	{ DSP563XX_X0, 0x799428 },
	{ DSP563XX_A, 0xf799000000123 },
	{ DSP563XX_X, 0x4008000000 },
	{ DSP563XX_A, 0xef00 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0xf },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0xfff47555000000 },
	{ DSP563XX_SR, 0x800d9 },
	{ DSP563XX_A, 0xf4 },
	{ DSP563XX_SR, 0x800d0 },
	{ DSP563XX_X, 0x4008000000 },
	{ DSP563XX_A, 0xff00 },
	{ DSP563XX_B, 0xf },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0xef123456abcdef },
	{ DSP563XX_A, 0x56abcdef },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B1, 0xaabbcc },
	{ DSP563XX_B0, 0xddeeff },
	{ DSP563XX_A, 0xccddeeff },
	{ DSP563XX_B, 0x444ffff000000 },
	{ DSP563XX_A, 0x444 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x1 },
	{ F_CCR_Z, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_A, 0xffffffff000000 },
	{ DSP563XX_B, 0x0 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_Z, 0x1 },
	{ F_CCR_N, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0xffffffff000000 },
	{ DSP563XX_B, 0x0 },
	{ F_CCR_N, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_N, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_A, 0x0 },
	{ F_CCR_C, 0x1 },
	{ F_CCR_Z, 0x1 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_A, 0x2 },
	{ F_CCR_C, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_E, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_X1, 0x123456 },
	{ DSP563XX_A, 0x12aabbccddeeff },
	{ DSP563XX_A, 0x12aabbccd456ff },
	{ DSP563XX_X0, 0x10028 },
	{ DSP563XX_Y1, 0xabcdef },
	{ DSP563XX_A, 0x12123456123456 },
	{ DSP563XX_A, 0xcdef3456123456 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_A0, 0xddeeff },
	{ DSP563XX_B0, 0xaabbcc },
	{ DSP563XX_X1, 0x8000 },
	{ DSP563XX_A0, 0xddeecc },
	{ DSP563XX_N0, 0x4711 },
	{ DSP563XX_N0, 0x2a },
	{ DSP563XX_A, 0xffaabbcc112233 },
	{ DSP563XX_A, 0xff557798112233 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0xffaabbcc112233 },
	{ DSP563XX_A, 0xffabbcc0112233 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_X1, 0x4 },
	{ DSP563XX_A, 0xab112233445566 },
	{ DSP563XX_A, 0xab122330445566 },
	{ DSP563XX_X1, 0x1c },
	{ DSP563XX_A, 0xab112233445566 },
	{ DSP563XX_A, 0xab000000445566 },
	{ DSP563XX_A, 0xffaabbcc112233 },
	{ DSP563XX_A, 0xff555de6112233 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0xffaabbcc112233 },
	{ DSP563XX_A, 0xff0aabbc112233 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0xab112233445566 },
	{ DSP563XX_X1, 0x4 },
	{ DSP563XX_A, 0xab011223445566 },
	{ DSP563XX_A, 0xab112233445566 },
	{ DSP563XX_X1, 0x1c },
	{ DSP563XX_A, 0xab000000445566 },
	{ DSP563XX_R0, 0x112233 },
	{ DSP563XX_N0, 0x1111 },
	{ DSP563XX_R0, 0x112233 },
	{ DSP563XX_N0, 0x112234 },
	{ DSP563XX_R0, 0x112233 },
	{ DSP563XX_N0, 0x1111 },
	{ DSP563XX_R0, 0x112233 },
	{ DSP563XX_N0, 0x113344 },
	{ DSP563XX_R0, 0xf0 },
	{ DSP563XX_M0, 0xffffff },
	{ DSP563XX_R0, 0xf0 },
	{ DSP563XX_N3, 0x120 },
	{ DSP563XX_R0, 0xf0 },
	{ DSP563XX_M0, 0xff },
	{ DSP563XX_R0, 0xf0 },
	{ DSP563XX_N3, 0x20 },
	{ DSP563XX_R0, 0xf0 },
	{ DSP563XX_M0, 0xffffff },
	{ DSP563XX_R0, 0xf0 },
	{ DSP563XX_R6, 0xdf },
	{ DSP563XX_X, 0xda7efa5a7efa },
	{ DSP563XX_Y, 0x800000 },
	{ DSP563XX_A, 0x5a7efa000000 },
	{ DSP563XX_B, 0x5a7efa000000 },
	{ DSP563XX_A, 0x800000000000 },
	{ DSP563XX_X, 0xda7efa5a7efa },
	{ DSP563XX_Y, 0x800000 },
	{ DSP563XX_A, 0x5a7efa000000 },
	{ DSP563XX_B, 0x5a7efa000000 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_Y0, 0x7fffff },
	{ DSP563XX_X0, 0x6bb14a },
	{ DSP563XX_B, 0x553300000000 },
	{ DSP563XX_SR, 0x880d0 },
	{ DSP563XX_LA, 0x800000 },
	{ DSP563XX_B, 0xc0e449289d6c },
	{ DSP563XX_SR, 0x880f0 },
	{ DSP563XX_Y1, 0xf3aab8 },
	{ DSP563XX_Y0, 0x80 },
	{ DSP563XX_SR, 0x800d8 },
	{ DSP563XX_B, 0xc000000 },
	{ DSP563XX_R5, 0xa },
	{ MEM_X, 0xa012346 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_R5, 0x9 },
	{ DSP563XX_Y0, 0x123456 },
	{ DSP563XX_SR, 0x800d4 },
	{ DSP563XX_X1, 0x2 },
	{ DSP563XX_A, 0x100 },
	{ DSP563XX_A, 0x800100 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x1 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_B, 0x2 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x2 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x2 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0xff112233445566 },
	{ DSP563XX_B, 0xffffffffffffff },
	{ DSP563XX_A, 0xff112233445566 },
	{ DSP563XX_B, 0xffffffffffffff },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_B, 0x123456123456 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_B, 0x123456123456 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x123456123456 },
	{ DSP563XX_B, 0xffffffffffffff },
	{ DSP563XX_A, 0x123456123456 },
	{ DSP563XX_B, 0x123456123456 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x1 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_B, 0x2 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x2 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x2 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0xfffffffffffffe },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_A, 0xfffffffffffffe },
	{ DSP563XX_B, 0xfffffffffffffe },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0xfffffffffffffe },
	{ DSP563XX_B, 0xfffffffffffffb },
	{ DSP563XX_A, 0xfffffffffffffe },
	{ DSP563XX_B, 0xfffffffffffffb },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0xff112233445566 },
	{ DSP563XX_B, 0xffffffffffffff },
	{ DSP563XX_A, 0xff112233445566 },
	{ DSP563XX_B, 0xff112233445566 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_B, 0x123456123456 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_B, 0x123456123456 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x123456123456 },
	{ DSP563XX_B, 0xffffffffffffff },
	{ DSP563XX_A, 0x123456123456 },
	{ DSP563XX_B, 0x123456123456 },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_X0, 0x20 },
	{ DSP563XX_X1, 0x20 },
	{ DSP563XX_A, 0x800 },
	{ DSP563XX_X0, 0xffffff },
	{ DSP563XX_X1, 0xffffff },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_X, 0xeeeeee },
	{ DSP563XX_Y, 0xbbbbbb },
	{ DSP563XX_A, 0x91a2bd4c3b4 },
	{ DSP563XX_X, 0xffffff },
	{ DSP563XX_Y, 0x7fffff },
	{ DSP563XX_A, 0xffffffff000002 },
	{ DSP563XX_X, 0xffffff },
	{ DSP563XX_Y, 0xffffff },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_B, 0x3a400000000 },
	{ DSP563XX_X, 0x506c000 },
	{ DSP563XX_Y, 0x400000400 },
	{ DSP563XX_SR, 0x800c9 },
	{ DSP563XX_A, 0x36000000 },
	{ DSP563XX_SR, 0x800d1 },
	{ DSP563XX_X0, 0x20 },
	{ DSP563XX_X1, 0x400 },
	{ DSP563XX_A, 0x12abcdefabdef },
	{ DSP563XX_B, 0x12abcdefabdef },
	{ DSP563XX_A, 0x8000 },
	{ DSP563XX_B, 0x80000 },
	{ DSP563XX_X0, 0xef4e },
	{ DSP563XX_Y0, 0x600000 },
	{ DSP563XX_SR, 0x880d0 },
	{ DSP563XX_LA, 0x800000 },
	{ DSP563XX_OMR, 0x4380 },
	{ DSP563XX_A, 0xb37a000000 },
	{ DSP563XX_X1, 0x2 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x800000 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ F_CCR_N, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0xfffffffffffffe },
	{ DSP563XX_A, 0x2 },
	{ F_CCR_N, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0x123456789abc },
	{ DSP563XX_B, 0x123456789abc },
	{ DSP563XX_A, 0x123456789ab },
	{ DSP563XX_B, 0x123456789abc0 },
	{ DSP563XX_A, 0x12555555123456 },
	{ DSP563XX_A, 0x12aaaaaa123456 },
	{ DSP563XX_A, 0xffd8b38b000000 },
	{ DSP563XX_SR, 0x800e8 },
	{ DSP563XX_A, 0xff274c74000000 },
	{ DSP563XX_SR, 0x800e0 },
	{ DSP563XX_A, 0xbb222222555555 },
	{ DSP563XX_X0, 0x444444 },
	{ DSP563XX_A, 0xbb666666555555 },
	{ DSP563XX_A, 0xbb222222555555 },
	{ DSP563XX_A, 0xbb666666555555 },
	{ DSP563XX_A, 0xbb222222555555 },
	{ DSP563XX_A, 0xbb222226555555 },
	{ DSP563XX_OMR, 0xff1111 },
	{ DSP563XX_SR, 0xff1111 },
	{ DSP563XX_OMR, 0xff3333 },
	{ DSP563XX_SR, 0xff3333 },
	{ DSP563XX_A, 0x222222333333 },
	{ DSP563XX_A, 0x222222000000 },
	{ DSP563XX_A, 0x222222999999 },
	{ DSP563XX_A, 0x222223000000 },
	{ DSP563XX_B, 0xffff9538000000 },
	{ DSP563XX_B, 0xffff9538000000 },
	{ F_CCR_N, 0x1 },
	{ F_CCR_Z, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x222222ffffff },
	{ F_SR_S0, 0x1 },
	{ F_SR_S1, 0x0 },
	{ DSP563XX_A, 0x222222000000 },
	{ DSP563XX_A, 0xeeeeeebbbbbb },
	{ F_SR_S0, 0x0 },
	{ F_SR_S1, 0x1 },
	{ DSP563XX_A, 0xeeeeee800000 },
	{ DSP563XX_A, 0xeeeeeebbbbbb },
	{ F_SR_S0, 0x0 },
	{ F_SR_S1, 0x0 },
	{ DSP563XX_A, 0xeeeeef000000 },
	{ DSP563XX_A, 0xee112233ffeedd },
	{ DSP563XX_SR, 0x0 },
	{ DSP563XX_A, 0xee224466ffeedd },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x12abcdef123456 },
	{ DSP563XX_SR, 0x0 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x12579bdf123456 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x12123456abcdef },
	{ DSP563XX_SR, 0x0 },
	{ F_CCR_C, 0x1 },
	{ DSP563XX_A, 0x122468adabcdef },
	{ F_CCR_C, 0x0 },
	{ DSP563XX_A, 0x1 },
	{ DSP563XX_B, 0x2 },
	{ DSP563XX_A, 0xffffffffffffff },
	{ F_CCR_C, 0x1 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x80000000000000 },
	{ DSP563XX_B, 0x1 },
	{ DSP563XX_A, 0x7fffffffffffff },
	{ F_CCR_C, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_X0, 0x800000 },
	{ DSP563XX_A, 0x800000000000 },
	{ F_CCR_C, 0x1 },
	{ F_CCR_N, 0x0 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_B, 0x4 },
	{ DSP563XX_A, 0x0 },
	{ F_CCR_Z, 0x1 },
	{ DSP563XX_A, 0x4 },
	{ DSP563XX_B, 0x2 },
	{ DSP563XX_A, 0x6 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0x2 },
	{ DSP563XX_B, 0x4 },
	{ DSP563XX_B, 0x6 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_A, 0x400000000000 },
	{ DSP563XX_B, 0x200000000000 },
	{ DSP563XX_A, 0x600000000000 },
	{ F_CCR_C, 0x0 },
	{ F_CCR_V, 0x0 },
	{ DSP563XX_A, 0x11223344556677 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x11223344556677 },
	{ DSP563XX_A, 0xaa112233445566 },
	{ DSP563XX_B, 0x0 },
	{ F_CCR_Z, 0x1 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_A, 0xbb112233445566 },
	{ DSP563XX_B, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_B, 0xbb112233445566 },
	{ DSP563XX_R0, 0xaa1122 },
	{ DSP563XX_R1, 0x0 },
	{ F_CCR_Z, 0x1 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_R0, 0xbb1122 },
	{ DSP563XX_R1, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_R1, 0xbb1122 },
	{ DSP563XX_A, 0xaa112233445566 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_R0, 0xaa1122 },
	{ DSP563XX_R1, 0x0 },
	{ F_CCR_Z, 0x1 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_R1, 0x0 },
	{ DSP563XX_A, 0xbb112233445566 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_R0, 0xbb1122 },
	{ DSP563XX_R1, 0x0 },
	{ F_CCR_Z, 0x0 },
	{ DSP563XX_B, 0xbb112233445566 },
	{ DSP563XX_R1, 0xbb1122 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0xffff0000000000 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0xf0000000000 },
	{ DSP563XX_X, 0x0 },
	{ DSP563XX_X0, 0xff0000 },
	{ DSP563XX_X, 0xff0000 },
	{ DSP563XX_R2, 0x0 },
	{ DSP563XX_R2, 0xff },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0x12345678abcdef },
	{ DSP563XX_A, 0x12345678abcdef },
	{ DSP563XX_B, 0x7fffff000000 },
	{ DSP563XX_R5, 0xa },
	{ MEM_Y, 0x9123456 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x123456000000 },
	{ DSP563XX_R5, 0x9 },
	{ MEM_X, 0xa123456 },
	{ MEM_Y, 0x5543210 },
	{ DSP563XX_A, 0xbabeb00bab },
	{ DSP563XX_R2, 0xa },
	{ DSP563XX_R6, 0x5 },
	{ DSP563XX_R2, 0xb },
	{ DSP563XX_R6, 0x6 },
	{ DSP563XX_A, 0x123456000000 },
	{ MEM_X, 0xa123456 },
	{ MEM_Y, 0x500babe },
	{ DSP563XX_A, 0x112233445566 },
	{ DSP563XX_N2, 0x0 },
	{ DSP563XX_N2, 0x112233 },
	{ DSP563XX_A, 0x445566aabbcc },
	{ DSP563XX_R0, 0x0 },
	{ DSP563XX_R0, 0x445566 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x44aabbccddeeff },
	{ DSP563XX_A, 0x7fffff000000 },
	{ DSP563XX_B, 0x44aabbccddeeff },
	{ DSP563XX_A, 0xff000000000000 },
	{ DSP563XX_B, 0x77000000000000 },
	{ DSP563XX_X0, 0xffffff },
	{ DSP563XX_Y0, 0x77 },
	{ DSP563XX_A, 0x223344556677 },
	{ DSP563XX_Y1, 0xaabbcc },
	{ DSP563XX_Y1, 0x223344 },
	{ DSP563XX_R2, 0xa },
	{ DSP563XX_N2, 0x5 },
	{ MEM_P, 0xe123456 },
	{ DSP563XX_R2, 0x123456 },
	{ DSP563XX_A, 0x0 },
	{ MEM_X, 0x10223344 },
	{ DSP563XX_A, 0x223344000000 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x3a800000000 },
	{ DSP563XX_R0, 0x11 },
	{ MEM_X, 0x1911abcd },
	{ DSP563XX_B, 0x11abcd000000 },
	{ DSP563XX_B, 0x11aabb000000 },
	{ MEM_X, 0x7000000 },
	{ DSP563XX_R0, 0x3 },
	{ MEM_X, 0x711aabb },
	{ DSP563XX_X, 0x0 },
	{ DSP563XX_X, 0xff0000 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0xffff0000000000 },
	{ MEM_Y, 0x20334455 },
	{ DSP563XX_Y1, 0x334455 },
	{ DSP563XX_R4, 0x10 },
	{ DSP563XX_N4, 0x3 },
	{ DSP563XX_R4, 0x13 },
	{ DSP563XX_R4, 0x13 },
	{ DSP563XX_R4, 0x14 },
	{ MEM_X, 0x7654321 },
	{ DSP563XX_R2, 0x0 },
	{ DSP563XX_R2, 0x654321 },
	{ DSP563XX_R2, 0xfedcba },
	{ MEM_Y, 0x6000000 },
	{ MEM_Y, 0x6fedcba },
	{ DSP563XX_R3, 0x3 },
	{ DSP563XX_N5, 0x0 },
	{ MEM_X, 0x7223344 },
	{ DSP563XX_R3, 0x3 },
	{ DSP563XX_N5, 0x223344 },
	{ DSP563XX_R2, 0x15 },
	{ DSP563XX_R1, 0x0 },
	{ MEM_X, 0x11456789 },
	{ DSP563XX_R1, 0x456789 },
	{ DSP563XX_R2, 0x5 },
	{ DSP563XX_N3, 0x778899 },
	{ DSP563XX_R2, 0x5 },
	{ MEM_Y, 0x9778899 },
	{ DSP563XX_R3, 0x3 },
	{ DSP563XX_A, 0x0 },
	{ MEM_X, 0x7223344 },
	{ DSP563XX_A, 0x223344000000 },
	{ DSP563XX_R2, 0x14 },
	{ DSP563XX_A, 0x0 },
	{ MEM_X, 0x10345678 },
	{ DSP563XX_A, 0x345678000000 },
	{ DSP563XX_R2, 0x11 },
	{ DSP563XX_M2, 0xf },
	{ DSP563XX_A, 0x0 },
	{ MEM_X, 0x1d345678 },
	{ DSP563XX_A, 0x345678000000 },
	{ DSP563XX_R2, 0x5 },
	{ DSP563XX_A, 0x334455667788 },
	{ MEM_Y, 0x9000000 },
	{ MEM_Y, 0x9334455 },
	{ DSP563XX_R2, 0x5 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x223344556677 },
	{ DSP563XX_Y, 0x111111222222 },
	{ MEM_X, 0x5aabbcc },
	{ DSP563XX_A, 0xffaabbcc000000 },
	{ DSP563XX_Y, 0x111111223344 },
	{ DSP563XX_R2, 0x6 },
	{ MEM_X, 0xffffc500c0de },
	{ DSP563XX_R2, 0xffffc4 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_A, 0xc0de000000 },
	{ DSP563XX_R2, 0x5 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x223344556677 },
	{ DSP563XX_X, 0x111111222222 },
	{ MEM_X, 0x5ddeeff },
	{ DSP563XX_A, 0xffddeeff000000 },
	{ DSP563XX_X, 0x111111223344 },
	{ DSP563XX_R2, 0x6 },
	{ DSP563XX_R1, 0x3 },
	{ DSP563XX_A, 0x223344556677 },
	{ DSP563XX_X, 0x111111222222 },
	{ MEM_X, 0x3000000 },
	{ DSP563XX_A, 0x222222000000 },
	{ MEM_X, 0x3223344 },
	{ DSP563XX_R6, 0x4 },
	{ DSP563XX_B, 0x334455667788 },
	{ DSP563XX_Y, 0x444444555555 },
	{ MEM_Y, 0x4000000 },
	{ DSP563XX_B, 0x555555000000 },
	{ MEM_Y, 0x4334455 },
	{ DSP563XX_R2, 0x2 },
	{ DSP563XX_R6, 0x3 },
	{ DSP563XX_N2, 0x3 },
	{ DSP563XX_X0, 0x0 },
	{ DSP563XX_Y0, 0x0 },
	{ MEM_X, 0x2223344 },
	{ MEM_Y, 0x3ccddee },
	{ DSP563XX_X0, 0x223344 },
	{ DSP563XX_Y0, 0xccddee },
	{ DSP563XX_R2, 0x5 },
	{ DSP563XX_R6, 0x4 },
	{ DSP563XX_R3, 0x6 },
	{ DSP563XX_R7, 0x7 },
	{ DSP563XX_X0, 0x112233 },
	{ DSP563XX_Y0, 0x445566 },
	{ MEM_X, 0x6000000 },
	{ MEM_Y, 0x7000000 },
	{ MEM_X, 0x6112233 },
	{ MEM_Y, 0x7445566 },
	{ DSP563XX_R0, 0x3 },
	{ DSP563XX_OMR, 0x0 },
	{ MEM_X, 0x3112233 },
	{ DSP563XX_OMR, 0x112233 },
	{ DSP563XX_SR, 0x0 },
	{ MEM_X, 0x3223344 },
	{ DSP563XX_SR, 0x223344 },
	{ DSP563XX_VBA, 0x0 },
	{ DSP563XX_Y1, 0x334455 },
	{ DSP563XX_VBA, 0x334455 },
	{ DSP563XX_EP, 0xaabbdd },
	{ DSP563XX_X1, 0x0 },
	{ DSP563XX_X1, 0xaabbdd },
	{ DSP563XX_LC, 0x0 },
	{ DSP563XX_LC, 0xaabbcc },
	{ DSP563XX_LA, 0x0 },
	{ DSP563XX_LA, 0x55 },
	{ MEM_X, 0xffffc5000000 },
	{ MEM_X, 0xffffc5ffeeff },
	{ MEM_X, 0xffffc500c0de },
	{ MEM_P, 0x23000000 },
	{ MEM_P, 0x2300c0de },
	{ MEM_X, 0xffff85000000 },
	{ MEM_X, 0xffff85334455 },
	{ MEM_Y, 0xffff8c000000 },
	{ MEM_Y, 0xffff8c556677 },
	{ MEM_X, 0xffff84000000 },
	{ DSP563XX_Y1, 0x334455 },
	{ MEM_X, 0xffff84334455 },
	{ MEM_X, 0xffff86112233 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_B, 0x112233000000 },
	{ MEM_Y, 0xffffc58899aa },
	{ DSP563XX_Y1, 0x0 },
	{ DSP563XX_Y1, 0x8899aa },
	{ MEM_X, 0x64123456 },
	{ MEM_Y, 0x64345678 },
	{ DSP563XX_R0, 0x64 },
	{ DSP563XX_A, 0x123456000000 },
	{ DSP563XX_B, 0x345678000000 },
	{ DSP563XX_B, 0xaabadbadbadbad },
	{ MEM_X, 0xa123456 },
	{ MEM_Y, 0xa543210 },
	{ DSP563XX_R0, 0xa },
	{ DSP563XX_B, 0x123456543210 },
	{ DSP563XX_X, 0xbadbadbadbad },
	{ DSP563XX_R1, 0x10 },
	{ MEM_X, 0x10aabbcc },
	{ MEM_Y, 0x10ddeeff },
	{ MEM_X, 0x37f0000 },
	{ MEM_Y, 0x3112233 },
	{ DSP563XX_B, 0xffffeeddccbbaa },
	{ DSP563XX_X, 0xaabbccddeeff },
	{ DSP563XX_B, 0x7f0000112233 },
	{ DSP563XX_R1, 0x11 },
	{ DSP563XX_X, 0xaabbccddeeff },
	{ DSP563XX_Y, 0x112233445566 },
	{ DSP563XX_A, 0x765432123456 },
	{ DSP563XX_B, 0x654321fedcba },
	{ DSP563XX_R1, 0x10 },
	{ DSP563XX_R2, 0x15 },
	{ DSP563XX_R3, 0x20 },
	{ DSP563XX_R5, 0x25 },
	{ MEM_X, 0x10000000 },
	{ MEM_Y, 0x10000000 },
	{ MEM_X, 0x15000000 },
	{ MEM_Y, 0x15000000 },
	{ MEM_X, 0x20000000 },
	{ MEM_Y, 0x20000000 },
	{ MEM_X, 0x25000000 },
	{ MEM_Y, 0x25000000 },
	{ MEM_X, 0x10aabbcc },
	{ MEM_Y, 0x10ddeeff },
	{ MEM_X, 0x16112233 },
	{ MEM_Y, 0x15445566 },
	{ MEM_X, 0x20765432 },
	{ MEM_Y, 0x20123456 },
	{ MEM_X, 0x25654321 },
	{ MEM_Y, 0x25fedcba },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ MEM_X, 0x3123456 },
	{ MEM_Y, 0x3789abc },
	{ DSP563XX_A, 0x123456000000 },
	{ DSP563XX_B, 0x789abc000000 },
	{ DSP563XX_Y, 0x0 },
	{ MEM_X, 0x4123456 },
	{ MEM_Y, 0x4789abc },
	{ DSP563XX_Y, 0x123456789abc },
	{ DSP563XX_X, 0x10000 },
	{ DSP563XX_Y, 0x222222222222 },
	{ DSP563XX_A, 0x6c0000000000 },
	{ DSP563XX_B, 0xbbbbbbbbbbbbbb },
	{ DSP563XX_X0, 0x3c0000 },
	{ DSP563XX_Y, 0x222222222222 },
	{ DSP563XX_A, 0x6b0000000000 },
	{ DSP563XX_B, 0xbbbbbbbbbbbbbb },
	{ DSP563XX_X, 0x100000080000 },
	{ DSP563XX_Y, 0x200000 },
	{ DSP563XX_A, 0x2cdd6000000 },
	{ DSP563XX_B, 0x2a0a5000000 },
	{ DSP563XX_X, 0x80000 },
	{ DSP563XX_Y, 0x200000 },
	{ DSP563XX_A, 0x80000000000 },
	{ DSP563XX_B, 0x2a0a5000000 },
	{ DSP563XX_X, 0x3339 },
	{ DSP563XX_Y, 0x65a1cb000000 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x196871f4bc6a },
	{ DSP563XX_X, 0x3339 },
	{ DSP563XX_Y, 0x65a1cb000000 },
	{ DSP563XX_A, 0x0 },
	{ DSP563XX_B, 0x0 },
	{ DSP563XX_X, 0x111111222222 },
	{ DSP563XX_Y, 0x333333444444 },
	{ DSP563XX_A, 0x55666666777777 },
	{ DSP563XX_B, 0x88999999aaaaaa },
	{ DSP563XX_X, 0x111111222222 },
	{ DSP563XX_Y, 0x333333444444 },
	{ DSP563XX_A, 0xff800000000000 },
	{ DSP563XX_B, 0x444444000000 },
	{ DSP563XX_X, 0x111111222222 },
	{ DSP563XX_Y, 0x333333444444 },
	{ DSP563XX_A, 0x55666666777777 },
	{ DSP563XX_B, 0x88999999aaaaaa },
	{ DSP563XX_X, 0x111111222222 },
	{ DSP563XX_Y, 0x777777444444 },
	{ DSP563XX_A, 0x222222000000 },
	{ DSP563XX_B, 0x88999999aaaaaa },
};
