package org.jctools.channels.proxy;

/**
 * This is the definition of the API required for the byte code generated by the {@link ProxyChannelFactory}
 */
public abstract class ProxyChannelRingBuffer {
    public static final long EOF = 0;

    /**
     * Acquire an offset to write to. If there's no space available a wait
     * strategy may be used.
     * 
     * @return the offset that was acquired for writing or {@link #EOF}
     */
    protected abstract long writeAcquire();

    /**
     * Ordered store of the callTypeId for the message at offset
     * 
     * @param offset
     *            the offset that was released for writing
     * @param callTypeId
     *            A unique ID for the call
     */
    protected abstract void writeRelease(long offset, int callTypeId);

    /**
     * Acquire an offset to read from
     * 
     * @return the offset that was acquired for reading or {@link #EOF}
     */
    protected abstract long readAcquire();

    /**
     * Release the offset from reading
     * 
     * @param offset
     *            the offset to release for reading
     */
    protected abstract void readRelease(long offset);

    /**
     * Get the position index of the consumer in the reference array
     * 
     * @param offset the current offset of the consumer returned from {@link #readAcquire()}
     * @return the consumer index
     */
    protected abstract long consumerReferenceArrayIndex(long offset);

    /**
     * Get the position index of the producer in the reference array
     * 
     * @param offset the current offset of the producer returned from {@link #writeAcquire()}
     * @return the producer index
     */
    protected abstract long producerReferenceArrayIndex(long offset);

    /**
     * Write a reference into the index of the reference array.
     * 
     * @param index
     *            the index to write to
     * @param reference
     *            the reference to write
     */
    protected abstract void writeReference(long index, Object reference);

    /**
     * Read a reference from the index of the reference array.
     * 
     * @param index
     *            the index to read from
     * @return the reference that was read
     */
    protected abstract Object readReference(long index);

}
