## Delta Decoder Specification
### Inputs
The decoder for the 'delta' codec takes a single numeric stream of deltas as input. The encoded stream must be a stream of 8, 16, 32, or 64-bit integers.

### Decoding
The decoded stream is reconstructed by copying the first element into the decoded stream. The first element is either in the frame header or the encoded stream depending on the format version. Each subsequent value is regenerated by adding the previous value with the next value in the encoded stream using unsigned modular addition.

### Codec Header
#### Frame Versions 13+
The codec header contains zero or one integer. If the codec header is empty, then the encoded delta stream must be empty, and the regenerated stream is empty. Otherwise, the codec header contains the first element of the regenerated stream, and the integer width of the encoded stream must be the same as the width of the integer in the codec header.

Consider the encoded input stream {1, 1, 2} with the codec header containing the value 2. We can regenerate the decoded stream by setting the first element to the value in the header, 2, and then adding the elements in the encoded delta stream to each subsequent element. This means that that decoded stream will be {2, 3, 4, 6}.

#### Frame Versions 12-
The first element of the original input stream is the first element in the encoded deltas stream.

Consider the encoded input stream {2, 1, 1, 2}. We can regenerate the decoded stream by setting the first element of the decoded stream to the first element of the encoded stream, 2, and then adding the elements in the encoded delta stream to each subsequent element. This means that that decoded stream will be {2, 3, 4, 6}.


### Outputs
The output of the decoder is a single numeric stream where the element width is the same as the elements of the input stream.

Let n be the number of elements in the encoded stream. For frame versions 13+, the length of the output should be n+1. For frame versions 12-, the length of the output stream should be n.
