/*
 * SPDX-FileCopyrightText: 2021-2021 CSSlayer <wengxt@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 */
#include "testdir.h"
#include "testfrontend_public.h"
#include <fcitx-config/rawconfig.h>
#include <fcitx-utils/capabilityflags.h>
#include <fcitx-utils/eventdispatcher.h>
#include <fcitx-utils/key.h>
#include <fcitx-utils/keysym.h>
#include <fcitx-utils/log.h>
#include <fcitx-utils/macros.h>
#include <fcitx-utils/standardpaths.h>
#include <fcitx-utils/testing.h>
#include <fcitx/addonmanager.h>
#include <fcitx/inputmethodgroup.h>
#include <fcitx/inputmethodmanager.h>
#include <fcitx/instance.h>
#include <map>
#include <string>

using namespace fcitx;

std::map<std::string, std::string> expectedTelexData{
    {"a", "a"},
    {"aa", "â"},
    {"aaa", "aa"},
    {"aac", "âc"},
    //{"aacf", "ầc"},
    //{"aacff", "âcf"},
    {"aacj", "ậc"},
    {"aacjj", "âcj"},
    //{"aacr", "ẩc"},
    //{"aacrr", "âcr"},
    {"aacs", "ấc"},
    {"aacss", "âcs"},
    //{"aacx", "ẫc"},
    //{"aacxx", "âcx"},
    {"aaf", "ầ"},
    {"aaff", "âf"},
    {"aaj", "ậ"},
    {"aajj", "âj"},
    {"aam", "âm"},
    {"aamf", "ầm"},
    {"aamff", "âmf"},
    {"aamj", "ậm"},
    {"aamjj", "âmj"},
    {"aamr", "ẩm"},
    {"aamrr", "âmr"},
    {"aams", "ấm"},
    {"aamss", "âms"},
    {"aamx", "ẫm"},
    {"aamxx", "âmx"},
    {"aan", "ân"},
    {"aanf", "ần"},
    {"aanff", "ânf"},
    {"aang", "âng"},
    {"aangf", "ầng"},
    {"aangff", "ângf"},
    {"aangj", "ậng"},
    {"aangjj", "ângj"},
    {"aangr", "ẩng"},
    {"aangrr", "ângr"},
    {"aangs", "ấng"},
    {"aangss", "ângs"},
    {"aangx", "ẫng"},
    {"aangxx", "ângx"},
    {"aanj", "ận"},
    {"aanjj", "ânj"},
    {"aanr", "ẩn"},
    {"aanrr", "ânr"},
    {"aans", "ấn"},
    {"aanss", "âns"},
    {"aanx", "ẫn"},
    {"aanxx", "ânx"},
    {"aap", "âp"},
    //{"aapf", "ầp"},
    //{"aapff", "âpf"},
    {"aapj", "ập"},
    {"aapjj", "âpj"},
    //{"aapr", "ẩp"},
    //{"aaprr", "âpr"},
    {"aaps", "ấp"},
    {"aapss", "âps"},
    //{"aapx", "ẫp"},
    //{"aapxx", "âpx"},
    {"aar", "ẩ"},
    {"aarr", "âr"},
    {"aas", "ấ"},
    {"aass", "âs"},
    {"aat", "ât"},
    //{"aatf", "ầt"},
    //{"aatff", "âtf"},
    {"aatj", "ật"},
    {"aatjj", "âtj"},
    //{"aatr", "ẩt"},
    //{"aatrr", "âtr"},
    {"aats", "ất"},
    {"aatss", "âts"},
    //{"aatx", "ẫt"},
    //{"aatxx", "âtx"},
    {"aau", "âu"},
    {"aauf", "ầu"},
    {"aauff", "âuf"},
    {"aauj", "ậu"},
    {"aaujj", "âuj"},
    {"aaur", "ẩu"},
    {"aaurr", "âur"},
    {"aaus", "ấu"},
    {"aauss", "âus"},
    {"aaux", "ẫu"},
    {"aauxx", "âux"},
    {"aax", "ẫ"},
    {"aaxx", "âx"},
    {"aay", "ây"},
    {"aayf", "ầy"},
    {"aayff", "âyf"},
    {"aayj", "ậy"},
    {"aayjj", "âyj"},
    {"aayr", "ẩy"},
    {"aayrr", "âyr"},
    {"aays", "ấy"},
    {"aayss", "âys"},
    {"aayx", "ẫy"},
    {"aayxx", "âyx"},
    {"ac", "ac"},
    //{"acf", "àc"},
    //{"acff", "acf"},
    {"ach", "ach"},
    //{"achf", "àch"},
    //{"achff", "achf"},
    {"achj", "ạch"},
    {"achjj", "achj"},
    //{"achr", "ảch"},
    //{"achrr", "achr"},
    {"achs", "ách"},
    {"achss", "achs"},
    //{"achx", "ãch"},
    //{"achxx", "achx"},
    {"acj", "ạc"},
    {"acjj", "acj"},
    //{"acr", "ảc"},
    //{"acrr", "acr"},
    {"acs", "ác"},
    {"acss", "acs"},
    //{"acx", "ãc"},
    //{"acxx", "acx"},
    {"af", "à"},
    {"aff", "af"},
    {"ai", "ai"},
    {"aif", "ài"},
    {"aiff", "aif"},
    {"aij", "ại"},
    {"aijj", "aij"},
    {"air", "ải"},
    {"airr", "air"},
    {"ais", "ái"},
    {"aiss", "ais"},
    {"aix", "ãi"},
    {"aixx", "aix"},
    {"aj", "ạ"},
    {"ajj", "aj"},
    {"am", "am"},
    {"amf", "àm"},
    {"amff", "amf"},
    {"amj", "ạm"},
    {"amjj", "amj"},
    {"amr", "ảm"},
    {"amrr", "amr"},
    {"ams", "ám"},
    {"amss", "ams"},
    {"amx", "ãm"},
    {"amxx", "amx"},
    {"an", "an"},
    {"anf", "àn"},
    {"anff", "anf"},
    {"ang", "ang"},
    {"angf", "àng"},
    {"angff", "angf"},
    {"angj", "ạng"},
    {"angjj", "angj"},
    {"angr", "ảng"},
    {"angrr", "angr"},
    {"angs", "áng"},
    {"angss", "angs"},
    {"angx", "ãng"},
    {"angxx", "angx"},
    {"anh", "anh"},
    {"anhf", "ành"},
    {"anhff", "anhf"},
    {"anhj", "ạnh"},
    {"anhjj", "anhj"},
    {"anhr", "ảnh"},
    {"anhrr", "anhr"},
    {"anhs", "ánh"},
    {"anhss", "anhs"},
    {"anhx", "ãnh"},
    {"anhxx", "anhx"},
    {"anj", "ạn"},
    {"anjj", "anj"},
    {"anr", "ản"},
    {"anrr", "anr"},
    {"ans", "án"},
    {"anss", "ans"},
    {"anx", "ãn"},
    {"anxx", "anx"},
    {"ao", "ao"},
    {"aof", "ào"},
    {"aoff", "aof"},
    {"aoj", "ạo"},
    {"aojj", "aoj"},
    {"aor", "ảo"},
    {"aorr", "aor"},
    {"aos", "áo"},
    {"aoss", "aos"},
    {"aox", "ão"},
    {"aoxx", "aox"},
    {"ap", "ap"},
    //{"apf", "àp"},
    //{"apff", "apf"},
    {"apj", "ạp"},
    {"apjj", "apj"},
    //{"apr", "ảp"},
    //{"aprr", "apr"},
    {"aps", "áp"},
    {"apss", "aps"},
    //{"apx", "ãp"},
    //{"apxx", "apx"},
    {"ar", "ả"},
    {"arr", "ar"},
    {"as", "á"},
    {"ass", "as"},
    {"at", "at"},
    //{"atf", "àt"},
    //{"atff", "atf"},
    {"atj", "ạt"},
    {"atjj", "atj"},
    //{"atr", "ảt"},
    //{"atrr", "atr"},
    {"ats", "át"},
    {"atss", "ats"},
    //{"atx", "ãt"},
    //{"atxx", "atx"},
    {"au", "au"},
    {"auf", "àu"},
    {"auff", "auf"},
    {"auj", "ạu"},
    {"aujj", "auj"},
    {"aur", "ảu"},
    {"aurr", "aur"},
    {"aus", "áu"},
    {"auss", "aus"},
    {"aux", "ãu"},
    {"auxx", "aux"},
    {"aw", "ă"},
    {"awc", "ăc"},
    //{"awcf", "ằc"},
    //{"awcff", "ăcf"},
    {"awcj", "ặc"},
    {"awcjj", "ăcj"},
    //{"awcr", "ẳc"},
    //{"awcrr", "ăcr"},
    {"awcs", "ắc"},
    {"awcss", "ăcs"},
    //{"awcx", "ẵc"},
    //{"awcxx", "ăcx"},
    {"awf", "ằ"},
    {"awff", "ăf"},
    {"awj", "ặ"},
    {"awjj", "ăj"},
    {"awm", "ăm"},
    {"awmf", "ằm"},
    {"awmff", "ămf"},
    {"awmj", "ặm"},
    {"awmjj", "ămj"},
    {"awmr", "ẳm"},
    {"awmrr", "ămr"},
    {"awms", "ắm"},
    {"awmss", "ăms"},
    {"awmx", "ẵm"},
    {"awmxx", "ămx"},
    {"awn", "ăn"},
    {"awnf", "ằn"},
    {"awnff", "ănf"},
    {"awng", "ăng"},
    {"awngf", "ằng"},
    {"awngff", "ăngf"},
    {"awngj", "ặng"},
    {"awngjj", "ăngj"},
    {"awngr", "ẳng"},
    {"awngrr", "ăngr"},
    {"awngs", "ắng"},
    {"awngss", "ăngs"},
    {"awngx", "ẵng"},
    {"awngxx", "ăngx"},
    {"awnj", "ặn"},
    {"awnjj", "ănj"},
    {"awnr", "ẳn"},
    {"awnrr", "ănr"},
    {"awns", "ắn"},
    {"awnss", "ăns"},
    {"awnx", "ẵn"},
    {"awnxx", "ănx"},
    {"awp", "ăp"},
    //{"awpf", "ằp"},
    //{"awpff", "ăpf"},
    {"awpj", "ặp"},
    {"awpjj", "ăpj"},
    //{"awpr", "ẳp"},
    //{"awprr", "ăpr"},
    {"awps", "ắp"},
    {"awpss", "ăps"},
    //{"awpx", "ẵp"},
    //{"awpxx", "ăpx"},
    {"awr", "ẳ"},
    {"awrr", "ăr"},
    {"aws", "ắ"},
    {"awss", "ăs"},
    {"awt", "ăt"},
    //{"awtf", "ằt"},
    //{"awtff", "ătf"},
    {"awtj", "ặt"},
    {"awtjj", "ătj"},
    //{"awtr", "ẳt"},
    //{"awtrr", "ătr"},
    {"awts", "ắt"},
    {"awtss", "ăts"},
    //{"awtx", "ẵt"},
    //{"awtxx", "ătx"},
    {"aww", "aw"},
    {"awx", "ẵ"},
    {"awxx", "ăx"},
    {"ax", "ã"},
    {"axx", "ax"},
    {"ay", "ay"},
    {"ayf", "ày"},
    {"ayff", "ayf"},
    {"ayj", "ạy"},
    {"ayjj", "ayj"},
    {"ayr", "ảy"},
    {"ayrr", "ayr"},
    {"ays", "áy"},
    {"ayss", "ays"},
    {"ayx", "ãy"},
    {"ayxx", "ayx"},
    {"d", "d"},
    {"dd", "đ"},
    {"ddd", "dd"},
    {"e", "e"},
    {"ec", "ec"},
    //{"ecf", "èc"},
    //{"ecff", "ecf"},
    {"ecj", "ẹc"},
    {"ecjj", "ecj"},
    //{"ecr", "ẻc"},
    //{"ecrr", "ecr"},
    {"ecs", "éc"},
    {"ecss", "ecs"},
    //{"ecx", "ẽc"},
    //{"ecxx", "ecx"},
    {"ee", "ê"},
    {"eec", "êc"},
    //{"eecf", "ềc"},
    //{"eecff", "êcf"},
    {"eech", "êch"},
    //{"eechf", "ềch"},
    //{"eechff", "êchf"},
    {"eechj", "ệch"},
    {"eechjj", "êchj"},
    //{"eechr", "ểch"},
    //{"eechrr", "êchr"},
    {"eechs", "ếch"},
    {"eechss", "êchs"},
    //{"eechx", "ễch"},
    //{"eechxx", "êchx"},
    {"eecj", "ệc"},
    {"eecjj", "êcj"},
    //{"eecr", "ểc"},
    //{"eecrr", "êcr"},
    {"eecs", "ếc"},
    {"eecss", "êcs"},
    //{"eecx", "ễc"},
    //{"eecxx", "êcx"},
    {"eee", "ee"},
    {"eef", "ề"},
    {"eeff", "êf"},
    {"eej", "ệ"},
    {"eejj", "êj"},
    {"eem", "êm"},
    {"eemf", "ềm"},
    {"eemff", "êmf"},
    {"eemj", "ệm"},
    {"eemjj", "êmj"},
    {"eemr", "ểm"},
    {"eemrr", "êmr"},
    {"eems", "ếm"},
    {"eemss", "êms"},
    {"eemx", "ễm"},
    {"eemxx", "êmx"},
    {"een", "ên"},
    {"eenf", "ền"},
    {"eenff", "ênf"},
    {"eeng", "êng"},
    //{"eengf", "ềng"},
    //{"eengff", "êngf"},
    //{"eengj", "ệng"},
    //{"eengjj", "êngj"},
    //{"eengr", "ểng"},
    //{"eengrr", "êngr"},
    //{"eengs", "ếng"},
    //{"eengss", "êngs"},
    //{"eengx", "ễng"},
    //{"eengxx", "êngx"},
    {"eenh", "ênh"},
    {"eenhf", "ềnh"},
    {"eenhff", "ênhf"},
    {"eenhj", "ệnh"},
    {"eenhjj", "ênhj"},
    {"eenhr", "ểnh"},
    {"eenhrr", "ênhr"},
    {"eenhs", "ếnh"},
    {"eenhss", "ênhs"},
    {"eenhx", "ễnh"},
    {"eenhxx", "ênhx"},
    {"eenj", "ện"},
    {"eenjj", "ênj"},
    {"eenr", "ển"},
    {"eenrr", "ênr"},
    {"eens", "ến"},
    {"eenss", "êns"},
    {"eenx", "ễn"},
    {"eenxx", "ênx"},
    {"eep", "êp"},
    //{"eepf", "ềp"},
    //{"eepff", "êpf"},
    {"eepj", "ệp"},
    {"eepjj", "êpj"},
    //{"eepr", "ểp"},
    //{"eeprr", "êpr"},
    {"eeps", "ếp"},
    {"eepss", "êps"},
    //{"eepx", "ễp"},
    //{"eepxx", "êpx"},
    {"eer", "ể"},
    {"eerr", "êr"},
    {"ees", "ế"},
    {"eess", "ês"},
    {"eet", "êt"},
    //{"eetf", "ềt"},
    //{"eetff", "êtf"},
    {"eetj", "ệt"},
    {"eetjj", "êtj"},
    //{"eetr", "ểt"},
    //{"eetrr", "êtr"},
    {"eets", "ết"},
    {"eetss", "êts"},
    //{"eetx", "ễt"},
    //{"eetxx", "êtx"},
    {"eeu", "êu"},
    {"eeuf", "ều"},
    {"eeuff", "êuf"},
    {"eeuj", "ệu"},
    {"eeujj", "êuj"},
    {"eeur", "ểu"},
    {"eeurr", "êur"},
    {"eeus", "ếu"},
    {"eeuss", "êus"},
    {"eeux", "ễu"},
    {"eeuxx", "êux"},
    {"eex", "ễ"},
    {"eexx", "êx"},
    {"ef", "è"},
    {"eff", "ef"},
    {"ej", "ẹ"},
    {"ejj", "ej"},
    {"em", "em"},
    {"emf", "èm"},
    {"emff", "emf"},
    {"emj", "ẹm"},
    {"emjj", "emj"},
    {"emr", "ẻm"},
    {"emrr", "emr"},
    {"ems", "ém"},
    {"emss", "ems"},
    {"emx", "ẽm"},
    {"emxx", "emx"},
    {"en", "en"},
    {"enf", "èn"},
    {"enff", "enf"},
    {"eng", "eng"},
    {"engf", "èng"},
    {"engff", "engf"},
    {"engj", "ẹng"},
    {"engjj", "engj"},
    {"engr", "ẻng"},
    {"engrr", "engr"},
    {"engs", "éng"},
    {"engss", "engs"},
    {"engx", "ẽng"},
    {"engxx", "engx"},
    {"enj", "ẹn"},
    {"enjj", "enj"},
    {"enr", "ẻn"},
    {"enrr", "enr"},
    {"ens", "én"},
    {"enss", "ens"},
    {"enx", "ẽn"},
    {"enxx", "enx"},
    {"eo", "eo"},
    {"eof", "èo"},
    {"eoff", "eof"},
    {"eoj", "ẹo"},
    {"eojj", "eoj"},
    {"eor", "ẻo"},
    {"eorr", "eor"},
    {"eos", "éo"},
    {"eoss", "eos"},
    {"eox", "ẽo"},
    {"eoxx", "eox"},
    {"ep", "ep"},
    //{"epf", "èp"},
    //{"epff", "epf"},
    {"epj", "ẹp"},
    {"epjj", "epj"},
    //{"epr", "ẻp"},
    //{"eprr", "epr"},
    {"eps", "ép"},
    {"epss", "eps"},
    //{"epx", "ẽp"},
    //{"epxx", "epx"},
    {"er", "ẻ"},
    {"err", "er"},
    {"es", "é"},
    {"ess", "es"},
    {"et", "et"},
    //{"etf", "èt"},
    //{"etff", "etf"},
    {"etj", "ẹt"},
    {"etjj", "etj"},
    //{"etr", "ẻt"},
    //{"etrr", "etr"},
    {"ets", "ét"},
    {"etss", "ets"},
    //{"etx", "ẽt"},
    //{"etxx", "etx"},
    {"ex", "ẽ"},
    {"exx", "ex"},
    {"i", "i"},
    {"ia", "ia"},
    {"iaf", "ìa"},
    {"iaff", "iaf"},
    {"iaj", "ịa"},
    {"iajj", "iaj"},
    {"iar", "ỉa"},
    {"iarr", "iar"},
    {"ias", "ía"},
    {"iass", "ias"},
    {"iax", "ĩa"},
    {"iaxx", "iax"},
    {"ic", "ic"},
    {"ich", "ich"},
    //{"ichf", "ìch"},
    //{"ichff", "ichf"},
    {"ichj", "ịch"},
    {"ichjj", "ichj"},
    //{"ichr", "ỉch"},
    //{"ichrr", "ichr"},
    {"ichs", "ích"},
    {"ichss", "ichs"},
    //{"ichx", "ĩch"},
    //{"ichxx", "ichx"},
    {"if", "ì"},
    {"iff", "if"},
    {"ij", "ị"},
    {"ijj", "ij"},
    {"im", "im"},
    {"imf", "ìm"},
    {"imff", "imf"},
    {"imj", "ịm"},
    {"imjj", "imj"},
    {"imr", "ỉm"},
    {"imrr", "imr"},
    {"ims", "ím"},
    {"imss", "ims"},
    {"imx", "ĩm"},
    {"imxx", "imx"},
    {"in", "in"},
    {"inf", "ìn"},
    {"inff", "inf"},
    {"inh", "inh"},
    {"inhf", "ình"},
    {"inhff", "inhf"},
    {"inhj", "ịnh"},
    {"inhjj", "inhj"},
    {"inhr", "ỉnh"},
    {"inhrr", "inhr"},
    {"inhs", "ính"},
    {"inhss", "inhs"},
    {"inhx", "ĩnh"},
    {"inhxx", "inhx"},
    {"inj", "ịn"},
    {"injj", "inj"},
    {"inr", "ỉn"},
    {"inrr", "inr"},
    {"ins", "ín"},
    {"inss", "ins"},
    {"inx", "ĩn"},
    {"inxx", "inx"},
    {"ip", "ip"},
    //{"ipf", "ìp"},
    //{"ipff", "ipf"},
    {"ipj", "ịp"},
    {"ipjj", "ipj"},
    //{"ipr", "ỉp"},
    //{"iprr", "ipr"},
    {"ips", "íp"},
    {"ipss", "ips"},
    //{"ipx", "ĩp"},
    //{"ipxx", "ipx"},
    {"ir", "ỉ"},
    {"irr", "ir"},
    {"is", "í"},
    {"iss", "is"},
    {"it", "it"},
    //{"itf", "ìt"},
    //{"itff", "itf"},
    {"itj", "ịt"},
    {"itjj", "itj"},
    //{"itr", "ỉt"},
    //{"itrr", "itr"},
    {"its", "ít"},
    {"itss", "its"},
    // {"itx", "ĩt"},
    // {"itxx", "itx"},
    {"iu", "iu"},
    {"iuf", "ìu"},
    {"iuff", "iuf"},
    {"iuj", "ịu"},
    {"iujj", "iuj"},
    {"iur", "ỉu"},
    {"iurr", "iur"},
    {"ius", "íu"},
    {"iuss", "ius"},
    {"iux", "ĩu"},
    {"iuxx", "iux"},
    {"ix", "ĩ"},
    {"ixx", "ix"},
    {"huwou", "hươu"},
    {"o", "o"},
    {"oc", "oc"},
    // {"ocf", "òc"},
    // {"ocff", "ocf"},
    {"ocj", "ọc"},
    {"ocjj", "ocj"},
    // {"ocr", "ỏc"},
    // {"ocrr", "ocr"},
    {"ocs", "óc"},
    {"ocss", "ocs"},
    // {"ocx", "õc"},
    // {"ocxx", "ocx"},
    {"of", "ò"},
    {"off", "of"},
    {"oi", "oi"},
    {"oif", "òi"},
    {"oiff", "oif"},
    {"oij", "ọi"},
    {"oijj", "oij"},
    {"oir", "ỏi"},
    {"oirr", "oir"},
    {"ois", "ói"},
    {"oiss", "ois"},
    {"oix", "õi"},
    {"oixx", "oix"},
    {"oj", "ọ"},
    {"ojj", "oj"},
    {"om", "om"},
    {"omf", "òm"},
    {"omff", "omf"},
    {"omj", "ọm"},
    {"omjj", "omj"},
    {"omr", "ỏm"},
    {"omrr", "omr"},
    {"oms", "óm"},
    {"omss", "oms"},
    {"omx", "õm"},
    {"omxx", "omx"},
    {"on", "on"},
    {"onf", "òn"},
    {"onff", "onf"},
    {"ong", "ong"},
    {"ongf", "òng"},
    {"ongff", "ongf"},
    {"ongj", "ọng"},
    {"ongjj", "ongj"},
    {"ongr", "ỏng"},
    {"ongrr", "ongr"},
    {"ongs", "óng"},
    {"ongss", "ongs"},
    {"ongx", "õng"},
    {"ongxx", "ongx"},
    {"onj", "ọn"},
    {"onjj", "onj"},
    {"onr", "ỏn"},
    {"onrr", "onr"},
    {"ons", "ón"},
    {"onss", "ons"},
    {"onx", "õn"},
    {"onxx", "onx"},
    {"oo", "ô"},
    {"ooc", "ôc"},
    // {"oocf", "ồc"},
    // {"oocff", "ôcf"},
    {"oocj", "ộc"},
    {"oocjj", "ôcj"},
    // {"oocr", "ổc"},
    // {"oocrr", "ôcr"},
    {"oocs", "ốc"},
    {"oocss", "ôcs"},
    // {"oocx", "ỗc"},
    // {"oocxx", "ôcx"},
    {"oof", "ồ"},
    {"ooff", "ôf"},
    {"ooi", "ôi"},
    {"ooif", "ồi"},
    {"ooiff", "ôif"},
    {"ooij", "ội"},
    {"ooijj", "ôij"},
    {"ooir", "ổi"},
    {"ooirr", "ôir"},
    {"oois", "ối"},
    {"ooiss", "ôis"},
    {"ooix", "ỗi"},
    {"ooixx", "ôix"},
    {"ooj", "ộ"},
    {"oojj", "ôj"},
    {"oom", "ôm"},
    {"oomf", "ồm"},
    {"oomff", "ômf"},
    {"oomj", "ộm"},
    {"oomjj", "ômj"},
    {"oomr", "ổm"},
    {"oomrr", "ômr"},
    {"ooms", "ốm"},
    {"oomss", "ôms"},
    {"oomx", "ỗm"},
    {"oomxx", "ômx"},
    {"oon", "ôn"},
    {"oonf", "ồn"},
    {"oonff", "ônf"},
    {"oong", "ông"},
    {"oongf", "ồng"},
    {"oongff", "ôngf"},
    {"oongj", "ộng"},
    {"oongjj", "ôngj"},
    {"oongr", "ổng"},
    {"oongrr", "ôngr"},
    {"oongs", "ống"},
    {"oongss", "ôngs"},
    {"oongx", "ỗng"},
    {"oongxx", "ôngx"},
    {"oonj", "ộn"},
    {"oonjj", "ônj"},
    {"oonr", "ổn"},
    {"oonrr", "ônr"},
    {"oons", "ốn"},
    {"oonss", "ôns"},
    {"oonx", "ỗn"},
    {"oonxx", "ônx"},
    {"ooo", "oo"},
    {"oooc", "ooc"},
    // {"ooocf", "oòc"},
    // {"ooocff", "oocf"},
    {"ooocj", "oọc"},
    {"ooocjj", "oocj"},
    // {"ooocr", "oỏc"},
    // {"ooocrr", "oocr"},
    {"ooocs", "oóc"},
    {"ooocss", "oocs"},
    // {"ooocx", "oõc"},
    // {"ooocxx", "oocx"},
    {"ooon", "oon"},
    {"ooong", "oong"},
    {"ooongf", "oòng"},
    {"ooongff", "oongf"},
    {"ooongj", "oọng"},
    {"ooongjj", "oongj"},
    {"ooongr", "oỏng"},
    {"ooongrr", "oongr"},
    {"ooongs", "oóng"},
    {"ooongss", "oongs"},
    {"ooongx", "oõng"},
    {"ooongxx", "oongx"},
    {"oop", "ôp"},
    // {"oopf", "ồp"},
    // {"oopff", "ôpf"},
    {"oopj", "ộp"},
    {"oopjj", "ôpj"},
    // {"oopr", "ổp"},
    // {"ooprr", "ôpr"},
    {"oops", "ốp"},
    {"oopss", "ôps"},
    // {"oopx", "ỗp"},
    // {"oopxx", "ôpx"},
    {"oor", "ổ"},
    {"oorr", "ôr"},
    {"oos", "ố"},
    {"ooss", "ôs"},
    {"oot", "ôt"},
    // {"ootf", "ồt"},
    // {"ootff", "ôtf"},
    {"ootj", "ột"},
    {"ootjj", "ôtj"},
    // {"ootr", "ổt"},
    // {"ootrr", "ôtr"},
    {"oots", "ốt"},
    {"ootss", "ôts"},
    // {"ootx", "ỗt"},
    // {"ootxx", "ôtx"},
    {"oox", "ỗ"},
    {"ooxx", "ôx"},
    {"op", "op"},
    // {"opf", "òp"},
    // {"opff", "opf"},
    {"opj", "ọp"},
    {"opjj", "opj"},
    // {"opr", "ỏp"},
    // {"oprr", "opr"},
    {"ops", "óp"},
    {"opss", "ops"},
    // {"opx", "õp"},
    // {"opxx", "opx"},
    {"or", "ỏ"},
    {"orr", "or"},
    {"os", "ó"},
    {"oss", "os"},
    {"ot", "ot"},
    // {"otf", "òt"},
    // {"otff", "otf"},
    {"otj", "ọt"},
    {"otjj", "otj"},
    // {"otr", "ỏt"},
    // {"otrr", "otr"},
    {"ots", "ót"},
    {"otss", "ots"},
    // {"otx", "õt"},
    // {"otxx", "otx"},
    {"ow", "ơ"},
    {"owf", "ờ"},
    {"owff", "ơf"},
    {"owi", "ơi"},
    {"owif", "ời"},
    {"owiff", "ơif"},
    {"owij", "ợi"},
    {"owijj", "ơij"},
    {"owir", "ởi"},
    {"owirr", "ơir"},
    {"owis", "ới"},
    {"owiss", "ơis"},
    {"owix", "ỡi"},
    {"owixx", "ơix"},
    {"owj", "ợ"},
    {"owjj", "ơj"},
    {"owm", "ơm"},
    {"owmf", "ờm"},
    {"owmff", "ơmf"},
    {"owmj", "ợm"},
    {"owmjj", "ơmj"},
    {"owmr", "ởm"},
    {"owmrr", "ơmr"},
    {"owms", "ớm"},
    {"owmss", "ơms"},
    {"owmx", "ỡm"},
    {"owmxx", "ơmx"},
    {"own", "ơn"},
    {"ownf", "ờn"},
    {"ownff", "ơnf"},
    {"ownj", "ợn"},
    {"ownjj", "ơnj"},
    {"ownr", "ởn"},
    {"ownrr", "ơnr"},
    {"owns", "ớn"},
    {"ownss", "ơns"},
    {"ownx", "ỡn"},
    {"ownxx", "ơnx"},
    {"owp", "ơp"},
    // {"owpf", "ờp"},
    // {"owpff", "ơpf"},
    {"owpj", "ợp"},
    {"owpjj", "ơpj"},
    // {"owpr", "ởp"},
    // {"owprr", "ơpr"},
    {"owps", "ớp"},
    {"owpss", "ơps"},
    // {"owpx", "ỡp"},
    // {"owpxx", "ơpx"},
    {"owr", "ở"},
    {"owrr", "ơr"},
    {"ows", "ớ"},
    {"owss", "ơs"},
    {"owt", "ơt"},
    // {"owtf", "ờt"},
    // {"owtff", "ơtf"},
    {"owtj", "ợt"},
    {"owtjj", "ơtj"},
    // {"owtr", "ởt"},
    // {"owtrr", "ơtr"},
    {"owts", "ớt"},
    {"owtss", "ơts"},
    // {"owtx", "ỡt"},
    // {"owtxx", "ơtx"},
    {"oww", "ow"},
    {"owx", "ỡ"},
    {"owxx", "ơx"},
    {"ox", "õ"},
    {"oxx", "ox"},
    {"q", "q"},
    {"qu", "qu"},
    // {"quf", "qù"},
    // {"quff", "quf"},
    // {"quj", "qụ"},
    // {"qujj", "quj"},
    {"quo", "quo"},
    {"quof", "quò"},
    {"quoff", "quof"},
    {"quoj", "quọ"},
    {"quojj", "quoj"},
    {"quor", "quỏ"},
    {"quorr", "quor"},
    {"quos", "quó"},
    {"quoss", "quos"},
    {"quow", "quơ"},
    {"quowc", "quơc"},
    // {"quowcf", "quờc"},
    // {"quowcff", "quơcf"},
    // {"quowcj", "quợc"},
    // {"quowcjj", "quơcj"},
    // {"quowcr", "quởc"},
    // {"quowcrr", "quơcr"},
    // {"quowcs", "quớc"},
    // {"quowcss", "quơcs"},
    // {"quowcx", "quỡc"},
    // {"quowcxx", "quơcx"},
    {"quowf", "quờ"},
    {"quowff", "quơf"},
    {"quowi", "quơi"},
    {"quowif", "quời"},
    {"quowiff", "quơif"},
    {"quowij", "quợi"},
    {"quowijj", "quơij"},
    {"quowir", "quởi"},
    {"quowirr", "quơir"},
    {"quowis", "quới"},
    {"quowiss", "quơis"},
    {"quowix", "quỡi"},
    {"quowixx", "quơix"},
    {"quowj", "quợ"},
    {"quowjj", "quơj"},
    {"quowm", "quơm"},
    {"quowmf", "quờm"},
    {"quowmff", "quơmf"},
    {"quowmj", "quợm"},
    {"quowmjj", "quơmj"},
    {"quowmr", "quởm"},
    {"quowmrr", "quơmr"},
    {"quowms", "quớm"},
    {"quowmss", "quơms"},
    {"quowmx", "quỡm"},
    {"quowmxx", "quơmx"},
    {"quown", "quơn"},
    {"quownf", "quờn"},
    {"quownff", "quơnf"},
    {"quowng", "quơng"},
    // {"quowngf", "quờng"},
    // {"quowngff", "quơngf"},
    // {"quowngj", "quợng"},
    // {"quowngjj", "quơngj"},
    // {"quowngr", "quởng"},
    // {"quowngrr", "quơngr"},
    // {"quowngs", "quớng"},
    // {"quowngss", "quơngs"},
    // {"quowngx", "quỡng"},
    // {"quowngxx", "quơngx"},
    {"quownj", "quợn"},
    {"quownjj", "quơnj"},
    {"quownr", "quởn"},
    {"quownrr", "quơnr"},
    {"quowns", "quớn"},
    {"quownss", "quơns"},
    {"quownx", "quỡn"},
    {"quownxx", "quơnx"},
    {"quowp", "quơp"},
    // {"quowpf", "quờp"},
    // {"quowpff", "quơpf"},
    // {"quowpj", "quợp"},
    // {"quowpjj", "quơpj"},
    // {"quowpr", "quởp"},
    // {"quowprr", "quơpr"},
    {"quowps", "quớp"},
    {"quowpss", "quơps"},
    // {"quowpx", "quỡp"},
    // {"quowpxx", "quơpx"},
    {"quowr", "quở"},
    {"quowrr", "quơr"},
    {"quows", "quớ"},
    {"quowss", "quơs"},
    {"quowt", "quơt"},
    // {"quowtf", "quờt"},
    // {"quowtff", "quơtf"},
    {"quowtj", "quợt"},
    {"quowtjj", "quơtj"},
    // {"quowtr", "quởt"},
    // {"quowtrr", "quơtr"},
    {"quowts", "quớt"},
    {"quowtss", "quơts"},
    // {"quowtx", "quỡt"},
    // {"quowtxx", "quơtx"},
    {"quowu", "quơu"},
    // {"quowuf", "quờu"},
    // {"quowuff", "quơuf"},
    // {"quowuj", "quợu"},
    // {"quowujj", "quơuj"},
    // {"quowur", "quởu"},
    // {"quowurr", "quơur"},
    // {"quowus", "quớu"},
    // {"quowuss", "quơus"},
    // {"quowux", "quỡu"},
    // {"quowuxx", "quơux"},
    {"quoww", "quow"},
    {"quowx", "quỡ"},
    {"quowxx", "quơx"},
    {"quox", "quõ"},
    {"quoxx", "quox"},
    // {"qur", "qủ"},
    // {"qurr", "qur"},
    // {"qus", "qú"},
    // {"quss", "qus"},
    // {"qux", "qũ"},
    // {"quxx", "qux"},
    {"qw", "qw"},
    {"quw", "quw"},
    {"t", "t"},
    {"th", "th"},
    {"thu", "thu"},
    {"thuf", "thù"},
    {"thuff", "thuf"},
    {"thuj", "thụ"},
    {"thujj", "thuj"},
    {"thuo", "thuo"},
    // {"thuof", "thuò"},
    {"thuoff", "thuof"},
    // {"thuoj", "thuọ"},
    {"thuojj", "thuoj"},
    // {"thuor", "thuỏ"},
    {"thuorr", "thuor"},
    // {"thuos", "thuó"},
    {"thuoss", "thuos"},
    {"thuow", "thuơ"},
    {"thuowc", "thươc"},
    // {"thuowcf", "thườc"},
    // {"thuowcff", "thươcf"},
    {"thuowcj", "thược"},
    {"thuowcjj", "thươcj"},
    // {"thuowcr", "thưởc"},
    // {"thuowcrr", "thươcr"},
    {"thuowcs", "thước"},
    {"thuowcss", "thươcs"},
    // {"thuowcx", "thưỡc"},
    // {"thuowcxx", "thươcx"},
    {"thuowf", "thuờ"},
    {"thuowff", "thuơf"},
    {"thuowj", "thuợ"},
    {"thuowjj", "thuơj"},
    {"thuowm", "thươm"},
    {"thuowmf", "thườm"},
    {"thuowmff", "thươmf"},
    {"thuowmj", "thượm"},
    {"thuowmjj", "thươmj"},
    {"thuowmr", "thưởm"},
    {"thuowmrr", "thươmr"},
    {"thuowms", "thướm"},
    {"thuowmss", "thươms"},
    {"thuowmx", "thưỡm"},
    {"thuowmxx", "thươmx"},
    {"thuown", "thươn"},
    {"thuownf", "thườn"},
    {"thuownff", "thươnf"},
    {"thuowng", "thương"},
    {"thuowngf", "thường"},
    {"thuowngff", "thươngf"},
    {"thuowngj", "thượng"},
    {"thuowngjj", "thươngj"},
    {"thuowngr", "thưởng"},
    {"thuowngrr", "thươngr"},
    {"thuowngs", "thướng"},
    {"thuowngss", "thươngs"},
    {"thuowngx", "thưỡng"},
    {"thuowngxx", "thươngx"},
    {"thuownj", "thượn"},
    {"thuownjj", "thươnj"},
    {"thuownr", "thưởn"},
    {"thuownrr", "thươnr"},
    {"thuowns", "thướn"},
    {"thuownss", "thươns"},
    {"thuownx", "thưỡn"},
    {"thuownxx", "thươnx"},
    {"thuowp", "thươp"},
    // {"thuowpf", "thườp"},
    // {"thuowpff", "thươpf"},
    {"thuowpj", "thượp"},
    {"thuowpjj", "thươpj"},
    // {"thuowpr", "thưởp"},
    // {"thuowprr", "thươpr"},
    {"thuowps", "thướp"},
    {"thuowpss", "thươps"},
    // {"thuowpx", "thưỡp"},
    // {"thuowpxx", "thươpx"},
    {"thuowr", "thuở"},
    {"thuowrr", "thuơr"},
    {"thuows", "thuớ"},
    {"thuowss", "thuơs"},
    {"thuowt", "thươt"},
    // {"thuowtf", "thườt"},
    // {"thuowtff", "thươtf"},
    {"thuowtj", "thượt"},
    {"thuowtjj", "thươtj"},
    // {"thuowtr", "thưởt"},
    // {"thuowtrr", "thươtr"},
    {"thuowts", "thướt"},
    {"thuowtss", "thươts"},
    // {"thuowtx", "thưỡt"},
    // {"thuowtxx", "thươtx"},
    {"thuoww", "thươ"},
    {"thuowwc", "thươc"},
    // {"thuowwcf", "thườc"},
    // {"thuowwcff", "thươcf"},
    {"thuowwcj", "thược"},
    {"thuowwcjj", "thươcj"},
    // {"thuowwcr", "thưởc"},
    // {"thuowwcrr", "thươcr"},
    {"thuowwcs", "thước"},
    {"thuowwcss", "thươcs"},
    // {"thuowwcx", "thưỡc"},
    // {"thuowwcxx", "thươcx"},
    {"thuowwf", "thườ"},
    {"thuowwff", "thươf"},
    {"thuowwi", "thươi"},
    {"thuowwif", "thười"},
    {"thuowwiff", "thươif"},
    {"thuowwij", "thượi"},
    {"thuowwijj", "thươij"},
    {"thuowwir", "thưởi"},
    {"thuowwirr", "thươir"},
    {"thuowwis", "thưới"},
    {"thuowwiss", "thươis"},
    {"thuowwix", "thưỡi"},
    {"thuowwixx", "thươix"},
    {"thuowwj", "thượ"},
    {"thuowwjj", "thươj"},
    {"thuowwm", "thươm"},
    {"thuowwmf", "thườm"},
    {"thuowwmff", "thươmf"},
    {"thuowwmj", "thượm"},
    {"thuowwmjj", "thươmj"},
    {"thuowwmr", "thưởm"},
    {"thuowwmrr", "thươmr"},
    {"thuowwms", "thướm"},
    {"thuowwmss", "thươms"},
    {"thuowwmx", "thưỡm"},
    {"thuowwmxx", "thươmx"},
    {"thuowwn", "thươn"},
    {"thuowwnf", "thườn"},
    {"thuowwnff", "thươnf"},
    {"thuowwng", "thương"},
    {"thuowwngf", "thường"},
    {"thuowwngff", "thươngf"},
    {"thuowwngj", "thượng"},
    {"thuowwngjj", "thươngj"},
    {"thuowwngr", "thưởng"},
    {"thuowwngrr", "thươngr"},
    {"thuowwngs", "thướng"},
    {"thuowwngss", "thươngs"},
    {"thuowwngx", "thưỡng"},
    {"thuowwngxx", "thươngx"},
    {"thuowwnj", "thượn"},
    {"thuowwnjj", "thươnj"},
    {"thuowwnr", "thưởn"},
    {"thuowwnrr", "thươnr"},
    {"thuowwns", "thướn"},
    {"thuowwnss", "thươns"},
    {"thuowwnx", "thưỡn"},
    {"thuowwnxx", "thươnx"},
    {"thuowwp", "thươp"},
    // {"thuowwpf", "thườp"},
    // {"thuowwpff", "thươpf"},
    {"thuowwpj", "thượp"},
    {"thuowwpjj", "thươpj"},
    // {"thuowwpr", "thưởp"},
    // {"thuowwprr", "thươpr"},
    {"thuowwps", "thướp"},
    {"thuowwpss", "thươps"},
    // {"thuowwpx", "thưỡp"},
    // {"thuowwpxx", "thươpx"},
    {"thuowwr", "thưở"},
    {"thuowwrr", "thươr"},
    {"thuowws", "thướ"},
    {"thuowwss", "thươs"},
    {"thuowwt", "thươt"},
    // {"thuowwtf", "thườt"},
    // {"thuowwtff", "thươtf"},
    {"thuowwtj", "thượt"},
    {"thuowwtjj", "thươtj"},
    // {"thuowwtr", "thưởt"},
    // {"thuowwtrr", "thươtr"},
    {"thuowwts", "thướt"},
    {"thuowwtss", "thươts"},
    // {"thuowwtx", "thưỡt"},
    // {"thuowwtxx", "thươtx"},
    {"thuowwu", "thươu"},
    {"thuowwuf", "thườu"},
    {"thuowwuff", "thươuf"},
    {"thuowwuj", "thượu"},
    {"thuowwujj", "thươuj"},
    {"thuowwur", "thưởu"},
    {"thuowwurr", "thươur"},
    {"thuowwus", "thướu"},
    {"thuowwuss", "thươus"},
    {"thuowwux", "thưỡu"},
    {"thuowwuxx", "thươux"},
    {"thuowww", "thuow"},
    {"thuowwx", "thưỡ"},
    {"thuowwxx", "thươx"},
    {"thuowx", "thuỡ"},
    {"thuowxx", "thuơx"},
    // {"thuox", "thuõ"},
    // {"thuoxx", "thuox"},
    {"thur", "thủ"},
    {"thurr", "thur"},
    {"thus", "thú"},
    {"thuss", "thus"},
    {"thux", "thũ"},
    {"thuxx", "thux"},
    {"u", "u"},
    {"ua", "ua"},
    {"uaf", "ùa"},
    {"uaff", "uaf"},
    {"uaj", "ụa"},
    {"uajj", "uaj"},
    {"uar", "ủa"},
    {"uarr", "uar"},
    {"uas", "úa"},
    {"uass", "uas"},
    {"uax", "ũa"},
    {"uaxx", "uax"},
    {"uc", "uc"},
    // {"ucf", "ùc"},
    // {"ucff", "ucf"},
    {"ucj", "ục"},
    {"ucjj", "ucj"},
    // {"ucr", "ủc"},
    // {"ucrr", "ucr"},
    {"ucs", "úc"},
    {"ucss", "ucs"},
    // {"ucx", "ũc"},
    // {"ucxx", "ucx"},
    {"uf", "ù"},
    {"uff", "uf"},
    {"ui", "ui"},
    {"uif", "ùi"},
    {"uiff", "uif"},
    {"uij", "ụi"},
    {"uijj", "uij"},
    {"uir", "ủi"},
    {"uirr", "uir"},
    {"uis", "úi"},
    {"uiss", "uis"},
    {"uix", "ũi"},
    {"uixx", "uix"},
    {"uj", "ụ"},
    {"ujj", "uj"},
    {"um", "um"},
    {"umf", "ùm"},
    {"umff", "umf"},
    {"umj", "ụm"},
    {"umjj", "umj"},
    {"umr", "ủm"},
    {"umrr", "umr"},
    {"ums", "úm"},
    {"umss", "ums"},
    {"umx", "ũm"},
    {"umxx", "umx"},
    {"un", "un"},
    {"unf", "ùn"},
    {"unff", "unf"},
    {"ung", "ung"},
    {"ungf", "ùng"},
    {"ungff", "ungf"},
    {"ungj", "ụng"},
    {"ungjj", "ungj"},
    {"ungr", "ủng"},
    {"ungrr", "ungr"},
    {"ungs", "úng"},
    {"ungss", "ungs"},
    {"ungx", "ũng"},
    {"ungxx", "ungx"},
    {"unj", "ụn"},
    {"unjj", "unj"},
    {"unr", "ủn"},
    {"unrr", "unr"},
    {"uns", "ún"},
    {"unss", "uns"},
    {"unx", "ũn"},
    {"unxx", "unx"},
    {"uo", "uo"},
    // {"uof", "uò"},
    // {"uoff", "uof"},
    // {"uoj", "uọ"},
    // {"uojj", "uoj"},
    // {"uor", "uỏ"},
    // {"uorr", "uor"},
    // {"uos", "uó"},
    // {"uoss", "uos"},
    {"uow", "uơ"},
    {"uowc", "ươc"},
    // {"uowcf", "ườc"},
    // {"uowcff", "ươcf"},
    {"uowcj", "ược"},
    {"uowcjj", "ươcj"},
    // {"uowcr", "ưởc"},
    // {"uowcrr", "ươcr"},
    {"uowcs", "ước"},
    {"uowcss", "ươcs"},
    // {"uowcx", "ưỡc"},
    // {"uowcxx", "ươcx"},
    {"uowf", "uờ"},
    {"uowff", "uơf"},
    {"uowi", "ươi"},
    {"uwoi", "ươi"},
    {"uowif", "ười"},
    {"uowiff", "ươif"},
    {"uowij", "ượi"},
    {"uowijj", "ươij"},
    {"uowir", "ưởi"},
    {"uowirr", "ươir"},
    {"uowis", "ưới"},
    {"uowiss", "ươis"},
    {"uowix", "ưỡi"},
    {"uowixx", "ươix"},
    {"uowj", "uợ"},
    {"uowjj", "uơj"},
    {"uowm", "ươm"},
    {"uowmf", "ườm"},
    {"uowmff", "ươmf"},
    {"uowmj", "ượm"},
    {"uowmjj", "ươmj"},
    {"uowmr", "ưởm"},
    {"uowmrr", "ươmr"},
    {"uowms", "ướm"},
    {"uowmss", "ươms"},
    {"uowmx", "ưỡm"},
    {"uowmxx", "ươmx"},
    {"uown", "ươn"},
    {"uownf", "ườn"},
    {"uownff", "ươnf"},
    {"uowng", "ương"},
    {"uowngf", "ường"},
    {"uowngff", "ươngf"},
    {"uowngj", "ượng"},
    {"uowngjj", "ươngj"},
    {"uowngr", "ưởng"},
    {"uowngrr", "ươngr"},
    {"uowngs", "ướng"},
    {"uowngss", "ươngs"},
    {"uowngx", "ưỡng"},
    {"uowngxx", "ươngx"},
    {"uownj", "ượn"},
    {"uownjj", "ươnj"},
    {"uownr", "ưởn"},
    {"uownrr", "ươnr"},
    {"uowns", "ướn"},
    {"uownss", "ươns"},
    {"uownx", "ưỡn"},
    {"uownxx", "ươnx"},
    {"uowp", "ươp"},
    // {"uowpf", "ườp"},
    // {"uowpff", "ươpf"},
    {"uowpj", "ượp"},
    {"uowpjj", "ươpj"},
    // {"uowpr", "ưởp"},
    // {"uowprr", "ươpr"},
    {"uowps", "ướp"},
    {"uowpss", "ươps"},
    // {"uowpx", "ưỡp"},
    // {"uowpxx", "ươpx"},
    {"uowr", "uở"},
    {"uowrr", "uơr"},
    {"uows", "uớ"},
    {"uowss", "uơs"},
    {"uowt", "ươt"},
    // {"uowtf", "ườt"},
    // {"uowtff", "ươtf"},
    {"uowtj", "ượt"},
    {"uowtjj", "ươtj"},
    // {"uowtr", "ưởt"},
    // {"uowtrr", "ươtr"},
    {"uowts", "ướt"},
    {"uowtss", "ươts"},
    // {"uowtx", "ưỡt"},
    // {"uowtxx", "ươtx"},
    {"uowu", "ươu"},
    {"uwou", "ươu"},
    {"uowuf", "ườu"},
    {"uowuff", "ươuf"},
    {"uowuj", "ượu"},
    {"uowujj", "ươuj"},
    {"uowur", "ưởu"},
    {"uowurr", "ươur"},
    {"uowus", "ướu"},
    {"uowuss", "ươus"},
    {"uowux", "ưỡu"},
    {"uowuxx", "ươux"},
    {"uoww", "ươ"},
    {"uowww", "uow"},
    {"uowx", "uỡ"},
    {"uowxx", "uơx"},
    {"uox", "ũo"},
    {"uoxx", "uox"},
    {"up", "up"},
    // {"upf", "ùp"},
    // {"upff", "upf"},
    {"upj", "ụp"},
    {"upjj", "upj"},
    // {"upr", "ủp"},
    // {"uprr", "upr"},
    {"ups", "úp"},
    {"upss", "ups"},
    // {"upx", "ũp"},
    // {"upxx", "upx"},
    {"ur", "ủ"},
    {"urr", "ur"},
    {"us", "ú"},
    {"uss", "us"},
    {"ut", "ut"},
    // {"utf", "ùt"},
    // {"utff", "utf"},
    {"utj", "ụt"},
    {"utjj", "utj"},
    // {"utr", "ủt"},
    // {"utrr", "utr"},
    {"uts", "út"},
    {"utss", "uts"},
    // {"utx", "ũt"},
    // {"utxx", "utx"},
    {"uw", "ư"},
    {"uwa", "ưa"},
    {"uwaf", "ừa"},
    {"uwaff", "ưaf"},
    {"uwaj", "ựa"},
    {"uwajj", "ưaj"},
    {"uwar", "ửa"},
    {"uwarr", "ưar"},
    {"uwas", "ứa"},
    {"uwass", "ưas"},
    {"uwax", "ữa"},
    {"uwaxx", "ưax"},
    {"uwc", "ưc"},
    // {"uwcf", "ừc"},
    // {"uwcff", "ưcf"},
    {"uwcj", "ực"},
    {"uwcjj", "ưcj"},
    // {"uwcr", "ửc"},
    // {"uwcrr", "ưcr"},
    {"uwcs", "ức"},
    {"uwcss", "ưcs"},
    // {"uwcx", "ữc"},
    // {"uwcxx", "ưcx"},
    {"uwf", "ừ"},
    {"uwff", "ưf"},
    {"uwi", "ưi"},
    {"uwif", "ừi"},
    {"uwiff", "ưif"},
    {"uwij", "ựi"},
    {"uwijj", "ưij"},
    {"uwir", "ửi"},
    {"uwirr", "ưir"},
    {"uwis", "ứi"},
    {"uwiss", "ưis"},
    {"uwix", "ữi"},
    {"uwixx", "ưix"},
    {"uwj", "ự"},
    {"uwjj", "ưj"},
    {"uwm", "ưm"},
    {"uwmf", "ừm"},
    {"uwmff", "ưmf"},
    {"uwmj", "ựm"},
    {"uwmjj", "ưmj"},
    {"uwmr", "ửm"},
    {"uwmrr", "ưmr"},
    {"uwms", "ứm"},
    {"uwmss", "ưms"},
    {"uwmx", "ữm"},
    {"uwmxx", "ưmx"},
    {"uwn", "ưn"},
    {"uwnf", "ừn"},
    {"uwnff", "ưnf"},
    {"uwng", "ưng"},
    {"uwngf", "ừng"},
    {"uwngff", "ưngf"},
    {"uwngj", "ựng"},
    {"uwngjj", "ưngj"},
    {"uwngr", "ửng"},
    {"uwngrr", "ưngr"},
    {"uwngs", "ứng"},
    {"uwngss", "ưngs"},
    {"uwngx", "ững"},
    {"uwngxx", "ưngx"},
    {"uwnj", "ựn"},
    {"uwnjj", "ưnj"},
    {"uwnr", "ửn"},
    {"uwnrr", "ưnr"},
    {"uwns", "ứn"},
    {"uwnss", "ưns"},
    {"uwnx", "ữn"},
    {"uwnxx", "ưnx"},
    {"uwr", "ử"},
    {"uwrr", "ưr"},
    {"uws", "ứ"},
    {"uwss", "ưs"},
    {"uwt", "ưt"},
    // {"uwtf", "ừt"},
    // {"uwtff", "ưtf"},
    {"uwtj", "ựt"},
    {"uwtjj", "ưtj"},
    // {"uwtr", "ửt"},
    // {"uwtrr", "ưtr"},
    {"uwts", "ứt"},
    {"uwtss", "ưts"},
    // {"uwtx", "ữt"},
    // {"uwtxx", "ưtx"},
    {"uwu", "ưu"},
    {"uwuf", "ừu"},
    {"uwuff", "ưuf"},
    {"uwuj", "ựu"},
    {"uwujj", "ưuj"},
    {"uwur", "ửu"},
    {"uwurr", "ưur"},
    {"uwus", "ứu"},
    {"uwuss", "ưus"},
    {"uwux", "ữu"},
    {"uwuxx", "ưux"},
    {"uww", "uw"},
    {"uwx", "ữ"},
    {"uwxx", "ưx"},
    {"ux", "ũ"},
    {"uxx", "ux"},
    {"w", "ư"},
    {"wa", "ưa"},
    {"waf", "ừa"},
    {"waff", "ưaf"},
    {"waj", "ựa"},
    {"wajj", "ưaj"},
    {"war", "ửa"},
    {"warr", "ưar"},
    {"was", "ứa"},
    {"wass", "ưas"},
    {"wax", "ữa"},
    {"waxx", "ưax"},
    {"wc", "ưc"},
    // {"wcf", "ừc"},
    // {"wcff", "ưcf"},
    {"wcj", "ực"},
    {"wcjj", "ưcj"},
    // {"wcr", "ửc"},
    // {"wcrr", "ưcr"},
    {"wcs", "ức"},
    {"wcss", "ưcs"},
    // {"wcx", "ữc"},
    // {"wcxx", "ưcx"},
    {"wf", "ừ"},
    {"wff", "ưf"},
    {"wi", "ưi"},
    {"wif", "ừi"},
    {"wiff", "ưif"},
    {"wij", "ựi"},
    {"wijj", "ưij"},
    {"wir", "ửi"},
    {"wirr", "ưir"},
    {"wis", "ứi"},
    {"wiss", "ưis"},
    {"wix", "ữi"},
    {"wixx", "ưix"},
    {"wj", "ự"},
    {"wjj", "ưj"},
    {"wm", "ưm"},
    {"wmf", "ừm"},
    {"wmff", "ưmf"},
    {"wmj", "ựm"},
    {"wmjj", "ưmj"},
    {"wmr", "ửm"},
    {"wmrr", "ưmr"},
    {"wms", "ứm"},
    {"wmss", "ưms"},
    {"wmx", "ữm"},
    {"wmxx", "ưmx"},
    {"wn", "ưn"},
    {"wnf", "ừn"},
    {"wnff", "ưnf"},
    {"wng", "ưng"},
    {"wngf", "ừng"},
    {"wngff", "ưngf"},
    {"wngj", "ựng"},
    {"wngjj", "ưngj"},
    {"wngr", "ửng"},
    {"wngrr", "ưngr"},
    {"wngs", "ứng"},
    {"wngss", "ưngs"},
    {"wngx", "ững"},
    {"wngxx", "ưngx"},
    {"wnj", "ựn"},
    {"wnjj", "ưnj"},
    {"wnr", "ửn"},
    {"wnrr", "ưnr"},
    {"wns", "ứn"},
    {"wnss", "ưns"},
    {"wnx", "ữn"},
    {"wnxx", "ưnx"},
    {"wr", "ử"},
    {"wrr", "ưr"},
    {"ws", "ứ"},
    {"wss", "ưs"},
    {"wt", "ưt"},
    // {"wtf", "ừt"},
    // {"wtff", "ưtf"},
    {"wtj", "ựt"},
    {"wtjj", "ưtj"},
    // {"wtr", "ửt"},
    // {"wtrr", "ưtr"},
    {"wts", "ứt"},
    {"wtss", "ưts"},
    // {"wtx", "ữt"},
    // {"wtxx", "ưtx"},
    {"wu", "ưu"},
    {"wuf", "ừu"},
    {"wuff", "ưuf"},
    {"wuj", "ựu"},
    {"wujj", "ưuj"},
    {"wur", "ửu"},
    {"wurr", "ưur"},
    {"wus", "ứu"},
    {"wuss", "ưus"},
    {"wux", "ữu"},
    {"wuxx", "ưux"},
    {"ww", "w"},
    {"www", "ww"},
    {"wwww", "www"},
    {"wx", "ữ"},
    {"wxx", "ưx"},
    {"y", "y"},
    {"ya", "ya"},
    // {"yaf", "ỳa"},
    // {"yaff", "yaf"},
    // {"yaj", "ỵa"},
    // {"yajj", "yaj"},
    // {"yar", "ỷa"},
    // {"yarr", "yar"},
    // {"yas", "ýa"},
    // {"yass", "yas"},
    // {"yax", "ỹa"},
    // {"yaxx", "yax"},
    {"yc", "yc"},
    {"ych", "ych"},
    // {"ychf", "ỳch"},
    // {"ychff", "ychf"},
    // {"ychj", "ỵch"},
    // {"ychjj", "ychj"},
    // {"ychr", "ỷch"},
    // {"ychrr", "ychr"},
    // {"ychs", "ých"},
    // {"ychss", "ychs"},
    // {"ychx", "ỹch"},
    // {"ychxx", "ychx"},
    {"yf", "ỳ"},
    {"yff", "yf"},
    {"yj", "ỵ"},
    {"yjj", "yj"},
    {"yn", "yn"},
    // {"ynf", "ỳn"},
    // {"ynff", "ynf"},
    // {"ynj", "ỵn"},
    // {"ynjj", "ynj"},
    {"ynn", "ynn"},
    // {"ynnf", "ỳnn"},
    // {"ynnff", "ynnf"},
    // {"ynnj", "ỵnn"},
    // {"ynnjj", "ynnj"},
    // {"ynnr", "ỷnn"},
    // {"ynnrr", "ynnr"},
    // {"ynns", "ýnn"},
    // {"ynnss", "ynns"},
    // {"ynnx", "ỹnn"},
    // {"ynnxx", "ynnx"},
    // {"ynr", "ỷn"},
    // {"ynrr", "ynr"},
    // {"yns", "ýn"},
    // {"ynss", "yns"},
    // {"ynx", "ỹn"},
    // {"ynxx", "ynx"},
    {"yp", "yp"},
    // {"ypf", "ỳp"},
    // {"ypff", "ypf"},
    // {"ypj", "ỵp"},
    // {"ypjj", "ypj"},
    // {"ypr", "ỷp"},
    // {"yprr", "ypr"},
    // {"yps", "ýp"},
    // {"ypss", "yps"},
    // {"ypx", "ỹp"},
    // {"ypxx", "ypx"},
    {"yr", "ỷ"},
    {"yrr", "yr"},
    {"ys", "ý"},
    {"yss", "ys"},
    {"yt", "yt"},
    // {"ytf", "ỳt"},
    // {"ytff", "ytf"},
    {"ytj", "ỵt"},
    {"ytjj", "ytj"},
    // {"ytr", "ỷt"},
    // {"ytrr", "ytr"},
    {"yts", "ýt"},
    {"ytss", "yts"},
    // {"ytx", "ỹt"},
    // {"ytxx", "ytx"},
    {"yu", "yu"},
    // {"yuf", "ỳu"},
    // {"yuff", "yuf"},
    // {"yuj", "ỵu"},
    // {"yujj", "yuj"},
    // {"yur", "ỷu"},
    // {"yurr", "yur"},
    // {"yus", "ýu"},
    // {"yuss", "yus"},
    // {"yux", "ỹu"},
    // {"yuxx", "yux"},
    {"yx", "ỹ"},
    {"yxx", "yx"},
};

void scheduleEvent(EventDispatcher *dispatcher, Instance *instance) {
    dispatcher->schedule([dispatcher, instance]() {
        auto *unikey = instance->addonManager().addon("unikey", true);
        FCITX_ASSERT(unikey);
        auto defaultGroup = instance->inputMethodManager().currentGroup();
        defaultGroup.inputMethodList().clear();
        defaultGroup.inputMethodList().push_back(
            InputMethodGroupItem("keyboard-us"));
        defaultGroup.inputMethodList().push_back(
            InputMethodGroupItem("unikey"));
        defaultGroup.setDefaultInputMethod("");
        instance->inputMethodManager().setGroup(defaultGroup);
        auto *testfrontend = instance->addonManager().addon("testfrontend");
        auto uuid =
            testfrontend->call<ITestFrontend::createInputContext>("testapp");
        auto *ic = instance->inputContextManager().findByUUID(uuid);
        ic->setCapabilityFlags(CapabilityFlag::SurroundingText);
        testfrontend->call<ITestFrontend::pushCommitExpectation>("ăo ");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("âo ");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("ăo ");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("ăo");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("awoo ");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("awo");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("aao");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("aao");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("aao");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("aao");
        testfrontend->call<ITestFrontend::pushCommitExpectation>("aao");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Control+space"),
                                                    false);
        RawConfig config;
        config.setValueByPath("SpellCheck", "False");
        unikey->setConfig(config);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("w"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("space"), false);

        config.setValueByPath("Macro", "False");
        unikey->setConfig(config);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("b"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("space"), false);

        config.setValueByPath("AutoNonVnRestore", "True");
        unikey->setConfig(config);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("w"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("space"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("w"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        config.setValueByPath("SpellCheck", "True");
        unikey->setConfig(config);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("w"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("space"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("w"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("a"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("o"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key(FcitxKey_ssharp),
                                                    false);

        config.setValueByPath("AutoNonVnRestore", "False");
        config.setValueByPath("SpellCheck", "False");
        config.setValueByPath("Macro", "True");
        unikey->setConfig(config);
        for (const auto &[_, expect] : expectedTelexData) {
            testfrontend->call<ITestFrontend::pushCommitExpectation>(expect);
        }

        for (const auto &[key, _] : expectedTelexData) {
            for (char c : key) {
                const char keyStr[2] = {c, '\0'};
                testfrontend->call<ITestFrontend::keyEvent>(uuid, Key(keyStr),
                                                            false);
            }
            testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"),
                                                        false);
        }

        ic->reset();
        ic->surroundingText().setText("q", 1, 1);
        ic->updateSurroundingText();
        testfrontend->call<ITestFrontend::pushCommitExpectation>("uẻ");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("u"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("e"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("r"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        ic->reset();
        ic->surroundingText().setText("reset", 5, 5);
        ic->updateSurroundingText();
        testfrontend->call<ITestFrontend::pushCommitExpectation>("e");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("e"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        config.setValueByPath("ModifySurroundingText", "True");
        unikey->setConfig(config);

        ic->reset();
        ic->surroundingText().setText("nga", 3, 3);
        ic->updateSurroundingText();
        testfrontend->call<ITestFrontend::pushCommitExpectation>("ngả");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("r"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        ic->reset();
        ic->surroundingText().setText("ngả nghieng", 11, 11);
        ic->updateSurroundingText();
        testfrontend->call<ITestFrontend::pushCommitExpectation>("nghiêng");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("e"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        ic->reset();
        ic->surroundingText().setText("ngả nghieng", 3, 3);
        ic->updateSurroundingText();
        testfrontend->call<ITestFrontend::pushCommitExpectation>("ngá");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("s"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        ic->reset();
        ic->surroundingText().setText("application", 11, 11);
        ic->updateSurroundingText();
        testfrontend->call<ITestFrontend::pushCommitExpectation>("s");
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("s"), false);
        testfrontend->call<ITestFrontend::keyEvent>(uuid, Key("Return"), false);

        instance->deactivate();
        dispatcher->schedule([dispatcher, instance]() {
            dispatcher->detach();
            instance->exit();
        });
    });
}

void runInstance() {}

int main() {
    setupTestingEnvironmentPath(TESTING_BINARY_DIR, {"bin"},
                                {TESTING_BINARY_DIR "/test"});
    // fcitx::Log::setLogRule("default=5,table=5,libime-table=5");
    char arg0[] = "testunikey";
    char arg1[] = "--disable=all";
    char arg2[] = "--enable=testim,testfrontend,unikey";
    char *argv[] = {arg0, arg1, arg2};
    fcitx::Log::setLogRule("default=5,unikey=5");
    Instance instance(FCITX_ARRAY_SIZE(argv), argv);
    instance.addonManager().registerDefaultLoader(nullptr);
    EventDispatcher dispatcher;
    dispatcher.attach(&instance.eventLoop());
    scheduleEvent(&dispatcher, &instance);
    instance.exec();

    return 0;
}
