#ifndef PROGBOB_H
#define PROGBOB_H

#include <string>
#include <vector>
#include "programmer-base.h"

class ProgBob_ARMSWD_priv;

class ProgBob_ARMSWD : public ProgrammerBase {
    private:
        ProgBob_ARMSWD_priv * priv;
    public:
        ProgBob_ARMSWD();
        virtual ~ProgBob_ARMSWD();
        void connect(const std::string & port);
        void configure(const std::string & part);
        std::string getStatus();
        void reset();
        void program(const std::string & segment, unsigned int startAddress, const std::vector<uint8_t> & memory);
        void verify(const std::string & segment, unsigned int startAddress, const std::vector<uint8_t> & memory);
        void startProgramMode(const std::string & mode, bool erase);
        void leaveProgramMode();
        void signalError();
        std::string readSignature();
};





#endif
