/* Copyright (c) 2012-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef TABLA_CODEC_DIGITAL_H

#define TABLA_CODEC_DIGITAL_H
#include <linux/mfd/wcd9xxx/wcd9xxx_registers.h>

#define TABLA_A_CHIP_CTL			WCD9XXX_A_CHIP_CTL
#define TABLA_A_CHIP_CTL__POR			WCD9XXX_A_CHIP_CTL__POR
#define TABLA_A_CHIP_STATUS			WCD9XXX_A_CHIP_STATUS
#define TABLA_A_CHIP_STATUS__POR		WCD9XXX_A_CHIP_STATUS__POR
#define TABLA_A_CHIP_ID_BYTE_0			WCD9XXX_A_CHIP_ID_BYTE_0
#define TABLA_A_CHIP_ID_BYTE_0__POR		WCD9XXX_A_CHIP_ID_BYTE_0__POR
#define TABLA_A_CHIP_ID_BYTE_1			WCD9XXX_A_CHIP_ID_BYTE_1
#define TABLA_A_CHIP_ID_BYTE_1__POR		WCD9XXX_A_CHIP_ID_BYTE_1__POR
#define TABLA_A_CHIP_ID_BYTE_2			WCD9XXX_A_CHIP_ID_BYTE_2
#define TABLA_A_CHIP_ID_BYTE_2__POR		WCD9XXX_A_CHIP_ID_BYTE_2__POR
#define TABLA_A_CHIP_ID_BYTE_3			WCD9XXX_A_CHIP_ID_BYTE_3
#define TABLA_A_CHIP_ID_BYTE_3__POR		WCD9XXX_A_CHIP_ID_BYTE_3__POR
#define TABLA_A_CHIP_VERSION			WCD9XXX_A_CHIP_VERSION
#define TABLA_A_CHIP_VERSION__POR		WCD9XXX_A_CHIP_VERSION__POR
#define TABLA_A_SB_VERSION			WCD9XXX_A_SB_VERSION
#define TABLA_A_SB_VERSION__POR			WCD9XXX_A_SB_VERSION__POR
#define TABLA_A_SLAVE_ID_1			WCD9XXX_A_SLAVE_ID_1
#define TABLA_A_SLAVE_ID_1__POR			WCD9XXX_A_SLAVE_ID_1__POR
#define TABLA_A_SLAVE_ID_2			WCD9XXX_A_SLAVE_ID_2
#define TABLA_A_SLAVE_ID_2__POR			WCD9XXX_A_SLAVE_ID_2__POR
#define TABLA_A_SLAVE_ID_3			WCD9XXX_A_SLAVE_ID_3
#define TABLA_A_SLAVE_ID_3__POR			WCD9XXX_A_SLAVE_ID_3__POR
#define TABLA_A_PIN_CTL_OE0			(0x10)
#define TABLA_A_PIN_CTL_OE0__POR			(0x00000000)
#define TABLA_A_PIN_CTL_OE1			(0x11)
#define TABLA_A_PIN_CTL_OE1__POR			(0x00000000)
#define TABLA_A_PIN_CTL_DATA0			(0x12)
#define TABLA_A_PIN_CTL_DATA0__POR			(0x00000000)
#define TABLA_A_PIN_CTL_DATA1			(0x13)
#define TABLA_A_PIN_CTL_DATA1__POR			(0x00000000)
#define TABLA_A_HDRIVE_GENERIC			(0x18)
#define TABLA_A_HDRIVE_GENERIC__POR			(0x00000000)
#define TABLA_A_HDRIVE_OVERRIDE			(0x19)
#define TABLA_A_HDRIVE_OVERRIDE__POR			(0x00000008)
#define TABLA_A_ANA_CSR_WAIT_STATE			(0x20)
#define TABLA_A_ANA_CSR_WAIT_STATE__POR			(0x00000044)
#define TABLA_A_PROCESS_MONITOR_CTL0			(0x40)
#define TABLA_A_PROCESS_MONITOR_CTL0__POR			(0x00000080)
#define TABLA_A_PROCESS_MONITOR_CTL1			(0x41)
#define TABLA_A_PROCESS_MONITOR_CTL1__POR			(0x00000000)
#define TABLA_A_PROCESS_MONITOR_CTL2			(0x42)
#define TABLA_A_PROCESS_MONITOR_CTL2__POR			(0x00000000)
#define TABLA_A_PROCESS_MONITOR_CTL3			(0x43)
#define TABLA_A_PROCESS_MONITOR_CTL3__POR			(0x00000001)
#define TABLA_A_QFUSE_CTL			(0x48)
#define TABLA_A_QFUSE_CTL__POR			(0x00000000)
#define TABLA_A_QFUSE_STATUS			(0x49)
#define TABLA_A_QFUSE_STATUS__POR			(0x00000000)
#define TABLA_A_QFUSE_DATA_OUT0			(0x4A)
#define TABLA_A_QFUSE_DATA_OUT0__POR			(0x00000000)
#define TABLA_A_QFUSE_DATA_OUT1			(0x4B)
#define TABLA_A_QFUSE_DATA_OUT1__POR			(0x00000000)
#define TABLA_A_QFUSE_DATA_OUT2			(0x4C)
#define TABLA_A_QFUSE_DATA_OUT2__POR			(0x00000000)
#define TABLA_A_QFUSE_DATA_OUT3			(0x4D)
#define TABLA_A_QFUSE_DATA_OUT3__POR			(0x00000000)
#define TABLA_A_CDC_CTL				WCD9XXX_A_CDC_CTL
#define TABLA_A_CDC_CTL__POR			WCD9XXX_A_CDC_CTL__POR
#define TABLA_A_LEAKAGE_CTL			WCD9XXX_A_LEAKAGE_CTL
#define TABLA_A_LEAKAGE_CTL__POR		WCD9XXX_A_LEAKAGE_CTL__POR
#define TABLA_A_INTR_MODE			(0x90)
#define TABLA_A_INTR_MODE__POR			(0x00000000)
#define TABLA_A_INTR_MASK0			(0x94)
#define TABLA_A_INTR_MASK0__POR			(0x000000ff)
#define TABLA_A_INTR_MASK1			(0x95)
#define TABLA_A_INTR_MASK1__POR			(0x000000ff)
#define TABLA_A_INTR_MASK2			(0x96)
#define TABLA_A_INTR_MASK2__POR			(0x000000ff)
#define TABLA_A_INTR_STATUS0			(0x98)
#define TABLA_A_INTR_STATUS0__POR			(0x00000000)
#define TABLA_A_INTR_STATUS1			(0x99)
#define TABLA_A_INTR_STATUS1__POR			(0x00000000)
#define TABLA_A_INTR_STATUS2			(0x9A)
#define TABLA_A_INTR_STATUS2__POR			(0x00000000)
#define TABLA_A_INTR_CLEAR0			(0x9C)
#define TABLA_A_INTR_CLEAR0__POR			(0x00000000)
#define TABLA_A_INTR_CLEAR1			(0x9D)
#define TABLA_A_INTR_CLEAR1__POR			(0x00000000)
#define TABLA_A_INTR_CLEAR2			(0x9E)
#define TABLA_A_INTR_CLEAR2__POR			(0x00000000)
#define TABLA_A_INTR_LEVEL0			(0xA0)
#define TABLA_A_INTR_LEVEL0__POR			(0x00000001)
#define TABLA_A_INTR_LEVEL1			(0xA1)
#define TABLA_A_INTR_LEVEL1__POR			(0x00000000)
#define TABLA_A_INTR_LEVEL2			(0xA2)
#define TABLA_A_INTR_LEVEL2__POR			(0x00000000)
#define TABLA_A_INTR_TEST0			(0xA4)
#define TABLA_A_INTR_TEST0__POR			(0x00000000)
#define TABLA_A_INTR_TEST1			(0xA5)
#define TABLA_A_INTR_TEST1__POR			(0x00000000)
#define TABLA_A_INTR_TEST2			(0xA6)
#define TABLA_A_INTR_TEST2__POR			(0x00000000)
#define TABLA_A_INTR_SET0			(0xA8)
#define TABLA_A_INTR_SET0__POR			(0x00000000)
#define TABLA_A_INTR_SET1			(0xA9)
#define TABLA_A_INTR_SET1__POR			(0x00000000)
#define TABLA_A_INTR_SET2			(0xAA)
#define TABLA_A_INTR_SET2__POR			(0x00000000)
#define TABLA_A_CDC_TX_I2S_SCK_MODE			(0xC0)
#define TABLA_A_CDC_TX_I2S_SCK_MODE__POR			(0x00000000)
#define TABLA_A_CDC_TX_I2S_WS_MODE			(0xC1)
#define TABLA_A_CDC_TX_I2S_WS_MODE__POR			(0x00000000)
#define TABLA_A_CDC_DMIC_DATA0_MODE			(0xC4)
#define TABLA_A_CDC_DMIC_DATA0_MODE__POR			(0x00000000)
#define TABLA_A_CDC_DMIC_CLK0_MODE			(0xC5)
#define TABLA_A_CDC_DMIC_CLK0_MODE__POR			(0x00000000)
#define TABLA_A_CDC_DMIC_DATA1_MODE			(0xC6)
#define TABLA_A_CDC_DMIC_DATA1_MODE__POR			(0x00000000)
#define TABLA_A_CDC_DMIC_CLK1_MODE			(0xC7)
#define TABLA_A_CDC_DMIC_CLK1_MODE__POR			(0x00000000)
#define TABLA_A_CDC_RX_I2S_SCK_MODE			(0xC8)
#define TABLA_A_CDC_RX_I2S_SCK_MODE__POR			(0x00000000)
#define TABLA_A_CDC_RX_I2S_WS_MODE			(0xC9)
#define TABLA_A_CDC_RX_I2S_WS_MODE__POR			(0x00000000)
#define TABLA_A_CDC_DMIC_DATA2_MODE			(0xCA)
#define TABLA_A_CDC_DMIC_DATA2_MODE__POR			(0x00000000)
#define TABLA_A_CDC_DMIC_CLK2_MODE			(0xCB)
#define TABLA_A_CDC_DMIC_CLK2_MODE__POR			(0x00000000)
#define TABLA_A_CDC_INTR_MODE			(0xCC)
#define TABLA_A_CDC_INTR_MODE__POR			(0x00000000)
#define TABLA_A_BIAS_REF_CTL			(0x0100)
#define TABLA_A_BIAS_REF_CTL__POR			(0x0000001C)
#define TABLA_A_BIAS_CENTRAL_BG_CTL			(0x0101)
#define TABLA_A_BIAS_CENTRAL_BG_CTL__POR			(0x00000050)
#define TABLA_A_BIAS_PRECHRG_CTL			(0x0102)
#define TABLA_A_BIAS_PRECHRG_CTL__POR			(0x00000007)
#define TABLA_A_BIAS_CURR_CTL_1			(0x0103)
#define TABLA_A_BIAS_CURR_CTL_1__POR			(0x00000052)
#define TABLA_A_BIAS_CURR_CTL_2			(0x0104)
#define TABLA_A_BIAS_CURR_CTL_2__POR			(0x00000000)
#define TABLA_A_BIAS_CONFIG_MODE_BG_CTL			(0x0105)
#define TABLA_A_BIAS_CONFIG_MODE_BG_CTL__POR			(0x00000016)
#define TABLA_A_BIAS_BG_STATUS			(0x0106)
#define TABLA_A_BIAS_BG_STATUS__POR			(0x00000000)
#define TABLA_A_CLK_BUFF_EN1			(0x0108)
#define TABLA_A_CLK_BUFF_EN1__POR			(0x00000004)
#define TABLA_A_CLK_BUFF_EN2			(0x0109)
#define TABLA_A_CLK_BUFF_EN2__POR			(0x00000002)
#define TABLA_A_LDO_H_MODE_1			(0x0110)
#define TABLA_A_LDO_H_MODE_1__POR			(0x00000065)
#define TABLA_A_LDO_H_MODE_2			(0x0111)
#define TABLA_A_LDO_H_MODE_2__POR			(0x000000A8)
#define TABLA_A_LDO_H_LOOP_CTL			(0x0112)
#define TABLA_A_LDO_H_LOOP_CTL__POR			(0x0000006B)
#define TABLA_A_LDO_H_COMP_1			(0x0113)
#define TABLA_A_LDO_H_COMP_1__POR			(0x00000084)
#define TABLA_A_LDO_H_COMP_2			(0x0114)
#define TABLA_A_LDO_H_COMP_2__POR			(0x000000E0)
#define TABLA_A_LDO_H_BIAS_1			(0x0115)
#define TABLA_A_LDO_H_BIAS_1__POR			(0x0000006D)
#define TABLA_A_LDO_H_BIAS_2			(0x0116)
#define TABLA_A_LDO_H_BIAS_2__POR			(0x000000A5)
#define TABLA_A_LDO_H_BIAS_3			(0x0117)
#define TABLA_A_LDO_H_BIAS_3__POR			(0x00000060)
#define TABLA_A_LDO_L_MODE_1			(0x0118)
#define TABLA_A_LDO_L_MODE_1__POR			(0x00000028)
#define TABLA_A_LDO_L_MODE_2			(0x0119)
#define TABLA_A_LDO_L_MODE_2__POR			(0x000000A8)
#define TABLA_A_LDO_L_LOOP_CTL			(0x011A)
#define TABLA_A_LDO_L_LOOP_CTL__POR			(0x0000006D)
#define TABLA_A_LDO_L_COMP_1			(0x011B)
#define TABLA_A_LDO_L_COMP_1__POR			(0x00000031)
#define TABLA_A_LDO_L_COMP_2			(0x011C)
#define TABLA_A_LDO_L_COMP_2__POR			(0x000000A0)
#define TABLA_A_LDO_L_BIAS_1			(0x011D)
#define TABLA_A_LDO_L_BIAS_1__POR			(0x0000006D)
#define TABLA_A_LDO_L_BIAS_2			(0x011E)
#define TABLA_A_LDO_L_BIAS_2__POR			(0x00000065)
#define TABLA_A_LDO_L_BIAS_3			(0x011F)
#define TABLA_A_LDO_L_BIAS_3__POR			(0x00000050)
#define TABLA_A_MICB_CFILT_1_CTL			(0x0128)
#define TABLA_A_MICB_CFILT_1_CTL__POR			(0x00000040)
#define TABLA_A_MICB_CFILT_1_VAL			(0x0129)
#define TABLA_A_MICB_CFILT_1_VAL__POR			(0x00000080)
#define TABLA_A_MICB_CFILT_1_PRECHRG			(0x012A)
#define TABLA_A_MICB_CFILT_1_PRECHRG__POR			(0x00000038)
#define TABLA_A_MICB_1_CTL			(0x012B)
#define TABLA_A_MICB_1_CTL__POR			(0x00000016)
#define TABLA_A_MICB_1_INT_RBIAS			(0x012C)
#define TABLA_A_MICB_1_INT_RBIAS__POR			(0x00000000)
#define TABLA_A_MICB_1_MBHC			(0x012D)
#define TABLA_A_MICB_1_MBHC__POR			(0x00000001)
#define TABLA_A_MICB_CFILT_2_CTL			(0x012E)
#define TABLA_A_MICB_CFILT_2_CTL__POR			(0x00000040)
#define TABLA_A_MICB_CFILT_2_VAL			(0x012F)
#define TABLA_A_MICB_CFILT_2_VAL__POR			(0x00000080)
#define TABLA_A_MICB_CFILT_2_PRECHRG			(0x0130)
#define TABLA_A_MICB_CFILT_2_PRECHRG__POR			(0x00000038)
#define TABLA_A_MICB_2_CTL			(0x0131)
#define TABLA_A_MICB_2_CTL__POR			(0x00000016)
#define TABLA_A_MICB_2_INT_RBIAS			(0x0132)
#define TABLA_A_MICB_2_INT_RBIAS__POR			(0x00000000)
#define TABLA_A_MICB_2_MBHC			(0x0133)
#define TABLA_A_MICB_2_MBHC__POR			(0x00000000)
#define TABLA_A_MICB_CFILT_3_CTL			(0x0134)
#define TABLA_A_MICB_CFILT_3_CTL__POR			(0x00000040)
#define TABLA_A_MICB_CFILT_3_VAL			(0x0135)
#define TABLA_A_MICB_CFILT_3_VAL__POR			(0x00000080)
#define TABLA_A_MICB_CFILT_3_PRECHRG			(0x0136)
#define TABLA_A_MICB_CFILT_3_PRECHRG__POR			(0x00000038)
#define TABLA_A_MICB_3_CTL			(0x0137)
#define TABLA_A_MICB_3_CTL__POR			(0x00000016)
#define TABLA_A_MICB_3_INT_RBIAS			(0x0138)
#define TABLA_A_MICB_3_INT_RBIAS__POR			(0x00000000)
#define TABLA_A_MICB_3_MBHC			(0x0139)
#define TABLA_A_MICB_3_MBHC__POR			(0x00000000)
#define TABLA_1_A_MICB_4_CTL			(0x013A)
#define TABLA_2_A_MICB_4_CTL			(0x013D)
#define TABLA_A_MICB_4_CTL__POR			(0x00000016)
#define TABLA_1_A_MICB_4_INT_RBIAS			(0x013B)
#define TABLA_2_A_MICB_4_INT_RBIAS			(0x013E)
#define TABLA_A_MICB_4_INT_RBIAS__POR			(0x00000000)
#define TABLA_1_A_MICB_4_MBHC			(0x013C)
#define TABLA_2_A_MICB_4_MBHC			(0x013F)
#define TABLA_A_MICB_4_MBHC__POR			(0x00000001)
#define TABLA_A_TX_COM_BIAS			(0x014C)
#define TABLA_A_TX_COM_BIAS__POR			(0x000000E0)
#define TABLA_A_MBHC_SCALING_MUX_1			(0x014E)
#define TABLA_A_MBHC_SCALING_MUX_1__POR			(0x00000000)
#define TABLA_A_MBHC_SCALING_MUX_2			(0x014F)
#define TABLA_A_MBHC_SCALING_MUX_2__POR			(0x00000080)
#define TABLA_A_TX_SUP_SWITCH_CTRL_1			(0x0151)
#define TABLA_A_TX_SUP_SWITCH_CTRL_1__POR			(0x00000000)
#define TABLA_A_TX_SUP_SWITCH_CTRL_2			(0x0152)
#define TABLA_A_TX_SUP_SWITCH_CTRL_2__POR			(0x00000080)
#define TABLA_A_TX_1_2_EN			(0x0153)
#define TABLA_A_TX_1_2_EN__POR			(0x00000000)
#define TABLA_A_TX_1_2_TEST_EN			(0x0154)
#define TABLA_A_TX_1_2_TEST_EN__POR			(0x000000CC)
#define TABLA_A_TX_1_2_ADC_CH1			(0x0155)
#define TABLA_A_TX_1_2_ADC_CH1__POR			(0x00000044)
#define TABLA_A_TX_1_2_ADC_CH2			(0x0156)
#define TABLA_A_TX_1_2_ADC_CH2__POR			(0x00000044)
#define TABLA_A_TX_1_2_ATEST_REFCTRL			(0x0157)
#define TABLA_A_TX_1_2_ATEST_REFCTRL__POR			(0x00000000)
#define TABLA_A_TX_1_2_TEST_CTL			(0x0158)
#define TABLA_A_TX_1_2_TEST_CTL__POR			(0x00000038)
#define TABLA_A_TX_1_2_TEST_BLOCK_EN			(0x0159)
#define TABLA_A_TX_1_2_TEST_BLOCK_EN__POR			(0x000000FF)
#define TABLA_A_TX_1_2_TXFE_CLKDIV			(0x015A)
#define TABLA_A_TX_1_2_TXFE_CLKDIV__POR			(0x000000EE)
#define TABLA_A_TX_1_2_SAR_ERR_CH1			(0x015B)
#define TABLA_A_TX_1_2_SAR_ERR_CH1__POR			(0x00000000)
#define TABLA_A_TX_1_2_SAR_ERR_CH2			(0x015C)
#define TABLA_A_TX_1_2_SAR_ERR_CH2__POR			(0x00000000)
#define TABLA_A_TX_3_4_EN			(0x015D)
#define TABLA_A_TX_3_4_EN__POR			(0x00000000)
#define TABLA_A_TX_3_4_TEST_EN			(0x015E)
#define TABLA_A_TX_3_4_TEST_EN__POR			(0x000000CC)
#define TABLA_A_TX_3_4_ADC_CH3			(0x015F)
#define TABLA_A_TX_3_4_ADC_CH3__POR			(0x00000044)
#define TABLA_A_TX_3_4_ADC_CH4			(0x0160)
#define TABLA_A_TX_3_4_ADC_CH4__POR			(0x00000044)
#define TABLA_A_TX_3_4_ATEST_REFCTRL			(0x0161)
#define TABLA_A_TX_3_4_ATEST_REFCTRL__POR			(0x00000000)
#define TABLA_A_TX_3_4_TEST_CTL			(0x0162)
#define TABLA_A_TX_3_4_TEST_CTL__POR			(0x00000038)
#define TABLA_A_TX_3_4_TEST_BLOCK_EN			(0x0163)
#define TABLA_A_TX_3_4_TEST_BLOCK_EN__POR			(0x000000FF)
#define TABLA_A_TX_3_4_TXFE_CKDIV			(0x0164)
#define TABLA_A_TX_3_4_TXFE_CKDIV__POR			(0x000000EE)
#define TABLA_A_TX_3_4_SAR_ERR_CH3			(0x0165)
#define TABLA_A_TX_3_4_SAR_ERR_CH3__POR			(0x00000000)
#define TABLA_A_TX_3_4_SAR_ERR_CH4			(0x0166)
#define TABLA_A_TX_3_4_SAR_ERR_CH4__POR			(0x00000000)
#define TABLA_A_TX_5_6_EN			(0x0167)
#define TABLA_A_TX_5_6_EN__POR			(0x00000011)
#define TABLA_A_TX_5_6_TEST_EN			(0x0168)
#define TABLA_A_TX_5_6_TEST_EN__POR			(0x000000CC)
#define TABLA_A_TX_5_6_ADC_CH5			(0x0169)
#define TABLA_A_TX_5_6_ADC_CH5__POR			(0x00000044)
#define TABLA_A_TX_5_6_ADC_CH6			(0x016A)
#define TABLA_A_TX_5_6_ADC_CH6__POR			(0x00000044)
#define TABLA_A_TX_5_6_ATEST_REFCTRL			(0x016B)
#define TABLA_A_TX_5_6_ATEST_REFCTRL__POR			(0x00000000)
#define TABLA_A_TX_5_6_TEST_CTL			(0x016C)
#define TABLA_A_TX_5_6_TEST_CTL__POR			(0x00000038)
#define TABLA_A_TX_5_6_TEST_BLOCK_EN			(0x016D)
#define TABLA_A_TX_5_6_TEST_BLOCK_EN__POR			(0x000000FF)
#define TABLA_A_TX_5_6_TXFE_CKDIV			(0x016E)
#define TABLA_A_TX_5_6_TXFE_CKDIV__POR			(0x000000EE)
#define TABLA_A_TX_5_6_SAR_ERR_CH5			(0x016F)
#define TABLA_A_TX_5_6_SAR_ERR_CH5__POR			(0x00000000)
#define TABLA_A_TX_5_6_SAR_ERR_CH6			(0x0170)
#define TABLA_A_TX_5_6_SAR_ERR_CH6__POR			(0x00000000)
#define TABLA_A_TX_7_MBHC_EN			(0x0171)
#define TABLA_A_TX_7_MBHC_EN__POR			(0x0000000C)
#define TABLA_A_TX_7_MBHC_ATEST_REFCTRL			(0x0172)
#define TABLA_A_TX_7_MBHC_ATEST_REFCTRL__POR			(0x00000000)
#define TABLA_A_TX_7_MBHC_ADC			(0x0173)
#define TABLA_A_TX_7_MBHC_ADC__POR			(0x00000044)
#define TABLA_A_TX_7_MBHC_TEST_CTL			(0x0174)
#define TABLA_A_TX_7_MBHC_TEST_CTL__POR			(0x00000038)
#define TABLA_A_TX_7_MBHC_SAR_ERR			(0x0175)
#define TABLA_A_TX_7_MBHC_SAR_ERR__POR			(0x00000000)
#define TABLA_A_TX_7_TXFE_CLKDIV			(0x0176)
#define TABLA_A_TX_7_TXFE_CLKDIV__POR			(0x0000001C)
#define TABLA_A_AUX_COM_CTL			(0x0180)
#define TABLA_A_AUX_COM_CTL__POR			(0x00000034)
#define TABLA_A_AUX_COM_ATEST			(0x0181)
#define TABLA_A_AUX_COM_ATEST__POR			(0x00000000)
#define TABLA_A_AUX_L_EN			(0x0182)
#define TABLA_A_AUX_L_EN__POR			(0x00000000)
#define TABLA_A_AUX_L_GAIN			(0x0183)
#define TABLA_A_AUX_L_GAIN__POR			(0x0000001F)
#define TABLA_A_AUX_L_PA_CONN			(0x0184)
#define TABLA_A_AUX_L_PA_CONN__POR			(0x00000000)
#define TABLA_A_AUX_L_PA_CONN_INV			(0x0185)
#define TABLA_A_AUX_L_PA_CONN_INV__POR			(0x00000000)
#define TABLA_A_AUX_R_EN			(0x0186)
#define TABLA_A_AUX_R_EN__POR			(0x00000000)
#define TABLA_A_AUX_R_GAIN			(0x0187)
#define TABLA_A_AUX_R_GAIN__POR			(0x0000001F)
#define TABLA_A_AUX_R_PA_CONN			(0x0188)
#define TABLA_A_AUX_R_PA_CONN__POR			(0x00000000)
#define TABLA_A_AUX_R_PA_CONN_INV			(0x0189)
#define TABLA_A_AUX_R_PA_CONN_INV__POR			(0x00000000)
#define TABLA_A_CP_EN			(0x0192)
#define TABLA_A_CP_EN__POR			(0x000000E6)
#define TABLA_A_CP_CLK			(0x0193)
#define TABLA_A_CP_CLK__POR			(0x00000029)
#define TABLA_A_CP_STATIC			(0x0194)
#define TABLA_A_CP_STATIC__POR			(0x00000010)
#define TABLA_A_CP_DCC1			(0x0195)
#define TABLA_A_CP_DCC1__POR			(0x00000052)
#define TABLA_A_CP_DCC3			(0x0196)
#define TABLA_A_CP_DCC3__POR			(0x00000001)
#define TABLA_A_CP_ATEST			(0x0197)
#define TABLA_A_CP_ATEST__POR			(0x00000000)
#define TABLA_A_CP_DTEST			(0x0198)
#define TABLA_A_CP_DTEST__POR			(0x00000000)
#define TABLA_A_RX_COM_TIMER_DIV			(0x019E)
#define TABLA_A_RX_COM_TIMER_DIV__POR			(0x000000E8)
#define TABLA_A_RX_COM_OCP_CTL			(0x019F)
#define TABLA_A_RX_COM_OCP_CTL__POR			(0x0000001F)
#define TABLA_A_RX_COM_OCP_COUNT			(0x01A0)
#define TABLA_A_RX_COM_OCP_COUNT__POR			(0x00000077)
#define TABLA_A_RX_COM_DAC_CTL			(0x01A1)
#define TABLA_A_RX_COM_DAC_CTL__POR			(0x00000000)
#define TABLA_A_RX_COM_BIAS			(0x01A2)
#define TABLA_A_RX_COM_BIAS__POR			(0x00000000)
#define TABLA_A_RX_HPH_BIAS_PA			(0x01A6)
#define TABLA_A_RX_HPH_BIAS_PA__POR			(0x000000AA)
#define TABLA_A_RX_HPH_BIAS_LDO			(0x01A7)
#define TABLA_A_RX_HPH_BIAS_LDO__POR			(0x00000086)
#define TABLA_A_RX_HPH_BIAS_CNP			(0x01A8)
#define TABLA_A_RX_HPH_BIAS_CNP__POR			(0x0000008A)
#define TABLA_A_RX_HPH_BIAS_WG			(0x01A9)
#define TABLA_A_RX_HPH_BIAS_WG__POR			(0x00000060)
#define TABLA_A_RX_HPH_OCP_CTL			(0x01AA)
#define TABLA_A_RX_HPH_OCP_CTL__POR			(0x000000E8)
#define TABLA_A_RX_HPH_CNP_EN			(0x01AB)
#define TABLA_A_RX_HPH_CNP_EN__POR			(0x00000080)
#define TABLA_A_RX_HPH_CNP_WG_CTL			(0x01AC)
#define TABLA_A_RX_HPH_CNP_WG_CTL__POR			(0x000000DC)
#define TABLA_A_RX_HPH_CNP_WG_TIME			(0x01AD)
#define TABLA_A_RX_HPH_CNP_WG_TIME__POR			(0x00000028)
#define TABLA_A_RX_HPH_L_GAIN			(0x01AE)
#define TABLA_A_RX_HPH_L_GAIN__POR			(0x00000000)
#define TABLA_A_RX_HPH_L_TEST			(0x01AF)
#define TABLA_A_RX_HPH_L_TEST__POR			(0x00000001)
#define TABLA_A_RX_HPH_L_PA_CTL			(0x01B0)
#define TABLA_A_RX_HPH_L_PA_CTL__POR			(0x00000040)
#define TABLA_A_RX_HPH_L_DAC_CTL			(0x01B1)
#define TABLA_A_RX_HPH_L_DAC_CTL__POR			(0x00000000)
#define TABLA_A_RX_HPH_L_ATEST			(0x01B2)
#define TABLA_A_RX_HPH_L_ATEST__POR			(0x00000000)
#define TABLA_A_RX_HPH_L_STATUS			(0x01B3)
#define TABLA_A_RX_HPH_L_STATUS__POR			(0x00000004)
#define TABLA_A_RX_HPH_R_GAIN			(0x01B4)
#define TABLA_A_RX_HPH_R_GAIN__POR			(0x00000000)
#define TABLA_A_RX_HPH_R_TEST			(0x01B5)
#define TABLA_A_RX_HPH_R_TEST__POR			(0x00000001)
#define TABLA_A_RX_HPH_R_PA_CTL			(0x01B6)
#define TABLA_A_RX_HPH_R_PA_CTL__POR			(0x00000040)
#define TABLA_A_RX_HPH_R_DAC_CTL			(0x01B7)
#define TABLA_A_RX_HPH_R_DAC_CTL__POR			(0x00000000)
#define TABLA_A_RX_HPH_R_ATEST			(0x01B8)
#define TABLA_A_RX_HPH_R_ATEST__POR			(0x00000000)
#define TABLA_A_RX_HPH_R_STATUS			(0x01B9)
#define TABLA_A_RX_HPH_R_STATUS__POR			(0x00000004)
#define TABLA_A_RX_EAR_BIAS_PA			(0x01BA)
#define TABLA_A_RX_EAR_BIAS_PA__POR			(0x000000AA)
#define TABLA_A_RX_EAR_BIAS_CMBUFF			(0x01BB)
#define TABLA_A_RX_EAR_BIAS_CMBUFF__POR			(0x000000A0)
#define TABLA_A_RX_EAR_EN			(0x01BC)
#define TABLA_A_RX_EAR_EN__POR			(0x00000000)
#define TABLA_A_RX_EAR_GAIN			(0x01BD)
#define TABLA_A_RX_EAR_GAIN__POR			(0x00000008)
#define TABLA_A_RX_EAR_CMBUFF			(0x01BE)
#define TABLA_A_RX_EAR_CMBUFF__POR			(0x00000000)
#define TABLA_A_RX_EAR_ICTL			(0x01BF)
#define TABLA_A_RX_EAR_ICTL__POR			(0x00000040)
#define TABLA_A_RX_EAR_CCOMP			(0x01C0)
#define TABLA_A_RX_EAR_CCOMP__POR			(0x00000008)
#define TABLA_A_RX_EAR_VCM			(0x01C1)
#define TABLA_A_RX_EAR_VCM__POR			(0x00000000)
#define TABLA_A_RX_EAR_CNP			(0x01C2)
#define TABLA_A_RX_EAR_CNP__POR			(0x00000080)
#define TABLA_A_RX_EAR_ATEST			(0x01C3)
#define TABLA_A_RX_EAR_ATEST__POR			(0x00000000)
#define TABLA_A_RX_EAR_STATUS			(0x01C5)
#define TABLA_A_RX_EAR_STATUS__POR			(0x00000004)
#define TABLA_A_RX_LINE_BIAS_PA			(0x01C6)
#define TABLA_A_RX_LINE_BIAS_PA__POR			(0x000000AA)
#define TABLA_A_RX_LINE_BIAS_DAC			(0x01C7)
#define TABLA_A_RX_LINE_BIAS_DAC__POR			(0x000000A0)
#define TABLA_A_RX_LINE_BIAS_CNP			(0x01C8)
#define TABLA_A_RX_LINE_BIAS_CNP__POR			(0x0000003A)
#define TABLA_A_RX_LINE_COM			(0x01C9)
#define TABLA_A_RX_LINE_COM__POR			(0x00000000)
#define TABLA_A_RX_LINE_CNP_EN			(0x01CA)
#define TABLA_A_RX_LINE_CNP_EN__POR			(0x00000080)
#define TABLA_A_RX_LINE_CNP_WG_CTL			(0x01CB)
#define TABLA_A_RX_LINE_CNP_WG_CTL__POR			(0x0000001C)
#define TABLA_A_RX_LINE_CNP_WG_TIME			(0x01CC)
#define TABLA_A_RX_LINE_CNP_WG_TIME__POR			(0x00000064)
#define TABLA_A_RX_LINE_1_GAIN			(0x01CD)
#define TABLA_A_RX_LINE_1_GAIN__POR			(0x00000000)
#define TABLA_A_RX_LINE_1_TEST			(0x01CE)
#define TABLA_A_RX_LINE_1_TEST__POR			(0x00000000)
#define TABLA_A_RX_LINE_1_DAC_CTL			(0x01CF)
#define TABLA_A_RX_LINE_1_DAC_CTL__POR			(0x0000000C)
#define TABLA_A_RX_LINE_1_STATUS			(0x01D0)
#define TABLA_A_RX_LINE_1_STATUS__POR			(0x00000000)
#define TABLA_A_RX_LINE_2_GAIN			(0x01D1)
#define TABLA_A_RX_LINE_2_GAIN__POR			(0x00000000)
#define TABLA_A_RX_LINE_2_TEST			(0x01D2)
#define TABLA_A_RX_LINE_2_TEST__POR			(0x00000000)
#define TABLA_A_RX_LINE_2_DAC_CTL			(0x01D3)
#define TABLA_A_RX_LINE_2_DAC_CTL__POR			(0x0000000C)
#define TABLA_A_RX_LINE_2_STATUS			(0x01D4)
#define TABLA_A_RX_LINE_2_STATUS__POR			(0x00000000)
#define TABLA_A_RX_LINE_3_GAIN			(0x01D5)
#define TABLA_A_RX_LINE_3_GAIN__POR			(0x00000000)
#define TABLA_A_RX_LINE_3_TEST			(0x01D6)
#define TABLA_A_RX_LINE_3_TEST__POR			(0x00000000)
#define TABLA_A_RX_LINE_3_DAC_CTL			(0x01D7)
#define TABLA_A_RX_LINE_3_DAC_CTL__POR			(0x0000000C)
#define TABLA_A_RX_LINE_3_STATUS			(0x01D8)
#define TABLA_A_RX_LINE_3_STATUS__POR			(0x00000000)
#define TABLA_A_RX_LINE_4_GAIN			(0x01D9)
#define TABLA_A_RX_LINE_4_GAIN__POR			(0x00000000)
#define TABLA_A_RX_LINE_4_TEST			(0x01DA)
#define TABLA_A_RX_LINE_4_TEST__POR			(0x00000000)
#define TABLA_A_RX_LINE_4_DAC_CTL			(0x01DB)
#define TABLA_A_RX_LINE_4_DAC_CTL__POR			(0x0000000C)
#define TABLA_A_RX_LINE_4_STATUS			(0x01DC)
#define TABLA_A_RX_LINE_4_STATUS__POR			(0x00000000)
#define TABLA_A_RX_LINE_5_GAIN			(0x01DD)
#define TABLA_A_RX_LINE_5_GAIN__POR			(0x00000000)
#define TABLA_A_RX_LINE_5_TEST			(0x01DE)
#define TABLA_A_RX_LINE_5_TEST__POR			(0x00000000)
#define TABLA_A_RX_LINE_5_DAC_CTL			(0x01DF)
#define TABLA_A_RX_LINE_5_DAC_CTL__POR			(0x0000000C)
#define TABLA_A_RX_LINE_5_STATUS			(0x01E0)
#define TABLA_A_RX_LINE_5_STATUS__POR			(0x00000000)
#define TABLA_A_RX_LINE_CNP_DBG			(0x01EC)
#define TABLA_A_RX_LINE_CNP_DBG__POR			(0x00000000)
#define TABLA_A_MBHC_HPH			(0x01ED)
#define TABLA_A_MBHC_HPH__POR			(0x00000048)
#define TABLA_A_CONFIG_MODE_FREQ			(0x01F7)
#define TABLA_A_CONFIG_MODE_FREQ__POR			(0x00000047)
#define TABLA_A_CONFIG_MODE_TEST			(0x01F8)
#define TABLA_A_CONFIG_MODE_TEST__POR			(0x0000000A)
#define TABLA_A_CONFIG_MODE_STATUS			(0x01F9)
#define TABLA_A_CONFIG_MODE_STATUS__POR			(0x0000001C)
#define TABLA_A_CONFIG_MODE_TUNER			(0x01FA)
#define TABLA_A_CONFIG_MODE_TUNER__POR			(0x00000000)
#define TABLA_A_CDC_ANC1_CTL                    (0x00000200)
#define TABLA_A_CDC_ANC1_CTL__POR                       (0x00000000)
#define TABLA_A_CDC_ANC2_CTL                    (0x00000280)
#define TABLA_A_CDC_ANC2_CTL__POR                       (0x00000000)
#define TABLA_A_CDC_ANC1_SHIFT                  (0x00000201)
#define TABLA_A_CDC_ANC1_SHIFT__POR                     (0x00000000)
#define TABLA_A_CDC_ANC2_SHIFT                  (0x00000281)
#define TABLA_A_CDC_ANC2_SHIFT__POR                     (0x00000000)
#define TABLA_A_CDC_ANC1_FILT1_B1_CTL                     (0x00000202)
#define TABLA_A_CDC_ANC1_FILT1_B1_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT1_B1_CTL                     (0x00000282)
#define TABLA_A_CDC_ANC2_FILT1_B1_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_FILT1_B2_CTL                     (0x00000203)
#define TABLA_A_CDC_ANC1_FILT1_B2_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT1_B2_CTL                     (0x00000283)
#define TABLA_A_CDC_ANC2_FILT1_B2_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_FILT1_B3_CTL                     (0x00000204)
#define TABLA_A_CDC_ANC1_FILT1_B3_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT1_B3_CTL                     (0x00000284)
#define TABLA_A_CDC_ANC2_FILT1_B3_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_FILT1_B4_CTL                     (0x00000205)
#define TABLA_A_CDC_ANC1_FILT1_B4_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT1_B4_CTL                     (0x00000285)
#define TABLA_A_CDC_ANC2_FILT1_B4_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_FILT2_B1_CTL                     (0x00000206)
#define TABLA_A_CDC_ANC1_FILT2_B1_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT2_B1_CTL                     (0x00000286)
#define TABLA_A_CDC_ANC2_FILT2_B1_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_FILT2_B2_CTL                     (0x00000207)
#define TABLA_A_CDC_ANC1_FILT2_B2_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT2_B2_CTL                     (0x00000287)
#define TABLA_A_CDC_ANC2_FILT2_B2_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_FILT2_B3_CTL                     (0x00000208)
#define TABLA_A_CDC_ANC1_FILT2_B3_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC2_FILT2_B3_CTL                     (0x00000288)
#define TABLA_A_CDC_ANC2_FILT2_B3_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_ANC1_SPARE                  (0x00000209)
#define TABLA_A_CDC_ANC1_SPARE__POR                     (0x00000000)
#define TABLA_A_CDC_ANC2_SPARE                  (0x00000289)
#define TABLA_A_CDC_ANC2_SPARE__POR                     (0x00000000)
#define TABLA_A_CDC_ANC1_FILT3_CTL                      (0x0000020A)
#define TABLA_A_CDC_ANC1_FILT3_CTL__POR                 (0x00000000)
#define TABLA_A_CDC_ANC2_FILT3_CTL                      (0x0000028A)
#define TABLA_A_CDC_ANC2_FILT3_CTL__POR                 (0x00000000)
#define TABLA_A_CDC_ANC1_FILT4_CTL                      (0x0000020B)
#define TABLA_A_CDC_ANC1_FILT4_CTL__POR                 (0x00000000)
#define TABLA_A_CDC_ANC2_FILT4_CTL                      (0x0000028B)
#define TABLA_A_CDC_ANC2_FILT4_CTL__POR                 (0x00000000)
#define TABLA_A_CDC_TX1_VOL_CTL_TIMER			(0x00000220)
#define TABLA_A_CDC_TX1_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX2_VOL_CTL_TIMER			(0x00000228)
#define TABLA_A_CDC_TX2_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX3_VOL_CTL_TIMER			(0x00000230)
#define TABLA_A_CDC_TX3_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX4_VOL_CTL_TIMER			(0x00000238)
#define TABLA_A_CDC_TX4_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX5_VOL_CTL_TIMER			(0x00000240)
#define TABLA_A_CDC_TX5_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX6_VOL_CTL_TIMER			(0x00000248)
#define TABLA_A_CDC_TX6_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX7_VOL_CTL_TIMER			(0x00000250)
#define TABLA_A_CDC_TX7_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX8_VOL_CTL_TIMER			(0x00000258)
#define TABLA_A_CDC_TX8_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX9_VOL_CTL_TIMER			(0x00000260)
#define TABLA_A_CDC_TX9_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX10_VOL_CTL_TIMER			(0x00000268)
#define TABLA_A_CDC_TX10_VOL_CTL_TIMER__POR			(0x00000000)
#define TABLA_A_CDC_TX1_VOL_CTL_GAIN			(0x00000221)
#define TABLA_A_CDC_TX1_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX2_VOL_CTL_GAIN			(0x00000229)
#define TABLA_A_CDC_TX2_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX3_VOL_CTL_GAIN			(0x00000231)
#define TABLA_A_CDC_TX3_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX4_VOL_CTL_GAIN			(0x00000239)
#define TABLA_A_CDC_TX4_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX5_VOL_CTL_GAIN			(0x00000241)
#define TABLA_A_CDC_TX5_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX6_VOL_CTL_GAIN			(0x00000249)
#define TABLA_A_CDC_TX6_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX7_VOL_CTL_GAIN			(0x00000251)
#define TABLA_A_CDC_TX7_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX8_VOL_CTL_GAIN			(0x00000259)
#define TABLA_A_CDC_TX8_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX9_VOL_CTL_GAIN			(0x00000261)
#define TABLA_A_CDC_TX9_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX10_VOL_CTL_GAIN			(0x00000269)
#define TABLA_A_CDC_TX10_VOL_CTL_GAIN__POR			(0x00000000)
#define TABLA_A_CDC_TX1_VOL_CTL_CFG			(0x00000222)
#define TABLA_A_CDC_TX1_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX2_VOL_CTL_CFG			(0x0000022A)
#define TABLA_A_CDC_TX2_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX3_VOL_CTL_CFG			(0x00000232)
#define TABLA_A_CDC_TX3_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX4_VOL_CTL_CFG			(0x0000023A)
#define TABLA_A_CDC_TX4_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX5_VOL_CTL_CFG			(0x00000242)
#define TABLA_A_CDC_TX5_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX6_VOL_CTL_CFG			(0x0000024A)
#define TABLA_A_CDC_TX6_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX7_VOL_CTL_CFG			(0x00000252)
#define TABLA_A_CDC_TX7_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX8_VOL_CTL_CFG			(0x0000025A)
#define TABLA_A_CDC_TX8_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX9_VOL_CTL_CFG			(0x00000262)
#define TABLA_A_CDC_TX9_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX10_VOL_CTL_CFG			(0x0000026A)
#define TABLA_A_CDC_TX10_VOL_CTL_CFG__POR			(0x00000000)
#define TABLA_A_CDC_TX1_MUX_CTL			(0x00000223)
#define TABLA_A_CDC_TX1_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX2_MUX_CTL			(0x0000022B)
#define TABLA_A_CDC_TX2_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX3_MUX_CTL			(0x00000233)
#define TABLA_A_CDC_TX3_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX4_MUX_CTL			(0x0000023B)
#define TABLA_A_CDC_TX4_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX5_MUX_CTL			(0x00000243)
#define TABLA_A_CDC_TX5_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX6_MUX_CTL			(0x0000024B)
#define TABLA_A_CDC_TX6_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX7_MUX_CTL			(0x00000253)
#define TABLA_A_CDC_TX7_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX8_MUX_CTL			(0x0000025B)
#define TABLA_A_CDC_TX8_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX9_MUX_CTL			(0x00000263)
#define TABLA_A_CDC_TX9_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX10_MUX_CTL			(0x0000026B)
#define TABLA_A_CDC_TX10_MUX_CTL__POR			(0x00000008)
#define TABLA_A_CDC_TX1_CLK_FS_CTL			(0x00000224)
#define TABLA_A_CDC_TX1_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX2_CLK_FS_CTL			(0x0000022C)
#define TABLA_A_CDC_TX2_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX3_CLK_FS_CTL			(0x00000234)
#define TABLA_A_CDC_TX3_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX4_CLK_FS_CTL			(0x0000023C)
#define TABLA_A_CDC_TX4_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX5_CLK_FS_CTL			(0x00000244)
#define TABLA_A_CDC_TX5_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX6_CLK_FS_CTL			(0x0000024C)
#define TABLA_A_CDC_TX6_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX7_CLK_FS_CTL			(0x00000254)
#define TABLA_A_CDC_TX7_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX8_CLK_FS_CTL			(0x0000025C)
#define TABLA_A_CDC_TX8_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX9_CLK_FS_CTL			(0x00000264)
#define TABLA_A_CDC_TX9_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX10_CLK_FS_CTL			(0x0000026C)
#define TABLA_A_CDC_TX10_CLK_FS_CTL__POR			(0x00000003)
#define TABLA_A_CDC_TX1_DMIC_CTL			(0x00000225)
#define TABLA_A_CDC_TX1_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX2_DMIC_CTL			(0x0000022D)
#define TABLA_A_CDC_TX2_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX3_DMIC_CTL			(0x00000235)
#define TABLA_A_CDC_TX3_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX4_DMIC_CTL			(0x0000023D)
#define TABLA_A_CDC_TX4_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX5_DMIC_CTL			(0x00000245)
#define TABLA_A_CDC_TX5_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX6_DMIC_CTL			(0x0000024D)
#define TABLA_A_CDC_TX6_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX7_DMIC_CTL			(0x00000255)
#define TABLA_A_CDC_TX7_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX8_DMIC_CTL			(0x0000025D)
#define TABLA_A_CDC_TX8_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX9_DMIC_CTL			(0x00000265)
#define TABLA_A_CDC_TX9_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TX10_DMIC_CTL			(0x0000026D)
#define TABLA_A_CDC_TX10_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_SRC1_PDA_CFG			(0x000002A0)
#define TABLA_A_CDC_SRC1_PDA_CFG__POR			(0x00000000)
#define TABLA_A_CDC_SRC2_PDA_CFG			(0x000002A8)
#define TABLA_A_CDC_SRC2_PDA_CFG__POR			(0x00000000)
#define TABLA_A_CDC_SRC1_FS_CTL			(0x000002A1)
#define TABLA_A_CDC_SRC1_FS_CTL__POR			(0x0000001b)
#define TABLA_A_CDC_SRC2_FS_CTL			(0x000002A9)
#define TABLA_A_CDC_SRC2_FS_CTL__POR			(0x0000001b)
#define TABLA_A_CDC_RX1_B1_CTL			(0x000002B0)
#define TABLA_A_CDC_RX1_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_B1_CTL			(0x000002B8)
#define TABLA_A_CDC_RX2_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_B1_CTL			(0x000002C0)
#define TABLA_A_CDC_RX3_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_B1_CTL			(0x000002C8)
#define TABLA_A_CDC_RX4_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_B1_CTL			(0x000002D0)
#define TABLA_A_CDC_RX5_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_B1_CTL			(0x000002D8)
#define TABLA_A_CDC_RX6_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_B1_CTL			(0x000002E0)
#define TABLA_A_CDC_RX7_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX1_B2_CTL			(0x000002B1)
#define TABLA_A_CDC_RX1_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_B2_CTL			(0x000002B9)
#define TABLA_A_CDC_RX2_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_B2_CTL			(0x000002C1)
#define TABLA_A_CDC_RX3_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_B2_CTL			(0x000002C9)
#define TABLA_A_CDC_RX4_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_B2_CTL			(0x000002D1)
#define TABLA_A_CDC_RX5_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_B2_CTL			(0x000002D9)
#define TABLA_A_CDC_RX6_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_B2_CTL			(0x000002E1)
#define TABLA_A_CDC_RX7_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX1_B3_CTL			(0x000002B2)
#define TABLA_A_CDC_RX1_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_B3_CTL			(0x000002BA)
#define TABLA_A_CDC_RX2_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_B3_CTL			(0x000002C2)
#define TABLA_A_CDC_RX3_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_B3_CTL			(0x000002CA)
#define TABLA_A_CDC_RX4_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_B3_CTL			(0x000002D2)
#define TABLA_A_CDC_RX5_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_B3_CTL			(0x000002DA)
#define TABLA_A_CDC_RX6_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_B3_CTL			(0x000002E2)
#define TABLA_A_CDC_RX7_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX1_B4_CTL			(0x000002B3)
#define TABLA_A_CDC_RX1_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_B4_CTL			(0x000002BB)
#define TABLA_A_CDC_RX2_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_B4_CTL			(0x000002C3)
#define TABLA_A_CDC_RX3_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_B4_CTL			(0x000002CB)
#define TABLA_A_CDC_RX4_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_B4_CTL			(0x000002D3)
#define TABLA_A_CDC_RX5_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_B4_CTL			(0x000002DB)
#define TABLA_A_CDC_RX6_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_B4_CTL			(0x000002E3)
#define TABLA_A_CDC_RX7_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX1_B5_CTL			(0x000002B4)
#define TABLA_A_CDC_RX1_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX2_B5_CTL			(0x000002BC)
#define TABLA_A_CDC_RX2_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX3_B5_CTL			(0x000002C4)
#define TABLA_A_CDC_RX3_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX4_B5_CTL			(0x000002CC)
#define TABLA_A_CDC_RX4_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX5_B5_CTL			(0x000002D4)
#define TABLA_A_CDC_RX5_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX6_B5_CTL			(0x000002DC)
#define TABLA_A_CDC_RX6_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX7_B5_CTL			(0x000002E4)
#define TABLA_A_CDC_RX7_B5_CTL__POR			(0x00000060)
#define TABLA_A_CDC_RX1_B6_CTL			(0x000002B5)
#define TABLA_A_CDC_RX1_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_B6_CTL			(0x000002BD)
#define TABLA_A_CDC_RX2_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_B6_CTL			(0x000002C5)
#define TABLA_A_CDC_RX3_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_B6_CTL			(0x000002CD)
#define TABLA_A_CDC_RX4_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_B6_CTL			(0x000002D5)
#define TABLA_A_CDC_RX5_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_B6_CTL			(0x000002DD)
#define TABLA_A_CDC_RX6_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_B6_CTL			(0x000002E5)
#define TABLA_A_CDC_RX7_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX1_VOL_CTL_B1_CTL			(0x000002B6)
#define TABLA_A_CDC_RX1_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_VOL_CTL_B1_CTL			(0x000002BE)
#define TABLA_A_CDC_RX2_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_VOL_CTL_B1_CTL			(0x000002C6)
#define TABLA_A_CDC_RX3_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_VOL_CTL_B1_CTL			(0x000002CE)
#define TABLA_A_CDC_RX4_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_VOL_CTL_B1_CTL			(0x000002D6)
#define TABLA_A_CDC_RX5_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_VOL_CTL_B1_CTL			(0x000002DE)
#define TABLA_A_CDC_RX6_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_VOL_CTL_B1_CTL			(0x000002E6)
#define TABLA_A_CDC_RX7_VOL_CTL_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX1_VOL_CTL_B2_CTL			(0x000002B7)
#define TABLA_A_CDC_RX1_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX2_VOL_CTL_B2_CTL			(0x000002BF)
#define TABLA_A_CDC_RX2_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX3_VOL_CTL_B2_CTL			(0x000002C7)
#define TABLA_A_CDC_RX3_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX4_VOL_CTL_B2_CTL			(0x000002CF)
#define TABLA_A_CDC_RX4_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX5_VOL_CTL_B2_CTL			(0x000002D7)
#define TABLA_A_CDC_RX5_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX6_VOL_CTL_B2_CTL			(0x000002DF)
#define TABLA_A_CDC_RX6_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_RX7_VOL_CTL_B2_CTL			(0x000002E7)
#define TABLA_A_CDC_RX7_VOL_CTL_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_ANC_RESET_CTL                   (0x00000300)
#define TABLA_A_CDC_CLK_ANC_RESET_CTL__POR                      (0x00000000)
#define TABLA_A_CDC_CLK_RX_RESET_CTL			(0x00000301)
#define TABLA_A_CDC_CLK_RX_RESET_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_TX_RESET_B1_CTL			(0x00000302)
#define TABLA_A_CDC_CLK_TX_RESET_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_TX_RESET_B2_CTL			(0x00000303)
#define TABLA_A_CDC_CLK_TX_RESET_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_DMIC_CTL			(0x00000304)
#define TABLA_A_CDC_CLK_DMIC_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_RX_I2S_CTL			(0x00000305)
#define TABLA_A_CDC_CLK_RX_I2S_CTL__POR			(0x00000003)
#define TABLA_A_CDC_CLK_TX_I2S_CTL			(0x00000306)
#define TABLA_A_CDC_CLK_TX_I2S_CTL__POR			(0x00000003)
#define TABLA_A_CDC_CLK_OTHR_RESET_CTL			(0x00000307)
#define TABLA_A_CDC_CLK_OTHR_RESET_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_TX_CLK_EN_B1_CTL			(0x00000308)
#define TABLA_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_TX_CLK_EN_B2_CTL			(0x00000309)
#define TABLA_A_CDC_CLK_TX_CLK_EN_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_OTHR_CTL			(0x0000030A)
#define TABLA_A_CDC_CLK_OTHR_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_RDAC_CLK_EN_CTL			(0x0000030B)
#define TABLA_A_CDC_CLK_RDAC_CLK_EN_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_ANC_CLK_EN_CTL                  (0x0000030C)
#define TABLA_A_CDC_CLK_ANC_CLK_EN_CTL__POR                     (0x00000000)
#define TABLA_A_CDC_CLK_RX_B1_CTL			(0x0000030D)
#define TABLA_A_CDC_CLK_RX_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_RX_B2_CTL			(0x0000030E)
#define TABLA_A_CDC_CLK_RX_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_MCLK_CTL			(0x0000030F)
#define TABLA_A_CDC_CLK_MCLK_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_PDM_CTL			(0x00000310)
#define TABLA_A_CDC_CLK_PDM_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLK_SD_CTL			(0x00000311)
#define TABLA_A_CDC_CLK_SD_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B1_CTL			(0x00000320)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B1_CTL__POR		(0x00000007)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B2_CTL			(0x00000321)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B2_CTL__POR		(0x00000013)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B3_CTL			(0x00000322)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B3_CTL__POR		(0x00000053)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B4_CTL			(0x00000323)
#define TABLA_A_CDC_CLSG_FREQ_THRESH_B4_CTL__POR		(0x0000007f)
#define TABLA_A_CDC_CLSG_GAIN_THRESH_CTL			(0x00000324)
#define TABLA_A_CDC_CLSG_GAIN_THRESH_CTL__POR			(0x00000026)
#define TABLA_A_CDC_CLSG_TIMER_B1_CFG			(0x00000325)
#define TABLA_A_CDC_CLSG_TIMER_B1_CFG__POR			(0x0000000a)
#define TABLA_A_CDC_CLSG_TIMER_B2_CFG			(0x00000326)
#define TABLA_A_CDC_CLSG_TIMER_B2_CFG__POR			(0x00000000)
#define TABLA_A_CDC_CLSG_CTL			(0x00000327)
#define TABLA_A_CDC_CLSG_CTL__POR			(0x00000013)
#define TABLA_A_CDC_IIR1_GAIN_B1_CTL			(0x00000340)
#define TABLA_A_CDC_IIR1_GAIN_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B1_CTL			(0x00000350)
#define TABLA_A_CDC_IIR2_GAIN_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B2_CTL			(0x00000341)
#define TABLA_A_CDC_IIR1_GAIN_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B2_CTL			(0x00000351)
#define TABLA_A_CDC_IIR2_GAIN_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B3_CTL			(0x00000342)
#define TABLA_A_CDC_IIR1_GAIN_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B3_CTL			(0x00000352)
#define TABLA_A_CDC_IIR2_GAIN_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B4_CTL			(0x00000343)
#define TABLA_A_CDC_IIR1_GAIN_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B4_CTL			(0x00000353)
#define TABLA_A_CDC_IIR2_GAIN_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B5_CTL			(0x00000344)
#define TABLA_A_CDC_IIR1_GAIN_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B5_CTL			(0x00000354)
#define TABLA_A_CDC_IIR2_GAIN_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B6_CTL			(0x00000345)
#define TABLA_A_CDC_IIR1_GAIN_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B6_CTL			(0x00000355)
#define TABLA_A_CDC_IIR2_GAIN_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B7_CTL			(0x00000346)
#define TABLA_A_CDC_IIR1_GAIN_B7_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B7_CTL			(0x00000356)
#define TABLA_A_CDC_IIR2_GAIN_B7_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_B8_CTL			(0x00000347)
#define TABLA_A_CDC_IIR1_GAIN_B8_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_B8_CTL			(0x00000357)
#define TABLA_A_CDC_IIR2_GAIN_B8_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_CTL			(0x00000348)
#define TABLA_A_CDC_IIR1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_CTL			(0x00000358)
#define TABLA_A_CDC_IIR2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_GAIN_TIMER_CTL			(0x00000349)
#define TABLA_A_CDC_IIR1_GAIN_TIMER_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_GAIN_TIMER_CTL			(0x00000359)
#define TABLA_A_CDC_IIR2_GAIN_TIMER_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_COEF_B1_CTL			(0x0000034A)
#define TABLA_A_CDC_IIR1_COEF_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_COEF_B1_CTL			(0x0000035A)
#define TABLA_A_CDC_IIR2_COEF_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_COEF_B2_CTL			(0x0000034B)
#define TABLA_A_CDC_IIR1_COEF_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_COEF_B2_CTL			(0x0000035B)
#define TABLA_A_CDC_IIR2_COEF_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_COEF_B3_CTL			(0x0000034C)
#define TABLA_A_CDC_IIR1_COEF_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_COEF_B3_CTL			(0x0000035C)
#define TABLA_A_CDC_IIR2_COEF_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_COEF_B4_CTL			(0x0000034D)
#define TABLA_A_CDC_IIR1_COEF_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_COEF_B4_CTL			(0x0000035D)
#define TABLA_A_CDC_IIR2_COEF_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR1_COEF_B5_CTL			(0x0000034E)
#define TABLA_A_CDC_IIR1_COEF_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_IIR2_COEF_B5_CTL			(0x0000035E)
#define TABLA_A_CDC_IIR2_COEF_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_TOP_GAIN_UPDATE			(0x00000360)
#define TABLA_A_CDC_TOP_GAIN_UPDATE__POR			(0x00000000)
#define TABLA_A_CDC_DEBUG_B1_CTL			(0x00000368)
#define TABLA_A_CDC_DEBUG_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_DEBUG_B2_CTL			(0x00000369)
#define TABLA_A_CDC_DEBUG_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_DEBUG_B3_CTL			(0x0000036A)
#define TABLA_A_CDC_DEBUG_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_DEBUG_B4_CTL			(0x0000036B)
#define TABLA_A_CDC_DEBUG_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_DEBUG_B5_CTL			(0x0000036C)
#define TABLA_A_CDC_DEBUG_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_DEBUG_B6_CTL			(0x0000036D)
#define TABLA_A_CDC_DEBUG_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_COMP1_B1_CTL			(0x00000370)
#define TABLA_A_CDC_COMP1_B1_CTL__POR			(0x00000030)
#define TABLA_A_CDC_COMP1_B2_CTL			(0x00000371)
#define TABLA_A_CDC_COMP1_B2_CTL__POR			(0x000000B5)
#define TABLA_A_CDC_COMP1_B3_CTL			(0x00000372)
#define TABLA_A_CDC_COMP1_B3_CTL__POR			(0x00000028)
#define TABLA_A_CDC_COMP1_B4_CTL			(0x00000373)
#define TABLA_A_CDC_COMP1_B4_CTL__POR			(0x0000003C)
#define TABLA_A_CDC_COMP1_B5_CTL			(0x00000374)
#define TABLA_A_CDC_COMP1_B5_CTL__POR			(0x0000001F)
#define TABLA_A_CDC_COMP1_B6_CTL			(0x00000375)
#define TABLA_A_CDC_COMP1_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS		(0x00000376)
#define TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS__POR	(0x00000000)
#define TABLA_A_CDC_COMP1_FS_CFG			(0x00000377)
#define TABLA_A_CDC_COMP1_FS_CFG__POR			(0x0000001B)
#define TABLA_A_CDC_COMP2_B1_CTL			(0x00000378)
#define TABLA_A_CDC_COMP2_B1_CTL__POR			(0x00000030)
#define TABLA_A_CDC_COMP2_B2_CTL			(0x00000379)
#define TABLA_A_CDC_COMP2_B2_CTL__POR			(0x000000B5)
#define TABLA_A_CDC_COMP2_B3_CTL			(0x0000037A)
#define TABLA_A_CDC_COMP2_B3_CTL__POR			(0x00000028)
#define TABLA_A_CDC_COMP2_B4_CTL			(0x0000037B)
#define TABLA_A_CDC_COMP2_B4_CTL__POR			(0x0000003C)
#define TABLA_A_CDC_COMP2_B5_CTL			(0x0000037C)
#define TABLA_A_CDC_COMP2_B5_CTL__POR			(0x0000001F)
#define TABLA_A_CDC_COMP2_B6_CTL			(0x0000037D)
#define TABLA_A_CDC_COMP2_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_COMP2_SHUT_DOWN_STATUS		(0x0000037E)
#define TABLA_A_CDC_COMP2_SHUT_DOWN_STATUS__POR	(0x00000000)
#define TABLA_A_CDC_COMP2_FS_CFG			(0x0000037F)
#define TABLA_A_CDC_COMP2_FS_CFG__POR			(0x0000001B)
#define TABLA_A_CDC_CONN_RX1_B1_CTL			(0x00000380)
#define TABLA_A_CDC_CONN_RX1_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX1_B2_CTL			(0x00000381)
#define TABLA_A_CDC_CONN_RX1_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX1_B3_CTL			(0x00000382)
#define TABLA_A_CDC_CONN_RX1_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX2_B1_CTL			(0x00000383)
#define TABLA_A_CDC_CONN_RX2_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX2_B2_CTL			(0x00000384)
#define TABLA_A_CDC_CONN_RX2_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX2_B3_CTL			(0x00000385)
#define TABLA_A_CDC_CONN_RX2_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX3_B1_CTL			(0x00000386)
#define TABLA_A_CDC_CONN_RX3_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX3_B2_CTL			(0x00000387)
#define TABLA_A_CDC_CONN_RX3_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX3_B3_CTL			(0x00000388)
#define TABLA_A_CDC_CONN_RX3_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX4_B1_CTL			(0x00000389)
#define TABLA_A_CDC_CONN_RX4_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX4_B2_CTL			(0x0000038A)
#define TABLA_A_CDC_CONN_RX4_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX5_B1_CTL			(0x0000038B)
#define TABLA_A_CDC_CONN_RX5_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX5_B2_CTL			(0x0000038C)
#define TABLA_A_CDC_CONN_RX5_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX6_B1_CTL			(0x0000038D)
#define TABLA_A_CDC_CONN_RX6_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX6_B2_CTL			(0x0000038E)
#define TABLA_A_CDC_CONN_RX6_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX7_B1_CTL			(0x0000038F)
#define TABLA_A_CDC_CONN_RX7_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX7_B2_CTL			(0x00000390)
#define TABLA_A_CDC_CONN_RX7_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_ANC_B1_CTL                     (0x00000391)
#define TABLA_A_CDC_CONN_ANC_B1_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_CONN_ANC_B2_CTL                     (0x00000392)
#define TABLA_A_CDC_CONN_ANC_B2_CTL__POR                        (0x00000000)
#define TABLA_A_CDC_CONN_TX_B1_CTL			(0x00000393)
#define TABLA_A_CDC_CONN_TX_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_B2_CTL			(0x00000394)
#define TABLA_A_CDC_CONN_TX_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_B3_CTL			(0x00000395)
#define TABLA_A_CDC_CONN_TX_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_B4_CTL			(0x00000396)
#define TABLA_A_CDC_CONN_TX_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ1_B1_CTL			(0x00000397)
#define TABLA_A_CDC_CONN_EQ1_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ1_B2_CTL			(0x00000398)
#define TABLA_A_CDC_CONN_EQ1_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ1_B3_CTL			(0x00000399)
#define TABLA_A_CDC_CONN_EQ1_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ1_B4_CTL			(0x0000039A)
#define TABLA_A_CDC_CONN_EQ1_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ2_B1_CTL			(0x0000039B)
#define TABLA_A_CDC_CONN_EQ2_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ2_B2_CTL			(0x0000039C)
#define TABLA_A_CDC_CONN_EQ2_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ2_B3_CTL			(0x0000039D)
#define TABLA_A_CDC_CONN_EQ2_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_EQ2_B4_CTL			(0x0000039E)
#define TABLA_A_CDC_CONN_EQ2_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_SRC1_B1_CTL			(0x0000039F)
#define TABLA_A_CDC_CONN_SRC1_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_SRC1_B2_CTL			(0x000003A0)
#define TABLA_A_CDC_CONN_SRC1_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_SRC2_B1_CTL			(0x000003A1)
#define TABLA_A_CDC_CONN_SRC2_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_SRC2_B2_CTL			(0x000003A2)
#define TABLA_A_CDC_CONN_SRC2_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B1_CTL			(0x000003A3)
#define TABLA_A_CDC_CONN_TX_SB_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B2_CTL			(0x000003A4)
#define TABLA_A_CDC_CONN_TX_SB_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B3_CTL			(0x000003A5)
#define TABLA_A_CDC_CONN_TX_SB_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B4_CTL			(0x000003A6)
#define TABLA_A_CDC_CONN_TX_SB_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B5_CTL			(0x000003A7)
#define TABLA_A_CDC_CONN_TX_SB_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B6_CTL			(0x000003A8)
#define TABLA_A_CDC_CONN_TX_SB_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B7_CTL			(0x000003A9)
#define TABLA_A_CDC_CONN_TX_SB_B7_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B8_CTL			(0x000003AA)
#define TABLA_A_CDC_CONN_TX_SB_B8_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B9_CTL			(0x000003AB)
#define TABLA_A_CDC_CONN_TX_SB_B9_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B10_CTL			(0x000003AC)
#define TABLA_A_CDC_CONN_TX_SB_B10_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_TX_SB_B11_CTL			(0x000003AD)
#define TABLA_A_CDC_CONN_TX_SB_B11_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX_SB_B1_CTL			(0x000003AE)
#define TABLA_A_CDC_CONN_RX_SB_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_RX_SB_B2_CTL			(0x000003AF)
#define TABLA_A_CDC_CONN_RX_SB_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_CLSG_CTL			(0x000003B0)
#define TABLA_A_CDC_CONN_CLSG_CTL__POR			(0x00000000)
#define TABLA_A_CDC_CONN_SPARE			(0x000003B1)
#define TABLA_A_CDC_CONN_SPARE__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_EN_CTL			(0x000003C0)
#define TABLA_A_CDC_MBHC_EN_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_FEATURE_B1_CFG			(0x000003C1)
#define TABLA_A_CDC_MBHC_FEATURE_B1_CFG__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_FEATURE_B2_CFG			(0x000003C2)
#define TABLA_A_CDC_MBHC_FEATURE_B2_CFG__POR			(0x00000006)
#define TABLA_A_CDC_MBHC_TIMER_B1_CTL			(0x000003C3)
#define TABLA_A_CDC_MBHC_TIMER_B1_CTL__POR			(0x00000003)
#define TABLA_A_CDC_MBHC_TIMER_B2_CTL			(0x000003C4)
#define TABLA_A_CDC_MBHC_TIMER_B2_CTL__POR			(0x00000009)
#define TABLA_A_CDC_MBHC_TIMER_B3_CTL			(0x000003C5)
#define TABLA_A_CDC_MBHC_TIMER_B3_CTL__POR			(0x0000001e)
#define TABLA_A_CDC_MBHC_TIMER_B4_CTL			(0x000003C6)
#define TABLA_A_CDC_MBHC_TIMER_B4_CTL__POR			(0x00000045)
#define TABLA_A_CDC_MBHC_TIMER_B5_CTL			(0x000003C7)
#define TABLA_A_CDC_MBHC_TIMER_B5_CTL__POR			(0x00000004)
#define TABLA_A_CDC_MBHC_TIMER_B6_CTL			(0x000003C8)
#define TABLA_A_CDC_MBHC_TIMER_B6_CTL__POR			(0x00000078)
#define TABLA_A_CDC_MBHC_B1_STATUS			(0x000003C9)
#define TABLA_A_CDC_MBHC_B1_STATUS__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_B2_STATUS			(0x000003CA)
#define TABLA_A_CDC_MBHC_B2_STATUS__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_B3_STATUS			(0x000003CB)
#define TABLA_A_CDC_MBHC_B3_STATUS__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_B4_STATUS			(0x000003CC)
#define TABLA_A_CDC_MBHC_B4_STATUS__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_B5_STATUS			(0x000003CD)
#define TABLA_A_CDC_MBHC_B5_STATUS__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_B1_CTL			(0x000003CE)
#define TABLA_A_CDC_MBHC_B1_CTL__POR			(0x000000c0)
#define TABLA_A_CDC_MBHC_B2_CTL			(0x000003CF)
#define TABLA_A_CDC_MBHC_B2_CTL__POR			(0x0000005d)
#define TABLA_A_CDC_MBHC_VOLT_B1_CTL			(0x000003D0)
#define TABLA_A_CDC_MBHC_VOLT_B1_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B2_CTL			(0x000003D1)
#define TABLA_A_CDC_MBHC_VOLT_B2_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B3_CTL			(0x000003D2)
#define TABLA_A_CDC_MBHC_VOLT_B3_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B4_CTL			(0x000003D3)
#define TABLA_A_CDC_MBHC_VOLT_B4_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B5_CTL			(0x000003D4)
#define TABLA_A_CDC_MBHC_VOLT_B5_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B6_CTL			(0x000003D5)
#define TABLA_A_CDC_MBHC_VOLT_B6_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B7_CTL			(0x000003D6)
#define TABLA_A_CDC_MBHC_VOLT_B7_CTL__POR			(0x000000ff)
#define TABLA_A_CDC_MBHC_VOLT_B8_CTL			(0x000003D7)
#define TABLA_A_CDC_MBHC_VOLT_B8_CTL__POR			(0x00000007)
#define TABLA_A_CDC_MBHC_VOLT_B9_CTL			(0x000003D8)
#define TABLA_A_CDC_MBHC_VOLT_B9_CTL__POR			(0x000000ff)
#define TABLA_A_CDC_MBHC_VOLT_B10_CTL			(0x000003D9)
#define TABLA_A_CDC_MBHC_VOLT_B10_CTL__POR			(0x0000007f)
#define TABLA_A_CDC_MBHC_VOLT_B11_CTL			(0x000003DA)
#define TABLA_A_CDC_MBHC_VOLT_B11_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_VOLT_B12_CTL			(0x000003DB)
#define TABLA_A_CDC_MBHC_VOLT_B12_CTL__POR			(0x00000080)
#define TABLA_A_CDC_MBHC_CLK_CTL			(0x000003DC)
#define TABLA_A_CDC_MBHC_CLK_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_INT_CTL			(0x000003DD)
#define TABLA_A_CDC_MBHC_INT_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_DEBUG_CTL			(0x000003DE)
#define TABLA_A_CDC_MBHC_DEBUG_CTL__POR			(0x00000000)
#define TABLA_A_CDC_MBHC_SPARE			(0x000003DF)
#define TABLA_A_CDC_MBHC_SPARE__POR			(0x00000000)


/* SLIMBUS Slave Registers */
#define TABLA_SLIM_PGD_PORT_INT_EN0                     (0x30)
#define TABLA_SLIM_PGD_PORT_INT_STATUS0                 (0x34)
#define TABLA_SLIM_PGD_PORT_INT_CLR0                    (0x38)
#define TABLA_SLIM_PGD_PORT_INT_SOURCE0			(0x60)

/* Macros for Packing Register Writes into a U32 */
#define TABLA_PACKED_REG_SIZE sizeof(u32)

#define TABLA_CODEC_PACK_ENTRY(reg, mask, val) ((val & 0xff)|\
	((mask & 0xff) << 8)|((reg & 0xffff) << 16))

#define TABLA_CODEC_UNPACK_ENTRY(packed, reg, mask, val) \
	do { \
		((reg) = ((packed >> 16) & (0xffff))); \
		((mask) = ((packed >> 8) & (0xff))); \
		((val) = ((packed) & (0xff))); \
	} while (0);

#endif
