% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_intercept.R
\name{get_intercept}
\alias{get_intercept}
\title{Get the value at the intercept}
\usage{
get_intercept(x, ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Not used.}
}
\value{
The value of the intercept.
}
\description{
Returns the value at the intercept (i.e., the intercept
parameter), and \code{NA} if there isn't one.
}
\examples{
get_intercept(lm(Sepal.Length ~ Petal.Width, data = iris))
get_intercept(lm(Sepal.Length ~ 0 + Petal.Width, data = iris))

\dontshow{if (require("lme4", quietly = TRUE)) withAutoprint(\{ # examplesIf}
get_intercept(lme4::lmer(Sepal.Length ~ Sepal.Width + (1 | Species), data = iris))
\dontshow{\}) # examplesIf}
\dontshow{if (require("gamm4")) withAutoprint(\{ # examplesIf}
get_intercept(gamm4::gamm4(Sepal.Length ~ s(Petal.Width), data = iris))
\dontshow{\}) # examplesIf}
}
