# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource import ResourceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceManagementProvidersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_unregister(self, resource_group):
        response = self.client.providers.unregister(
            resource_provider_namespace="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_register_at_management_group_scope(self, resource_group):
        response = self.client.providers.register_at_management_group_scope(
            resource_provider_namespace="str",
            group_id="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_provider_permissions(self, resource_group):
        response = self.client.providers.provider_permissions(
            resource_provider_namespace="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_register(self, resource_group):
        response = self.client.providers.register(
            resource_provider_namespace="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_list(self, resource_group):
        response = self.client.providers.list(
            api_version="2022-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_list_at_tenant_scope(self, resource_group):
        response = self.client.providers.list_at_tenant_scope(
            api_version="2022-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_get(self, resource_group):
        response = self.client.providers.get(
            resource_provider_namespace="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_providers_get_at_tenant_scope(self, resource_group):
        response = self.client.providers.get_at_tenant_scope(
            resource_provider_namespace="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...
