"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyGsubTable = rectifyGsubTable;
exports.rectifyGposTable = rectifyGposTable;
const Ot = require("@ot-builder/ot");
const cleanup_1 = require("./cleanup");
const lookup_removable_alg_1 = require("./lookup-removable-alg");
const rectify_1 = require("./rectify");
function rectifyGsubTable(recGlyphs, recAxes, recCoord, recPA, table) {
    const alg = new rectify_1.RectifyGsubGlyphCoordAlg(recGlyphs, recCoord, recPA);
    const lookupCorrespondence = (0, rectify_1.rectifyLookupList)(table.lookups, alg, (l, a) => a.process(l));
    const newTable = (0, cleanup_1.cleanupGsubGposData)(table, new Ot.Gsub.Table(), lookupCorrespondence, {
        lookupRemovable: l => lookup_removable_alg_1.LookupRemovableAlg.process(l),
        cleanupBrokenCrossLinks: (l, v) => lookup_removable_alg_1.RemoveBrokenLinkAlg.process(l, v)
    });
    if (newTable && newTable.featureVariations) {
        for (const fv of newTable.featureVariations)
            (0, cleanup_1.axesRectifyFeatureVariation)(recAxes, fv);
    }
    return newTable;
}
function rectifyGposTable(recGlyphs, recAxes, recCoord, recPA, table) {
    const alg = new rectify_1.RectifyGposGlyphCoordAlg(recGlyphs, recCoord, recPA);
    const lookupCorrespondence = (0, rectify_1.rectifyLookupList)(table.lookups, alg, (l, a) => a.process(l));
    const newTable = (0, cleanup_1.cleanupGsubGposData)(table, new Ot.Gpos.Table(), lookupCorrespondence, {
        lookupRemovable: l => lookup_removable_alg_1.LookupRemovableAlg.process(l),
        cleanupBrokenCrossLinks: (l, v) => lookup_removable_alg_1.RemoveBrokenLinkAlg.process(l, v)
    });
    if (newTable && newTable.featureVariations) {
        for (const fv of newTable.featureVariations)
            (0, cleanup_1.axesRectifyFeatureVariation)(recAxes, fv);
    }
    return newTable;
}
//# sourceMappingURL=index.js.map