//  Copyright 2024 Google LLC

//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at

//     https://www.apache.org/licenses/LICENSE-2.0

//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v3.21.12
// source: plugin_comm.proto

package plugin_comm

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request sent to plugins to start.
type StartRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Any config like the state directory path can be passed here on startup.
	Config *StartRequest_Config `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Data is any additional Guest Agent agnostic payload handed off to the
	// plugin on every start request. Payload is optional and defined by the
	// service and plugin itself.
	//
	// Types that are valid to be assigned to ServiceConfig:
	//
	//	*StartRequest_StringConfig
	//	*StartRequest_StructConfig
	ServiceConfig isStartRequest_ServiceConfig `protobuf_oneof:"service_config"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartRequest) Reset() {
	*x = StartRequest{}
	mi := &file_plugin_comm_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartRequest) ProtoMessage() {}

func (x *StartRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartRequest.ProtoReflect.Descriptor instead.
func (*StartRequest) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{0}
}

func (x *StartRequest) GetConfig() *StartRequest_Config {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *StartRequest) GetServiceConfig() isStartRequest_ServiceConfig {
	if x != nil {
		return x.ServiceConfig
	}
	return nil
}

func (x *StartRequest) GetStringConfig() string {
	if x != nil {
		if x, ok := x.ServiceConfig.(*StartRequest_StringConfig); ok {
			return x.StringConfig
		}
	}
	return ""
}

func (x *StartRequest) GetStructConfig() *structpb.Struct {
	if x != nil {
		if x, ok := x.ServiceConfig.(*StartRequest_StructConfig); ok {
			return x.StructConfig
		}
	}
	return nil
}

type isStartRequest_ServiceConfig interface {
	isStartRequest_ServiceConfig()
}

type StartRequest_StringConfig struct {
	// String configuration. Any string payload that the plugin understands.
	StringConfig string `protobuf:"bytes,2,opt,name=string_config,json=stringConfig,proto3,oneof"`
}

type StartRequest_StructConfig struct {
	// Struct configuration. Usually used for reading file based configuration
	// like JSON or yaml.
	StructConfig *structpb.Struct `protobuf:"bytes,3,opt,name=struct_config,json=structConfig,proto3,oneof"`
}

func (*StartRequest_StringConfig) isStartRequest_ServiceConfig() {}

func (*StartRequest_StructConfig) isStartRequest_ServiceConfig() {}

// Guest Agent does not expect any response from plugins for start request, it
// will poll for status with health check requests later. In case of any error
// plugins should throw RPC error.
// https://pkg.go.dev/google.golang.org/grpc/status#ErrorProto
type StartResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartResponse) Reset() {
	*x = StartResponse{}
	mi := &file_plugin_comm_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartResponse) ProtoMessage() {}

func (x *StartResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartResponse.ProtoReflect.Descriptor instead.
func (*StartResponse) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{1}
}

// Guest Agent agnostic request from services forwarded to the plugins.
type ApplyRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Service specific configuration that is passed to the plugin. This is same
	// as the service_config in the StartRequest. However, it allows updating the
	// config without restarting the plugin. If the plugin does not support
	// updating the config, it should return an unimplemented error in which case
	// the plugin manager will restart the plugin with the new config.
	//
	// Types that are valid to be assigned to ServiceConfig:
	//
	//	*ApplyRequest_StringConfig
	//	*ApplyRequest_StructConfig
	ServiceConfig isApplyRequest_ServiceConfig `protobuf_oneof:"service_config"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyRequest) Reset() {
	*x = ApplyRequest{}
	mi := &file_plugin_comm_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRequest) ProtoMessage() {}

func (x *ApplyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRequest.ProtoReflect.Descriptor instead.
func (*ApplyRequest) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{2}
}

func (x *ApplyRequest) GetServiceConfig() isApplyRequest_ServiceConfig {
	if x != nil {
		return x.ServiceConfig
	}
	return nil
}

func (x *ApplyRequest) GetStringConfig() string {
	if x != nil {
		if x, ok := x.ServiceConfig.(*ApplyRequest_StringConfig); ok {
			return x.StringConfig
		}
	}
	return ""
}

func (x *ApplyRequest) GetStructConfig() *structpb.Struct {
	if x != nil {
		if x, ok := x.ServiceConfig.(*ApplyRequest_StructConfig); ok {
			return x.StructConfig
		}
	}
	return nil
}

type isApplyRequest_ServiceConfig interface {
	isApplyRequest_ServiceConfig()
}

type ApplyRequest_StringConfig struct {
	// String configuration. Any string payload that the plugin understands.
	StringConfig string `protobuf:"bytes,2,opt,name=string_config,json=stringConfig,proto3,oneof"`
}

type ApplyRequest_StructConfig struct {
	// Struct configuration. Usually used for reading file based configuration
	// like JSON or yaml.
	StructConfig *structpb.Struct `protobuf:"bytes,3,opt,name=struct_config,json=structConfig,proto3,oneof"`
}

func (*ApplyRequest_StringConfig) isApplyRequest_ServiceConfig() {}

func (*ApplyRequest_StructConfig) isApplyRequest_ServiceConfig() {}

// Response from plugins for apply request.
type ApplyResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyResponse) Reset() {
	*x = ApplyResponse{}
	mi := &file_plugin_comm_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResponse) ProtoMessage() {}

func (x *ApplyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResponse.ProtoReflect.Descriptor instead.
func (*ApplyResponse) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{3}
}

// Guest Agent sends requests to get current status.
type GetStatusRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This data payload is optionally supplied to the plugin. It's empty for
	// regular periodic health checks and contains context on what request is for
	// (like task ID) in specialized requests.
	// General periodic health check is the request that agent makes to verify
	// plugins are healthy and running. Plugins can report any ongoing
	// status which will be sent back to the service.
	// Specialized status request is something that plugin owners can
	// define on each plugin similar to apply request. This can be used to
	// request specific status. For e.g. if Apply() request was made to make run
	// some task, this type can be used to check status for it.
	Data          *string `protobuf:"bytes,2,opt,name=data,proto3,oneof" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetStatusRequest) Reset() {
	*x = GetStatusRequest{}
	mi := &file_plugin_comm_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStatusRequest) ProtoMessage() {}

func (x *GetStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStatusRequest.ProtoReflect.Descriptor instead.
func (*GetStatusRequest) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{4}
}

func (x *GetStatusRequest) GetData() string {
	if x != nil && x.Data != nil {
		return *x.Data
	}
	return ""
}

// Response from plugins for status request.
type Status struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Non-zero code would mean plugin is unhealthy for health check.
	// For specialized request contract can be defined between service and plugin
	// itself, Guest Agent will make no interpretation and simply report as is.
	Code int32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// Human readable summary on current status describing the status code.
	// Can include one or more error logs or details describing the issue.
	Results       []string `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Status) Reset() {
	*x = Status{}
	mi := &file_plugin_comm_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{5}
}

func (x *Status) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *Status) GetResults() []string {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request sent to plugins to stop and exit the process.
// Plugins processes are killed immediately after this request returns.
type StopRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Cleanup is set to true to notify plugins to remove any state stored on
	// disk. Stop request can be sent as part of plugin restart which does not
	// require cleanup whereas plugin remove does require.
	Cleanup bool `protobuf:"varint,1,opt,name=cleanup,proto3" json:"cleanup,omitempty"`
	// Guest Agent will wait for this deadline, if the plugin gracefully
	// exits, guest agent will do nothing. If the plugin process is still
	// running, then it is killed.
	Deadline      *durationpb.Duration `protobuf:"bytes,2,opt,name=deadline,proto3" json:"deadline,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopRequest) Reset() {
	*x = StopRequest{}
	mi := &file_plugin_comm_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopRequest) ProtoMessage() {}

func (x *StopRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopRequest.ProtoReflect.Descriptor instead.
func (*StopRequest) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{6}
}

func (x *StopRequest) GetCleanup() bool {
	if x != nil {
		return x.Cleanup
	}
	return false
}

func (x *StopRequest) GetDeadline() *durationpb.Duration {
	if x != nil {
		return x.Deadline
	}
	return nil
}

// Response from plugins for stop request.
type StopResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopResponse) Reset() {
	*x = StopResponse{}
	mi := &file_plugin_comm_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopResponse) ProtoMessage() {}

func (x *StopResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopResponse.ProtoReflect.Descriptor instead.
func (*StopResponse) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{7}
}

// Config is Guest Agent managed config that is passed to the every plugin on
// startup.
type StartRequest_Config struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path to the state directory where plugins are allowed to store any state
	// that they want to persist across revisions.
	StateDirectoryPath string `protobuf:"bytes,1,opt,name=state_directory_path,json=stateDirectoryPath,proto3" json:"state_directory_path,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *StartRequest_Config) Reset() {
	*x = StartRequest_Config{}
	mi := &file_plugin_comm_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartRequest_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartRequest_Config) ProtoMessage() {}

func (x *StartRequest_Config) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_comm_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartRequest_Config.ProtoReflect.Descriptor instead.
func (*StartRequest_Config) Descriptor() ([]byte, []int) {
	return file_plugin_comm_proto_rawDescGZIP(), []int{0, 0}
}

func (x *StartRequest_Config) GetStateDirectoryPath() string {
	if x != nil {
		return x.StateDirectoryPath
	}
	return ""
}

var File_plugin_comm_proto protoreflect.FileDescriptor

var file_plugin_comm_proto_rawDesc = string([]byte{
	0x0a, 0x11, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd,
	0x01, 0x0a, 0x0c, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x38, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0d, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3e, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x3a, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x61, 0x74, 0x68, 0x42, 0x10, 0x0a, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x0f,
	0x0a, 0x0d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x8d, 0x01, 0x0a, 0x0c, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x25, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22,
	0x0f, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x34, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x22, 0x36, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x5e,
	0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a,
	0x07, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x65, 0x61, 0x64, 0x6c,
	0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x0e,
	0x0a, 0x0c, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x98,
	0x02, 0x0a, 0x10, 0x47, 0x75, 0x65, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x12, 0x40, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x19, 0x2e, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3d, 0x0a, 0x04, 0x53, 0x74, 0x6f, 0x70, 0x12, 0x18, 0x2e,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x53, 0x74, 0x6f, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x1d, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x13, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x05, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x12, 0x19, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x0e, 0x5a, 0x0c, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
})

var (
	file_plugin_comm_proto_rawDescOnce sync.Once
	file_plugin_comm_proto_rawDescData []byte
)

func file_plugin_comm_proto_rawDescGZIP() []byte {
	file_plugin_comm_proto_rawDescOnce.Do(func() {
		file_plugin_comm_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_plugin_comm_proto_rawDesc), len(file_plugin_comm_proto_rawDesc)))
	})
	return file_plugin_comm_proto_rawDescData
}

var file_plugin_comm_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_plugin_comm_proto_goTypes = []any{
	(*StartRequest)(nil),        // 0: plugin_comm.StartRequest
	(*StartResponse)(nil),       // 1: plugin_comm.StartResponse
	(*ApplyRequest)(nil),        // 2: plugin_comm.ApplyRequest
	(*ApplyResponse)(nil),       // 3: plugin_comm.ApplyResponse
	(*GetStatusRequest)(nil),    // 4: plugin_comm.GetStatusRequest
	(*Status)(nil),              // 5: plugin_comm.Status
	(*StopRequest)(nil),         // 6: plugin_comm.StopRequest
	(*StopResponse)(nil),        // 7: plugin_comm.StopResponse
	(*StartRequest_Config)(nil), // 8: plugin_comm.StartRequest.Config
	(*structpb.Struct)(nil),     // 9: google.protobuf.Struct
	(*durationpb.Duration)(nil), // 10: google.protobuf.Duration
}
var file_plugin_comm_proto_depIdxs = []int32{
	8,  // 0: plugin_comm.StartRequest.config:type_name -> plugin_comm.StartRequest.Config
	9,  // 1: plugin_comm.StartRequest.struct_config:type_name -> google.protobuf.Struct
	9,  // 2: plugin_comm.ApplyRequest.struct_config:type_name -> google.protobuf.Struct
	10, // 3: plugin_comm.StopRequest.deadline:type_name -> google.protobuf.Duration
	0,  // 4: plugin_comm.GuestAgentPlugin.Start:input_type -> plugin_comm.StartRequest
	6,  // 5: plugin_comm.GuestAgentPlugin.Stop:input_type -> plugin_comm.StopRequest
	4,  // 6: plugin_comm.GuestAgentPlugin.GetStatus:input_type -> plugin_comm.GetStatusRequest
	2,  // 7: plugin_comm.GuestAgentPlugin.Apply:input_type -> plugin_comm.ApplyRequest
	1,  // 8: plugin_comm.GuestAgentPlugin.Start:output_type -> plugin_comm.StartResponse
	7,  // 9: plugin_comm.GuestAgentPlugin.Stop:output_type -> plugin_comm.StopResponse
	5,  // 10: plugin_comm.GuestAgentPlugin.GetStatus:output_type -> plugin_comm.Status
	3,  // 11: plugin_comm.GuestAgentPlugin.Apply:output_type -> plugin_comm.ApplyResponse
	8,  // [8:12] is the sub-list for method output_type
	4,  // [4:8] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_plugin_comm_proto_init() }
func file_plugin_comm_proto_init() {
	if File_plugin_comm_proto != nil {
		return
	}
	file_plugin_comm_proto_msgTypes[0].OneofWrappers = []any{
		(*StartRequest_StringConfig)(nil),
		(*StartRequest_StructConfig)(nil),
	}
	file_plugin_comm_proto_msgTypes[2].OneofWrappers = []any{
		(*ApplyRequest_StringConfig)(nil),
		(*ApplyRequest_StructConfig)(nil),
	}
	file_plugin_comm_proto_msgTypes[4].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_plugin_comm_proto_rawDesc), len(file_plugin_comm_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_plugin_comm_proto_goTypes,
		DependencyIndexes: file_plugin_comm_proto_depIdxs,
		MessageInfos:      file_plugin_comm_proto_msgTypes,
	}.Build()
	File_plugin_comm_proto = out.File
	file_plugin_comm_proto_goTypes = nil
	file_plugin_comm_proto_depIdxs = nil
}
