/*
 *  Copyright (C) 2021 - This file is part of libecc project
 *
 *  Authors:
 *      Arnaud EBALARD <arnaud.ebalard@ssi.gouv.fr>
 *      Ryad BENADJILA <ryadbenadjila@gmail.com>
 *
 *  This software is licensed under a dual BSD and GPL v2 license.
 *  See LICENSE file at the root folder of the project.
 */
#ifndef __ED448PH_TEST_VECTORS_H__
#define __ED448PH_TEST_VECTORS_H__

/************************************************/
static const u8 ed448ph_1_test_vectors_priv_key[] = {
	0x83, 0x3f, 0xe6, 0x24, 0x09, 0x23, 0x7b, 0x9d, 0x62, 0xec, 0x77, 0x58, 0x75, 0x20, 0x91, 0x1e, 0x9a, 0x75, 0x9c, 0xec, 0x1d, 0x19, 0x75, 0x5b, 0x7d, 0xa9, 0x01, 0xb9, 0x6d, 0xca, 0x3d, 0x42, 0xef, 0x78, 0x22, 0xe0, 0xd5, 0x10, 0x41, 0x27, 0xdc, 0x05, 0xd6, 0xdb, 0xef, 0xde, 0x69, 0xe3, 0xab, 0x2c, 0xec, 0x7c, 0x86, 0x7c, 0x6e, 0x2c, 0x49,
 };
static const u8 ed448ph_1_test_vectors_expected_sig[] = {
	0x82, 0x2f, 0x69, 0x01, 0xf7, 0x48, 0x0f, 0x3d, 0x5f, 0x56, 0x2c, 0x59, 0x29, 0x94, 0xd9, 0x69, 0x36, 0x02, 0x87, 0x56, 0x14, 0x48, 0x32, 0x56, 0x50, 0x56, 0x00, 0xbb, 0xc2, 0x81, 0xae, 0x38, 0x1f, 0x54, 0xd6, 0xbc, 0xe2, 0xea, 0x91, 0x15, 0x74, 0x93, 0x2f, 0x52, 0xa4, 0xe6, 0xca, 0xdd, 0x78, 0x76, 0x93, 0x75, 0xec, 0x3f, 0xfd, 0x1b, 0x80, 0x1a, 0x0d, 0x9b, 0x3f, 0x40, 0x30, 0xcd, 0x43, 0x39, 0x64, 0xb6, 0x45, 0x7e, 0xa3, 0x94, 0x76, 0x51, 0x12, 0x14, 0xf9, 0x74, 0x69, 0xb5, 0x7d, 0xd3, 0x2d, 0xbc, 0x56, 0x0a, 0x9a, 0x94, 0xd0, 0x0b, 0xff, 0x07, 0x62, 0x04, 0x64, 0xa3, 0xad, 0x20, 0x3d, 0xf7, 0xdc, 0x7c, 0xe3, 0x60, 0xc3, 0xcd, 0x36, 0x96, 0xd9, 0xd9, 0xfa, 0xb9, 0x0f, 0x00,
 };
static const u8 ed448ph_1_test_vectors_message[] = {
	0x61, 0x62, 0x63,
 };
static const ec_test_case ed448ph_1_test_case = {
        .name = "EDDSA448PH-SHAKE256/wei448 1",
        .ec_str_p = &wei448_str_params,
        .priv_key = ed448ph_1_test_vectors_priv_key,
        .priv_key_len = sizeof(ed448ph_1_test_vectors_priv_key),
        .nn_random = NULL,
        .hash_type = SHAKE256,
        .msg = (const char *)ed448ph_1_test_vectors_message,
        .msglen = sizeof(ed448ph_1_test_vectors_message),
        .sig_type = EDDSA448PH,
        .exp_sig = ed448ph_1_test_vectors_expected_sig,
        .exp_siglen = sizeof(ed448ph_1_test_vectors_expected_sig),
	.adata = NULL,
	.adata_len = 0,
};

/************************************************/
static const u8 ed448ph_2_test_vectors_priv_key[] = {
	0x83, 0x3f, 0xe6, 0x24, 0x09, 0x23, 0x7b, 0x9d, 0x62, 0xec, 0x77, 0x58, 0x75, 0x20, 0x91, 0x1e, 0x9a, 0x75, 0x9c, 0xec, 0x1d, 0x19, 0x75, 0x5b, 0x7d, 0xa9, 0x01, 0xb9, 0x6d, 0xca, 0x3d, 0x42, 0xef, 0x78, 0x22, 0xe0, 0xd5, 0x10, 0x41, 0x27, 0xdc, 0x05, 0xd6, 0xdb, 0xef, 0xde, 0x69, 0xe3, 0xab, 0x2c, 0xec, 0x7c, 0x86, 0x7c, 0x6e, 0x2c, 0x49,
 };
static const u8 ed448ph_2_test_vectors_expected_sig[] = {
	0xc3, 0x22, 0x99, 0xd4, 0x6e, 0xc8, 0xff, 0x02, 0xb5, 0x45, 0x40, 0x98, 0x28, 0x14, 0xdc, 0xe9, 0xa0, 0x58, 0x12, 0xf8, 0x19, 0x62, 0xb6, 0x49, 0xd5, 0x28, 0x09, 0x59, 0x16, 0xa2, 0xaa, 0x48, 0x10, 0x65, 0xb1, 0x58, 0x04, 0x23, 0xef, 0x92, 0x7e, 0xcf, 0x0a, 0xf5, 0x88, 0x8f, 0x90, 0xda, 0x0f, 0x6a, 0x9a, 0x85, 0xad, 0x5d, 0xc3, 0xf2, 0x80, 0xd9, 0x12, 0x24, 0xba, 0x99, 0x11, 0xa3, 0x65, 0x3d, 0x00, 0xe4, 0x84, 0xe2, 0xce, 0x23, 0x25, 0x21, 0x48, 0x1c, 0x86, 0x58, 0xdf, 0x30, 0x4b, 0xb7, 0x74, 0x5a, 0x73, 0x51, 0x4c, 0xdb, 0x9b, 0xf3, 0xe1, 0x57, 0x84, 0xab, 0x71, 0x28, 0x4f, 0x8d, 0x07, 0x04, 0xa6, 0x08, 0xc5, 0x4a, 0x6b, 0x62, 0xd9, 0x7b, 0xeb, 0x51, 0x1d, 0x13, 0x21, 0x00,
 };
static const u8 ed448ph_2_test_vectors_message[] = {
	0x61, 0x62, 0x63,
 };
static const u8 ed448ph_2_test_vectors_adata[] = {
	0x66, 0x6f, 0x6f,
 };
static const ec_test_case ed448ph_2_test_case = {
        .name = "EDDSA448PH-SHAKE256/wei448 2",
        .ec_str_p = &wei448_str_params,
        .priv_key = ed448ph_2_test_vectors_priv_key,
        .priv_key_len = sizeof(ed448ph_2_test_vectors_priv_key),
        .nn_random = NULL,
        .hash_type = SHAKE256,
        .msg = (const char *)ed448ph_2_test_vectors_message,
        .msglen = sizeof(ed448ph_2_test_vectors_message),
        .sig_type = EDDSA448PH,
        .exp_sig = ed448ph_2_test_vectors_expected_sig,
        .exp_siglen = sizeof(ed448ph_2_test_vectors_expected_sig),
	.adata = ed448ph_2_test_vectors_adata,
	.adata_len = sizeof(ed448ph_2_test_vectors_adata),
};

/************************************************/
#define EDDSA448PH_SHAKE256_WEI448_ALL_TESTS() \
        &ed448ph_1_test_case,\
        &ed448ph_2_test_case,

#endif /* __ED448PH_TEST_VECTORS_H__ */
