// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file maps.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__MAPS_HPP
#define FAST_DDS_GENERATED__MAPS_HPP

#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MAPS_SOURCE)
#define MAPS_DllAPI __declspec( dllexport )
#else
#define MAPS_DllAPI __declspec( dllimport )
#endif // MAPS_SOURCE
#else
#define MAPS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MAPS_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure MapShortShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortShort that will be copied.
     */
    eProsima_user_DllExport MapShortShort(
            const MapShortShort& x)
    {
                    m_var_map_short_short = x.m_var_map_short_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortShort that will be copied.
     */
    eProsima_user_DllExport MapShortShort(
            MapShortShort&& x) noexcept
    {
        m_var_map_short_short = std::move(x.m_var_map_short_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortShort that will be copied.
     */
    eProsima_user_DllExport MapShortShort& operator =(
            const MapShortShort& x)
    {

                    m_var_map_short_short = x.m_var_map_short_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortShort that will be copied.
     */
    eProsima_user_DllExport MapShortShort& operator =(
            MapShortShort&& x) noexcept
    {

        m_var_map_short_short = std::move(x.m_var_map_short_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortShort& x) const
    {
        return (m_var_map_short_short == x.m_var_map_short_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_short
     * @param _var_map_short_short New value to be copied in member var_map_short_short
     */
    eProsima_user_DllExport void var_map_short_short(
            const std::map<int16_t, int16_t>& _var_map_short_short)
    {
        m_var_map_short_short = _var_map_short_short;
    }

    /*!
     * @brief This function moves the value in member var_map_short_short
     * @param _var_map_short_short New value to be moved in member var_map_short_short
     */
    eProsima_user_DllExport void var_map_short_short(
            std::map<int16_t, int16_t>&& _var_map_short_short)
    {
        m_var_map_short_short = std::move(_var_map_short_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_short
     * @return Constant reference to member var_map_short_short
     */
    eProsima_user_DllExport const std::map<int16_t, int16_t>& var_map_short_short() const
    {
        return m_var_map_short_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_short
     * @return Reference to member var_map_short_short
     */
    eProsima_user_DllExport std::map<int16_t, int16_t>& var_map_short_short()
    {
        return m_var_map_short_short;
    }



private:

    std::map<int16_t, int16_t> m_var_map_short_short;

};
/*!
 * @brief This class represents the structure MapShortUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortUShort that will be copied.
     */
    eProsima_user_DllExport MapShortUShort(
            const MapShortUShort& x)
    {
                    m_var_map_short_ushort = x.m_var_map_short_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortUShort that will be copied.
     */
    eProsima_user_DllExport MapShortUShort(
            MapShortUShort&& x) noexcept
    {
        m_var_map_short_ushort = std::move(x.m_var_map_short_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortUShort that will be copied.
     */
    eProsima_user_DllExport MapShortUShort& operator =(
            const MapShortUShort& x)
    {

                    m_var_map_short_ushort = x.m_var_map_short_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortUShort that will be copied.
     */
    eProsima_user_DllExport MapShortUShort& operator =(
            MapShortUShort&& x) noexcept
    {

        m_var_map_short_ushort = std::move(x.m_var_map_short_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortUShort& x) const
    {
        return (m_var_map_short_ushort == x.m_var_map_short_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_ushort
     * @param _var_map_short_ushort New value to be copied in member var_map_short_ushort
     */
    eProsima_user_DllExport void var_map_short_ushort(
            const std::map<int16_t, uint16_t>& _var_map_short_ushort)
    {
        m_var_map_short_ushort = _var_map_short_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_short_ushort
     * @param _var_map_short_ushort New value to be moved in member var_map_short_ushort
     */
    eProsima_user_DllExport void var_map_short_ushort(
            std::map<int16_t, uint16_t>&& _var_map_short_ushort)
    {
        m_var_map_short_ushort = std::move(_var_map_short_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_ushort
     * @return Constant reference to member var_map_short_ushort
     */
    eProsima_user_DllExport const std::map<int16_t, uint16_t>& var_map_short_ushort() const
    {
        return m_var_map_short_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_ushort
     * @return Reference to member var_map_short_ushort
     */
    eProsima_user_DllExport std::map<int16_t, uint16_t>& var_map_short_ushort()
    {
        return m_var_map_short_ushort;
    }



private:

    std::map<int16_t, uint16_t> m_var_map_short_ushort;

};
/*!
 * @brief This class represents the structure MapShortLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortLong that will be copied.
     */
    eProsima_user_DllExport MapShortLong(
            const MapShortLong& x)
    {
                    m_var_map_short_long = x.m_var_map_short_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortLong that will be copied.
     */
    eProsima_user_DllExport MapShortLong(
            MapShortLong&& x) noexcept
    {
        m_var_map_short_long = std::move(x.m_var_map_short_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortLong that will be copied.
     */
    eProsima_user_DllExport MapShortLong& operator =(
            const MapShortLong& x)
    {

                    m_var_map_short_long = x.m_var_map_short_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortLong that will be copied.
     */
    eProsima_user_DllExport MapShortLong& operator =(
            MapShortLong&& x) noexcept
    {

        m_var_map_short_long = std::move(x.m_var_map_short_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortLong& x) const
    {
        return (m_var_map_short_long == x.m_var_map_short_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_long
     * @param _var_map_short_long New value to be copied in member var_map_short_long
     */
    eProsima_user_DllExport void var_map_short_long(
            const std::map<int16_t, int32_t>& _var_map_short_long)
    {
        m_var_map_short_long = _var_map_short_long;
    }

    /*!
     * @brief This function moves the value in member var_map_short_long
     * @param _var_map_short_long New value to be moved in member var_map_short_long
     */
    eProsima_user_DllExport void var_map_short_long(
            std::map<int16_t, int32_t>&& _var_map_short_long)
    {
        m_var_map_short_long = std::move(_var_map_short_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_long
     * @return Constant reference to member var_map_short_long
     */
    eProsima_user_DllExport const std::map<int16_t, int32_t>& var_map_short_long() const
    {
        return m_var_map_short_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_long
     * @return Reference to member var_map_short_long
     */
    eProsima_user_DllExport std::map<int16_t, int32_t>& var_map_short_long()
    {
        return m_var_map_short_long;
    }



private:

    std::map<int16_t, int32_t> m_var_map_short_long;

};
/*!
 * @brief This class represents the structure MapShortULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortULong that will be copied.
     */
    eProsima_user_DllExport MapShortULong(
            const MapShortULong& x)
    {
                    m_var_map_short_ulong = x.m_var_map_short_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortULong that will be copied.
     */
    eProsima_user_DllExport MapShortULong(
            MapShortULong&& x) noexcept
    {
        m_var_map_short_ulong = std::move(x.m_var_map_short_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortULong that will be copied.
     */
    eProsima_user_DllExport MapShortULong& operator =(
            const MapShortULong& x)
    {

                    m_var_map_short_ulong = x.m_var_map_short_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortULong that will be copied.
     */
    eProsima_user_DllExport MapShortULong& operator =(
            MapShortULong&& x) noexcept
    {

        m_var_map_short_ulong = std::move(x.m_var_map_short_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortULong& x) const
    {
        return (m_var_map_short_ulong == x.m_var_map_short_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_ulong
     * @param _var_map_short_ulong New value to be copied in member var_map_short_ulong
     */
    eProsima_user_DllExport void var_map_short_ulong(
            const std::map<int16_t, uint32_t>& _var_map_short_ulong)
    {
        m_var_map_short_ulong = _var_map_short_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_short_ulong
     * @param _var_map_short_ulong New value to be moved in member var_map_short_ulong
     */
    eProsima_user_DllExport void var_map_short_ulong(
            std::map<int16_t, uint32_t>&& _var_map_short_ulong)
    {
        m_var_map_short_ulong = std::move(_var_map_short_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_ulong
     * @return Constant reference to member var_map_short_ulong
     */
    eProsima_user_DllExport const std::map<int16_t, uint32_t>& var_map_short_ulong() const
    {
        return m_var_map_short_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_ulong
     * @return Reference to member var_map_short_ulong
     */
    eProsima_user_DllExport std::map<int16_t, uint32_t>& var_map_short_ulong()
    {
        return m_var_map_short_ulong;
    }



private:

    std::map<int16_t, uint32_t> m_var_map_short_ulong;

};
/*!
 * @brief This class represents the structure MapShortLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapShortLongLong(
            const MapShortLongLong& x)
    {
                    m_var_map_short_longlong = x.m_var_map_short_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapShortLongLong(
            MapShortLongLong&& x) noexcept
    {
        m_var_map_short_longlong = std::move(x.m_var_map_short_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapShortLongLong& operator =(
            const MapShortLongLong& x)
    {

                    m_var_map_short_longlong = x.m_var_map_short_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapShortLongLong& operator =(
            MapShortLongLong&& x) noexcept
    {

        m_var_map_short_longlong = std::move(x.m_var_map_short_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortLongLong& x) const
    {
        return (m_var_map_short_longlong == x.m_var_map_short_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_longlong
     * @param _var_map_short_longlong New value to be copied in member var_map_short_longlong
     */
    eProsima_user_DllExport void var_map_short_longlong(
            const std::map<int16_t, int64_t>& _var_map_short_longlong)
    {
        m_var_map_short_longlong = _var_map_short_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_short_longlong
     * @param _var_map_short_longlong New value to be moved in member var_map_short_longlong
     */
    eProsima_user_DllExport void var_map_short_longlong(
            std::map<int16_t, int64_t>&& _var_map_short_longlong)
    {
        m_var_map_short_longlong = std::move(_var_map_short_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_longlong
     * @return Constant reference to member var_map_short_longlong
     */
    eProsima_user_DllExport const std::map<int16_t, int64_t>& var_map_short_longlong() const
    {
        return m_var_map_short_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_longlong
     * @return Reference to member var_map_short_longlong
     */
    eProsima_user_DllExport std::map<int16_t, int64_t>& var_map_short_longlong()
    {
        return m_var_map_short_longlong;
    }



private:

    std::map<int16_t, int64_t> m_var_map_short_longlong;

};
/*!
 * @brief This class represents the structure MapShortULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapShortULongLong(
            const MapShortULongLong& x)
    {
                    m_var_map_short_ulonglong = x.m_var_map_short_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapShortULongLong(
            MapShortULongLong&& x) noexcept
    {
        m_var_map_short_ulonglong = std::move(x.m_var_map_short_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapShortULongLong& operator =(
            const MapShortULongLong& x)
    {

                    m_var_map_short_ulonglong = x.m_var_map_short_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapShortULongLong& operator =(
            MapShortULongLong&& x) noexcept
    {

        m_var_map_short_ulonglong = std::move(x.m_var_map_short_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortULongLong& x) const
    {
        return (m_var_map_short_ulonglong == x.m_var_map_short_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_ulonglong
     * @param _var_map_short_ulonglong New value to be copied in member var_map_short_ulonglong
     */
    eProsima_user_DllExport void var_map_short_ulonglong(
            const std::map<int16_t, uint64_t>& _var_map_short_ulonglong)
    {
        m_var_map_short_ulonglong = _var_map_short_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_short_ulonglong
     * @param _var_map_short_ulonglong New value to be moved in member var_map_short_ulonglong
     */
    eProsima_user_DllExport void var_map_short_ulonglong(
            std::map<int16_t, uint64_t>&& _var_map_short_ulonglong)
    {
        m_var_map_short_ulonglong = std::move(_var_map_short_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_ulonglong
     * @return Constant reference to member var_map_short_ulonglong
     */
    eProsima_user_DllExport const std::map<int16_t, uint64_t>& var_map_short_ulonglong() const
    {
        return m_var_map_short_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_ulonglong
     * @return Reference to member var_map_short_ulonglong
     */
    eProsima_user_DllExport std::map<int16_t, uint64_t>& var_map_short_ulonglong()
    {
        return m_var_map_short_ulonglong;
    }



private:

    std::map<int16_t, uint64_t> m_var_map_short_ulonglong;

};
/*!
 * @brief This class represents the structure MapShortFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortFloat that will be copied.
     */
    eProsima_user_DllExport MapShortFloat(
            const MapShortFloat& x)
    {
                    m_var_map_short_float = x.m_var_map_short_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortFloat that will be copied.
     */
    eProsima_user_DllExport MapShortFloat(
            MapShortFloat&& x) noexcept
    {
        m_var_map_short_float = std::move(x.m_var_map_short_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortFloat that will be copied.
     */
    eProsima_user_DllExport MapShortFloat& operator =(
            const MapShortFloat& x)
    {

                    m_var_map_short_float = x.m_var_map_short_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortFloat that will be copied.
     */
    eProsima_user_DllExport MapShortFloat& operator =(
            MapShortFloat&& x) noexcept
    {

        m_var_map_short_float = std::move(x.m_var_map_short_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortFloat& x) const
    {
        return (m_var_map_short_float == x.m_var_map_short_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_float
     * @param _var_map_short_float New value to be copied in member var_map_short_float
     */
    eProsima_user_DllExport void var_map_short_float(
            const std::map<int16_t, float>& _var_map_short_float)
    {
        m_var_map_short_float = _var_map_short_float;
    }

    /*!
     * @brief This function moves the value in member var_map_short_float
     * @param _var_map_short_float New value to be moved in member var_map_short_float
     */
    eProsima_user_DllExport void var_map_short_float(
            std::map<int16_t, float>&& _var_map_short_float)
    {
        m_var_map_short_float = std::move(_var_map_short_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_float
     * @return Constant reference to member var_map_short_float
     */
    eProsima_user_DllExport const std::map<int16_t, float>& var_map_short_float() const
    {
        return m_var_map_short_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_float
     * @return Reference to member var_map_short_float
     */
    eProsima_user_DllExport std::map<int16_t, float>& var_map_short_float()
    {
        return m_var_map_short_float;
    }



private:

    std::map<int16_t, float> m_var_map_short_float;

};
/*!
 * @brief This class represents the structure MapShortDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortDouble that will be copied.
     */
    eProsima_user_DllExport MapShortDouble(
            const MapShortDouble& x)
    {
                    m_var_map_short_double = x.m_var_map_short_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortDouble that will be copied.
     */
    eProsima_user_DllExport MapShortDouble(
            MapShortDouble&& x) noexcept
    {
        m_var_map_short_double = std::move(x.m_var_map_short_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortDouble that will be copied.
     */
    eProsima_user_DllExport MapShortDouble& operator =(
            const MapShortDouble& x)
    {

                    m_var_map_short_double = x.m_var_map_short_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortDouble that will be copied.
     */
    eProsima_user_DllExport MapShortDouble& operator =(
            MapShortDouble&& x) noexcept
    {

        m_var_map_short_double = std::move(x.m_var_map_short_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortDouble& x) const
    {
        return (m_var_map_short_double == x.m_var_map_short_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_double
     * @param _var_map_short_double New value to be copied in member var_map_short_double
     */
    eProsima_user_DllExport void var_map_short_double(
            const std::map<int16_t, double>& _var_map_short_double)
    {
        m_var_map_short_double = _var_map_short_double;
    }

    /*!
     * @brief This function moves the value in member var_map_short_double
     * @param _var_map_short_double New value to be moved in member var_map_short_double
     */
    eProsima_user_DllExport void var_map_short_double(
            std::map<int16_t, double>&& _var_map_short_double)
    {
        m_var_map_short_double = std::move(_var_map_short_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_double
     * @return Constant reference to member var_map_short_double
     */
    eProsima_user_DllExport const std::map<int16_t, double>& var_map_short_double() const
    {
        return m_var_map_short_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_double
     * @return Reference to member var_map_short_double
     */
    eProsima_user_DllExport std::map<int16_t, double>& var_map_short_double()
    {
        return m_var_map_short_double;
    }



private:

    std::map<int16_t, double> m_var_map_short_double;

};
/*!
 * @brief This class represents the structure MapShortLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapShortLongDouble(
            const MapShortLongDouble& x)
    {
                    m_var_map_short_longdouble = x.m_var_map_short_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapShortLongDouble(
            MapShortLongDouble&& x) noexcept
    {
        m_var_map_short_longdouble = std::move(x.m_var_map_short_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapShortLongDouble& operator =(
            const MapShortLongDouble& x)
    {

                    m_var_map_short_longdouble = x.m_var_map_short_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapShortLongDouble& operator =(
            MapShortLongDouble&& x) noexcept
    {

        m_var_map_short_longdouble = std::move(x.m_var_map_short_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortLongDouble& x) const
    {
        return (m_var_map_short_longdouble == x.m_var_map_short_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_longdouble
     * @param _var_map_short_longdouble New value to be copied in member var_map_short_longdouble
     */
    eProsima_user_DllExport void var_map_short_longdouble(
            const std::map<int16_t, long double>& _var_map_short_longdouble)
    {
        m_var_map_short_longdouble = _var_map_short_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_short_longdouble
     * @param _var_map_short_longdouble New value to be moved in member var_map_short_longdouble
     */
    eProsima_user_DllExport void var_map_short_longdouble(
            std::map<int16_t, long double>&& _var_map_short_longdouble)
    {
        m_var_map_short_longdouble = std::move(_var_map_short_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_longdouble
     * @return Constant reference to member var_map_short_longdouble
     */
    eProsima_user_DllExport const std::map<int16_t, long double>& var_map_short_longdouble() const
    {
        return m_var_map_short_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_longdouble
     * @return Reference to member var_map_short_longdouble
     */
    eProsima_user_DllExport std::map<int16_t, long double>& var_map_short_longdouble()
    {
        return m_var_map_short_longdouble;
    }



private:

    std::map<int16_t, long double> m_var_map_short_longdouble;

};
/*!
 * @brief This class represents the structure MapShortBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapShortBoolean(
            const MapShortBoolean& x)
    {
                    m_var_map_short_boolean = x.m_var_map_short_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapShortBoolean(
            MapShortBoolean&& x) noexcept
    {
        m_var_map_short_boolean = std::move(x.m_var_map_short_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapShortBoolean& operator =(
            const MapShortBoolean& x)
    {

                    m_var_map_short_boolean = x.m_var_map_short_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapShortBoolean& operator =(
            MapShortBoolean&& x) noexcept
    {

        m_var_map_short_boolean = std::move(x.m_var_map_short_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortBoolean& x) const
    {
        return (m_var_map_short_boolean == x.m_var_map_short_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_boolean
     * @param _var_map_short_boolean New value to be copied in member var_map_short_boolean
     */
    eProsima_user_DllExport void var_map_short_boolean(
            const std::map<int16_t, bool>& _var_map_short_boolean)
    {
        m_var_map_short_boolean = _var_map_short_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_short_boolean
     * @param _var_map_short_boolean New value to be moved in member var_map_short_boolean
     */
    eProsima_user_DllExport void var_map_short_boolean(
            std::map<int16_t, bool>&& _var_map_short_boolean)
    {
        m_var_map_short_boolean = std::move(_var_map_short_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_boolean
     * @return Constant reference to member var_map_short_boolean
     */
    eProsima_user_DllExport const std::map<int16_t, bool>& var_map_short_boolean() const
    {
        return m_var_map_short_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_boolean
     * @return Reference to member var_map_short_boolean
     */
    eProsima_user_DllExport std::map<int16_t, bool>& var_map_short_boolean()
    {
        return m_var_map_short_boolean;
    }



private:

    std::map<int16_t, bool> m_var_map_short_boolean;

};
/*!
 * @brief This class represents the structure MapShortOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortOctet that will be copied.
     */
    eProsima_user_DllExport MapShortOctet(
            const MapShortOctet& x)
    {
                    m_var_map_short_octet = x.m_var_map_short_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortOctet that will be copied.
     */
    eProsima_user_DllExport MapShortOctet(
            MapShortOctet&& x) noexcept
    {
        m_var_map_short_octet = std::move(x.m_var_map_short_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortOctet that will be copied.
     */
    eProsima_user_DllExport MapShortOctet& operator =(
            const MapShortOctet& x)
    {

                    m_var_map_short_octet = x.m_var_map_short_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortOctet that will be copied.
     */
    eProsima_user_DllExport MapShortOctet& operator =(
            MapShortOctet&& x) noexcept
    {

        m_var_map_short_octet = std::move(x.m_var_map_short_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortOctet& x) const
    {
        return (m_var_map_short_octet == x.m_var_map_short_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_octet
     * @param _var_map_short_octet New value to be copied in member var_map_short_octet
     */
    eProsima_user_DllExport void var_map_short_octet(
            const std::map<int16_t, uint8_t>& _var_map_short_octet)
    {
        m_var_map_short_octet = _var_map_short_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_short_octet
     * @param _var_map_short_octet New value to be moved in member var_map_short_octet
     */
    eProsima_user_DllExport void var_map_short_octet(
            std::map<int16_t, uint8_t>&& _var_map_short_octet)
    {
        m_var_map_short_octet = std::move(_var_map_short_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_octet
     * @return Constant reference to member var_map_short_octet
     */
    eProsima_user_DllExport const std::map<int16_t, uint8_t>& var_map_short_octet() const
    {
        return m_var_map_short_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_octet
     * @return Reference to member var_map_short_octet
     */
    eProsima_user_DllExport std::map<int16_t, uint8_t>& var_map_short_octet()
    {
        return m_var_map_short_octet;
    }



private:

    std::map<int16_t, uint8_t> m_var_map_short_octet;

};
/*!
 * @brief This class represents the structure MapShortChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortChar that will be copied.
     */
    eProsima_user_DllExport MapShortChar(
            const MapShortChar& x)
    {
                    m_var_map_short_char = x.m_var_map_short_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortChar that will be copied.
     */
    eProsima_user_DllExport MapShortChar(
            MapShortChar&& x) noexcept
    {
        m_var_map_short_char = std::move(x.m_var_map_short_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortChar that will be copied.
     */
    eProsima_user_DllExport MapShortChar& operator =(
            const MapShortChar& x)
    {

                    m_var_map_short_char = x.m_var_map_short_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortChar that will be copied.
     */
    eProsima_user_DllExport MapShortChar& operator =(
            MapShortChar&& x) noexcept
    {

        m_var_map_short_char = std::move(x.m_var_map_short_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortChar& x) const
    {
        return (m_var_map_short_char == x.m_var_map_short_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_char
     * @param _var_map_short_char New value to be copied in member var_map_short_char
     */
    eProsima_user_DllExport void var_map_short_char(
            const std::map<int16_t, char>& _var_map_short_char)
    {
        m_var_map_short_char = _var_map_short_char;
    }

    /*!
     * @brief This function moves the value in member var_map_short_char
     * @param _var_map_short_char New value to be moved in member var_map_short_char
     */
    eProsima_user_DllExport void var_map_short_char(
            std::map<int16_t, char>&& _var_map_short_char)
    {
        m_var_map_short_char = std::move(_var_map_short_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_char
     * @return Constant reference to member var_map_short_char
     */
    eProsima_user_DllExport const std::map<int16_t, char>& var_map_short_char() const
    {
        return m_var_map_short_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_char
     * @return Reference to member var_map_short_char
     */
    eProsima_user_DllExport std::map<int16_t, char>& var_map_short_char()
    {
        return m_var_map_short_char;
    }



private:

    std::map<int16_t, char> m_var_map_short_char;

};
/*!
 * @brief This class represents the structure MapShortWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortWChar that will be copied.
     */
    eProsima_user_DllExport MapShortWChar(
            const MapShortWChar& x)
    {
                    m_var_map_short_wchar = x.m_var_map_short_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortWChar that will be copied.
     */
    eProsima_user_DllExport MapShortWChar(
            MapShortWChar&& x) noexcept
    {
        m_var_map_short_wchar = std::move(x.m_var_map_short_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortWChar that will be copied.
     */
    eProsima_user_DllExport MapShortWChar& operator =(
            const MapShortWChar& x)
    {

                    m_var_map_short_wchar = x.m_var_map_short_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortWChar that will be copied.
     */
    eProsima_user_DllExport MapShortWChar& operator =(
            MapShortWChar&& x) noexcept
    {

        m_var_map_short_wchar = std::move(x.m_var_map_short_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortWChar& x) const
    {
        return (m_var_map_short_wchar == x.m_var_map_short_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_wchar
     * @param _var_map_short_wchar New value to be copied in member var_map_short_wchar
     */
    eProsima_user_DllExport void var_map_short_wchar(
            const std::map<int16_t, wchar_t>& _var_map_short_wchar)
    {
        m_var_map_short_wchar = _var_map_short_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_short_wchar
     * @param _var_map_short_wchar New value to be moved in member var_map_short_wchar
     */
    eProsima_user_DllExport void var_map_short_wchar(
            std::map<int16_t, wchar_t>&& _var_map_short_wchar)
    {
        m_var_map_short_wchar = std::move(_var_map_short_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_wchar
     * @return Constant reference to member var_map_short_wchar
     */
    eProsima_user_DllExport const std::map<int16_t, wchar_t>& var_map_short_wchar() const
    {
        return m_var_map_short_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_wchar
     * @return Reference to member var_map_short_wchar
     */
    eProsima_user_DllExport std::map<int16_t, wchar_t>& var_map_short_wchar()
    {
        return m_var_map_short_wchar;
    }



private:

    std::map<int16_t, wchar_t> m_var_map_short_wchar;

};
/*!
 * @brief This class represents the structure MapShortString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortString that will be copied.
     */
    eProsima_user_DllExport MapShortString(
            const MapShortString& x)
    {
                    m_var_map_short_string = x.m_var_map_short_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortString that will be copied.
     */
    eProsima_user_DllExport MapShortString(
            MapShortString&& x) noexcept
    {
        m_var_map_short_string = std::move(x.m_var_map_short_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortString that will be copied.
     */
    eProsima_user_DllExport MapShortString& operator =(
            const MapShortString& x)
    {

                    m_var_map_short_string = x.m_var_map_short_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortString that will be copied.
     */
    eProsima_user_DllExport MapShortString& operator =(
            MapShortString&& x) noexcept
    {

        m_var_map_short_string = std::move(x.m_var_map_short_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortString& x) const
    {
        return (m_var_map_short_string == x.m_var_map_short_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_string
     * @param _var_map_short_string New value to be copied in member var_map_short_string
     */
    eProsima_user_DllExport void var_map_short_string(
            const std::map<int16_t, std::string>& _var_map_short_string)
    {
        m_var_map_short_string = _var_map_short_string;
    }

    /*!
     * @brief This function moves the value in member var_map_short_string
     * @param _var_map_short_string New value to be moved in member var_map_short_string
     */
    eProsima_user_DllExport void var_map_short_string(
            std::map<int16_t, std::string>&& _var_map_short_string)
    {
        m_var_map_short_string = std::move(_var_map_short_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_string
     * @return Constant reference to member var_map_short_string
     */
    eProsima_user_DllExport const std::map<int16_t, std::string>& var_map_short_string() const
    {
        return m_var_map_short_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_string
     * @return Reference to member var_map_short_string
     */
    eProsima_user_DllExport std::map<int16_t, std::string>& var_map_short_string()
    {
        return m_var_map_short_string;
    }



private:

    std::map<int16_t, std::string> m_var_map_short_string;

};
/*!
 * @brief This class represents the structure MapShortWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortWString that will be copied.
     */
    eProsima_user_DllExport MapShortWString(
            const MapShortWString& x)
    {
                    m_var_map_short_wstring = x.m_var_map_short_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortWString that will be copied.
     */
    eProsima_user_DllExport MapShortWString(
            MapShortWString&& x) noexcept
    {
        m_var_map_short_wstring = std::move(x.m_var_map_short_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortWString that will be copied.
     */
    eProsima_user_DllExport MapShortWString& operator =(
            const MapShortWString& x)
    {

                    m_var_map_short_wstring = x.m_var_map_short_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortWString that will be copied.
     */
    eProsima_user_DllExport MapShortWString& operator =(
            MapShortWString&& x) noexcept
    {

        m_var_map_short_wstring = std::move(x.m_var_map_short_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortWString& x) const
    {
        return (m_var_map_short_wstring == x.m_var_map_short_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_wstring
     * @param _var_map_short_wstring New value to be copied in member var_map_short_wstring
     */
    eProsima_user_DllExport void var_map_short_wstring(
            const std::map<int16_t, std::wstring>& _var_map_short_wstring)
    {
        m_var_map_short_wstring = _var_map_short_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_short_wstring
     * @param _var_map_short_wstring New value to be moved in member var_map_short_wstring
     */
    eProsima_user_DllExport void var_map_short_wstring(
            std::map<int16_t, std::wstring>&& _var_map_short_wstring)
    {
        m_var_map_short_wstring = std::move(_var_map_short_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_wstring
     * @return Constant reference to member var_map_short_wstring
     */
    eProsima_user_DllExport const std::map<int16_t, std::wstring>& var_map_short_wstring() const
    {
        return m_var_map_short_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_wstring
     * @return Reference to member var_map_short_wstring
     */
    eProsima_user_DllExport std::map<int16_t, std::wstring>& var_map_short_wstring()
    {
        return m_var_map_short_wstring;
    }



private:

    std::map<int16_t, std::wstring> m_var_map_short_wstring;

};
/*!
 * @brief This class represents the structure MapShortInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedStringHelper(
            const MapShortInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_short_inneraliasboundedstringhelper = x.m_var_map_short_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedStringHelper(
            MapShortInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_short_inneraliasboundedstringhelper = std::move(x.m_var_map_short_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedStringHelper& operator =(
            const MapShortInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_short_inneraliasboundedstringhelper = x.m_var_map_short_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedStringHelper& operator =(
            MapShortInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_short_inneraliasboundedstringhelper = std::move(x.m_var_map_short_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_short_inneraliasboundedstringhelper == x.m_var_map_short_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_inneraliasboundedstringhelper
     * @param _var_map_short_inneraliasboundedstringhelper New value to be copied in member var_map_short_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasboundedstringhelper(
            const std::map<int16_t, Inner_alias_bounded_string_helper>& _var_map_short_inneraliasboundedstringhelper)
    {
        m_var_map_short_inneraliasboundedstringhelper = _var_map_short_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_inneraliasboundedstringhelper
     * @param _var_map_short_inneraliasboundedstringhelper New value to be moved in member var_map_short_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasboundedstringhelper(
            std::map<int16_t, Inner_alias_bounded_string_helper>&& _var_map_short_inneraliasboundedstringhelper)
    {
        m_var_map_short_inneraliasboundedstringhelper = std::move(_var_map_short_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_short_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<int16_t, Inner_alias_bounded_string_helper>& var_map_short_inneraliasboundedstringhelper() const
    {
        return m_var_map_short_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_inneraliasboundedstringhelper
     * @return Reference to member var_map_short_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<int16_t, Inner_alias_bounded_string_helper>& var_map_short_inneraliasboundedstringhelper()
    {
        return m_var_map_short_inneraliasboundedstringhelper;
    }



private:

    std::map<int16_t, Inner_alias_bounded_string_helper> m_var_map_short_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapShortInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedWStringHelper(
            const MapShortInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_short_inneraliasboundedwstringhelper = x.m_var_map_short_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedWStringHelper(
            MapShortInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_short_inneraliasboundedwstringhelper = std::move(x.m_var_map_short_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedWStringHelper& operator =(
            const MapShortInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_short_inneraliasboundedwstringhelper = x.m_var_map_short_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasBoundedWStringHelper& operator =(
            MapShortInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_short_inneraliasboundedwstringhelper = std::move(x.m_var_map_short_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_short_inneraliasboundedwstringhelper == x.m_var_map_short_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_inneraliasboundedwstringhelper
     * @param _var_map_short_inneraliasboundedwstringhelper New value to be copied in member var_map_short_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasboundedwstringhelper(
            const std::map<int16_t, Inner_alias_bounded_wstring_helper>& _var_map_short_inneraliasboundedwstringhelper)
    {
        m_var_map_short_inneraliasboundedwstringhelper = _var_map_short_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_inneraliasboundedwstringhelper
     * @param _var_map_short_inneraliasboundedwstringhelper New value to be moved in member var_map_short_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasboundedwstringhelper(
            std::map<int16_t, Inner_alias_bounded_wstring_helper>&& _var_map_short_inneraliasboundedwstringhelper)
    {
        m_var_map_short_inneraliasboundedwstringhelper = std::move(_var_map_short_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_short_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<int16_t, Inner_alias_bounded_wstring_helper>& var_map_short_inneraliasboundedwstringhelper() const
    {
        return m_var_map_short_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_inneraliasboundedwstringhelper
     * @return Reference to member var_map_short_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<int16_t, Inner_alias_bounded_wstring_helper>& var_map_short_inneraliasboundedwstringhelper()
    {
        return m_var_map_short_inneraliasboundedwstringhelper;
    }



private:

    std::map<int16_t, Inner_alias_bounded_wstring_helper> m_var_map_short_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapShortInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerEnumHelper(
            const MapShortInnerEnumHelper& x)
    {
                    m_var_map_short_innerenumhelper = x.m_var_map_short_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerEnumHelper(
            MapShortInnerEnumHelper&& x) noexcept
    {
        m_var_map_short_innerenumhelper = std::move(x.m_var_map_short_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerEnumHelper& operator =(
            const MapShortInnerEnumHelper& x)
    {

                    m_var_map_short_innerenumhelper = x.m_var_map_short_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerEnumHelper& operator =(
            MapShortInnerEnumHelper&& x) noexcept
    {

        m_var_map_short_innerenumhelper = std::move(x.m_var_map_short_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerEnumHelper& x) const
    {
        return (m_var_map_short_innerenumhelper == x.m_var_map_short_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_innerenumhelper
     * @param _var_map_short_innerenumhelper New value to be copied in member var_map_short_innerenumhelper
     */
    eProsima_user_DllExport void var_map_short_innerenumhelper(
            const std::map<int16_t, InnerEnumHelper>& _var_map_short_innerenumhelper)
    {
        m_var_map_short_innerenumhelper = _var_map_short_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_innerenumhelper
     * @param _var_map_short_innerenumhelper New value to be moved in member var_map_short_innerenumhelper
     */
    eProsima_user_DllExport void var_map_short_innerenumhelper(
            std::map<int16_t, InnerEnumHelper>&& _var_map_short_innerenumhelper)
    {
        m_var_map_short_innerenumhelper = std::move(_var_map_short_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_innerenumhelper
     * @return Constant reference to member var_map_short_innerenumhelper
     */
    eProsima_user_DllExport const std::map<int16_t, InnerEnumHelper>& var_map_short_innerenumhelper() const
    {
        return m_var_map_short_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_innerenumhelper
     * @return Reference to member var_map_short_innerenumhelper
     */
    eProsima_user_DllExport std::map<int16_t, InnerEnumHelper>& var_map_short_innerenumhelper()
    {
        return m_var_map_short_innerenumhelper;
    }



private:

    std::map<int16_t, InnerEnumHelper> m_var_map_short_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapShortInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitMaskHelper(
            const MapShortInnerBitMaskHelper& x)
    {
                    m_var_map_short_innerbitmaskhelper = x.m_var_map_short_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitMaskHelper(
            MapShortInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_short_innerbitmaskhelper = std::move(x.m_var_map_short_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitMaskHelper& operator =(
            const MapShortInnerBitMaskHelper& x)
    {

                    m_var_map_short_innerbitmaskhelper = x.m_var_map_short_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitMaskHelper& operator =(
            MapShortInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_short_innerbitmaskhelper = std::move(x.m_var_map_short_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerBitMaskHelper& x) const
    {
        return (m_var_map_short_innerbitmaskhelper == x.m_var_map_short_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_innerbitmaskhelper
     * @param _var_map_short_innerbitmaskhelper New value to be copied in member var_map_short_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_short_innerbitmaskhelper(
            const std::map<int16_t, InnerBitMaskHelper>& _var_map_short_innerbitmaskhelper)
    {
        m_var_map_short_innerbitmaskhelper = _var_map_short_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_innerbitmaskhelper
     * @param _var_map_short_innerbitmaskhelper New value to be moved in member var_map_short_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_short_innerbitmaskhelper(
            std::map<int16_t, InnerBitMaskHelper>&& _var_map_short_innerbitmaskhelper)
    {
        m_var_map_short_innerbitmaskhelper = std::move(_var_map_short_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_innerbitmaskhelper
     * @return Constant reference to member var_map_short_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<int16_t, InnerBitMaskHelper>& var_map_short_innerbitmaskhelper() const
    {
        return m_var_map_short_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_innerbitmaskhelper
     * @return Reference to member var_map_short_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<int16_t, InnerBitMaskHelper>& var_map_short_innerbitmaskhelper()
    {
        return m_var_map_short_innerbitmaskhelper;
    }



private:

    std::map<int16_t, InnerBitMaskHelper> m_var_map_short_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapShortInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasHelper(
            const MapShortInnerAliasHelper& x)
    {
                    m_var_map_short_inneraliashelper = x.m_var_map_short_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasHelper(
            MapShortInnerAliasHelper&& x) noexcept
    {
        m_var_map_short_inneraliashelper = std::move(x.m_var_map_short_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasHelper& operator =(
            const MapShortInnerAliasHelper& x)
    {

                    m_var_map_short_inneraliashelper = x.m_var_map_short_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasHelper& operator =(
            MapShortInnerAliasHelper&& x) noexcept
    {

        m_var_map_short_inneraliashelper = std::move(x.m_var_map_short_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerAliasHelper& x) const
    {
        return (m_var_map_short_inneraliashelper == x.m_var_map_short_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_inneraliashelper
     * @param _var_map_short_inneraliashelper New value to be copied in member var_map_short_inneraliashelper
     */
    eProsima_user_DllExport void var_map_short_inneraliashelper(
            const std::map<int16_t, InnerAliasHelper>& _var_map_short_inneraliashelper)
    {
        m_var_map_short_inneraliashelper = _var_map_short_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_inneraliashelper
     * @param _var_map_short_inneraliashelper New value to be moved in member var_map_short_inneraliashelper
     */
    eProsima_user_DllExport void var_map_short_inneraliashelper(
            std::map<int16_t, InnerAliasHelper>&& _var_map_short_inneraliashelper)
    {
        m_var_map_short_inneraliashelper = std::move(_var_map_short_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_inneraliashelper
     * @return Constant reference to member var_map_short_inneraliashelper
     */
    eProsima_user_DllExport const std::map<int16_t, InnerAliasHelper>& var_map_short_inneraliashelper() const
    {
        return m_var_map_short_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_inneraliashelper
     * @return Reference to member var_map_short_inneraliashelper
     */
    eProsima_user_DllExport std::map<int16_t, InnerAliasHelper>& var_map_short_inneraliashelper()
    {
        return m_var_map_short_inneraliashelper;
    }



private:

    std::map<int16_t, InnerAliasHelper> m_var_map_short_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapShortInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasArrayHelper(
            const MapShortInnerAliasArrayHelper& x)
    {
                    m_var_map_short_inneraliasarrayhelper = x.m_var_map_short_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasArrayHelper(
            MapShortInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_short_inneraliasarrayhelper = std::move(x.m_var_map_short_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasArrayHelper& operator =(
            const MapShortInnerAliasArrayHelper& x)
    {

                    m_var_map_short_inneraliasarrayhelper = x.m_var_map_short_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasArrayHelper& operator =(
            MapShortInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_short_inneraliasarrayhelper = std::move(x.m_var_map_short_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerAliasArrayHelper& x) const
    {
        return (m_var_map_short_inneraliasarrayhelper == x.m_var_map_short_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_inneraliasarrayhelper
     * @param _var_map_short_inneraliasarrayhelper New value to be copied in member var_map_short_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasarrayhelper(
            const std::map<int16_t, Inner_alias_array_helper>& _var_map_short_inneraliasarrayhelper)
    {
        m_var_map_short_inneraliasarrayhelper = _var_map_short_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_inneraliasarrayhelper
     * @param _var_map_short_inneraliasarrayhelper New value to be moved in member var_map_short_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasarrayhelper(
            std::map<int16_t, Inner_alias_array_helper>&& _var_map_short_inneraliasarrayhelper)
    {
        m_var_map_short_inneraliasarrayhelper = std::move(_var_map_short_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_inneraliasarrayhelper
     * @return Constant reference to member var_map_short_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<int16_t, Inner_alias_array_helper>& var_map_short_inneraliasarrayhelper() const
    {
        return m_var_map_short_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_inneraliasarrayhelper
     * @return Reference to member var_map_short_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<int16_t, Inner_alias_array_helper>& var_map_short_inneraliasarrayhelper()
    {
        return m_var_map_short_inneraliasarrayhelper;
    }



private:

    std::map<int16_t, Inner_alias_array_helper> m_var_map_short_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapShortInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasSequenceHelper(
            const MapShortInnerAliasSequenceHelper& x)
    {
                    m_var_map_short_inneraliassequencehelper = x.m_var_map_short_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasSequenceHelper(
            MapShortInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_short_inneraliassequencehelper = std::move(x.m_var_map_short_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasSequenceHelper& operator =(
            const MapShortInnerAliasSequenceHelper& x)
    {

                    m_var_map_short_inneraliassequencehelper = x.m_var_map_short_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasSequenceHelper& operator =(
            MapShortInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_short_inneraliassequencehelper = std::move(x.m_var_map_short_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_short_inneraliassequencehelper == x.m_var_map_short_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_inneraliassequencehelper
     * @param _var_map_short_inneraliassequencehelper New value to be copied in member var_map_short_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_short_inneraliassequencehelper(
            const std::map<int16_t, Inner_alias_sequence_helper>& _var_map_short_inneraliassequencehelper)
    {
        m_var_map_short_inneraliassequencehelper = _var_map_short_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_inneraliassequencehelper
     * @param _var_map_short_inneraliassequencehelper New value to be moved in member var_map_short_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_short_inneraliassequencehelper(
            std::map<int16_t, Inner_alias_sequence_helper>&& _var_map_short_inneraliassequencehelper)
    {
        m_var_map_short_inneraliassequencehelper = std::move(_var_map_short_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_inneraliassequencehelper
     * @return Constant reference to member var_map_short_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<int16_t, Inner_alias_sequence_helper>& var_map_short_inneraliassequencehelper() const
    {
        return m_var_map_short_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_inneraliassequencehelper
     * @return Reference to member var_map_short_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<int16_t, Inner_alias_sequence_helper>& var_map_short_inneraliassequencehelper()
    {
        return m_var_map_short_inneraliassequencehelper;
    }



private:

    std::map<int16_t, Inner_alias_sequence_helper> m_var_map_short_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapShortInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasMapHelper(
            const MapShortInnerAliasMapHelper& x)
    {
                    m_var_map_short_inneraliasmaphelper = x.m_var_map_short_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasMapHelper(
            MapShortInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_short_inneraliasmaphelper = std::move(x.m_var_map_short_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasMapHelper& operator =(
            const MapShortInnerAliasMapHelper& x)
    {

                    m_var_map_short_inneraliasmaphelper = x.m_var_map_short_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerAliasMapHelper& operator =(
            MapShortInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_short_inneraliasmaphelper = std::move(x.m_var_map_short_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerAliasMapHelper& x) const
    {
        return (m_var_map_short_inneraliasmaphelper == x.m_var_map_short_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_inneraliasmaphelper
     * @param _var_map_short_inneraliasmaphelper New value to be copied in member var_map_short_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasmaphelper(
            const std::map<int16_t, Inner_alias_map_helper>& _var_map_short_inneraliasmaphelper)
    {
        m_var_map_short_inneraliasmaphelper = _var_map_short_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_inneraliasmaphelper
     * @param _var_map_short_inneraliasmaphelper New value to be moved in member var_map_short_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_short_inneraliasmaphelper(
            std::map<int16_t, Inner_alias_map_helper>&& _var_map_short_inneraliasmaphelper)
    {
        m_var_map_short_inneraliasmaphelper = std::move(_var_map_short_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_inneraliasmaphelper
     * @return Constant reference to member var_map_short_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<int16_t, Inner_alias_map_helper>& var_map_short_inneraliasmaphelper() const
    {
        return m_var_map_short_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_inneraliasmaphelper
     * @return Reference to member var_map_short_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<int16_t, Inner_alias_map_helper>& var_map_short_inneraliasmaphelper()
    {
        return m_var_map_short_inneraliasmaphelper;
    }



private:

    std::map<int16_t, Inner_alias_map_helper> m_var_map_short_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapShortInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerUnionHelper(
            const MapShortInnerUnionHelper& x)
    {
                    m_var_map_short_innerunionhelper = x.m_var_map_short_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerUnionHelper(
            MapShortInnerUnionHelper&& x) noexcept
    {
        m_var_map_short_innerunionhelper = std::move(x.m_var_map_short_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerUnionHelper& operator =(
            const MapShortInnerUnionHelper& x)
    {

                    m_var_map_short_innerunionhelper = x.m_var_map_short_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerUnionHelper& operator =(
            MapShortInnerUnionHelper&& x) noexcept
    {

        m_var_map_short_innerunionhelper = std::move(x.m_var_map_short_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerUnionHelper& x) const
    {
        return (m_var_map_short_innerunionhelper == x.m_var_map_short_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_innerunionhelper
     * @param _var_map_short_innerunionhelper New value to be copied in member var_map_short_innerunionhelper
     */
    eProsima_user_DllExport void var_map_short_innerunionhelper(
            const std::map<int16_t, InnerUnionHelper>& _var_map_short_innerunionhelper)
    {
        m_var_map_short_innerunionhelper = _var_map_short_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_innerunionhelper
     * @param _var_map_short_innerunionhelper New value to be moved in member var_map_short_innerunionhelper
     */
    eProsima_user_DllExport void var_map_short_innerunionhelper(
            std::map<int16_t, InnerUnionHelper>&& _var_map_short_innerunionhelper)
    {
        m_var_map_short_innerunionhelper = std::move(_var_map_short_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_innerunionhelper
     * @return Constant reference to member var_map_short_innerunionhelper
     */
    eProsima_user_DllExport const std::map<int16_t, InnerUnionHelper>& var_map_short_innerunionhelper() const
    {
        return m_var_map_short_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_innerunionhelper
     * @return Reference to member var_map_short_innerunionhelper
     */
    eProsima_user_DllExport std::map<int16_t, InnerUnionHelper>& var_map_short_innerunionhelper()
    {
        return m_var_map_short_innerunionhelper;
    }



private:

    std::map<int16_t, InnerUnionHelper> m_var_map_short_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapShortInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerStructureHelper(
            const MapShortInnerStructureHelper& x)
    {
                    m_var_map_short_innerstructurehelper = x.m_var_map_short_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerStructureHelper(
            MapShortInnerStructureHelper&& x) noexcept
    {
        m_var_map_short_innerstructurehelper = std::move(x.m_var_map_short_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerStructureHelper& operator =(
            const MapShortInnerStructureHelper& x)
    {

                    m_var_map_short_innerstructurehelper = x.m_var_map_short_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerStructureHelper& operator =(
            MapShortInnerStructureHelper&& x) noexcept
    {

        m_var_map_short_innerstructurehelper = std::move(x.m_var_map_short_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerStructureHelper& x) const
    {
        return (m_var_map_short_innerstructurehelper == x.m_var_map_short_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_innerstructurehelper
     * @param _var_map_short_innerstructurehelper New value to be copied in member var_map_short_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_short_innerstructurehelper(
            const std::map<int16_t, InnerStructureHelper>& _var_map_short_innerstructurehelper)
    {
        m_var_map_short_innerstructurehelper = _var_map_short_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_innerstructurehelper
     * @param _var_map_short_innerstructurehelper New value to be moved in member var_map_short_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_short_innerstructurehelper(
            std::map<int16_t, InnerStructureHelper>&& _var_map_short_innerstructurehelper)
    {
        m_var_map_short_innerstructurehelper = std::move(_var_map_short_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_innerstructurehelper
     * @return Constant reference to member var_map_short_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<int16_t, InnerStructureHelper>& var_map_short_innerstructurehelper() const
    {
        return m_var_map_short_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_innerstructurehelper
     * @return Reference to member var_map_short_innerstructurehelper
     */
    eProsima_user_DllExport std::map<int16_t, InnerStructureHelper>& var_map_short_innerstructurehelper()
    {
        return m_var_map_short_innerstructurehelper;
    }



private:

    std::map<int16_t, InnerStructureHelper> m_var_map_short_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapShortInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapShortInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapShortInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapShortInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitsetHelper(
            const MapShortInnerBitsetHelper& x)
    {
                    m_var_map_short_innerbitsethelper = x.m_var_map_short_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitsetHelper(
            MapShortInnerBitsetHelper&& x) noexcept
    {
        m_var_map_short_innerbitsethelper = std::move(x.m_var_map_short_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitsetHelper& operator =(
            const MapShortInnerBitsetHelper& x)
    {

                    m_var_map_short_innerbitsethelper = x.m_var_map_short_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapShortInnerBitsetHelper& operator =(
            MapShortInnerBitsetHelper&& x) noexcept
    {

        m_var_map_short_innerbitsethelper = std::move(x.m_var_map_short_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapShortInnerBitsetHelper& x) const
    {
        return (m_var_map_short_innerbitsethelper == x.m_var_map_short_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapShortInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapShortInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_short_innerbitsethelper
     * @param _var_map_short_innerbitsethelper New value to be copied in member var_map_short_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_short_innerbitsethelper(
            const std::map<int16_t, InnerBitsetHelper>& _var_map_short_innerbitsethelper)
    {
        m_var_map_short_innerbitsethelper = _var_map_short_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_short_innerbitsethelper
     * @param _var_map_short_innerbitsethelper New value to be moved in member var_map_short_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_short_innerbitsethelper(
            std::map<int16_t, InnerBitsetHelper>&& _var_map_short_innerbitsethelper)
    {
        m_var_map_short_innerbitsethelper = std::move(_var_map_short_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_short_innerbitsethelper
     * @return Constant reference to member var_map_short_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<int16_t, InnerBitsetHelper>& var_map_short_innerbitsethelper() const
    {
        return m_var_map_short_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_short_innerbitsethelper
     * @return Reference to member var_map_short_innerbitsethelper
     */
    eProsima_user_DllExport std::map<int16_t, InnerBitsetHelper>& var_map_short_innerbitsethelper()
    {
        return m_var_map_short_innerbitsethelper;
    }



private:

    std::map<int16_t, InnerBitsetHelper> m_var_map_short_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapUShortShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortShort that will be copied.
     */
    eProsima_user_DllExport MapUShortShort(
            const MapUShortShort& x)
    {
                    m_var_map_ushort_short = x.m_var_map_ushort_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortShort that will be copied.
     */
    eProsima_user_DllExport MapUShortShort(
            MapUShortShort&& x) noexcept
    {
        m_var_map_ushort_short = std::move(x.m_var_map_ushort_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortShort that will be copied.
     */
    eProsima_user_DllExport MapUShortShort& operator =(
            const MapUShortShort& x)
    {

                    m_var_map_ushort_short = x.m_var_map_ushort_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortShort that will be copied.
     */
    eProsima_user_DllExport MapUShortShort& operator =(
            MapUShortShort&& x) noexcept
    {

        m_var_map_ushort_short = std::move(x.m_var_map_ushort_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortShort& x) const
    {
        return (m_var_map_ushort_short == x.m_var_map_ushort_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_short
     * @param _var_map_ushort_short New value to be copied in member var_map_ushort_short
     */
    eProsima_user_DllExport void var_map_ushort_short(
            const std::map<uint16_t, int16_t>& _var_map_ushort_short)
    {
        m_var_map_ushort_short = _var_map_ushort_short;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_short
     * @param _var_map_ushort_short New value to be moved in member var_map_ushort_short
     */
    eProsima_user_DllExport void var_map_ushort_short(
            std::map<uint16_t, int16_t>&& _var_map_ushort_short)
    {
        m_var_map_ushort_short = std::move(_var_map_ushort_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_short
     * @return Constant reference to member var_map_ushort_short
     */
    eProsima_user_DllExport const std::map<uint16_t, int16_t>& var_map_ushort_short() const
    {
        return m_var_map_ushort_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_short
     * @return Reference to member var_map_ushort_short
     */
    eProsima_user_DllExport std::map<uint16_t, int16_t>& var_map_ushort_short()
    {
        return m_var_map_ushort_short;
    }



private:

    std::map<uint16_t, int16_t> m_var_map_ushort_short;

};
/*!
 * @brief This class represents the structure MapUShortUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortUShort that will be copied.
     */
    eProsima_user_DllExport MapUShortUShort(
            const MapUShortUShort& x)
    {
                    m_var_map_ushort_ushort = x.m_var_map_ushort_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortUShort that will be copied.
     */
    eProsima_user_DllExport MapUShortUShort(
            MapUShortUShort&& x) noexcept
    {
        m_var_map_ushort_ushort = std::move(x.m_var_map_ushort_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortUShort that will be copied.
     */
    eProsima_user_DllExport MapUShortUShort& operator =(
            const MapUShortUShort& x)
    {

                    m_var_map_ushort_ushort = x.m_var_map_ushort_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortUShort that will be copied.
     */
    eProsima_user_DllExport MapUShortUShort& operator =(
            MapUShortUShort&& x) noexcept
    {

        m_var_map_ushort_ushort = std::move(x.m_var_map_ushort_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortUShort& x) const
    {
        return (m_var_map_ushort_ushort == x.m_var_map_ushort_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_ushort
     * @param _var_map_ushort_ushort New value to be copied in member var_map_ushort_ushort
     */
    eProsima_user_DllExport void var_map_ushort_ushort(
            const std::map<uint16_t, uint16_t>& _var_map_ushort_ushort)
    {
        m_var_map_ushort_ushort = _var_map_ushort_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_ushort
     * @param _var_map_ushort_ushort New value to be moved in member var_map_ushort_ushort
     */
    eProsima_user_DllExport void var_map_ushort_ushort(
            std::map<uint16_t, uint16_t>&& _var_map_ushort_ushort)
    {
        m_var_map_ushort_ushort = std::move(_var_map_ushort_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_ushort
     * @return Constant reference to member var_map_ushort_ushort
     */
    eProsima_user_DllExport const std::map<uint16_t, uint16_t>& var_map_ushort_ushort() const
    {
        return m_var_map_ushort_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_ushort
     * @return Reference to member var_map_ushort_ushort
     */
    eProsima_user_DllExport std::map<uint16_t, uint16_t>& var_map_ushort_ushort()
    {
        return m_var_map_ushort_ushort;
    }



private:

    std::map<uint16_t, uint16_t> m_var_map_ushort_ushort;

};
/*!
 * @brief This class represents the structure MapUShortLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLong(
            const MapUShortLong& x)
    {
                    m_var_map_ushort_long = x.m_var_map_ushort_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLong(
            MapUShortLong&& x) noexcept
    {
        m_var_map_ushort_long = std::move(x.m_var_map_ushort_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLong& operator =(
            const MapUShortLong& x)
    {

                    m_var_map_ushort_long = x.m_var_map_ushort_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLong& operator =(
            MapUShortLong&& x) noexcept
    {

        m_var_map_ushort_long = std::move(x.m_var_map_ushort_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortLong& x) const
    {
        return (m_var_map_ushort_long == x.m_var_map_ushort_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_long
     * @param _var_map_ushort_long New value to be copied in member var_map_ushort_long
     */
    eProsima_user_DllExport void var_map_ushort_long(
            const std::map<uint16_t, int32_t>& _var_map_ushort_long)
    {
        m_var_map_ushort_long = _var_map_ushort_long;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_long
     * @param _var_map_ushort_long New value to be moved in member var_map_ushort_long
     */
    eProsima_user_DllExport void var_map_ushort_long(
            std::map<uint16_t, int32_t>&& _var_map_ushort_long)
    {
        m_var_map_ushort_long = std::move(_var_map_ushort_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_long
     * @return Constant reference to member var_map_ushort_long
     */
    eProsima_user_DllExport const std::map<uint16_t, int32_t>& var_map_ushort_long() const
    {
        return m_var_map_ushort_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_long
     * @return Reference to member var_map_ushort_long
     */
    eProsima_user_DllExport std::map<uint16_t, int32_t>& var_map_ushort_long()
    {
        return m_var_map_ushort_long;
    }



private:

    std::map<uint16_t, int32_t> m_var_map_ushort_long;

};
/*!
 * @brief This class represents the structure MapUShortULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortULong that will be copied.
     */
    eProsima_user_DllExport MapUShortULong(
            const MapUShortULong& x)
    {
                    m_var_map_ushort_ulong = x.m_var_map_ushort_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortULong that will be copied.
     */
    eProsima_user_DllExport MapUShortULong(
            MapUShortULong&& x) noexcept
    {
        m_var_map_ushort_ulong = std::move(x.m_var_map_ushort_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortULong that will be copied.
     */
    eProsima_user_DllExport MapUShortULong& operator =(
            const MapUShortULong& x)
    {

                    m_var_map_ushort_ulong = x.m_var_map_ushort_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortULong that will be copied.
     */
    eProsima_user_DllExport MapUShortULong& operator =(
            MapUShortULong&& x) noexcept
    {

        m_var_map_ushort_ulong = std::move(x.m_var_map_ushort_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortULong& x) const
    {
        return (m_var_map_ushort_ulong == x.m_var_map_ushort_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_ulong
     * @param _var_map_ushort_ulong New value to be copied in member var_map_ushort_ulong
     */
    eProsima_user_DllExport void var_map_ushort_ulong(
            const std::map<uint16_t, uint32_t>& _var_map_ushort_ulong)
    {
        m_var_map_ushort_ulong = _var_map_ushort_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_ulong
     * @param _var_map_ushort_ulong New value to be moved in member var_map_ushort_ulong
     */
    eProsima_user_DllExport void var_map_ushort_ulong(
            std::map<uint16_t, uint32_t>&& _var_map_ushort_ulong)
    {
        m_var_map_ushort_ulong = std::move(_var_map_ushort_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_ulong
     * @return Constant reference to member var_map_ushort_ulong
     */
    eProsima_user_DllExport const std::map<uint16_t, uint32_t>& var_map_ushort_ulong() const
    {
        return m_var_map_ushort_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_ulong
     * @return Reference to member var_map_ushort_ulong
     */
    eProsima_user_DllExport std::map<uint16_t, uint32_t>& var_map_ushort_ulong()
    {
        return m_var_map_ushort_ulong;
    }



private:

    std::map<uint16_t, uint32_t> m_var_map_ushort_ulong;

};
/*!
 * @brief This class represents the structure MapUShortLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLongLong(
            const MapUShortLongLong& x)
    {
                    m_var_map_ushort_longlong = x.m_var_map_ushort_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLongLong(
            MapUShortLongLong&& x) noexcept
    {
        m_var_map_ushort_longlong = std::move(x.m_var_map_ushort_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLongLong& operator =(
            const MapUShortLongLong& x)
    {

                    m_var_map_ushort_longlong = x.m_var_map_ushort_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortLongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortLongLong& operator =(
            MapUShortLongLong&& x) noexcept
    {

        m_var_map_ushort_longlong = std::move(x.m_var_map_ushort_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortLongLong& x) const
    {
        return (m_var_map_ushort_longlong == x.m_var_map_ushort_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_longlong
     * @param _var_map_ushort_longlong New value to be copied in member var_map_ushort_longlong
     */
    eProsima_user_DllExport void var_map_ushort_longlong(
            const std::map<uint16_t, int64_t>& _var_map_ushort_longlong)
    {
        m_var_map_ushort_longlong = _var_map_ushort_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_longlong
     * @param _var_map_ushort_longlong New value to be moved in member var_map_ushort_longlong
     */
    eProsima_user_DllExport void var_map_ushort_longlong(
            std::map<uint16_t, int64_t>&& _var_map_ushort_longlong)
    {
        m_var_map_ushort_longlong = std::move(_var_map_ushort_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_longlong
     * @return Constant reference to member var_map_ushort_longlong
     */
    eProsima_user_DllExport const std::map<uint16_t, int64_t>& var_map_ushort_longlong() const
    {
        return m_var_map_ushort_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_longlong
     * @return Reference to member var_map_ushort_longlong
     */
    eProsima_user_DllExport std::map<uint16_t, int64_t>& var_map_ushort_longlong()
    {
        return m_var_map_ushort_longlong;
    }



private:

    std::map<uint16_t, int64_t> m_var_map_ushort_longlong;

};
/*!
 * @brief This class represents the structure MapUShortULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortULongLong(
            const MapUShortULongLong& x)
    {
                    m_var_map_ushort_ulonglong = x.m_var_map_ushort_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortULongLong(
            MapUShortULongLong&& x) noexcept
    {
        m_var_map_ushort_ulonglong = std::move(x.m_var_map_ushort_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortULongLong& operator =(
            const MapUShortULongLong& x)
    {

                    m_var_map_ushort_ulonglong = x.m_var_map_ushort_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortULongLong that will be copied.
     */
    eProsima_user_DllExport MapUShortULongLong& operator =(
            MapUShortULongLong&& x) noexcept
    {

        m_var_map_ushort_ulonglong = std::move(x.m_var_map_ushort_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortULongLong& x) const
    {
        return (m_var_map_ushort_ulonglong == x.m_var_map_ushort_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_ulonglong
     * @param _var_map_ushort_ulonglong New value to be copied in member var_map_ushort_ulonglong
     */
    eProsima_user_DllExport void var_map_ushort_ulonglong(
            const std::map<uint16_t, uint64_t>& _var_map_ushort_ulonglong)
    {
        m_var_map_ushort_ulonglong = _var_map_ushort_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_ulonglong
     * @param _var_map_ushort_ulonglong New value to be moved in member var_map_ushort_ulonglong
     */
    eProsima_user_DllExport void var_map_ushort_ulonglong(
            std::map<uint16_t, uint64_t>&& _var_map_ushort_ulonglong)
    {
        m_var_map_ushort_ulonglong = std::move(_var_map_ushort_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_ulonglong
     * @return Constant reference to member var_map_ushort_ulonglong
     */
    eProsima_user_DllExport const std::map<uint16_t, uint64_t>& var_map_ushort_ulonglong() const
    {
        return m_var_map_ushort_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_ulonglong
     * @return Reference to member var_map_ushort_ulonglong
     */
    eProsima_user_DllExport std::map<uint16_t, uint64_t>& var_map_ushort_ulonglong()
    {
        return m_var_map_ushort_ulonglong;
    }



private:

    std::map<uint16_t, uint64_t> m_var_map_ushort_ulonglong;

};
/*!
 * @brief This class represents the structure MapUShortFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortFloat that will be copied.
     */
    eProsima_user_DllExport MapUShortFloat(
            const MapUShortFloat& x)
    {
                    m_var_map_ushort_float = x.m_var_map_ushort_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortFloat that will be copied.
     */
    eProsima_user_DllExport MapUShortFloat(
            MapUShortFloat&& x) noexcept
    {
        m_var_map_ushort_float = std::move(x.m_var_map_ushort_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortFloat that will be copied.
     */
    eProsima_user_DllExport MapUShortFloat& operator =(
            const MapUShortFloat& x)
    {

                    m_var_map_ushort_float = x.m_var_map_ushort_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortFloat that will be copied.
     */
    eProsima_user_DllExport MapUShortFloat& operator =(
            MapUShortFloat&& x) noexcept
    {

        m_var_map_ushort_float = std::move(x.m_var_map_ushort_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortFloat& x) const
    {
        return (m_var_map_ushort_float == x.m_var_map_ushort_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_float
     * @param _var_map_ushort_float New value to be copied in member var_map_ushort_float
     */
    eProsima_user_DllExport void var_map_ushort_float(
            const std::map<uint16_t, float>& _var_map_ushort_float)
    {
        m_var_map_ushort_float = _var_map_ushort_float;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_float
     * @param _var_map_ushort_float New value to be moved in member var_map_ushort_float
     */
    eProsima_user_DllExport void var_map_ushort_float(
            std::map<uint16_t, float>&& _var_map_ushort_float)
    {
        m_var_map_ushort_float = std::move(_var_map_ushort_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_float
     * @return Constant reference to member var_map_ushort_float
     */
    eProsima_user_DllExport const std::map<uint16_t, float>& var_map_ushort_float() const
    {
        return m_var_map_ushort_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_float
     * @return Reference to member var_map_ushort_float
     */
    eProsima_user_DllExport std::map<uint16_t, float>& var_map_ushort_float()
    {
        return m_var_map_ushort_float;
    }



private:

    std::map<uint16_t, float> m_var_map_ushort_float;

};
/*!
 * @brief This class represents the structure MapUShortDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortDouble(
            const MapUShortDouble& x)
    {
                    m_var_map_ushort_double = x.m_var_map_ushort_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortDouble(
            MapUShortDouble&& x) noexcept
    {
        m_var_map_ushort_double = std::move(x.m_var_map_ushort_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortDouble& operator =(
            const MapUShortDouble& x)
    {

                    m_var_map_ushort_double = x.m_var_map_ushort_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortDouble& operator =(
            MapUShortDouble&& x) noexcept
    {

        m_var_map_ushort_double = std::move(x.m_var_map_ushort_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortDouble& x) const
    {
        return (m_var_map_ushort_double == x.m_var_map_ushort_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_double
     * @param _var_map_ushort_double New value to be copied in member var_map_ushort_double
     */
    eProsima_user_DllExport void var_map_ushort_double(
            const std::map<uint16_t, double>& _var_map_ushort_double)
    {
        m_var_map_ushort_double = _var_map_ushort_double;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_double
     * @param _var_map_ushort_double New value to be moved in member var_map_ushort_double
     */
    eProsima_user_DllExport void var_map_ushort_double(
            std::map<uint16_t, double>&& _var_map_ushort_double)
    {
        m_var_map_ushort_double = std::move(_var_map_ushort_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_double
     * @return Constant reference to member var_map_ushort_double
     */
    eProsima_user_DllExport const std::map<uint16_t, double>& var_map_ushort_double() const
    {
        return m_var_map_ushort_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_double
     * @return Reference to member var_map_ushort_double
     */
    eProsima_user_DllExport std::map<uint16_t, double>& var_map_ushort_double()
    {
        return m_var_map_ushort_double;
    }



private:

    std::map<uint16_t, double> m_var_map_ushort_double;

};
/*!
 * @brief This class represents the structure MapUShortLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortLongDouble(
            const MapUShortLongDouble& x)
    {
                    m_var_map_ushort_longdouble = x.m_var_map_ushort_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortLongDouble(
            MapUShortLongDouble&& x) noexcept
    {
        m_var_map_ushort_longdouble = std::move(x.m_var_map_ushort_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortLongDouble& operator =(
            const MapUShortLongDouble& x)
    {

                    m_var_map_ushort_longdouble = x.m_var_map_ushort_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortLongDouble that will be copied.
     */
    eProsima_user_DllExport MapUShortLongDouble& operator =(
            MapUShortLongDouble&& x) noexcept
    {

        m_var_map_ushort_longdouble = std::move(x.m_var_map_ushort_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortLongDouble& x) const
    {
        return (m_var_map_ushort_longdouble == x.m_var_map_ushort_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_longdouble
     * @param _var_map_ushort_longdouble New value to be copied in member var_map_ushort_longdouble
     */
    eProsima_user_DllExport void var_map_ushort_longdouble(
            const std::map<uint16_t, long double>& _var_map_ushort_longdouble)
    {
        m_var_map_ushort_longdouble = _var_map_ushort_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_longdouble
     * @param _var_map_ushort_longdouble New value to be moved in member var_map_ushort_longdouble
     */
    eProsima_user_DllExport void var_map_ushort_longdouble(
            std::map<uint16_t, long double>&& _var_map_ushort_longdouble)
    {
        m_var_map_ushort_longdouble = std::move(_var_map_ushort_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_longdouble
     * @return Constant reference to member var_map_ushort_longdouble
     */
    eProsima_user_DllExport const std::map<uint16_t, long double>& var_map_ushort_longdouble() const
    {
        return m_var_map_ushort_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_longdouble
     * @return Reference to member var_map_ushort_longdouble
     */
    eProsima_user_DllExport std::map<uint16_t, long double>& var_map_ushort_longdouble()
    {
        return m_var_map_ushort_longdouble;
    }



private:

    std::map<uint16_t, long double> m_var_map_ushort_longdouble;

};
/*!
 * @brief This class represents the structure MapUShortBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapUShortBoolean(
            const MapUShortBoolean& x)
    {
                    m_var_map_ushort_boolean = x.m_var_map_ushort_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapUShortBoolean(
            MapUShortBoolean&& x) noexcept
    {
        m_var_map_ushort_boolean = std::move(x.m_var_map_ushort_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapUShortBoolean& operator =(
            const MapUShortBoolean& x)
    {

                    m_var_map_ushort_boolean = x.m_var_map_ushort_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortBoolean that will be copied.
     */
    eProsima_user_DllExport MapUShortBoolean& operator =(
            MapUShortBoolean&& x) noexcept
    {

        m_var_map_ushort_boolean = std::move(x.m_var_map_ushort_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortBoolean& x) const
    {
        return (m_var_map_ushort_boolean == x.m_var_map_ushort_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_boolean
     * @param _var_map_ushort_boolean New value to be copied in member var_map_ushort_boolean
     */
    eProsima_user_DllExport void var_map_ushort_boolean(
            const std::map<uint16_t, bool>& _var_map_ushort_boolean)
    {
        m_var_map_ushort_boolean = _var_map_ushort_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_boolean
     * @param _var_map_ushort_boolean New value to be moved in member var_map_ushort_boolean
     */
    eProsima_user_DllExport void var_map_ushort_boolean(
            std::map<uint16_t, bool>&& _var_map_ushort_boolean)
    {
        m_var_map_ushort_boolean = std::move(_var_map_ushort_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_boolean
     * @return Constant reference to member var_map_ushort_boolean
     */
    eProsima_user_DllExport const std::map<uint16_t, bool>& var_map_ushort_boolean() const
    {
        return m_var_map_ushort_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_boolean
     * @return Reference to member var_map_ushort_boolean
     */
    eProsima_user_DllExport std::map<uint16_t, bool>& var_map_ushort_boolean()
    {
        return m_var_map_ushort_boolean;
    }



private:

    std::map<uint16_t, bool> m_var_map_ushort_boolean;

};
/*!
 * @brief This class represents the structure MapUShortOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortOctet that will be copied.
     */
    eProsima_user_DllExport MapUShortOctet(
            const MapUShortOctet& x)
    {
                    m_var_map_ushort_octet = x.m_var_map_ushort_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortOctet that will be copied.
     */
    eProsima_user_DllExport MapUShortOctet(
            MapUShortOctet&& x) noexcept
    {
        m_var_map_ushort_octet = std::move(x.m_var_map_ushort_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortOctet that will be copied.
     */
    eProsima_user_DllExport MapUShortOctet& operator =(
            const MapUShortOctet& x)
    {

                    m_var_map_ushort_octet = x.m_var_map_ushort_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortOctet that will be copied.
     */
    eProsima_user_DllExport MapUShortOctet& operator =(
            MapUShortOctet&& x) noexcept
    {

        m_var_map_ushort_octet = std::move(x.m_var_map_ushort_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortOctet& x) const
    {
        return (m_var_map_ushort_octet == x.m_var_map_ushort_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_octet
     * @param _var_map_ushort_octet New value to be copied in member var_map_ushort_octet
     */
    eProsima_user_DllExport void var_map_ushort_octet(
            const std::map<uint16_t, uint8_t>& _var_map_ushort_octet)
    {
        m_var_map_ushort_octet = _var_map_ushort_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_octet
     * @param _var_map_ushort_octet New value to be moved in member var_map_ushort_octet
     */
    eProsima_user_DllExport void var_map_ushort_octet(
            std::map<uint16_t, uint8_t>&& _var_map_ushort_octet)
    {
        m_var_map_ushort_octet = std::move(_var_map_ushort_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_octet
     * @return Constant reference to member var_map_ushort_octet
     */
    eProsima_user_DllExport const std::map<uint16_t, uint8_t>& var_map_ushort_octet() const
    {
        return m_var_map_ushort_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_octet
     * @return Reference to member var_map_ushort_octet
     */
    eProsima_user_DllExport std::map<uint16_t, uint8_t>& var_map_ushort_octet()
    {
        return m_var_map_ushort_octet;
    }



private:

    std::map<uint16_t, uint8_t> m_var_map_ushort_octet;

};
/*!
 * @brief This class represents the structure MapUShortChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortChar that will be copied.
     */
    eProsima_user_DllExport MapUShortChar(
            const MapUShortChar& x)
    {
                    m_var_map_ushort_char = x.m_var_map_ushort_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortChar that will be copied.
     */
    eProsima_user_DllExport MapUShortChar(
            MapUShortChar&& x) noexcept
    {
        m_var_map_ushort_char = std::move(x.m_var_map_ushort_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortChar that will be copied.
     */
    eProsima_user_DllExport MapUShortChar& operator =(
            const MapUShortChar& x)
    {

                    m_var_map_ushort_char = x.m_var_map_ushort_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortChar that will be copied.
     */
    eProsima_user_DllExport MapUShortChar& operator =(
            MapUShortChar&& x) noexcept
    {

        m_var_map_ushort_char = std::move(x.m_var_map_ushort_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortChar& x) const
    {
        return (m_var_map_ushort_char == x.m_var_map_ushort_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_char
     * @param _var_map_ushort_char New value to be copied in member var_map_ushort_char
     */
    eProsima_user_DllExport void var_map_ushort_char(
            const std::map<uint16_t, char>& _var_map_ushort_char)
    {
        m_var_map_ushort_char = _var_map_ushort_char;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_char
     * @param _var_map_ushort_char New value to be moved in member var_map_ushort_char
     */
    eProsima_user_DllExport void var_map_ushort_char(
            std::map<uint16_t, char>&& _var_map_ushort_char)
    {
        m_var_map_ushort_char = std::move(_var_map_ushort_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_char
     * @return Constant reference to member var_map_ushort_char
     */
    eProsima_user_DllExport const std::map<uint16_t, char>& var_map_ushort_char() const
    {
        return m_var_map_ushort_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_char
     * @return Reference to member var_map_ushort_char
     */
    eProsima_user_DllExport std::map<uint16_t, char>& var_map_ushort_char()
    {
        return m_var_map_ushort_char;
    }



private:

    std::map<uint16_t, char> m_var_map_ushort_char;

};
/*!
 * @brief This class represents the structure MapUShortWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortWChar that will be copied.
     */
    eProsima_user_DllExport MapUShortWChar(
            const MapUShortWChar& x)
    {
                    m_var_map_ushort_wchar = x.m_var_map_ushort_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortWChar that will be copied.
     */
    eProsima_user_DllExport MapUShortWChar(
            MapUShortWChar&& x) noexcept
    {
        m_var_map_ushort_wchar = std::move(x.m_var_map_ushort_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortWChar that will be copied.
     */
    eProsima_user_DllExport MapUShortWChar& operator =(
            const MapUShortWChar& x)
    {

                    m_var_map_ushort_wchar = x.m_var_map_ushort_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortWChar that will be copied.
     */
    eProsima_user_DllExport MapUShortWChar& operator =(
            MapUShortWChar&& x) noexcept
    {

        m_var_map_ushort_wchar = std::move(x.m_var_map_ushort_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortWChar& x) const
    {
        return (m_var_map_ushort_wchar == x.m_var_map_ushort_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_wchar
     * @param _var_map_ushort_wchar New value to be copied in member var_map_ushort_wchar
     */
    eProsima_user_DllExport void var_map_ushort_wchar(
            const std::map<uint16_t, wchar_t>& _var_map_ushort_wchar)
    {
        m_var_map_ushort_wchar = _var_map_ushort_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_wchar
     * @param _var_map_ushort_wchar New value to be moved in member var_map_ushort_wchar
     */
    eProsima_user_DllExport void var_map_ushort_wchar(
            std::map<uint16_t, wchar_t>&& _var_map_ushort_wchar)
    {
        m_var_map_ushort_wchar = std::move(_var_map_ushort_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_wchar
     * @return Constant reference to member var_map_ushort_wchar
     */
    eProsima_user_DllExport const std::map<uint16_t, wchar_t>& var_map_ushort_wchar() const
    {
        return m_var_map_ushort_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_wchar
     * @return Reference to member var_map_ushort_wchar
     */
    eProsima_user_DllExport std::map<uint16_t, wchar_t>& var_map_ushort_wchar()
    {
        return m_var_map_ushort_wchar;
    }



private:

    std::map<uint16_t, wchar_t> m_var_map_ushort_wchar;

};
/*!
 * @brief This class represents the structure MapUShortString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortString that will be copied.
     */
    eProsima_user_DllExport MapUShortString(
            const MapUShortString& x)
    {
                    m_var_map_ushort_string = x.m_var_map_ushort_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortString that will be copied.
     */
    eProsima_user_DllExport MapUShortString(
            MapUShortString&& x) noexcept
    {
        m_var_map_ushort_string = std::move(x.m_var_map_ushort_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortString that will be copied.
     */
    eProsima_user_DllExport MapUShortString& operator =(
            const MapUShortString& x)
    {

                    m_var_map_ushort_string = x.m_var_map_ushort_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortString that will be copied.
     */
    eProsima_user_DllExport MapUShortString& operator =(
            MapUShortString&& x) noexcept
    {

        m_var_map_ushort_string = std::move(x.m_var_map_ushort_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortString& x) const
    {
        return (m_var_map_ushort_string == x.m_var_map_ushort_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_string
     * @param _var_map_ushort_string New value to be copied in member var_map_ushort_string
     */
    eProsima_user_DllExport void var_map_ushort_string(
            const std::map<uint16_t, std::string>& _var_map_ushort_string)
    {
        m_var_map_ushort_string = _var_map_ushort_string;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_string
     * @param _var_map_ushort_string New value to be moved in member var_map_ushort_string
     */
    eProsima_user_DllExport void var_map_ushort_string(
            std::map<uint16_t, std::string>&& _var_map_ushort_string)
    {
        m_var_map_ushort_string = std::move(_var_map_ushort_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_string
     * @return Constant reference to member var_map_ushort_string
     */
    eProsima_user_DllExport const std::map<uint16_t, std::string>& var_map_ushort_string() const
    {
        return m_var_map_ushort_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_string
     * @return Reference to member var_map_ushort_string
     */
    eProsima_user_DllExport std::map<uint16_t, std::string>& var_map_ushort_string()
    {
        return m_var_map_ushort_string;
    }



private:

    std::map<uint16_t, std::string> m_var_map_ushort_string;

};
/*!
 * @brief This class represents the structure MapUShortWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortWString that will be copied.
     */
    eProsima_user_DllExport MapUShortWString(
            const MapUShortWString& x)
    {
                    m_var_map_ushort_wstring = x.m_var_map_ushort_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortWString that will be copied.
     */
    eProsima_user_DllExport MapUShortWString(
            MapUShortWString&& x) noexcept
    {
        m_var_map_ushort_wstring = std::move(x.m_var_map_ushort_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortWString that will be copied.
     */
    eProsima_user_DllExport MapUShortWString& operator =(
            const MapUShortWString& x)
    {

                    m_var_map_ushort_wstring = x.m_var_map_ushort_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortWString that will be copied.
     */
    eProsima_user_DllExport MapUShortWString& operator =(
            MapUShortWString&& x) noexcept
    {

        m_var_map_ushort_wstring = std::move(x.m_var_map_ushort_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortWString& x) const
    {
        return (m_var_map_ushort_wstring == x.m_var_map_ushort_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_wstring
     * @param _var_map_ushort_wstring New value to be copied in member var_map_ushort_wstring
     */
    eProsima_user_DllExport void var_map_ushort_wstring(
            const std::map<uint16_t, std::wstring>& _var_map_ushort_wstring)
    {
        m_var_map_ushort_wstring = _var_map_ushort_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_wstring
     * @param _var_map_ushort_wstring New value to be moved in member var_map_ushort_wstring
     */
    eProsima_user_DllExport void var_map_ushort_wstring(
            std::map<uint16_t, std::wstring>&& _var_map_ushort_wstring)
    {
        m_var_map_ushort_wstring = std::move(_var_map_ushort_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_wstring
     * @return Constant reference to member var_map_ushort_wstring
     */
    eProsima_user_DllExport const std::map<uint16_t, std::wstring>& var_map_ushort_wstring() const
    {
        return m_var_map_ushort_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_wstring
     * @return Reference to member var_map_ushort_wstring
     */
    eProsima_user_DllExport std::map<uint16_t, std::wstring>& var_map_ushort_wstring()
    {
        return m_var_map_ushort_wstring;
    }



private:

    std::map<uint16_t, std::wstring> m_var_map_ushort_wstring;

};
/*!
 * @brief This class represents the structure MapUShortInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedStringHelper(
            const MapUShortInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_ushort_inneraliasboundedstringhelper = x.m_var_map_ushort_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedStringHelper(
            MapUShortInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_ushort_inneraliasboundedstringhelper = std::move(x.m_var_map_ushort_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedStringHelper& operator =(
            const MapUShortInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_ushort_inneraliasboundedstringhelper = x.m_var_map_ushort_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedStringHelper& operator =(
            MapUShortInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_ushort_inneraliasboundedstringhelper = std::move(x.m_var_map_ushort_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_ushort_inneraliasboundedstringhelper == x.m_var_map_ushort_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_inneraliasboundedstringhelper
     * @param _var_map_ushort_inneraliasboundedstringhelper New value to be copied in member var_map_ushort_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasboundedstringhelper(
            const std::map<uint16_t, Inner_alias_bounded_string_helper>& _var_map_ushort_inneraliasboundedstringhelper)
    {
        m_var_map_ushort_inneraliasboundedstringhelper = _var_map_ushort_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_inneraliasboundedstringhelper
     * @param _var_map_ushort_inneraliasboundedstringhelper New value to be moved in member var_map_ushort_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasboundedstringhelper(
            std::map<uint16_t, Inner_alias_bounded_string_helper>&& _var_map_ushort_inneraliasboundedstringhelper)
    {
        m_var_map_ushort_inneraliasboundedstringhelper = std::move(_var_map_ushort_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_ushort_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<uint16_t, Inner_alias_bounded_string_helper>& var_map_ushort_inneraliasboundedstringhelper() const
    {
        return m_var_map_ushort_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_inneraliasboundedstringhelper
     * @return Reference to member var_map_ushort_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<uint16_t, Inner_alias_bounded_string_helper>& var_map_ushort_inneraliasboundedstringhelper()
    {
        return m_var_map_ushort_inneraliasboundedstringhelper;
    }



private:

    std::map<uint16_t, Inner_alias_bounded_string_helper> m_var_map_ushort_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedWStringHelper(
            const MapUShortInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_ushort_inneraliasboundedwstringhelper = x.m_var_map_ushort_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedWStringHelper(
            MapUShortInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_ushort_inneraliasboundedwstringhelper = std::move(x.m_var_map_ushort_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedWStringHelper& operator =(
            const MapUShortInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_ushort_inneraliasboundedwstringhelper = x.m_var_map_ushort_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasBoundedWStringHelper& operator =(
            MapUShortInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_ushort_inneraliasboundedwstringhelper = std::move(x.m_var_map_ushort_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_ushort_inneraliasboundedwstringhelper == x.m_var_map_ushort_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_inneraliasboundedwstringhelper
     * @param _var_map_ushort_inneraliasboundedwstringhelper New value to be copied in member var_map_ushort_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasboundedwstringhelper(
            const std::map<uint16_t, Inner_alias_bounded_wstring_helper>& _var_map_ushort_inneraliasboundedwstringhelper)
    {
        m_var_map_ushort_inneraliasboundedwstringhelper = _var_map_ushort_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_inneraliasboundedwstringhelper
     * @param _var_map_ushort_inneraliasboundedwstringhelper New value to be moved in member var_map_ushort_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasboundedwstringhelper(
            std::map<uint16_t, Inner_alias_bounded_wstring_helper>&& _var_map_ushort_inneraliasboundedwstringhelper)
    {
        m_var_map_ushort_inneraliasboundedwstringhelper = std::move(_var_map_ushort_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_ushort_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<uint16_t, Inner_alias_bounded_wstring_helper>& var_map_ushort_inneraliasboundedwstringhelper() const
    {
        return m_var_map_ushort_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_inneraliasboundedwstringhelper
     * @return Reference to member var_map_ushort_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<uint16_t, Inner_alias_bounded_wstring_helper>& var_map_ushort_inneraliasboundedwstringhelper()
    {
        return m_var_map_ushort_inneraliasboundedwstringhelper;
    }



private:

    std::map<uint16_t, Inner_alias_bounded_wstring_helper> m_var_map_ushort_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerEnumHelper(
            const MapUShortInnerEnumHelper& x)
    {
                    m_var_map_ushort_innerenumhelper = x.m_var_map_ushort_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerEnumHelper(
            MapUShortInnerEnumHelper&& x) noexcept
    {
        m_var_map_ushort_innerenumhelper = std::move(x.m_var_map_ushort_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerEnumHelper& operator =(
            const MapUShortInnerEnumHelper& x)
    {

                    m_var_map_ushort_innerenumhelper = x.m_var_map_ushort_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerEnumHelper& operator =(
            MapUShortInnerEnumHelper&& x) noexcept
    {

        m_var_map_ushort_innerenumhelper = std::move(x.m_var_map_ushort_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerEnumHelper& x) const
    {
        return (m_var_map_ushort_innerenumhelper == x.m_var_map_ushort_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_innerenumhelper
     * @param _var_map_ushort_innerenumhelper New value to be copied in member var_map_ushort_innerenumhelper
     */
    eProsima_user_DllExport void var_map_ushort_innerenumhelper(
            const std::map<uint16_t, InnerEnumHelper>& _var_map_ushort_innerenumhelper)
    {
        m_var_map_ushort_innerenumhelper = _var_map_ushort_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_innerenumhelper
     * @param _var_map_ushort_innerenumhelper New value to be moved in member var_map_ushort_innerenumhelper
     */
    eProsima_user_DllExport void var_map_ushort_innerenumhelper(
            std::map<uint16_t, InnerEnumHelper>&& _var_map_ushort_innerenumhelper)
    {
        m_var_map_ushort_innerenumhelper = std::move(_var_map_ushort_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_innerenumhelper
     * @return Constant reference to member var_map_ushort_innerenumhelper
     */
    eProsima_user_DllExport const std::map<uint16_t, InnerEnumHelper>& var_map_ushort_innerenumhelper() const
    {
        return m_var_map_ushort_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_innerenumhelper
     * @return Reference to member var_map_ushort_innerenumhelper
     */
    eProsima_user_DllExport std::map<uint16_t, InnerEnumHelper>& var_map_ushort_innerenumhelper()
    {
        return m_var_map_ushort_innerenumhelper;
    }



private:

    std::map<uint16_t, InnerEnumHelper> m_var_map_ushort_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitMaskHelper(
            const MapUShortInnerBitMaskHelper& x)
    {
                    m_var_map_ushort_innerbitmaskhelper = x.m_var_map_ushort_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitMaskHelper(
            MapUShortInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_ushort_innerbitmaskhelper = std::move(x.m_var_map_ushort_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitMaskHelper& operator =(
            const MapUShortInnerBitMaskHelper& x)
    {

                    m_var_map_ushort_innerbitmaskhelper = x.m_var_map_ushort_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitMaskHelper& operator =(
            MapUShortInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_ushort_innerbitmaskhelper = std::move(x.m_var_map_ushort_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerBitMaskHelper& x) const
    {
        return (m_var_map_ushort_innerbitmaskhelper == x.m_var_map_ushort_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_innerbitmaskhelper
     * @param _var_map_ushort_innerbitmaskhelper New value to be copied in member var_map_ushort_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_ushort_innerbitmaskhelper(
            const std::map<uint16_t, InnerBitMaskHelper>& _var_map_ushort_innerbitmaskhelper)
    {
        m_var_map_ushort_innerbitmaskhelper = _var_map_ushort_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_innerbitmaskhelper
     * @param _var_map_ushort_innerbitmaskhelper New value to be moved in member var_map_ushort_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_ushort_innerbitmaskhelper(
            std::map<uint16_t, InnerBitMaskHelper>&& _var_map_ushort_innerbitmaskhelper)
    {
        m_var_map_ushort_innerbitmaskhelper = std::move(_var_map_ushort_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_innerbitmaskhelper
     * @return Constant reference to member var_map_ushort_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<uint16_t, InnerBitMaskHelper>& var_map_ushort_innerbitmaskhelper() const
    {
        return m_var_map_ushort_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_innerbitmaskhelper
     * @return Reference to member var_map_ushort_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<uint16_t, InnerBitMaskHelper>& var_map_ushort_innerbitmaskhelper()
    {
        return m_var_map_ushort_innerbitmaskhelper;
    }



private:

    std::map<uint16_t, InnerBitMaskHelper> m_var_map_ushort_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasHelper(
            const MapUShortInnerAliasHelper& x)
    {
                    m_var_map_ushort_inneraliashelper = x.m_var_map_ushort_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasHelper(
            MapUShortInnerAliasHelper&& x) noexcept
    {
        m_var_map_ushort_inneraliashelper = std::move(x.m_var_map_ushort_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasHelper& operator =(
            const MapUShortInnerAliasHelper& x)
    {

                    m_var_map_ushort_inneraliashelper = x.m_var_map_ushort_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasHelper& operator =(
            MapUShortInnerAliasHelper&& x) noexcept
    {

        m_var_map_ushort_inneraliashelper = std::move(x.m_var_map_ushort_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerAliasHelper& x) const
    {
        return (m_var_map_ushort_inneraliashelper == x.m_var_map_ushort_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_inneraliashelper
     * @param _var_map_ushort_inneraliashelper New value to be copied in member var_map_ushort_inneraliashelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliashelper(
            const std::map<uint16_t, InnerAliasHelper>& _var_map_ushort_inneraliashelper)
    {
        m_var_map_ushort_inneraliashelper = _var_map_ushort_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_inneraliashelper
     * @param _var_map_ushort_inneraliashelper New value to be moved in member var_map_ushort_inneraliashelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliashelper(
            std::map<uint16_t, InnerAliasHelper>&& _var_map_ushort_inneraliashelper)
    {
        m_var_map_ushort_inneraliashelper = std::move(_var_map_ushort_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_inneraliashelper
     * @return Constant reference to member var_map_ushort_inneraliashelper
     */
    eProsima_user_DllExport const std::map<uint16_t, InnerAliasHelper>& var_map_ushort_inneraliashelper() const
    {
        return m_var_map_ushort_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_inneraliashelper
     * @return Reference to member var_map_ushort_inneraliashelper
     */
    eProsima_user_DllExport std::map<uint16_t, InnerAliasHelper>& var_map_ushort_inneraliashelper()
    {
        return m_var_map_ushort_inneraliashelper;
    }



private:

    std::map<uint16_t, InnerAliasHelper> m_var_map_ushort_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasArrayHelper(
            const MapUShortInnerAliasArrayHelper& x)
    {
                    m_var_map_ushort_inneraliasarrayhelper = x.m_var_map_ushort_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasArrayHelper(
            MapUShortInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_ushort_inneraliasarrayhelper = std::move(x.m_var_map_ushort_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasArrayHelper& operator =(
            const MapUShortInnerAliasArrayHelper& x)
    {

                    m_var_map_ushort_inneraliasarrayhelper = x.m_var_map_ushort_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasArrayHelper& operator =(
            MapUShortInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_ushort_inneraliasarrayhelper = std::move(x.m_var_map_ushort_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerAliasArrayHelper& x) const
    {
        return (m_var_map_ushort_inneraliasarrayhelper == x.m_var_map_ushort_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_inneraliasarrayhelper
     * @param _var_map_ushort_inneraliasarrayhelper New value to be copied in member var_map_ushort_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasarrayhelper(
            const std::map<uint16_t, Inner_alias_array_helper>& _var_map_ushort_inneraliasarrayhelper)
    {
        m_var_map_ushort_inneraliasarrayhelper = _var_map_ushort_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_inneraliasarrayhelper
     * @param _var_map_ushort_inneraliasarrayhelper New value to be moved in member var_map_ushort_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasarrayhelper(
            std::map<uint16_t, Inner_alias_array_helper>&& _var_map_ushort_inneraliasarrayhelper)
    {
        m_var_map_ushort_inneraliasarrayhelper = std::move(_var_map_ushort_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_inneraliasarrayhelper
     * @return Constant reference to member var_map_ushort_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<uint16_t, Inner_alias_array_helper>& var_map_ushort_inneraliasarrayhelper() const
    {
        return m_var_map_ushort_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_inneraliasarrayhelper
     * @return Reference to member var_map_ushort_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<uint16_t, Inner_alias_array_helper>& var_map_ushort_inneraliasarrayhelper()
    {
        return m_var_map_ushort_inneraliasarrayhelper;
    }



private:

    std::map<uint16_t, Inner_alias_array_helper> m_var_map_ushort_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasSequenceHelper(
            const MapUShortInnerAliasSequenceHelper& x)
    {
                    m_var_map_ushort_inneraliassequencehelper = x.m_var_map_ushort_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasSequenceHelper(
            MapUShortInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_ushort_inneraliassequencehelper = std::move(x.m_var_map_ushort_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasSequenceHelper& operator =(
            const MapUShortInnerAliasSequenceHelper& x)
    {

                    m_var_map_ushort_inneraliassequencehelper = x.m_var_map_ushort_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasSequenceHelper& operator =(
            MapUShortInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_ushort_inneraliassequencehelper = std::move(x.m_var_map_ushort_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_ushort_inneraliassequencehelper == x.m_var_map_ushort_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_inneraliassequencehelper
     * @param _var_map_ushort_inneraliassequencehelper New value to be copied in member var_map_ushort_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliassequencehelper(
            const std::map<uint16_t, Inner_alias_sequence_helper>& _var_map_ushort_inneraliassequencehelper)
    {
        m_var_map_ushort_inneraliassequencehelper = _var_map_ushort_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_inneraliassequencehelper
     * @param _var_map_ushort_inneraliassequencehelper New value to be moved in member var_map_ushort_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliassequencehelper(
            std::map<uint16_t, Inner_alias_sequence_helper>&& _var_map_ushort_inneraliassequencehelper)
    {
        m_var_map_ushort_inneraliassequencehelper = std::move(_var_map_ushort_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_inneraliassequencehelper
     * @return Constant reference to member var_map_ushort_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<uint16_t, Inner_alias_sequence_helper>& var_map_ushort_inneraliassequencehelper() const
    {
        return m_var_map_ushort_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_inneraliassequencehelper
     * @return Reference to member var_map_ushort_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<uint16_t, Inner_alias_sequence_helper>& var_map_ushort_inneraliassequencehelper()
    {
        return m_var_map_ushort_inneraliassequencehelper;
    }



private:

    std::map<uint16_t, Inner_alias_sequence_helper> m_var_map_ushort_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasMapHelper(
            const MapUShortInnerAliasMapHelper& x)
    {
                    m_var_map_ushort_inneraliasmaphelper = x.m_var_map_ushort_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasMapHelper(
            MapUShortInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_ushort_inneraliasmaphelper = std::move(x.m_var_map_ushort_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasMapHelper& operator =(
            const MapUShortInnerAliasMapHelper& x)
    {

                    m_var_map_ushort_inneraliasmaphelper = x.m_var_map_ushort_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerAliasMapHelper& operator =(
            MapUShortInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_ushort_inneraliasmaphelper = std::move(x.m_var_map_ushort_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerAliasMapHelper& x) const
    {
        return (m_var_map_ushort_inneraliasmaphelper == x.m_var_map_ushort_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_inneraliasmaphelper
     * @param _var_map_ushort_inneraliasmaphelper New value to be copied in member var_map_ushort_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasmaphelper(
            const std::map<uint16_t, Inner_alias_map_helper>& _var_map_ushort_inneraliasmaphelper)
    {
        m_var_map_ushort_inneraliasmaphelper = _var_map_ushort_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_inneraliasmaphelper
     * @param _var_map_ushort_inneraliasmaphelper New value to be moved in member var_map_ushort_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_ushort_inneraliasmaphelper(
            std::map<uint16_t, Inner_alias_map_helper>&& _var_map_ushort_inneraliasmaphelper)
    {
        m_var_map_ushort_inneraliasmaphelper = std::move(_var_map_ushort_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_inneraliasmaphelper
     * @return Constant reference to member var_map_ushort_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<uint16_t, Inner_alias_map_helper>& var_map_ushort_inneraliasmaphelper() const
    {
        return m_var_map_ushort_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_inneraliasmaphelper
     * @return Reference to member var_map_ushort_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<uint16_t, Inner_alias_map_helper>& var_map_ushort_inneraliasmaphelper()
    {
        return m_var_map_ushort_inneraliasmaphelper;
    }



private:

    std::map<uint16_t, Inner_alias_map_helper> m_var_map_ushort_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerUnionHelper(
            const MapUShortInnerUnionHelper& x)
    {
                    m_var_map_ushort_innerunionhelper = x.m_var_map_ushort_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerUnionHelper(
            MapUShortInnerUnionHelper&& x) noexcept
    {
        m_var_map_ushort_innerunionhelper = std::move(x.m_var_map_ushort_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerUnionHelper& operator =(
            const MapUShortInnerUnionHelper& x)
    {

                    m_var_map_ushort_innerunionhelper = x.m_var_map_ushort_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerUnionHelper& operator =(
            MapUShortInnerUnionHelper&& x) noexcept
    {

        m_var_map_ushort_innerunionhelper = std::move(x.m_var_map_ushort_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerUnionHelper& x) const
    {
        return (m_var_map_ushort_innerunionhelper == x.m_var_map_ushort_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_innerunionhelper
     * @param _var_map_ushort_innerunionhelper New value to be copied in member var_map_ushort_innerunionhelper
     */
    eProsima_user_DllExport void var_map_ushort_innerunionhelper(
            const std::map<uint16_t, InnerUnionHelper>& _var_map_ushort_innerunionhelper)
    {
        m_var_map_ushort_innerunionhelper = _var_map_ushort_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_innerunionhelper
     * @param _var_map_ushort_innerunionhelper New value to be moved in member var_map_ushort_innerunionhelper
     */
    eProsima_user_DllExport void var_map_ushort_innerunionhelper(
            std::map<uint16_t, InnerUnionHelper>&& _var_map_ushort_innerunionhelper)
    {
        m_var_map_ushort_innerunionhelper = std::move(_var_map_ushort_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_innerunionhelper
     * @return Constant reference to member var_map_ushort_innerunionhelper
     */
    eProsima_user_DllExport const std::map<uint16_t, InnerUnionHelper>& var_map_ushort_innerunionhelper() const
    {
        return m_var_map_ushort_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_innerunionhelper
     * @return Reference to member var_map_ushort_innerunionhelper
     */
    eProsima_user_DllExport std::map<uint16_t, InnerUnionHelper>& var_map_ushort_innerunionhelper()
    {
        return m_var_map_ushort_innerunionhelper;
    }



private:

    std::map<uint16_t, InnerUnionHelper> m_var_map_ushort_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerStructureHelper(
            const MapUShortInnerStructureHelper& x)
    {
                    m_var_map_ushort_innerstructurehelper = x.m_var_map_ushort_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerStructureHelper(
            MapUShortInnerStructureHelper&& x) noexcept
    {
        m_var_map_ushort_innerstructurehelper = std::move(x.m_var_map_ushort_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerStructureHelper& operator =(
            const MapUShortInnerStructureHelper& x)
    {

                    m_var_map_ushort_innerstructurehelper = x.m_var_map_ushort_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerStructureHelper& operator =(
            MapUShortInnerStructureHelper&& x) noexcept
    {

        m_var_map_ushort_innerstructurehelper = std::move(x.m_var_map_ushort_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerStructureHelper& x) const
    {
        return (m_var_map_ushort_innerstructurehelper == x.m_var_map_ushort_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_innerstructurehelper
     * @param _var_map_ushort_innerstructurehelper New value to be copied in member var_map_ushort_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_ushort_innerstructurehelper(
            const std::map<uint16_t, InnerStructureHelper>& _var_map_ushort_innerstructurehelper)
    {
        m_var_map_ushort_innerstructurehelper = _var_map_ushort_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_innerstructurehelper
     * @param _var_map_ushort_innerstructurehelper New value to be moved in member var_map_ushort_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_ushort_innerstructurehelper(
            std::map<uint16_t, InnerStructureHelper>&& _var_map_ushort_innerstructurehelper)
    {
        m_var_map_ushort_innerstructurehelper = std::move(_var_map_ushort_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_innerstructurehelper
     * @return Constant reference to member var_map_ushort_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<uint16_t, InnerStructureHelper>& var_map_ushort_innerstructurehelper() const
    {
        return m_var_map_ushort_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_innerstructurehelper
     * @return Reference to member var_map_ushort_innerstructurehelper
     */
    eProsima_user_DllExport std::map<uint16_t, InnerStructureHelper>& var_map_ushort_innerstructurehelper()
    {
        return m_var_map_ushort_innerstructurehelper;
    }



private:

    std::map<uint16_t, InnerStructureHelper> m_var_map_ushort_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapUShortInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapUShortInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapUShortInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapUShortInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapUShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitsetHelper(
            const MapUShortInnerBitsetHelper& x)
    {
                    m_var_map_ushort_innerbitsethelper = x.m_var_map_ushort_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapUShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitsetHelper(
            MapUShortInnerBitsetHelper&& x) noexcept
    {
        m_var_map_ushort_innerbitsethelper = std::move(x.m_var_map_ushort_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapUShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitsetHelper& operator =(
            const MapUShortInnerBitsetHelper& x)
    {

                    m_var_map_ushort_innerbitsethelper = x.m_var_map_ushort_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapUShortInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapUShortInnerBitsetHelper& operator =(
            MapUShortInnerBitsetHelper&& x) noexcept
    {

        m_var_map_ushort_innerbitsethelper = std::move(x.m_var_map_ushort_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapUShortInnerBitsetHelper& x) const
    {
        return (m_var_map_ushort_innerbitsethelper == x.m_var_map_ushort_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapUShortInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapUShortInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ushort_innerbitsethelper
     * @param _var_map_ushort_innerbitsethelper New value to be copied in member var_map_ushort_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_ushort_innerbitsethelper(
            const std::map<uint16_t, InnerBitsetHelper>& _var_map_ushort_innerbitsethelper)
    {
        m_var_map_ushort_innerbitsethelper = _var_map_ushort_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ushort_innerbitsethelper
     * @param _var_map_ushort_innerbitsethelper New value to be moved in member var_map_ushort_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_ushort_innerbitsethelper(
            std::map<uint16_t, InnerBitsetHelper>&& _var_map_ushort_innerbitsethelper)
    {
        m_var_map_ushort_innerbitsethelper = std::move(_var_map_ushort_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ushort_innerbitsethelper
     * @return Constant reference to member var_map_ushort_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<uint16_t, InnerBitsetHelper>& var_map_ushort_innerbitsethelper() const
    {
        return m_var_map_ushort_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ushort_innerbitsethelper
     * @return Reference to member var_map_ushort_innerbitsethelper
     */
    eProsima_user_DllExport std::map<uint16_t, InnerBitsetHelper>& var_map_ushort_innerbitsethelper()
    {
        return m_var_map_ushort_innerbitsethelper;
    }



private:

    std::map<uint16_t, InnerBitsetHelper> m_var_map_ushort_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapLongShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongShort(
            const MapLongShort& x)
    {
                    m_var_map_long_short = x.m_var_map_long_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongShort(
            MapLongShort&& x) noexcept
    {
        m_var_map_long_short = std::move(x.m_var_map_long_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongShort& operator =(
            const MapLongShort& x)
    {

                    m_var_map_long_short = x.m_var_map_long_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongShort& operator =(
            MapLongShort&& x) noexcept
    {

        m_var_map_long_short = std::move(x.m_var_map_long_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongShort& x) const
    {
        return (m_var_map_long_short == x.m_var_map_long_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_short
     * @param _var_map_long_short New value to be copied in member var_map_long_short
     */
    eProsima_user_DllExport void var_map_long_short(
            const std::map<int32_t, int16_t>& _var_map_long_short)
    {
        m_var_map_long_short = _var_map_long_short;
    }

    /*!
     * @brief This function moves the value in member var_map_long_short
     * @param _var_map_long_short New value to be moved in member var_map_long_short
     */
    eProsima_user_DllExport void var_map_long_short(
            std::map<int32_t, int16_t>&& _var_map_long_short)
    {
        m_var_map_long_short = std::move(_var_map_long_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_short
     * @return Constant reference to member var_map_long_short
     */
    eProsima_user_DllExport const std::map<int32_t, int16_t>& var_map_long_short() const
    {
        return m_var_map_long_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_short
     * @return Reference to member var_map_long_short
     */
    eProsima_user_DllExport std::map<int32_t, int16_t>& var_map_long_short()
    {
        return m_var_map_long_short;
    }



private:

    std::map<int32_t, int16_t> m_var_map_long_short;

};
/*!
 * @brief This class represents the structure MapLongUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongUShort(
            const MapLongUShort& x)
    {
                    m_var_map_long_ushort = x.m_var_map_long_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongUShort(
            MapLongUShort&& x) noexcept
    {
        m_var_map_long_ushort = std::move(x.m_var_map_long_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongUShort& operator =(
            const MapLongUShort& x)
    {

                    m_var_map_long_ushort = x.m_var_map_long_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongUShort& operator =(
            MapLongUShort&& x) noexcept
    {

        m_var_map_long_ushort = std::move(x.m_var_map_long_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongUShort& x) const
    {
        return (m_var_map_long_ushort == x.m_var_map_long_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_ushort
     * @param _var_map_long_ushort New value to be copied in member var_map_long_ushort
     */
    eProsima_user_DllExport void var_map_long_ushort(
            const std::map<int32_t, uint16_t>& _var_map_long_ushort)
    {
        m_var_map_long_ushort = _var_map_long_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_long_ushort
     * @param _var_map_long_ushort New value to be moved in member var_map_long_ushort
     */
    eProsima_user_DllExport void var_map_long_ushort(
            std::map<int32_t, uint16_t>&& _var_map_long_ushort)
    {
        m_var_map_long_ushort = std::move(_var_map_long_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_ushort
     * @return Constant reference to member var_map_long_ushort
     */
    eProsima_user_DllExport const std::map<int32_t, uint16_t>& var_map_long_ushort() const
    {
        return m_var_map_long_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_ushort
     * @return Reference to member var_map_long_ushort
     */
    eProsima_user_DllExport std::map<int32_t, uint16_t>& var_map_long_ushort()
    {
        return m_var_map_long_ushort;
    }



private:

    std::map<int32_t, uint16_t> m_var_map_long_ushort;

};
/*!
 * @brief This class represents the structure MapLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLong(
            const MapLongLong& x)
    {
                    m_var_map_long_long = x.m_var_map_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLong(
            MapLongLong&& x) noexcept
    {
        m_var_map_long_long = std::move(x.m_var_map_long_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLong& operator =(
            const MapLongLong& x)
    {

                    m_var_map_long_long = x.m_var_map_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLong& operator =(
            MapLongLong&& x) noexcept
    {

        m_var_map_long_long = std::move(x.m_var_map_long_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLong& x) const
    {
        return (m_var_map_long_long == x.m_var_map_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_long
     * @param _var_map_long_long New value to be copied in member var_map_long_long
     */
    eProsima_user_DllExport void var_map_long_long(
            const std::map<int32_t, int32_t>& _var_map_long_long)
    {
        m_var_map_long_long = _var_map_long_long;
    }

    /*!
     * @brief This function moves the value in member var_map_long_long
     * @param _var_map_long_long New value to be moved in member var_map_long_long
     */
    eProsima_user_DllExport void var_map_long_long(
            std::map<int32_t, int32_t>&& _var_map_long_long)
    {
        m_var_map_long_long = std::move(_var_map_long_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_long
     * @return Constant reference to member var_map_long_long
     */
    eProsima_user_DllExport const std::map<int32_t, int32_t>& var_map_long_long() const
    {
        return m_var_map_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_long
     * @return Reference to member var_map_long_long
     */
    eProsima_user_DllExport std::map<int32_t, int32_t>& var_map_long_long()
    {
        return m_var_map_long_long;
    }



private:

    std::map<int32_t, int32_t> m_var_map_long_long;

};
/*!
 * @brief This class represents the structure MapLongULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongULong(
            const MapLongULong& x)
    {
                    m_var_map_long_ulong = x.m_var_map_long_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongULong(
            MapLongULong&& x) noexcept
    {
        m_var_map_long_ulong = std::move(x.m_var_map_long_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongULong& operator =(
            const MapLongULong& x)
    {

                    m_var_map_long_ulong = x.m_var_map_long_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongULong& operator =(
            MapLongULong&& x) noexcept
    {

        m_var_map_long_ulong = std::move(x.m_var_map_long_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongULong& x) const
    {
        return (m_var_map_long_ulong == x.m_var_map_long_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_ulong
     * @param _var_map_long_ulong New value to be copied in member var_map_long_ulong
     */
    eProsima_user_DllExport void var_map_long_ulong(
            const std::map<int32_t, uint32_t>& _var_map_long_ulong)
    {
        m_var_map_long_ulong = _var_map_long_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_long_ulong
     * @param _var_map_long_ulong New value to be moved in member var_map_long_ulong
     */
    eProsima_user_DllExport void var_map_long_ulong(
            std::map<int32_t, uint32_t>&& _var_map_long_ulong)
    {
        m_var_map_long_ulong = std::move(_var_map_long_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_ulong
     * @return Constant reference to member var_map_long_ulong
     */
    eProsima_user_DllExport const std::map<int32_t, uint32_t>& var_map_long_ulong() const
    {
        return m_var_map_long_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_ulong
     * @return Reference to member var_map_long_ulong
     */
    eProsima_user_DllExport std::map<int32_t, uint32_t>& var_map_long_ulong()
    {
        return m_var_map_long_ulong;
    }



private:

    std::map<int32_t, uint32_t> m_var_map_long_ulong;

};
/*!
 * @brief This class represents the structure MapLongKeyLongLongValue defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongKeyLongLongValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongKeyLongLongValue()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongKeyLongLongValue()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongKeyLongLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongLongValue(
            const MapLongKeyLongLongValue& x)
    {
                    m_var_map_long_longlong = x.m_var_map_long_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongKeyLongLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongLongValue(
            MapLongKeyLongLongValue&& x) noexcept
    {
        m_var_map_long_longlong = std::move(x.m_var_map_long_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongKeyLongLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongLongValue& operator =(
            const MapLongKeyLongLongValue& x)
    {

                    m_var_map_long_longlong = x.m_var_map_long_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongKeyLongLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongLongValue& operator =(
            MapLongKeyLongLongValue&& x) noexcept
    {

        m_var_map_long_longlong = std::move(x.m_var_map_long_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongKeyLongLongValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongKeyLongLongValue& x) const
    {
        return (m_var_map_long_longlong == x.m_var_map_long_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongKeyLongLongValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongKeyLongLongValue& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_longlong
     * @param _var_map_long_longlong New value to be copied in member var_map_long_longlong
     */
    eProsima_user_DllExport void var_map_long_longlong(
            const std::map<int32_t, int64_t>& _var_map_long_longlong)
    {
        m_var_map_long_longlong = _var_map_long_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_long_longlong
     * @param _var_map_long_longlong New value to be moved in member var_map_long_longlong
     */
    eProsima_user_DllExport void var_map_long_longlong(
            std::map<int32_t, int64_t>&& _var_map_long_longlong)
    {
        m_var_map_long_longlong = std::move(_var_map_long_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_longlong
     * @return Constant reference to member var_map_long_longlong
     */
    eProsima_user_DllExport const std::map<int32_t, int64_t>& var_map_long_longlong() const
    {
        return m_var_map_long_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_longlong
     * @return Reference to member var_map_long_longlong
     */
    eProsima_user_DllExport std::map<int32_t, int64_t>& var_map_long_longlong()
    {
        return m_var_map_long_longlong;
    }



private:

    std::map<int32_t, int64_t> m_var_map_long_longlong;

};
/*!
 * @brief This class represents the structure MapLongULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongULongLong(
            const MapLongULongLong& x)
    {
                    m_var_map_long_ulonglong = x.m_var_map_long_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongULongLong(
            MapLongULongLong&& x) noexcept
    {
        m_var_map_long_ulonglong = std::move(x.m_var_map_long_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongULongLong& operator =(
            const MapLongULongLong& x)
    {

                    m_var_map_long_ulonglong = x.m_var_map_long_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongULongLong& operator =(
            MapLongULongLong&& x) noexcept
    {

        m_var_map_long_ulonglong = std::move(x.m_var_map_long_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongULongLong& x) const
    {
        return (m_var_map_long_ulonglong == x.m_var_map_long_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_ulonglong
     * @param _var_map_long_ulonglong New value to be copied in member var_map_long_ulonglong
     */
    eProsima_user_DllExport void var_map_long_ulonglong(
            const std::map<int32_t, uint64_t>& _var_map_long_ulonglong)
    {
        m_var_map_long_ulonglong = _var_map_long_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_long_ulonglong
     * @param _var_map_long_ulonglong New value to be moved in member var_map_long_ulonglong
     */
    eProsima_user_DllExport void var_map_long_ulonglong(
            std::map<int32_t, uint64_t>&& _var_map_long_ulonglong)
    {
        m_var_map_long_ulonglong = std::move(_var_map_long_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_ulonglong
     * @return Constant reference to member var_map_long_ulonglong
     */
    eProsima_user_DllExport const std::map<int32_t, uint64_t>& var_map_long_ulonglong() const
    {
        return m_var_map_long_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_ulonglong
     * @return Reference to member var_map_long_ulonglong
     */
    eProsima_user_DllExport std::map<int32_t, uint64_t>& var_map_long_ulonglong()
    {
        return m_var_map_long_ulonglong;
    }



private:

    std::map<int32_t, uint64_t> m_var_map_long_ulonglong;

};
/*!
 * @brief This class represents the structure MapLongFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongFloat(
            const MapLongFloat& x)
    {
                    m_var_map_long_float = x.m_var_map_long_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongFloat(
            MapLongFloat&& x) noexcept
    {
        m_var_map_long_float = std::move(x.m_var_map_long_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongFloat& operator =(
            const MapLongFloat& x)
    {

                    m_var_map_long_float = x.m_var_map_long_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongFloat& operator =(
            MapLongFloat&& x) noexcept
    {

        m_var_map_long_float = std::move(x.m_var_map_long_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongFloat& x) const
    {
        return (m_var_map_long_float == x.m_var_map_long_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_float
     * @param _var_map_long_float New value to be copied in member var_map_long_float
     */
    eProsima_user_DllExport void var_map_long_float(
            const std::map<int32_t, float>& _var_map_long_float)
    {
        m_var_map_long_float = _var_map_long_float;
    }

    /*!
     * @brief This function moves the value in member var_map_long_float
     * @param _var_map_long_float New value to be moved in member var_map_long_float
     */
    eProsima_user_DllExport void var_map_long_float(
            std::map<int32_t, float>&& _var_map_long_float)
    {
        m_var_map_long_float = std::move(_var_map_long_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_float
     * @return Constant reference to member var_map_long_float
     */
    eProsima_user_DllExport const std::map<int32_t, float>& var_map_long_float() const
    {
        return m_var_map_long_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_float
     * @return Reference to member var_map_long_float
     */
    eProsima_user_DllExport std::map<int32_t, float>& var_map_long_float()
    {
        return m_var_map_long_float;
    }



private:

    std::map<int32_t, float> m_var_map_long_float;

};
/*!
 * @brief This class represents the structure MapLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongDouble(
            const MapLongDouble& x)
    {
                    m_var_map_long_double = x.m_var_map_long_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongDouble(
            MapLongDouble&& x) noexcept
    {
        m_var_map_long_double = std::move(x.m_var_map_long_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongDouble& operator =(
            const MapLongDouble& x)
    {

                    m_var_map_long_double = x.m_var_map_long_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongDouble& operator =(
            MapLongDouble&& x) noexcept
    {

        m_var_map_long_double = std::move(x.m_var_map_long_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongDouble& x) const
    {
        return (m_var_map_long_double == x.m_var_map_long_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_double
     * @param _var_map_long_double New value to be copied in member var_map_long_double
     */
    eProsima_user_DllExport void var_map_long_double(
            const std::map<int32_t, double>& _var_map_long_double)
    {
        m_var_map_long_double = _var_map_long_double;
    }

    /*!
     * @brief This function moves the value in member var_map_long_double
     * @param _var_map_long_double New value to be moved in member var_map_long_double
     */
    eProsima_user_DllExport void var_map_long_double(
            std::map<int32_t, double>&& _var_map_long_double)
    {
        m_var_map_long_double = std::move(_var_map_long_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_double
     * @return Constant reference to member var_map_long_double
     */
    eProsima_user_DllExport const std::map<int32_t, double>& var_map_long_double() const
    {
        return m_var_map_long_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_double
     * @return Reference to member var_map_long_double
     */
    eProsima_user_DllExport std::map<int32_t, double>& var_map_long_double()
    {
        return m_var_map_long_double;
    }



private:

    std::map<int32_t, double> m_var_map_long_double;

};
/*!
 * @brief This class represents the structure MapLongKeyLongDoubleValue defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongKeyLongDoubleValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongKeyLongDoubleValue()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongKeyLongDoubleValue()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongKeyLongDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongDoubleValue(
            const MapLongKeyLongDoubleValue& x)
    {
                    m_var_map_long_longdouble = x.m_var_map_long_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongKeyLongDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongDoubleValue(
            MapLongKeyLongDoubleValue&& x) noexcept
    {
        m_var_map_long_longdouble = std::move(x.m_var_map_long_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongKeyLongDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongDoubleValue& operator =(
            const MapLongKeyLongDoubleValue& x)
    {

                    m_var_map_long_longdouble = x.m_var_map_long_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongKeyLongDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongKeyLongDoubleValue& operator =(
            MapLongKeyLongDoubleValue&& x) noexcept
    {

        m_var_map_long_longdouble = std::move(x.m_var_map_long_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongKeyLongDoubleValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongKeyLongDoubleValue& x) const
    {
        return (m_var_map_long_longdouble == x.m_var_map_long_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongKeyLongDoubleValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongKeyLongDoubleValue& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_longdouble
     * @param _var_map_long_longdouble New value to be copied in member var_map_long_longdouble
     */
    eProsima_user_DllExport void var_map_long_longdouble(
            const std::map<int32_t, long double>& _var_map_long_longdouble)
    {
        m_var_map_long_longdouble = _var_map_long_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_long_longdouble
     * @param _var_map_long_longdouble New value to be moved in member var_map_long_longdouble
     */
    eProsima_user_DllExport void var_map_long_longdouble(
            std::map<int32_t, long double>&& _var_map_long_longdouble)
    {
        m_var_map_long_longdouble = std::move(_var_map_long_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_longdouble
     * @return Constant reference to member var_map_long_longdouble
     */
    eProsima_user_DllExport const std::map<int32_t, long double>& var_map_long_longdouble() const
    {
        return m_var_map_long_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_longdouble
     * @return Reference to member var_map_long_longdouble
     */
    eProsima_user_DllExport std::map<int32_t, long double>& var_map_long_longdouble()
    {
        return m_var_map_long_longdouble;
    }



private:

    std::map<int32_t, long double> m_var_map_long_longdouble;

};
/*!
 * @brief This class represents the structure MapLongBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongBoolean(
            const MapLongBoolean& x)
    {
                    m_var_map_long_boolean = x.m_var_map_long_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongBoolean(
            MapLongBoolean&& x) noexcept
    {
        m_var_map_long_boolean = std::move(x.m_var_map_long_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongBoolean& operator =(
            const MapLongBoolean& x)
    {

                    m_var_map_long_boolean = x.m_var_map_long_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongBoolean& operator =(
            MapLongBoolean&& x) noexcept
    {

        m_var_map_long_boolean = std::move(x.m_var_map_long_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongBoolean& x) const
    {
        return (m_var_map_long_boolean == x.m_var_map_long_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_boolean
     * @param _var_map_long_boolean New value to be copied in member var_map_long_boolean
     */
    eProsima_user_DllExport void var_map_long_boolean(
            const std::map<int32_t, bool>& _var_map_long_boolean)
    {
        m_var_map_long_boolean = _var_map_long_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_long_boolean
     * @param _var_map_long_boolean New value to be moved in member var_map_long_boolean
     */
    eProsima_user_DllExport void var_map_long_boolean(
            std::map<int32_t, bool>&& _var_map_long_boolean)
    {
        m_var_map_long_boolean = std::move(_var_map_long_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_boolean
     * @return Constant reference to member var_map_long_boolean
     */
    eProsima_user_DllExport const std::map<int32_t, bool>& var_map_long_boolean() const
    {
        return m_var_map_long_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_boolean
     * @return Reference to member var_map_long_boolean
     */
    eProsima_user_DllExport std::map<int32_t, bool>& var_map_long_boolean()
    {
        return m_var_map_long_boolean;
    }



private:

    std::map<int32_t, bool> m_var_map_long_boolean;

};
/*!
 * @brief This class represents the structure MapLongOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongOctet(
            const MapLongOctet& x)
    {
                    m_var_map_long_octet = x.m_var_map_long_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongOctet(
            MapLongOctet&& x) noexcept
    {
        m_var_map_long_octet = std::move(x.m_var_map_long_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongOctet& operator =(
            const MapLongOctet& x)
    {

                    m_var_map_long_octet = x.m_var_map_long_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongOctet& operator =(
            MapLongOctet&& x) noexcept
    {

        m_var_map_long_octet = std::move(x.m_var_map_long_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongOctet& x) const
    {
        return (m_var_map_long_octet == x.m_var_map_long_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_octet
     * @param _var_map_long_octet New value to be copied in member var_map_long_octet
     */
    eProsima_user_DllExport void var_map_long_octet(
            const std::map<int32_t, uint8_t>& _var_map_long_octet)
    {
        m_var_map_long_octet = _var_map_long_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_long_octet
     * @param _var_map_long_octet New value to be moved in member var_map_long_octet
     */
    eProsima_user_DllExport void var_map_long_octet(
            std::map<int32_t, uint8_t>&& _var_map_long_octet)
    {
        m_var_map_long_octet = std::move(_var_map_long_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_octet
     * @return Constant reference to member var_map_long_octet
     */
    eProsima_user_DllExport const std::map<int32_t, uint8_t>& var_map_long_octet() const
    {
        return m_var_map_long_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_octet
     * @return Reference to member var_map_long_octet
     */
    eProsima_user_DllExport std::map<int32_t, uint8_t>& var_map_long_octet()
    {
        return m_var_map_long_octet;
    }



private:

    std::map<int32_t, uint8_t> m_var_map_long_octet;

};
/*!
 * @brief This class represents the structure MapLongChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongChar(
            const MapLongChar& x)
    {
                    m_var_map_long_char = x.m_var_map_long_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongChar(
            MapLongChar&& x) noexcept
    {
        m_var_map_long_char = std::move(x.m_var_map_long_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongChar& operator =(
            const MapLongChar& x)
    {

                    m_var_map_long_char = x.m_var_map_long_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongChar& operator =(
            MapLongChar&& x) noexcept
    {

        m_var_map_long_char = std::move(x.m_var_map_long_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongChar& x) const
    {
        return (m_var_map_long_char == x.m_var_map_long_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_char
     * @param _var_map_long_char New value to be copied in member var_map_long_char
     */
    eProsima_user_DllExport void var_map_long_char(
            const std::map<int32_t, char>& _var_map_long_char)
    {
        m_var_map_long_char = _var_map_long_char;
    }

    /*!
     * @brief This function moves the value in member var_map_long_char
     * @param _var_map_long_char New value to be moved in member var_map_long_char
     */
    eProsima_user_DllExport void var_map_long_char(
            std::map<int32_t, char>&& _var_map_long_char)
    {
        m_var_map_long_char = std::move(_var_map_long_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_char
     * @return Constant reference to member var_map_long_char
     */
    eProsima_user_DllExport const std::map<int32_t, char>& var_map_long_char() const
    {
        return m_var_map_long_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_char
     * @return Reference to member var_map_long_char
     */
    eProsima_user_DllExport std::map<int32_t, char>& var_map_long_char()
    {
        return m_var_map_long_char;
    }



private:

    std::map<int32_t, char> m_var_map_long_char;

};
/*!
 * @brief This class represents the structure MapLongWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongWChar(
            const MapLongWChar& x)
    {
                    m_var_map_long_wchar = x.m_var_map_long_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongWChar(
            MapLongWChar&& x) noexcept
    {
        m_var_map_long_wchar = std::move(x.m_var_map_long_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongWChar& operator =(
            const MapLongWChar& x)
    {

                    m_var_map_long_wchar = x.m_var_map_long_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongWChar& operator =(
            MapLongWChar&& x) noexcept
    {

        m_var_map_long_wchar = std::move(x.m_var_map_long_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongWChar& x) const
    {
        return (m_var_map_long_wchar == x.m_var_map_long_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_wchar
     * @param _var_map_long_wchar New value to be copied in member var_map_long_wchar
     */
    eProsima_user_DllExport void var_map_long_wchar(
            const std::map<int32_t, wchar_t>& _var_map_long_wchar)
    {
        m_var_map_long_wchar = _var_map_long_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_long_wchar
     * @param _var_map_long_wchar New value to be moved in member var_map_long_wchar
     */
    eProsima_user_DllExport void var_map_long_wchar(
            std::map<int32_t, wchar_t>&& _var_map_long_wchar)
    {
        m_var_map_long_wchar = std::move(_var_map_long_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_wchar
     * @return Constant reference to member var_map_long_wchar
     */
    eProsima_user_DllExport const std::map<int32_t, wchar_t>& var_map_long_wchar() const
    {
        return m_var_map_long_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_wchar
     * @return Reference to member var_map_long_wchar
     */
    eProsima_user_DllExport std::map<int32_t, wchar_t>& var_map_long_wchar()
    {
        return m_var_map_long_wchar;
    }



private:

    std::map<int32_t, wchar_t> m_var_map_long_wchar;

};
/*!
 * @brief This class represents the structure MapLongString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongString that will be copied.
     */
    eProsima_user_DllExport MapLongString(
            const MapLongString& x)
    {
                    m_var_map_long_string = x.m_var_map_long_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongString that will be copied.
     */
    eProsima_user_DllExport MapLongString(
            MapLongString&& x) noexcept
    {
        m_var_map_long_string = std::move(x.m_var_map_long_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongString that will be copied.
     */
    eProsima_user_DllExport MapLongString& operator =(
            const MapLongString& x)
    {

                    m_var_map_long_string = x.m_var_map_long_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongString that will be copied.
     */
    eProsima_user_DllExport MapLongString& operator =(
            MapLongString&& x) noexcept
    {

        m_var_map_long_string = std::move(x.m_var_map_long_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongString& x) const
    {
        return (m_var_map_long_string == x.m_var_map_long_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_string
     * @param _var_map_long_string New value to be copied in member var_map_long_string
     */
    eProsima_user_DllExport void var_map_long_string(
            const std::map<int32_t, std::string>& _var_map_long_string)
    {
        m_var_map_long_string = _var_map_long_string;
    }

    /*!
     * @brief This function moves the value in member var_map_long_string
     * @param _var_map_long_string New value to be moved in member var_map_long_string
     */
    eProsima_user_DllExport void var_map_long_string(
            std::map<int32_t, std::string>&& _var_map_long_string)
    {
        m_var_map_long_string = std::move(_var_map_long_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_string
     * @return Constant reference to member var_map_long_string
     */
    eProsima_user_DllExport const std::map<int32_t, std::string>& var_map_long_string() const
    {
        return m_var_map_long_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_string
     * @return Reference to member var_map_long_string
     */
    eProsima_user_DllExport std::map<int32_t, std::string>& var_map_long_string()
    {
        return m_var_map_long_string;
    }



private:

    std::map<int32_t, std::string> m_var_map_long_string;

};
/*!
 * @brief This class represents the structure MapLongWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongWString(
            const MapLongWString& x)
    {
                    m_var_map_long_wstring = x.m_var_map_long_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongWString(
            MapLongWString&& x) noexcept
    {
        m_var_map_long_wstring = std::move(x.m_var_map_long_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongWString& operator =(
            const MapLongWString& x)
    {

                    m_var_map_long_wstring = x.m_var_map_long_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongWString& operator =(
            MapLongWString&& x) noexcept
    {

        m_var_map_long_wstring = std::move(x.m_var_map_long_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongWString& x) const
    {
        return (m_var_map_long_wstring == x.m_var_map_long_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_wstring
     * @param _var_map_long_wstring New value to be copied in member var_map_long_wstring
     */
    eProsima_user_DllExport void var_map_long_wstring(
            const std::map<int32_t, std::wstring>& _var_map_long_wstring)
    {
        m_var_map_long_wstring = _var_map_long_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_long_wstring
     * @param _var_map_long_wstring New value to be moved in member var_map_long_wstring
     */
    eProsima_user_DllExport void var_map_long_wstring(
            std::map<int32_t, std::wstring>&& _var_map_long_wstring)
    {
        m_var_map_long_wstring = std::move(_var_map_long_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_wstring
     * @return Constant reference to member var_map_long_wstring
     */
    eProsima_user_DllExport const std::map<int32_t, std::wstring>& var_map_long_wstring() const
    {
        return m_var_map_long_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_wstring
     * @return Reference to member var_map_long_wstring
     */
    eProsima_user_DllExport std::map<int32_t, std::wstring>& var_map_long_wstring()
    {
        return m_var_map_long_wstring;
    }



private:

    std::map<int32_t, std::wstring> m_var_map_long_wstring;

};
/*!
 * @brief This class represents the structure MapLongInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedStringHelper(
            const MapLongInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_long_inneraliasboundedstringhelper = x.m_var_map_long_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedStringHelper(
            MapLongInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_long_inneraliasboundedstringhelper = std::move(x.m_var_map_long_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedStringHelper& operator =(
            const MapLongInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_long_inneraliasboundedstringhelper = x.m_var_map_long_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedStringHelper& operator =(
            MapLongInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_long_inneraliasboundedstringhelper = std::move(x.m_var_map_long_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_long_inneraliasboundedstringhelper == x.m_var_map_long_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_inneraliasboundedstringhelper
     * @param _var_map_long_inneraliasboundedstringhelper New value to be copied in member var_map_long_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasboundedstringhelper(
            const std::map<int32_t, Inner_alias_bounded_string_helper>& _var_map_long_inneraliasboundedstringhelper)
    {
        m_var_map_long_inneraliasboundedstringhelper = _var_map_long_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_inneraliasboundedstringhelper
     * @param _var_map_long_inneraliasboundedstringhelper New value to be moved in member var_map_long_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasboundedstringhelper(
            std::map<int32_t, Inner_alias_bounded_string_helper>&& _var_map_long_inneraliasboundedstringhelper)
    {
        m_var_map_long_inneraliasboundedstringhelper = std::move(_var_map_long_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_long_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<int32_t, Inner_alias_bounded_string_helper>& var_map_long_inneraliasboundedstringhelper() const
    {
        return m_var_map_long_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_inneraliasboundedstringhelper
     * @return Reference to member var_map_long_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<int32_t, Inner_alias_bounded_string_helper>& var_map_long_inneraliasboundedstringhelper()
    {
        return m_var_map_long_inneraliasboundedstringhelper;
    }



private:

    std::map<int32_t, Inner_alias_bounded_string_helper> m_var_map_long_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapLongInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedWStringHelper(
            const MapLongInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_long_inneraliasboundedwstringhelper = x.m_var_map_long_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedWStringHelper(
            MapLongInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_long_inneraliasboundedwstringhelper = std::move(x.m_var_map_long_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedWStringHelper& operator =(
            const MapLongInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_long_inneraliasboundedwstringhelper = x.m_var_map_long_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasBoundedWStringHelper& operator =(
            MapLongInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_long_inneraliasboundedwstringhelper = std::move(x.m_var_map_long_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_long_inneraliasboundedwstringhelper == x.m_var_map_long_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_inneraliasboundedwstringhelper
     * @param _var_map_long_inneraliasboundedwstringhelper New value to be copied in member var_map_long_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasboundedwstringhelper(
            const std::map<int32_t, Inner_alias_bounded_wstring_helper>& _var_map_long_inneraliasboundedwstringhelper)
    {
        m_var_map_long_inneraliasboundedwstringhelper = _var_map_long_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_inneraliasboundedwstringhelper
     * @param _var_map_long_inneraliasboundedwstringhelper New value to be moved in member var_map_long_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasboundedwstringhelper(
            std::map<int32_t, Inner_alias_bounded_wstring_helper>&& _var_map_long_inneraliasboundedwstringhelper)
    {
        m_var_map_long_inneraliasboundedwstringhelper = std::move(_var_map_long_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_long_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<int32_t, Inner_alias_bounded_wstring_helper>& var_map_long_inneraliasboundedwstringhelper() const
    {
        return m_var_map_long_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_inneraliasboundedwstringhelper
     * @return Reference to member var_map_long_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<int32_t, Inner_alias_bounded_wstring_helper>& var_map_long_inneraliasboundedwstringhelper()
    {
        return m_var_map_long_inneraliasboundedwstringhelper;
    }



private:

    std::map<int32_t, Inner_alias_bounded_wstring_helper> m_var_map_long_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapLongInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerEnumHelper(
            const MapLongInnerEnumHelper& x)
    {
                    m_var_map_long_innerenumhelper = x.m_var_map_long_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerEnumHelper(
            MapLongInnerEnumHelper&& x) noexcept
    {
        m_var_map_long_innerenumhelper = std::move(x.m_var_map_long_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerEnumHelper& operator =(
            const MapLongInnerEnumHelper& x)
    {

                    m_var_map_long_innerenumhelper = x.m_var_map_long_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerEnumHelper& operator =(
            MapLongInnerEnumHelper&& x) noexcept
    {

        m_var_map_long_innerenumhelper = std::move(x.m_var_map_long_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerEnumHelper& x) const
    {
        return (m_var_map_long_innerenumhelper == x.m_var_map_long_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_innerenumhelper
     * @param _var_map_long_innerenumhelper New value to be copied in member var_map_long_innerenumhelper
     */
    eProsima_user_DllExport void var_map_long_innerenumhelper(
            const std::map<int32_t, InnerEnumHelper>& _var_map_long_innerenumhelper)
    {
        m_var_map_long_innerenumhelper = _var_map_long_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_innerenumhelper
     * @param _var_map_long_innerenumhelper New value to be moved in member var_map_long_innerenumhelper
     */
    eProsima_user_DllExport void var_map_long_innerenumhelper(
            std::map<int32_t, InnerEnumHelper>&& _var_map_long_innerenumhelper)
    {
        m_var_map_long_innerenumhelper = std::move(_var_map_long_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_innerenumhelper
     * @return Constant reference to member var_map_long_innerenumhelper
     */
    eProsima_user_DllExport const std::map<int32_t, InnerEnumHelper>& var_map_long_innerenumhelper() const
    {
        return m_var_map_long_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_innerenumhelper
     * @return Reference to member var_map_long_innerenumhelper
     */
    eProsima_user_DllExport std::map<int32_t, InnerEnumHelper>& var_map_long_innerenumhelper()
    {
        return m_var_map_long_innerenumhelper;
    }



private:

    std::map<int32_t, InnerEnumHelper> m_var_map_long_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapLongInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitMaskHelper(
            const MapLongInnerBitMaskHelper& x)
    {
                    m_var_map_long_innerbitmaskhelper = x.m_var_map_long_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitMaskHelper(
            MapLongInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_long_innerbitmaskhelper = std::move(x.m_var_map_long_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitMaskHelper& operator =(
            const MapLongInnerBitMaskHelper& x)
    {

                    m_var_map_long_innerbitmaskhelper = x.m_var_map_long_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitMaskHelper& operator =(
            MapLongInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_long_innerbitmaskhelper = std::move(x.m_var_map_long_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerBitMaskHelper& x) const
    {
        return (m_var_map_long_innerbitmaskhelper == x.m_var_map_long_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_innerbitmaskhelper
     * @param _var_map_long_innerbitmaskhelper New value to be copied in member var_map_long_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_long_innerbitmaskhelper(
            const std::map<int32_t, InnerBitMaskHelper>& _var_map_long_innerbitmaskhelper)
    {
        m_var_map_long_innerbitmaskhelper = _var_map_long_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_innerbitmaskhelper
     * @param _var_map_long_innerbitmaskhelper New value to be moved in member var_map_long_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_long_innerbitmaskhelper(
            std::map<int32_t, InnerBitMaskHelper>&& _var_map_long_innerbitmaskhelper)
    {
        m_var_map_long_innerbitmaskhelper = std::move(_var_map_long_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_innerbitmaskhelper
     * @return Constant reference to member var_map_long_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<int32_t, InnerBitMaskHelper>& var_map_long_innerbitmaskhelper() const
    {
        return m_var_map_long_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_innerbitmaskhelper
     * @return Reference to member var_map_long_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<int32_t, InnerBitMaskHelper>& var_map_long_innerbitmaskhelper()
    {
        return m_var_map_long_innerbitmaskhelper;
    }



private:

    std::map<int32_t, InnerBitMaskHelper> m_var_map_long_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapLongInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasHelper(
            const MapLongInnerAliasHelper& x)
    {
                    m_var_map_long_inneraliashelper = x.m_var_map_long_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasHelper(
            MapLongInnerAliasHelper&& x) noexcept
    {
        m_var_map_long_inneraliashelper = std::move(x.m_var_map_long_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasHelper& operator =(
            const MapLongInnerAliasHelper& x)
    {

                    m_var_map_long_inneraliashelper = x.m_var_map_long_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasHelper& operator =(
            MapLongInnerAliasHelper&& x) noexcept
    {

        m_var_map_long_inneraliashelper = std::move(x.m_var_map_long_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerAliasHelper& x) const
    {
        return (m_var_map_long_inneraliashelper == x.m_var_map_long_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_inneraliashelper
     * @param _var_map_long_inneraliashelper New value to be copied in member var_map_long_inneraliashelper
     */
    eProsima_user_DllExport void var_map_long_inneraliashelper(
            const std::map<int32_t, InnerAliasHelper>& _var_map_long_inneraliashelper)
    {
        m_var_map_long_inneraliashelper = _var_map_long_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_inneraliashelper
     * @param _var_map_long_inneraliashelper New value to be moved in member var_map_long_inneraliashelper
     */
    eProsima_user_DllExport void var_map_long_inneraliashelper(
            std::map<int32_t, InnerAliasHelper>&& _var_map_long_inneraliashelper)
    {
        m_var_map_long_inneraliashelper = std::move(_var_map_long_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_inneraliashelper
     * @return Constant reference to member var_map_long_inneraliashelper
     */
    eProsima_user_DllExport const std::map<int32_t, InnerAliasHelper>& var_map_long_inneraliashelper() const
    {
        return m_var_map_long_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_inneraliashelper
     * @return Reference to member var_map_long_inneraliashelper
     */
    eProsima_user_DllExport std::map<int32_t, InnerAliasHelper>& var_map_long_inneraliashelper()
    {
        return m_var_map_long_inneraliashelper;
    }



private:

    std::map<int32_t, InnerAliasHelper> m_var_map_long_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapLongInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasArrayHelper(
            const MapLongInnerAliasArrayHelper& x)
    {
                    m_var_map_long_inneraliasarrayhelper = x.m_var_map_long_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasArrayHelper(
            MapLongInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_long_inneraliasarrayhelper = std::move(x.m_var_map_long_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasArrayHelper& operator =(
            const MapLongInnerAliasArrayHelper& x)
    {

                    m_var_map_long_inneraliasarrayhelper = x.m_var_map_long_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasArrayHelper& operator =(
            MapLongInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_long_inneraliasarrayhelper = std::move(x.m_var_map_long_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerAliasArrayHelper& x) const
    {
        return (m_var_map_long_inneraliasarrayhelper == x.m_var_map_long_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_inneraliasarrayhelper
     * @param _var_map_long_inneraliasarrayhelper New value to be copied in member var_map_long_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasarrayhelper(
            const std::map<int32_t, Inner_alias_array_helper>& _var_map_long_inneraliasarrayhelper)
    {
        m_var_map_long_inneraliasarrayhelper = _var_map_long_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_inneraliasarrayhelper
     * @param _var_map_long_inneraliasarrayhelper New value to be moved in member var_map_long_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasarrayhelper(
            std::map<int32_t, Inner_alias_array_helper>&& _var_map_long_inneraliasarrayhelper)
    {
        m_var_map_long_inneraliasarrayhelper = std::move(_var_map_long_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_inneraliasarrayhelper
     * @return Constant reference to member var_map_long_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<int32_t, Inner_alias_array_helper>& var_map_long_inneraliasarrayhelper() const
    {
        return m_var_map_long_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_inneraliasarrayhelper
     * @return Reference to member var_map_long_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<int32_t, Inner_alias_array_helper>& var_map_long_inneraliasarrayhelper()
    {
        return m_var_map_long_inneraliasarrayhelper;
    }



private:

    std::map<int32_t, Inner_alias_array_helper> m_var_map_long_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapLongInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasSequenceHelper(
            const MapLongInnerAliasSequenceHelper& x)
    {
                    m_var_map_long_inneraliassequencehelper = x.m_var_map_long_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasSequenceHelper(
            MapLongInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_long_inneraliassequencehelper = std::move(x.m_var_map_long_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasSequenceHelper& operator =(
            const MapLongInnerAliasSequenceHelper& x)
    {

                    m_var_map_long_inneraliassequencehelper = x.m_var_map_long_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasSequenceHelper& operator =(
            MapLongInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_long_inneraliassequencehelper = std::move(x.m_var_map_long_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_long_inneraliassequencehelper == x.m_var_map_long_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_inneraliassequencehelper
     * @param _var_map_long_inneraliassequencehelper New value to be copied in member var_map_long_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_long_inneraliassequencehelper(
            const std::map<int32_t, Inner_alias_sequence_helper>& _var_map_long_inneraliassequencehelper)
    {
        m_var_map_long_inneraliassequencehelper = _var_map_long_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_inneraliassequencehelper
     * @param _var_map_long_inneraliassequencehelper New value to be moved in member var_map_long_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_long_inneraliassequencehelper(
            std::map<int32_t, Inner_alias_sequence_helper>&& _var_map_long_inneraliassequencehelper)
    {
        m_var_map_long_inneraliassequencehelper = std::move(_var_map_long_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_inneraliassequencehelper
     * @return Constant reference to member var_map_long_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<int32_t, Inner_alias_sequence_helper>& var_map_long_inneraliassequencehelper() const
    {
        return m_var_map_long_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_inneraliassequencehelper
     * @return Reference to member var_map_long_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<int32_t, Inner_alias_sequence_helper>& var_map_long_inneraliassequencehelper()
    {
        return m_var_map_long_inneraliassequencehelper;
    }



private:

    std::map<int32_t, Inner_alias_sequence_helper> m_var_map_long_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapLongInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasMapHelper(
            const MapLongInnerAliasMapHelper& x)
    {
                    m_var_map_long_inneraliasmaphelper = x.m_var_map_long_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasMapHelper(
            MapLongInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_long_inneraliasmaphelper = std::move(x.m_var_map_long_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasMapHelper& operator =(
            const MapLongInnerAliasMapHelper& x)
    {

                    m_var_map_long_inneraliasmaphelper = x.m_var_map_long_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerAliasMapHelper& operator =(
            MapLongInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_long_inneraliasmaphelper = std::move(x.m_var_map_long_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerAliasMapHelper& x) const
    {
        return (m_var_map_long_inneraliasmaphelper == x.m_var_map_long_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_inneraliasmaphelper
     * @param _var_map_long_inneraliasmaphelper New value to be copied in member var_map_long_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasmaphelper(
            const std::map<int32_t, Inner_alias_map_helper>& _var_map_long_inneraliasmaphelper)
    {
        m_var_map_long_inneraliasmaphelper = _var_map_long_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_inneraliasmaphelper
     * @param _var_map_long_inneraliasmaphelper New value to be moved in member var_map_long_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_long_inneraliasmaphelper(
            std::map<int32_t, Inner_alias_map_helper>&& _var_map_long_inneraliasmaphelper)
    {
        m_var_map_long_inneraliasmaphelper = std::move(_var_map_long_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_inneraliasmaphelper
     * @return Constant reference to member var_map_long_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<int32_t, Inner_alias_map_helper>& var_map_long_inneraliasmaphelper() const
    {
        return m_var_map_long_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_inneraliasmaphelper
     * @return Reference to member var_map_long_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<int32_t, Inner_alias_map_helper>& var_map_long_inneraliasmaphelper()
    {
        return m_var_map_long_inneraliasmaphelper;
    }



private:

    std::map<int32_t, Inner_alias_map_helper> m_var_map_long_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapLongInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerUnionHelper(
            const MapLongInnerUnionHelper& x)
    {
                    m_var_map_long_innerunionhelper = x.m_var_map_long_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerUnionHelper(
            MapLongInnerUnionHelper&& x) noexcept
    {
        m_var_map_long_innerunionhelper = std::move(x.m_var_map_long_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerUnionHelper& operator =(
            const MapLongInnerUnionHelper& x)
    {

                    m_var_map_long_innerunionhelper = x.m_var_map_long_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerUnionHelper& operator =(
            MapLongInnerUnionHelper&& x) noexcept
    {

        m_var_map_long_innerunionhelper = std::move(x.m_var_map_long_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerUnionHelper& x) const
    {
        return (m_var_map_long_innerunionhelper == x.m_var_map_long_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_innerunionhelper
     * @param _var_map_long_innerunionhelper New value to be copied in member var_map_long_innerunionhelper
     */
    eProsima_user_DllExport void var_map_long_innerunionhelper(
            const std::map<int32_t, InnerUnionHelper>& _var_map_long_innerunionhelper)
    {
        m_var_map_long_innerunionhelper = _var_map_long_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_innerunionhelper
     * @param _var_map_long_innerunionhelper New value to be moved in member var_map_long_innerunionhelper
     */
    eProsima_user_DllExport void var_map_long_innerunionhelper(
            std::map<int32_t, InnerUnionHelper>&& _var_map_long_innerunionhelper)
    {
        m_var_map_long_innerunionhelper = std::move(_var_map_long_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_innerunionhelper
     * @return Constant reference to member var_map_long_innerunionhelper
     */
    eProsima_user_DllExport const std::map<int32_t, InnerUnionHelper>& var_map_long_innerunionhelper() const
    {
        return m_var_map_long_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_innerunionhelper
     * @return Reference to member var_map_long_innerunionhelper
     */
    eProsima_user_DllExport std::map<int32_t, InnerUnionHelper>& var_map_long_innerunionhelper()
    {
        return m_var_map_long_innerunionhelper;
    }



private:

    std::map<int32_t, InnerUnionHelper> m_var_map_long_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapLongInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerStructureHelper(
            const MapLongInnerStructureHelper& x)
    {
                    m_var_map_long_innerstructurehelper = x.m_var_map_long_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerStructureHelper(
            MapLongInnerStructureHelper&& x) noexcept
    {
        m_var_map_long_innerstructurehelper = std::move(x.m_var_map_long_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerStructureHelper& operator =(
            const MapLongInnerStructureHelper& x)
    {

                    m_var_map_long_innerstructurehelper = x.m_var_map_long_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerStructureHelper& operator =(
            MapLongInnerStructureHelper&& x) noexcept
    {

        m_var_map_long_innerstructurehelper = std::move(x.m_var_map_long_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerStructureHelper& x) const
    {
        return (m_var_map_long_innerstructurehelper == x.m_var_map_long_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_innerstructurehelper
     * @param _var_map_long_innerstructurehelper New value to be copied in member var_map_long_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_long_innerstructurehelper(
            const std::map<int32_t, InnerStructureHelper>& _var_map_long_innerstructurehelper)
    {
        m_var_map_long_innerstructurehelper = _var_map_long_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_innerstructurehelper
     * @param _var_map_long_innerstructurehelper New value to be moved in member var_map_long_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_long_innerstructurehelper(
            std::map<int32_t, InnerStructureHelper>&& _var_map_long_innerstructurehelper)
    {
        m_var_map_long_innerstructurehelper = std::move(_var_map_long_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_innerstructurehelper
     * @return Constant reference to member var_map_long_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<int32_t, InnerStructureHelper>& var_map_long_innerstructurehelper() const
    {
        return m_var_map_long_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_innerstructurehelper
     * @return Reference to member var_map_long_innerstructurehelper
     */
    eProsima_user_DllExport std::map<int32_t, InnerStructureHelper>& var_map_long_innerstructurehelper()
    {
        return m_var_map_long_innerstructurehelper;
    }



private:

    std::map<int32_t, InnerStructureHelper> m_var_map_long_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapLongInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitsetHelper(
            const MapLongInnerBitsetHelper& x)
    {
                    m_var_map_long_innerbitsethelper = x.m_var_map_long_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitsetHelper(
            MapLongInnerBitsetHelper&& x) noexcept
    {
        m_var_map_long_innerbitsethelper = std::move(x.m_var_map_long_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitsetHelper& operator =(
            const MapLongInnerBitsetHelper& x)
    {

                    m_var_map_long_innerbitsethelper = x.m_var_map_long_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongInnerBitsetHelper& operator =(
            MapLongInnerBitsetHelper&& x) noexcept
    {

        m_var_map_long_innerbitsethelper = std::move(x.m_var_map_long_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongInnerBitsetHelper& x) const
    {
        return (m_var_map_long_innerbitsethelper == x.m_var_map_long_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_long_innerbitsethelper
     * @param _var_map_long_innerbitsethelper New value to be copied in member var_map_long_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_long_innerbitsethelper(
            const std::map<int32_t, InnerBitsetHelper>& _var_map_long_innerbitsethelper)
    {
        m_var_map_long_innerbitsethelper = _var_map_long_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_long_innerbitsethelper
     * @param _var_map_long_innerbitsethelper New value to be moved in member var_map_long_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_long_innerbitsethelper(
            std::map<int32_t, InnerBitsetHelper>&& _var_map_long_innerbitsethelper)
    {
        m_var_map_long_innerbitsethelper = std::move(_var_map_long_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_long_innerbitsethelper
     * @return Constant reference to member var_map_long_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<int32_t, InnerBitsetHelper>& var_map_long_innerbitsethelper() const
    {
        return m_var_map_long_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_long_innerbitsethelper
     * @return Reference to member var_map_long_innerbitsethelper
     */
    eProsima_user_DllExport std::map<int32_t, InnerBitsetHelper>& var_map_long_innerbitsethelper()
    {
        return m_var_map_long_innerbitsethelper;
    }



private:

    std::map<int32_t, InnerBitsetHelper> m_var_map_long_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapULongShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongShort that will be copied.
     */
    eProsima_user_DllExport MapULongShort(
            const MapULongShort& x)
    {
                    m_var_map_ulong_short = x.m_var_map_ulong_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongShort that will be copied.
     */
    eProsima_user_DllExport MapULongShort(
            MapULongShort&& x) noexcept
    {
        m_var_map_ulong_short = std::move(x.m_var_map_ulong_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongShort that will be copied.
     */
    eProsima_user_DllExport MapULongShort& operator =(
            const MapULongShort& x)
    {

                    m_var_map_ulong_short = x.m_var_map_ulong_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongShort that will be copied.
     */
    eProsima_user_DllExport MapULongShort& operator =(
            MapULongShort&& x) noexcept
    {

        m_var_map_ulong_short = std::move(x.m_var_map_ulong_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongShort& x) const
    {
        return (m_var_map_ulong_short == x.m_var_map_ulong_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_short
     * @param _var_map_ulong_short New value to be copied in member var_map_ulong_short
     */
    eProsima_user_DllExport void var_map_ulong_short(
            const std::map<uint32_t, int16_t>& _var_map_ulong_short)
    {
        m_var_map_ulong_short = _var_map_ulong_short;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_short
     * @param _var_map_ulong_short New value to be moved in member var_map_ulong_short
     */
    eProsima_user_DllExport void var_map_ulong_short(
            std::map<uint32_t, int16_t>&& _var_map_ulong_short)
    {
        m_var_map_ulong_short = std::move(_var_map_ulong_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_short
     * @return Constant reference to member var_map_ulong_short
     */
    eProsima_user_DllExport const std::map<uint32_t, int16_t>& var_map_ulong_short() const
    {
        return m_var_map_ulong_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_short
     * @return Reference to member var_map_ulong_short
     */
    eProsima_user_DllExport std::map<uint32_t, int16_t>& var_map_ulong_short()
    {
        return m_var_map_ulong_short;
    }



private:

    std::map<uint32_t, int16_t> m_var_map_ulong_short;

};
/*!
 * @brief This class represents the structure MapULongUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongUShort(
            const MapULongUShort& x)
    {
                    m_var_map_ulong_ushort = x.m_var_map_ulong_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongUShort(
            MapULongUShort&& x) noexcept
    {
        m_var_map_ulong_ushort = std::move(x.m_var_map_ulong_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongUShort& operator =(
            const MapULongUShort& x)
    {

                    m_var_map_ulong_ushort = x.m_var_map_ulong_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongUShort& operator =(
            MapULongUShort&& x) noexcept
    {

        m_var_map_ulong_ushort = std::move(x.m_var_map_ulong_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongUShort& x) const
    {
        return (m_var_map_ulong_ushort == x.m_var_map_ulong_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_ushort
     * @param _var_map_ulong_ushort New value to be copied in member var_map_ulong_ushort
     */
    eProsima_user_DllExport void var_map_ulong_ushort(
            const std::map<uint32_t, uint16_t>& _var_map_ulong_ushort)
    {
        m_var_map_ulong_ushort = _var_map_ulong_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_ushort
     * @param _var_map_ulong_ushort New value to be moved in member var_map_ulong_ushort
     */
    eProsima_user_DllExport void var_map_ulong_ushort(
            std::map<uint32_t, uint16_t>&& _var_map_ulong_ushort)
    {
        m_var_map_ulong_ushort = std::move(_var_map_ulong_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_ushort
     * @return Constant reference to member var_map_ulong_ushort
     */
    eProsima_user_DllExport const std::map<uint32_t, uint16_t>& var_map_ulong_ushort() const
    {
        return m_var_map_ulong_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_ushort
     * @return Reference to member var_map_ulong_ushort
     */
    eProsima_user_DllExport std::map<uint32_t, uint16_t>& var_map_ulong_ushort()
    {
        return m_var_map_ulong_ushort;
    }



private:

    std::map<uint32_t, uint16_t> m_var_map_ulong_ushort;

};
/*!
 * @brief This class represents the structure MapULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLong(
            const MapULongLong& x)
    {
                    m_var_map_ulong_long = x.m_var_map_ulong_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLong(
            MapULongLong&& x) noexcept
    {
        m_var_map_ulong_long = std::move(x.m_var_map_ulong_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLong& operator =(
            const MapULongLong& x)
    {

                    m_var_map_ulong_long = x.m_var_map_ulong_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLong& operator =(
            MapULongLong&& x) noexcept
    {

        m_var_map_ulong_long = std::move(x.m_var_map_ulong_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLong& x) const
    {
        return (m_var_map_ulong_long == x.m_var_map_ulong_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_long
     * @param _var_map_ulong_long New value to be copied in member var_map_ulong_long
     */
    eProsima_user_DllExport void var_map_ulong_long(
            const std::map<uint32_t, int32_t>& _var_map_ulong_long)
    {
        m_var_map_ulong_long = _var_map_ulong_long;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_long
     * @param _var_map_ulong_long New value to be moved in member var_map_ulong_long
     */
    eProsima_user_DllExport void var_map_ulong_long(
            std::map<uint32_t, int32_t>&& _var_map_ulong_long)
    {
        m_var_map_ulong_long = std::move(_var_map_ulong_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_long
     * @return Constant reference to member var_map_ulong_long
     */
    eProsima_user_DllExport const std::map<uint32_t, int32_t>& var_map_ulong_long() const
    {
        return m_var_map_ulong_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_long
     * @return Reference to member var_map_ulong_long
     */
    eProsima_user_DllExport std::map<uint32_t, int32_t>& var_map_ulong_long()
    {
        return m_var_map_ulong_long;
    }



private:

    std::map<uint32_t, int32_t> m_var_map_ulong_long;

};
/*!
 * @brief This class represents the structure MapULongULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongULong that will be copied.
     */
    eProsima_user_DllExport MapULongULong(
            const MapULongULong& x)
    {
                    m_var_map_ulong_ulong = x.m_var_map_ulong_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongULong that will be copied.
     */
    eProsima_user_DllExport MapULongULong(
            MapULongULong&& x) noexcept
    {
        m_var_map_ulong_ulong = std::move(x.m_var_map_ulong_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongULong that will be copied.
     */
    eProsima_user_DllExport MapULongULong& operator =(
            const MapULongULong& x)
    {

                    m_var_map_ulong_ulong = x.m_var_map_ulong_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongULong that will be copied.
     */
    eProsima_user_DllExport MapULongULong& operator =(
            MapULongULong&& x) noexcept
    {

        m_var_map_ulong_ulong = std::move(x.m_var_map_ulong_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongULong& x) const
    {
        return (m_var_map_ulong_ulong == x.m_var_map_ulong_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_ulong
     * @param _var_map_ulong_ulong New value to be copied in member var_map_ulong_ulong
     */
    eProsima_user_DllExport void var_map_ulong_ulong(
            const std::map<uint32_t, uint32_t>& _var_map_ulong_ulong)
    {
        m_var_map_ulong_ulong = _var_map_ulong_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_ulong
     * @param _var_map_ulong_ulong New value to be moved in member var_map_ulong_ulong
     */
    eProsima_user_DllExport void var_map_ulong_ulong(
            std::map<uint32_t, uint32_t>&& _var_map_ulong_ulong)
    {
        m_var_map_ulong_ulong = std::move(_var_map_ulong_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_ulong
     * @return Constant reference to member var_map_ulong_ulong
     */
    eProsima_user_DllExport const std::map<uint32_t, uint32_t>& var_map_ulong_ulong() const
    {
        return m_var_map_ulong_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_ulong
     * @return Reference to member var_map_ulong_ulong
     */
    eProsima_user_DllExport std::map<uint32_t, uint32_t>& var_map_ulong_ulong()
    {
        return m_var_map_ulong_ulong;
    }



private:

    std::map<uint32_t, uint32_t> m_var_map_ulong_ulong;

};
/*!
 * @brief This class represents the structure MapKeyULongValueLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapKeyULongValueLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapKeyULongValueLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapKeyULongValueLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapKeyULongValueLongLong that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongLong(
            const MapKeyULongValueLongLong& x)
    {
                    m_var_map_ulong_longlong = x.m_var_map_ulong_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapKeyULongValueLongLong that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongLong(
            MapKeyULongValueLongLong&& x) noexcept
    {
        m_var_map_ulong_longlong = std::move(x.m_var_map_ulong_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapKeyULongValueLongLong that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongLong& operator =(
            const MapKeyULongValueLongLong& x)
    {

                    m_var_map_ulong_longlong = x.m_var_map_ulong_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapKeyULongValueLongLong that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongLong& operator =(
            MapKeyULongValueLongLong&& x) noexcept
    {

        m_var_map_ulong_longlong = std::move(x.m_var_map_ulong_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapKeyULongValueLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapKeyULongValueLongLong& x) const
    {
        return (m_var_map_ulong_longlong == x.m_var_map_ulong_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapKeyULongValueLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapKeyULongValueLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_longlong
     * @param _var_map_ulong_longlong New value to be copied in member var_map_ulong_longlong
     */
    eProsima_user_DllExport void var_map_ulong_longlong(
            const std::map<uint32_t, int64_t>& _var_map_ulong_longlong)
    {
        m_var_map_ulong_longlong = _var_map_ulong_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_longlong
     * @param _var_map_ulong_longlong New value to be moved in member var_map_ulong_longlong
     */
    eProsima_user_DllExport void var_map_ulong_longlong(
            std::map<uint32_t, int64_t>&& _var_map_ulong_longlong)
    {
        m_var_map_ulong_longlong = std::move(_var_map_ulong_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_longlong
     * @return Constant reference to member var_map_ulong_longlong
     */
    eProsima_user_DllExport const std::map<uint32_t, int64_t>& var_map_ulong_longlong() const
    {
        return m_var_map_ulong_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_longlong
     * @return Reference to member var_map_ulong_longlong
     */
    eProsima_user_DllExport std::map<uint32_t, int64_t>& var_map_ulong_longlong()
    {
        return m_var_map_ulong_longlong;
    }



private:

    std::map<uint32_t, int64_t> m_var_map_ulong_longlong;

};
/*!
 * @brief This class represents the structure MapULongULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongULongLong(
            const MapULongULongLong& x)
    {
                    m_var_map_ulong_ulonglong = x.m_var_map_ulong_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongULongLong(
            MapULongULongLong&& x) noexcept
    {
        m_var_map_ulong_ulonglong = std::move(x.m_var_map_ulong_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongULongLong& operator =(
            const MapULongULongLong& x)
    {

                    m_var_map_ulong_ulonglong = x.m_var_map_ulong_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongULongLong& operator =(
            MapULongULongLong&& x) noexcept
    {

        m_var_map_ulong_ulonglong = std::move(x.m_var_map_ulong_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongULongLong& x) const
    {
        return (m_var_map_ulong_ulonglong == x.m_var_map_ulong_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_ulonglong
     * @param _var_map_ulong_ulonglong New value to be copied in member var_map_ulong_ulonglong
     */
    eProsima_user_DllExport void var_map_ulong_ulonglong(
            const std::map<uint32_t, uint64_t>& _var_map_ulong_ulonglong)
    {
        m_var_map_ulong_ulonglong = _var_map_ulong_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_ulonglong
     * @param _var_map_ulong_ulonglong New value to be moved in member var_map_ulong_ulonglong
     */
    eProsima_user_DllExport void var_map_ulong_ulonglong(
            std::map<uint32_t, uint64_t>&& _var_map_ulong_ulonglong)
    {
        m_var_map_ulong_ulonglong = std::move(_var_map_ulong_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_ulonglong
     * @return Constant reference to member var_map_ulong_ulonglong
     */
    eProsima_user_DllExport const std::map<uint32_t, uint64_t>& var_map_ulong_ulonglong() const
    {
        return m_var_map_ulong_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_ulonglong
     * @return Reference to member var_map_ulong_ulonglong
     */
    eProsima_user_DllExport std::map<uint32_t, uint64_t>& var_map_ulong_ulonglong()
    {
        return m_var_map_ulong_ulonglong;
    }



private:

    std::map<uint32_t, uint64_t> m_var_map_ulong_ulonglong;

};
/*!
 * @brief This class represents the structure MapULongFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongFloat(
            const MapULongFloat& x)
    {
                    m_var_map_ulong_float = x.m_var_map_ulong_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongFloat(
            MapULongFloat&& x) noexcept
    {
        m_var_map_ulong_float = std::move(x.m_var_map_ulong_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongFloat& operator =(
            const MapULongFloat& x)
    {

                    m_var_map_ulong_float = x.m_var_map_ulong_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongFloat& operator =(
            MapULongFloat&& x) noexcept
    {

        m_var_map_ulong_float = std::move(x.m_var_map_ulong_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongFloat& x) const
    {
        return (m_var_map_ulong_float == x.m_var_map_ulong_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_float
     * @param _var_map_ulong_float New value to be copied in member var_map_ulong_float
     */
    eProsima_user_DllExport void var_map_ulong_float(
            const std::map<uint32_t, float>& _var_map_ulong_float)
    {
        m_var_map_ulong_float = _var_map_ulong_float;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_float
     * @param _var_map_ulong_float New value to be moved in member var_map_ulong_float
     */
    eProsima_user_DllExport void var_map_ulong_float(
            std::map<uint32_t, float>&& _var_map_ulong_float)
    {
        m_var_map_ulong_float = std::move(_var_map_ulong_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_float
     * @return Constant reference to member var_map_ulong_float
     */
    eProsima_user_DllExport const std::map<uint32_t, float>& var_map_ulong_float() const
    {
        return m_var_map_ulong_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_float
     * @return Reference to member var_map_ulong_float
     */
    eProsima_user_DllExport std::map<uint32_t, float>& var_map_ulong_float()
    {
        return m_var_map_ulong_float;
    }



private:

    std::map<uint32_t, float> m_var_map_ulong_float;

};
/*!
 * @brief This class represents the structure MapULongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongDouble(
            const MapULongDouble& x)
    {
                    m_var_map_ulong_double = x.m_var_map_ulong_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongDouble(
            MapULongDouble&& x) noexcept
    {
        m_var_map_ulong_double = std::move(x.m_var_map_ulong_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongDouble& operator =(
            const MapULongDouble& x)
    {

                    m_var_map_ulong_double = x.m_var_map_ulong_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongDouble& operator =(
            MapULongDouble&& x) noexcept
    {

        m_var_map_ulong_double = std::move(x.m_var_map_ulong_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongDouble& x) const
    {
        return (m_var_map_ulong_double == x.m_var_map_ulong_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_double
     * @param _var_map_ulong_double New value to be copied in member var_map_ulong_double
     */
    eProsima_user_DllExport void var_map_ulong_double(
            const std::map<uint32_t, double>& _var_map_ulong_double)
    {
        m_var_map_ulong_double = _var_map_ulong_double;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_double
     * @param _var_map_ulong_double New value to be moved in member var_map_ulong_double
     */
    eProsima_user_DllExport void var_map_ulong_double(
            std::map<uint32_t, double>&& _var_map_ulong_double)
    {
        m_var_map_ulong_double = std::move(_var_map_ulong_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_double
     * @return Constant reference to member var_map_ulong_double
     */
    eProsima_user_DllExport const std::map<uint32_t, double>& var_map_ulong_double() const
    {
        return m_var_map_ulong_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_double
     * @return Reference to member var_map_ulong_double
     */
    eProsima_user_DllExport std::map<uint32_t, double>& var_map_ulong_double()
    {
        return m_var_map_ulong_double;
    }



private:

    std::map<uint32_t, double> m_var_map_ulong_double;

};
/*!
 * @brief This class represents the structure MapKeyULongValueLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapKeyULongValueLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapKeyULongValueLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapKeyULongValueLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapKeyULongValueLongDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongDouble(
            const MapKeyULongValueLongDouble& x)
    {
                    m_var_map_ulong_longdouble = x.m_var_map_ulong_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapKeyULongValueLongDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongDouble(
            MapKeyULongValueLongDouble&& x) noexcept
    {
        m_var_map_ulong_longdouble = std::move(x.m_var_map_ulong_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapKeyULongValueLongDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongDouble& operator =(
            const MapKeyULongValueLongDouble& x)
    {

                    m_var_map_ulong_longdouble = x.m_var_map_ulong_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapKeyULongValueLongDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongValueLongDouble& operator =(
            MapKeyULongValueLongDouble&& x) noexcept
    {

        m_var_map_ulong_longdouble = std::move(x.m_var_map_ulong_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapKeyULongValueLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapKeyULongValueLongDouble& x) const
    {
        return (m_var_map_ulong_longdouble == x.m_var_map_ulong_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapKeyULongValueLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapKeyULongValueLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_longdouble
     * @param _var_map_ulong_longdouble New value to be copied in member var_map_ulong_longdouble
     */
    eProsima_user_DllExport void var_map_ulong_longdouble(
            const std::map<uint32_t, long double>& _var_map_ulong_longdouble)
    {
        m_var_map_ulong_longdouble = _var_map_ulong_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_longdouble
     * @param _var_map_ulong_longdouble New value to be moved in member var_map_ulong_longdouble
     */
    eProsima_user_DllExport void var_map_ulong_longdouble(
            std::map<uint32_t, long double>&& _var_map_ulong_longdouble)
    {
        m_var_map_ulong_longdouble = std::move(_var_map_ulong_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_longdouble
     * @return Constant reference to member var_map_ulong_longdouble
     */
    eProsima_user_DllExport const std::map<uint32_t, long double>& var_map_ulong_longdouble() const
    {
        return m_var_map_ulong_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_longdouble
     * @return Reference to member var_map_ulong_longdouble
     */
    eProsima_user_DllExport std::map<uint32_t, long double>& var_map_ulong_longdouble()
    {
        return m_var_map_ulong_longdouble;
    }



private:

    std::map<uint32_t, long double> m_var_map_ulong_longdouble;

};
/*!
 * @brief This class represents the structure MapULongBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongBoolean(
            const MapULongBoolean& x)
    {
                    m_var_map_ulong_boolean = x.m_var_map_ulong_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongBoolean(
            MapULongBoolean&& x) noexcept
    {
        m_var_map_ulong_boolean = std::move(x.m_var_map_ulong_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongBoolean& operator =(
            const MapULongBoolean& x)
    {

                    m_var_map_ulong_boolean = x.m_var_map_ulong_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongBoolean& operator =(
            MapULongBoolean&& x) noexcept
    {

        m_var_map_ulong_boolean = std::move(x.m_var_map_ulong_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongBoolean& x) const
    {
        return (m_var_map_ulong_boolean == x.m_var_map_ulong_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_boolean
     * @param _var_map_ulong_boolean New value to be copied in member var_map_ulong_boolean
     */
    eProsima_user_DllExport void var_map_ulong_boolean(
            const std::map<uint32_t, bool>& _var_map_ulong_boolean)
    {
        m_var_map_ulong_boolean = _var_map_ulong_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_boolean
     * @param _var_map_ulong_boolean New value to be moved in member var_map_ulong_boolean
     */
    eProsima_user_DllExport void var_map_ulong_boolean(
            std::map<uint32_t, bool>&& _var_map_ulong_boolean)
    {
        m_var_map_ulong_boolean = std::move(_var_map_ulong_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_boolean
     * @return Constant reference to member var_map_ulong_boolean
     */
    eProsima_user_DllExport const std::map<uint32_t, bool>& var_map_ulong_boolean() const
    {
        return m_var_map_ulong_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_boolean
     * @return Reference to member var_map_ulong_boolean
     */
    eProsima_user_DllExport std::map<uint32_t, bool>& var_map_ulong_boolean()
    {
        return m_var_map_ulong_boolean;
    }



private:

    std::map<uint32_t, bool> m_var_map_ulong_boolean;

};
/*!
 * @brief This class represents the structure MapULongOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongOctet(
            const MapULongOctet& x)
    {
                    m_var_map_ulong_octet = x.m_var_map_ulong_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongOctet(
            MapULongOctet&& x) noexcept
    {
        m_var_map_ulong_octet = std::move(x.m_var_map_ulong_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongOctet& operator =(
            const MapULongOctet& x)
    {

                    m_var_map_ulong_octet = x.m_var_map_ulong_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongOctet& operator =(
            MapULongOctet&& x) noexcept
    {

        m_var_map_ulong_octet = std::move(x.m_var_map_ulong_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongOctet& x) const
    {
        return (m_var_map_ulong_octet == x.m_var_map_ulong_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_octet
     * @param _var_map_ulong_octet New value to be copied in member var_map_ulong_octet
     */
    eProsima_user_DllExport void var_map_ulong_octet(
            const std::map<uint32_t, uint8_t>& _var_map_ulong_octet)
    {
        m_var_map_ulong_octet = _var_map_ulong_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_octet
     * @param _var_map_ulong_octet New value to be moved in member var_map_ulong_octet
     */
    eProsima_user_DllExport void var_map_ulong_octet(
            std::map<uint32_t, uint8_t>&& _var_map_ulong_octet)
    {
        m_var_map_ulong_octet = std::move(_var_map_ulong_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_octet
     * @return Constant reference to member var_map_ulong_octet
     */
    eProsima_user_DllExport const std::map<uint32_t, uint8_t>& var_map_ulong_octet() const
    {
        return m_var_map_ulong_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_octet
     * @return Reference to member var_map_ulong_octet
     */
    eProsima_user_DllExport std::map<uint32_t, uint8_t>& var_map_ulong_octet()
    {
        return m_var_map_ulong_octet;
    }



private:

    std::map<uint32_t, uint8_t> m_var_map_ulong_octet;

};
/*!
 * @brief This class represents the structure MapULongChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongChar that will be copied.
     */
    eProsima_user_DllExport MapULongChar(
            const MapULongChar& x)
    {
                    m_var_map_ulong_char = x.m_var_map_ulong_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongChar that will be copied.
     */
    eProsima_user_DllExport MapULongChar(
            MapULongChar&& x) noexcept
    {
        m_var_map_ulong_char = std::move(x.m_var_map_ulong_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongChar that will be copied.
     */
    eProsima_user_DllExport MapULongChar& operator =(
            const MapULongChar& x)
    {

                    m_var_map_ulong_char = x.m_var_map_ulong_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongChar that will be copied.
     */
    eProsima_user_DllExport MapULongChar& operator =(
            MapULongChar&& x) noexcept
    {

        m_var_map_ulong_char = std::move(x.m_var_map_ulong_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongChar& x) const
    {
        return (m_var_map_ulong_char == x.m_var_map_ulong_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_char
     * @param _var_map_ulong_char New value to be copied in member var_map_ulong_char
     */
    eProsima_user_DllExport void var_map_ulong_char(
            const std::map<uint32_t, char>& _var_map_ulong_char)
    {
        m_var_map_ulong_char = _var_map_ulong_char;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_char
     * @param _var_map_ulong_char New value to be moved in member var_map_ulong_char
     */
    eProsima_user_DllExport void var_map_ulong_char(
            std::map<uint32_t, char>&& _var_map_ulong_char)
    {
        m_var_map_ulong_char = std::move(_var_map_ulong_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_char
     * @return Constant reference to member var_map_ulong_char
     */
    eProsima_user_DllExport const std::map<uint32_t, char>& var_map_ulong_char() const
    {
        return m_var_map_ulong_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_char
     * @return Reference to member var_map_ulong_char
     */
    eProsima_user_DllExport std::map<uint32_t, char>& var_map_ulong_char()
    {
        return m_var_map_ulong_char;
    }



private:

    std::map<uint32_t, char> m_var_map_ulong_char;

};
/*!
 * @brief This class represents the structure MapULongWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongWChar(
            const MapULongWChar& x)
    {
                    m_var_map_ulong_wchar = x.m_var_map_ulong_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongWChar(
            MapULongWChar&& x) noexcept
    {
        m_var_map_ulong_wchar = std::move(x.m_var_map_ulong_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongWChar& operator =(
            const MapULongWChar& x)
    {

                    m_var_map_ulong_wchar = x.m_var_map_ulong_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongWChar& operator =(
            MapULongWChar&& x) noexcept
    {

        m_var_map_ulong_wchar = std::move(x.m_var_map_ulong_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongWChar& x) const
    {
        return (m_var_map_ulong_wchar == x.m_var_map_ulong_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_wchar
     * @param _var_map_ulong_wchar New value to be copied in member var_map_ulong_wchar
     */
    eProsima_user_DllExport void var_map_ulong_wchar(
            const std::map<uint32_t, wchar_t>& _var_map_ulong_wchar)
    {
        m_var_map_ulong_wchar = _var_map_ulong_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_wchar
     * @param _var_map_ulong_wchar New value to be moved in member var_map_ulong_wchar
     */
    eProsima_user_DllExport void var_map_ulong_wchar(
            std::map<uint32_t, wchar_t>&& _var_map_ulong_wchar)
    {
        m_var_map_ulong_wchar = std::move(_var_map_ulong_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_wchar
     * @return Constant reference to member var_map_ulong_wchar
     */
    eProsima_user_DllExport const std::map<uint32_t, wchar_t>& var_map_ulong_wchar() const
    {
        return m_var_map_ulong_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_wchar
     * @return Reference to member var_map_ulong_wchar
     */
    eProsima_user_DllExport std::map<uint32_t, wchar_t>& var_map_ulong_wchar()
    {
        return m_var_map_ulong_wchar;
    }



private:

    std::map<uint32_t, wchar_t> m_var_map_ulong_wchar;

};
/*!
 * @brief This class represents the structure MapULongString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongString that will be copied.
     */
    eProsima_user_DllExport MapULongString(
            const MapULongString& x)
    {
                    m_var_map_ulong_string = x.m_var_map_ulong_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongString that will be copied.
     */
    eProsima_user_DllExport MapULongString(
            MapULongString&& x) noexcept
    {
        m_var_map_ulong_string = std::move(x.m_var_map_ulong_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongString that will be copied.
     */
    eProsima_user_DllExport MapULongString& operator =(
            const MapULongString& x)
    {

                    m_var_map_ulong_string = x.m_var_map_ulong_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongString that will be copied.
     */
    eProsima_user_DllExport MapULongString& operator =(
            MapULongString&& x) noexcept
    {

        m_var_map_ulong_string = std::move(x.m_var_map_ulong_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongString& x) const
    {
        return (m_var_map_ulong_string == x.m_var_map_ulong_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_string
     * @param _var_map_ulong_string New value to be copied in member var_map_ulong_string
     */
    eProsima_user_DllExport void var_map_ulong_string(
            const std::map<uint32_t, std::string>& _var_map_ulong_string)
    {
        m_var_map_ulong_string = _var_map_ulong_string;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_string
     * @param _var_map_ulong_string New value to be moved in member var_map_ulong_string
     */
    eProsima_user_DllExport void var_map_ulong_string(
            std::map<uint32_t, std::string>&& _var_map_ulong_string)
    {
        m_var_map_ulong_string = std::move(_var_map_ulong_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_string
     * @return Constant reference to member var_map_ulong_string
     */
    eProsima_user_DllExport const std::map<uint32_t, std::string>& var_map_ulong_string() const
    {
        return m_var_map_ulong_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_string
     * @return Reference to member var_map_ulong_string
     */
    eProsima_user_DllExport std::map<uint32_t, std::string>& var_map_ulong_string()
    {
        return m_var_map_ulong_string;
    }



private:

    std::map<uint32_t, std::string> m_var_map_ulong_string;

};
/*!
 * @brief This class represents the structure MapULongWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongWString that will be copied.
     */
    eProsima_user_DllExport MapULongWString(
            const MapULongWString& x)
    {
                    m_var_map_ulong_wstring = x.m_var_map_ulong_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongWString that will be copied.
     */
    eProsima_user_DllExport MapULongWString(
            MapULongWString&& x) noexcept
    {
        m_var_map_ulong_wstring = std::move(x.m_var_map_ulong_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongWString that will be copied.
     */
    eProsima_user_DllExport MapULongWString& operator =(
            const MapULongWString& x)
    {

                    m_var_map_ulong_wstring = x.m_var_map_ulong_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongWString that will be copied.
     */
    eProsima_user_DllExport MapULongWString& operator =(
            MapULongWString&& x) noexcept
    {

        m_var_map_ulong_wstring = std::move(x.m_var_map_ulong_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongWString& x) const
    {
        return (m_var_map_ulong_wstring == x.m_var_map_ulong_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_wstring
     * @param _var_map_ulong_wstring New value to be copied in member var_map_ulong_wstring
     */
    eProsima_user_DllExport void var_map_ulong_wstring(
            const std::map<uint32_t, std::wstring>& _var_map_ulong_wstring)
    {
        m_var_map_ulong_wstring = _var_map_ulong_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_wstring
     * @param _var_map_ulong_wstring New value to be moved in member var_map_ulong_wstring
     */
    eProsima_user_DllExport void var_map_ulong_wstring(
            std::map<uint32_t, std::wstring>&& _var_map_ulong_wstring)
    {
        m_var_map_ulong_wstring = std::move(_var_map_ulong_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_wstring
     * @return Constant reference to member var_map_ulong_wstring
     */
    eProsima_user_DllExport const std::map<uint32_t, std::wstring>& var_map_ulong_wstring() const
    {
        return m_var_map_ulong_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_wstring
     * @return Reference to member var_map_ulong_wstring
     */
    eProsima_user_DllExport std::map<uint32_t, std::wstring>& var_map_ulong_wstring()
    {
        return m_var_map_ulong_wstring;
    }



private:

    std::map<uint32_t, std::wstring> m_var_map_ulong_wstring;

};
/*!
 * @brief This class represents the structure MapULongInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedStringHelper(
            const MapULongInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_ulong_inneraliasboundedstringhelper = x.m_var_map_ulong_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedStringHelper(
            MapULongInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_ulong_inneraliasboundedstringhelper = std::move(x.m_var_map_ulong_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedStringHelper& operator =(
            const MapULongInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_ulong_inneraliasboundedstringhelper = x.m_var_map_ulong_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedStringHelper& operator =(
            MapULongInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_ulong_inneraliasboundedstringhelper = std::move(x.m_var_map_ulong_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_ulong_inneraliasboundedstringhelper == x.m_var_map_ulong_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_inneraliasboundedstringhelper
     * @param _var_map_ulong_inneraliasboundedstringhelper New value to be copied in member var_map_ulong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasboundedstringhelper(
            const std::map<uint32_t, Inner_alias_bounded_string_helper>& _var_map_ulong_inneraliasboundedstringhelper)
    {
        m_var_map_ulong_inneraliasboundedstringhelper = _var_map_ulong_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_inneraliasboundedstringhelper
     * @param _var_map_ulong_inneraliasboundedstringhelper New value to be moved in member var_map_ulong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasboundedstringhelper(
            std::map<uint32_t, Inner_alias_bounded_string_helper>&& _var_map_ulong_inneraliasboundedstringhelper)
    {
        m_var_map_ulong_inneraliasboundedstringhelper = std::move(_var_map_ulong_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_ulong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<uint32_t, Inner_alias_bounded_string_helper>& var_map_ulong_inneraliasboundedstringhelper() const
    {
        return m_var_map_ulong_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_inneraliasboundedstringhelper
     * @return Reference to member var_map_ulong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<uint32_t, Inner_alias_bounded_string_helper>& var_map_ulong_inneraliasboundedstringhelper()
    {
        return m_var_map_ulong_inneraliasboundedstringhelper;
    }



private:

    std::map<uint32_t, Inner_alias_bounded_string_helper> m_var_map_ulong_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapULongInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedWStringHelper(
            const MapULongInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_ulong_inneraliasboundedwstringhelper = x.m_var_map_ulong_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedWStringHelper(
            MapULongInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_ulong_inneraliasboundedwstringhelper = std::move(x.m_var_map_ulong_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedWStringHelper& operator =(
            const MapULongInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_ulong_inneraliasboundedwstringhelper = x.m_var_map_ulong_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasBoundedWStringHelper& operator =(
            MapULongInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_ulong_inneraliasboundedwstringhelper = std::move(x.m_var_map_ulong_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_ulong_inneraliasboundedwstringhelper == x.m_var_map_ulong_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_inneraliasboundedwstringhelper
     * @param _var_map_ulong_inneraliasboundedwstringhelper New value to be copied in member var_map_ulong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasboundedwstringhelper(
            const std::map<uint32_t, Inner_alias_bounded_wstring_helper>& _var_map_ulong_inneraliasboundedwstringhelper)
    {
        m_var_map_ulong_inneraliasboundedwstringhelper = _var_map_ulong_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_inneraliasboundedwstringhelper
     * @param _var_map_ulong_inneraliasboundedwstringhelper New value to be moved in member var_map_ulong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasboundedwstringhelper(
            std::map<uint32_t, Inner_alias_bounded_wstring_helper>&& _var_map_ulong_inneraliasboundedwstringhelper)
    {
        m_var_map_ulong_inneraliasboundedwstringhelper = std::move(_var_map_ulong_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_ulong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<uint32_t, Inner_alias_bounded_wstring_helper>& var_map_ulong_inneraliasboundedwstringhelper() const
    {
        return m_var_map_ulong_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_inneraliasboundedwstringhelper
     * @return Reference to member var_map_ulong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<uint32_t, Inner_alias_bounded_wstring_helper>& var_map_ulong_inneraliasboundedwstringhelper()
    {
        return m_var_map_ulong_inneraliasboundedwstringhelper;
    }



private:

    std::map<uint32_t, Inner_alias_bounded_wstring_helper> m_var_map_ulong_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapULongInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerEnumHelper(
            const MapULongInnerEnumHelper& x)
    {
                    m_var_map_ulong_innerenumhelper = x.m_var_map_ulong_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerEnumHelper(
            MapULongInnerEnumHelper&& x) noexcept
    {
        m_var_map_ulong_innerenumhelper = std::move(x.m_var_map_ulong_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerEnumHelper& operator =(
            const MapULongInnerEnumHelper& x)
    {

                    m_var_map_ulong_innerenumhelper = x.m_var_map_ulong_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerEnumHelper& operator =(
            MapULongInnerEnumHelper&& x) noexcept
    {

        m_var_map_ulong_innerenumhelper = std::move(x.m_var_map_ulong_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerEnumHelper& x) const
    {
        return (m_var_map_ulong_innerenumhelper == x.m_var_map_ulong_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_innerenumhelper
     * @param _var_map_ulong_innerenumhelper New value to be copied in member var_map_ulong_innerenumhelper
     */
    eProsima_user_DllExport void var_map_ulong_innerenumhelper(
            const std::map<uint32_t, InnerEnumHelper>& _var_map_ulong_innerenumhelper)
    {
        m_var_map_ulong_innerenumhelper = _var_map_ulong_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_innerenumhelper
     * @param _var_map_ulong_innerenumhelper New value to be moved in member var_map_ulong_innerenumhelper
     */
    eProsima_user_DllExport void var_map_ulong_innerenumhelper(
            std::map<uint32_t, InnerEnumHelper>&& _var_map_ulong_innerenumhelper)
    {
        m_var_map_ulong_innerenumhelper = std::move(_var_map_ulong_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_innerenumhelper
     * @return Constant reference to member var_map_ulong_innerenumhelper
     */
    eProsima_user_DllExport const std::map<uint32_t, InnerEnumHelper>& var_map_ulong_innerenumhelper() const
    {
        return m_var_map_ulong_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_innerenumhelper
     * @return Reference to member var_map_ulong_innerenumhelper
     */
    eProsima_user_DllExport std::map<uint32_t, InnerEnumHelper>& var_map_ulong_innerenumhelper()
    {
        return m_var_map_ulong_innerenumhelper;
    }



private:

    std::map<uint32_t, InnerEnumHelper> m_var_map_ulong_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapULongInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitMaskHelper(
            const MapULongInnerBitMaskHelper& x)
    {
                    m_var_map_ulong_innerbitmaskhelper = x.m_var_map_ulong_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitMaskHelper(
            MapULongInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_ulong_innerbitmaskhelper = std::move(x.m_var_map_ulong_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitMaskHelper& operator =(
            const MapULongInnerBitMaskHelper& x)
    {

                    m_var_map_ulong_innerbitmaskhelper = x.m_var_map_ulong_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitMaskHelper& operator =(
            MapULongInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_ulong_innerbitmaskhelper = std::move(x.m_var_map_ulong_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerBitMaskHelper& x) const
    {
        return (m_var_map_ulong_innerbitmaskhelper == x.m_var_map_ulong_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_innerbitmaskhelper
     * @param _var_map_ulong_innerbitmaskhelper New value to be copied in member var_map_ulong_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_ulong_innerbitmaskhelper(
            const std::map<uint32_t, InnerBitMaskHelper>& _var_map_ulong_innerbitmaskhelper)
    {
        m_var_map_ulong_innerbitmaskhelper = _var_map_ulong_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_innerbitmaskhelper
     * @param _var_map_ulong_innerbitmaskhelper New value to be moved in member var_map_ulong_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_ulong_innerbitmaskhelper(
            std::map<uint32_t, InnerBitMaskHelper>&& _var_map_ulong_innerbitmaskhelper)
    {
        m_var_map_ulong_innerbitmaskhelper = std::move(_var_map_ulong_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_innerbitmaskhelper
     * @return Constant reference to member var_map_ulong_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<uint32_t, InnerBitMaskHelper>& var_map_ulong_innerbitmaskhelper() const
    {
        return m_var_map_ulong_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_innerbitmaskhelper
     * @return Reference to member var_map_ulong_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<uint32_t, InnerBitMaskHelper>& var_map_ulong_innerbitmaskhelper()
    {
        return m_var_map_ulong_innerbitmaskhelper;
    }



private:

    std::map<uint32_t, InnerBitMaskHelper> m_var_map_ulong_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapULongInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasHelper(
            const MapULongInnerAliasHelper& x)
    {
                    m_var_map_ulong_inneraliashelper = x.m_var_map_ulong_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasHelper(
            MapULongInnerAliasHelper&& x) noexcept
    {
        m_var_map_ulong_inneraliashelper = std::move(x.m_var_map_ulong_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasHelper& operator =(
            const MapULongInnerAliasHelper& x)
    {

                    m_var_map_ulong_inneraliashelper = x.m_var_map_ulong_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasHelper& operator =(
            MapULongInnerAliasHelper&& x) noexcept
    {

        m_var_map_ulong_inneraliashelper = std::move(x.m_var_map_ulong_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerAliasHelper& x) const
    {
        return (m_var_map_ulong_inneraliashelper == x.m_var_map_ulong_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_inneraliashelper
     * @param _var_map_ulong_inneraliashelper New value to be copied in member var_map_ulong_inneraliashelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliashelper(
            const std::map<uint32_t, InnerAliasHelper>& _var_map_ulong_inneraliashelper)
    {
        m_var_map_ulong_inneraliashelper = _var_map_ulong_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_inneraliashelper
     * @param _var_map_ulong_inneraliashelper New value to be moved in member var_map_ulong_inneraliashelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliashelper(
            std::map<uint32_t, InnerAliasHelper>&& _var_map_ulong_inneraliashelper)
    {
        m_var_map_ulong_inneraliashelper = std::move(_var_map_ulong_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_inneraliashelper
     * @return Constant reference to member var_map_ulong_inneraliashelper
     */
    eProsima_user_DllExport const std::map<uint32_t, InnerAliasHelper>& var_map_ulong_inneraliashelper() const
    {
        return m_var_map_ulong_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_inneraliashelper
     * @return Reference to member var_map_ulong_inneraliashelper
     */
    eProsima_user_DllExport std::map<uint32_t, InnerAliasHelper>& var_map_ulong_inneraliashelper()
    {
        return m_var_map_ulong_inneraliashelper;
    }



private:

    std::map<uint32_t, InnerAliasHelper> m_var_map_ulong_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapULongInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasArrayHelper(
            const MapULongInnerAliasArrayHelper& x)
    {
                    m_var_map_ulong_inneraliasarrayhelper = x.m_var_map_ulong_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasArrayHelper(
            MapULongInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_ulong_inneraliasarrayhelper = std::move(x.m_var_map_ulong_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasArrayHelper& operator =(
            const MapULongInnerAliasArrayHelper& x)
    {

                    m_var_map_ulong_inneraliasarrayhelper = x.m_var_map_ulong_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasArrayHelper& operator =(
            MapULongInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_ulong_inneraliasarrayhelper = std::move(x.m_var_map_ulong_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerAliasArrayHelper& x) const
    {
        return (m_var_map_ulong_inneraliasarrayhelper == x.m_var_map_ulong_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_inneraliasarrayhelper
     * @param _var_map_ulong_inneraliasarrayhelper New value to be copied in member var_map_ulong_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasarrayhelper(
            const std::map<uint32_t, Inner_alias_array_helper>& _var_map_ulong_inneraliasarrayhelper)
    {
        m_var_map_ulong_inneraliasarrayhelper = _var_map_ulong_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_inneraliasarrayhelper
     * @param _var_map_ulong_inneraliasarrayhelper New value to be moved in member var_map_ulong_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasarrayhelper(
            std::map<uint32_t, Inner_alias_array_helper>&& _var_map_ulong_inneraliasarrayhelper)
    {
        m_var_map_ulong_inneraliasarrayhelper = std::move(_var_map_ulong_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_inneraliasarrayhelper
     * @return Constant reference to member var_map_ulong_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<uint32_t, Inner_alias_array_helper>& var_map_ulong_inneraliasarrayhelper() const
    {
        return m_var_map_ulong_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_inneraliasarrayhelper
     * @return Reference to member var_map_ulong_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<uint32_t, Inner_alias_array_helper>& var_map_ulong_inneraliasarrayhelper()
    {
        return m_var_map_ulong_inneraliasarrayhelper;
    }



private:

    std::map<uint32_t, Inner_alias_array_helper> m_var_map_ulong_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapULongInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasSequenceHelper(
            const MapULongInnerAliasSequenceHelper& x)
    {
                    m_var_map_ulong_inneraliassequencehelper = x.m_var_map_ulong_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasSequenceHelper(
            MapULongInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_ulong_inneraliassequencehelper = std::move(x.m_var_map_ulong_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasSequenceHelper& operator =(
            const MapULongInnerAliasSequenceHelper& x)
    {

                    m_var_map_ulong_inneraliassequencehelper = x.m_var_map_ulong_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasSequenceHelper& operator =(
            MapULongInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_ulong_inneraliassequencehelper = std::move(x.m_var_map_ulong_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_ulong_inneraliassequencehelper == x.m_var_map_ulong_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_inneraliassequencehelper
     * @param _var_map_ulong_inneraliassequencehelper New value to be copied in member var_map_ulong_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliassequencehelper(
            const std::map<uint32_t, Inner_alias_sequence_helper>& _var_map_ulong_inneraliassequencehelper)
    {
        m_var_map_ulong_inneraliassequencehelper = _var_map_ulong_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_inneraliassequencehelper
     * @param _var_map_ulong_inneraliassequencehelper New value to be moved in member var_map_ulong_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliassequencehelper(
            std::map<uint32_t, Inner_alias_sequence_helper>&& _var_map_ulong_inneraliassequencehelper)
    {
        m_var_map_ulong_inneraliassequencehelper = std::move(_var_map_ulong_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_inneraliassequencehelper
     * @return Constant reference to member var_map_ulong_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<uint32_t, Inner_alias_sequence_helper>& var_map_ulong_inneraliassequencehelper() const
    {
        return m_var_map_ulong_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_inneraliassequencehelper
     * @return Reference to member var_map_ulong_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<uint32_t, Inner_alias_sequence_helper>& var_map_ulong_inneraliassequencehelper()
    {
        return m_var_map_ulong_inneraliassequencehelper;
    }



private:

    std::map<uint32_t, Inner_alias_sequence_helper> m_var_map_ulong_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapULongInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasMapHelper(
            const MapULongInnerAliasMapHelper& x)
    {
                    m_var_map_ulong_inneraliasmaphelper = x.m_var_map_ulong_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasMapHelper(
            MapULongInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_ulong_inneraliasmaphelper = std::move(x.m_var_map_ulong_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasMapHelper& operator =(
            const MapULongInnerAliasMapHelper& x)
    {

                    m_var_map_ulong_inneraliasmaphelper = x.m_var_map_ulong_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerAliasMapHelper& operator =(
            MapULongInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_ulong_inneraliasmaphelper = std::move(x.m_var_map_ulong_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerAliasMapHelper& x) const
    {
        return (m_var_map_ulong_inneraliasmaphelper == x.m_var_map_ulong_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_inneraliasmaphelper
     * @param _var_map_ulong_inneraliasmaphelper New value to be copied in member var_map_ulong_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasmaphelper(
            const std::map<uint32_t, Inner_alias_map_helper>& _var_map_ulong_inneraliasmaphelper)
    {
        m_var_map_ulong_inneraliasmaphelper = _var_map_ulong_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_inneraliasmaphelper
     * @param _var_map_ulong_inneraliasmaphelper New value to be moved in member var_map_ulong_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_ulong_inneraliasmaphelper(
            std::map<uint32_t, Inner_alias_map_helper>&& _var_map_ulong_inneraliasmaphelper)
    {
        m_var_map_ulong_inneraliasmaphelper = std::move(_var_map_ulong_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_inneraliasmaphelper
     * @return Constant reference to member var_map_ulong_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<uint32_t, Inner_alias_map_helper>& var_map_ulong_inneraliasmaphelper() const
    {
        return m_var_map_ulong_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_inneraliasmaphelper
     * @return Reference to member var_map_ulong_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<uint32_t, Inner_alias_map_helper>& var_map_ulong_inneraliasmaphelper()
    {
        return m_var_map_ulong_inneraliasmaphelper;
    }



private:

    std::map<uint32_t, Inner_alias_map_helper> m_var_map_ulong_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapULongInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerUnionHelper(
            const MapULongInnerUnionHelper& x)
    {
                    m_var_map_ulong_innerunionhelper = x.m_var_map_ulong_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerUnionHelper(
            MapULongInnerUnionHelper&& x) noexcept
    {
        m_var_map_ulong_innerunionhelper = std::move(x.m_var_map_ulong_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerUnionHelper& operator =(
            const MapULongInnerUnionHelper& x)
    {

                    m_var_map_ulong_innerunionhelper = x.m_var_map_ulong_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerUnionHelper& operator =(
            MapULongInnerUnionHelper&& x) noexcept
    {

        m_var_map_ulong_innerunionhelper = std::move(x.m_var_map_ulong_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerUnionHelper& x) const
    {
        return (m_var_map_ulong_innerunionhelper == x.m_var_map_ulong_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_innerunionhelper
     * @param _var_map_ulong_innerunionhelper New value to be copied in member var_map_ulong_innerunionhelper
     */
    eProsima_user_DllExport void var_map_ulong_innerunionhelper(
            const std::map<uint32_t, InnerUnionHelper>& _var_map_ulong_innerunionhelper)
    {
        m_var_map_ulong_innerunionhelper = _var_map_ulong_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_innerunionhelper
     * @param _var_map_ulong_innerunionhelper New value to be moved in member var_map_ulong_innerunionhelper
     */
    eProsima_user_DllExport void var_map_ulong_innerunionhelper(
            std::map<uint32_t, InnerUnionHelper>&& _var_map_ulong_innerunionhelper)
    {
        m_var_map_ulong_innerunionhelper = std::move(_var_map_ulong_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_innerunionhelper
     * @return Constant reference to member var_map_ulong_innerunionhelper
     */
    eProsima_user_DllExport const std::map<uint32_t, InnerUnionHelper>& var_map_ulong_innerunionhelper() const
    {
        return m_var_map_ulong_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_innerunionhelper
     * @return Reference to member var_map_ulong_innerunionhelper
     */
    eProsima_user_DllExport std::map<uint32_t, InnerUnionHelper>& var_map_ulong_innerunionhelper()
    {
        return m_var_map_ulong_innerunionhelper;
    }



private:

    std::map<uint32_t, InnerUnionHelper> m_var_map_ulong_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapULongInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerStructureHelper(
            const MapULongInnerStructureHelper& x)
    {
                    m_var_map_ulong_innerstructurehelper = x.m_var_map_ulong_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerStructureHelper(
            MapULongInnerStructureHelper&& x) noexcept
    {
        m_var_map_ulong_innerstructurehelper = std::move(x.m_var_map_ulong_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerStructureHelper& operator =(
            const MapULongInnerStructureHelper& x)
    {

                    m_var_map_ulong_innerstructurehelper = x.m_var_map_ulong_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerStructureHelper& operator =(
            MapULongInnerStructureHelper&& x) noexcept
    {

        m_var_map_ulong_innerstructurehelper = std::move(x.m_var_map_ulong_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerStructureHelper& x) const
    {
        return (m_var_map_ulong_innerstructurehelper == x.m_var_map_ulong_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_innerstructurehelper
     * @param _var_map_ulong_innerstructurehelper New value to be copied in member var_map_ulong_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_ulong_innerstructurehelper(
            const std::map<uint32_t, InnerStructureHelper>& _var_map_ulong_innerstructurehelper)
    {
        m_var_map_ulong_innerstructurehelper = _var_map_ulong_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_innerstructurehelper
     * @param _var_map_ulong_innerstructurehelper New value to be moved in member var_map_ulong_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_ulong_innerstructurehelper(
            std::map<uint32_t, InnerStructureHelper>&& _var_map_ulong_innerstructurehelper)
    {
        m_var_map_ulong_innerstructurehelper = std::move(_var_map_ulong_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_innerstructurehelper
     * @return Constant reference to member var_map_ulong_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<uint32_t, InnerStructureHelper>& var_map_ulong_innerstructurehelper() const
    {
        return m_var_map_ulong_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_innerstructurehelper
     * @return Reference to member var_map_ulong_innerstructurehelper
     */
    eProsima_user_DllExport std::map<uint32_t, InnerStructureHelper>& var_map_ulong_innerstructurehelper()
    {
        return m_var_map_ulong_innerstructurehelper;
    }



private:

    std::map<uint32_t, InnerStructureHelper> m_var_map_ulong_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapULongInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitsetHelper(
            const MapULongInnerBitsetHelper& x)
    {
                    m_var_map_ulong_innerbitsethelper = x.m_var_map_ulong_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitsetHelper(
            MapULongInnerBitsetHelper&& x) noexcept
    {
        m_var_map_ulong_innerbitsethelper = std::move(x.m_var_map_ulong_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitsetHelper& operator =(
            const MapULongInnerBitsetHelper& x)
    {

                    m_var_map_ulong_innerbitsethelper = x.m_var_map_ulong_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongInnerBitsetHelper& operator =(
            MapULongInnerBitsetHelper&& x) noexcept
    {

        m_var_map_ulong_innerbitsethelper = std::move(x.m_var_map_ulong_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongInnerBitsetHelper& x) const
    {
        return (m_var_map_ulong_innerbitsethelper == x.m_var_map_ulong_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_ulong_innerbitsethelper
     * @param _var_map_ulong_innerbitsethelper New value to be copied in member var_map_ulong_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_ulong_innerbitsethelper(
            const std::map<uint32_t, InnerBitsetHelper>& _var_map_ulong_innerbitsethelper)
    {
        m_var_map_ulong_innerbitsethelper = _var_map_ulong_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_ulong_innerbitsethelper
     * @param _var_map_ulong_innerbitsethelper New value to be moved in member var_map_ulong_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_ulong_innerbitsethelper(
            std::map<uint32_t, InnerBitsetHelper>&& _var_map_ulong_innerbitsethelper)
    {
        m_var_map_ulong_innerbitsethelper = std::move(_var_map_ulong_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_ulong_innerbitsethelper
     * @return Constant reference to member var_map_ulong_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<uint32_t, InnerBitsetHelper>& var_map_ulong_innerbitsethelper() const
    {
        return m_var_map_ulong_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_ulong_innerbitsethelper
     * @return Reference to member var_map_ulong_innerbitsethelper
     */
    eProsima_user_DllExport std::map<uint32_t, InnerBitsetHelper>& var_map_ulong_innerbitsethelper()
    {
        return m_var_map_ulong_innerbitsethelper;
    }



private:

    std::map<uint32_t, InnerBitsetHelper> m_var_map_ulong_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapLongLongShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongShort(
            const MapLongLongShort& x)
    {
                    m_var_map_longlong_short = x.m_var_map_longlong_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongShort(
            MapLongLongShort&& x) noexcept
    {
        m_var_map_longlong_short = std::move(x.m_var_map_longlong_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongShort& operator =(
            const MapLongLongShort& x)
    {

                    m_var_map_longlong_short = x.m_var_map_longlong_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongShort& operator =(
            MapLongLongShort&& x) noexcept
    {

        m_var_map_longlong_short = std::move(x.m_var_map_longlong_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongShort& x) const
    {
        return (m_var_map_longlong_short == x.m_var_map_longlong_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_short
     * @param _var_map_longlong_short New value to be copied in member var_map_longlong_short
     */
    eProsima_user_DllExport void var_map_longlong_short(
            const std::map<int64_t, int16_t>& _var_map_longlong_short)
    {
        m_var_map_longlong_short = _var_map_longlong_short;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_short
     * @param _var_map_longlong_short New value to be moved in member var_map_longlong_short
     */
    eProsima_user_DllExport void var_map_longlong_short(
            std::map<int64_t, int16_t>&& _var_map_longlong_short)
    {
        m_var_map_longlong_short = std::move(_var_map_longlong_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_short
     * @return Constant reference to member var_map_longlong_short
     */
    eProsima_user_DllExport const std::map<int64_t, int16_t>& var_map_longlong_short() const
    {
        return m_var_map_longlong_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_short
     * @return Reference to member var_map_longlong_short
     */
    eProsima_user_DllExport std::map<int64_t, int16_t>& var_map_longlong_short()
    {
        return m_var_map_longlong_short;
    }



private:

    std::map<int64_t, int16_t> m_var_map_longlong_short;

};
/*!
 * @brief This class represents the structure MapLongLongUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongUShort(
            const MapLongLongUShort& x)
    {
                    m_var_map_longlong_ushort = x.m_var_map_longlong_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongUShort(
            MapLongLongUShort&& x) noexcept
    {
        m_var_map_longlong_ushort = std::move(x.m_var_map_longlong_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongUShort& operator =(
            const MapLongLongUShort& x)
    {

                    m_var_map_longlong_ushort = x.m_var_map_longlong_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapLongLongUShort& operator =(
            MapLongLongUShort&& x) noexcept
    {

        m_var_map_longlong_ushort = std::move(x.m_var_map_longlong_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongUShort& x) const
    {
        return (m_var_map_longlong_ushort == x.m_var_map_longlong_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_ushort
     * @param _var_map_longlong_ushort New value to be copied in member var_map_longlong_ushort
     */
    eProsima_user_DllExport void var_map_longlong_ushort(
            const std::map<int64_t, uint16_t>& _var_map_longlong_ushort)
    {
        m_var_map_longlong_ushort = _var_map_longlong_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_ushort
     * @param _var_map_longlong_ushort New value to be moved in member var_map_longlong_ushort
     */
    eProsima_user_DllExport void var_map_longlong_ushort(
            std::map<int64_t, uint16_t>&& _var_map_longlong_ushort)
    {
        m_var_map_longlong_ushort = std::move(_var_map_longlong_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_ushort
     * @return Constant reference to member var_map_longlong_ushort
     */
    eProsima_user_DllExport const std::map<int64_t, uint16_t>& var_map_longlong_ushort() const
    {
        return m_var_map_longlong_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_ushort
     * @return Reference to member var_map_longlong_ushort
     */
    eProsima_user_DllExport std::map<int64_t, uint16_t>& var_map_longlong_ushort()
    {
        return m_var_map_longlong_ushort;
    }



private:

    std::map<int64_t, uint16_t> m_var_map_longlong_ushort;

};
/*!
 * @brief This class represents the structure MapLongLongKeyLongValue defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongKeyLongValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongKeyLongValue()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongKeyLongValue()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongKeyLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyLongValue(
            const MapLongLongKeyLongValue& x)
    {
                    m_var_map_longlong_long = x.m_var_map_longlong_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongKeyLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyLongValue(
            MapLongLongKeyLongValue&& x) noexcept
    {
        m_var_map_longlong_long = std::move(x.m_var_map_longlong_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongKeyLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyLongValue& operator =(
            const MapLongLongKeyLongValue& x)
    {

                    m_var_map_longlong_long = x.m_var_map_longlong_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongKeyLongValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyLongValue& operator =(
            MapLongLongKeyLongValue&& x) noexcept
    {

        m_var_map_longlong_long = std::move(x.m_var_map_longlong_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongKeyLongValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongKeyLongValue& x) const
    {
        return (m_var_map_longlong_long == x.m_var_map_longlong_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongKeyLongValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongKeyLongValue& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_long
     * @param _var_map_longlong_long New value to be copied in member var_map_longlong_long
     */
    eProsima_user_DllExport void var_map_longlong_long(
            const std::map<int64_t, int32_t>& _var_map_longlong_long)
    {
        m_var_map_longlong_long = _var_map_longlong_long;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_long
     * @param _var_map_longlong_long New value to be moved in member var_map_longlong_long
     */
    eProsima_user_DllExport void var_map_longlong_long(
            std::map<int64_t, int32_t>&& _var_map_longlong_long)
    {
        m_var_map_longlong_long = std::move(_var_map_longlong_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_long
     * @return Constant reference to member var_map_longlong_long
     */
    eProsima_user_DllExport const std::map<int64_t, int32_t>& var_map_longlong_long() const
    {
        return m_var_map_longlong_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_long
     * @return Reference to member var_map_longlong_long
     */
    eProsima_user_DllExport std::map<int64_t, int32_t>& var_map_longlong_long()
    {
        return m_var_map_longlong_long;
    }



private:

    std::map<int64_t, int32_t> m_var_map_longlong_long;

};
/*!
 * @brief This class represents the structure MapLongLongULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULong(
            const MapLongLongULong& x)
    {
                    m_var_map_longlong_ulong = x.m_var_map_longlong_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULong(
            MapLongLongULong&& x) noexcept
    {
        m_var_map_longlong_ulong = std::move(x.m_var_map_longlong_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULong& operator =(
            const MapLongLongULong& x)
    {

                    m_var_map_longlong_ulong = x.m_var_map_longlong_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongULong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULong& operator =(
            MapLongLongULong&& x) noexcept
    {

        m_var_map_longlong_ulong = std::move(x.m_var_map_longlong_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongULong& x) const
    {
        return (m_var_map_longlong_ulong == x.m_var_map_longlong_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_ulong
     * @param _var_map_longlong_ulong New value to be copied in member var_map_longlong_ulong
     */
    eProsima_user_DllExport void var_map_longlong_ulong(
            const std::map<int64_t, uint32_t>& _var_map_longlong_ulong)
    {
        m_var_map_longlong_ulong = _var_map_longlong_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_ulong
     * @param _var_map_longlong_ulong New value to be moved in member var_map_longlong_ulong
     */
    eProsima_user_DllExport void var_map_longlong_ulong(
            std::map<int64_t, uint32_t>&& _var_map_longlong_ulong)
    {
        m_var_map_longlong_ulong = std::move(_var_map_longlong_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_ulong
     * @return Constant reference to member var_map_longlong_ulong
     */
    eProsima_user_DllExport const std::map<int64_t, uint32_t>& var_map_longlong_ulong() const
    {
        return m_var_map_longlong_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_ulong
     * @return Reference to member var_map_longlong_ulong
     */
    eProsima_user_DllExport std::map<int64_t, uint32_t>& var_map_longlong_ulong()
    {
        return m_var_map_longlong_ulong;
    }



private:

    std::map<int64_t, uint32_t> m_var_map_longlong_ulong;

};
/*!
 * @brief This class represents the structure MapLongLongLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongLong(
            const MapLongLongLongLong& x)
    {
                    m_var_map_longlong_longlong = x.m_var_map_longlong_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongLong(
            MapLongLongLongLong&& x) noexcept
    {
        m_var_map_longlong_longlong = std::move(x.m_var_map_longlong_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongLong& operator =(
            const MapLongLongLongLong& x)
    {

                    m_var_map_longlong_longlong = x.m_var_map_longlong_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongLong& operator =(
            MapLongLongLongLong&& x) noexcept
    {

        m_var_map_longlong_longlong = std::move(x.m_var_map_longlong_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongLongLong& x) const
    {
        return (m_var_map_longlong_longlong == x.m_var_map_longlong_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_longlong
     * @param _var_map_longlong_longlong New value to be copied in member var_map_longlong_longlong
     */
    eProsima_user_DllExport void var_map_longlong_longlong(
            const std::map<int64_t, int64_t>& _var_map_longlong_longlong)
    {
        m_var_map_longlong_longlong = _var_map_longlong_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_longlong
     * @param _var_map_longlong_longlong New value to be moved in member var_map_longlong_longlong
     */
    eProsima_user_DllExport void var_map_longlong_longlong(
            std::map<int64_t, int64_t>&& _var_map_longlong_longlong)
    {
        m_var_map_longlong_longlong = std::move(_var_map_longlong_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_longlong
     * @return Constant reference to member var_map_longlong_longlong
     */
    eProsima_user_DllExport const std::map<int64_t, int64_t>& var_map_longlong_longlong() const
    {
        return m_var_map_longlong_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_longlong
     * @return Reference to member var_map_longlong_longlong
     */
    eProsima_user_DllExport std::map<int64_t, int64_t>& var_map_longlong_longlong()
    {
        return m_var_map_longlong_longlong;
    }



private:

    std::map<int64_t, int64_t> m_var_map_longlong_longlong;

};
/*!
 * @brief This class represents the structure MapLongLongULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULongLong(
            const MapLongLongULongLong& x)
    {
                    m_var_map_longlong_ulonglong = x.m_var_map_longlong_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULongLong(
            MapLongLongULongLong&& x) noexcept
    {
        m_var_map_longlong_ulonglong = std::move(x.m_var_map_longlong_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULongLong& operator =(
            const MapLongLongULongLong& x)
    {

                    m_var_map_longlong_ulonglong = x.m_var_map_longlong_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapLongLongULongLong& operator =(
            MapLongLongULongLong&& x) noexcept
    {

        m_var_map_longlong_ulonglong = std::move(x.m_var_map_longlong_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongULongLong& x) const
    {
        return (m_var_map_longlong_ulonglong == x.m_var_map_longlong_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_ulonglong
     * @param _var_map_longlong_ulonglong New value to be copied in member var_map_longlong_ulonglong
     */
    eProsima_user_DllExport void var_map_longlong_ulonglong(
            const std::map<int64_t, uint64_t>& _var_map_longlong_ulonglong)
    {
        m_var_map_longlong_ulonglong = _var_map_longlong_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_ulonglong
     * @param _var_map_longlong_ulonglong New value to be moved in member var_map_longlong_ulonglong
     */
    eProsima_user_DllExport void var_map_longlong_ulonglong(
            std::map<int64_t, uint64_t>&& _var_map_longlong_ulonglong)
    {
        m_var_map_longlong_ulonglong = std::move(_var_map_longlong_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_ulonglong
     * @return Constant reference to member var_map_longlong_ulonglong
     */
    eProsima_user_DllExport const std::map<int64_t, uint64_t>& var_map_longlong_ulonglong() const
    {
        return m_var_map_longlong_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_ulonglong
     * @return Reference to member var_map_longlong_ulonglong
     */
    eProsima_user_DllExport std::map<int64_t, uint64_t>& var_map_longlong_ulonglong()
    {
        return m_var_map_longlong_ulonglong;
    }



private:

    std::map<int64_t, uint64_t> m_var_map_longlong_ulonglong;

};
/*!
 * @brief This class represents the structure MapLongLongFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongLongFloat(
            const MapLongLongFloat& x)
    {
                    m_var_map_longlong_float = x.m_var_map_longlong_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongLongFloat(
            MapLongLongFloat&& x) noexcept
    {
        m_var_map_longlong_float = std::move(x.m_var_map_longlong_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongLongFloat& operator =(
            const MapLongLongFloat& x)
    {

                    m_var_map_longlong_float = x.m_var_map_longlong_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapLongLongFloat& operator =(
            MapLongLongFloat&& x) noexcept
    {

        m_var_map_longlong_float = std::move(x.m_var_map_longlong_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongFloat& x) const
    {
        return (m_var_map_longlong_float == x.m_var_map_longlong_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_float
     * @param _var_map_longlong_float New value to be copied in member var_map_longlong_float
     */
    eProsima_user_DllExport void var_map_longlong_float(
            const std::map<int64_t, float>& _var_map_longlong_float)
    {
        m_var_map_longlong_float = _var_map_longlong_float;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_float
     * @param _var_map_longlong_float New value to be moved in member var_map_longlong_float
     */
    eProsima_user_DllExport void var_map_longlong_float(
            std::map<int64_t, float>&& _var_map_longlong_float)
    {
        m_var_map_longlong_float = std::move(_var_map_longlong_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_float
     * @return Constant reference to member var_map_longlong_float
     */
    eProsima_user_DllExport const std::map<int64_t, float>& var_map_longlong_float() const
    {
        return m_var_map_longlong_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_float
     * @return Reference to member var_map_longlong_float
     */
    eProsima_user_DllExport std::map<int64_t, float>& var_map_longlong_float()
    {
        return m_var_map_longlong_float;
    }



private:

    std::map<int64_t, float> m_var_map_longlong_float;

};
/*!
 * @brief This class represents the structure MapLongLongKeyDoubleValue defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongKeyDoubleValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongKeyDoubleValue()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongKeyDoubleValue()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongKeyDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyDoubleValue(
            const MapLongLongKeyDoubleValue& x)
    {
                    m_var_map_longlong_double = x.m_var_map_longlong_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongKeyDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyDoubleValue(
            MapLongLongKeyDoubleValue&& x) noexcept
    {
        m_var_map_longlong_double = std::move(x.m_var_map_longlong_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongKeyDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyDoubleValue& operator =(
            const MapLongLongKeyDoubleValue& x)
    {

                    m_var_map_longlong_double = x.m_var_map_longlong_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongKeyDoubleValue that will be copied.
     */
    eProsima_user_DllExport MapLongLongKeyDoubleValue& operator =(
            MapLongLongKeyDoubleValue&& x) noexcept
    {

        m_var_map_longlong_double = std::move(x.m_var_map_longlong_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongKeyDoubleValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongKeyDoubleValue& x) const
    {
        return (m_var_map_longlong_double == x.m_var_map_longlong_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongKeyDoubleValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongKeyDoubleValue& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_double
     * @param _var_map_longlong_double New value to be copied in member var_map_longlong_double
     */
    eProsima_user_DllExport void var_map_longlong_double(
            const std::map<int64_t, double>& _var_map_longlong_double)
    {
        m_var_map_longlong_double = _var_map_longlong_double;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_double
     * @param _var_map_longlong_double New value to be moved in member var_map_longlong_double
     */
    eProsima_user_DllExport void var_map_longlong_double(
            std::map<int64_t, double>&& _var_map_longlong_double)
    {
        m_var_map_longlong_double = std::move(_var_map_longlong_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_double
     * @return Constant reference to member var_map_longlong_double
     */
    eProsima_user_DllExport const std::map<int64_t, double>& var_map_longlong_double() const
    {
        return m_var_map_longlong_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_double
     * @return Reference to member var_map_longlong_double
     */
    eProsima_user_DllExport std::map<int64_t, double>& var_map_longlong_double()
    {
        return m_var_map_longlong_double;
    }



private:

    std::map<int64_t, double> m_var_map_longlong_double;

};
/*!
 * @brief This class represents the structure MapLongLongLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongDouble(
            const MapLongLongLongDouble& x)
    {
                    m_var_map_longlong_longdouble = x.m_var_map_longlong_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongDouble(
            MapLongLongLongDouble&& x) noexcept
    {
        m_var_map_longlong_longdouble = std::move(x.m_var_map_longlong_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongDouble& operator =(
            const MapLongLongLongDouble& x)
    {

                    m_var_map_longlong_longdouble = x.m_var_map_longlong_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapLongLongLongDouble& operator =(
            MapLongLongLongDouble&& x) noexcept
    {

        m_var_map_longlong_longdouble = std::move(x.m_var_map_longlong_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongLongDouble& x) const
    {
        return (m_var_map_longlong_longdouble == x.m_var_map_longlong_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_longdouble
     * @param _var_map_longlong_longdouble New value to be copied in member var_map_longlong_longdouble
     */
    eProsima_user_DllExport void var_map_longlong_longdouble(
            const std::map<int64_t, long double>& _var_map_longlong_longdouble)
    {
        m_var_map_longlong_longdouble = _var_map_longlong_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_longdouble
     * @param _var_map_longlong_longdouble New value to be moved in member var_map_longlong_longdouble
     */
    eProsima_user_DllExport void var_map_longlong_longdouble(
            std::map<int64_t, long double>&& _var_map_longlong_longdouble)
    {
        m_var_map_longlong_longdouble = std::move(_var_map_longlong_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_longdouble
     * @return Constant reference to member var_map_longlong_longdouble
     */
    eProsima_user_DllExport const std::map<int64_t, long double>& var_map_longlong_longdouble() const
    {
        return m_var_map_longlong_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_longdouble
     * @return Reference to member var_map_longlong_longdouble
     */
    eProsima_user_DllExport std::map<int64_t, long double>& var_map_longlong_longdouble()
    {
        return m_var_map_longlong_longdouble;
    }



private:

    std::map<int64_t, long double> m_var_map_longlong_longdouble;

};
/*!
 * @brief This class represents the structure MapLongLongBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongLongBoolean(
            const MapLongLongBoolean& x)
    {
                    m_var_map_longlong_boolean = x.m_var_map_longlong_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongLongBoolean(
            MapLongLongBoolean&& x) noexcept
    {
        m_var_map_longlong_boolean = std::move(x.m_var_map_longlong_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongLongBoolean& operator =(
            const MapLongLongBoolean& x)
    {

                    m_var_map_longlong_boolean = x.m_var_map_longlong_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapLongLongBoolean& operator =(
            MapLongLongBoolean&& x) noexcept
    {

        m_var_map_longlong_boolean = std::move(x.m_var_map_longlong_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongBoolean& x) const
    {
        return (m_var_map_longlong_boolean == x.m_var_map_longlong_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_boolean
     * @param _var_map_longlong_boolean New value to be copied in member var_map_longlong_boolean
     */
    eProsima_user_DllExport void var_map_longlong_boolean(
            const std::map<int64_t, bool>& _var_map_longlong_boolean)
    {
        m_var_map_longlong_boolean = _var_map_longlong_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_boolean
     * @param _var_map_longlong_boolean New value to be moved in member var_map_longlong_boolean
     */
    eProsima_user_DllExport void var_map_longlong_boolean(
            std::map<int64_t, bool>&& _var_map_longlong_boolean)
    {
        m_var_map_longlong_boolean = std::move(_var_map_longlong_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_boolean
     * @return Constant reference to member var_map_longlong_boolean
     */
    eProsima_user_DllExport const std::map<int64_t, bool>& var_map_longlong_boolean() const
    {
        return m_var_map_longlong_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_boolean
     * @return Reference to member var_map_longlong_boolean
     */
    eProsima_user_DllExport std::map<int64_t, bool>& var_map_longlong_boolean()
    {
        return m_var_map_longlong_boolean;
    }



private:

    std::map<int64_t, bool> m_var_map_longlong_boolean;

};
/*!
 * @brief This class represents the structure MapLongLongOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongLongOctet(
            const MapLongLongOctet& x)
    {
                    m_var_map_longlong_octet = x.m_var_map_longlong_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongLongOctet(
            MapLongLongOctet&& x) noexcept
    {
        m_var_map_longlong_octet = std::move(x.m_var_map_longlong_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongLongOctet& operator =(
            const MapLongLongOctet& x)
    {

                    m_var_map_longlong_octet = x.m_var_map_longlong_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapLongLongOctet& operator =(
            MapLongLongOctet&& x) noexcept
    {

        m_var_map_longlong_octet = std::move(x.m_var_map_longlong_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongOctet& x) const
    {
        return (m_var_map_longlong_octet == x.m_var_map_longlong_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_octet
     * @param _var_map_longlong_octet New value to be copied in member var_map_longlong_octet
     */
    eProsima_user_DllExport void var_map_longlong_octet(
            const std::map<int64_t, uint8_t>& _var_map_longlong_octet)
    {
        m_var_map_longlong_octet = _var_map_longlong_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_octet
     * @param _var_map_longlong_octet New value to be moved in member var_map_longlong_octet
     */
    eProsima_user_DllExport void var_map_longlong_octet(
            std::map<int64_t, uint8_t>&& _var_map_longlong_octet)
    {
        m_var_map_longlong_octet = std::move(_var_map_longlong_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_octet
     * @return Constant reference to member var_map_longlong_octet
     */
    eProsima_user_DllExport const std::map<int64_t, uint8_t>& var_map_longlong_octet() const
    {
        return m_var_map_longlong_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_octet
     * @return Reference to member var_map_longlong_octet
     */
    eProsima_user_DllExport std::map<int64_t, uint8_t>& var_map_longlong_octet()
    {
        return m_var_map_longlong_octet;
    }



private:

    std::map<int64_t, uint8_t> m_var_map_longlong_octet;

};
/*!
 * @brief This class represents the structure MapLongLongChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongChar(
            const MapLongLongChar& x)
    {
                    m_var_map_longlong_char = x.m_var_map_longlong_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongChar(
            MapLongLongChar&& x) noexcept
    {
        m_var_map_longlong_char = std::move(x.m_var_map_longlong_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongChar& operator =(
            const MapLongLongChar& x)
    {

                    m_var_map_longlong_char = x.m_var_map_longlong_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongChar& operator =(
            MapLongLongChar&& x) noexcept
    {

        m_var_map_longlong_char = std::move(x.m_var_map_longlong_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongChar& x) const
    {
        return (m_var_map_longlong_char == x.m_var_map_longlong_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_char
     * @param _var_map_longlong_char New value to be copied in member var_map_longlong_char
     */
    eProsima_user_DllExport void var_map_longlong_char(
            const std::map<int64_t, char>& _var_map_longlong_char)
    {
        m_var_map_longlong_char = _var_map_longlong_char;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_char
     * @param _var_map_longlong_char New value to be moved in member var_map_longlong_char
     */
    eProsima_user_DllExport void var_map_longlong_char(
            std::map<int64_t, char>&& _var_map_longlong_char)
    {
        m_var_map_longlong_char = std::move(_var_map_longlong_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_char
     * @return Constant reference to member var_map_longlong_char
     */
    eProsima_user_DllExport const std::map<int64_t, char>& var_map_longlong_char() const
    {
        return m_var_map_longlong_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_char
     * @return Reference to member var_map_longlong_char
     */
    eProsima_user_DllExport std::map<int64_t, char>& var_map_longlong_char()
    {
        return m_var_map_longlong_char;
    }



private:

    std::map<int64_t, char> m_var_map_longlong_char;

};
/*!
 * @brief This class represents the structure MapLongLongWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongWChar(
            const MapLongLongWChar& x)
    {
                    m_var_map_longlong_wchar = x.m_var_map_longlong_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongWChar(
            MapLongLongWChar&& x) noexcept
    {
        m_var_map_longlong_wchar = std::move(x.m_var_map_longlong_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongWChar& operator =(
            const MapLongLongWChar& x)
    {

                    m_var_map_longlong_wchar = x.m_var_map_longlong_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapLongLongWChar& operator =(
            MapLongLongWChar&& x) noexcept
    {

        m_var_map_longlong_wchar = std::move(x.m_var_map_longlong_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongWChar& x) const
    {
        return (m_var_map_longlong_wchar == x.m_var_map_longlong_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_wchar
     * @param _var_map_longlong_wchar New value to be copied in member var_map_longlong_wchar
     */
    eProsima_user_DllExport void var_map_longlong_wchar(
            const std::map<int64_t, wchar_t>& _var_map_longlong_wchar)
    {
        m_var_map_longlong_wchar = _var_map_longlong_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_wchar
     * @param _var_map_longlong_wchar New value to be moved in member var_map_longlong_wchar
     */
    eProsima_user_DllExport void var_map_longlong_wchar(
            std::map<int64_t, wchar_t>&& _var_map_longlong_wchar)
    {
        m_var_map_longlong_wchar = std::move(_var_map_longlong_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_wchar
     * @return Constant reference to member var_map_longlong_wchar
     */
    eProsima_user_DllExport const std::map<int64_t, wchar_t>& var_map_longlong_wchar() const
    {
        return m_var_map_longlong_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_wchar
     * @return Reference to member var_map_longlong_wchar
     */
    eProsima_user_DllExport std::map<int64_t, wchar_t>& var_map_longlong_wchar()
    {
        return m_var_map_longlong_wchar;
    }



private:

    std::map<int64_t, wchar_t> m_var_map_longlong_wchar;

};
/*!
 * @brief This class represents the structure MapLongLongString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongString that will be copied.
     */
    eProsima_user_DllExport MapLongLongString(
            const MapLongLongString& x)
    {
                    m_var_map_longlong_string = x.m_var_map_longlong_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongString that will be copied.
     */
    eProsima_user_DllExport MapLongLongString(
            MapLongLongString&& x) noexcept
    {
        m_var_map_longlong_string = std::move(x.m_var_map_longlong_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongString that will be copied.
     */
    eProsima_user_DllExport MapLongLongString& operator =(
            const MapLongLongString& x)
    {

                    m_var_map_longlong_string = x.m_var_map_longlong_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongString that will be copied.
     */
    eProsima_user_DllExport MapLongLongString& operator =(
            MapLongLongString&& x) noexcept
    {

        m_var_map_longlong_string = std::move(x.m_var_map_longlong_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongString& x) const
    {
        return (m_var_map_longlong_string == x.m_var_map_longlong_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_string
     * @param _var_map_longlong_string New value to be copied in member var_map_longlong_string
     */
    eProsima_user_DllExport void var_map_longlong_string(
            const std::map<int64_t, std::string>& _var_map_longlong_string)
    {
        m_var_map_longlong_string = _var_map_longlong_string;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_string
     * @param _var_map_longlong_string New value to be moved in member var_map_longlong_string
     */
    eProsima_user_DllExport void var_map_longlong_string(
            std::map<int64_t, std::string>&& _var_map_longlong_string)
    {
        m_var_map_longlong_string = std::move(_var_map_longlong_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_string
     * @return Constant reference to member var_map_longlong_string
     */
    eProsima_user_DllExport const std::map<int64_t, std::string>& var_map_longlong_string() const
    {
        return m_var_map_longlong_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_string
     * @return Reference to member var_map_longlong_string
     */
    eProsima_user_DllExport std::map<int64_t, std::string>& var_map_longlong_string()
    {
        return m_var_map_longlong_string;
    }



private:

    std::map<int64_t, std::string> m_var_map_longlong_string;

};
/*!
 * @brief This class represents the structure MapLongLongWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongLongWString(
            const MapLongLongWString& x)
    {
                    m_var_map_longlong_wstring = x.m_var_map_longlong_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongLongWString(
            MapLongLongWString&& x) noexcept
    {
        m_var_map_longlong_wstring = std::move(x.m_var_map_longlong_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongLongWString& operator =(
            const MapLongLongWString& x)
    {

                    m_var_map_longlong_wstring = x.m_var_map_longlong_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongWString that will be copied.
     */
    eProsima_user_DllExport MapLongLongWString& operator =(
            MapLongLongWString&& x) noexcept
    {

        m_var_map_longlong_wstring = std::move(x.m_var_map_longlong_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongWString& x) const
    {
        return (m_var_map_longlong_wstring == x.m_var_map_longlong_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_wstring
     * @param _var_map_longlong_wstring New value to be copied in member var_map_longlong_wstring
     */
    eProsima_user_DllExport void var_map_longlong_wstring(
            const std::map<int64_t, std::wstring>& _var_map_longlong_wstring)
    {
        m_var_map_longlong_wstring = _var_map_longlong_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_wstring
     * @param _var_map_longlong_wstring New value to be moved in member var_map_longlong_wstring
     */
    eProsima_user_DllExport void var_map_longlong_wstring(
            std::map<int64_t, std::wstring>&& _var_map_longlong_wstring)
    {
        m_var_map_longlong_wstring = std::move(_var_map_longlong_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_wstring
     * @return Constant reference to member var_map_longlong_wstring
     */
    eProsima_user_DllExport const std::map<int64_t, std::wstring>& var_map_longlong_wstring() const
    {
        return m_var_map_longlong_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_wstring
     * @return Reference to member var_map_longlong_wstring
     */
    eProsima_user_DllExport std::map<int64_t, std::wstring>& var_map_longlong_wstring()
    {
        return m_var_map_longlong_wstring;
    }



private:

    std::map<int64_t, std::wstring> m_var_map_longlong_wstring;

};
/*!
 * @brief This class represents the structure MapLongLongInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedStringHelper(
            const MapLongLongInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_longlong_inneraliasboundedstringhelper = x.m_var_map_longlong_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedStringHelper(
            MapLongLongInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_longlong_inneraliasboundedstringhelper = std::move(x.m_var_map_longlong_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedStringHelper& operator =(
            const MapLongLongInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_longlong_inneraliasboundedstringhelper = x.m_var_map_longlong_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedStringHelper& operator =(
            MapLongLongInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_longlong_inneraliasboundedstringhelper = std::move(x.m_var_map_longlong_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_longlong_inneraliasboundedstringhelper == x.m_var_map_longlong_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_inneraliasboundedstringhelper
     * @param _var_map_longlong_inneraliasboundedstringhelper New value to be copied in member var_map_longlong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasboundedstringhelper(
            const std::map<int64_t, Inner_alias_bounded_string_helper>& _var_map_longlong_inneraliasboundedstringhelper)
    {
        m_var_map_longlong_inneraliasboundedstringhelper = _var_map_longlong_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_inneraliasboundedstringhelper
     * @param _var_map_longlong_inneraliasboundedstringhelper New value to be moved in member var_map_longlong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasboundedstringhelper(
            std::map<int64_t, Inner_alias_bounded_string_helper>&& _var_map_longlong_inneraliasboundedstringhelper)
    {
        m_var_map_longlong_inneraliasboundedstringhelper = std::move(_var_map_longlong_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_longlong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<int64_t, Inner_alias_bounded_string_helper>& var_map_longlong_inneraliasboundedstringhelper() const
    {
        return m_var_map_longlong_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_inneraliasboundedstringhelper
     * @return Reference to member var_map_longlong_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<int64_t, Inner_alias_bounded_string_helper>& var_map_longlong_inneraliasboundedstringhelper()
    {
        return m_var_map_longlong_inneraliasboundedstringhelper;
    }



private:

    std::map<int64_t, Inner_alias_bounded_string_helper> m_var_map_longlong_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedWStringHelper(
            const MapLongLongInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_longlong_inneraliasboundedwstringhelper = x.m_var_map_longlong_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedWStringHelper(
            MapLongLongInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_longlong_inneraliasboundedwstringhelper = std::move(x.m_var_map_longlong_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedWStringHelper& operator =(
            const MapLongLongInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_longlong_inneraliasboundedwstringhelper = x.m_var_map_longlong_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasBoundedWStringHelper& operator =(
            MapLongLongInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_longlong_inneraliasboundedwstringhelper = std::move(x.m_var_map_longlong_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_longlong_inneraliasboundedwstringhelper == x.m_var_map_longlong_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_inneraliasboundedwstringhelper
     * @param _var_map_longlong_inneraliasboundedwstringhelper New value to be copied in member var_map_longlong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasboundedwstringhelper(
            const std::map<int64_t, Inner_alias_bounded_wstring_helper>& _var_map_longlong_inneraliasboundedwstringhelper)
    {
        m_var_map_longlong_inneraliasboundedwstringhelper = _var_map_longlong_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_inneraliasboundedwstringhelper
     * @param _var_map_longlong_inneraliasboundedwstringhelper New value to be moved in member var_map_longlong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasboundedwstringhelper(
            std::map<int64_t, Inner_alias_bounded_wstring_helper>&& _var_map_longlong_inneraliasboundedwstringhelper)
    {
        m_var_map_longlong_inneraliasboundedwstringhelper = std::move(_var_map_longlong_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_longlong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<int64_t, Inner_alias_bounded_wstring_helper>& var_map_longlong_inneraliasboundedwstringhelper() const
    {
        return m_var_map_longlong_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_inneraliasboundedwstringhelper
     * @return Reference to member var_map_longlong_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<int64_t, Inner_alias_bounded_wstring_helper>& var_map_longlong_inneraliasboundedwstringhelper()
    {
        return m_var_map_longlong_inneraliasboundedwstringhelper;
    }



private:

    std::map<int64_t, Inner_alias_bounded_wstring_helper> m_var_map_longlong_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerEnumHelper(
            const MapLongLongInnerEnumHelper& x)
    {
                    m_var_map_longlong_innerenumhelper = x.m_var_map_longlong_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerEnumHelper(
            MapLongLongInnerEnumHelper&& x) noexcept
    {
        m_var_map_longlong_innerenumhelper = std::move(x.m_var_map_longlong_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerEnumHelper& operator =(
            const MapLongLongInnerEnumHelper& x)
    {

                    m_var_map_longlong_innerenumhelper = x.m_var_map_longlong_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerEnumHelper& operator =(
            MapLongLongInnerEnumHelper&& x) noexcept
    {

        m_var_map_longlong_innerenumhelper = std::move(x.m_var_map_longlong_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerEnumHelper& x) const
    {
        return (m_var_map_longlong_innerenumhelper == x.m_var_map_longlong_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_innerenumhelper
     * @param _var_map_longlong_innerenumhelper New value to be copied in member var_map_longlong_innerenumhelper
     */
    eProsima_user_DllExport void var_map_longlong_innerenumhelper(
            const std::map<int64_t, InnerEnumHelper>& _var_map_longlong_innerenumhelper)
    {
        m_var_map_longlong_innerenumhelper = _var_map_longlong_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_innerenumhelper
     * @param _var_map_longlong_innerenumhelper New value to be moved in member var_map_longlong_innerenumhelper
     */
    eProsima_user_DllExport void var_map_longlong_innerenumhelper(
            std::map<int64_t, InnerEnumHelper>&& _var_map_longlong_innerenumhelper)
    {
        m_var_map_longlong_innerenumhelper = std::move(_var_map_longlong_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_innerenumhelper
     * @return Constant reference to member var_map_longlong_innerenumhelper
     */
    eProsima_user_DllExport const std::map<int64_t, InnerEnumHelper>& var_map_longlong_innerenumhelper() const
    {
        return m_var_map_longlong_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_innerenumhelper
     * @return Reference to member var_map_longlong_innerenumhelper
     */
    eProsima_user_DllExport std::map<int64_t, InnerEnumHelper>& var_map_longlong_innerenumhelper()
    {
        return m_var_map_longlong_innerenumhelper;
    }



private:

    std::map<int64_t, InnerEnumHelper> m_var_map_longlong_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitMaskHelper(
            const MapLongLongInnerBitMaskHelper& x)
    {
                    m_var_map_longlong_innerbitmaskhelper = x.m_var_map_longlong_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitMaskHelper(
            MapLongLongInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_longlong_innerbitmaskhelper = std::move(x.m_var_map_longlong_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitMaskHelper& operator =(
            const MapLongLongInnerBitMaskHelper& x)
    {

                    m_var_map_longlong_innerbitmaskhelper = x.m_var_map_longlong_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitMaskHelper& operator =(
            MapLongLongInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_longlong_innerbitmaskhelper = std::move(x.m_var_map_longlong_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerBitMaskHelper& x) const
    {
        return (m_var_map_longlong_innerbitmaskhelper == x.m_var_map_longlong_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_innerbitmaskhelper
     * @param _var_map_longlong_innerbitmaskhelper New value to be copied in member var_map_longlong_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_longlong_innerbitmaskhelper(
            const std::map<int64_t, InnerBitMaskHelper>& _var_map_longlong_innerbitmaskhelper)
    {
        m_var_map_longlong_innerbitmaskhelper = _var_map_longlong_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_innerbitmaskhelper
     * @param _var_map_longlong_innerbitmaskhelper New value to be moved in member var_map_longlong_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_longlong_innerbitmaskhelper(
            std::map<int64_t, InnerBitMaskHelper>&& _var_map_longlong_innerbitmaskhelper)
    {
        m_var_map_longlong_innerbitmaskhelper = std::move(_var_map_longlong_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_innerbitmaskhelper
     * @return Constant reference to member var_map_longlong_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<int64_t, InnerBitMaskHelper>& var_map_longlong_innerbitmaskhelper() const
    {
        return m_var_map_longlong_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_innerbitmaskhelper
     * @return Reference to member var_map_longlong_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<int64_t, InnerBitMaskHelper>& var_map_longlong_innerbitmaskhelper()
    {
        return m_var_map_longlong_innerbitmaskhelper;
    }



private:

    std::map<int64_t, InnerBitMaskHelper> m_var_map_longlong_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasHelper(
            const MapLongLongInnerAliasHelper& x)
    {
                    m_var_map_longlong_inneraliashelper = x.m_var_map_longlong_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasHelper(
            MapLongLongInnerAliasHelper&& x) noexcept
    {
        m_var_map_longlong_inneraliashelper = std::move(x.m_var_map_longlong_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasHelper& operator =(
            const MapLongLongInnerAliasHelper& x)
    {

                    m_var_map_longlong_inneraliashelper = x.m_var_map_longlong_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasHelper& operator =(
            MapLongLongInnerAliasHelper&& x) noexcept
    {

        m_var_map_longlong_inneraliashelper = std::move(x.m_var_map_longlong_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerAliasHelper& x) const
    {
        return (m_var_map_longlong_inneraliashelper == x.m_var_map_longlong_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_inneraliashelper
     * @param _var_map_longlong_inneraliashelper New value to be copied in member var_map_longlong_inneraliashelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliashelper(
            const std::map<int64_t, InnerAliasHelper>& _var_map_longlong_inneraliashelper)
    {
        m_var_map_longlong_inneraliashelper = _var_map_longlong_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_inneraliashelper
     * @param _var_map_longlong_inneraliashelper New value to be moved in member var_map_longlong_inneraliashelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliashelper(
            std::map<int64_t, InnerAliasHelper>&& _var_map_longlong_inneraliashelper)
    {
        m_var_map_longlong_inneraliashelper = std::move(_var_map_longlong_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_inneraliashelper
     * @return Constant reference to member var_map_longlong_inneraliashelper
     */
    eProsima_user_DllExport const std::map<int64_t, InnerAliasHelper>& var_map_longlong_inneraliashelper() const
    {
        return m_var_map_longlong_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_inneraliashelper
     * @return Reference to member var_map_longlong_inneraliashelper
     */
    eProsima_user_DllExport std::map<int64_t, InnerAliasHelper>& var_map_longlong_inneraliashelper()
    {
        return m_var_map_longlong_inneraliashelper;
    }



private:

    std::map<int64_t, InnerAliasHelper> m_var_map_longlong_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasArrayHelper(
            const MapLongLongInnerAliasArrayHelper& x)
    {
                    m_var_map_longlong_inneraliasarrayhelper = x.m_var_map_longlong_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasArrayHelper(
            MapLongLongInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_longlong_inneraliasarrayhelper = std::move(x.m_var_map_longlong_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasArrayHelper& operator =(
            const MapLongLongInnerAliasArrayHelper& x)
    {

                    m_var_map_longlong_inneraliasarrayhelper = x.m_var_map_longlong_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasArrayHelper& operator =(
            MapLongLongInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_longlong_inneraliasarrayhelper = std::move(x.m_var_map_longlong_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerAliasArrayHelper& x) const
    {
        return (m_var_map_longlong_inneraliasarrayhelper == x.m_var_map_longlong_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_inneraliasarrayhelper
     * @param _var_map_longlong_inneraliasarrayhelper New value to be copied in member var_map_longlong_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasarrayhelper(
            const std::map<int64_t, Inner_alias_array_helper>& _var_map_longlong_inneraliasarrayhelper)
    {
        m_var_map_longlong_inneraliasarrayhelper = _var_map_longlong_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_inneraliasarrayhelper
     * @param _var_map_longlong_inneraliasarrayhelper New value to be moved in member var_map_longlong_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasarrayhelper(
            std::map<int64_t, Inner_alias_array_helper>&& _var_map_longlong_inneraliasarrayhelper)
    {
        m_var_map_longlong_inneraliasarrayhelper = std::move(_var_map_longlong_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_inneraliasarrayhelper
     * @return Constant reference to member var_map_longlong_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<int64_t, Inner_alias_array_helper>& var_map_longlong_inneraliasarrayhelper() const
    {
        return m_var_map_longlong_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_inneraliasarrayhelper
     * @return Reference to member var_map_longlong_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<int64_t, Inner_alias_array_helper>& var_map_longlong_inneraliasarrayhelper()
    {
        return m_var_map_longlong_inneraliasarrayhelper;
    }



private:

    std::map<int64_t, Inner_alias_array_helper> m_var_map_longlong_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasSequenceHelper(
            const MapLongLongInnerAliasSequenceHelper& x)
    {
                    m_var_map_longlong_inneraliassequencehelper = x.m_var_map_longlong_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasSequenceHelper(
            MapLongLongInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_longlong_inneraliassequencehelper = std::move(x.m_var_map_longlong_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasSequenceHelper& operator =(
            const MapLongLongInnerAliasSequenceHelper& x)
    {

                    m_var_map_longlong_inneraliassequencehelper = x.m_var_map_longlong_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasSequenceHelper& operator =(
            MapLongLongInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_longlong_inneraliassequencehelper = std::move(x.m_var_map_longlong_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_longlong_inneraliassequencehelper == x.m_var_map_longlong_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_inneraliassequencehelper
     * @param _var_map_longlong_inneraliassequencehelper New value to be copied in member var_map_longlong_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliassequencehelper(
            const std::map<int64_t, Inner_alias_sequence_helper>& _var_map_longlong_inneraliassequencehelper)
    {
        m_var_map_longlong_inneraliassequencehelper = _var_map_longlong_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_inneraliassequencehelper
     * @param _var_map_longlong_inneraliassequencehelper New value to be moved in member var_map_longlong_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliassequencehelper(
            std::map<int64_t, Inner_alias_sequence_helper>&& _var_map_longlong_inneraliassequencehelper)
    {
        m_var_map_longlong_inneraliassequencehelper = std::move(_var_map_longlong_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_inneraliassequencehelper
     * @return Constant reference to member var_map_longlong_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<int64_t, Inner_alias_sequence_helper>& var_map_longlong_inneraliassequencehelper() const
    {
        return m_var_map_longlong_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_inneraliassequencehelper
     * @return Reference to member var_map_longlong_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<int64_t, Inner_alias_sequence_helper>& var_map_longlong_inneraliassequencehelper()
    {
        return m_var_map_longlong_inneraliassequencehelper;
    }



private:

    std::map<int64_t, Inner_alias_sequence_helper> m_var_map_longlong_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasMapHelper(
            const MapLongLongInnerAliasMapHelper& x)
    {
                    m_var_map_longlong_inneraliasmaphelper = x.m_var_map_longlong_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasMapHelper(
            MapLongLongInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_longlong_inneraliasmaphelper = std::move(x.m_var_map_longlong_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasMapHelper& operator =(
            const MapLongLongInnerAliasMapHelper& x)
    {

                    m_var_map_longlong_inneraliasmaphelper = x.m_var_map_longlong_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerAliasMapHelper& operator =(
            MapLongLongInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_longlong_inneraliasmaphelper = std::move(x.m_var_map_longlong_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerAliasMapHelper& x) const
    {
        return (m_var_map_longlong_inneraliasmaphelper == x.m_var_map_longlong_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_inneraliasmaphelper
     * @param _var_map_longlong_inneraliasmaphelper New value to be copied in member var_map_longlong_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasmaphelper(
            const std::map<int64_t, Inner_alias_map_helper>& _var_map_longlong_inneraliasmaphelper)
    {
        m_var_map_longlong_inneraliasmaphelper = _var_map_longlong_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_inneraliasmaphelper
     * @param _var_map_longlong_inneraliasmaphelper New value to be moved in member var_map_longlong_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_longlong_inneraliasmaphelper(
            std::map<int64_t, Inner_alias_map_helper>&& _var_map_longlong_inneraliasmaphelper)
    {
        m_var_map_longlong_inneraliasmaphelper = std::move(_var_map_longlong_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_inneraliasmaphelper
     * @return Constant reference to member var_map_longlong_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<int64_t, Inner_alias_map_helper>& var_map_longlong_inneraliasmaphelper() const
    {
        return m_var_map_longlong_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_inneraliasmaphelper
     * @return Reference to member var_map_longlong_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<int64_t, Inner_alias_map_helper>& var_map_longlong_inneraliasmaphelper()
    {
        return m_var_map_longlong_inneraliasmaphelper;
    }



private:

    std::map<int64_t, Inner_alias_map_helper> m_var_map_longlong_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerUnionHelper(
            const MapLongLongInnerUnionHelper& x)
    {
                    m_var_map_longlong_innerunionhelper = x.m_var_map_longlong_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerUnionHelper(
            MapLongLongInnerUnionHelper&& x) noexcept
    {
        m_var_map_longlong_innerunionhelper = std::move(x.m_var_map_longlong_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerUnionHelper& operator =(
            const MapLongLongInnerUnionHelper& x)
    {

                    m_var_map_longlong_innerunionhelper = x.m_var_map_longlong_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerUnionHelper& operator =(
            MapLongLongInnerUnionHelper&& x) noexcept
    {

        m_var_map_longlong_innerunionhelper = std::move(x.m_var_map_longlong_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerUnionHelper& x) const
    {
        return (m_var_map_longlong_innerunionhelper == x.m_var_map_longlong_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_innerunionhelper
     * @param _var_map_longlong_innerunionhelper New value to be copied in member var_map_longlong_innerunionhelper
     */
    eProsima_user_DllExport void var_map_longlong_innerunionhelper(
            const std::map<int64_t, InnerUnionHelper>& _var_map_longlong_innerunionhelper)
    {
        m_var_map_longlong_innerunionhelper = _var_map_longlong_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_innerunionhelper
     * @param _var_map_longlong_innerunionhelper New value to be moved in member var_map_longlong_innerunionhelper
     */
    eProsima_user_DllExport void var_map_longlong_innerunionhelper(
            std::map<int64_t, InnerUnionHelper>&& _var_map_longlong_innerunionhelper)
    {
        m_var_map_longlong_innerunionhelper = std::move(_var_map_longlong_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_innerunionhelper
     * @return Constant reference to member var_map_longlong_innerunionhelper
     */
    eProsima_user_DllExport const std::map<int64_t, InnerUnionHelper>& var_map_longlong_innerunionhelper() const
    {
        return m_var_map_longlong_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_innerunionhelper
     * @return Reference to member var_map_longlong_innerunionhelper
     */
    eProsima_user_DllExport std::map<int64_t, InnerUnionHelper>& var_map_longlong_innerunionhelper()
    {
        return m_var_map_longlong_innerunionhelper;
    }



private:

    std::map<int64_t, InnerUnionHelper> m_var_map_longlong_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerStructureHelper(
            const MapLongLongInnerStructureHelper& x)
    {
                    m_var_map_longlong_innerstructurehelper = x.m_var_map_longlong_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerStructureHelper(
            MapLongLongInnerStructureHelper&& x) noexcept
    {
        m_var_map_longlong_innerstructurehelper = std::move(x.m_var_map_longlong_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerStructureHelper& operator =(
            const MapLongLongInnerStructureHelper& x)
    {

                    m_var_map_longlong_innerstructurehelper = x.m_var_map_longlong_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerStructureHelper& operator =(
            MapLongLongInnerStructureHelper&& x) noexcept
    {

        m_var_map_longlong_innerstructurehelper = std::move(x.m_var_map_longlong_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerStructureHelper& x) const
    {
        return (m_var_map_longlong_innerstructurehelper == x.m_var_map_longlong_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_innerstructurehelper
     * @param _var_map_longlong_innerstructurehelper New value to be copied in member var_map_longlong_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_longlong_innerstructurehelper(
            const std::map<int64_t, InnerStructureHelper>& _var_map_longlong_innerstructurehelper)
    {
        m_var_map_longlong_innerstructurehelper = _var_map_longlong_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_innerstructurehelper
     * @param _var_map_longlong_innerstructurehelper New value to be moved in member var_map_longlong_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_longlong_innerstructurehelper(
            std::map<int64_t, InnerStructureHelper>&& _var_map_longlong_innerstructurehelper)
    {
        m_var_map_longlong_innerstructurehelper = std::move(_var_map_longlong_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_innerstructurehelper
     * @return Constant reference to member var_map_longlong_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<int64_t, InnerStructureHelper>& var_map_longlong_innerstructurehelper() const
    {
        return m_var_map_longlong_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_innerstructurehelper
     * @return Reference to member var_map_longlong_innerstructurehelper
     */
    eProsima_user_DllExport std::map<int64_t, InnerStructureHelper>& var_map_longlong_innerstructurehelper()
    {
        return m_var_map_longlong_innerstructurehelper;
    }



private:

    std::map<int64_t, InnerStructureHelper> m_var_map_longlong_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapLongLongInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapLongLongInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapLongLongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapLongLongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapLongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitsetHelper(
            const MapLongLongInnerBitsetHelper& x)
    {
                    m_var_map_longlong_innerbitsethelper = x.m_var_map_longlong_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapLongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitsetHelper(
            MapLongLongInnerBitsetHelper&& x) noexcept
    {
        m_var_map_longlong_innerbitsethelper = std::move(x.m_var_map_longlong_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapLongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitsetHelper& operator =(
            const MapLongLongInnerBitsetHelper& x)
    {

                    m_var_map_longlong_innerbitsethelper = x.m_var_map_longlong_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapLongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapLongLongInnerBitsetHelper& operator =(
            MapLongLongInnerBitsetHelper&& x) noexcept
    {

        m_var_map_longlong_innerbitsethelper = std::move(x.m_var_map_longlong_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapLongLongInnerBitsetHelper& x) const
    {
        return (m_var_map_longlong_innerbitsethelper == x.m_var_map_longlong_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapLongLongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapLongLongInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_longlong_innerbitsethelper
     * @param _var_map_longlong_innerbitsethelper New value to be copied in member var_map_longlong_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_longlong_innerbitsethelper(
            const std::map<int64_t, InnerBitsetHelper>& _var_map_longlong_innerbitsethelper)
    {
        m_var_map_longlong_innerbitsethelper = _var_map_longlong_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_longlong_innerbitsethelper
     * @param _var_map_longlong_innerbitsethelper New value to be moved in member var_map_longlong_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_longlong_innerbitsethelper(
            std::map<int64_t, InnerBitsetHelper>&& _var_map_longlong_innerbitsethelper)
    {
        m_var_map_longlong_innerbitsethelper = std::move(_var_map_longlong_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_longlong_innerbitsethelper
     * @return Constant reference to member var_map_longlong_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<int64_t, InnerBitsetHelper>& var_map_longlong_innerbitsethelper() const
    {
        return m_var_map_longlong_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_longlong_innerbitsethelper
     * @return Reference to member var_map_longlong_innerbitsethelper
     */
    eProsima_user_DllExport std::map<int64_t, InnerBitsetHelper>& var_map_longlong_innerbitsethelper()
    {
        return m_var_map_longlong_innerbitsethelper;
    }



private:

    std::map<int64_t, InnerBitsetHelper> m_var_map_longlong_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapULongLongShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongShort(
            const MapULongLongShort& x)
    {
                    m_var_map_u_long_long_short = x.m_var_map_u_long_long_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongShort(
            MapULongLongShort&& x) noexcept
    {
        m_var_map_u_long_long_short = std::move(x.m_var_map_u_long_long_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongShort& operator =(
            const MapULongLongShort& x)
    {

                    m_var_map_u_long_long_short = x.m_var_map_u_long_long_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongShort& operator =(
            MapULongLongShort&& x) noexcept
    {

        m_var_map_u_long_long_short = std::move(x.m_var_map_u_long_long_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongShort& x) const
    {
        return (m_var_map_u_long_long_short == x.m_var_map_u_long_long_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_short
     * @param _var_map_u_long_long_short New value to be copied in member var_map_u_long_long_short
     */
    eProsima_user_DllExport void var_map_u_long_long_short(
            const std::map<uint64_t, int16_t>& _var_map_u_long_long_short)
    {
        m_var_map_u_long_long_short = _var_map_u_long_long_short;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_short
     * @param _var_map_u_long_long_short New value to be moved in member var_map_u_long_long_short
     */
    eProsima_user_DllExport void var_map_u_long_long_short(
            std::map<uint64_t, int16_t>&& _var_map_u_long_long_short)
    {
        m_var_map_u_long_long_short = std::move(_var_map_u_long_long_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_short
     * @return Constant reference to member var_map_u_long_long_short
     */
    eProsima_user_DllExport const std::map<uint64_t, int16_t>& var_map_u_long_long_short() const
    {
        return m_var_map_u_long_long_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_short
     * @return Reference to member var_map_u_long_long_short
     */
    eProsima_user_DllExport std::map<uint64_t, int16_t>& var_map_u_long_long_short()
    {
        return m_var_map_u_long_long_short;
    }



private:

    std::map<uint64_t, int16_t> m_var_map_u_long_long_short;

};
/*!
 * @brief This class represents the structure MapULongLongUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongUShort(
            const MapULongLongUShort& x)
    {
                    m_var_map_u_long_long_u_short = x.m_var_map_u_long_long_u_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongUShort(
            MapULongLongUShort&& x) noexcept
    {
        m_var_map_u_long_long_u_short = std::move(x.m_var_map_u_long_long_u_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongUShort& operator =(
            const MapULongLongUShort& x)
    {

                    m_var_map_u_long_long_u_short = x.m_var_map_u_long_long_u_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongUShort that will be copied.
     */
    eProsima_user_DllExport MapULongLongUShort& operator =(
            MapULongLongUShort&& x) noexcept
    {

        m_var_map_u_long_long_u_short = std::move(x.m_var_map_u_long_long_u_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongUShort& x) const
    {
        return (m_var_map_u_long_long_u_short == x.m_var_map_u_long_long_u_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_u_short
     * @param _var_map_u_long_long_u_short New value to be copied in member var_map_u_long_long_u_short
     */
    eProsima_user_DllExport void var_map_u_long_long_u_short(
            const std::map<uint64_t, uint16_t>& _var_map_u_long_long_u_short)
    {
        m_var_map_u_long_long_u_short = _var_map_u_long_long_u_short;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_u_short
     * @param _var_map_u_long_long_u_short New value to be moved in member var_map_u_long_long_u_short
     */
    eProsima_user_DllExport void var_map_u_long_long_u_short(
            std::map<uint64_t, uint16_t>&& _var_map_u_long_long_u_short)
    {
        m_var_map_u_long_long_u_short = std::move(_var_map_u_long_long_u_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_u_short
     * @return Constant reference to member var_map_u_long_long_u_short
     */
    eProsima_user_DllExport const std::map<uint64_t, uint16_t>& var_map_u_long_long_u_short() const
    {
        return m_var_map_u_long_long_u_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_u_short
     * @return Reference to member var_map_u_long_long_u_short
     */
    eProsima_user_DllExport std::map<uint64_t, uint16_t>& var_map_u_long_long_u_short()
    {
        return m_var_map_u_long_long_u_short;
    }



private:

    std::map<uint64_t, uint16_t> m_var_map_u_long_long_u_short;

};
/*!
 * @brief This class represents the structure MapULongLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLong(
            const MapULongLongLong& x)
    {
                    m_var_map_u_long_long_long = x.m_var_map_u_long_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLong(
            MapULongLongLong&& x) noexcept
    {
        m_var_map_u_long_long_long = std::move(x.m_var_map_u_long_long_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLong& operator =(
            const MapULongLongLong& x)
    {

                    m_var_map_u_long_long_long = x.m_var_map_u_long_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLong& operator =(
            MapULongLongLong&& x) noexcept
    {

        m_var_map_u_long_long_long = std::move(x.m_var_map_u_long_long_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongLong& x) const
    {
        return (m_var_map_u_long_long_long == x.m_var_map_u_long_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_long
     * @param _var_map_u_long_long_long New value to be copied in member var_map_u_long_long_long
     */
    eProsima_user_DllExport void var_map_u_long_long_long(
            const std::map<uint64_t, int32_t>& _var_map_u_long_long_long)
    {
        m_var_map_u_long_long_long = _var_map_u_long_long_long;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_long
     * @param _var_map_u_long_long_long New value to be moved in member var_map_u_long_long_long
     */
    eProsima_user_DllExport void var_map_u_long_long_long(
            std::map<uint64_t, int32_t>&& _var_map_u_long_long_long)
    {
        m_var_map_u_long_long_long = std::move(_var_map_u_long_long_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_long
     * @return Constant reference to member var_map_u_long_long_long
     */
    eProsima_user_DllExport const std::map<uint64_t, int32_t>& var_map_u_long_long_long() const
    {
        return m_var_map_u_long_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_long
     * @return Reference to member var_map_u_long_long_long
     */
    eProsima_user_DllExport std::map<uint64_t, int32_t>& var_map_u_long_long_long()
    {
        return m_var_map_u_long_long_long;
    }



private:

    std::map<uint64_t, int32_t> m_var_map_u_long_long_long;

};
/*!
 * @brief This class represents the structure MapULongLongULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongULong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULong(
            const MapULongLongULong& x)
    {
                    m_var_map_u_long_long_u_long = x.m_var_map_u_long_long_u_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongULong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULong(
            MapULongLongULong&& x) noexcept
    {
        m_var_map_u_long_long_u_long = std::move(x.m_var_map_u_long_long_u_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongULong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULong& operator =(
            const MapULongLongULong& x)
    {

                    m_var_map_u_long_long_u_long = x.m_var_map_u_long_long_u_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongULong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULong& operator =(
            MapULongLongULong&& x) noexcept
    {

        m_var_map_u_long_long_u_long = std::move(x.m_var_map_u_long_long_u_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongULong& x) const
    {
        return (m_var_map_u_long_long_u_long == x.m_var_map_u_long_long_u_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_u_long
     * @param _var_map_u_long_long_u_long New value to be copied in member var_map_u_long_long_u_long
     */
    eProsima_user_DllExport void var_map_u_long_long_u_long(
            const std::map<uint64_t, uint32_t>& _var_map_u_long_long_u_long)
    {
        m_var_map_u_long_long_u_long = _var_map_u_long_long_u_long;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_u_long
     * @param _var_map_u_long_long_u_long New value to be moved in member var_map_u_long_long_u_long
     */
    eProsima_user_DllExport void var_map_u_long_long_u_long(
            std::map<uint64_t, uint32_t>&& _var_map_u_long_long_u_long)
    {
        m_var_map_u_long_long_u_long = std::move(_var_map_u_long_long_u_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_u_long
     * @return Constant reference to member var_map_u_long_long_u_long
     */
    eProsima_user_DllExport const std::map<uint64_t, uint32_t>& var_map_u_long_long_u_long() const
    {
        return m_var_map_u_long_long_u_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_u_long
     * @return Reference to member var_map_u_long_long_u_long
     */
    eProsima_user_DllExport std::map<uint64_t, uint32_t>& var_map_u_long_long_u_long()
    {
        return m_var_map_u_long_long_u_long;
    }



private:

    std::map<uint64_t, uint32_t> m_var_map_u_long_long_u_long;

};
/*!
 * @brief This class represents the structure MapULongLongLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongLong(
            const MapULongLongLongLong& x)
    {
                    m_var_map_u_long_long_long_long = x.m_var_map_u_long_long_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongLong(
            MapULongLongLongLong&& x) noexcept
    {
        m_var_map_u_long_long_long_long = std::move(x.m_var_map_u_long_long_long_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongLong& operator =(
            const MapULongLongLongLong& x)
    {

                    m_var_map_u_long_long_long_long = x.m_var_map_u_long_long_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongLongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongLong& operator =(
            MapULongLongLongLong&& x) noexcept
    {

        m_var_map_u_long_long_long_long = std::move(x.m_var_map_u_long_long_long_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongLongLong& x) const
    {
        return (m_var_map_u_long_long_long_long == x.m_var_map_u_long_long_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_long_long
     * @param _var_map_u_long_long_long_long New value to be copied in member var_map_u_long_long_long_long
     */
    eProsima_user_DllExport void var_map_u_long_long_long_long(
            const std::map<uint64_t, int64_t>& _var_map_u_long_long_long_long)
    {
        m_var_map_u_long_long_long_long = _var_map_u_long_long_long_long;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_long_long
     * @param _var_map_u_long_long_long_long New value to be moved in member var_map_u_long_long_long_long
     */
    eProsima_user_DllExport void var_map_u_long_long_long_long(
            std::map<uint64_t, int64_t>&& _var_map_u_long_long_long_long)
    {
        m_var_map_u_long_long_long_long = std::move(_var_map_u_long_long_long_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_long_long
     * @return Constant reference to member var_map_u_long_long_long_long
     */
    eProsima_user_DllExport const std::map<uint64_t, int64_t>& var_map_u_long_long_long_long() const
    {
        return m_var_map_u_long_long_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_long_long
     * @return Reference to member var_map_u_long_long_long_long
     */
    eProsima_user_DllExport std::map<uint64_t, int64_t>& var_map_u_long_long_long_long()
    {
        return m_var_map_u_long_long_long_long;
    }



private:

    std::map<uint64_t, int64_t> m_var_map_u_long_long_long_long;

};
/*!
 * @brief This class represents the structure MapULongLongULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULongLong(
            const MapULongLongULongLong& x)
    {
                    m_var_map_u_long_long_u_long_long = x.m_var_map_u_long_long_u_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULongLong(
            MapULongLongULongLong&& x) noexcept
    {
        m_var_map_u_long_long_u_long_long = std::move(x.m_var_map_u_long_long_u_long_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULongLong& operator =(
            const MapULongLongULongLong& x)
    {

                    m_var_map_u_long_long_u_long_long = x.m_var_map_u_long_long_u_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongULongLong that will be copied.
     */
    eProsima_user_DllExport MapULongLongULongLong& operator =(
            MapULongLongULongLong&& x) noexcept
    {

        m_var_map_u_long_long_u_long_long = std::move(x.m_var_map_u_long_long_u_long_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongULongLong& x) const
    {
        return (m_var_map_u_long_long_u_long_long == x.m_var_map_u_long_long_u_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_u_long_long
     * @param _var_map_u_long_long_u_long_long New value to be copied in member var_map_u_long_long_u_long_long
     */
    eProsima_user_DllExport void var_map_u_long_long_u_long_long(
            const std::map<uint64_t, uint64_t>& _var_map_u_long_long_u_long_long)
    {
        m_var_map_u_long_long_u_long_long = _var_map_u_long_long_u_long_long;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_u_long_long
     * @param _var_map_u_long_long_u_long_long New value to be moved in member var_map_u_long_long_u_long_long
     */
    eProsima_user_DllExport void var_map_u_long_long_u_long_long(
            std::map<uint64_t, uint64_t>&& _var_map_u_long_long_u_long_long)
    {
        m_var_map_u_long_long_u_long_long = std::move(_var_map_u_long_long_u_long_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_u_long_long
     * @return Constant reference to member var_map_u_long_long_u_long_long
     */
    eProsima_user_DllExport const std::map<uint64_t, uint64_t>& var_map_u_long_long_u_long_long() const
    {
        return m_var_map_u_long_long_u_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_u_long_long
     * @return Reference to member var_map_u_long_long_u_long_long
     */
    eProsima_user_DllExport std::map<uint64_t, uint64_t>& var_map_u_long_long_u_long_long()
    {
        return m_var_map_u_long_long_u_long_long;
    }



private:

    std::map<uint64_t, uint64_t> m_var_map_u_long_long_u_long_long;

};
/*!
 * @brief This class represents the structure MapULongLongFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongLongFloat(
            const MapULongLongFloat& x)
    {
                    m_var_map_u_long_long_float = x.m_var_map_u_long_long_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongLongFloat(
            MapULongLongFloat&& x) noexcept
    {
        m_var_map_u_long_long_float = std::move(x.m_var_map_u_long_long_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongLongFloat& operator =(
            const MapULongLongFloat& x)
    {

                    m_var_map_u_long_long_float = x.m_var_map_u_long_long_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongFloat that will be copied.
     */
    eProsima_user_DllExport MapULongLongFloat& operator =(
            MapULongLongFloat&& x) noexcept
    {

        m_var_map_u_long_long_float = std::move(x.m_var_map_u_long_long_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongFloat& x) const
    {
        return (m_var_map_u_long_long_float == x.m_var_map_u_long_long_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_float
     * @param _var_map_u_long_long_float New value to be copied in member var_map_u_long_long_float
     */
    eProsima_user_DllExport void var_map_u_long_long_float(
            const std::map<uint64_t, float>& _var_map_u_long_long_float)
    {
        m_var_map_u_long_long_float = _var_map_u_long_long_float;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_float
     * @param _var_map_u_long_long_float New value to be moved in member var_map_u_long_long_float
     */
    eProsima_user_DllExport void var_map_u_long_long_float(
            std::map<uint64_t, float>&& _var_map_u_long_long_float)
    {
        m_var_map_u_long_long_float = std::move(_var_map_u_long_long_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_float
     * @return Constant reference to member var_map_u_long_long_float
     */
    eProsima_user_DllExport const std::map<uint64_t, float>& var_map_u_long_long_float() const
    {
        return m_var_map_u_long_long_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_float
     * @return Reference to member var_map_u_long_long_float
     */
    eProsima_user_DllExport std::map<uint64_t, float>& var_map_u_long_long_float()
    {
        return m_var_map_u_long_long_float;
    }



private:

    std::map<uint64_t, float> m_var_map_u_long_long_float;

};
/*!
 * @brief This class represents the structure MapKeyULongLongValueDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapKeyULongLongValueDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapKeyULongLongValueDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapKeyULongLongValueDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapKeyULongLongValueDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongLongValueDouble(
            const MapKeyULongLongValueDouble& x)
    {
                    m_var_map_u_long_long_double = x.m_var_map_u_long_long_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapKeyULongLongValueDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongLongValueDouble(
            MapKeyULongLongValueDouble&& x) noexcept
    {
        m_var_map_u_long_long_double = std::move(x.m_var_map_u_long_long_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapKeyULongLongValueDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongLongValueDouble& operator =(
            const MapKeyULongLongValueDouble& x)
    {

                    m_var_map_u_long_long_double = x.m_var_map_u_long_long_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapKeyULongLongValueDouble that will be copied.
     */
    eProsima_user_DllExport MapKeyULongLongValueDouble& operator =(
            MapKeyULongLongValueDouble&& x) noexcept
    {

        m_var_map_u_long_long_double = std::move(x.m_var_map_u_long_long_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapKeyULongLongValueDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapKeyULongLongValueDouble& x) const
    {
        return (m_var_map_u_long_long_double == x.m_var_map_u_long_long_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapKeyULongLongValueDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapKeyULongLongValueDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_double
     * @param _var_map_u_long_long_double New value to be copied in member var_map_u_long_long_double
     */
    eProsima_user_DllExport void var_map_u_long_long_double(
            const std::map<uint64_t, double>& _var_map_u_long_long_double)
    {
        m_var_map_u_long_long_double = _var_map_u_long_long_double;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_double
     * @param _var_map_u_long_long_double New value to be moved in member var_map_u_long_long_double
     */
    eProsima_user_DllExport void var_map_u_long_long_double(
            std::map<uint64_t, double>&& _var_map_u_long_long_double)
    {
        m_var_map_u_long_long_double = std::move(_var_map_u_long_long_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_double
     * @return Constant reference to member var_map_u_long_long_double
     */
    eProsima_user_DllExport const std::map<uint64_t, double>& var_map_u_long_long_double() const
    {
        return m_var_map_u_long_long_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_double
     * @return Reference to member var_map_u_long_long_double
     */
    eProsima_user_DllExport std::map<uint64_t, double>& var_map_u_long_long_double()
    {
        return m_var_map_u_long_long_double;
    }



private:

    std::map<uint64_t, double> m_var_map_u_long_long_double;

};
/*!
 * @brief This class represents the structure MapULongLongLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongDouble(
            const MapULongLongLongDouble& x)
    {
                    m_var_map_u_long_long_long_double = x.m_var_map_u_long_long_long_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongDouble(
            MapULongLongLongDouble&& x) noexcept
    {
        m_var_map_u_long_long_long_double = std::move(x.m_var_map_u_long_long_long_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongDouble& operator =(
            const MapULongLongLongDouble& x)
    {

                    m_var_map_u_long_long_long_double = x.m_var_map_u_long_long_long_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongLongDouble that will be copied.
     */
    eProsima_user_DllExport MapULongLongLongDouble& operator =(
            MapULongLongLongDouble&& x) noexcept
    {

        m_var_map_u_long_long_long_double = std::move(x.m_var_map_u_long_long_long_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongLongDouble& x) const
    {
        return (m_var_map_u_long_long_long_double == x.m_var_map_u_long_long_long_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_long_double
     * @param _var_map_u_long_long_long_double New value to be copied in member var_map_u_long_long_long_double
     */
    eProsima_user_DllExport void var_map_u_long_long_long_double(
            const std::map<uint64_t, long double>& _var_map_u_long_long_long_double)
    {
        m_var_map_u_long_long_long_double = _var_map_u_long_long_long_double;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_long_double
     * @param _var_map_u_long_long_long_double New value to be moved in member var_map_u_long_long_long_double
     */
    eProsima_user_DllExport void var_map_u_long_long_long_double(
            std::map<uint64_t, long double>&& _var_map_u_long_long_long_double)
    {
        m_var_map_u_long_long_long_double = std::move(_var_map_u_long_long_long_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_long_double
     * @return Constant reference to member var_map_u_long_long_long_double
     */
    eProsima_user_DllExport const std::map<uint64_t, long double>& var_map_u_long_long_long_double() const
    {
        return m_var_map_u_long_long_long_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_long_double
     * @return Reference to member var_map_u_long_long_long_double
     */
    eProsima_user_DllExport std::map<uint64_t, long double>& var_map_u_long_long_long_double()
    {
        return m_var_map_u_long_long_long_double;
    }



private:

    std::map<uint64_t, long double> m_var_map_u_long_long_long_double;

};
/*!
 * @brief This class represents the structure MapULongLongBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongLongBoolean(
            const MapULongLongBoolean& x)
    {
                    m_var_map_u_long_long_boolean = x.m_var_map_u_long_long_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongLongBoolean(
            MapULongLongBoolean&& x) noexcept
    {
        m_var_map_u_long_long_boolean = std::move(x.m_var_map_u_long_long_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongLongBoolean& operator =(
            const MapULongLongBoolean& x)
    {

                    m_var_map_u_long_long_boolean = x.m_var_map_u_long_long_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongBoolean that will be copied.
     */
    eProsima_user_DllExport MapULongLongBoolean& operator =(
            MapULongLongBoolean&& x) noexcept
    {

        m_var_map_u_long_long_boolean = std::move(x.m_var_map_u_long_long_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongBoolean& x) const
    {
        return (m_var_map_u_long_long_boolean == x.m_var_map_u_long_long_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_boolean
     * @param _var_map_u_long_long_boolean New value to be copied in member var_map_u_long_long_boolean
     */
    eProsima_user_DllExport void var_map_u_long_long_boolean(
            const std::map<uint64_t, bool>& _var_map_u_long_long_boolean)
    {
        m_var_map_u_long_long_boolean = _var_map_u_long_long_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_boolean
     * @param _var_map_u_long_long_boolean New value to be moved in member var_map_u_long_long_boolean
     */
    eProsima_user_DllExport void var_map_u_long_long_boolean(
            std::map<uint64_t, bool>&& _var_map_u_long_long_boolean)
    {
        m_var_map_u_long_long_boolean = std::move(_var_map_u_long_long_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_boolean
     * @return Constant reference to member var_map_u_long_long_boolean
     */
    eProsima_user_DllExport const std::map<uint64_t, bool>& var_map_u_long_long_boolean() const
    {
        return m_var_map_u_long_long_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_boolean
     * @return Reference to member var_map_u_long_long_boolean
     */
    eProsima_user_DllExport std::map<uint64_t, bool>& var_map_u_long_long_boolean()
    {
        return m_var_map_u_long_long_boolean;
    }



private:

    std::map<uint64_t, bool> m_var_map_u_long_long_boolean;

};
/*!
 * @brief This class represents the structure MapULongLongOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongLongOctet(
            const MapULongLongOctet& x)
    {
                    m_var_map_u_long_long_octet = x.m_var_map_u_long_long_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongLongOctet(
            MapULongLongOctet&& x) noexcept
    {
        m_var_map_u_long_long_octet = std::move(x.m_var_map_u_long_long_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongLongOctet& operator =(
            const MapULongLongOctet& x)
    {

                    m_var_map_u_long_long_octet = x.m_var_map_u_long_long_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongOctet that will be copied.
     */
    eProsima_user_DllExport MapULongLongOctet& operator =(
            MapULongLongOctet&& x) noexcept
    {

        m_var_map_u_long_long_octet = std::move(x.m_var_map_u_long_long_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongOctet& x) const
    {
        return (m_var_map_u_long_long_octet == x.m_var_map_u_long_long_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_octet
     * @param _var_map_u_long_long_octet New value to be copied in member var_map_u_long_long_octet
     */
    eProsima_user_DllExport void var_map_u_long_long_octet(
            const std::map<uint64_t, uint8_t>& _var_map_u_long_long_octet)
    {
        m_var_map_u_long_long_octet = _var_map_u_long_long_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_octet
     * @param _var_map_u_long_long_octet New value to be moved in member var_map_u_long_long_octet
     */
    eProsima_user_DllExport void var_map_u_long_long_octet(
            std::map<uint64_t, uint8_t>&& _var_map_u_long_long_octet)
    {
        m_var_map_u_long_long_octet = std::move(_var_map_u_long_long_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_octet
     * @return Constant reference to member var_map_u_long_long_octet
     */
    eProsima_user_DllExport const std::map<uint64_t, uint8_t>& var_map_u_long_long_octet() const
    {
        return m_var_map_u_long_long_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_octet
     * @return Reference to member var_map_u_long_long_octet
     */
    eProsima_user_DllExport std::map<uint64_t, uint8_t>& var_map_u_long_long_octet()
    {
        return m_var_map_u_long_long_octet;
    }



private:

    std::map<uint64_t, uint8_t> m_var_map_u_long_long_octet;

};
/*!
 * @brief This class represents the structure MapULongLongChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongChar(
            const MapULongLongChar& x)
    {
                    m_var_map_u_long_long_char = x.m_var_map_u_long_long_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongChar(
            MapULongLongChar&& x) noexcept
    {
        m_var_map_u_long_long_char = std::move(x.m_var_map_u_long_long_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongChar& operator =(
            const MapULongLongChar& x)
    {

                    m_var_map_u_long_long_char = x.m_var_map_u_long_long_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongChar& operator =(
            MapULongLongChar&& x) noexcept
    {

        m_var_map_u_long_long_char = std::move(x.m_var_map_u_long_long_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongChar& x) const
    {
        return (m_var_map_u_long_long_char == x.m_var_map_u_long_long_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_char
     * @param _var_map_u_long_long_char New value to be copied in member var_map_u_long_long_char
     */
    eProsima_user_DllExport void var_map_u_long_long_char(
            const std::map<uint64_t, char>& _var_map_u_long_long_char)
    {
        m_var_map_u_long_long_char = _var_map_u_long_long_char;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_char
     * @param _var_map_u_long_long_char New value to be moved in member var_map_u_long_long_char
     */
    eProsima_user_DllExport void var_map_u_long_long_char(
            std::map<uint64_t, char>&& _var_map_u_long_long_char)
    {
        m_var_map_u_long_long_char = std::move(_var_map_u_long_long_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_char
     * @return Constant reference to member var_map_u_long_long_char
     */
    eProsima_user_DllExport const std::map<uint64_t, char>& var_map_u_long_long_char() const
    {
        return m_var_map_u_long_long_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_char
     * @return Reference to member var_map_u_long_long_char
     */
    eProsima_user_DllExport std::map<uint64_t, char>& var_map_u_long_long_char()
    {
        return m_var_map_u_long_long_char;
    }



private:

    std::map<uint64_t, char> m_var_map_u_long_long_char;

};
/*!
 * @brief This class represents the structure MapULongLongWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongWChar(
            const MapULongLongWChar& x)
    {
                    m_var_map_u_long_long_wchar = x.m_var_map_u_long_long_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongWChar(
            MapULongLongWChar&& x) noexcept
    {
        m_var_map_u_long_long_wchar = std::move(x.m_var_map_u_long_long_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongWChar& operator =(
            const MapULongLongWChar& x)
    {

                    m_var_map_u_long_long_wchar = x.m_var_map_u_long_long_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongWChar that will be copied.
     */
    eProsima_user_DllExport MapULongLongWChar& operator =(
            MapULongLongWChar&& x) noexcept
    {

        m_var_map_u_long_long_wchar = std::move(x.m_var_map_u_long_long_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongWChar& x) const
    {
        return (m_var_map_u_long_long_wchar == x.m_var_map_u_long_long_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_wchar
     * @param _var_map_u_long_long_wchar New value to be copied in member var_map_u_long_long_wchar
     */
    eProsima_user_DllExport void var_map_u_long_long_wchar(
            const std::map<uint64_t, wchar_t>& _var_map_u_long_long_wchar)
    {
        m_var_map_u_long_long_wchar = _var_map_u_long_long_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_wchar
     * @param _var_map_u_long_long_wchar New value to be moved in member var_map_u_long_long_wchar
     */
    eProsima_user_DllExport void var_map_u_long_long_wchar(
            std::map<uint64_t, wchar_t>&& _var_map_u_long_long_wchar)
    {
        m_var_map_u_long_long_wchar = std::move(_var_map_u_long_long_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_wchar
     * @return Constant reference to member var_map_u_long_long_wchar
     */
    eProsima_user_DllExport const std::map<uint64_t, wchar_t>& var_map_u_long_long_wchar() const
    {
        return m_var_map_u_long_long_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_wchar
     * @return Reference to member var_map_u_long_long_wchar
     */
    eProsima_user_DllExport std::map<uint64_t, wchar_t>& var_map_u_long_long_wchar()
    {
        return m_var_map_u_long_long_wchar;
    }



private:

    std::map<uint64_t, wchar_t> m_var_map_u_long_long_wchar;

};
/*!
 * @brief This class represents the structure MapULongLongString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongString that will be copied.
     */
    eProsima_user_DllExport MapULongLongString(
            const MapULongLongString& x)
    {
                    m_var_map_u_long_long_string = x.m_var_map_u_long_long_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongString that will be copied.
     */
    eProsima_user_DllExport MapULongLongString(
            MapULongLongString&& x) noexcept
    {
        m_var_map_u_long_long_string = std::move(x.m_var_map_u_long_long_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongString that will be copied.
     */
    eProsima_user_DllExport MapULongLongString& operator =(
            const MapULongLongString& x)
    {

                    m_var_map_u_long_long_string = x.m_var_map_u_long_long_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongString that will be copied.
     */
    eProsima_user_DllExport MapULongLongString& operator =(
            MapULongLongString&& x) noexcept
    {

        m_var_map_u_long_long_string = std::move(x.m_var_map_u_long_long_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongString& x) const
    {
        return (m_var_map_u_long_long_string == x.m_var_map_u_long_long_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_string
     * @param _var_map_u_long_long_string New value to be copied in member var_map_u_long_long_string
     */
    eProsima_user_DllExport void var_map_u_long_long_string(
            const std::map<uint64_t, std::string>& _var_map_u_long_long_string)
    {
        m_var_map_u_long_long_string = _var_map_u_long_long_string;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_string
     * @param _var_map_u_long_long_string New value to be moved in member var_map_u_long_long_string
     */
    eProsima_user_DllExport void var_map_u_long_long_string(
            std::map<uint64_t, std::string>&& _var_map_u_long_long_string)
    {
        m_var_map_u_long_long_string = std::move(_var_map_u_long_long_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_string
     * @return Constant reference to member var_map_u_long_long_string
     */
    eProsima_user_DllExport const std::map<uint64_t, std::string>& var_map_u_long_long_string() const
    {
        return m_var_map_u_long_long_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_string
     * @return Reference to member var_map_u_long_long_string
     */
    eProsima_user_DllExport std::map<uint64_t, std::string>& var_map_u_long_long_string()
    {
        return m_var_map_u_long_long_string;
    }



private:

    std::map<uint64_t, std::string> m_var_map_u_long_long_string;

};
/*!
 * @brief This class represents the structure MapULongLongWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongWString that will be copied.
     */
    eProsima_user_DllExport MapULongLongWString(
            const MapULongLongWString& x)
    {
                    m_var_map_u_long_long_wstring = x.m_var_map_u_long_long_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongWString that will be copied.
     */
    eProsima_user_DllExport MapULongLongWString(
            MapULongLongWString&& x) noexcept
    {
        m_var_map_u_long_long_wstring = std::move(x.m_var_map_u_long_long_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongWString that will be copied.
     */
    eProsima_user_DllExport MapULongLongWString& operator =(
            const MapULongLongWString& x)
    {

                    m_var_map_u_long_long_wstring = x.m_var_map_u_long_long_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongWString that will be copied.
     */
    eProsima_user_DllExport MapULongLongWString& operator =(
            MapULongLongWString&& x) noexcept
    {

        m_var_map_u_long_long_wstring = std::move(x.m_var_map_u_long_long_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongWString& x) const
    {
        return (m_var_map_u_long_long_wstring == x.m_var_map_u_long_long_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_wstring
     * @param _var_map_u_long_long_wstring New value to be copied in member var_map_u_long_long_wstring
     */
    eProsima_user_DllExport void var_map_u_long_long_wstring(
            const std::map<uint64_t, std::wstring>& _var_map_u_long_long_wstring)
    {
        m_var_map_u_long_long_wstring = _var_map_u_long_long_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_wstring
     * @param _var_map_u_long_long_wstring New value to be moved in member var_map_u_long_long_wstring
     */
    eProsima_user_DllExport void var_map_u_long_long_wstring(
            std::map<uint64_t, std::wstring>&& _var_map_u_long_long_wstring)
    {
        m_var_map_u_long_long_wstring = std::move(_var_map_u_long_long_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_wstring
     * @return Constant reference to member var_map_u_long_long_wstring
     */
    eProsima_user_DllExport const std::map<uint64_t, std::wstring>& var_map_u_long_long_wstring() const
    {
        return m_var_map_u_long_long_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_wstring
     * @return Reference to member var_map_u_long_long_wstring
     */
    eProsima_user_DllExport std::map<uint64_t, std::wstring>& var_map_u_long_long_wstring()
    {
        return m_var_map_u_long_long_wstring;
    }



private:

    std::map<uint64_t, std::wstring> m_var_map_u_long_long_wstring;

};
/*!
 * @brief This class represents the structure MapULongLongInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedStringHelper(
            const MapULongLongInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_u_long_long_inner_alias_bounded_string_helper = x.m_var_map_u_long_long_inner_alias_bounded_string_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedStringHelper(
            MapULongLongInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_alias_bounded_string_helper = std::move(x.m_var_map_u_long_long_inner_alias_bounded_string_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedStringHelper& operator =(
            const MapULongLongInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_u_long_long_inner_alias_bounded_string_helper = x.m_var_map_u_long_long_inner_alias_bounded_string_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedStringHelper& operator =(
            MapULongLongInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_alias_bounded_string_helper = std::move(x.m_var_map_u_long_long_inner_alias_bounded_string_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_u_long_long_inner_alias_bounded_string_helper == x.m_var_map_u_long_long_inner_alias_bounded_string_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_alias_bounded_string_helper
     * @param _var_map_u_long_long_inner_alias_bounded_string_helper New value to be copied in member var_map_u_long_long_inner_alias_bounded_string_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_bounded_string_helper(
            const std::map<uint64_t, Inner_alias_bounded_string_helper>& _var_map_u_long_long_inner_alias_bounded_string_helper)
    {
        m_var_map_u_long_long_inner_alias_bounded_string_helper = _var_map_u_long_long_inner_alias_bounded_string_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_alias_bounded_string_helper
     * @param _var_map_u_long_long_inner_alias_bounded_string_helper New value to be moved in member var_map_u_long_long_inner_alias_bounded_string_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_bounded_string_helper(
            std::map<uint64_t, Inner_alias_bounded_string_helper>&& _var_map_u_long_long_inner_alias_bounded_string_helper)
    {
        m_var_map_u_long_long_inner_alias_bounded_string_helper = std::move(_var_map_u_long_long_inner_alias_bounded_string_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_alias_bounded_string_helper
     * @return Constant reference to member var_map_u_long_long_inner_alias_bounded_string_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, Inner_alias_bounded_string_helper>& var_map_u_long_long_inner_alias_bounded_string_helper() const
    {
        return m_var_map_u_long_long_inner_alias_bounded_string_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_alias_bounded_string_helper
     * @return Reference to member var_map_u_long_long_inner_alias_bounded_string_helper
     */
    eProsima_user_DllExport std::map<uint64_t, Inner_alias_bounded_string_helper>& var_map_u_long_long_inner_alias_bounded_string_helper()
    {
        return m_var_map_u_long_long_inner_alias_bounded_string_helper;
    }



private:

    std::map<uint64_t, Inner_alias_bounded_string_helper> m_var_map_u_long_long_inner_alias_bounded_string_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedWStringHelper(
            const MapULongLongInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_u_long_long_inner_alias_bounded_wstring_helper = x.m_var_map_u_long_long_inner_alias_bounded_wstring_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedWStringHelper(
            MapULongLongInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_alias_bounded_wstring_helper = std::move(x.m_var_map_u_long_long_inner_alias_bounded_wstring_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedWStringHelper& operator =(
            const MapULongLongInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_u_long_long_inner_alias_bounded_wstring_helper = x.m_var_map_u_long_long_inner_alias_bounded_wstring_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasBoundedWStringHelper& operator =(
            MapULongLongInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_alias_bounded_wstring_helper = std::move(x.m_var_map_u_long_long_inner_alias_bounded_wstring_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_u_long_long_inner_alias_bounded_wstring_helper == x.m_var_map_u_long_long_inner_alias_bounded_wstring_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_alias_bounded_wstring_helper
     * @param _var_map_u_long_long_inner_alias_bounded_wstring_helper New value to be copied in member var_map_u_long_long_inner_alias_bounded_wstring_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_bounded_wstring_helper(
            const std::map<uint64_t, Inner_alias_bounded_wstring_helper>& _var_map_u_long_long_inner_alias_bounded_wstring_helper)
    {
        m_var_map_u_long_long_inner_alias_bounded_wstring_helper = _var_map_u_long_long_inner_alias_bounded_wstring_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_alias_bounded_wstring_helper
     * @param _var_map_u_long_long_inner_alias_bounded_wstring_helper New value to be moved in member var_map_u_long_long_inner_alias_bounded_wstring_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_bounded_wstring_helper(
            std::map<uint64_t, Inner_alias_bounded_wstring_helper>&& _var_map_u_long_long_inner_alias_bounded_wstring_helper)
    {
        m_var_map_u_long_long_inner_alias_bounded_wstring_helper = std::move(_var_map_u_long_long_inner_alias_bounded_wstring_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_alias_bounded_wstring_helper
     * @return Constant reference to member var_map_u_long_long_inner_alias_bounded_wstring_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, Inner_alias_bounded_wstring_helper>& var_map_u_long_long_inner_alias_bounded_wstring_helper() const
    {
        return m_var_map_u_long_long_inner_alias_bounded_wstring_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_alias_bounded_wstring_helper
     * @return Reference to member var_map_u_long_long_inner_alias_bounded_wstring_helper
     */
    eProsima_user_DllExport std::map<uint64_t, Inner_alias_bounded_wstring_helper>& var_map_u_long_long_inner_alias_bounded_wstring_helper()
    {
        return m_var_map_u_long_long_inner_alias_bounded_wstring_helper;
    }



private:

    std::map<uint64_t, Inner_alias_bounded_wstring_helper> m_var_map_u_long_long_inner_alias_bounded_wstring_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerEnumHelper(
            const MapULongLongInnerEnumHelper& x)
    {
                    m_var_map_u_long_long_inner_enum_helper = x.m_var_map_u_long_long_inner_enum_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerEnumHelper(
            MapULongLongInnerEnumHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_enum_helper = std::move(x.m_var_map_u_long_long_inner_enum_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerEnumHelper& operator =(
            const MapULongLongInnerEnumHelper& x)
    {

                    m_var_map_u_long_long_inner_enum_helper = x.m_var_map_u_long_long_inner_enum_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerEnumHelper& operator =(
            MapULongLongInnerEnumHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_enum_helper = std::move(x.m_var_map_u_long_long_inner_enum_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerEnumHelper& x) const
    {
        return (m_var_map_u_long_long_inner_enum_helper == x.m_var_map_u_long_long_inner_enum_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_enum_helper
     * @param _var_map_u_long_long_inner_enum_helper New value to be copied in member var_map_u_long_long_inner_enum_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_enum_helper(
            const std::map<uint64_t, InnerEnumHelper>& _var_map_u_long_long_inner_enum_helper)
    {
        m_var_map_u_long_long_inner_enum_helper = _var_map_u_long_long_inner_enum_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_enum_helper
     * @param _var_map_u_long_long_inner_enum_helper New value to be moved in member var_map_u_long_long_inner_enum_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_enum_helper(
            std::map<uint64_t, InnerEnumHelper>&& _var_map_u_long_long_inner_enum_helper)
    {
        m_var_map_u_long_long_inner_enum_helper = std::move(_var_map_u_long_long_inner_enum_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_enum_helper
     * @return Constant reference to member var_map_u_long_long_inner_enum_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, InnerEnumHelper>& var_map_u_long_long_inner_enum_helper() const
    {
        return m_var_map_u_long_long_inner_enum_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_enum_helper
     * @return Reference to member var_map_u_long_long_inner_enum_helper
     */
    eProsima_user_DllExport std::map<uint64_t, InnerEnumHelper>& var_map_u_long_long_inner_enum_helper()
    {
        return m_var_map_u_long_long_inner_enum_helper;
    }



private:

    std::map<uint64_t, InnerEnumHelper> m_var_map_u_long_long_inner_enum_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitMaskHelper(
            const MapULongLongInnerBitMaskHelper& x)
    {
                    m_var_map_u_long_long_inner_bit_mask_helper = x.m_var_map_u_long_long_inner_bit_mask_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitMaskHelper(
            MapULongLongInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_bit_mask_helper = std::move(x.m_var_map_u_long_long_inner_bit_mask_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitMaskHelper& operator =(
            const MapULongLongInnerBitMaskHelper& x)
    {

                    m_var_map_u_long_long_inner_bit_mask_helper = x.m_var_map_u_long_long_inner_bit_mask_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitMaskHelper& operator =(
            MapULongLongInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_bit_mask_helper = std::move(x.m_var_map_u_long_long_inner_bit_mask_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerBitMaskHelper& x) const
    {
        return (m_var_map_u_long_long_inner_bit_mask_helper == x.m_var_map_u_long_long_inner_bit_mask_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_bit_mask_helper
     * @param _var_map_u_long_long_inner_bit_mask_helper New value to be copied in member var_map_u_long_long_inner_bit_mask_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_bit_mask_helper(
            const std::map<uint64_t, InnerBitMaskHelper>& _var_map_u_long_long_inner_bit_mask_helper)
    {
        m_var_map_u_long_long_inner_bit_mask_helper = _var_map_u_long_long_inner_bit_mask_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_bit_mask_helper
     * @param _var_map_u_long_long_inner_bit_mask_helper New value to be moved in member var_map_u_long_long_inner_bit_mask_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_bit_mask_helper(
            std::map<uint64_t, InnerBitMaskHelper>&& _var_map_u_long_long_inner_bit_mask_helper)
    {
        m_var_map_u_long_long_inner_bit_mask_helper = std::move(_var_map_u_long_long_inner_bit_mask_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_bit_mask_helper
     * @return Constant reference to member var_map_u_long_long_inner_bit_mask_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, InnerBitMaskHelper>& var_map_u_long_long_inner_bit_mask_helper() const
    {
        return m_var_map_u_long_long_inner_bit_mask_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_bit_mask_helper
     * @return Reference to member var_map_u_long_long_inner_bit_mask_helper
     */
    eProsima_user_DllExport std::map<uint64_t, InnerBitMaskHelper>& var_map_u_long_long_inner_bit_mask_helper()
    {
        return m_var_map_u_long_long_inner_bit_mask_helper;
    }



private:

    std::map<uint64_t, InnerBitMaskHelper> m_var_map_u_long_long_inner_bit_mask_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasHelper(
            const MapULongLongInnerAliasHelper& x)
    {
                    m_var_map_u_long_long_inner_alias_helper = x.m_var_map_u_long_long_inner_alias_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasHelper(
            MapULongLongInnerAliasHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_alias_helper = std::move(x.m_var_map_u_long_long_inner_alias_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasHelper& operator =(
            const MapULongLongInnerAliasHelper& x)
    {

                    m_var_map_u_long_long_inner_alias_helper = x.m_var_map_u_long_long_inner_alias_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasHelper& operator =(
            MapULongLongInnerAliasHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_alias_helper = std::move(x.m_var_map_u_long_long_inner_alias_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerAliasHelper& x) const
    {
        return (m_var_map_u_long_long_inner_alias_helper == x.m_var_map_u_long_long_inner_alias_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_alias_helper
     * @param _var_map_u_long_long_inner_alias_helper New value to be copied in member var_map_u_long_long_inner_alias_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_helper(
            const std::map<uint64_t, InnerAliasHelper>& _var_map_u_long_long_inner_alias_helper)
    {
        m_var_map_u_long_long_inner_alias_helper = _var_map_u_long_long_inner_alias_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_alias_helper
     * @param _var_map_u_long_long_inner_alias_helper New value to be moved in member var_map_u_long_long_inner_alias_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_helper(
            std::map<uint64_t, InnerAliasHelper>&& _var_map_u_long_long_inner_alias_helper)
    {
        m_var_map_u_long_long_inner_alias_helper = std::move(_var_map_u_long_long_inner_alias_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_alias_helper
     * @return Constant reference to member var_map_u_long_long_inner_alias_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, InnerAliasHelper>& var_map_u_long_long_inner_alias_helper() const
    {
        return m_var_map_u_long_long_inner_alias_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_alias_helper
     * @return Reference to member var_map_u_long_long_inner_alias_helper
     */
    eProsima_user_DllExport std::map<uint64_t, InnerAliasHelper>& var_map_u_long_long_inner_alias_helper()
    {
        return m_var_map_u_long_long_inner_alias_helper;
    }



private:

    std::map<uint64_t, InnerAliasHelper> m_var_map_u_long_long_inner_alias_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasArrayHelper(
            const MapULongLongInnerAliasArrayHelper& x)
    {
                    m_var_map_u_long_long_inner_alias_array_helper = x.m_var_map_u_long_long_inner_alias_array_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasArrayHelper(
            MapULongLongInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_alias_array_helper = std::move(x.m_var_map_u_long_long_inner_alias_array_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasArrayHelper& operator =(
            const MapULongLongInnerAliasArrayHelper& x)
    {

                    m_var_map_u_long_long_inner_alias_array_helper = x.m_var_map_u_long_long_inner_alias_array_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasArrayHelper& operator =(
            MapULongLongInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_alias_array_helper = std::move(x.m_var_map_u_long_long_inner_alias_array_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerAliasArrayHelper& x) const
    {
        return (m_var_map_u_long_long_inner_alias_array_helper == x.m_var_map_u_long_long_inner_alias_array_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_alias_array_helper
     * @param _var_map_u_long_long_inner_alias_array_helper New value to be copied in member var_map_u_long_long_inner_alias_array_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_array_helper(
            const std::map<uint64_t, Inner_alias_array_helper>& _var_map_u_long_long_inner_alias_array_helper)
    {
        m_var_map_u_long_long_inner_alias_array_helper = _var_map_u_long_long_inner_alias_array_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_alias_array_helper
     * @param _var_map_u_long_long_inner_alias_array_helper New value to be moved in member var_map_u_long_long_inner_alias_array_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_array_helper(
            std::map<uint64_t, Inner_alias_array_helper>&& _var_map_u_long_long_inner_alias_array_helper)
    {
        m_var_map_u_long_long_inner_alias_array_helper = std::move(_var_map_u_long_long_inner_alias_array_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_alias_array_helper
     * @return Constant reference to member var_map_u_long_long_inner_alias_array_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, Inner_alias_array_helper>& var_map_u_long_long_inner_alias_array_helper() const
    {
        return m_var_map_u_long_long_inner_alias_array_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_alias_array_helper
     * @return Reference to member var_map_u_long_long_inner_alias_array_helper
     */
    eProsima_user_DllExport std::map<uint64_t, Inner_alias_array_helper>& var_map_u_long_long_inner_alias_array_helper()
    {
        return m_var_map_u_long_long_inner_alias_array_helper;
    }



private:

    std::map<uint64_t, Inner_alias_array_helper> m_var_map_u_long_long_inner_alias_array_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasSequenceHelper(
            const MapULongLongInnerAliasSequenceHelper& x)
    {
                    m_var_map_u_long_long_inner_alias_sequence_helper = x.m_var_map_u_long_long_inner_alias_sequence_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasSequenceHelper(
            MapULongLongInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_alias_sequence_helper = std::move(x.m_var_map_u_long_long_inner_alias_sequence_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasSequenceHelper& operator =(
            const MapULongLongInnerAliasSequenceHelper& x)
    {

                    m_var_map_u_long_long_inner_alias_sequence_helper = x.m_var_map_u_long_long_inner_alias_sequence_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasSequenceHelper& operator =(
            MapULongLongInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_alias_sequence_helper = std::move(x.m_var_map_u_long_long_inner_alias_sequence_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_u_long_long_inner_alias_sequence_helper == x.m_var_map_u_long_long_inner_alias_sequence_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_alias_sequence_helper
     * @param _var_map_u_long_long_inner_alias_sequence_helper New value to be copied in member var_map_u_long_long_inner_alias_sequence_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_sequence_helper(
            const std::map<uint64_t, Inner_alias_sequence_helper>& _var_map_u_long_long_inner_alias_sequence_helper)
    {
        m_var_map_u_long_long_inner_alias_sequence_helper = _var_map_u_long_long_inner_alias_sequence_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_alias_sequence_helper
     * @param _var_map_u_long_long_inner_alias_sequence_helper New value to be moved in member var_map_u_long_long_inner_alias_sequence_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_sequence_helper(
            std::map<uint64_t, Inner_alias_sequence_helper>&& _var_map_u_long_long_inner_alias_sequence_helper)
    {
        m_var_map_u_long_long_inner_alias_sequence_helper = std::move(_var_map_u_long_long_inner_alias_sequence_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_alias_sequence_helper
     * @return Constant reference to member var_map_u_long_long_inner_alias_sequence_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, Inner_alias_sequence_helper>& var_map_u_long_long_inner_alias_sequence_helper() const
    {
        return m_var_map_u_long_long_inner_alias_sequence_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_alias_sequence_helper
     * @return Reference to member var_map_u_long_long_inner_alias_sequence_helper
     */
    eProsima_user_DllExport std::map<uint64_t, Inner_alias_sequence_helper>& var_map_u_long_long_inner_alias_sequence_helper()
    {
        return m_var_map_u_long_long_inner_alias_sequence_helper;
    }



private:

    std::map<uint64_t, Inner_alias_sequence_helper> m_var_map_u_long_long_inner_alias_sequence_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasMapHelper(
            const MapULongLongInnerAliasMapHelper& x)
    {
                    m_var_map_u_long_long_inner_alias_map_helper = x.m_var_map_u_long_long_inner_alias_map_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasMapHelper(
            MapULongLongInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_alias_map_helper = std::move(x.m_var_map_u_long_long_inner_alias_map_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasMapHelper& operator =(
            const MapULongLongInnerAliasMapHelper& x)
    {

                    m_var_map_u_long_long_inner_alias_map_helper = x.m_var_map_u_long_long_inner_alias_map_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerAliasMapHelper& operator =(
            MapULongLongInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_alias_map_helper = std::move(x.m_var_map_u_long_long_inner_alias_map_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerAliasMapHelper& x) const
    {
        return (m_var_map_u_long_long_inner_alias_map_helper == x.m_var_map_u_long_long_inner_alias_map_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_alias_map_helper
     * @param _var_map_u_long_long_inner_alias_map_helper New value to be copied in member var_map_u_long_long_inner_alias_map_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_map_helper(
            const std::map<uint64_t, Inner_alias_map_helper>& _var_map_u_long_long_inner_alias_map_helper)
    {
        m_var_map_u_long_long_inner_alias_map_helper = _var_map_u_long_long_inner_alias_map_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_alias_map_helper
     * @param _var_map_u_long_long_inner_alias_map_helper New value to be moved in member var_map_u_long_long_inner_alias_map_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_alias_map_helper(
            std::map<uint64_t, Inner_alias_map_helper>&& _var_map_u_long_long_inner_alias_map_helper)
    {
        m_var_map_u_long_long_inner_alias_map_helper = std::move(_var_map_u_long_long_inner_alias_map_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_alias_map_helper
     * @return Constant reference to member var_map_u_long_long_inner_alias_map_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, Inner_alias_map_helper>& var_map_u_long_long_inner_alias_map_helper() const
    {
        return m_var_map_u_long_long_inner_alias_map_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_alias_map_helper
     * @return Reference to member var_map_u_long_long_inner_alias_map_helper
     */
    eProsima_user_DllExport std::map<uint64_t, Inner_alias_map_helper>& var_map_u_long_long_inner_alias_map_helper()
    {
        return m_var_map_u_long_long_inner_alias_map_helper;
    }



private:

    std::map<uint64_t, Inner_alias_map_helper> m_var_map_u_long_long_inner_alias_map_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerUnionHelper(
            const MapULongLongInnerUnionHelper& x)
    {
                    m_var_map_u_long_long_inner_union_helper = x.m_var_map_u_long_long_inner_union_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerUnionHelper(
            MapULongLongInnerUnionHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_union_helper = std::move(x.m_var_map_u_long_long_inner_union_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerUnionHelper& operator =(
            const MapULongLongInnerUnionHelper& x)
    {

                    m_var_map_u_long_long_inner_union_helper = x.m_var_map_u_long_long_inner_union_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerUnionHelper& operator =(
            MapULongLongInnerUnionHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_union_helper = std::move(x.m_var_map_u_long_long_inner_union_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerUnionHelper& x) const
    {
        return (m_var_map_u_long_long_inner_union_helper == x.m_var_map_u_long_long_inner_union_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_union_helper
     * @param _var_map_u_long_long_inner_union_helper New value to be copied in member var_map_u_long_long_inner_union_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_union_helper(
            const std::map<uint64_t, InnerUnionHelper>& _var_map_u_long_long_inner_union_helper)
    {
        m_var_map_u_long_long_inner_union_helper = _var_map_u_long_long_inner_union_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_union_helper
     * @param _var_map_u_long_long_inner_union_helper New value to be moved in member var_map_u_long_long_inner_union_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_union_helper(
            std::map<uint64_t, InnerUnionHelper>&& _var_map_u_long_long_inner_union_helper)
    {
        m_var_map_u_long_long_inner_union_helper = std::move(_var_map_u_long_long_inner_union_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_union_helper
     * @return Constant reference to member var_map_u_long_long_inner_union_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, InnerUnionHelper>& var_map_u_long_long_inner_union_helper() const
    {
        return m_var_map_u_long_long_inner_union_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_union_helper
     * @return Reference to member var_map_u_long_long_inner_union_helper
     */
    eProsima_user_DllExport std::map<uint64_t, InnerUnionHelper>& var_map_u_long_long_inner_union_helper()
    {
        return m_var_map_u_long_long_inner_union_helper;
    }



private:

    std::map<uint64_t, InnerUnionHelper> m_var_map_u_long_long_inner_union_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerStructureHelper(
            const MapULongLongInnerStructureHelper& x)
    {
                    m_var_map_u_long_long_inner_structure_helper = x.m_var_map_u_long_long_inner_structure_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerStructureHelper(
            MapULongLongInnerStructureHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_structure_helper = std::move(x.m_var_map_u_long_long_inner_structure_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerStructureHelper& operator =(
            const MapULongLongInnerStructureHelper& x)
    {

                    m_var_map_u_long_long_inner_structure_helper = x.m_var_map_u_long_long_inner_structure_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerStructureHelper& operator =(
            MapULongLongInnerStructureHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_structure_helper = std::move(x.m_var_map_u_long_long_inner_structure_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerStructureHelper& x) const
    {
        return (m_var_map_u_long_long_inner_structure_helper == x.m_var_map_u_long_long_inner_structure_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_structure_helper
     * @param _var_map_u_long_long_inner_structure_helper New value to be copied in member var_map_u_long_long_inner_structure_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_structure_helper(
            const std::map<uint64_t, InnerStructureHelper>& _var_map_u_long_long_inner_structure_helper)
    {
        m_var_map_u_long_long_inner_structure_helper = _var_map_u_long_long_inner_structure_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_structure_helper
     * @param _var_map_u_long_long_inner_structure_helper New value to be moved in member var_map_u_long_long_inner_structure_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_structure_helper(
            std::map<uint64_t, InnerStructureHelper>&& _var_map_u_long_long_inner_structure_helper)
    {
        m_var_map_u_long_long_inner_structure_helper = std::move(_var_map_u_long_long_inner_structure_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_structure_helper
     * @return Constant reference to member var_map_u_long_long_inner_structure_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, InnerStructureHelper>& var_map_u_long_long_inner_structure_helper() const
    {
        return m_var_map_u_long_long_inner_structure_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_structure_helper
     * @return Reference to member var_map_u_long_long_inner_structure_helper
     */
    eProsima_user_DllExport std::map<uint64_t, InnerStructureHelper>& var_map_u_long_long_inner_structure_helper()
    {
        return m_var_map_u_long_long_inner_structure_helper;
    }



private:

    std::map<uint64_t, InnerStructureHelper> m_var_map_u_long_long_inner_structure_helper;

};
/*!
 * @brief This class represents the structure MapULongLongInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapULongLongInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapULongLongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapULongLongInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapULongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitsetHelper(
            const MapULongLongInnerBitsetHelper& x)
    {
                    m_var_map_u_long_long_inner_bitset_helper = x.m_var_map_u_long_long_inner_bitset_helper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapULongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitsetHelper(
            MapULongLongInnerBitsetHelper&& x) noexcept
    {
        m_var_map_u_long_long_inner_bitset_helper = std::move(x.m_var_map_u_long_long_inner_bitset_helper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapULongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitsetHelper& operator =(
            const MapULongLongInnerBitsetHelper& x)
    {

                    m_var_map_u_long_long_inner_bitset_helper = x.m_var_map_u_long_long_inner_bitset_helper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapULongLongInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapULongLongInnerBitsetHelper& operator =(
            MapULongLongInnerBitsetHelper&& x) noexcept
    {

        m_var_map_u_long_long_inner_bitset_helper = std::move(x.m_var_map_u_long_long_inner_bitset_helper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapULongLongInnerBitsetHelper& x) const
    {
        return (m_var_map_u_long_long_inner_bitset_helper == x.m_var_map_u_long_long_inner_bitset_helper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapULongLongInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapULongLongInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_u_long_long_inner_bitset_helper
     * @param _var_map_u_long_long_inner_bitset_helper New value to be copied in member var_map_u_long_long_inner_bitset_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_bitset_helper(
            const std::map<uint64_t, InnerBitsetHelper>& _var_map_u_long_long_inner_bitset_helper)
    {
        m_var_map_u_long_long_inner_bitset_helper = _var_map_u_long_long_inner_bitset_helper;
    }

    /*!
     * @brief This function moves the value in member var_map_u_long_long_inner_bitset_helper
     * @param _var_map_u_long_long_inner_bitset_helper New value to be moved in member var_map_u_long_long_inner_bitset_helper
     */
    eProsima_user_DllExport void var_map_u_long_long_inner_bitset_helper(
            std::map<uint64_t, InnerBitsetHelper>&& _var_map_u_long_long_inner_bitset_helper)
    {
        m_var_map_u_long_long_inner_bitset_helper = std::move(_var_map_u_long_long_inner_bitset_helper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_u_long_long_inner_bitset_helper
     * @return Constant reference to member var_map_u_long_long_inner_bitset_helper
     */
    eProsima_user_DllExport const std::map<uint64_t, InnerBitsetHelper>& var_map_u_long_long_inner_bitset_helper() const
    {
        return m_var_map_u_long_long_inner_bitset_helper;
    }

    /*!
     * @brief This function returns a reference to member var_map_u_long_long_inner_bitset_helper
     * @return Reference to member var_map_u_long_long_inner_bitset_helper
     */
    eProsima_user_DllExport std::map<uint64_t, InnerBitsetHelper>& var_map_u_long_long_inner_bitset_helper()
    {
        return m_var_map_u_long_long_inner_bitset_helper;
    }



private:

    std::map<uint64_t, InnerBitsetHelper> m_var_map_u_long_long_inner_bitset_helper;

};
/*!
 * @brief This class represents the structure MapStringShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringShort that will be copied.
     */
    eProsima_user_DllExport MapStringShort(
            const MapStringShort& x)
    {
                    m_var_map_string_short = x.m_var_map_string_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringShort that will be copied.
     */
    eProsima_user_DllExport MapStringShort(
            MapStringShort&& x) noexcept
    {
        m_var_map_string_short = std::move(x.m_var_map_string_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringShort that will be copied.
     */
    eProsima_user_DllExport MapStringShort& operator =(
            const MapStringShort& x)
    {

                    m_var_map_string_short = x.m_var_map_string_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringShort that will be copied.
     */
    eProsima_user_DllExport MapStringShort& operator =(
            MapStringShort&& x) noexcept
    {

        m_var_map_string_short = std::move(x.m_var_map_string_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringShort& x) const
    {
        return (m_var_map_string_short == x.m_var_map_string_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_short
     * @param _var_map_string_short New value to be copied in member var_map_string_short
     */
    eProsima_user_DllExport void var_map_string_short(
            const std::map<std::string, int16_t>& _var_map_string_short)
    {
        m_var_map_string_short = _var_map_string_short;
    }

    /*!
     * @brief This function moves the value in member var_map_string_short
     * @param _var_map_string_short New value to be moved in member var_map_string_short
     */
    eProsima_user_DllExport void var_map_string_short(
            std::map<std::string, int16_t>&& _var_map_string_short)
    {
        m_var_map_string_short = std::move(_var_map_string_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_short
     * @return Constant reference to member var_map_string_short
     */
    eProsima_user_DllExport const std::map<std::string, int16_t>& var_map_string_short() const
    {
        return m_var_map_string_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_short
     * @return Reference to member var_map_string_short
     */
    eProsima_user_DllExport std::map<std::string, int16_t>& var_map_string_short()
    {
        return m_var_map_string_short;
    }



private:

    std::map<std::string, int16_t> m_var_map_string_short;

};
/*!
 * @brief This class represents the structure MapStringUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringUShort that will be copied.
     */
    eProsima_user_DllExport MapStringUShort(
            const MapStringUShort& x)
    {
                    m_var_map_string_ushort = x.m_var_map_string_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringUShort that will be copied.
     */
    eProsima_user_DllExport MapStringUShort(
            MapStringUShort&& x) noexcept
    {
        m_var_map_string_ushort = std::move(x.m_var_map_string_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringUShort that will be copied.
     */
    eProsima_user_DllExport MapStringUShort& operator =(
            const MapStringUShort& x)
    {

                    m_var_map_string_ushort = x.m_var_map_string_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringUShort that will be copied.
     */
    eProsima_user_DllExport MapStringUShort& operator =(
            MapStringUShort&& x) noexcept
    {

        m_var_map_string_ushort = std::move(x.m_var_map_string_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringUShort& x) const
    {
        return (m_var_map_string_ushort == x.m_var_map_string_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_ushort
     * @param _var_map_string_ushort New value to be copied in member var_map_string_ushort
     */
    eProsima_user_DllExport void var_map_string_ushort(
            const std::map<std::string, uint16_t>& _var_map_string_ushort)
    {
        m_var_map_string_ushort = _var_map_string_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_string_ushort
     * @param _var_map_string_ushort New value to be moved in member var_map_string_ushort
     */
    eProsima_user_DllExport void var_map_string_ushort(
            std::map<std::string, uint16_t>&& _var_map_string_ushort)
    {
        m_var_map_string_ushort = std::move(_var_map_string_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_ushort
     * @return Constant reference to member var_map_string_ushort
     */
    eProsima_user_DllExport const std::map<std::string, uint16_t>& var_map_string_ushort() const
    {
        return m_var_map_string_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_ushort
     * @return Reference to member var_map_string_ushort
     */
    eProsima_user_DllExport std::map<std::string, uint16_t>& var_map_string_ushort()
    {
        return m_var_map_string_ushort;
    }



private:

    std::map<std::string, uint16_t> m_var_map_string_ushort;

};
/*!
 * @brief This class represents the structure MapStringLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringLong that will be copied.
     */
    eProsima_user_DllExport MapStringLong(
            const MapStringLong& x)
    {
                    m_var_map_string_long = x.m_var_map_string_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringLong that will be copied.
     */
    eProsima_user_DllExport MapStringLong(
            MapStringLong&& x) noexcept
    {
        m_var_map_string_long = std::move(x.m_var_map_string_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringLong that will be copied.
     */
    eProsima_user_DllExport MapStringLong& operator =(
            const MapStringLong& x)
    {

                    m_var_map_string_long = x.m_var_map_string_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringLong that will be copied.
     */
    eProsima_user_DllExport MapStringLong& operator =(
            MapStringLong&& x) noexcept
    {

        m_var_map_string_long = std::move(x.m_var_map_string_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringLong& x) const
    {
        return (m_var_map_string_long == x.m_var_map_string_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_long
     * @param _var_map_string_long New value to be copied in member var_map_string_long
     */
    eProsima_user_DllExport void var_map_string_long(
            const std::map<std::string, int32_t>& _var_map_string_long)
    {
        m_var_map_string_long = _var_map_string_long;
    }

    /*!
     * @brief This function moves the value in member var_map_string_long
     * @param _var_map_string_long New value to be moved in member var_map_string_long
     */
    eProsima_user_DllExport void var_map_string_long(
            std::map<std::string, int32_t>&& _var_map_string_long)
    {
        m_var_map_string_long = std::move(_var_map_string_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_long
     * @return Constant reference to member var_map_string_long
     */
    eProsima_user_DllExport const std::map<std::string, int32_t>& var_map_string_long() const
    {
        return m_var_map_string_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_long
     * @return Reference to member var_map_string_long
     */
    eProsima_user_DllExport std::map<std::string, int32_t>& var_map_string_long()
    {
        return m_var_map_string_long;
    }



private:

    std::map<std::string, int32_t> m_var_map_string_long;

};
/*!
 * @brief This class represents the structure MapStringULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringULong that will be copied.
     */
    eProsima_user_DllExport MapStringULong(
            const MapStringULong& x)
    {
                    m_var_map_string_ulong = x.m_var_map_string_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringULong that will be copied.
     */
    eProsima_user_DllExport MapStringULong(
            MapStringULong&& x) noexcept
    {
        m_var_map_string_ulong = std::move(x.m_var_map_string_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringULong that will be copied.
     */
    eProsima_user_DllExport MapStringULong& operator =(
            const MapStringULong& x)
    {

                    m_var_map_string_ulong = x.m_var_map_string_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringULong that will be copied.
     */
    eProsima_user_DllExport MapStringULong& operator =(
            MapStringULong&& x) noexcept
    {

        m_var_map_string_ulong = std::move(x.m_var_map_string_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringULong& x) const
    {
        return (m_var_map_string_ulong == x.m_var_map_string_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_ulong
     * @param _var_map_string_ulong New value to be copied in member var_map_string_ulong
     */
    eProsima_user_DllExport void var_map_string_ulong(
            const std::map<std::string, uint32_t>& _var_map_string_ulong)
    {
        m_var_map_string_ulong = _var_map_string_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_string_ulong
     * @param _var_map_string_ulong New value to be moved in member var_map_string_ulong
     */
    eProsima_user_DllExport void var_map_string_ulong(
            std::map<std::string, uint32_t>&& _var_map_string_ulong)
    {
        m_var_map_string_ulong = std::move(_var_map_string_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_ulong
     * @return Constant reference to member var_map_string_ulong
     */
    eProsima_user_DllExport const std::map<std::string, uint32_t>& var_map_string_ulong() const
    {
        return m_var_map_string_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_ulong
     * @return Reference to member var_map_string_ulong
     */
    eProsima_user_DllExport std::map<std::string, uint32_t>& var_map_string_ulong()
    {
        return m_var_map_string_ulong;
    }



private:

    std::map<std::string, uint32_t> m_var_map_string_ulong;

};
/*!
 * @brief This class represents the structure MapStringLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapStringLongLong(
            const MapStringLongLong& x)
    {
                    m_var_map_string_longlong = x.m_var_map_string_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapStringLongLong(
            MapStringLongLong&& x) noexcept
    {
        m_var_map_string_longlong = std::move(x.m_var_map_string_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapStringLongLong& operator =(
            const MapStringLongLong& x)
    {

                    m_var_map_string_longlong = x.m_var_map_string_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapStringLongLong& operator =(
            MapStringLongLong&& x) noexcept
    {

        m_var_map_string_longlong = std::move(x.m_var_map_string_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringLongLong& x) const
    {
        return (m_var_map_string_longlong == x.m_var_map_string_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_longlong
     * @param _var_map_string_longlong New value to be copied in member var_map_string_longlong
     */
    eProsima_user_DllExport void var_map_string_longlong(
            const std::map<std::string, int64_t>& _var_map_string_longlong)
    {
        m_var_map_string_longlong = _var_map_string_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_string_longlong
     * @param _var_map_string_longlong New value to be moved in member var_map_string_longlong
     */
    eProsima_user_DllExport void var_map_string_longlong(
            std::map<std::string, int64_t>&& _var_map_string_longlong)
    {
        m_var_map_string_longlong = std::move(_var_map_string_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_longlong
     * @return Constant reference to member var_map_string_longlong
     */
    eProsima_user_DllExport const std::map<std::string, int64_t>& var_map_string_longlong() const
    {
        return m_var_map_string_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_longlong
     * @return Reference to member var_map_string_longlong
     */
    eProsima_user_DllExport std::map<std::string, int64_t>& var_map_string_longlong()
    {
        return m_var_map_string_longlong;
    }



private:

    std::map<std::string, int64_t> m_var_map_string_longlong;

};
/*!
 * @brief This class represents the structure MapStringULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapStringULongLong(
            const MapStringULongLong& x)
    {
                    m_var_map_string_ulonglong = x.m_var_map_string_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapStringULongLong(
            MapStringULongLong&& x) noexcept
    {
        m_var_map_string_ulonglong = std::move(x.m_var_map_string_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapStringULongLong& operator =(
            const MapStringULongLong& x)
    {

                    m_var_map_string_ulonglong = x.m_var_map_string_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapStringULongLong& operator =(
            MapStringULongLong&& x) noexcept
    {

        m_var_map_string_ulonglong = std::move(x.m_var_map_string_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringULongLong& x) const
    {
        return (m_var_map_string_ulonglong == x.m_var_map_string_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_ulonglong
     * @param _var_map_string_ulonglong New value to be copied in member var_map_string_ulonglong
     */
    eProsima_user_DllExport void var_map_string_ulonglong(
            const std::map<std::string, uint64_t>& _var_map_string_ulonglong)
    {
        m_var_map_string_ulonglong = _var_map_string_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_string_ulonglong
     * @param _var_map_string_ulonglong New value to be moved in member var_map_string_ulonglong
     */
    eProsima_user_DllExport void var_map_string_ulonglong(
            std::map<std::string, uint64_t>&& _var_map_string_ulonglong)
    {
        m_var_map_string_ulonglong = std::move(_var_map_string_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_ulonglong
     * @return Constant reference to member var_map_string_ulonglong
     */
    eProsima_user_DllExport const std::map<std::string, uint64_t>& var_map_string_ulonglong() const
    {
        return m_var_map_string_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_ulonglong
     * @return Reference to member var_map_string_ulonglong
     */
    eProsima_user_DllExport std::map<std::string, uint64_t>& var_map_string_ulonglong()
    {
        return m_var_map_string_ulonglong;
    }



private:

    std::map<std::string, uint64_t> m_var_map_string_ulonglong;

};
/*!
 * @brief This class represents the structure MapStringFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringFloat that will be copied.
     */
    eProsima_user_DllExport MapStringFloat(
            const MapStringFloat& x)
    {
                    m_var_map_string_float = x.m_var_map_string_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringFloat that will be copied.
     */
    eProsima_user_DllExport MapStringFloat(
            MapStringFloat&& x) noexcept
    {
        m_var_map_string_float = std::move(x.m_var_map_string_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringFloat that will be copied.
     */
    eProsima_user_DllExport MapStringFloat& operator =(
            const MapStringFloat& x)
    {

                    m_var_map_string_float = x.m_var_map_string_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringFloat that will be copied.
     */
    eProsima_user_DllExport MapStringFloat& operator =(
            MapStringFloat&& x) noexcept
    {

        m_var_map_string_float = std::move(x.m_var_map_string_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringFloat& x) const
    {
        return (m_var_map_string_float == x.m_var_map_string_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_float
     * @param _var_map_string_float New value to be copied in member var_map_string_float
     */
    eProsima_user_DllExport void var_map_string_float(
            const std::map<std::string, float>& _var_map_string_float)
    {
        m_var_map_string_float = _var_map_string_float;
    }

    /*!
     * @brief This function moves the value in member var_map_string_float
     * @param _var_map_string_float New value to be moved in member var_map_string_float
     */
    eProsima_user_DllExport void var_map_string_float(
            std::map<std::string, float>&& _var_map_string_float)
    {
        m_var_map_string_float = std::move(_var_map_string_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_float
     * @return Constant reference to member var_map_string_float
     */
    eProsima_user_DllExport const std::map<std::string, float>& var_map_string_float() const
    {
        return m_var_map_string_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_float
     * @return Reference to member var_map_string_float
     */
    eProsima_user_DllExport std::map<std::string, float>& var_map_string_float()
    {
        return m_var_map_string_float;
    }



private:

    std::map<std::string, float> m_var_map_string_float;

};
/*!
 * @brief This class represents the structure MapStringDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringDouble that will be copied.
     */
    eProsima_user_DllExport MapStringDouble(
            const MapStringDouble& x)
    {
                    m_var_map_string_double = x.m_var_map_string_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringDouble that will be copied.
     */
    eProsima_user_DllExport MapStringDouble(
            MapStringDouble&& x) noexcept
    {
        m_var_map_string_double = std::move(x.m_var_map_string_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringDouble that will be copied.
     */
    eProsima_user_DllExport MapStringDouble& operator =(
            const MapStringDouble& x)
    {

                    m_var_map_string_double = x.m_var_map_string_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringDouble that will be copied.
     */
    eProsima_user_DllExport MapStringDouble& operator =(
            MapStringDouble&& x) noexcept
    {

        m_var_map_string_double = std::move(x.m_var_map_string_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringDouble& x) const
    {
        return (m_var_map_string_double == x.m_var_map_string_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_double
     * @param _var_map_string_double New value to be copied in member var_map_string_double
     */
    eProsima_user_DllExport void var_map_string_double(
            const std::map<std::string, double>& _var_map_string_double)
    {
        m_var_map_string_double = _var_map_string_double;
    }

    /*!
     * @brief This function moves the value in member var_map_string_double
     * @param _var_map_string_double New value to be moved in member var_map_string_double
     */
    eProsima_user_DllExport void var_map_string_double(
            std::map<std::string, double>&& _var_map_string_double)
    {
        m_var_map_string_double = std::move(_var_map_string_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_double
     * @return Constant reference to member var_map_string_double
     */
    eProsima_user_DllExport const std::map<std::string, double>& var_map_string_double() const
    {
        return m_var_map_string_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_double
     * @return Reference to member var_map_string_double
     */
    eProsima_user_DllExport std::map<std::string, double>& var_map_string_double()
    {
        return m_var_map_string_double;
    }



private:

    std::map<std::string, double> m_var_map_string_double;

};
/*!
 * @brief This class represents the structure MapStringLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapStringLongDouble(
            const MapStringLongDouble& x)
    {
                    m_var_map_string_longdouble = x.m_var_map_string_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapStringLongDouble(
            MapStringLongDouble&& x) noexcept
    {
        m_var_map_string_longdouble = std::move(x.m_var_map_string_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapStringLongDouble& operator =(
            const MapStringLongDouble& x)
    {

                    m_var_map_string_longdouble = x.m_var_map_string_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapStringLongDouble& operator =(
            MapStringLongDouble&& x) noexcept
    {

        m_var_map_string_longdouble = std::move(x.m_var_map_string_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringLongDouble& x) const
    {
        return (m_var_map_string_longdouble == x.m_var_map_string_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_longdouble
     * @param _var_map_string_longdouble New value to be copied in member var_map_string_longdouble
     */
    eProsima_user_DllExport void var_map_string_longdouble(
            const std::map<std::string, long double>& _var_map_string_longdouble)
    {
        m_var_map_string_longdouble = _var_map_string_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_string_longdouble
     * @param _var_map_string_longdouble New value to be moved in member var_map_string_longdouble
     */
    eProsima_user_DllExport void var_map_string_longdouble(
            std::map<std::string, long double>&& _var_map_string_longdouble)
    {
        m_var_map_string_longdouble = std::move(_var_map_string_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_longdouble
     * @return Constant reference to member var_map_string_longdouble
     */
    eProsima_user_DllExport const std::map<std::string, long double>& var_map_string_longdouble() const
    {
        return m_var_map_string_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_longdouble
     * @return Reference to member var_map_string_longdouble
     */
    eProsima_user_DllExport std::map<std::string, long double>& var_map_string_longdouble()
    {
        return m_var_map_string_longdouble;
    }



private:

    std::map<std::string, long double> m_var_map_string_longdouble;

};
/*!
 * @brief This class represents the structure MapStringBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapStringBoolean(
            const MapStringBoolean& x)
    {
                    m_var_map_string_boolean = x.m_var_map_string_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapStringBoolean(
            MapStringBoolean&& x) noexcept
    {
        m_var_map_string_boolean = std::move(x.m_var_map_string_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapStringBoolean& operator =(
            const MapStringBoolean& x)
    {

                    m_var_map_string_boolean = x.m_var_map_string_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapStringBoolean& operator =(
            MapStringBoolean&& x) noexcept
    {

        m_var_map_string_boolean = std::move(x.m_var_map_string_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringBoolean& x) const
    {
        return (m_var_map_string_boolean == x.m_var_map_string_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_boolean
     * @param _var_map_string_boolean New value to be copied in member var_map_string_boolean
     */
    eProsima_user_DllExport void var_map_string_boolean(
            const std::map<std::string, bool>& _var_map_string_boolean)
    {
        m_var_map_string_boolean = _var_map_string_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_string_boolean
     * @param _var_map_string_boolean New value to be moved in member var_map_string_boolean
     */
    eProsima_user_DllExport void var_map_string_boolean(
            std::map<std::string, bool>&& _var_map_string_boolean)
    {
        m_var_map_string_boolean = std::move(_var_map_string_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_boolean
     * @return Constant reference to member var_map_string_boolean
     */
    eProsima_user_DllExport const std::map<std::string, bool>& var_map_string_boolean() const
    {
        return m_var_map_string_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_boolean
     * @return Reference to member var_map_string_boolean
     */
    eProsima_user_DllExport std::map<std::string, bool>& var_map_string_boolean()
    {
        return m_var_map_string_boolean;
    }



private:

    std::map<std::string, bool> m_var_map_string_boolean;

};
/*!
 * @brief This class represents the structure MapStringOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringOctet that will be copied.
     */
    eProsima_user_DllExport MapStringOctet(
            const MapStringOctet& x)
    {
                    m_var_map_string_octet = x.m_var_map_string_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringOctet that will be copied.
     */
    eProsima_user_DllExport MapStringOctet(
            MapStringOctet&& x) noexcept
    {
        m_var_map_string_octet = std::move(x.m_var_map_string_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringOctet that will be copied.
     */
    eProsima_user_DllExport MapStringOctet& operator =(
            const MapStringOctet& x)
    {

                    m_var_map_string_octet = x.m_var_map_string_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringOctet that will be copied.
     */
    eProsima_user_DllExport MapStringOctet& operator =(
            MapStringOctet&& x) noexcept
    {

        m_var_map_string_octet = std::move(x.m_var_map_string_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringOctet& x) const
    {
        return (m_var_map_string_octet == x.m_var_map_string_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_octet
     * @param _var_map_string_octet New value to be copied in member var_map_string_octet
     */
    eProsima_user_DllExport void var_map_string_octet(
            const std::map<std::string, uint8_t>& _var_map_string_octet)
    {
        m_var_map_string_octet = _var_map_string_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_string_octet
     * @param _var_map_string_octet New value to be moved in member var_map_string_octet
     */
    eProsima_user_DllExport void var_map_string_octet(
            std::map<std::string, uint8_t>&& _var_map_string_octet)
    {
        m_var_map_string_octet = std::move(_var_map_string_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_octet
     * @return Constant reference to member var_map_string_octet
     */
    eProsima_user_DllExport const std::map<std::string, uint8_t>& var_map_string_octet() const
    {
        return m_var_map_string_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_octet
     * @return Reference to member var_map_string_octet
     */
    eProsima_user_DllExport std::map<std::string, uint8_t>& var_map_string_octet()
    {
        return m_var_map_string_octet;
    }



private:

    std::map<std::string, uint8_t> m_var_map_string_octet;

};
/*!
 * @brief This class represents the structure MapStringChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringChar that will be copied.
     */
    eProsima_user_DllExport MapStringChar(
            const MapStringChar& x)
    {
                    m_var_map_string_char = x.m_var_map_string_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringChar that will be copied.
     */
    eProsima_user_DllExport MapStringChar(
            MapStringChar&& x) noexcept
    {
        m_var_map_string_char = std::move(x.m_var_map_string_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringChar that will be copied.
     */
    eProsima_user_DllExport MapStringChar& operator =(
            const MapStringChar& x)
    {

                    m_var_map_string_char = x.m_var_map_string_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringChar that will be copied.
     */
    eProsima_user_DllExport MapStringChar& operator =(
            MapStringChar&& x) noexcept
    {

        m_var_map_string_char = std::move(x.m_var_map_string_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringChar& x) const
    {
        return (m_var_map_string_char == x.m_var_map_string_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_char
     * @param _var_map_string_char New value to be copied in member var_map_string_char
     */
    eProsima_user_DllExport void var_map_string_char(
            const std::map<std::string, char>& _var_map_string_char)
    {
        m_var_map_string_char = _var_map_string_char;
    }

    /*!
     * @brief This function moves the value in member var_map_string_char
     * @param _var_map_string_char New value to be moved in member var_map_string_char
     */
    eProsima_user_DllExport void var_map_string_char(
            std::map<std::string, char>&& _var_map_string_char)
    {
        m_var_map_string_char = std::move(_var_map_string_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_char
     * @return Constant reference to member var_map_string_char
     */
    eProsima_user_DllExport const std::map<std::string, char>& var_map_string_char() const
    {
        return m_var_map_string_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_char
     * @return Reference to member var_map_string_char
     */
    eProsima_user_DllExport std::map<std::string, char>& var_map_string_char()
    {
        return m_var_map_string_char;
    }



private:

    std::map<std::string, char> m_var_map_string_char;

};
/*!
 * @brief This class represents the structure MapStringWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringWChar that will be copied.
     */
    eProsima_user_DllExport MapStringWChar(
            const MapStringWChar& x)
    {
                    m_var_map_string_wchar = x.m_var_map_string_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringWChar that will be copied.
     */
    eProsima_user_DllExport MapStringWChar(
            MapStringWChar&& x) noexcept
    {
        m_var_map_string_wchar = std::move(x.m_var_map_string_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringWChar that will be copied.
     */
    eProsima_user_DllExport MapStringWChar& operator =(
            const MapStringWChar& x)
    {

                    m_var_map_string_wchar = x.m_var_map_string_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringWChar that will be copied.
     */
    eProsima_user_DllExport MapStringWChar& operator =(
            MapStringWChar&& x) noexcept
    {

        m_var_map_string_wchar = std::move(x.m_var_map_string_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringWChar& x) const
    {
        return (m_var_map_string_wchar == x.m_var_map_string_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_wchar
     * @param _var_map_string_wchar New value to be copied in member var_map_string_wchar
     */
    eProsima_user_DllExport void var_map_string_wchar(
            const std::map<std::string, wchar_t>& _var_map_string_wchar)
    {
        m_var_map_string_wchar = _var_map_string_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_string_wchar
     * @param _var_map_string_wchar New value to be moved in member var_map_string_wchar
     */
    eProsima_user_DllExport void var_map_string_wchar(
            std::map<std::string, wchar_t>&& _var_map_string_wchar)
    {
        m_var_map_string_wchar = std::move(_var_map_string_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_wchar
     * @return Constant reference to member var_map_string_wchar
     */
    eProsima_user_DllExport const std::map<std::string, wchar_t>& var_map_string_wchar() const
    {
        return m_var_map_string_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_wchar
     * @return Reference to member var_map_string_wchar
     */
    eProsima_user_DllExport std::map<std::string, wchar_t>& var_map_string_wchar()
    {
        return m_var_map_string_wchar;
    }



private:

    std::map<std::string, wchar_t> m_var_map_string_wchar;

};
/*!
 * @brief This class represents the structure MapStringString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringString that will be copied.
     */
    eProsima_user_DllExport MapStringString(
            const MapStringString& x)
    {
                    m_var_map_string_string = x.m_var_map_string_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringString that will be copied.
     */
    eProsima_user_DllExport MapStringString(
            MapStringString&& x) noexcept
    {
        m_var_map_string_string = std::move(x.m_var_map_string_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringString that will be copied.
     */
    eProsima_user_DllExport MapStringString& operator =(
            const MapStringString& x)
    {

                    m_var_map_string_string = x.m_var_map_string_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringString that will be copied.
     */
    eProsima_user_DllExport MapStringString& operator =(
            MapStringString&& x) noexcept
    {

        m_var_map_string_string = std::move(x.m_var_map_string_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringString& x) const
    {
        return (m_var_map_string_string == x.m_var_map_string_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_string
     * @param _var_map_string_string New value to be copied in member var_map_string_string
     */
    eProsima_user_DllExport void var_map_string_string(
            const std::map<std::string, std::string>& _var_map_string_string)
    {
        m_var_map_string_string = _var_map_string_string;
    }

    /*!
     * @brief This function moves the value in member var_map_string_string
     * @param _var_map_string_string New value to be moved in member var_map_string_string
     */
    eProsima_user_DllExport void var_map_string_string(
            std::map<std::string, std::string>&& _var_map_string_string)
    {
        m_var_map_string_string = std::move(_var_map_string_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_string
     * @return Constant reference to member var_map_string_string
     */
    eProsima_user_DllExport const std::map<std::string, std::string>& var_map_string_string() const
    {
        return m_var_map_string_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_string
     * @return Reference to member var_map_string_string
     */
    eProsima_user_DllExport std::map<std::string, std::string>& var_map_string_string()
    {
        return m_var_map_string_string;
    }



private:

    std::map<std::string, std::string> m_var_map_string_string;

};
/*!
 * @brief This class represents the structure MapStringWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringWString that will be copied.
     */
    eProsima_user_DllExport MapStringWString(
            const MapStringWString& x)
    {
                    m_var_map_string_wstring = x.m_var_map_string_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringWString that will be copied.
     */
    eProsima_user_DllExport MapStringWString(
            MapStringWString&& x) noexcept
    {
        m_var_map_string_wstring = std::move(x.m_var_map_string_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringWString that will be copied.
     */
    eProsima_user_DllExport MapStringWString& operator =(
            const MapStringWString& x)
    {

                    m_var_map_string_wstring = x.m_var_map_string_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringWString that will be copied.
     */
    eProsima_user_DllExport MapStringWString& operator =(
            MapStringWString&& x) noexcept
    {

        m_var_map_string_wstring = std::move(x.m_var_map_string_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringWString& x) const
    {
        return (m_var_map_string_wstring == x.m_var_map_string_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_wstring
     * @param _var_map_string_wstring New value to be copied in member var_map_string_wstring
     */
    eProsima_user_DllExport void var_map_string_wstring(
            const std::map<std::string, std::wstring>& _var_map_string_wstring)
    {
        m_var_map_string_wstring = _var_map_string_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_string_wstring
     * @param _var_map_string_wstring New value to be moved in member var_map_string_wstring
     */
    eProsima_user_DllExport void var_map_string_wstring(
            std::map<std::string, std::wstring>&& _var_map_string_wstring)
    {
        m_var_map_string_wstring = std::move(_var_map_string_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_wstring
     * @return Constant reference to member var_map_string_wstring
     */
    eProsima_user_DllExport const std::map<std::string, std::wstring>& var_map_string_wstring() const
    {
        return m_var_map_string_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_wstring
     * @return Reference to member var_map_string_wstring
     */
    eProsima_user_DllExport std::map<std::string, std::wstring>& var_map_string_wstring()
    {
        return m_var_map_string_wstring;
    }



private:

    std::map<std::string, std::wstring> m_var_map_string_wstring;

};
/*!
 * @brief This class represents the structure MapStringInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedStringHelper(
            const MapStringInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_string_inneraliasboundedstringhelper = x.m_var_map_string_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedStringHelper(
            MapStringInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_string_inneraliasboundedstringhelper = std::move(x.m_var_map_string_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedStringHelper& operator =(
            const MapStringInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_string_inneraliasboundedstringhelper = x.m_var_map_string_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedStringHelper& operator =(
            MapStringInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_string_inneraliasboundedstringhelper = std::move(x.m_var_map_string_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_string_inneraliasboundedstringhelper == x.m_var_map_string_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_inneraliasboundedstringhelper
     * @param _var_map_string_inneraliasboundedstringhelper New value to be copied in member var_map_string_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasboundedstringhelper(
            const std::map<std::string, Inner_alias_bounded_string_helper>& _var_map_string_inneraliasboundedstringhelper)
    {
        m_var_map_string_inneraliasboundedstringhelper = _var_map_string_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_inneraliasboundedstringhelper
     * @param _var_map_string_inneraliasboundedstringhelper New value to be moved in member var_map_string_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasboundedstringhelper(
            std::map<std::string, Inner_alias_bounded_string_helper>&& _var_map_string_inneraliasboundedstringhelper)
    {
        m_var_map_string_inneraliasboundedstringhelper = std::move(_var_map_string_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_string_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<std::string, Inner_alias_bounded_string_helper>& var_map_string_inneraliasboundedstringhelper() const
    {
        return m_var_map_string_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_inneraliasboundedstringhelper
     * @return Reference to member var_map_string_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<std::string, Inner_alias_bounded_string_helper>& var_map_string_inneraliasboundedstringhelper()
    {
        return m_var_map_string_inneraliasboundedstringhelper;
    }



private:

    std::map<std::string, Inner_alias_bounded_string_helper> m_var_map_string_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapStringInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedWStringHelper(
            const MapStringInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_string_inneraliasboundedwstringhelper = x.m_var_map_string_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedWStringHelper(
            MapStringInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_string_inneraliasboundedwstringhelper = std::move(x.m_var_map_string_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedWStringHelper& operator =(
            const MapStringInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_string_inneraliasboundedwstringhelper = x.m_var_map_string_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasBoundedWStringHelper& operator =(
            MapStringInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_string_inneraliasboundedwstringhelper = std::move(x.m_var_map_string_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_string_inneraliasboundedwstringhelper == x.m_var_map_string_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_inneraliasboundedwstringhelper
     * @param _var_map_string_inneraliasboundedwstringhelper New value to be copied in member var_map_string_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasboundedwstringhelper(
            const std::map<std::string, Inner_alias_bounded_wstring_helper>& _var_map_string_inneraliasboundedwstringhelper)
    {
        m_var_map_string_inneraliasboundedwstringhelper = _var_map_string_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_inneraliasboundedwstringhelper
     * @param _var_map_string_inneraliasboundedwstringhelper New value to be moved in member var_map_string_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasboundedwstringhelper(
            std::map<std::string, Inner_alias_bounded_wstring_helper>&& _var_map_string_inneraliasboundedwstringhelper)
    {
        m_var_map_string_inneraliasboundedwstringhelper = std::move(_var_map_string_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_string_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<std::string, Inner_alias_bounded_wstring_helper>& var_map_string_inneraliasboundedwstringhelper() const
    {
        return m_var_map_string_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_inneraliasboundedwstringhelper
     * @return Reference to member var_map_string_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<std::string, Inner_alias_bounded_wstring_helper>& var_map_string_inneraliasboundedwstringhelper()
    {
        return m_var_map_string_inneraliasboundedwstringhelper;
    }



private:

    std::map<std::string, Inner_alias_bounded_wstring_helper> m_var_map_string_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapStringInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerEnumHelper(
            const MapStringInnerEnumHelper& x)
    {
                    m_var_map_string_innerenumhelper = x.m_var_map_string_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerEnumHelper(
            MapStringInnerEnumHelper&& x) noexcept
    {
        m_var_map_string_innerenumhelper = std::move(x.m_var_map_string_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerEnumHelper& operator =(
            const MapStringInnerEnumHelper& x)
    {

                    m_var_map_string_innerenumhelper = x.m_var_map_string_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerEnumHelper& operator =(
            MapStringInnerEnumHelper&& x) noexcept
    {

        m_var_map_string_innerenumhelper = std::move(x.m_var_map_string_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerEnumHelper& x) const
    {
        return (m_var_map_string_innerenumhelper == x.m_var_map_string_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_innerenumhelper
     * @param _var_map_string_innerenumhelper New value to be copied in member var_map_string_innerenumhelper
     */
    eProsima_user_DllExport void var_map_string_innerenumhelper(
            const std::map<std::string, InnerEnumHelper>& _var_map_string_innerenumhelper)
    {
        m_var_map_string_innerenumhelper = _var_map_string_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_innerenumhelper
     * @param _var_map_string_innerenumhelper New value to be moved in member var_map_string_innerenumhelper
     */
    eProsima_user_DllExport void var_map_string_innerenumhelper(
            std::map<std::string, InnerEnumHelper>&& _var_map_string_innerenumhelper)
    {
        m_var_map_string_innerenumhelper = std::move(_var_map_string_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_innerenumhelper
     * @return Constant reference to member var_map_string_innerenumhelper
     */
    eProsima_user_DllExport const std::map<std::string, InnerEnumHelper>& var_map_string_innerenumhelper() const
    {
        return m_var_map_string_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_innerenumhelper
     * @return Reference to member var_map_string_innerenumhelper
     */
    eProsima_user_DllExport std::map<std::string, InnerEnumHelper>& var_map_string_innerenumhelper()
    {
        return m_var_map_string_innerenumhelper;
    }



private:

    std::map<std::string, InnerEnumHelper> m_var_map_string_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapStringInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitMaskHelper(
            const MapStringInnerBitMaskHelper& x)
    {
                    m_var_map_string_innerbitmaskhelper = x.m_var_map_string_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitMaskHelper(
            MapStringInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_string_innerbitmaskhelper = std::move(x.m_var_map_string_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitMaskHelper& operator =(
            const MapStringInnerBitMaskHelper& x)
    {

                    m_var_map_string_innerbitmaskhelper = x.m_var_map_string_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitMaskHelper& operator =(
            MapStringInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_string_innerbitmaskhelper = std::move(x.m_var_map_string_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerBitMaskHelper& x) const
    {
        return (m_var_map_string_innerbitmaskhelper == x.m_var_map_string_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_innerbitmaskhelper
     * @param _var_map_string_innerbitmaskhelper New value to be copied in member var_map_string_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_string_innerbitmaskhelper(
            const std::map<std::string, InnerBitMaskHelper>& _var_map_string_innerbitmaskhelper)
    {
        m_var_map_string_innerbitmaskhelper = _var_map_string_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_innerbitmaskhelper
     * @param _var_map_string_innerbitmaskhelper New value to be moved in member var_map_string_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_string_innerbitmaskhelper(
            std::map<std::string, InnerBitMaskHelper>&& _var_map_string_innerbitmaskhelper)
    {
        m_var_map_string_innerbitmaskhelper = std::move(_var_map_string_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_innerbitmaskhelper
     * @return Constant reference to member var_map_string_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<std::string, InnerBitMaskHelper>& var_map_string_innerbitmaskhelper() const
    {
        return m_var_map_string_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_innerbitmaskhelper
     * @return Reference to member var_map_string_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<std::string, InnerBitMaskHelper>& var_map_string_innerbitmaskhelper()
    {
        return m_var_map_string_innerbitmaskhelper;
    }



private:

    std::map<std::string, InnerBitMaskHelper> m_var_map_string_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapStringInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasHelper(
            const MapStringInnerAliasHelper& x)
    {
                    m_var_map_string_inneraliashelper = x.m_var_map_string_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasHelper(
            MapStringInnerAliasHelper&& x) noexcept
    {
        m_var_map_string_inneraliashelper = std::move(x.m_var_map_string_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasHelper& operator =(
            const MapStringInnerAliasHelper& x)
    {

                    m_var_map_string_inneraliashelper = x.m_var_map_string_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasHelper& operator =(
            MapStringInnerAliasHelper&& x) noexcept
    {

        m_var_map_string_inneraliashelper = std::move(x.m_var_map_string_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerAliasHelper& x) const
    {
        return (m_var_map_string_inneraliashelper == x.m_var_map_string_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_inneraliashelper
     * @param _var_map_string_inneraliashelper New value to be copied in member var_map_string_inneraliashelper
     */
    eProsima_user_DllExport void var_map_string_inneraliashelper(
            const std::map<std::string, InnerAliasHelper>& _var_map_string_inneraliashelper)
    {
        m_var_map_string_inneraliashelper = _var_map_string_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_inneraliashelper
     * @param _var_map_string_inneraliashelper New value to be moved in member var_map_string_inneraliashelper
     */
    eProsima_user_DllExport void var_map_string_inneraliashelper(
            std::map<std::string, InnerAliasHelper>&& _var_map_string_inneraliashelper)
    {
        m_var_map_string_inneraliashelper = std::move(_var_map_string_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_inneraliashelper
     * @return Constant reference to member var_map_string_inneraliashelper
     */
    eProsima_user_DllExport const std::map<std::string, InnerAliasHelper>& var_map_string_inneraliashelper() const
    {
        return m_var_map_string_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_inneraliashelper
     * @return Reference to member var_map_string_inneraliashelper
     */
    eProsima_user_DllExport std::map<std::string, InnerAliasHelper>& var_map_string_inneraliashelper()
    {
        return m_var_map_string_inneraliashelper;
    }



private:

    std::map<std::string, InnerAliasHelper> m_var_map_string_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapStringInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasArrayHelper(
            const MapStringInnerAliasArrayHelper& x)
    {
                    m_var_map_string_inneraliasarrayhelper = x.m_var_map_string_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasArrayHelper(
            MapStringInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_string_inneraliasarrayhelper = std::move(x.m_var_map_string_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasArrayHelper& operator =(
            const MapStringInnerAliasArrayHelper& x)
    {

                    m_var_map_string_inneraliasarrayhelper = x.m_var_map_string_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasArrayHelper& operator =(
            MapStringInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_string_inneraliasarrayhelper = std::move(x.m_var_map_string_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerAliasArrayHelper& x) const
    {
        return (m_var_map_string_inneraliasarrayhelper == x.m_var_map_string_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_inneraliasarrayhelper
     * @param _var_map_string_inneraliasarrayhelper New value to be copied in member var_map_string_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasarrayhelper(
            const std::map<std::string, Inner_alias_array_helper>& _var_map_string_inneraliasarrayhelper)
    {
        m_var_map_string_inneraliasarrayhelper = _var_map_string_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_inneraliasarrayhelper
     * @param _var_map_string_inneraliasarrayhelper New value to be moved in member var_map_string_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasarrayhelper(
            std::map<std::string, Inner_alias_array_helper>&& _var_map_string_inneraliasarrayhelper)
    {
        m_var_map_string_inneraliasarrayhelper = std::move(_var_map_string_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_inneraliasarrayhelper
     * @return Constant reference to member var_map_string_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<std::string, Inner_alias_array_helper>& var_map_string_inneraliasarrayhelper() const
    {
        return m_var_map_string_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_inneraliasarrayhelper
     * @return Reference to member var_map_string_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<std::string, Inner_alias_array_helper>& var_map_string_inneraliasarrayhelper()
    {
        return m_var_map_string_inneraliasarrayhelper;
    }



private:

    std::map<std::string, Inner_alias_array_helper> m_var_map_string_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapStringInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasSequenceHelper(
            const MapStringInnerAliasSequenceHelper& x)
    {
                    m_var_map_string_inneraliassequencehelper = x.m_var_map_string_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasSequenceHelper(
            MapStringInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_string_inneraliassequencehelper = std::move(x.m_var_map_string_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasSequenceHelper& operator =(
            const MapStringInnerAliasSequenceHelper& x)
    {

                    m_var_map_string_inneraliassequencehelper = x.m_var_map_string_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasSequenceHelper& operator =(
            MapStringInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_string_inneraliassequencehelper = std::move(x.m_var_map_string_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_string_inneraliassequencehelper == x.m_var_map_string_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_inneraliassequencehelper
     * @param _var_map_string_inneraliassequencehelper New value to be copied in member var_map_string_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_string_inneraliassequencehelper(
            const std::map<std::string, Inner_alias_sequence_helper>& _var_map_string_inneraliassequencehelper)
    {
        m_var_map_string_inneraliassequencehelper = _var_map_string_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_inneraliassequencehelper
     * @param _var_map_string_inneraliassequencehelper New value to be moved in member var_map_string_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_string_inneraliassequencehelper(
            std::map<std::string, Inner_alias_sequence_helper>&& _var_map_string_inneraliassequencehelper)
    {
        m_var_map_string_inneraliassequencehelper = std::move(_var_map_string_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_inneraliassequencehelper
     * @return Constant reference to member var_map_string_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<std::string, Inner_alias_sequence_helper>& var_map_string_inneraliassequencehelper() const
    {
        return m_var_map_string_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_inneraliassequencehelper
     * @return Reference to member var_map_string_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<std::string, Inner_alias_sequence_helper>& var_map_string_inneraliassequencehelper()
    {
        return m_var_map_string_inneraliassequencehelper;
    }



private:

    std::map<std::string, Inner_alias_sequence_helper> m_var_map_string_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapStringInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasMapHelper(
            const MapStringInnerAliasMapHelper& x)
    {
                    m_var_map_string_inneraliasmaphelper = x.m_var_map_string_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasMapHelper(
            MapStringInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_string_inneraliasmaphelper = std::move(x.m_var_map_string_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasMapHelper& operator =(
            const MapStringInnerAliasMapHelper& x)
    {

                    m_var_map_string_inneraliasmaphelper = x.m_var_map_string_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerAliasMapHelper& operator =(
            MapStringInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_string_inneraliasmaphelper = std::move(x.m_var_map_string_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerAliasMapHelper& x) const
    {
        return (m_var_map_string_inneraliasmaphelper == x.m_var_map_string_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_inneraliasmaphelper
     * @param _var_map_string_inneraliasmaphelper New value to be copied in member var_map_string_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasmaphelper(
            const std::map<std::string, Inner_alias_map_helper>& _var_map_string_inneraliasmaphelper)
    {
        m_var_map_string_inneraliasmaphelper = _var_map_string_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_inneraliasmaphelper
     * @param _var_map_string_inneraliasmaphelper New value to be moved in member var_map_string_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_string_inneraliasmaphelper(
            std::map<std::string, Inner_alias_map_helper>&& _var_map_string_inneraliasmaphelper)
    {
        m_var_map_string_inneraliasmaphelper = std::move(_var_map_string_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_inneraliasmaphelper
     * @return Constant reference to member var_map_string_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<std::string, Inner_alias_map_helper>& var_map_string_inneraliasmaphelper() const
    {
        return m_var_map_string_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_inneraliasmaphelper
     * @return Reference to member var_map_string_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<std::string, Inner_alias_map_helper>& var_map_string_inneraliasmaphelper()
    {
        return m_var_map_string_inneraliasmaphelper;
    }



private:

    std::map<std::string, Inner_alias_map_helper> m_var_map_string_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapStringInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerUnionHelper(
            const MapStringInnerUnionHelper& x)
    {
                    m_var_map_string_innerunionhelper = x.m_var_map_string_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerUnionHelper(
            MapStringInnerUnionHelper&& x) noexcept
    {
        m_var_map_string_innerunionhelper = std::move(x.m_var_map_string_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerUnionHelper& operator =(
            const MapStringInnerUnionHelper& x)
    {

                    m_var_map_string_innerunionhelper = x.m_var_map_string_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerUnionHelper& operator =(
            MapStringInnerUnionHelper&& x) noexcept
    {

        m_var_map_string_innerunionhelper = std::move(x.m_var_map_string_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerUnionHelper& x) const
    {
        return (m_var_map_string_innerunionhelper == x.m_var_map_string_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_innerunionhelper
     * @param _var_map_string_innerunionhelper New value to be copied in member var_map_string_innerunionhelper
     */
    eProsima_user_DllExport void var_map_string_innerunionhelper(
            const std::map<std::string, InnerUnionHelper>& _var_map_string_innerunionhelper)
    {
        m_var_map_string_innerunionhelper = _var_map_string_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_innerunionhelper
     * @param _var_map_string_innerunionhelper New value to be moved in member var_map_string_innerunionhelper
     */
    eProsima_user_DllExport void var_map_string_innerunionhelper(
            std::map<std::string, InnerUnionHelper>&& _var_map_string_innerunionhelper)
    {
        m_var_map_string_innerunionhelper = std::move(_var_map_string_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_innerunionhelper
     * @return Constant reference to member var_map_string_innerunionhelper
     */
    eProsima_user_DllExport const std::map<std::string, InnerUnionHelper>& var_map_string_innerunionhelper() const
    {
        return m_var_map_string_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_innerunionhelper
     * @return Reference to member var_map_string_innerunionhelper
     */
    eProsima_user_DllExport std::map<std::string, InnerUnionHelper>& var_map_string_innerunionhelper()
    {
        return m_var_map_string_innerunionhelper;
    }



private:

    std::map<std::string, InnerUnionHelper> m_var_map_string_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapStringInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerStructureHelper(
            const MapStringInnerStructureHelper& x)
    {
                    m_var_map_string_innerstructurehelper = x.m_var_map_string_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerStructureHelper(
            MapStringInnerStructureHelper&& x) noexcept
    {
        m_var_map_string_innerstructurehelper = std::move(x.m_var_map_string_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerStructureHelper& operator =(
            const MapStringInnerStructureHelper& x)
    {

                    m_var_map_string_innerstructurehelper = x.m_var_map_string_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerStructureHelper& operator =(
            MapStringInnerStructureHelper&& x) noexcept
    {

        m_var_map_string_innerstructurehelper = std::move(x.m_var_map_string_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerStructureHelper& x) const
    {
        return (m_var_map_string_innerstructurehelper == x.m_var_map_string_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_innerstructurehelper
     * @param _var_map_string_innerstructurehelper New value to be copied in member var_map_string_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_string_innerstructurehelper(
            const std::map<std::string, InnerStructureHelper>& _var_map_string_innerstructurehelper)
    {
        m_var_map_string_innerstructurehelper = _var_map_string_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_innerstructurehelper
     * @param _var_map_string_innerstructurehelper New value to be moved in member var_map_string_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_string_innerstructurehelper(
            std::map<std::string, InnerStructureHelper>&& _var_map_string_innerstructurehelper)
    {
        m_var_map_string_innerstructurehelper = std::move(_var_map_string_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_innerstructurehelper
     * @return Constant reference to member var_map_string_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<std::string, InnerStructureHelper>& var_map_string_innerstructurehelper() const
    {
        return m_var_map_string_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_innerstructurehelper
     * @return Reference to member var_map_string_innerstructurehelper
     */
    eProsima_user_DllExport std::map<std::string, InnerStructureHelper>& var_map_string_innerstructurehelper()
    {
        return m_var_map_string_innerstructurehelper;
    }



private:

    std::map<std::string, InnerStructureHelper> m_var_map_string_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapStringInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapStringInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStringInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStringInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitsetHelper(
            const MapStringInnerBitsetHelper& x)
    {
                    m_var_map_string_innerbitsethelper = x.m_var_map_string_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitsetHelper(
            MapStringInnerBitsetHelper&& x) noexcept
    {
        m_var_map_string_innerbitsethelper = std::move(x.m_var_map_string_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitsetHelper& operator =(
            const MapStringInnerBitsetHelper& x)
    {

                    m_var_map_string_innerbitsethelper = x.m_var_map_string_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapStringInnerBitsetHelper& operator =(
            MapStringInnerBitsetHelper&& x) noexcept
    {

        m_var_map_string_innerbitsethelper = std::move(x.m_var_map_string_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStringInnerBitsetHelper& x) const
    {
        return (m_var_map_string_innerbitsethelper == x.m_var_map_string_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStringInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStringInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_string_innerbitsethelper
     * @param _var_map_string_innerbitsethelper New value to be copied in member var_map_string_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_string_innerbitsethelper(
            const std::map<std::string, InnerBitsetHelper>& _var_map_string_innerbitsethelper)
    {
        m_var_map_string_innerbitsethelper = _var_map_string_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_string_innerbitsethelper
     * @param _var_map_string_innerbitsethelper New value to be moved in member var_map_string_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_string_innerbitsethelper(
            std::map<std::string, InnerBitsetHelper>&& _var_map_string_innerbitsethelper)
    {
        m_var_map_string_innerbitsethelper = std::move(_var_map_string_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_string_innerbitsethelper
     * @return Constant reference to member var_map_string_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<std::string, InnerBitsetHelper>& var_map_string_innerbitsethelper() const
    {
        return m_var_map_string_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_string_innerbitsethelper
     * @return Reference to member var_map_string_innerbitsethelper
     */
    eProsima_user_DllExport std::map<std::string, InnerBitsetHelper>& var_map_string_innerbitsethelper()
    {
        return m_var_map_string_innerbitsethelper;
    }



private:

    std::map<std::string, InnerBitsetHelper> m_var_map_string_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapWStringShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringShort that will be copied.
     */
    eProsima_user_DllExport MapWStringShort(
            const MapWStringShort& x)
    {
                    m_var_map_wstring_short = x.m_var_map_wstring_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringShort that will be copied.
     */
    eProsima_user_DllExport MapWStringShort(
            MapWStringShort&& x) noexcept
    {
        m_var_map_wstring_short = std::move(x.m_var_map_wstring_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringShort that will be copied.
     */
    eProsima_user_DllExport MapWStringShort& operator =(
            const MapWStringShort& x)
    {

                    m_var_map_wstring_short = x.m_var_map_wstring_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringShort that will be copied.
     */
    eProsima_user_DllExport MapWStringShort& operator =(
            MapWStringShort&& x) noexcept
    {

        m_var_map_wstring_short = std::move(x.m_var_map_wstring_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringShort& x) const
    {
        return (m_var_map_wstring_short == x.m_var_map_wstring_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_short
     * @param _var_map_wstring_short New value to be copied in member var_map_wstring_short
     */
    eProsima_user_DllExport void var_map_wstring_short(
            const std::map<std::wstring, int16_t>& _var_map_wstring_short)
    {
        m_var_map_wstring_short = _var_map_wstring_short;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_short
     * @param _var_map_wstring_short New value to be moved in member var_map_wstring_short
     */
    eProsima_user_DllExport void var_map_wstring_short(
            std::map<std::wstring, int16_t>&& _var_map_wstring_short)
    {
        m_var_map_wstring_short = std::move(_var_map_wstring_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_short
     * @return Constant reference to member var_map_wstring_short
     */
    eProsima_user_DllExport const std::map<std::wstring, int16_t>& var_map_wstring_short() const
    {
        return m_var_map_wstring_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_short
     * @return Reference to member var_map_wstring_short
     */
    eProsima_user_DllExport std::map<std::wstring, int16_t>& var_map_wstring_short()
    {
        return m_var_map_wstring_short;
    }



private:

    std::map<std::wstring, int16_t> m_var_map_wstring_short;

};
/*!
 * @brief This class represents the structure MapWStringUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringUShort that will be copied.
     */
    eProsima_user_DllExport MapWStringUShort(
            const MapWStringUShort& x)
    {
                    m_var_map_wstring_ushort = x.m_var_map_wstring_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringUShort that will be copied.
     */
    eProsima_user_DllExport MapWStringUShort(
            MapWStringUShort&& x) noexcept
    {
        m_var_map_wstring_ushort = std::move(x.m_var_map_wstring_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringUShort that will be copied.
     */
    eProsima_user_DllExport MapWStringUShort& operator =(
            const MapWStringUShort& x)
    {

                    m_var_map_wstring_ushort = x.m_var_map_wstring_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringUShort that will be copied.
     */
    eProsima_user_DllExport MapWStringUShort& operator =(
            MapWStringUShort&& x) noexcept
    {

        m_var_map_wstring_ushort = std::move(x.m_var_map_wstring_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringUShort& x) const
    {
        return (m_var_map_wstring_ushort == x.m_var_map_wstring_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_ushort
     * @param _var_map_wstring_ushort New value to be copied in member var_map_wstring_ushort
     */
    eProsima_user_DllExport void var_map_wstring_ushort(
            const std::map<std::wstring, uint16_t>& _var_map_wstring_ushort)
    {
        m_var_map_wstring_ushort = _var_map_wstring_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_ushort
     * @param _var_map_wstring_ushort New value to be moved in member var_map_wstring_ushort
     */
    eProsima_user_DllExport void var_map_wstring_ushort(
            std::map<std::wstring, uint16_t>&& _var_map_wstring_ushort)
    {
        m_var_map_wstring_ushort = std::move(_var_map_wstring_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_ushort
     * @return Constant reference to member var_map_wstring_ushort
     */
    eProsima_user_DllExport const std::map<std::wstring, uint16_t>& var_map_wstring_ushort() const
    {
        return m_var_map_wstring_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_ushort
     * @return Reference to member var_map_wstring_ushort
     */
    eProsima_user_DllExport std::map<std::wstring, uint16_t>& var_map_wstring_ushort()
    {
        return m_var_map_wstring_ushort;
    }



private:

    std::map<std::wstring, uint16_t> m_var_map_wstring_ushort;

};
/*!
 * @brief This class represents the structure MapWStringLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLong(
            const MapWStringLong& x)
    {
                    m_var_map_wstring_long = x.m_var_map_wstring_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLong(
            MapWStringLong&& x) noexcept
    {
        m_var_map_wstring_long = std::move(x.m_var_map_wstring_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLong& operator =(
            const MapWStringLong& x)
    {

                    m_var_map_wstring_long = x.m_var_map_wstring_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLong& operator =(
            MapWStringLong&& x) noexcept
    {

        m_var_map_wstring_long = std::move(x.m_var_map_wstring_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringLong& x) const
    {
        return (m_var_map_wstring_long == x.m_var_map_wstring_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_long
     * @param _var_map_wstring_long New value to be copied in member var_map_wstring_long
     */
    eProsima_user_DllExport void var_map_wstring_long(
            const std::map<std::wstring, int32_t>& _var_map_wstring_long)
    {
        m_var_map_wstring_long = _var_map_wstring_long;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_long
     * @param _var_map_wstring_long New value to be moved in member var_map_wstring_long
     */
    eProsima_user_DllExport void var_map_wstring_long(
            std::map<std::wstring, int32_t>&& _var_map_wstring_long)
    {
        m_var_map_wstring_long = std::move(_var_map_wstring_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_long
     * @return Constant reference to member var_map_wstring_long
     */
    eProsima_user_DllExport const std::map<std::wstring, int32_t>& var_map_wstring_long() const
    {
        return m_var_map_wstring_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_long
     * @return Reference to member var_map_wstring_long
     */
    eProsima_user_DllExport std::map<std::wstring, int32_t>& var_map_wstring_long()
    {
        return m_var_map_wstring_long;
    }



private:

    std::map<std::wstring, int32_t> m_var_map_wstring_long;

};
/*!
 * @brief This class represents the structure MapWStringULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringULong that will be copied.
     */
    eProsima_user_DllExport MapWStringULong(
            const MapWStringULong& x)
    {
                    m_var_map_wstring_ulong = x.m_var_map_wstring_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringULong that will be copied.
     */
    eProsima_user_DllExport MapWStringULong(
            MapWStringULong&& x) noexcept
    {
        m_var_map_wstring_ulong = std::move(x.m_var_map_wstring_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringULong that will be copied.
     */
    eProsima_user_DllExport MapWStringULong& operator =(
            const MapWStringULong& x)
    {

                    m_var_map_wstring_ulong = x.m_var_map_wstring_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringULong that will be copied.
     */
    eProsima_user_DllExport MapWStringULong& operator =(
            MapWStringULong&& x) noexcept
    {

        m_var_map_wstring_ulong = std::move(x.m_var_map_wstring_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringULong& x) const
    {
        return (m_var_map_wstring_ulong == x.m_var_map_wstring_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_ulong
     * @param _var_map_wstring_ulong New value to be copied in member var_map_wstring_ulong
     */
    eProsima_user_DllExport void var_map_wstring_ulong(
            const std::map<std::wstring, uint32_t>& _var_map_wstring_ulong)
    {
        m_var_map_wstring_ulong = _var_map_wstring_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_ulong
     * @param _var_map_wstring_ulong New value to be moved in member var_map_wstring_ulong
     */
    eProsima_user_DllExport void var_map_wstring_ulong(
            std::map<std::wstring, uint32_t>&& _var_map_wstring_ulong)
    {
        m_var_map_wstring_ulong = std::move(_var_map_wstring_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_ulong
     * @return Constant reference to member var_map_wstring_ulong
     */
    eProsima_user_DllExport const std::map<std::wstring, uint32_t>& var_map_wstring_ulong() const
    {
        return m_var_map_wstring_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_ulong
     * @return Reference to member var_map_wstring_ulong
     */
    eProsima_user_DllExport std::map<std::wstring, uint32_t>& var_map_wstring_ulong()
    {
        return m_var_map_wstring_ulong;
    }



private:

    std::map<std::wstring, uint32_t> m_var_map_wstring_ulong;

};
/*!
 * @brief This class represents the structure MapWStringLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLongLong(
            const MapWStringLongLong& x)
    {
                    m_var_map_wstring_longlong = x.m_var_map_wstring_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLongLong(
            MapWStringLongLong&& x) noexcept
    {
        m_var_map_wstring_longlong = std::move(x.m_var_map_wstring_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLongLong& operator =(
            const MapWStringLongLong& x)
    {

                    m_var_map_wstring_longlong = x.m_var_map_wstring_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringLongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringLongLong& operator =(
            MapWStringLongLong&& x) noexcept
    {

        m_var_map_wstring_longlong = std::move(x.m_var_map_wstring_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringLongLong& x) const
    {
        return (m_var_map_wstring_longlong == x.m_var_map_wstring_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_longlong
     * @param _var_map_wstring_longlong New value to be copied in member var_map_wstring_longlong
     */
    eProsima_user_DllExport void var_map_wstring_longlong(
            const std::map<std::wstring, int64_t>& _var_map_wstring_longlong)
    {
        m_var_map_wstring_longlong = _var_map_wstring_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_longlong
     * @param _var_map_wstring_longlong New value to be moved in member var_map_wstring_longlong
     */
    eProsima_user_DllExport void var_map_wstring_longlong(
            std::map<std::wstring, int64_t>&& _var_map_wstring_longlong)
    {
        m_var_map_wstring_longlong = std::move(_var_map_wstring_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_longlong
     * @return Constant reference to member var_map_wstring_longlong
     */
    eProsima_user_DllExport const std::map<std::wstring, int64_t>& var_map_wstring_longlong() const
    {
        return m_var_map_wstring_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_longlong
     * @return Reference to member var_map_wstring_longlong
     */
    eProsima_user_DllExport std::map<std::wstring, int64_t>& var_map_wstring_longlong()
    {
        return m_var_map_wstring_longlong;
    }



private:

    std::map<std::wstring, int64_t> m_var_map_wstring_longlong;

};
/*!
 * @brief This class represents the structure MapWStringULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringULongLong(
            const MapWStringULongLong& x)
    {
                    m_var_map_wstring_ulonglong = x.m_var_map_wstring_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringULongLong(
            MapWStringULongLong&& x) noexcept
    {
        m_var_map_wstring_ulonglong = std::move(x.m_var_map_wstring_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringULongLong& operator =(
            const MapWStringULongLong& x)
    {

                    m_var_map_wstring_ulonglong = x.m_var_map_wstring_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringULongLong that will be copied.
     */
    eProsima_user_DllExport MapWStringULongLong& operator =(
            MapWStringULongLong&& x) noexcept
    {

        m_var_map_wstring_ulonglong = std::move(x.m_var_map_wstring_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringULongLong& x) const
    {
        return (m_var_map_wstring_ulonglong == x.m_var_map_wstring_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_ulonglong
     * @param _var_map_wstring_ulonglong New value to be copied in member var_map_wstring_ulonglong
     */
    eProsima_user_DllExport void var_map_wstring_ulonglong(
            const std::map<std::wstring, uint64_t>& _var_map_wstring_ulonglong)
    {
        m_var_map_wstring_ulonglong = _var_map_wstring_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_ulonglong
     * @param _var_map_wstring_ulonglong New value to be moved in member var_map_wstring_ulonglong
     */
    eProsima_user_DllExport void var_map_wstring_ulonglong(
            std::map<std::wstring, uint64_t>&& _var_map_wstring_ulonglong)
    {
        m_var_map_wstring_ulonglong = std::move(_var_map_wstring_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_ulonglong
     * @return Constant reference to member var_map_wstring_ulonglong
     */
    eProsima_user_DllExport const std::map<std::wstring, uint64_t>& var_map_wstring_ulonglong() const
    {
        return m_var_map_wstring_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_ulonglong
     * @return Reference to member var_map_wstring_ulonglong
     */
    eProsima_user_DllExport std::map<std::wstring, uint64_t>& var_map_wstring_ulonglong()
    {
        return m_var_map_wstring_ulonglong;
    }



private:

    std::map<std::wstring, uint64_t> m_var_map_wstring_ulonglong;

};
/*!
 * @brief This class represents the structure MapWStringFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringFloat that will be copied.
     */
    eProsima_user_DllExport MapWStringFloat(
            const MapWStringFloat& x)
    {
                    m_var_map_wstring_float = x.m_var_map_wstring_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringFloat that will be copied.
     */
    eProsima_user_DllExport MapWStringFloat(
            MapWStringFloat&& x) noexcept
    {
        m_var_map_wstring_float = std::move(x.m_var_map_wstring_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringFloat that will be copied.
     */
    eProsima_user_DllExport MapWStringFloat& operator =(
            const MapWStringFloat& x)
    {

                    m_var_map_wstring_float = x.m_var_map_wstring_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringFloat that will be copied.
     */
    eProsima_user_DllExport MapWStringFloat& operator =(
            MapWStringFloat&& x) noexcept
    {

        m_var_map_wstring_float = std::move(x.m_var_map_wstring_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringFloat& x) const
    {
        return (m_var_map_wstring_float == x.m_var_map_wstring_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_float
     * @param _var_map_wstring_float New value to be copied in member var_map_wstring_float
     */
    eProsima_user_DllExport void var_map_wstring_float(
            const std::map<std::wstring, float>& _var_map_wstring_float)
    {
        m_var_map_wstring_float = _var_map_wstring_float;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_float
     * @param _var_map_wstring_float New value to be moved in member var_map_wstring_float
     */
    eProsima_user_DllExport void var_map_wstring_float(
            std::map<std::wstring, float>&& _var_map_wstring_float)
    {
        m_var_map_wstring_float = std::move(_var_map_wstring_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_float
     * @return Constant reference to member var_map_wstring_float
     */
    eProsima_user_DllExport const std::map<std::wstring, float>& var_map_wstring_float() const
    {
        return m_var_map_wstring_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_float
     * @return Reference to member var_map_wstring_float
     */
    eProsima_user_DllExport std::map<std::wstring, float>& var_map_wstring_float()
    {
        return m_var_map_wstring_float;
    }



private:

    std::map<std::wstring, float> m_var_map_wstring_float;

};
/*!
 * @brief This class represents the structure MapWStringDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringDouble(
            const MapWStringDouble& x)
    {
                    m_var_map_wstring_double = x.m_var_map_wstring_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringDouble(
            MapWStringDouble&& x) noexcept
    {
        m_var_map_wstring_double = std::move(x.m_var_map_wstring_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringDouble& operator =(
            const MapWStringDouble& x)
    {

                    m_var_map_wstring_double = x.m_var_map_wstring_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringDouble& operator =(
            MapWStringDouble&& x) noexcept
    {

        m_var_map_wstring_double = std::move(x.m_var_map_wstring_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringDouble& x) const
    {
        return (m_var_map_wstring_double == x.m_var_map_wstring_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_double
     * @param _var_map_wstring_double New value to be copied in member var_map_wstring_double
     */
    eProsima_user_DllExport void var_map_wstring_double(
            const std::map<std::wstring, double>& _var_map_wstring_double)
    {
        m_var_map_wstring_double = _var_map_wstring_double;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_double
     * @param _var_map_wstring_double New value to be moved in member var_map_wstring_double
     */
    eProsima_user_DllExport void var_map_wstring_double(
            std::map<std::wstring, double>&& _var_map_wstring_double)
    {
        m_var_map_wstring_double = std::move(_var_map_wstring_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_double
     * @return Constant reference to member var_map_wstring_double
     */
    eProsima_user_DllExport const std::map<std::wstring, double>& var_map_wstring_double() const
    {
        return m_var_map_wstring_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_double
     * @return Reference to member var_map_wstring_double
     */
    eProsima_user_DllExport std::map<std::wstring, double>& var_map_wstring_double()
    {
        return m_var_map_wstring_double;
    }



private:

    std::map<std::wstring, double> m_var_map_wstring_double;

};
/*!
 * @brief This class represents the structure MapWStringLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringLongDouble(
            const MapWStringLongDouble& x)
    {
                    m_var_map_wstring_longdouble = x.m_var_map_wstring_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringLongDouble(
            MapWStringLongDouble&& x) noexcept
    {
        m_var_map_wstring_longdouble = std::move(x.m_var_map_wstring_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringLongDouble& operator =(
            const MapWStringLongDouble& x)
    {

                    m_var_map_wstring_longdouble = x.m_var_map_wstring_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringLongDouble that will be copied.
     */
    eProsima_user_DllExport MapWStringLongDouble& operator =(
            MapWStringLongDouble&& x) noexcept
    {

        m_var_map_wstring_longdouble = std::move(x.m_var_map_wstring_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringLongDouble& x) const
    {
        return (m_var_map_wstring_longdouble == x.m_var_map_wstring_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_longdouble
     * @param _var_map_wstring_longdouble New value to be copied in member var_map_wstring_longdouble
     */
    eProsima_user_DllExport void var_map_wstring_longdouble(
            const std::map<std::wstring, long double>& _var_map_wstring_longdouble)
    {
        m_var_map_wstring_longdouble = _var_map_wstring_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_longdouble
     * @param _var_map_wstring_longdouble New value to be moved in member var_map_wstring_longdouble
     */
    eProsima_user_DllExport void var_map_wstring_longdouble(
            std::map<std::wstring, long double>&& _var_map_wstring_longdouble)
    {
        m_var_map_wstring_longdouble = std::move(_var_map_wstring_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_longdouble
     * @return Constant reference to member var_map_wstring_longdouble
     */
    eProsima_user_DllExport const std::map<std::wstring, long double>& var_map_wstring_longdouble() const
    {
        return m_var_map_wstring_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_longdouble
     * @return Reference to member var_map_wstring_longdouble
     */
    eProsima_user_DllExport std::map<std::wstring, long double>& var_map_wstring_longdouble()
    {
        return m_var_map_wstring_longdouble;
    }



private:

    std::map<std::wstring, long double> m_var_map_wstring_longdouble;

};
/*!
 * @brief This class represents the structure MapWStringBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapWStringBoolean(
            const MapWStringBoolean& x)
    {
                    m_var_map_wstring_boolean = x.m_var_map_wstring_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapWStringBoolean(
            MapWStringBoolean&& x) noexcept
    {
        m_var_map_wstring_boolean = std::move(x.m_var_map_wstring_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapWStringBoolean& operator =(
            const MapWStringBoolean& x)
    {

                    m_var_map_wstring_boolean = x.m_var_map_wstring_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringBoolean that will be copied.
     */
    eProsima_user_DllExport MapWStringBoolean& operator =(
            MapWStringBoolean&& x) noexcept
    {

        m_var_map_wstring_boolean = std::move(x.m_var_map_wstring_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringBoolean& x) const
    {
        return (m_var_map_wstring_boolean == x.m_var_map_wstring_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_boolean
     * @param _var_map_wstring_boolean New value to be copied in member var_map_wstring_boolean
     */
    eProsima_user_DllExport void var_map_wstring_boolean(
            const std::map<std::wstring, bool>& _var_map_wstring_boolean)
    {
        m_var_map_wstring_boolean = _var_map_wstring_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_boolean
     * @param _var_map_wstring_boolean New value to be moved in member var_map_wstring_boolean
     */
    eProsima_user_DllExport void var_map_wstring_boolean(
            std::map<std::wstring, bool>&& _var_map_wstring_boolean)
    {
        m_var_map_wstring_boolean = std::move(_var_map_wstring_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_boolean
     * @return Constant reference to member var_map_wstring_boolean
     */
    eProsima_user_DllExport const std::map<std::wstring, bool>& var_map_wstring_boolean() const
    {
        return m_var_map_wstring_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_boolean
     * @return Reference to member var_map_wstring_boolean
     */
    eProsima_user_DllExport std::map<std::wstring, bool>& var_map_wstring_boolean()
    {
        return m_var_map_wstring_boolean;
    }



private:

    std::map<std::wstring, bool> m_var_map_wstring_boolean;

};
/*!
 * @brief This class represents the structure MapWStringOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringOctet that will be copied.
     */
    eProsima_user_DllExport MapWStringOctet(
            const MapWStringOctet& x)
    {
                    m_var_map_wstring_octet = x.m_var_map_wstring_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringOctet that will be copied.
     */
    eProsima_user_DllExport MapWStringOctet(
            MapWStringOctet&& x) noexcept
    {
        m_var_map_wstring_octet = std::move(x.m_var_map_wstring_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringOctet that will be copied.
     */
    eProsima_user_DllExport MapWStringOctet& operator =(
            const MapWStringOctet& x)
    {

                    m_var_map_wstring_octet = x.m_var_map_wstring_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringOctet that will be copied.
     */
    eProsima_user_DllExport MapWStringOctet& operator =(
            MapWStringOctet&& x) noexcept
    {

        m_var_map_wstring_octet = std::move(x.m_var_map_wstring_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringOctet& x) const
    {
        return (m_var_map_wstring_octet == x.m_var_map_wstring_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_octet
     * @param _var_map_wstring_octet New value to be copied in member var_map_wstring_octet
     */
    eProsima_user_DllExport void var_map_wstring_octet(
            const std::map<std::wstring, uint8_t>& _var_map_wstring_octet)
    {
        m_var_map_wstring_octet = _var_map_wstring_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_octet
     * @param _var_map_wstring_octet New value to be moved in member var_map_wstring_octet
     */
    eProsima_user_DllExport void var_map_wstring_octet(
            std::map<std::wstring, uint8_t>&& _var_map_wstring_octet)
    {
        m_var_map_wstring_octet = std::move(_var_map_wstring_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_octet
     * @return Constant reference to member var_map_wstring_octet
     */
    eProsima_user_DllExport const std::map<std::wstring, uint8_t>& var_map_wstring_octet() const
    {
        return m_var_map_wstring_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_octet
     * @return Reference to member var_map_wstring_octet
     */
    eProsima_user_DllExport std::map<std::wstring, uint8_t>& var_map_wstring_octet()
    {
        return m_var_map_wstring_octet;
    }



private:

    std::map<std::wstring, uint8_t> m_var_map_wstring_octet;

};
/*!
 * @brief This class represents the structure MapWStringChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringChar that will be copied.
     */
    eProsima_user_DllExport MapWStringChar(
            const MapWStringChar& x)
    {
                    m_var_map_wstring_char = x.m_var_map_wstring_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringChar that will be copied.
     */
    eProsima_user_DllExport MapWStringChar(
            MapWStringChar&& x) noexcept
    {
        m_var_map_wstring_char = std::move(x.m_var_map_wstring_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringChar that will be copied.
     */
    eProsima_user_DllExport MapWStringChar& operator =(
            const MapWStringChar& x)
    {

                    m_var_map_wstring_char = x.m_var_map_wstring_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringChar that will be copied.
     */
    eProsima_user_DllExport MapWStringChar& operator =(
            MapWStringChar&& x) noexcept
    {

        m_var_map_wstring_char = std::move(x.m_var_map_wstring_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringChar& x) const
    {
        return (m_var_map_wstring_char == x.m_var_map_wstring_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_char
     * @param _var_map_wstring_char New value to be copied in member var_map_wstring_char
     */
    eProsima_user_DllExport void var_map_wstring_char(
            const std::map<std::wstring, char>& _var_map_wstring_char)
    {
        m_var_map_wstring_char = _var_map_wstring_char;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_char
     * @param _var_map_wstring_char New value to be moved in member var_map_wstring_char
     */
    eProsima_user_DllExport void var_map_wstring_char(
            std::map<std::wstring, char>&& _var_map_wstring_char)
    {
        m_var_map_wstring_char = std::move(_var_map_wstring_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_char
     * @return Constant reference to member var_map_wstring_char
     */
    eProsima_user_DllExport const std::map<std::wstring, char>& var_map_wstring_char() const
    {
        return m_var_map_wstring_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_char
     * @return Reference to member var_map_wstring_char
     */
    eProsima_user_DllExport std::map<std::wstring, char>& var_map_wstring_char()
    {
        return m_var_map_wstring_char;
    }



private:

    std::map<std::wstring, char> m_var_map_wstring_char;

};
/*!
 * @brief This class represents the structure MapWStringWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringWChar that will be copied.
     */
    eProsima_user_DllExport MapWStringWChar(
            const MapWStringWChar& x)
    {
                    m_var_map_wstring_wchar = x.m_var_map_wstring_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringWChar that will be copied.
     */
    eProsima_user_DllExport MapWStringWChar(
            MapWStringWChar&& x) noexcept
    {
        m_var_map_wstring_wchar = std::move(x.m_var_map_wstring_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringWChar that will be copied.
     */
    eProsima_user_DllExport MapWStringWChar& operator =(
            const MapWStringWChar& x)
    {

                    m_var_map_wstring_wchar = x.m_var_map_wstring_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringWChar that will be copied.
     */
    eProsima_user_DllExport MapWStringWChar& operator =(
            MapWStringWChar&& x) noexcept
    {

        m_var_map_wstring_wchar = std::move(x.m_var_map_wstring_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringWChar& x) const
    {
        return (m_var_map_wstring_wchar == x.m_var_map_wstring_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_wchar
     * @param _var_map_wstring_wchar New value to be copied in member var_map_wstring_wchar
     */
    eProsima_user_DllExport void var_map_wstring_wchar(
            const std::map<std::wstring, wchar_t>& _var_map_wstring_wchar)
    {
        m_var_map_wstring_wchar = _var_map_wstring_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_wchar
     * @param _var_map_wstring_wchar New value to be moved in member var_map_wstring_wchar
     */
    eProsima_user_DllExport void var_map_wstring_wchar(
            std::map<std::wstring, wchar_t>&& _var_map_wstring_wchar)
    {
        m_var_map_wstring_wchar = std::move(_var_map_wstring_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_wchar
     * @return Constant reference to member var_map_wstring_wchar
     */
    eProsima_user_DllExport const std::map<std::wstring, wchar_t>& var_map_wstring_wchar() const
    {
        return m_var_map_wstring_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_wchar
     * @return Reference to member var_map_wstring_wchar
     */
    eProsima_user_DllExport std::map<std::wstring, wchar_t>& var_map_wstring_wchar()
    {
        return m_var_map_wstring_wchar;
    }



private:

    std::map<std::wstring, wchar_t> m_var_map_wstring_wchar;

};
/*!
 * @brief This class represents the structure MapWStringString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringString that will be copied.
     */
    eProsima_user_DllExport MapWStringString(
            const MapWStringString& x)
    {
                    m_var_map_wstring_string = x.m_var_map_wstring_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringString that will be copied.
     */
    eProsima_user_DllExport MapWStringString(
            MapWStringString&& x) noexcept
    {
        m_var_map_wstring_string = std::move(x.m_var_map_wstring_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringString that will be copied.
     */
    eProsima_user_DllExport MapWStringString& operator =(
            const MapWStringString& x)
    {

                    m_var_map_wstring_string = x.m_var_map_wstring_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringString that will be copied.
     */
    eProsima_user_DllExport MapWStringString& operator =(
            MapWStringString&& x) noexcept
    {

        m_var_map_wstring_string = std::move(x.m_var_map_wstring_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringString& x) const
    {
        return (m_var_map_wstring_string == x.m_var_map_wstring_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_string
     * @param _var_map_wstring_string New value to be copied in member var_map_wstring_string
     */
    eProsima_user_DllExport void var_map_wstring_string(
            const std::map<std::wstring, std::string>& _var_map_wstring_string)
    {
        m_var_map_wstring_string = _var_map_wstring_string;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_string
     * @param _var_map_wstring_string New value to be moved in member var_map_wstring_string
     */
    eProsima_user_DllExport void var_map_wstring_string(
            std::map<std::wstring, std::string>&& _var_map_wstring_string)
    {
        m_var_map_wstring_string = std::move(_var_map_wstring_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_string
     * @return Constant reference to member var_map_wstring_string
     */
    eProsima_user_DllExport const std::map<std::wstring, std::string>& var_map_wstring_string() const
    {
        return m_var_map_wstring_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_string
     * @return Reference to member var_map_wstring_string
     */
    eProsima_user_DllExport std::map<std::wstring, std::string>& var_map_wstring_string()
    {
        return m_var_map_wstring_string;
    }



private:

    std::map<std::wstring, std::string> m_var_map_wstring_string;

};
/*!
 * @brief This class represents the structure MapWStringWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringWString that will be copied.
     */
    eProsima_user_DllExport MapWStringWString(
            const MapWStringWString& x)
    {
                    m_var_map_wstring_wstring = x.m_var_map_wstring_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringWString that will be copied.
     */
    eProsima_user_DllExport MapWStringWString(
            MapWStringWString&& x) noexcept
    {
        m_var_map_wstring_wstring = std::move(x.m_var_map_wstring_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringWString that will be copied.
     */
    eProsima_user_DllExport MapWStringWString& operator =(
            const MapWStringWString& x)
    {

                    m_var_map_wstring_wstring = x.m_var_map_wstring_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringWString that will be copied.
     */
    eProsima_user_DllExport MapWStringWString& operator =(
            MapWStringWString&& x) noexcept
    {

        m_var_map_wstring_wstring = std::move(x.m_var_map_wstring_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringWString& x) const
    {
        return (m_var_map_wstring_wstring == x.m_var_map_wstring_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_wstring
     * @param _var_map_wstring_wstring New value to be copied in member var_map_wstring_wstring
     */
    eProsima_user_DllExport void var_map_wstring_wstring(
            const std::map<std::wstring, std::wstring>& _var_map_wstring_wstring)
    {
        m_var_map_wstring_wstring = _var_map_wstring_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_wstring
     * @param _var_map_wstring_wstring New value to be moved in member var_map_wstring_wstring
     */
    eProsima_user_DllExport void var_map_wstring_wstring(
            std::map<std::wstring, std::wstring>&& _var_map_wstring_wstring)
    {
        m_var_map_wstring_wstring = std::move(_var_map_wstring_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_wstring
     * @return Constant reference to member var_map_wstring_wstring
     */
    eProsima_user_DllExport const std::map<std::wstring, std::wstring>& var_map_wstring_wstring() const
    {
        return m_var_map_wstring_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_wstring
     * @return Reference to member var_map_wstring_wstring
     */
    eProsima_user_DllExport std::map<std::wstring, std::wstring>& var_map_wstring_wstring()
    {
        return m_var_map_wstring_wstring;
    }



private:

    std::map<std::wstring, std::wstring> m_var_map_wstring_wstring;

};
/*!
 * @brief This class represents the structure MapWStringInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedStringHelper(
            const MapWStringInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_wstring_inneraliasboundedstringhelper = x.m_var_map_wstring_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedStringHelper(
            MapWStringInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_wstring_inneraliasboundedstringhelper = std::move(x.m_var_map_wstring_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedStringHelper& operator =(
            const MapWStringInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_wstring_inneraliasboundedstringhelper = x.m_var_map_wstring_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedStringHelper& operator =(
            MapWStringInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_wstring_inneraliasboundedstringhelper = std::move(x.m_var_map_wstring_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_wstring_inneraliasboundedstringhelper == x.m_var_map_wstring_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_inneraliasboundedstringhelper
     * @param _var_map_wstring_inneraliasboundedstringhelper New value to be copied in member var_map_wstring_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasboundedstringhelper(
            const std::map<std::wstring, Inner_alias_bounded_string_helper>& _var_map_wstring_inneraliasboundedstringhelper)
    {
        m_var_map_wstring_inneraliasboundedstringhelper = _var_map_wstring_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_inneraliasboundedstringhelper
     * @param _var_map_wstring_inneraliasboundedstringhelper New value to be moved in member var_map_wstring_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasboundedstringhelper(
            std::map<std::wstring, Inner_alias_bounded_string_helper>&& _var_map_wstring_inneraliasboundedstringhelper)
    {
        m_var_map_wstring_inneraliasboundedstringhelper = std::move(_var_map_wstring_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_wstring_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<std::wstring, Inner_alias_bounded_string_helper>& var_map_wstring_inneraliasboundedstringhelper() const
    {
        return m_var_map_wstring_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_inneraliasboundedstringhelper
     * @return Reference to member var_map_wstring_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<std::wstring, Inner_alias_bounded_string_helper>& var_map_wstring_inneraliasboundedstringhelper()
    {
        return m_var_map_wstring_inneraliasboundedstringhelper;
    }



private:

    std::map<std::wstring, Inner_alias_bounded_string_helper> m_var_map_wstring_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedWStringHelper(
            const MapWStringInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_wstring_inneraliasboundedwstringhelper = x.m_var_map_wstring_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedWStringHelper(
            MapWStringInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_wstring_inneraliasboundedwstringhelper = std::move(x.m_var_map_wstring_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedWStringHelper& operator =(
            const MapWStringInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_wstring_inneraliasboundedwstringhelper = x.m_var_map_wstring_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasBoundedWStringHelper& operator =(
            MapWStringInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_wstring_inneraliasboundedwstringhelper = std::move(x.m_var_map_wstring_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_wstring_inneraliasboundedwstringhelper == x.m_var_map_wstring_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_inneraliasboundedwstringhelper
     * @param _var_map_wstring_inneraliasboundedwstringhelper New value to be copied in member var_map_wstring_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasboundedwstringhelper(
            const std::map<std::wstring, Inner_alias_bounded_wstring_helper>& _var_map_wstring_inneraliasboundedwstringhelper)
    {
        m_var_map_wstring_inneraliasboundedwstringhelper = _var_map_wstring_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_inneraliasboundedwstringhelper
     * @param _var_map_wstring_inneraliasboundedwstringhelper New value to be moved in member var_map_wstring_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasboundedwstringhelper(
            std::map<std::wstring, Inner_alias_bounded_wstring_helper>&& _var_map_wstring_inneraliasboundedwstringhelper)
    {
        m_var_map_wstring_inneraliasboundedwstringhelper = std::move(_var_map_wstring_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_wstring_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<std::wstring, Inner_alias_bounded_wstring_helper>& var_map_wstring_inneraliasboundedwstringhelper() const
    {
        return m_var_map_wstring_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_inneraliasboundedwstringhelper
     * @return Reference to member var_map_wstring_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<std::wstring, Inner_alias_bounded_wstring_helper>& var_map_wstring_inneraliasboundedwstringhelper()
    {
        return m_var_map_wstring_inneraliasboundedwstringhelper;
    }



private:

    std::map<std::wstring, Inner_alias_bounded_wstring_helper> m_var_map_wstring_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerEnumHelper(
            const MapWStringInnerEnumHelper& x)
    {
                    m_var_map_wstring_innerenumhelper = x.m_var_map_wstring_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerEnumHelper(
            MapWStringInnerEnumHelper&& x) noexcept
    {
        m_var_map_wstring_innerenumhelper = std::move(x.m_var_map_wstring_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerEnumHelper& operator =(
            const MapWStringInnerEnumHelper& x)
    {

                    m_var_map_wstring_innerenumhelper = x.m_var_map_wstring_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerEnumHelper& operator =(
            MapWStringInnerEnumHelper&& x) noexcept
    {

        m_var_map_wstring_innerenumhelper = std::move(x.m_var_map_wstring_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerEnumHelper& x) const
    {
        return (m_var_map_wstring_innerenumhelper == x.m_var_map_wstring_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_innerenumhelper
     * @param _var_map_wstring_innerenumhelper New value to be copied in member var_map_wstring_innerenumhelper
     */
    eProsima_user_DllExport void var_map_wstring_innerenumhelper(
            const std::map<std::wstring, InnerEnumHelper>& _var_map_wstring_innerenumhelper)
    {
        m_var_map_wstring_innerenumhelper = _var_map_wstring_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_innerenumhelper
     * @param _var_map_wstring_innerenumhelper New value to be moved in member var_map_wstring_innerenumhelper
     */
    eProsima_user_DllExport void var_map_wstring_innerenumhelper(
            std::map<std::wstring, InnerEnumHelper>&& _var_map_wstring_innerenumhelper)
    {
        m_var_map_wstring_innerenumhelper = std::move(_var_map_wstring_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_innerenumhelper
     * @return Constant reference to member var_map_wstring_innerenumhelper
     */
    eProsima_user_DllExport const std::map<std::wstring, InnerEnumHelper>& var_map_wstring_innerenumhelper() const
    {
        return m_var_map_wstring_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_innerenumhelper
     * @return Reference to member var_map_wstring_innerenumhelper
     */
    eProsima_user_DllExport std::map<std::wstring, InnerEnumHelper>& var_map_wstring_innerenumhelper()
    {
        return m_var_map_wstring_innerenumhelper;
    }



private:

    std::map<std::wstring, InnerEnumHelper> m_var_map_wstring_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitMaskHelper(
            const MapWStringInnerBitMaskHelper& x)
    {
                    m_var_map_wstring_innerbitmaskhelper = x.m_var_map_wstring_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitMaskHelper(
            MapWStringInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_wstring_innerbitmaskhelper = std::move(x.m_var_map_wstring_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitMaskHelper& operator =(
            const MapWStringInnerBitMaskHelper& x)
    {

                    m_var_map_wstring_innerbitmaskhelper = x.m_var_map_wstring_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitMaskHelper& operator =(
            MapWStringInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_wstring_innerbitmaskhelper = std::move(x.m_var_map_wstring_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerBitMaskHelper& x) const
    {
        return (m_var_map_wstring_innerbitmaskhelper == x.m_var_map_wstring_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_innerbitmaskhelper
     * @param _var_map_wstring_innerbitmaskhelper New value to be copied in member var_map_wstring_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_wstring_innerbitmaskhelper(
            const std::map<std::wstring, InnerBitMaskHelper>& _var_map_wstring_innerbitmaskhelper)
    {
        m_var_map_wstring_innerbitmaskhelper = _var_map_wstring_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_innerbitmaskhelper
     * @param _var_map_wstring_innerbitmaskhelper New value to be moved in member var_map_wstring_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_wstring_innerbitmaskhelper(
            std::map<std::wstring, InnerBitMaskHelper>&& _var_map_wstring_innerbitmaskhelper)
    {
        m_var_map_wstring_innerbitmaskhelper = std::move(_var_map_wstring_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_innerbitmaskhelper
     * @return Constant reference to member var_map_wstring_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<std::wstring, InnerBitMaskHelper>& var_map_wstring_innerbitmaskhelper() const
    {
        return m_var_map_wstring_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_innerbitmaskhelper
     * @return Reference to member var_map_wstring_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<std::wstring, InnerBitMaskHelper>& var_map_wstring_innerbitmaskhelper()
    {
        return m_var_map_wstring_innerbitmaskhelper;
    }



private:

    std::map<std::wstring, InnerBitMaskHelper> m_var_map_wstring_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasHelper(
            const MapWStringInnerAliasHelper& x)
    {
                    m_var_map_wstring_inneraliashelper = x.m_var_map_wstring_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasHelper(
            MapWStringInnerAliasHelper&& x) noexcept
    {
        m_var_map_wstring_inneraliashelper = std::move(x.m_var_map_wstring_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasHelper& operator =(
            const MapWStringInnerAliasHelper& x)
    {

                    m_var_map_wstring_inneraliashelper = x.m_var_map_wstring_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasHelper& operator =(
            MapWStringInnerAliasHelper&& x) noexcept
    {

        m_var_map_wstring_inneraliashelper = std::move(x.m_var_map_wstring_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerAliasHelper& x) const
    {
        return (m_var_map_wstring_inneraliashelper == x.m_var_map_wstring_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_inneraliashelper
     * @param _var_map_wstring_inneraliashelper New value to be copied in member var_map_wstring_inneraliashelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliashelper(
            const std::map<std::wstring, InnerAliasHelper>& _var_map_wstring_inneraliashelper)
    {
        m_var_map_wstring_inneraliashelper = _var_map_wstring_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_inneraliashelper
     * @param _var_map_wstring_inneraliashelper New value to be moved in member var_map_wstring_inneraliashelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliashelper(
            std::map<std::wstring, InnerAliasHelper>&& _var_map_wstring_inneraliashelper)
    {
        m_var_map_wstring_inneraliashelper = std::move(_var_map_wstring_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_inneraliashelper
     * @return Constant reference to member var_map_wstring_inneraliashelper
     */
    eProsima_user_DllExport const std::map<std::wstring, InnerAliasHelper>& var_map_wstring_inneraliashelper() const
    {
        return m_var_map_wstring_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_inneraliashelper
     * @return Reference to member var_map_wstring_inneraliashelper
     */
    eProsima_user_DllExport std::map<std::wstring, InnerAliasHelper>& var_map_wstring_inneraliashelper()
    {
        return m_var_map_wstring_inneraliashelper;
    }



private:

    std::map<std::wstring, InnerAliasHelper> m_var_map_wstring_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasArrayHelper(
            const MapWStringInnerAliasArrayHelper& x)
    {
                    m_var_map_wstring_inneraliasarrayhelper = x.m_var_map_wstring_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasArrayHelper(
            MapWStringInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_wstring_inneraliasarrayhelper = std::move(x.m_var_map_wstring_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasArrayHelper& operator =(
            const MapWStringInnerAliasArrayHelper& x)
    {

                    m_var_map_wstring_inneraliasarrayhelper = x.m_var_map_wstring_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasArrayHelper& operator =(
            MapWStringInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_wstring_inneraliasarrayhelper = std::move(x.m_var_map_wstring_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerAliasArrayHelper& x) const
    {
        return (m_var_map_wstring_inneraliasarrayhelper == x.m_var_map_wstring_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_inneraliasarrayhelper
     * @param _var_map_wstring_inneraliasarrayhelper New value to be copied in member var_map_wstring_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasarrayhelper(
            const std::map<std::wstring, Inner_alias_array_helper>& _var_map_wstring_inneraliasarrayhelper)
    {
        m_var_map_wstring_inneraliasarrayhelper = _var_map_wstring_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_inneraliasarrayhelper
     * @param _var_map_wstring_inneraliasarrayhelper New value to be moved in member var_map_wstring_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasarrayhelper(
            std::map<std::wstring, Inner_alias_array_helper>&& _var_map_wstring_inneraliasarrayhelper)
    {
        m_var_map_wstring_inneraliasarrayhelper = std::move(_var_map_wstring_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_inneraliasarrayhelper
     * @return Constant reference to member var_map_wstring_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<std::wstring, Inner_alias_array_helper>& var_map_wstring_inneraliasarrayhelper() const
    {
        return m_var_map_wstring_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_inneraliasarrayhelper
     * @return Reference to member var_map_wstring_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<std::wstring, Inner_alias_array_helper>& var_map_wstring_inneraliasarrayhelper()
    {
        return m_var_map_wstring_inneraliasarrayhelper;
    }



private:

    std::map<std::wstring, Inner_alias_array_helper> m_var_map_wstring_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasSequenceHelper(
            const MapWStringInnerAliasSequenceHelper& x)
    {
                    m_var_map_wstring_inneraliassequencehelper = x.m_var_map_wstring_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasSequenceHelper(
            MapWStringInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_wstring_inneraliassequencehelper = std::move(x.m_var_map_wstring_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasSequenceHelper& operator =(
            const MapWStringInnerAliasSequenceHelper& x)
    {

                    m_var_map_wstring_inneraliassequencehelper = x.m_var_map_wstring_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasSequenceHelper& operator =(
            MapWStringInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_wstring_inneraliassequencehelper = std::move(x.m_var_map_wstring_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_wstring_inneraliassequencehelper == x.m_var_map_wstring_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_inneraliassequencehelper
     * @param _var_map_wstring_inneraliassequencehelper New value to be copied in member var_map_wstring_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliassequencehelper(
            const std::map<std::wstring, Inner_alias_sequence_helper>& _var_map_wstring_inneraliassequencehelper)
    {
        m_var_map_wstring_inneraliassequencehelper = _var_map_wstring_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_inneraliassequencehelper
     * @param _var_map_wstring_inneraliassequencehelper New value to be moved in member var_map_wstring_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliassequencehelper(
            std::map<std::wstring, Inner_alias_sequence_helper>&& _var_map_wstring_inneraliassequencehelper)
    {
        m_var_map_wstring_inneraliassequencehelper = std::move(_var_map_wstring_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_inneraliassequencehelper
     * @return Constant reference to member var_map_wstring_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<std::wstring, Inner_alias_sequence_helper>& var_map_wstring_inneraliassequencehelper() const
    {
        return m_var_map_wstring_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_inneraliassequencehelper
     * @return Reference to member var_map_wstring_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<std::wstring, Inner_alias_sequence_helper>& var_map_wstring_inneraliassequencehelper()
    {
        return m_var_map_wstring_inneraliassequencehelper;
    }



private:

    std::map<std::wstring, Inner_alias_sequence_helper> m_var_map_wstring_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasMapHelper(
            const MapWStringInnerAliasMapHelper& x)
    {
                    m_var_map_wstring_inneraliasmaphelper = x.m_var_map_wstring_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasMapHelper(
            MapWStringInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_wstring_inneraliasmaphelper = std::move(x.m_var_map_wstring_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasMapHelper& operator =(
            const MapWStringInnerAliasMapHelper& x)
    {

                    m_var_map_wstring_inneraliasmaphelper = x.m_var_map_wstring_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerAliasMapHelper& operator =(
            MapWStringInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_wstring_inneraliasmaphelper = std::move(x.m_var_map_wstring_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerAliasMapHelper& x) const
    {
        return (m_var_map_wstring_inneraliasmaphelper == x.m_var_map_wstring_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_inneraliasmaphelper
     * @param _var_map_wstring_inneraliasmaphelper New value to be copied in member var_map_wstring_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasmaphelper(
            const std::map<std::wstring, Inner_alias_map_helper>& _var_map_wstring_inneraliasmaphelper)
    {
        m_var_map_wstring_inneraliasmaphelper = _var_map_wstring_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_inneraliasmaphelper
     * @param _var_map_wstring_inneraliasmaphelper New value to be moved in member var_map_wstring_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_wstring_inneraliasmaphelper(
            std::map<std::wstring, Inner_alias_map_helper>&& _var_map_wstring_inneraliasmaphelper)
    {
        m_var_map_wstring_inneraliasmaphelper = std::move(_var_map_wstring_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_inneraliasmaphelper
     * @return Constant reference to member var_map_wstring_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<std::wstring, Inner_alias_map_helper>& var_map_wstring_inneraliasmaphelper() const
    {
        return m_var_map_wstring_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_inneraliasmaphelper
     * @return Reference to member var_map_wstring_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<std::wstring, Inner_alias_map_helper>& var_map_wstring_inneraliasmaphelper()
    {
        return m_var_map_wstring_inneraliasmaphelper;
    }



private:

    std::map<std::wstring, Inner_alias_map_helper> m_var_map_wstring_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerUnionHelper(
            const MapWStringInnerUnionHelper& x)
    {
                    m_var_map_wstring_innerunionhelper = x.m_var_map_wstring_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerUnionHelper(
            MapWStringInnerUnionHelper&& x) noexcept
    {
        m_var_map_wstring_innerunionhelper = std::move(x.m_var_map_wstring_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerUnionHelper& operator =(
            const MapWStringInnerUnionHelper& x)
    {

                    m_var_map_wstring_innerunionhelper = x.m_var_map_wstring_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerUnionHelper& operator =(
            MapWStringInnerUnionHelper&& x) noexcept
    {

        m_var_map_wstring_innerunionhelper = std::move(x.m_var_map_wstring_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerUnionHelper& x) const
    {
        return (m_var_map_wstring_innerunionhelper == x.m_var_map_wstring_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_innerunionhelper
     * @param _var_map_wstring_innerunionhelper New value to be copied in member var_map_wstring_innerunionhelper
     */
    eProsima_user_DllExport void var_map_wstring_innerunionhelper(
            const std::map<std::wstring, InnerUnionHelper>& _var_map_wstring_innerunionhelper)
    {
        m_var_map_wstring_innerunionhelper = _var_map_wstring_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_innerunionhelper
     * @param _var_map_wstring_innerunionhelper New value to be moved in member var_map_wstring_innerunionhelper
     */
    eProsima_user_DllExport void var_map_wstring_innerunionhelper(
            std::map<std::wstring, InnerUnionHelper>&& _var_map_wstring_innerunionhelper)
    {
        m_var_map_wstring_innerunionhelper = std::move(_var_map_wstring_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_innerunionhelper
     * @return Constant reference to member var_map_wstring_innerunionhelper
     */
    eProsima_user_DllExport const std::map<std::wstring, InnerUnionHelper>& var_map_wstring_innerunionhelper() const
    {
        return m_var_map_wstring_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_innerunionhelper
     * @return Reference to member var_map_wstring_innerunionhelper
     */
    eProsima_user_DllExport std::map<std::wstring, InnerUnionHelper>& var_map_wstring_innerunionhelper()
    {
        return m_var_map_wstring_innerunionhelper;
    }



private:

    std::map<std::wstring, InnerUnionHelper> m_var_map_wstring_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerStructureHelper(
            const MapWStringInnerStructureHelper& x)
    {
                    m_var_map_wstring_innerstructurehelper = x.m_var_map_wstring_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerStructureHelper(
            MapWStringInnerStructureHelper&& x) noexcept
    {
        m_var_map_wstring_innerstructurehelper = std::move(x.m_var_map_wstring_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerStructureHelper& operator =(
            const MapWStringInnerStructureHelper& x)
    {

                    m_var_map_wstring_innerstructurehelper = x.m_var_map_wstring_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerStructureHelper& operator =(
            MapWStringInnerStructureHelper&& x) noexcept
    {

        m_var_map_wstring_innerstructurehelper = std::move(x.m_var_map_wstring_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerStructureHelper& x) const
    {
        return (m_var_map_wstring_innerstructurehelper == x.m_var_map_wstring_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_innerstructurehelper
     * @param _var_map_wstring_innerstructurehelper New value to be copied in member var_map_wstring_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_wstring_innerstructurehelper(
            const std::map<std::wstring, InnerStructureHelper>& _var_map_wstring_innerstructurehelper)
    {
        m_var_map_wstring_innerstructurehelper = _var_map_wstring_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_innerstructurehelper
     * @param _var_map_wstring_innerstructurehelper New value to be moved in member var_map_wstring_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_wstring_innerstructurehelper(
            std::map<std::wstring, InnerStructureHelper>&& _var_map_wstring_innerstructurehelper)
    {
        m_var_map_wstring_innerstructurehelper = std::move(_var_map_wstring_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_innerstructurehelper
     * @return Constant reference to member var_map_wstring_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<std::wstring, InnerStructureHelper>& var_map_wstring_innerstructurehelper() const
    {
        return m_var_map_wstring_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_innerstructurehelper
     * @return Reference to member var_map_wstring_innerstructurehelper
     */
    eProsima_user_DllExport std::map<std::wstring, InnerStructureHelper>& var_map_wstring_innerstructurehelper()
    {
        return m_var_map_wstring_innerstructurehelper;
    }



private:

    std::map<std::wstring, InnerStructureHelper> m_var_map_wstring_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapWStringInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapWStringInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapWStringInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapWStringInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapWStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitsetHelper(
            const MapWStringInnerBitsetHelper& x)
    {
                    m_var_map_wstring_innerbitsethelper = x.m_var_map_wstring_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapWStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitsetHelper(
            MapWStringInnerBitsetHelper&& x) noexcept
    {
        m_var_map_wstring_innerbitsethelper = std::move(x.m_var_map_wstring_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapWStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitsetHelper& operator =(
            const MapWStringInnerBitsetHelper& x)
    {

                    m_var_map_wstring_innerbitsethelper = x.m_var_map_wstring_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapWStringInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapWStringInnerBitsetHelper& operator =(
            MapWStringInnerBitsetHelper&& x) noexcept
    {

        m_var_map_wstring_innerbitsethelper = std::move(x.m_var_map_wstring_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapWStringInnerBitsetHelper& x) const
    {
        return (m_var_map_wstring_innerbitsethelper == x.m_var_map_wstring_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapWStringInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapWStringInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_wstring_innerbitsethelper
     * @param _var_map_wstring_innerbitsethelper New value to be copied in member var_map_wstring_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_wstring_innerbitsethelper(
            const std::map<std::wstring, InnerBitsetHelper>& _var_map_wstring_innerbitsethelper)
    {
        m_var_map_wstring_innerbitsethelper = _var_map_wstring_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_wstring_innerbitsethelper
     * @param _var_map_wstring_innerbitsethelper New value to be moved in member var_map_wstring_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_wstring_innerbitsethelper(
            std::map<std::wstring, InnerBitsetHelper>&& _var_map_wstring_innerbitsethelper)
    {
        m_var_map_wstring_innerbitsethelper = std::move(_var_map_wstring_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_wstring_innerbitsethelper
     * @return Constant reference to member var_map_wstring_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<std::wstring, InnerBitsetHelper>& var_map_wstring_innerbitsethelper() const
    {
        return m_var_map_wstring_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_wstring_innerbitsethelper
     * @return Reference to member var_map_wstring_innerbitsethelper
     */
    eProsima_user_DllExport std::map<std::wstring, InnerBitsetHelper>& var_map_wstring_innerbitsethelper()
    {
        return m_var_map_wstring_innerbitsethelper;
    }



private:

    std::map<std::wstring, InnerBitsetHelper> m_var_map_wstring_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperShort(
            const MapInnerAliasBoundedStringHelperShort& x)
    {
                    m_var_map_inneraliasboundedstringhelper_short = x.m_var_map_inneraliasboundedstringhelper_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperShort(
            MapInnerAliasBoundedStringHelperShort&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_short = std::move(x.m_var_map_inneraliasboundedstringhelper_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperShort& operator =(
            const MapInnerAliasBoundedStringHelperShort& x)
    {

                    m_var_map_inneraliasboundedstringhelper_short = x.m_var_map_inneraliasboundedstringhelper_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperShort& operator =(
            MapInnerAliasBoundedStringHelperShort&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_short = std::move(x.m_var_map_inneraliasboundedstringhelper_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperShort& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_short == x.m_var_map_inneraliasboundedstringhelper_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_short
     * @param _var_map_inneraliasboundedstringhelper_short New value to be copied in member var_map_inneraliasboundedstringhelper_short
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_short(
            const std::map<Inner_alias_bounded_string_helper, int16_t>& _var_map_inneraliasboundedstringhelper_short)
    {
        m_var_map_inneraliasboundedstringhelper_short = _var_map_inneraliasboundedstringhelper_short;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_short
     * @param _var_map_inneraliasboundedstringhelper_short New value to be moved in member var_map_inneraliasboundedstringhelper_short
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_short(
            std::map<Inner_alias_bounded_string_helper, int16_t>&& _var_map_inneraliasboundedstringhelper_short)
    {
        m_var_map_inneraliasboundedstringhelper_short = std::move(_var_map_inneraliasboundedstringhelper_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_short
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_short
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, int16_t>& var_map_inneraliasboundedstringhelper_short() const
    {
        return m_var_map_inneraliasboundedstringhelper_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_short
     * @return Reference to member var_map_inneraliasboundedstringhelper_short
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, int16_t>& var_map_inneraliasboundedstringhelper_short()
    {
        return m_var_map_inneraliasboundedstringhelper_short;
    }



private:

    std::map<Inner_alias_bounded_string_helper, int16_t> m_var_map_inneraliasboundedstringhelper_short;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperUShort(
            const MapInnerAliasBoundedStringHelperUShort& x)
    {
                    m_var_map_inneraliasboundedstringhelper_ushort = x.m_var_map_inneraliasboundedstringhelper_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperUShort(
            MapInnerAliasBoundedStringHelperUShort&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_ushort = std::move(x.m_var_map_inneraliasboundedstringhelper_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperUShort& operator =(
            const MapInnerAliasBoundedStringHelperUShort& x)
    {

                    m_var_map_inneraliasboundedstringhelper_ushort = x.m_var_map_inneraliasboundedstringhelper_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperUShort& operator =(
            MapInnerAliasBoundedStringHelperUShort&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_ushort = std::move(x.m_var_map_inneraliasboundedstringhelper_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperUShort& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_ushort == x.m_var_map_inneraliasboundedstringhelper_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_ushort
     * @param _var_map_inneraliasboundedstringhelper_ushort New value to be copied in member var_map_inneraliasboundedstringhelper_ushort
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_ushort(
            const std::map<Inner_alias_bounded_string_helper, uint16_t>& _var_map_inneraliasboundedstringhelper_ushort)
    {
        m_var_map_inneraliasboundedstringhelper_ushort = _var_map_inneraliasboundedstringhelper_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_ushort
     * @param _var_map_inneraliasboundedstringhelper_ushort New value to be moved in member var_map_inneraliasboundedstringhelper_ushort
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_ushort(
            std::map<Inner_alias_bounded_string_helper, uint16_t>&& _var_map_inneraliasboundedstringhelper_ushort)
    {
        m_var_map_inneraliasboundedstringhelper_ushort = std::move(_var_map_inneraliasboundedstringhelper_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_ushort
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_ushort
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, uint16_t>& var_map_inneraliasboundedstringhelper_ushort() const
    {
        return m_var_map_inneraliasboundedstringhelper_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_ushort
     * @return Reference to member var_map_inneraliasboundedstringhelper_ushort
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, uint16_t>& var_map_inneraliasboundedstringhelper_ushort()
    {
        return m_var_map_inneraliasboundedstringhelper_ushort;
    }



private:

    std::map<Inner_alias_bounded_string_helper, uint16_t> m_var_map_inneraliasboundedstringhelper_ushort;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLong(
            const MapInnerAliasBoundedStringHelperLong& x)
    {
                    m_var_map_inneraliasboundedstringhelper_long = x.m_var_map_inneraliasboundedstringhelper_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLong(
            MapInnerAliasBoundedStringHelperLong&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_long = std::move(x.m_var_map_inneraliasboundedstringhelper_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLong& operator =(
            const MapInnerAliasBoundedStringHelperLong& x)
    {

                    m_var_map_inneraliasboundedstringhelper_long = x.m_var_map_inneraliasboundedstringhelper_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLong& operator =(
            MapInnerAliasBoundedStringHelperLong&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_long = std::move(x.m_var_map_inneraliasboundedstringhelper_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperLong& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_long == x.m_var_map_inneraliasboundedstringhelper_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_long
     * @param _var_map_inneraliasboundedstringhelper_long New value to be copied in member var_map_inneraliasboundedstringhelper_long
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_long(
            const std::map<Inner_alias_bounded_string_helper, int32_t>& _var_map_inneraliasboundedstringhelper_long)
    {
        m_var_map_inneraliasboundedstringhelper_long = _var_map_inneraliasboundedstringhelper_long;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_long
     * @param _var_map_inneraliasboundedstringhelper_long New value to be moved in member var_map_inneraliasboundedstringhelper_long
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_long(
            std::map<Inner_alias_bounded_string_helper, int32_t>&& _var_map_inneraliasboundedstringhelper_long)
    {
        m_var_map_inneraliasboundedstringhelper_long = std::move(_var_map_inneraliasboundedstringhelper_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_long
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_long
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, int32_t>& var_map_inneraliasboundedstringhelper_long() const
    {
        return m_var_map_inneraliasboundedstringhelper_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_long
     * @return Reference to member var_map_inneraliasboundedstringhelper_long
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, int32_t>& var_map_inneraliasboundedstringhelper_long()
    {
        return m_var_map_inneraliasboundedstringhelper_long;
    }



private:

    std::map<Inner_alias_bounded_string_helper, int32_t> m_var_map_inneraliasboundedstringhelper_long;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULong(
            const MapInnerAliasBoundedStringHelperULong& x)
    {
                    m_var_map_inneraliasboundedstringhelper_ulong = x.m_var_map_inneraliasboundedstringhelper_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULong(
            MapInnerAliasBoundedStringHelperULong&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_ulong = std::move(x.m_var_map_inneraliasboundedstringhelper_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULong& operator =(
            const MapInnerAliasBoundedStringHelperULong& x)
    {

                    m_var_map_inneraliasboundedstringhelper_ulong = x.m_var_map_inneraliasboundedstringhelper_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULong& operator =(
            MapInnerAliasBoundedStringHelperULong&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_ulong = std::move(x.m_var_map_inneraliasboundedstringhelper_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperULong& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_ulong == x.m_var_map_inneraliasboundedstringhelper_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_ulong
     * @param _var_map_inneraliasboundedstringhelper_ulong New value to be copied in member var_map_inneraliasboundedstringhelper_ulong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_ulong(
            const std::map<Inner_alias_bounded_string_helper, uint32_t>& _var_map_inneraliasboundedstringhelper_ulong)
    {
        m_var_map_inneraliasboundedstringhelper_ulong = _var_map_inneraliasboundedstringhelper_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_ulong
     * @param _var_map_inneraliasboundedstringhelper_ulong New value to be moved in member var_map_inneraliasboundedstringhelper_ulong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_ulong(
            std::map<Inner_alias_bounded_string_helper, uint32_t>&& _var_map_inneraliasboundedstringhelper_ulong)
    {
        m_var_map_inneraliasboundedstringhelper_ulong = std::move(_var_map_inneraliasboundedstringhelper_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_ulong
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_ulong
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, uint32_t>& var_map_inneraliasboundedstringhelper_ulong() const
    {
        return m_var_map_inneraliasboundedstringhelper_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_ulong
     * @return Reference to member var_map_inneraliasboundedstringhelper_ulong
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, uint32_t>& var_map_inneraliasboundedstringhelper_ulong()
    {
        return m_var_map_inneraliasboundedstringhelper_ulong;
    }



private:

    std::map<Inner_alias_bounded_string_helper, uint32_t> m_var_map_inneraliasboundedstringhelper_ulong;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongLong(
            const MapInnerAliasBoundedStringHelperLongLong& x)
    {
                    m_var_map_inneraliasboundedstringhelper_longlong = x.m_var_map_inneraliasboundedstringhelper_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongLong(
            MapInnerAliasBoundedStringHelperLongLong&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_longlong = std::move(x.m_var_map_inneraliasboundedstringhelper_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongLong& operator =(
            const MapInnerAliasBoundedStringHelperLongLong& x)
    {

                    m_var_map_inneraliasboundedstringhelper_longlong = x.m_var_map_inneraliasboundedstringhelper_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongLong& operator =(
            MapInnerAliasBoundedStringHelperLongLong&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_longlong = std::move(x.m_var_map_inneraliasboundedstringhelper_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperLongLong& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_longlong == x.m_var_map_inneraliasboundedstringhelper_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_longlong
     * @param _var_map_inneraliasboundedstringhelper_longlong New value to be copied in member var_map_inneraliasboundedstringhelper_longlong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_longlong(
            const std::map<Inner_alias_bounded_string_helper, int64_t>& _var_map_inneraliasboundedstringhelper_longlong)
    {
        m_var_map_inneraliasboundedstringhelper_longlong = _var_map_inneraliasboundedstringhelper_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_longlong
     * @param _var_map_inneraliasboundedstringhelper_longlong New value to be moved in member var_map_inneraliasboundedstringhelper_longlong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_longlong(
            std::map<Inner_alias_bounded_string_helper, int64_t>&& _var_map_inneraliasboundedstringhelper_longlong)
    {
        m_var_map_inneraliasboundedstringhelper_longlong = std::move(_var_map_inneraliasboundedstringhelper_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_longlong
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_longlong
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, int64_t>& var_map_inneraliasboundedstringhelper_longlong() const
    {
        return m_var_map_inneraliasboundedstringhelper_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_longlong
     * @return Reference to member var_map_inneraliasboundedstringhelper_longlong
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, int64_t>& var_map_inneraliasboundedstringhelper_longlong()
    {
        return m_var_map_inneraliasboundedstringhelper_longlong;
    }



private:

    std::map<Inner_alias_bounded_string_helper, int64_t> m_var_map_inneraliasboundedstringhelper_longlong;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULongLong(
            const MapInnerAliasBoundedStringHelperULongLong& x)
    {
                    m_var_map_inneraliasboundedstringhelper_ulonglong = x.m_var_map_inneraliasboundedstringhelper_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULongLong(
            MapInnerAliasBoundedStringHelperULongLong&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_ulonglong = std::move(x.m_var_map_inneraliasboundedstringhelper_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULongLong& operator =(
            const MapInnerAliasBoundedStringHelperULongLong& x)
    {

                    m_var_map_inneraliasboundedstringhelper_ulonglong = x.m_var_map_inneraliasboundedstringhelper_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperULongLong& operator =(
            MapInnerAliasBoundedStringHelperULongLong&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_ulonglong = std::move(x.m_var_map_inneraliasboundedstringhelper_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperULongLong& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_ulonglong == x.m_var_map_inneraliasboundedstringhelper_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_ulonglong
     * @param _var_map_inneraliasboundedstringhelper_ulonglong New value to be copied in member var_map_inneraliasboundedstringhelper_ulonglong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_ulonglong(
            const std::map<Inner_alias_bounded_string_helper, uint64_t>& _var_map_inneraliasboundedstringhelper_ulonglong)
    {
        m_var_map_inneraliasboundedstringhelper_ulonglong = _var_map_inneraliasboundedstringhelper_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_ulonglong
     * @param _var_map_inneraliasboundedstringhelper_ulonglong New value to be moved in member var_map_inneraliasboundedstringhelper_ulonglong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_ulonglong(
            std::map<Inner_alias_bounded_string_helper, uint64_t>&& _var_map_inneraliasboundedstringhelper_ulonglong)
    {
        m_var_map_inneraliasboundedstringhelper_ulonglong = std::move(_var_map_inneraliasboundedstringhelper_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_ulonglong
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_ulonglong
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, uint64_t>& var_map_inneraliasboundedstringhelper_ulonglong() const
    {
        return m_var_map_inneraliasboundedstringhelper_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_ulonglong
     * @return Reference to member var_map_inneraliasboundedstringhelper_ulonglong
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, uint64_t>& var_map_inneraliasboundedstringhelper_ulonglong()
    {
        return m_var_map_inneraliasboundedstringhelper_ulonglong;
    }



private:

    std::map<Inner_alias_bounded_string_helper, uint64_t> m_var_map_inneraliasboundedstringhelper_ulonglong;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperFloat(
            const MapInnerAliasBoundedStringHelperFloat& x)
    {
                    m_var_map_inneraliasboundedstringhelper_float = x.m_var_map_inneraliasboundedstringhelper_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperFloat(
            MapInnerAliasBoundedStringHelperFloat&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_float = std::move(x.m_var_map_inneraliasboundedstringhelper_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperFloat& operator =(
            const MapInnerAliasBoundedStringHelperFloat& x)
    {

                    m_var_map_inneraliasboundedstringhelper_float = x.m_var_map_inneraliasboundedstringhelper_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperFloat& operator =(
            MapInnerAliasBoundedStringHelperFloat&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_float = std::move(x.m_var_map_inneraliasboundedstringhelper_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperFloat& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_float == x.m_var_map_inneraliasboundedstringhelper_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_float
     * @param _var_map_inneraliasboundedstringhelper_float New value to be copied in member var_map_inneraliasboundedstringhelper_float
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_float(
            const std::map<Inner_alias_bounded_string_helper, float>& _var_map_inneraliasboundedstringhelper_float)
    {
        m_var_map_inneraliasboundedstringhelper_float = _var_map_inneraliasboundedstringhelper_float;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_float
     * @param _var_map_inneraliasboundedstringhelper_float New value to be moved in member var_map_inneraliasboundedstringhelper_float
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_float(
            std::map<Inner_alias_bounded_string_helper, float>&& _var_map_inneraliasboundedstringhelper_float)
    {
        m_var_map_inneraliasboundedstringhelper_float = std::move(_var_map_inneraliasboundedstringhelper_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_float
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_float
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, float>& var_map_inneraliasboundedstringhelper_float() const
    {
        return m_var_map_inneraliasboundedstringhelper_float;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_float
     * @return Reference to member var_map_inneraliasboundedstringhelper_float
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, float>& var_map_inneraliasboundedstringhelper_float()
    {
        return m_var_map_inneraliasboundedstringhelper_float;
    }



private:

    std::map<Inner_alias_bounded_string_helper, float> m_var_map_inneraliasboundedstringhelper_float;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperDouble(
            const MapInnerAliasBoundedStringHelperDouble& x)
    {
                    m_var_map_inneraliasboundedstringhelper_double = x.m_var_map_inneraliasboundedstringhelper_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperDouble(
            MapInnerAliasBoundedStringHelperDouble&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_double = std::move(x.m_var_map_inneraliasboundedstringhelper_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperDouble& operator =(
            const MapInnerAliasBoundedStringHelperDouble& x)
    {

                    m_var_map_inneraliasboundedstringhelper_double = x.m_var_map_inneraliasboundedstringhelper_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperDouble& operator =(
            MapInnerAliasBoundedStringHelperDouble&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_double = std::move(x.m_var_map_inneraliasboundedstringhelper_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperDouble& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_double == x.m_var_map_inneraliasboundedstringhelper_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_double
     * @param _var_map_inneraliasboundedstringhelper_double New value to be copied in member var_map_inneraliasboundedstringhelper_double
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_double(
            const std::map<Inner_alias_bounded_string_helper, double>& _var_map_inneraliasboundedstringhelper_double)
    {
        m_var_map_inneraliasboundedstringhelper_double = _var_map_inneraliasboundedstringhelper_double;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_double
     * @param _var_map_inneraliasboundedstringhelper_double New value to be moved in member var_map_inneraliasboundedstringhelper_double
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_double(
            std::map<Inner_alias_bounded_string_helper, double>&& _var_map_inneraliasboundedstringhelper_double)
    {
        m_var_map_inneraliasboundedstringhelper_double = std::move(_var_map_inneraliasboundedstringhelper_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_double
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_double
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, double>& var_map_inneraliasboundedstringhelper_double() const
    {
        return m_var_map_inneraliasboundedstringhelper_double;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_double
     * @return Reference to member var_map_inneraliasboundedstringhelper_double
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, double>& var_map_inneraliasboundedstringhelper_double()
    {
        return m_var_map_inneraliasboundedstringhelper_double;
    }



private:

    std::map<Inner_alias_bounded_string_helper, double> m_var_map_inneraliasboundedstringhelper_double;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperLongDouble defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongDouble(
            const MapInnerAliasBoundedStringHelperLongDouble& x)
    {
                    m_var_map_inneraliasboundedstringhelper_longdouble = x.m_var_map_inneraliasboundedstringhelper_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongDouble(
            MapInnerAliasBoundedStringHelperLongDouble&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_longdouble = std::move(x.m_var_map_inneraliasboundedstringhelper_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongDouble& operator =(
            const MapInnerAliasBoundedStringHelperLongDouble& x)
    {

                    m_var_map_inneraliasboundedstringhelper_longdouble = x.m_var_map_inneraliasboundedstringhelper_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperLongDouble that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperLongDouble& operator =(
            MapInnerAliasBoundedStringHelperLongDouble&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_longdouble = std::move(x.m_var_map_inneraliasboundedstringhelper_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperLongDouble& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_longdouble == x.m_var_map_inneraliasboundedstringhelper_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_longdouble
     * @param _var_map_inneraliasboundedstringhelper_longdouble New value to be copied in member var_map_inneraliasboundedstringhelper_longdouble
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_longdouble(
            const std::map<Inner_alias_bounded_string_helper, long double>& _var_map_inneraliasboundedstringhelper_longdouble)
    {
        m_var_map_inneraliasboundedstringhelper_longdouble = _var_map_inneraliasboundedstringhelper_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_longdouble
     * @param _var_map_inneraliasboundedstringhelper_longdouble New value to be moved in member var_map_inneraliasboundedstringhelper_longdouble
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_longdouble(
            std::map<Inner_alias_bounded_string_helper, long double>&& _var_map_inneraliasboundedstringhelper_longdouble)
    {
        m_var_map_inneraliasboundedstringhelper_longdouble = std::move(_var_map_inneraliasboundedstringhelper_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_longdouble
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_longdouble
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, long double>& var_map_inneraliasboundedstringhelper_longdouble() const
    {
        return m_var_map_inneraliasboundedstringhelper_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_longdouble
     * @return Reference to member var_map_inneraliasboundedstringhelper_longdouble
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, long double>& var_map_inneraliasboundedstringhelper_longdouble()
    {
        return m_var_map_inneraliasboundedstringhelper_longdouble;
    }



private:

    std::map<Inner_alias_bounded_string_helper, long double> m_var_map_inneraliasboundedstringhelper_longdouble;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperBoolean defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperBoolean that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperBoolean(
            const MapInnerAliasBoundedStringHelperBoolean& x)
    {
                    m_var_map_inneraliasboundedstringhelper_boolean = x.m_var_map_inneraliasboundedstringhelper_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperBoolean that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperBoolean(
            MapInnerAliasBoundedStringHelperBoolean&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_boolean = std::move(x.m_var_map_inneraliasboundedstringhelper_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperBoolean that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperBoolean& operator =(
            const MapInnerAliasBoundedStringHelperBoolean& x)
    {

                    m_var_map_inneraliasboundedstringhelper_boolean = x.m_var_map_inneraliasboundedstringhelper_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperBoolean that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperBoolean& operator =(
            MapInnerAliasBoundedStringHelperBoolean&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_boolean = std::move(x.m_var_map_inneraliasboundedstringhelper_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperBoolean& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_boolean == x.m_var_map_inneraliasboundedstringhelper_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_boolean
     * @param _var_map_inneraliasboundedstringhelper_boolean New value to be copied in member var_map_inneraliasboundedstringhelper_boolean
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_boolean(
            const std::map<Inner_alias_bounded_string_helper, bool>& _var_map_inneraliasboundedstringhelper_boolean)
    {
        m_var_map_inneraliasboundedstringhelper_boolean = _var_map_inneraliasboundedstringhelper_boolean;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_boolean
     * @param _var_map_inneraliasboundedstringhelper_boolean New value to be moved in member var_map_inneraliasboundedstringhelper_boolean
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_boolean(
            std::map<Inner_alias_bounded_string_helper, bool>&& _var_map_inneraliasboundedstringhelper_boolean)
    {
        m_var_map_inneraliasboundedstringhelper_boolean = std::move(_var_map_inneraliasboundedstringhelper_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_boolean
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_boolean
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, bool>& var_map_inneraliasboundedstringhelper_boolean() const
    {
        return m_var_map_inneraliasboundedstringhelper_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_boolean
     * @return Reference to member var_map_inneraliasboundedstringhelper_boolean
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, bool>& var_map_inneraliasboundedstringhelper_boolean()
    {
        return m_var_map_inneraliasboundedstringhelper_boolean;
    }



private:

    std::map<Inner_alias_bounded_string_helper, bool> m_var_map_inneraliasboundedstringhelper_boolean;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperOctet defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperOctet that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperOctet(
            const MapInnerAliasBoundedStringHelperOctet& x)
    {
                    m_var_map_inneraliasboundedstringhelper_octet = x.m_var_map_inneraliasboundedstringhelper_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperOctet that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperOctet(
            MapInnerAliasBoundedStringHelperOctet&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_octet = std::move(x.m_var_map_inneraliasboundedstringhelper_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperOctet that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperOctet& operator =(
            const MapInnerAliasBoundedStringHelperOctet& x)
    {

                    m_var_map_inneraliasboundedstringhelper_octet = x.m_var_map_inneraliasboundedstringhelper_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperOctet that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperOctet& operator =(
            MapInnerAliasBoundedStringHelperOctet&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_octet = std::move(x.m_var_map_inneraliasboundedstringhelper_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperOctet& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_octet == x.m_var_map_inneraliasboundedstringhelper_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_octet
     * @param _var_map_inneraliasboundedstringhelper_octet New value to be copied in member var_map_inneraliasboundedstringhelper_octet
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_octet(
            const std::map<Inner_alias_bounded_string_helper, uint8_t>& _var_map_inneraliasboundedstringhelper_octet)
    {
        m_var_map_inneraliasboundedstringhelper_octet = _var_map_inneraliasboundedstringhelper_octet;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_octet
     * @param _var_map_inneraliasboundedstringhelper_octet New value to be moved in member var_map_inneraliasboundedstringhelper_octet
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_octet(
            std::map<Inner_alias_bounded_string_helper, uint8_t>&& _var_map_inneraliasboundedstringhelper_octet)
    {
        m_var_map_inneraliasboundedstringhelper_octet = std::move(_var_map_inneraliasboundedstringhelper_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_octet
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_octet
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, uint8_t>& var_map_inneraliasboundedstringhelper_octet() const
    {
        return m_var_map_inneraliasboundedstringhelper_octet;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_octet
     * @return Reference to member var_map_inneraliasboundedstringhelper_octet
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, uint8_t>& var_map_inneraliasboundedstringhelper_octet()
    {
        return m_var_map_inneraliasboundedstringhelper_octet;
    }



private:

    std::map<Inner_alias_bounded_string_helper, uint8_t> m_var_map_inneraliasboundedstringhelper_octet;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperChar(
            const MapInnerAliasBoundedStringHelperChar& x)
    {
                    m_var_map_inneraliasboundedstringhelper_char = x.m_var_map_inneraliasboundedstringhelper_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperChar(
            MapInnerAliasBoundedStringHelperChar&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_char = std::move(x.m_var_map_inneraliasboundedstringhelper_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperChar& operator =(
            const MapInnerAliasBoundedStringHelperChar& x)
    {

                    m_var_map_inneraliasboundedstringhelper_char = x.m_var_map_inneraliasboundedstringhelper_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperChar& operator =(
            MapInnerAliasBoundedStringHelperChar&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_char = std::move(x.m_var_map_inneraliasboundedstringhelper_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperChar& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_char == x.m_var_map_inneraliasboundedstringhelper_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_char
     * @param _var_map_inneraliasboundedstringhelper_char New value to be copied in member var_map_inneraliasboundedstringhelper_char
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_char(
            const std::map<Inner_alias_bounded_string_helper, char>& _var_map_inneraliasboundedstringhelper_char)
    {
        m_var_map_inneraliasboundedstringhelper_char = _var_map_inneraliasboundedstringhelper_char;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_char
     * @param _var_map_inneraliasboundedstringhelper_char New value to be moved in member var_map_inneraliasboundedstringhelper_char
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_char(
            std::map<Inner_alias_bounded_string_helper, char>&& _var_map_inneraliasboundedstringhelper_char)
    {
        m_var_map_inneraliasboundedstringhelper_char = std::move(_var_map_inneraliasboundedstringhelper_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_char
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_char
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, char>& var_map_inneraliasboundedstringhelper_char() const
    {
        return m_var_map_inneraliasboundedstringhelper_char;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_char
     * @return Reference to member var_map_inneraliasboundedstringhelper_char
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, char>& var_map_inneraliasboundedstringhelper_char()
    {
        return m_var_map_inneraliasboundedstringhelper_char;
    }



private:

    std::map<Inner_alias_bounded_string_helper, char> m_var_map_inneraliasboundedstringhelper_char;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperWChar defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWChar(
            const MapInnerAliasBoundedStringHelperWChar& x)
    {
                    m_var_map_inneraliasboundedstringhelper_wchar = x.m_var_map_inneraliasboundedstringhelper_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWChar(
            MapInnerAliasBoundedStringHelperWChar&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_wchar = std::move(x.m_var_map_inneraliasboundedstringhelper_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWChar& operator =(
            const MapInnerAliasBoundedStringHelperWChar& x)
    {

                    m_var_map_inneraliasboundedstringhelper_wchar = x.m_var_map_inneraliasboundedstringhelper_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWChar that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWChar& operator =(
            MapInnerAliasBoundedStringHelperWChar&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_wchar = std::move(x.m_var_map_inneraliasboundedstringhelper_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperWChar& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_wchar == x.m_var_map_inneraliasboundedstringhelper_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_wchar
     * @param _var_map_inneraliasboundedstringhelper_wchar New value to be copied in member var_map_inneraliasboundedstringhelper_wchar
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_wchar(
            const std::map<Inner_alias_bounded_string_helper, wchar_t>& _var_map_inneraliasboundedstringhelper_wchar)
    {
        m_var_map_inneraliasboundedstringhelper_wchar = _var_map_inneraliasboundedstringhelper_wchar;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_wchar
     * @param _var_map_inneraliasboundedstringhelper_wchar New value to be moved in member var_map_inneraliasboundedstringhelper_wchar
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_wchar(
            std::map<Inner_alias_bounded_string_helper, wchar_t>&& _var_map_inneraliasboundedstringhelper_wchar)
    {
        m_var_map_inneraliasboundedstringhelper_wchar = std::move(_var_map_inneraliasboundedstringhelper_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_wchar
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_wchar
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, wchar_t>& var_map_inneraliasboundedstringhelper_wchar() const
    {
        return m_var_map_inneraliasboundedstringhelper_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_wchar
     * @return Reference to member var_map_inneraliasboundedstringhelper_wchar
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, wchar_t>& var_map_inneraliasboundedstringhelper_wchar()
    {
        return m_var_map_inneraliasboundedstringhelper_wchar;
    }



private:

    std::map<Inner_alias_bounded_string_helper, wchar_t> m_var_map_inneraliasboundedstringhelper_wchar;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperString(
            const MapInnerAliasBoundedStringHelperString& x)
    {
                    m_var_map_inneraliasboundedstringhelper_string = x.m_var_map_inneraliasboundedstringhelper_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperString(
            MapInnerAliasBoundedStringHelperString&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_string = std::move(x.m_var_map_inneraliasboundedstringhelper_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperString& operator =(
            const MapInnerAliasBoundedStringHelperString& x)
    {

                    m_var_map_inneraliasboundedstringhelper_string = x.m_var_map_inneraliasboundedstringhelper_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperString& operator =(
            MapInnerAliasBoundedStringHelperString&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_string = std::move(x.m_var_map_inneraliasboundedstringhelper_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperString& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_string == x.m_var_map_inneraliasboundedstringhelper_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_string
     * @param _var_map_inneraliasboundedstringhelper_string New value to be copied in member var_map_inneraliasboundedstringhelper_string
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_string(
            const std::map<Inner_alias_bounded_string_helper, std::string>& _var_map_inneraliasboundedstringhelper_string)
    {
        m_var_map_inneraliasboundedstringhelper_string = _var_map_inneraliasboundedstringhelper_string;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_string
     * @param _var_map_inneraliasboundedstringhelper_string New value to be moved in member var_map_inneraliasboundedstringhelper_string
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_string(
            std::map<Inner_alias_bounded_string_helper, std::string>&& _var_map_inneraliasboundedstringhelper_string)
    {
        m_var_map_inneraliasboundedstringhelper_string = std::move(_var_map_inneraliasboundedstringhelper_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_string
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_string
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, std::string>& var_map_inneraliasboundedstringhelper_string() const
    {
        return m_var_map_inneraliasboundedstringhelper_string;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_string
     * @return Reference to member var_map_inneraliasboundedstringhelper_string
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, std::string>& var_map_inneraliasboundedstringhelper_string()
    {
        return m_var_map_inneraliasboundedstringhelper_string;
    }



private:

    std::map<Inner_alias_bounded_string_helper, std::string> m_var_map_inneraliasboundedstringhelper_string;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperWString defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWString(
            const MapInnerAliasBoundedStringHelperWString& x)
    {
                    m_var_map_inneraliasboundedstringhelper_wstring = x.m_var_map_inneraliasboundedstringhelper_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWString(
            MapInnerAliasBoundedStringHelperWString&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_wstring = std::move(x.m_var_map_inneraliasboundedstringhelper_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWString& operator =(
            const MapInnerAliasBoundedStringHelperWString& x)
    {

                    m_var_map_inneraliasboundedstringhelper_wstring = x.m_var_map_inneraliasboundedstringhelper_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperWString that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperWString& operator =(
            MapInnerAliasBoundedStringHelperWString&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_wstring = std::move(x.m_var_map_inneraliasboundedstringhelper_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperWString& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_wstring == x.m_var_map_inneraliasboundedstringhelper_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_wstring
     * @param _var_map_inneraliasboundedstringhelper_wstring New value to be copied in member var_map_inneraliasboundedstringhelper_wstring
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_wstring(
            const std::map<Inner_alias_bounded_string_helper, std::wstring>& _var_map_inneraliasboundedstringhelper_wstring)
    {
        m_var_map_inneraliasboundedstringhelper_wstring = _var_map_inneraliasboundedstringhelper_wstring;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_wstring
     * @param _var_map_inneraliasboundedstringhelper_wstring New value to be moved in member var_map_inneraliasboundedstringhelper_wstring
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_wstring(
            std::map<Inner_alias_bounded_string_helper, std::wstring>&& _var_map_inneraliasboundedstringhelper_wstring)
    {
        m_var_map_inneraliasboundedstringhelper_wstring = std::move(_var_map_inneraliasboundedstringhelper_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_wstring
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_wstring
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, std::wstring>& var_map_inneraliasboundedstringhelper_wstring() const
    {
        return m_var_map_inneraliasboundedstringhelper_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_wstring
     * @return Reference to member var_map_inneraliasboundedstringhelper_wstring
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, std::wstring>& var_map_inneraliasboundedstringhelper_wstring()
    {
        return m_var_map_inneraliasboundedstringhelper_wstring;
    }



private:

    std::map<Inner_alias_bounded_string_helper, std::wstring> m_var_map_inneraliasboundedstringhelper_wstring;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper(
            MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper == x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper New value to be copied in member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper(
            const std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_string_helper>& _var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper = _var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper New value to be moved in member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper(
            std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_string_helper>&& _var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper = std::move(_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_string_helper>& var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_string_helper>& var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper()
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_string_helper> m_var_map_inneraliasboundedstringhelper_inneraliasboundedstringhelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper(
            MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper == x.m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerAliasBoundedWStringHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper New value to be copied in member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper(
            const std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_wstring_helper>& _var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper = _var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper New value to be moved in member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper(
            std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_wstring_helper>&& _var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper = std::move(_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_wstring_helper>& var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_wstring_helper>& var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper()
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, Inner_alias_bounded_wstring_helper> m_var_map_inneraliasboundedstringhelper_inneraliasboundedwstringhelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerEnumHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerEnumHelper(
            const MapInnerAliasBoundedStringHelperInnerEnumHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_innerenumhelper = x.m_var_map_inneraliasboundedstringhelper_innerenumhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerEnumHelper(
            MapInnerAliasBoundedStringHelperInnerEnumHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_innerenumhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerenumhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerEnumHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerEnumHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_innerenumhelper = x.m_var_map_inneraliasboundedstringhelper_innerenumhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerEnumHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerEnumHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_innerenumhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerenumhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerEnumHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_innerenumhelper == x.m_var_map_inneraliasboundedstringhelper_innerenumhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_innerenumhelper
     * @param _var_map_inneraliasboundedstringhelper_innerenumhelper New value to be copied in member var_map_inneraliasboundedstringhelper_innerenumhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerenumhelper(
            const std::map<Inner_alias_bounded_string_helper, InnerEnumHelper>& _var_map_inneraliasboundedstringhelper_innerenumhelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerenumhelper = _var_map_inneraliasboundedstringhelper_innerenumhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_innerenumhelper
     * @param _var_map_inneraliasboundedstringhelper_innerenumhelper New value to be moved in member var_map_inneraliasboundedstringhelper_innerenumhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerenumhelper(
            std::map<Inner_alias_bounded_string_helper, InnerEnumHelper>&& _var_map_inneraliasboundedstringhelper_innerenumhelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerenumhelper = std::move(_var_map_inneraliasboundedstringhelper_innerenumhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_innerenumhelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_innerenumhelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, InnerEnumHelper>& var_map_inneraliasboundedstringhelper_innerenumhelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_innerenumhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_innerenumhelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_innerenumhelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, InnerEnumHelper>& var_map_inneraliasboundedstringhelper_innerenumhelper()
    {
        return m_var_map_inneraliasboundedstringhelper_innerenumhelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, InnerEnumHelper> m_var_map_inneraliasboundedstringhelper_innerenumhelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitMaskHelper(
            const MapInnerAliasBoundedStringHelperInnerBitMaskHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper = x.m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitMaskHelper(
            MapInnerAliasBoundedStringHelperInnerBitMaskHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitMaskHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerBitMaskHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper = x.m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitMaskHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerBitMaskHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerBitMaskHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper == x.m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     * @param _var_map_inneraliasboundedstringhelper_innerbitmaskhelper New value to be copied in member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerbitmaskhelper(
            const std::map<Inner_alias_bounded_string_helper, InnerBitMaskHelper>& _var_map_inneraliasboundedstringhelper_innerbitmaskhelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper = _var_map_inneraliasboundedstringhelper_innerbitmaskhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     * @param _var_map_inneraliasboundedstringhelper_innerbitmaskhelper New value to be moved in member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerbitmaskhelper(
            std::map<Inner_alias_bounded_string_helper, InnerBitMaskHelper>&& _var_map_inneraliasboundedstringhelper_innerbitmaskhelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper = std::move(_var_map_inneraliasboundedstringhelper_innerbitmaskhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, InnerBitMaskHelper>& var_map_inneraliasboundedstringhelper_innerbitmaskhelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_innerbitmaskhelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, InnerBitMaskHelper>& var_map_inneraliasboundedstringhelper_innerbitmaskhelper()
    {
        return m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, InnerBitMaskHelper> m_var_map_inneraliasboundedstringhelper_innerbitmaskhelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerAliasHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasHelper(
            const MapInnerAliasBoundedStringHelperInnerAliasHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_inneraliashelper = x.m_var_map_inneraliasboundedstringhelper_inneraliashelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasHelper(
            MapInnerAliasBoundedStringHelperInnerAliasHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_inneraliashelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliashelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerAliasHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_inneraliashelper = x.m_var_map_inneraliasboundedstringhelper_inneraliashelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerAliasHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_inneraliashelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliashelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerAliasHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_inneraliashelper == x.m_var_map_inneraliasboundedstringhelper_inneraliashelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_inneraliashelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliashelper New value to be copied in member var_map_inneraliasboundedstringhelper_inneraliashelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliashelper(
            const std::map<Inner_alias_bounded_string_helper, InnerAliasHelper>& _var_map_inneraliasboundedstringhelper_inneraliashelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliashelper = _var_map_inneraliasboundedstringhelper_inneraliashelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_inneraliashelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliashelper New value to be moved in member var_map_inneraliasboundedstringhelper_inneraliashelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliashelper(
            std::map<Inner_alias_bounded_string_helper, InnerAliasHelper>&& _var_map_inneraliasboundedstringhelper_inneraliashelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliashelper = std::move(_var_map_inneraliasboundedstringhelper_inneraliashelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_inneraliashelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_inneraliashelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, InnerAliasHelper>& var_map_inneraliasboundedstringhelper_inneraliashelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliashelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_inneraliashelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_inneraliashelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, InnerAliasHelper>& var_map_inneraliasboundedstringhelper_inneraliashelper()
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliashelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, InnerAliasHelper> m_var_map_inneraliasboundedstringhelper_inneraliashelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerAliasArrayHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerAliasArrayHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerAliasArrayHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasArrayHelper(
            const MapInnerAliasBoundedStringHelperInnerAliasArrayHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasArrayHelper(
            MapInnerAliasBoundedStringHelperInnerAliasArrayHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasArrayHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerAliasArrayHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasArrayHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasArrayHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerAliasArrayHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerAliasArrayHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper == x.m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasArrayHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerAliasArrayHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasarrayhelper New value to be copied in member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasarrayhelper(
            const std::map<Inner_alias_bounded_string_helper, Inner_alias_array_helper>& _var_map_inneraliasboundedstringhelper_inneraliasarrayhelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper = _var_map_inneraliasboundedstringhelper_inneraliasarrayhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasarrayhelper New value to be moved in member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasarrayhelper(
            std::map<Inner_alias_bounded_string_helper, Inner_alias_array_helper>&& _var_map_inneraliasboundedstringhelper_inneraliasarrayhelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper = std::move(_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, Inner_alias_array_helper>& var_map_inneraliasboundedstringhelper_inneraliasarrayhelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_inneraliasarrayhelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, Inner_alias_array_helper>& var_map_inneraliasboundedstringhelper_inneraliasarrayhelper()
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, Inner_alias_array_helper> m_var_map_inneraliasboundedstringhelper_inneraliasarrayhelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper(
            const MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper = x.m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper(
            MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper = x.m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper == x.m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerAliasSequenceHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliassequencehelper New value to be copied in member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliassequencehelper(
            const std::map<Inner_alias_bounded_string_helper, Inner_alias_sequence_helper>& _var_map_inneraliasboundedstringhelper_inneraliassequencehelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper = _var_map_inneraliasboundedstringhelper_inneraliassequencehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliassequencehelper New value to be moved in member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliassequencehelper(
            std::map<Inner_alias_bounded_string_helper, Inner_alias_sequence_helper>&& _var_map_inneraliasboundedstringhelper_inneraliassequencehelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper = std::move(_var_map_inneraliasboundedstringhelper_inneraliassequencehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, Inner_alias_sequence_helper>& var_map_inneraliasboundedstringhelper_inneraliassequencehelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_inneraliassequencehelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, Inner_alias_sequence_helper>& var_map_inneraliasboundedstringhelper_inneraliassequencehelper()
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, Inner_alias_sequence_helper> m_var_map_inneraliasboundedstringhelper_inneraliassequencehelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerAliasMapHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerAliasMapHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerAliasMapHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasMapHelper(
            const MapInnerAliasBoundedStringHelperInnerAliasMapHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasMapHelper(
            MapInnerAliasBoundedStringHelperInnerAliasMapHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasMapHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerAliasMapHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper = x.m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerAliasMapHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerAliasMapHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerAliasMapHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper = std::move(x.m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerAliasMapHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper == x.m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerAliasMapHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerAliasMapHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasmaphelper New value to be copied in member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasmaphelper(
            const std::map<Inner_alias_bounded_string_helper, Inner_alias_map_helper>& _var_map_inneraliasboundedstringhelper_inneraliasmaphelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper = _var_map_inneraliasboundedstringhelper_inneraliasmaphelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     * @param _var_map_inneraliasboundedstringhelper_inneraliasmaphelper New value to be moved in member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_inneraliasmaphelper(
            std::map<Inner_alias_bounded_string_helper, Inner_alias_map_helper>&& _var_map_inneraliasboundedstringhelper_inneraliasmaphelper)
    {
        m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper = std::move(_var_map_inneraliasboundedstringhelper_inneraliasmaphelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, Inner_alias_map_helper>& var_map_inneraliasboundedstringhelper_inneraliasmaphelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_inneraliasmaphelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, Inner_alias_map_helper>& var_map_inneraliasboundedstringhelper_inneraliasmaphelper()
    {
        return m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, Inner_alias_map_helper> m_var_map_inneraliasboundedstringhelper_inneraliasmaphelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerUnionHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerUnionHelper(
            const MapInnerAliasBoundedStringHelperInnerUnionHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_innerunionhelper = x.m_var_map_inneraliasboundedstringhelper_innerunionhelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerUnionHelper(
            MapInnerAliasBoundedStringHelperInnerUnionHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_innerunionhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerunionhelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerUnionHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerUnionHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_innerunionhelper = x.m_var_map_inneraliasboundedstringhelper_innerunionhelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerUnionHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerUnionHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_innerunionhelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerunionhelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerUnionHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_innerunionhelper == x.m_var_map_inneraliasboundedstringhelper_innerunionhelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_innerunionhelper
     * @param _var_map_inneraliasboundedstringhelper_innerunionhelper New value to be copied in member var_map_inneraliasboundedstringhelper_innerunionhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerunionhelper(
            const std::map<Inner_alias_bounded_string_helper, InnerUnionHelper>& _var_map_inneraliasboundedstringhelper_innerunionhelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerunionhelper = _var_map_inneraliasboundedstringhelper_innerunionhelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_innerunionhelper
     * @param _var_map_inneraliasboundedstringhelper_innerunionhelper New value to be moved in member var_map_inneraliasboundedstringhelper_innerunionhelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerunionhelper(
            std::map<Inner_alias_bounded_string_helper, InnerUnionHelper>&& _var_map_inneraliasboundedstringhelper_innerunionhelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerunionhelper = std::move(_var_map_inneraliasboundedstringhelper_innerunionhelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_innerunionhelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_innerunionhelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, InnerUnionHelper>& var_map_inneraliasboundedstringhelper_innerunionhelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_innerunionhelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_innerunionhelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_innerunionhelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, InnerUnionHelper>& var_map_inneraliasboundedstringhelper_innerunionhelper()
    {
        return m_var_map_inneraliasboundedstringhelper_innerunionhelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, InnerUnionHelper> m_var_map_inneraliasboundedstringhelper_innerunionhelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerStructureHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerStructureHelper(
            const MapInnerAliasBoundedStringHelperInnerStructureHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_innerstructurehelper = x.m_var_map_inneraliasboundedstringhelper_innerstructurehelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerStructureHelper(
            MapInnerAliasBoundedStringHelperInnerStructureHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_innerstructurehelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerstructurehelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerStructureHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerStructureHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_innerstructurehelper = x.m_var_map_inneraliasboundedstringhelper_innerstructurehelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerStructureHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerStructureHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_innerstructurehelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerstructurehelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerStructureHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_innerstructurehelper == x.m_var_map_inneraliasboundedstringhelper_innerstructurehelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_innerstructurehelper
     * @param _var_map_inneraliasboundedstringhelper_innerstructurehelper New value to be copied in member var_map_inneraliasboundedstringhelper_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerstructurehelper(
            const std::map<Inner_alias_bounded_string_helper, InnerStructureHelper>& _var_map_inneraliasboundedstringhelper_innerstructurehelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerstructurehelper = _var_map_inneraliasboundedstringhelper_innerstructurehelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_innerstructurehelper
     * @param _var_map_inneraliasboundedstringhelper_innerstructurehelper New value to be moved in member var_map_inneraliasboundedstringhelper_innerstructurehelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerstructurehelper(
            std::map<Inner_alias_bounded_string_helper, InnerStructureHelper>&& _var_map_inneraliasboundedstringhelper_innerstructurehelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerstructurehelper = std::move(_var_map_inneraliasboundedstringhelper_innerstructurehelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_innerstructurehelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_innerstructurehelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, InnerStructureHelper>& var_map_inneraliasboundedstringhelper_innerstructurehelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_innerstructurehelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_innerstructurehelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_innerstructurehelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, InnerStructureHelper>& var_map_inneraliasboundedstringhelper_innerstructurehelper()
    {
        return m_var_map_inneraliasboundedstringhelper_innerstructurehelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, InnerStructureHelper> m_var_map_inneraliasboundedstringhelper_innerstructurehelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedStringHelperInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedStringHelperInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedStringHelperInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitsetHelper(
            const MapInnerAliasBoundedStringHelperInnerBitsetHelper& x)
    {
                    m_var_map_inneraliasboundedstringhelper_innerbitsethelper = x.m_var_map_inneraliasboundedstringhelper_innerbitsethelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitsetHelper(
            MapInnerAliasBoundedStringHelperInnerBitsetHelper&& x) noexcept
    {
        m_var_map_inneraliasboundedstringhelper_innerbitsethelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerbitsethelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitsetHelper& operator =(
            const MapInnerAliasBoundedStringHelperInnerBitsetHelper& x)
    {

                    m_var_map_inneraliasboundedstringhelper_innerbitsethelper = x.m_var_map_inneraliasboundedstringhelper_innerbitsethelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedStringHelperInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedStringHelperInnerBitsetHelper& operator =(
            MapInnerAliasBoundedStringHelperInnerBitsetHelper&& x) noexcept
    {

        m_var_map_inneraliasboundedstringhelper_innerbitsethelper = std::move(x.m_var_map_inneraliasboundedstringhelper_innerbitsethelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedStringHelperInnerBitsetHelper& x) const
    {
        return (m_var_map_inneraliasboundedstringhelper_innerbitsethelper == x.m_var_map_inneraliasboundedstringhelper_innerbitsethelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedStringHelperInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedStringHelperInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedstringhelper_innerbitsethelper
     * @param _var_map_inneraliasboundedstringhelper_innerbitsethelper New value to be copied in member var_map_inneraliasboundedstringhelper_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerbitsethelper(
            const std::map<Inner_alias_bounded_string_helper, InnerBitsetHelper>& _var_map_inneraliasboundedstringhelper_innerbitsethelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerbitsethelper = _var_map_inneraliasboundedstringhelper_innerbitsethelper;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedstringhelper_innerbitsethelper
     * @param _var_map_inneraliasboundedstringhelper_innerbitsethelper New value to be moved in member var_map_inneraliasboundedstringhelper_innerbitsethelper
     */
    eProsima_user_DllExport void var_map_inneraliasboundedstringhelper_innerbitsethelper(
            std::map<Inner_alias_bounded_string_helper, InnerBitsetHelper>&& _var_map_inneraliasboundedstringhelper_innerbitsethelper)
    {
        m_var_map_inneraliasboundedstringhelper_innerbitsethelper = std::move(_var_map_inneraliasboundedstringhelper_innerbitsethelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedstringhelper_innerbitsethelper
     * @return Constant reference to member var_map_inneraliasboundedstringhelper_innerbitsethelper
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_string_helper, InnerBitsetHelper>& var_map_inneraliasboundedstringhelper_innerbitsethelper() const
    {
        return m_var_map_inneraliasboundedstringhelper_innerbitsethelper;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedstringhelper_innerbitsethelper
     * @return Reference to member var_map_inneraliasboundedstringhelper_innerbitsethelper
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_string_helper, InnerBitsetHelper>& var_map_inneraliasboundedstringhelper_innerbitsethelper()
    {
        return m_var_map_inneraliasboundedstringhelper_innerbitsethelper;
    }



private:

    std::map<Inner_alias_bounded_string_helper, InnerBitsetHelper> m_var_map_inneraliasboundedstringhelper_innerbitsethelper;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperShort(
            const MapInnerAliasBoundedWStringHelperShort& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_short = x.m_var_map_inneraliasboundedwstringhelper_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperShort(
            MapInnerAliasBoundedWStringHelperShort&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_short = std::move(x.m_var_map_inneraliasboundedwstringhelper_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperShort& operator =(
            const MapInnerAliasBoundedWStringHelperShort& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_short = x.m_var_map_inneraliasboundedwstringhelper_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperShort& operator =(
            MapInnerAliasBoundedWStringHelperShort&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_short = std::move(x.m_var_map_inneraliasboundedwstringhelper_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedWStringHelperShort& x) const
    {
        return (m_var_map_inneraliasboundedwstringhelper_short == x.m_var_map_inneraliasboundedwstringhelper_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedWStringHelperShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedwstringhelper_short
     * @param _var_map_inneraliasboundedwstringhelper_short New value to be copied in member var_map_inneraliasboundedwstringhelper_short
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_short(
            const std::map<Inner_alias_bounded_wstring_helper, int16_t>& _var_map_inneraliasboundedwstringhelper_short)
    {
        m_var_map_inneraliasboundedwstringhelper_short = _var_map_inneraliasboundedwstringhelper_short;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedwstringhelper_short
     * @param _var_map_inneraliasboundedwstringhelper_short New value to be moved in member var_map_inneraliasboundedwstringhelper_short
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_short(
            std::map<Inner_alias_bounded_wstring_helper, int16_t>&& _var_map_inneraliasboundedwstringhelper_short)
    {
        m_var_map_inneraliasboundedwstringhelper_short = std::move(_var_map_inneraliasboundedwstringhelper_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedwstringhelper_short
     * @return Constant reference to member var_map_inneraliasboundedwstringhelper_short
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_wstring_helper, int16_t>& var_map_inneraliasboundedwstringhelper_short() const
    {
        return m_var_map_inneraliasboundedwstringhelper_short;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedwstringhelper_short
     * @return Reference to member var_map_inneraliasboundedwstringhelper_short
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_wstring_helper, int16_t>& var_map_inneraliasboundedwstringhelper_short()
    {
        return m_var_map_inneraliasboundedwstringhelper_short;
    }



private:

    std::map<Inner_alias_bounded_wstring_helper, int16_t> m_var_map_inneraliasboundedwstringhelper_short;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperUShort defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperUShort(
            const MapInnerAliasBoundedWStringHelperUShort& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_ushort = x.m_var_map_inneraliasboundedwstringhelper_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperUShort(
            MapInnerAliasBoundedWStringHelperUShort&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_ushort = std::move(x.m_var_map_inneraliasboundedwstringhelper_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperUShort& operator =(
            const MapInnerAliasBoundedWStringHelperUShort& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_ushort = x.m_var_map_inneraliasboundedwstringhelper_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperUShort that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperUShort& operator =(
            MapInnerAliasBoundedWStringHelperUShort&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_ushort = std::move(x.m_var_map_inneraliasboundedwstringhelper_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedWStringHelperUShort& x) const
    {
        return (m_var_map_inneraliasboundedwstringhelper_ushort == x.m_var_map_inneraliasboundedwstringhelper_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedWStringHelperUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedwstringhelper_ushort
     * @param _var_map_inneraliasboundedwstringhelper_ushort New value to be copied in member var_map_inneraliasboundedwstringhelper_ushort
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_ushort(
            const std::map<Inner_alias_bounded_wstring_helper, uint16_t>& _var_map_inneraliasboundedwstringhelper_ushort)
    {
        m_var_map_inneraliasboundedwstringhelper_ushort = _var_map_inneraliasboundedwstringhelper_ushort;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedwstringhelper_ushort
     * @param _var_map_inneraliasboundedwstringhelper_ushort New value to be moved in member var_map_inneraliasboundedwstringhelper_ushort
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_ushort(
            std::map<Inner_alias_bounded_wstring_helper, uint16_t>&& _var_map_inneraliasboundedwstringhelper_ushort)
    {
        m_var_map_inneraliasboundedwstringhelper_ushort = std::move(_var_map_inneraliasboundedwstringhelper_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedwstringhelper_ushort
     * @return Constant reference to member var_map_inneraliasboundedwstringhelper_ushort
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_wstring_helper, uint16_t>& var_map_inneraliasboundedwstringhelper_ushort() const
    {
        return m_var_map_inneraliasboundedwstringhelper_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedwstringhelper_ushort
     * @return Reference to member var_map_inneraliasboundedwstringhelper_ushort
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_wstring_helper, uint16_t>& var_map_inneraliasboundedwstringhelper_ushort()
    {
        return m_var_map_inneraliasboundedwstringhelper_ushort;
    }



private:

    std::map<Inner_alias_bounded_wstring_helper, uint16_t> m_var_map_inneraliasboundedwstringhelper_ushort;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLong(
            const MapInnerAliasBoundedWStringHelperLong& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_long = x.m_var_map_inneraliasboundedwstringhelper_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLong(
            MapInnerAliasBoundedWStringHelperLong&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_long = std::move(x.m_var_map_inneraliasboundedwstringhelper_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLong& operator =(
            const MapInnerAliasBoundedWStringHelperLong& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_long = x.m_var_map_inneraliasboundedwstringhelper_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLong& operator =(
            MapInnerAliasBoundedWStringHelperLong&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_long = std::move(x.m_var_map_inneraliasboundedwstringhelper_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedWStringHelperLong& x) const
    {
        return (m_var_map_inneraliasboundedwstringhelper_long == x.m_var_map_inneraliasboundedwstringhelper_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedWStringHelperLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedwstringhelper_long
     * @param _var_map_inneraliasboundedwstringhelper_long New value to be copied in member var_map_inneraliasboundedwstringhelper_long
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_long(
            const std::map<Inner_alias_bounded_wstring_helper, int32_t>& _var_map_inneraliasboundedwstringhelper_long)
    {
        m_var_map_inneraliasboundedwstringhelper_long = _var_map_inneraliasboundedwstringhelper_long;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedwstringhelper_long
     * @param _var_map_inneraliasboundedwstringhelper_long New value to be moved in member var_map_inneraliasboundedwstringhelper_long
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_long(
            std::map<Inner_alias_bounded_wstring_helper, int32_t>&& _var_map_inneraliasboundedwstringhelper_long)
    {
        m_var_map_inneraliasboundedwstringhelper_long = std::move(_var_map_inneraliasboundedwstringhelper_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedwstringhelper_long
     * @return Constant reference to member var_map_inneraliasboundedwstringhelper_long
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_wstring_helper, int32_t>& var_map_inneraliasboundedwstringhelper_long() const
    {
        return m_var_map_inneraliasboundedwstringhelper_long;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedwstringhelper_long
     * @return Reference to member var_map_inneraliasboundedwstringhelper_long
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_wstring_helper, int32_t>& var_map_inneraliasboundedwstringhelper_long()
    {
        return m_var_map_inneraliasboundedwstringhelper_long;
    }



private:

    std::map<Inner_alias_bounded_wstring_helper, int32_t> m_var_map_inneraliasboundedwstringhelper_long;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperULong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULong(
            const MapInnerAliasBoundedWStringHelperULong& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_ulong = x.m_var_map_inneraliasboundedwstringhelper_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULong(
            MapInnerAliasBoundedWStringHelperULong&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_ulong = std::move(x.m_var_map_inneraliasboundedwstringhelper_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULong& operator =(
            const MapInnerAliasBoundedWStringHelperULong& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_ulong = x.m_var_map_inneraliasboundedwstringhelper_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULong& operator =(
            MapInnerAliasBoundedWStringHelperULong&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_ulong = std::move(x.m_var_map_inneraliasboundedwstringhelper_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedWStringHelperULong& x) const
    {
        return (m_var_map_inneraliasboundedwstringhelper_ulong == x.m_var_map_inneraliasboundedwstringhelper_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedWStringHelperULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedwstringhelper_ulong
     * @param _var_map_inneraliasboundedwstringhelper_ulong New value to be copied in member var_map_inneraliasboundedwstringhelper_ulong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_ulong(
            const std::map<Inner_alias_bounded_wstring_helper, uint32_t>& _var_map_inneraliasboundedwstringhelper_ulong)
    {
        m_var_map_inneraliasboundedwstringhelper_ulong = _var_map_inneraliasboundedwstringhelper_ulong;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedwstringhelper_ulong
     * @param _var_map_inneraliasboundedwstringhelper_ulong New value to be moved in member var_map_inneraliasboundedwstringhelper_ulong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_ulong(
            std::map<Inner_alias_bounded_wstring_helper, uint32_t>&& _var_map_inneraliasboundedwstringhelper_ulong)
    {
        m_var_map_inneraliasboundedwstringhelper_ulong = std::move(_var_map_inneraliasboundedwstringhelper_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedwstringhelper_ulong
     * @return Constant reference to member var_map_inneraliasboundedwstringhelper_ulong
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_wstring_helper, uint32_t>& var_map_inneraliasboundedwstringhelper_ulong() const
    {
        return m_var_map_inneraliasboundedwstringhelper_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedwstringhelper_ulong
     * @return Reference to member var_map_inneraliasboundedwstringhelper_ulong
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_wstring_helper, uint32_t>& var_map_inneraliasboundedwstringhelper_ulong()
    {
        return m_var_map_inneraliasboundedwstringhelper_ulong;
    }



private:

    std::map<Inner_alias_bounded_wstring_helper, uint32_t> m_var_map_inneraliasboundedwstringhelper_ulong;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperLongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLongLong(
            const MapInnerAliasBoundedWStringHelperLongLong& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_longlong = x.m_var_map_inneraliasboundedwstringhelper_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLongLong(
            MapInnerAliasBoundedWStringHelperLongLong&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_longlong = std::move(x.m_var_map_inneraliasboundedwstringhelper_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLongLong& operator =(
            const MapInnerAliasBoundedWStringHelperLongLong& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_longlong = x.m_var_map_inneraliasboundedwstringhelper_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperLongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperLongLong& operator =(
            MapInnerAliasBoundedWStringHelperLongLong&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_longlong = std::move(x.m_var_map_inneraliasboundedwstringhelper_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedWStringHelperLongLong& x) const
    {
        return (m_var_map_inneraliasboundedwstringhelper_longlong == x.m_var_map_inneraliasboundedwstringhelper_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedWStringHelperLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedwstringhelper_longlong
     * @param _var_map_inneraliasboundedwstringhelper_longlong New value to be copied in member var_map_inneraliasboundedwstringhelper_longlong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_longlong(
            const std::map<Inner_alias_bounded_wstring_helper, int64_t>& _var_map_inneraliasboundedwstringhelper_longlong)
    {
        m_var_map_inneraliasboundedwstringhelper_longlong = _var_map_inneraliasboundedwstringhelper_longlong;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedwstringhelper_longlong
     * @param _var_map_inneraliasboundedwstringhelper_longlong New value to be moved in member var_map_inneraliasboundedwstringhelper_longlong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_longlong(
            std::map<Inner_alias_bounded_wstring_helper, int64_t>&& _var_map_inneraliasboundedwstringhelper_longlong)
    {
        m_var_map_inneraliasboundedwstringhelper_longlong = std::move(_var_map_inneraliasboundedwstringhelper_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedwstringhelper_longlong
     * @return Constant reference to member var_map_inneraliasboundedwstringhelper_longlong
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_wstring_helper, int64_t>& var_map_inneraliasboundedwstringhelper_longlong() const
    {
        return m_var_map_inneraliasboundedwstringhelper_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedwstringhelper_longlong
     * @return Reference to member var_map_inneraliasboundedwstringhelper_longlong
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_wstring_helper, int64_t>& var_map_inneraliasboundedwstringhelper_longlong()
    {
        return m_var_map_inneraliasboundedwstringhelper_longlong;
    }



private:

    std::map<Inner_alias_bounded_wstring_helper, int64_t> m_var_map_inneraliasboundedwstringhelper_longlong;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperULongLong defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULongLong(
            const MapInnerAliasBoundedWStringHelperULongLong& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_ulonglong = x.m_var_map_inneraliasboundedwstringhelper_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULongLong(
            MapInnerAliasBoundedWStringHelperULongLong&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_ulonglong = std::move(x.m_var_map_inneraliasboundedwstringhelper_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULongLong& operator =(
            const MapInnerAliasBoundedWStringHelperULongLong& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_ulonglong = x.m_var_map_inneraliasboundedwstringhelper_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperULongLong that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperULongLong& operator =(
            MapInnerAliasBoundedWStringHelperULongLong&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_ulonglong = std::move(x.m_var_map_inneraliasboundedwstringhelper_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapInnerAliasBoundedWStringHelperULongLong& x) const
    {
        return (m_var_map_inneraliasboundedwstringhelper_ulonglong == x.m_var_map_inneraliasboundedwstringhelper_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapInnerAliasBoundedWStringHelperULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map_inneraliasboundedwstringhelper_ulonglong
     * @param _var_map_inneraliasboundedwstringhelper_ulonglong New value to be copied in member var_map_inneraliasboundedwstringhelper_ulonglong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_ulonglong(
            const std::map<Inner_alias_bounded_wstring_helper, uint64_t>& _var_map_inneraliasboundedwstringhelper_ulonglong)
    {
        m_var_map_inneraliasboundedwstringhelper_ulonglong = _var_map_inneraliasboundedwstringhelper_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_map_inneraliasboundedwstringhelper_ulonglong
     * @param _var_map_inneraliasboundedwstringhelper_ulonglong New value to be moved in member var_map_inneraliasboundedwstringhelper_ulonglong
     */
    eProsima_user_DllExport void var_map_inneraliasboundedwstringhelper_ulonglong(
            std::map<Inner_alias_bounded_wstring_helper, uint64_t>&& _var_map_inneraliasboundedwstringhelper_ulonglong)
    {
        m_var_map_inneraliasboundedwstringhelper_ulonglong = std::move(_var_map_inneraliasboundedwstringhelper_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_map_inneraliasboundedwstringhelper_ulonglong
     * @return Constant reference to member var_map_inneraliasboundedwstringhelper_ulonglong
     */
    eProsima_user_DllExport const std::map<Inner_alias_bounded_wstring_helper, uint64_t>& var_map_inneraliasboundedwstringhelper_ulonglong() const
    {
        return m_var_map_inneraliasboundedwstringhelper_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_map_inneraliasboundedwstringhelper_ulonglong
     * @return Reference to member var_map_inneraliasboundedwstringhelper_ulonglong
     */
    eProsima_user_DllExport std::map<Inner_alias_bounded_wstring_helper, uint64_t>& var_map_inneraliasboundedwstringhelper_ulonglong()
    {
        return m_var_map_inneraliasboundedwstringhelper_ulonglong;
    }



private:

    std::map<Inner_alias_bounded_wstring_helper, uint64_t> m_var_map_inneraliasboundedwstringhelper_ulonglong;

};
/*!
 * @brief This class represents the structure MapInnerAliasBoundedWStringHelperFloat defined by the user in the IDL file.
 * @ingroup maps
 */
class MapInnerAliasBoundedWStringHelperFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapInnerAliasBoundedWStringHelperFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperFloat(
            const MapInnerAliasBoundedWStringHelperFloat& x)
    {
                    m_var_map_inneraliasboundedwstringhelper_float = x.m_var_map_inneraliasboundedwstringhelper_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperFloat(
            MapInnerAliasBoundedWStringHelperFloat&& x) noexcept
    {
        m_var_map_inneraliasboundedwstringhelper_float = std::move(x.m_var_map_inneraliasboundedwstringhelper_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperFloat& operator =(
            const MapInnerAliasBoundedWStringHelperFloat& x)
    {

                    m_var_map_inneraliasboundedwstringhelper_float = x.m_var_map_inneraliasboundedwstringhelper_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapInnerAliasBoundedWStringHelperFloat that will be copied.
     */
    eProsima_user_DllExport MapInnerAliasBoundedWStringHelperFloat& operator =(
            MapInnerAliasBoundedWStringHelperFloat&& x) noexcept
    {

        m_var_map_inneraliasboundedwstringhelper_float = std::move(x.m_var_map_inneraliasboundedwstringhelper_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapInnerAliasBoundedWStringHelperFloat o