/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;

public class ChainingTrustEngine<TokenType>
implements TrustEngine<TokenType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingTrustEngine.class);
    @Nonnull
    private List<TrustEngine<? super TokenType>> engines;

    public ChainingTrustEngine(@Nonnull @ParameterName(name="chain") List<TrustEngine<? super TokenType>> chain) {
        this.engines = CollectionSupport.copyToList((Collection)Constraint.isNotNull(chain, "TrustEngine list cannot be null"));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<TrustEngine<? super TokenType>> getChain() {
        return this.engines;
    }

    @Override
    public boolean validate(@Nonnull TokenType token, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        for (TrustEngine<TokenType> engine : this.engines) {
            if (!engine.validate(token, trustBasisCriteria)) continue;
            this.log.debug("Token was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }
}

