/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config.impl;

import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.slf4j.Logger;

public class JavaCryptoValidationInitializer
implements Initializer {
    @Nonnull
    @NotEmpty
    public static final String CONFIG_PROPERTY_FAIL_IS_FATAL = "opensaml.config.xmlsec.cryptoValidationIsFatal";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(JavaCryptoValidationInitializer.class);

    @Override
    public void init() throws InitializationException {
        ConfigurationProperties props;
        Boolean isFatal;
        boolean valid = true;
        String errorMsgAESPadding = "The JCE providers currently configured in the JVM do not support\nrequired capabilities for XML Encryption, either the 'AES' cipher algorithm\nor the 'ISO10126Padding' padding scheme\n";
        try {
            Cipher.getInstance("AES/CBC/ISO10126Padding");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.warn("The JCE providers currently configured in the JVM do not support\nrequired capabilities for XML Encryption, either the 'AES' cipher algorithm\nor the 'ISO10126Padding' padding scheme\n");
            valid = false;
        }
        catch (NoSuchPaddingException e) {
            this.log.warn("The JCE providers currently configured in the JVM do not support\nrequired capabilities for XML Encryption, either the 'AES' cipher algorithm\nor the 'ISO10126Padding' padding scheme\n");
            valid = false;
        }
        if (!valid && (isFatal = Boolean.valueOf(Boolean.parseBoolean((props = ConfigurationService.getConfigurationProperties()).getProperty(CONFIG_PROPERTY_FAIL_IS_FATAL, "false")))).booleanValue()) {
            this.log.warn("Configuration indicates an invalid crypto configuration should be fatal");
            throw new InitializationException("A fatal error was encountered validating required crypto capabilities");
        }
    }
}

