/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.runner;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.runner.LineTransformer;
import com.amazon.randomcutforest.runner.SimpleRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AnomalyAttributionRunner
extends SimpleRunner {
    public AnomalyAttributionRunner() {
        super(AnomalyAttributionRunner.class.getName(), "Compute directional anomaly scores from the input rows and append them to the output rows.", AnomalyAttributionTransformer::new);
    }

    public static void main(String ... args) throws IOException {
        AnomalyAttributionRunner runner = new AnomalyAttributionRunner();
        runner.parse(args);
        System.out.println("Reading from stdin... (Ctrl-c to exit)");
        runner.run(new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        System.out.println("Done.");
    }

    public static class AnomalyAttributionTransformer
    implements LineTransformer {
        private final RandomCutForest forest;

        public AnomalyAttributionTransformer(RandomCutForest forest) {
            this.forest = forest;
        }

        @Override
        public List<String> getResultValues(double ... point) {
            DiVector attribution = this.forest.getAnomalyAttribution(point);
            this.forest.update(point);
            ArrayList<String> result = new ArrayList<String>(2 * this.forest.getDimensions());
            for (int i = 0; i < attribution.getDimensions(); ++i) {
                result.add(Double.toString(attribution.low[i]));
                result.add(Double.toString(attribution.high[i]));
            }
            return result;
        }

        @Override
        public List<String> getEmptyResultValue() {
            ArrayList<String> result = new ArrayList<String>(2 * this.forest.getDimensions());
            for (int i = 0; i < 2 * this.forest.getDimensions(); ++i) {
                result.add("NA");
            }
            return result;
        }

        @Override
        public List<String> getResultColumnNames() {
            ArrayList<String> result = new ArrayList<String>(2 * this.forest.getDimensions());
            for (int i = 0; i < this.forest.getDimensions(); ++i) {
                result.add("anomaly_low_" + i);
                result.add("anomaly_high_" + i);
            }
            return result;
        }

        @Override
        public RandomCutForest getForest() {
            return this.forest;
        }
    }
}

