/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.extract;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.extract.ContentExtractor;
import tim.prune.function.filesleuth.extract.XmlFileExtractor;

public class ZipFileExtractor
implements ContentExtractor {
    private final File _file;

    public ZipFileExtractor(File file) {
        this._file = file;
    }

    @Override
    public TrackContents getContents(TimeZone timeZone) {
        ContentExtractor contentExtractor = this.getExtractor();
        if (contentExtractor == null) {
            return new TrackContents(timeZone);
        }
        return contentExtractor.getContents(timeZone);
    }

    private ContentExtractor getExtractor() {
        if (this._file == null || !this._file.isFile() || !this._file.canRead()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (ZipFile zipFile = new ZipFile(this._file);){
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.toString();
                    if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".kml") && !string.equals(".gpx") && !string.equals(".xml")) continue;
                    return new XmlFileExtractor(zipFile.getInputStream(zipEntry));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public boolean matchesFilter(LocationFilter locationFilter) {
        ContentExtractor contentExtractor = this.getExtractor();
        return contentExtractor != null && contentExtractor.matchesFilter(locationFilter);
    }
}

