/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaFlexTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjection;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjectionColumn;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaUDF;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class VerticaSchema
extends GenericSchema
implements DBPSystemObject,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(VerticaSchema.class);
    private boolean hasStatistics;
    private static final String[] SYSTEM_SCHEMAS = new String[]{"v_catalog", "v_internal", "v_monitor", "v_txtindex"};
    final ProjectionCache projectionCache = new ProjectionCache();
    final UDFCache udfCache = new UDFCache();

    public VerticaSchema(GenericDataSource dataSource, GenericCatalog catalog, String schemaName) {
        super(dataSource, catalog, schemaName);
    }

    public ProjectionCache getProjectionCache() {
        return this.projectionCache;
    }

    public List<VerticaTable> getPhysicalTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getPhysicalTables(monitor);
    }

    public List<VerticaTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getTables(monitor);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<VerticaTable> children = new ArrayList<VerticaTable>(this.getTables(monitor));
        return children;
    }

    @Association
    public List<VerticaFlexTable> getFlexTables(DBRProgressMonitor monitor) throws DBException {
        List<VerticaTable> tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<VerticaFlexTable> filtered = new ArrayList<VerticaFlexTable>();
            for (GenericTableBase genericTableBase : tables) {
                if (!(genericTableBase instanceof VerticaFlexTable)) continue;
                filtered.add((VerticaFlexTable)genericTableBase);
            }
            return filtered;
        }
        return null;
    }

    @Association
    public Collection<VerticaProjection> getProjections(DBRProgressMonitor monitor) throws DBException {
        return this.projectionCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public VerticaProjection getProjection(DBRProgressMonitor monitor, String name) throws DBException {
        return (VerticaProjection)this.projectionCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<VerticaUDF> getUserDefinedFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.udfCache.getAllObjects(monitor, (DBSObject)this);
    }

    public boolean isSystem() {
        return ArrayUtils.contains((Object[])SYSTEM_SCHEMAS, (Object)this.getName());
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.hasStatistics = false;
        return super.refreshObject(monitor);
    }

    void resetStatistics() {
        this.hasStatistics = false;
    }

    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read relation statistics");){
                try {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT anchor_table_name as table_name,\nSUM(used_bytes) as used_bytes\nFROM v_monitor.column_storage cs\nWHERE cs.anchor_table_schema = ?\nGROUP BY anchor_table_id, anchor_table_name\nORDER BY anchor_table_name");){
                        dbStat.setString(1, this.getName());
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String tableName = dbResult.getString("table_name");
                                GenericTableBase table = this.getTable(monitor, tableName);
                                if (!(table instanceof VerticaTable)) continue;
                                ((VerticaTable)table).fetchStatistics(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException("Error reading schema relation statistics", (Throwable)e);
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return VerticaTable.class;
    }

    public class ProjectionCache
    extends JDBCStructLookupCache<VerticaSchema, VerticaProjection, VerticaProjectionColumn> {
        ProjectionCache() {
            super((Object)"projection_name");
            this.setListOrderComparator(DBUtils.nameComparatorIgnoreCase());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull VerticaSchema schema, @Nullable VerticaProjection object, @Nullable String objectName) throws SQLException {
            boolean avoidCommentsReading = ((VerticaDataSource)schema.getDataSource()).avoidCommentsReading();
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.*" + (avoidCommentsReading ? "" : ",c.comment") + " FROM v_catalog.projections p\n" + (avoidCommentsReading ? "" : "LEFT OUTER JOIN v_catalog.comments c ON c.object_type = 'PROJECTION'\nAND c.object_schema = p.projection_schema AND c.object_name = p.projection_name\n") + "WHERE p.projection_schema=?" + (object == null && objectName == null ? "" : " AND projection_name=?"));
            dbStat.setString(1, schema.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected VerticaProjection fetchObject(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaProjection(VerticaSchema.this, dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @Nullable VerticaProjection forTable) throws SQLException {
            boolean avoidCommentsReading = ((VerticaDataSource)owner.getDataSource()).avoidCommentsReading();
            String sql = "SELECT pc.*" + (avoidCommentsReading ? "" : ",c.comment") + " FROM v_catalog.projection_columns pc\n" + (avoidCommentsReading ? "" : "LEFT OUTER JOIN v_catalog.comments c ON c.object_id = pc.column_id\n") + "WHERE pc.projection_id=?\nORDER BY pc.column_position";
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            dbStat.setLong(1, forTable.getObjectId());
            return dbStat;
        }

        protected VerticaProjectionColumn fetchChild(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @NotNull VerticaProjection table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaProjectionColumn(table, dbResult);
        }
    }

    public class UDFCache
    extends JDBCObjectLookupCache<VerticaSchema, VerticaUDF> {
        UDFCache() {
            this.setListOrderComparator(DBUtils.nameComparatorIgnoreCase());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull VerticaSchema schema, @Nullable VerticaUDF object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM v_catalog.user_functions WHERE schema_schema=?" + (object == null && objectName == null ? "" : " AND function_name=?"));
            dbStat.setString(1, schema.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected VerticaUDF fetchObject(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaUDF(VerticaSchema.this, dbResult);
        }
    }
}

