/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline(value=false)
@GenerateUncached
public abstract class SequenceRepeatHelperNode
extends Node {
    abstract Object execute(VirtualFrame var1, TpSlot var2, Object var3, Object var4);

    @Specialization
    static Object sequenceRepeat(VirtualFrame frame, TpSlot slot, Object seq, Object n, @Bind Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSlotNode, @Cached PRaiseNode raiseNode) {
        if (indexCheckNode.execute(inliningTarget, n)) {
            int count = asSizeNode.execute((Frame)frame, inliningTarget, n, (Object)PythonBuiltinClassType.OverflowError);
            return callSlotNode.execute(frame, inliningTarget, slot, seq, count);
        }
        throw SequenceRepeatHelperNode.raiseNonIntSqMul(inliningTarget, n, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNonIntSqMul(Node inliningTarget, Object n, PRaiseNode raiseNode) {
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANT_MULTIPLY_SEQ_BY_NON_INT, n);
    }
}

