/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.ssl;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.jdbc.SslMode;
import com.amazon.redshift.ssl.LazyKeyManager;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.redshift.ssl.PKCS12KeyManager;
import com.amazon.redshift.ssl.SSLUtil;
import com.amazon.redshift.ssl.WrappedFactory;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.ObjectFactory;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LibPQFactory
extends WrappedFactory {
    private static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String TRUSTSTORE_PWD_PROPERTY = "javax.net.ssl.trustStorePassword";
    private static final String TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    KeyManager km;
    boolean defaultfile;

    private CallbackHandler getCallbackHandler(Properties info) throws RedshiftException {
        CallbackHandler cbh;
        String sslpasswordcallback = RedshiftProperty.SSL_PASSWORD_CALLBACK.get(info);
        if (sslpasswordcallback != null) {
            try {
                cbh = ObjectFactory.instantiate(CallbackHandler.class, sslpasswordcallback, info, false, null);
            }
            catch (Exception e) {
                throw new RedshiftException(GT.tr("The password callback class provided {0} could not be instantiated.", sslpasswordcallback), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
            }
        } else {
            cbh = new ConsoleCallbackHandler(RedshiftProperty.SSL_PASSWORD.get(info));
        }
        return cbh;
    }

    private void initPk8(String sslkeyfile, String defaultdir, Properties info) throws RedshiftException {
        String sslcertfile = RedshiftProperty.SSL_CERT.get(info);
        if (sslcertfile == null) {
            this.defaultfile = true;
            sslcertfile = defaultdir + "redshift.crt";
        }
        this.km = new LazyKeyManager("".equals(sslcertfile) ? null : sslcertfile, "".equals(sslkeyfile) ? null : sslkeyfile, this.getCallbackHandler(info), this.defaultfile);
    }

    private void initP12(String sslkeyfile, Properties info) throws RedshiftException {
        this.km = new PKCS12KeyManager(sslkeyfile, this.getCallbackHandler(info));
    }

    public LibPQFactory(Properties info) throws RedshiftException {
        try {
            TrustManager[] tm;
            SslMode sslMode;
            SSLContext ctx = SSLUtil.createSecureSSLContext();
            String pathsep = System.getProperty("file.separator");
            String defaultdir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathsep + "redshift" + pathsep : System.getProperty("user.home") + pathsep + ".redshift" + pathsep;
            String sslkeyfile = RedshiftProperty.SSL_KEY.get(info);
            if (sslkeyfile == null) {
                this.defaultfile = true;
                sslkeyfile = defaultdir + "redshift.pk8";
            }
            if (sslkeyfile.endsWith("pk8")) {
                this.initPk8(sslkeyfile, defaultdir, info);
            }
            if (sslkeyfile.endsWith("p12")) {
                this.initP12(sslkeyfile, info);
            }
            if (!(sslMode = SslMode.of(info)).verifyCertificate()) {
                tm = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            } else {
                String sslTrustStorePath = RedshiftProperty.SSL_TRUSTSTORE_PATH_KEY.get(info);
                String sslrootcertfile = RedshiftProperty.SSL_ROOT_CERT.get(info);
                String sslTrustStorePwd = RedshiftProperty.SSL_TRUSTSTORE_PWD_KEY.get(info);
                tm = null != sslTrustStorePath ? this.getTrustManagerWithDefinedTrustStore(sslTrustStorePath, sslTrustStorePwd) : (null != sslrootcertfile ? this.getTrustManagerWithImportedCertificate(sslrootcertfile) : this.getDefaultTrustManager());
            }
            try {
                ctx.init(new KeyManager[]{this.km}, tm, null);
            }
            catch (KeyManagementException ex) {
                throw new RedshiftException(GT.tr("Could not initialize SSL context.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ex);
            }
            this.factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RedshiftException(GT.tr("Could not find a java cryptographic algorithm: {0}.", ex.getMessage()), RedshiftState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void throwKeyManagerException() throws RedshiftException {
        if (this.km != null) {
            if (this.km instanceof LazyKeyManager) {
                ((LazyKeyManager)this.km).throwKeyManagerException();
            }
            if (this.km instanceof PKCS12KeyManager) {
                ((PKCS12KeyManager)this.km).throwKeyManagerException();
            }
        }
    }

    private TrustManager[] getTrustManagerWithDefinedTrustStore(String sslTrustStorePath, String sslTrustStorePwd) throws RedshiftException {
        KeyStore truststore = null;
        FileInputStream trustStoreSource = null;
        try {
            trustStoreSource = new FileInputStream(sslTrustStorePath);
            truststore = KeyStore.getInstance(KeyStore.getDefaultType());
            truststore.load(trustStoreSource, sslTrustStorePwd != null ? sslTrustStorePwd.toCharArray() : null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(truststore);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("Error retrieving the available trust managers {0}.", sslTrustStorePath), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
        finally {
            if (trustStoreSource != null) {
                try {
                    trustStoreSource.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private TrustManager[] getTrustManagerWithImportedCertificate(String sslRootCert) throws RedshiftException {
        KeyStore truststore = this.getDefaultKeystore();
        try {
            Certificate[] chain = this.getCertificateChain(sslRootCert);
            truststore.setCertificateEntry(sslRootCert, chain[0]);
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("Error loading the certificate file {0}.", sslRootCert), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
        return this.getTrustManager(truststore);
    }

    private KeyStore getDefaultKeystore() throws RedshiftException {
        FileInputStream keystoreStream = null;
        String passphrase = null;
        String keystorePath = System.getProperty(TRUSTSTORE_PROPERTY);
        passphrase = System.getProperty(TRUSTSTORE_PWD_PROPERTY);
        String type = System.getProperty(TRUSTSTORE_TYPE);
        if (null == keystorePath) {
            StringBuilder trustorePath = new StringBuilder();
            trustorePath.append(System.getProperty("java.home"));
            trustorePath.append(File.separatorChar);
            trustorePath.append("lib");
            trustorePath.append(File.separatorChar);
            trustorePath.append("security");
            trustorePath.append(File.separatorChar);
            trustorePath.append("cacerts");
            keystorePath = trustorePath.toString();
        }
        try {
            keystoreStream = new FileInputStream(new File(keystorePath));
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("Error loading the keystore  {0}.", keystorePath), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
        try {
            KeyStore keystore = null != type && !type.isEmpty() ? KeyStore.getInstance(type) : KeyStore.getInstance(KeyStore.getDefaultType());
            char[] passphraseArray = null;
            if (null != passphrase) {
                passphraseArray = passphrase.toCharArray();
            }
            keystore.load(keystoreStream, passphraseArray);
            ((InputStream)keystoreStream).close();
            return keystore;
        }
        catch (Exception e) {
            return this.fallbackKeyStores(keystorePath, passphrase, e);
        }
    }

    private KeyStore fallbackKeyStores(String keystorePath, String passphrase, Exception originalEx) throws RedshiftException {
        String[] keystoreTypes;
        for (String keystoreType : keystoreTypes = new String[]{"JKS", "PKCS12", "JCEKS"}) {
            try {
                FileInputStream keystoreStream = null;
                try {
                    keystoreStream = new FileInputStream(new File(keystorePath));
                }
                catch (Exception e) {
                    throw new RedshiftException(GT.tr("Error loading the keystore  {0}.", keystorePath), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
                }
                KeyStore keystore = KeyStore.getInstance(keystoreType);
                char[] passphraseArray = null;
                if (null != passphrase) {
                    passphraseArray = passphrase.toCharArray();
                }
                keystore.load(keystoreStream, passphraseArray);
                ((InputStream)keystoreStream).close();
                return keystore;
            }
            catch (RedshiftException rsex) {
                throw rsex;
            }
            catch (Exception exception) {
            }
        }
        throw new RedshiftException(GT.tr("Error loading the provided keystore.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)originalEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultCA(KeyStore keystore, String name) throws IOException, GeneralSecurityException {
        try (InputStream is = null;){
            is = NonValidatingFactory.class.getResourceAsStream(name);
            if (is == null) {
                return;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(is);
            keystore.setCertificateEntry(name, cert);
        }
    }

    private Certificate[] getCertificateChain(String certificatePath) throws RedshiftException {
        Certificate[] chain = new Certificate[]{};
        try {
            File certificateFile = new File(certificatePath);
            if (!certificateFile.isFile() || !certificateFile.exists()) {
                throw new RedshiftException(GT.tr("Error certificate file doesn't found {0}.", certificatePath), RedshiftState.CONNECTION_FAILURE);
            }
            FileInputStream certificateStream = new FileInputStream(certificateFile);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            chain = certificateFactory.generateCertificates(certificateStream).toArray(chain);
            ((InputStream)certificateStream).close();
            if (0 >= chain.length || null == chain[0]) {
                throw new RedshiftException(GT.tr("Error missing certificate.", new Object[0]), RedshiftState.CONNECTION_FAILURE);
            }
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("Error loading certificate chain.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
        return chain;
    }

    private TrustManager[] getTrustManager(KeyStore keystore) throws RedshiftException {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("Error retrieving the available trust managers.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    private TrustManager[] getDefaultTrustManager() throws RedshiftException {
        KeyStore keystore = this.getDefaultKeystore();
        return this.getTrustManager(keystore);
    }

    public static class ConsoleCallbackHandler
    implements CallbackHandler {
        private char[] password = null;

        ConsoleCallbackHandler(String password) {
            if (password != null) {
                this.password = password.toCharArray();
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Console cons = System.console();
            if (cons == null && this.password == null) {
                throw new UnsupportedCallbackException(callbacks[0], "Console is not available");
            }
            for (Callback callback : callbacks) {
                if (!(callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                PasswordCallback pwdCallback = (PasswordCallback)callback;
                if (this.password != null) {
                    pwdCallback.setPassword(this.password);
                    continue;
                }
                pwdCallback.setPassword(cons.readPassword("%s", pwdCallback.getPrompt()));
            }
        }
    }
}

