/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.BeanUtils;

public class DataSourceVariableResolver
extends SystemVariablesResolver {
    private static final Log log = Log.getLog(DataSourceVariableResolver.class);
    private final DBPDataSourceContainer dataSourceContainer;
    private final DBPConnectionConfiguration configuration;

    public DataSourceVariableResolver(@Nullable DBPDataSourceContainer dataSourceContainer, @Nullable DBPConnectionConfiguration configuration) {
        this.dataSourceContainer = dataSourceContainer;
        this.configuration = configuration;
    }

    public boolean isSecure() {
        return false;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    protected DBPConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected boolean isResolveSystemVariables() {
        return DBWorkbench.getPlatform().getApplication().isEnvironmentVariablesAccessible();
    }

    @Override
    @Nullable
    public String get(@NotNull String name) {
        block60: {
            block58: {
                if (this.configuration == null) break block58;
                switch (name) {
                    case "host": {
                        return this.configuration.getHostName();
                    }
                    case "host.tunnel": {
                        return DBWUtils.getTargetTunnelHostName(this.dataSourceContainer, this.configuration);
                    }
                    case "port": {
                        return this.configuration.getHostPort();
                    }
                    case "server": {
                        return this.configuration.getServerName();
                    }
                    case "database": {
                        return this.configuration.getDatabaseName();
                    }
                    case "user": {
                        return this.configuration.getUserName();
                    }
                    case "url": {
                        return this.configuration.getUrl();
                    }
                    case "connection.type": 
                    case "connectionType": {
                        return this.configuration.getConnectionType().getId();
                    }
                }
                if ("password".equals(name) && this.isSecure()) {
                    return this.configuration.getUserPassword();
                }
                if (name.startsWith("properties.")) {
                    return this.configuration.getProperty(name.substring("properties.".length()));
                }
                if (name.startsWith("auth.")) {
                    return this.configuration.getAuthProperty(name.substring("auth.".length()));
                }
                String propValue = this.configuration.getProperty(name);
                if (propValue != null) {
                    return propValue;
                }
            }
            if (this.dataSourceContainer == null) break block60;
            switch (name) {
                case "datasource": {
                    return this.dataSourceContainer.getName();
                }
                case "project.path": {
                    return this.dataSourceContainer.getProject().getAbsolutePath().toAbsolutePath().toString();
                }
                case "project.name": {
                    return this.dataSourceContainer.getProject().getName();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
                case "time": {
                    return RuntimeUtils.getCurrentTime();
                }
            }
            if (name.startsWith("origin.")) {
                String originProperty = name.substring("origin.".length());
                DBPDataSourceOrigin origin = this.dataSourceContainer.getOrigin();
                try {
                    Object value = BeanUtils.readObjectProperty((Object)origin, (String)originProperty);
                    if (value != null) {
                        return value.toString();
                    }
                }
                catch (Exception e) {
                    log.debug("Invalid datasource origin property '" + originProperty + "': " + e.getMessage(), e);
                }
            }
            if (name.startsWith("tag.")) {
                return this.dataSourceContainer.getTagValue(name.substring("tag.".length()));
            }
        }
        return super.get(name);
    }
}

