﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>

namespace Aws {
namespace MediaConvert {
namespace Model {
enum class HlsProgressiveWriteHlsManifest { NOT_SET, ENABLED, DISABLED };

namespace HlsProgressiveWriteHlsManifestMapper {
AWS_MEDIACONVERT_API HlsProgressiveWriteHlsManifest GetHlsProgressiveWriteHlsManifestForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForHlsProgressiveWriteHlsManifest(HlsProgressiveWriteHlsManifest value);
}  // namespace HlsProgressiveWriteHlsManifestMapper
}  // namespace Model
}  // namespace MediaConvert
}  // namespace Aws
