﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/fms/FMS_EXPORTS.h>
#include <aws/fms/model/Route.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FMS {
namespace Model {

/**
 * <p>Violation detail for an unexpected gateway route that’s present in a route
 * table.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/NetworkFirewallUnexpectedGatewayRoutesViolation">AWS
 * API Reference</a></p>
 */
class NetworkFirewallUnexpectedGatewayRoutesViolation {
 public:
  AWS_FMS_API NetworkFirewallUnexpectedGatewayRoutesViolation() = default;
  AWS_FMS_API NetworkFirewallUnexpectedGatewayRoutesViolation(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API NetworkFirewallUnexpectedGatewayRoutesViolation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Information about the gateway ID.</p>
   */
  inline const Aws::String& GetGatewayId() const { return m_gatewayId; }
  inline bool GatewayIdHasBeenSet() const { return m_gatewayIdHasBeenSet; }
  template <typename GatewayIdT = Aws::String>
  void SetGatewayId(GatewayIdT&& value) {
    m_gatewayIdHasBeenSet = true;
    m_gatewayId = std::forward<GatewayIdT>(value);
  }
  template <typename GatewayIdT = Aws::String>
  NetworkFirewallUnexpectedGatewayRoutesViolation& WithGatewayId(GatewayIdT&& value) {
    SetGatewayId(std::forward<GatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The routes that are in violation.</p>
   */
  inline const Aws::Vector<Route>& GetViolatingRoutes() const { return m_violatingRoutes; }
  inline bool ViolatingRoutesHasBeenSet() const { return m_violatingRoutesHasBeenSet; }
  template <typename ViolatingRoutesT = Aws::Vector<Route>>
  void SetViolatingRoutes(ViolatingRoutesT&& value) {
    m_violatingRoutesHasBeenSet = true;
    m_violatingRoutes = std::forward<ViolatingRoutesT>(value);
  }
  template <typename ViolatingRoutesT = Aws::Vector<Route>>
  NetworkFirewallUnexpectedGatewayRoutesViolation& WithViolatingRoutes(ViolatingRoutesT&& value) {
    SetViolatingRoutes(std::forward<ViolatingRoutesT>(value));
    return *this;
  }
  template <typename ViolatingRoutesT = Route>
  NetworkFirewallUnexpectedGatewayRoutesViolation& AddViolatingRoutes(ViolatingRoutesT&& value) {
    m_violatingRoutesHasBeenSet = true;
    m_violatingRoutes.emplace_back(std::forward<ViolatingRoutesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the route table.</p>
   */
  inline const Aws::String& GetRouteTableId() const { return m_routeTableId; }
  inline bool RouteTableIdHasBeenSet() const { return m_routeTableIdHasBeenSet; }
  template <typename RouteTableIdT = Aws::String>
  void SetRouteTableId(RouteTableIdT&& value) {
    m_routeTableIdHasBeenSet = true;
    m_routeTableId = std::forward<RouteTableIdT>(value);
  }
  template <typename RouteTableIdT = Aws::String>
  NetworkFirewallUnexpectedGatewayRoutesViolation& WithRouteTableId(RouteTableIdT&& value) {
    SetRouteTableId(std::forward<RouteTableIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the VPC ID.</p>
   */
  inline const Aws::String& GetVpcId() const { return m_vpcId; }
  inline bool VpcIdHasBeenSet() const { return m_vpcIdHasBeenSet; }
  template <typename VpcIdT = Aws::String>
  void SetVpcId(VpcIdT&& value) {
    m_vpcIdHasBeenSet = true;
    m_vpcId = std::forward<VpcIdT>(value);
  }
  template <typename VpcIdT = Aws::String>
  NetworkFirewallUnexpectedGatewayRoutesViolation& WithVpcId(VpcIdT&& value) {
    SetVpcId(std::forward<VpcIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_gatewayId;

  Aws::Vector<Route> m_violatingRoutes;

  Aws::String m_routeTableId;

  Aws::String m_vpcId;
  bool m_gatewayIdHasBeenSet = false;
  bool m_violatingRoutesHasBeenSet = false;
  bool m_routeTableIdHasBeenSet = false;
  bool m_vpcIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FMS
}  // namespace Aws
