﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/cloudtrail/model/Query.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CloudTrail {
namespace Model {
class ListQueriesResult {
 public:
  AWS_CLOUDTRAIL_API ListQueriesResult() = default;
  AWS_CLOUDTRAIL_API ListQueriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLOUDTRAIL_API ListQueriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Lists matching query results, and shows query ID, status, and creation time
   * of each query.</p>
   */
  inline const Aws::Vector<Query>& GetQueries() const { return m_queries; }
  template <typename QueriesT = Aws::Vector<Query>>
  void SetQueries(QueriesT&& value) {
    m_queriesHasBeenSet = true;
    m_queries = std::forward<QueriesT>(value);
  }
  template <typename QueriesT = Aws::Vector<Query>>
  ListQueriesResult& WithQueries(QueriesT&& value) {
    SetQueries(std::forward<QueriesT>(value));
    return *this;
  }
  template <typename QueriesT = Query>
  ListQueriesResult& AddQueries(QueriesT&& value) {
    m_queriesHasBeenSet = true;
    m_queries.emplace_back(std::forward<QueriesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token you can use to get the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListQueriesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListQueriesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Query> m_queries;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_queriesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
