/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.AliasParameter;
import com.tigervnc.rfb.BoolParameter;
import com.tigervnc.rfb.CSecurityTLS;
import com.tigervnc.rfb.IntParameter;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.SecurityClient;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.rfb.VoidParameter;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.UserPreferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Parameters {
    public static BoolParameter noLionFS = new BoolParameter("NoLionFS", "On Mac systems, setting this parameter will force the use of the old (pre-Lion) full-screen mode, even if the viewer is running on OS X 10.7 Lion or later.", false);
    public static BoolParameter dotWhenNoCursor = new BoolParameter("DotWhenNoCursor", "[DEPRECATED] Show the dot cursor when the server sends an invisible cursor", false);
    public static BoolParameter alwaysCursor = new BoolParameter("AlwaysCursor", "Show the local cursor when the server sends an invisible cursor", false);
    public static StringParameter cursorType = new StringParameter("CursorType", "Specify which cursor type the local cursor should be. Should be either Dot or System", "Dot");
    public static BoolParameter sendLocalUsername = new BoolParameter("SendLocalUsername", "Send the local username for SecurityTypes such as Plain rather than prompting", true);
    public static StringParameter passwordFile = new StringParameter("PasswordFile", "Password file for VNC authentication", "");
    public static AliasParameter passwd = new AliasParameter("passwd", "Alias for PasswordFile", passwordFile);
    public static BoolParameter autoSelect = new BoolParameter("AutoSelect", "Auto select pixel format and encoding", true);
    public static BoolParameter fullColor = new BoolParameter("FullColor", "Use full color - otherwise 6-bit colour is used until AutoSelect decides the link is fast enough", true);
    public static AliasParameter fullColorAlias = new AliasParameter("FullColour", "Alias for FullColor", fullColor);
    public static IntParameter lowColorLevel = new IntParameter("LowColorLevel", "Color level to use on slow connections. 0 = Very Low, 1 = Low, 2 = Medium", 2);
    public static AliasParameter lowColorLevelAlias = new AliasParameter("LowColourLevel", "Alias for LowColorLevel", lowColorLevel);
    public static StringParameter preferredEncoding = new StringParameter("PreferredEncoding", "Preferred encoding to use (Tight, ZRLE, hextile or raw) - implies AutoSelect=0", "Tight");
    public static BoolParameter remoteResize = new BoolParameter("RemoteResize", "Dynamically resize the remote desktop size as the size of the local client window changes. (Does not work with all servers)", true);
    public static BoolParameter viewOnly = new BoolParameter("ViewOnly", "Don't send any mouse or keyboard events to the server", false);
    public static BoolParameter shared = new BoolParameter("Shared", "Don't disconnect other viewers upon connection - share the desktop instead", false);
    public static BoolParameter maximize = new BoolParameter("Maximize", "Maximize viewer window", false);
    public static BoolParameter fullScreen = new BoolParameter("FullScreen", "Enable full screen", false);
    public static BoolParameter fullScreenAllMonitors = new BoolParameter("FullScreenAllMonitors", "Enable full screen over all monitors", true);
    public static BoolParameter acceptClipboard = new BoolParameter("AcceptClipboard", "Accept clipboard changes from the server", true);
    public static BoolParameter sendClipboard = new BoolParameter("SendClipboard", "Send clipboard changes to the server", true);
    public static IntParameter maxCutText = new IntParameter("MaxCutText", "Maximum permitted length of an outgoing clipboard update", 262144);
    public static StringParameter menuKey = new StringParameter("MenuKey", "The key which brings up the popup menu", "F8");
    public static StringParameter desktopSize = new StringParameter("DesktopSize", "Reconfigure desktop size on the server on connect (if possible)", "");
    public static BoolParameter listenMode = new BoolParameter("listen", "Listen for connections from VNC servers", false);
    public static StringParameter scalingFactor = new StringParameter("ScalingFactor", "Reduce or enlarge the remote desktop image. The value is interpreted as a scaling factor in percent. If the parameter is set to \"Auto\", then automatic scaling is performed. Auto-scaling tries to choose a scaling factor in such a way that the whole remote desktop will fit on the local screen. If the parameter is set to \"FixedRatio\", then automatic scaling is performed, but the original aspect ratio is preserved.", "100");
    public static BoolParameter alwaysShowServerDialog = new BoolParameter("AlwaysShowServerDialog", "Always show the server dialog even if a server has been specified in an applet parameter or on the command line", false);
    public static BoolParameter acceptBell = new BoolParameter("AcceptBell", "Produce a system beep when requested to by the server.", true);
    public static StringParameter via = new StringParameter("Via", "Automatically create an encrypted TCP tunnel to the gateway machine, then connect to the VNC host through that tunnel. By default, this option invokes SSH local port forwarding using the embedded JSch client, however an external SSH client may be specified using the \"-extSSH\" parameter. Note that when using the -via option, the VNC host machine name should be specified from the point of view of the gateway machine, e.g. \"localhost\" denotes the gateway, not the machine on which the viewer was launched. See the System properties section below for information on configuring the -Via option.", "");
    public static BoolParameter tunnel = new BoolParameter("Tunnel", "The -Tunnel command is basically a shorthand for the -via command when the VNC server and SSH gateway are one and the same. -Tunnel creates an SSH connection to the server and forwards the VNC through the tunnel without the need to specify anything else.", false);
    public static BoolParameter extSSH = new BoolParameter("extSSH", "By default, SSH tunneling uses the embedded JSch client for tunnel creation. This option causes the client to invoke an external SSH client application for all tunneling operations. By default, \"/usr/bin/ssh\" is used, however the path to the external application may be specified using the -SSHClient option.", false);
    public static StringParameter extSSHClient = new StringParameter("extSSHClient", "Specifies the path to an external SSH client application that is to be used for tunneling operations when the -extSSH option is in effect.", "/usr/bin/ssh");
    public static StringParameter extSSHArgs = new StringParameter("extSSHArgs", "Specifies the arguments string or command template to be used by the external SSH client application when the -extSSH option is in effect. The string will be processed according to the same pattern substitution rules as the VNC_TUNNEL_CMD and VNC_VIA_CMD system properties, and can be used to override those in a more command-line friendly way. If not specified, then the appropriate VNC_TUNNEL_CMD or VNC_VIA_CMD command template will be used.", "");
    public static StringParameter sshConfig = new StringParameter("SSHConfig", "Specifies the path to an OpenSSH configuration file that to be parsed by the embedded JSch SSH client during tunneling operations.", FileUtils.getHomeDir() + ".ssh/config");
    public static StringParameter sshKey = new StringParameter("SSHKey", "When using the Via or Tunnel options with the embedded SSH client, this parameter specifies the text of the SSH private key to use when authenticating with the SSH server. You can use \\n within the string to specify a new line.", "");
    public static StringParameter sshKeyFile = new StringParameter("SSHKeyFile", "When using the Via or Tunnel options with the embedded SSH client, this parameter specifies a file that contains an SSH private key (or keys) to use when authenticating with the SSH server. If not specified, ~/.ssh/id_dsa or ~/.ssh/id_rsa will be used (if they exist). Otherwise, the client will fallback to prompting for an SSH password.", "");
    public static StringParameter sshKeyPass = new StringParameter("SSHKeyPass", "When using the Via or Tunnel options with the embedded SSH client, this parameter specifies the passphrase for the SSH key.", "");
    public static BoolParameter customCompressLevel = new BoolParameter("CustomCompressLevel", "Use custom compression level. Default if CompressLevel is specified.", false);
    public static IntParameter compressLevel = new IntParameter("CompressLevel", "Use specified lossless compression level. 0 = Low, 9 = High. Default is 2.", 2);
    public static BoolParameter noJpeg = new BoolParameter("NoJPEG", "Disable lossy JPEG compression in Tight encoding.", false);
    public static IntParameter qualityLevel = new IntParameter("QualityLevel", "JPEG quality level. 0 = Low, 9 = High", 8);
    private static final String IDENTIFIER_STRING = "TigerVNC Configuration file Version 1.0";
    static VoidParameter[] parameterArray = new VoidParameter[]{CSecurityTLS.X509CA, CSecurityTLS.X509CRL, SecurityClient.secTypes, alwaysCursor, cursorType, autoSelect, fullColor, lowColorLevel, preferredEncoding, customCompressLevel, compressLevel, noJpeg, qualityLevel, maximize, fullScreen, fullScreenAllMonitors, desktopSize, remoteResize, viewOnly, shared, acceptClipboard, sendClipboard, menuKey, noLionFS, sendLocalUsername, maxCutText, scalingFactor, acceptBell, via, tunnel, extSSH, extSSHClient, extSSHArgs, sshConfig, sshKeyFile};
    static VoidParameter[] readOnlyParameterArray = new VoidParameter[]{dotWhenNoCursor};
    static LogWriter vlog = new LogWriter("Parameters");

    public static void saveViewerParameters(String string, String string2) {
        if (string == null || string.isEmpty()) {
            Parameters.saveToReg(string2);
            return;
        }
        String string3 = string;
        File file = new File(string3);
        if (file.exists() && !file.canWrite()) {
            throw new com.tigervnc.rfb.Exception(String.format("Failed to write configuration file,can't open %s", string3));
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(file, "UTF-8");
        }
        catch (Exception exception) {
            throw new com.tigervnc.rfb.Exception(exception.getMessage());
        }
        printWriter.println(IDENTIFIER_STRING);
        printWriter.println("");
        if (string2 != null && !string2.isEmpty()) {
            printWriter.println(String.format("ServerName=%s\n", string2));
            Parameters.updateConnHistory(string2);
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            if (parameterArray[i] instanceof StringParameter) {
                printWriter.println(String.format("%s=%s", parameterArray[i].getName(), parameterArray[i].getValueStr()));
                continue;
            }
            if (parameterArray[i] instanceof IntParameter) {
                printWriter.println(String.format("%s=%s", parameterArray[i].getName(), parameterArray[i].getValueStr()));
                continue;
            }
            if (parameterArray[i] instanceof BoolParameter) {
                printWriter.println(String.format("%s=%s", parameterArray[i].getName(), parameterArray[i].getValueStr()));
                continue;
            }
            vlog.error(String.format("Unknown parameter type for parameter %s", parameterArray[i].getName()), new Object[0]);
        }
        printWriter.flush();
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadViewerParameters(String string) throws com.tigervnc.rfb.Exception {
        LineNumberReader lineNumberReader;
        String string2 = "";
        if (string == null) {
            return Parameters.loadFromReg();
        }
        String string3 = string;
        File file = new File(string3);
        if (!file.exists() || !file.canRead()) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            throw new com.tigervnc.rfb.Exception(String.format("Failed to read configuration file, can't open %s", string3));
        }
        String string4 = "";
        try {
            lineNumberReader = new LineNumberReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new com.tigervnc.rfb.Exception(fileNotFoundException.getMessage());
        }
        int n = 0;
        while (string4 != null) {
            try {
                string4 = lineNumberReader.readLine();
                n = lineNumberReader.getLineNumber();
                if (string4 == null) {
                    break;
                }
            }
            catch (IOException iOException) {
                throw new com.tigervnc.rfb.Exception(String.format("Failed to read line %d in file %s: %s", n, string3, iOException.getMessage()));
            }
            if (n == 1) {
                if (string4.equals(IDENTIFIER_STRING)) continue;
                throw new com.tigervnc.rfb.Exception(String.format("Configuration file %s is in an invalid format", string));
            }
            if (string4.trim().isEmpty() || string4.trim().startsWith("#")) continue;
            int n2 = string4.indexOf("=");
            if (n2 == -1) {
                vlog.error(String.format("Failed to read line %d in file %s: %s", n, string, "Invalid format"), new Object[0]);
                continue;
            }
            String string5 = string4.substring(n2 + 1).trim();
            boolean bl = true;
            if (string4.substring(0, n2).trim().equalsIgnoreCase("ServerName")) {
                if (string5.length() > 256) {
                    vlog.error(String.format("Failed to read line %d in file %s: %s", n, string3, "Invalid format or too large value"), new Object[0]);
                    continue;
                }
                string2 = string5;
                bl = false;
            } else {
                for (int i = 0; i < parameterArray.length; ++i) {
                    VoidParameter voidParameter = i < parameterArray.length ? parameterArray[i] : readOnlyParameterArray[i - parameterArray.length];
                    if (voidParameter instanceof StringParameter) {
                        if (!string4.substring(0, n2).trim().equalsIgnoreCase(voidParameter.getName())) continue;
                        if (string5.length() > 256) {
                            vlog.error(String.format("Failed to read line %d in file %s: %s", n, string3, "Invalid format or too large value"), new Object[0]);
                            continue;
                        }
                        ((StringParameter)voidParameter).setParam(string5);
                        bl = false;
                        continue;
                    }
                    if (voidParameter instanceof IntParameter) {
                        if (!string4.substring(0, n2).trim().equalsIgnoreCase(voidParameter.getName())) continue;
                        ((IntParameter)voidParameter).setParam(string5);
                        bl = false;
                        continue;
                    }
                    if (voidParameter instanceof BoolParameter) {
                        if (!string4.substring(0, n2).trim().equalsIgnoreCase(voidParameter.getName())) continue;
                        ((BoolParameter)voidParameter).setParam(string5);
                        bl = false;
                        continue;
                    }
                    vlog.error(String.format("Unknown parameter type for parameter %s", voidParameter.getName()), new Object[0]);
                }
            }
            if (!bl) continue;
            vlog.info(String.format("Unknown parameter %s on line %d in file %s", string4, n, string3), new Object[0]);
        }
        try {
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            vlog.info(iOException.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (lineNumberReader != null) {
                    lineNumberReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string2;
    }

    public static void saveToReg(String string) {
        int n;
        String string2 = "global";
        if (string != null && !string.isEmpty()) {
            UserPreferences.set(string2, "ServerName", string);
            Parameters.updateConnHistory(string);
        }
        for (n = 0; n < parameterArray.length; ++n) {
            if (parameterArray[n] instanceof StringParameter) {
                UserPreferences.set(string2, parameterArray[n].getName(), parameterArray[n].getValueStr());
                continue;
            }
            if (parameterArray[n] instanceof IntParameter) {
                UserPreferences.set(string2, parameterArray[n].getName(), ((IntParameter)parameterArray[n]).getValue());
                continue;
            }
            if (parameterArray[n] instanceof BoolParameter) {
                UserPreferences.set(string2, parameterArray[n].getName(), ((BoolParameter)parameterArray[n]).getValue());
                continue;
            }
            vlog.error(String.format("Unknown parameter type for parameter %s", parameterArray[n].getName()), new Object[0]);
        }
        for (n = 0; n < readOnlyParameterArray.length; ++n) {
            UserPreferences.delete(string2, readOnlyParameterArray[n].getName());
        }
        UserPreferences.save(string2);
    }

    public static String loadFromReg() {
        String string = "global";
        String string2 = UserPreferences.get(string, "ServerName");
        if (string2 == null) {
            string2 = "";
        }
        for (int i = 0; i < parameterArray.length + readOnlyParameterArray.length; ++i) {
            VoidParameter voidParameter = i < parameterArray.length ? parameterArray[i] : readOnlyParameterArray[i - parameterArray.length];
            if (voidParameter instanceof StringParameter) {
                if (UserPreferences.get(string, voidParameter.getName()) == null) continue;
                String string3 = UserPreferences.get(string, voidParameter.getName());
                ((StringParameter)voidParameter).setParam(string3);
                continue;
            }
            if (voidParameter instanceof IntParameter) {
                if (UserPreferences.get(string, voidParameter.getName()) == null) continue;
                int n = UserPreferences.getInt(string, voidParameter.getName());
                ((IntParameter)voidParameter).setParam(n);
                continue;
            }
            if (voidParameter instanceof BoolParameter) {
                if (UserPreferences.get(string, voidParameter.getName()) == null) continue;
                boolean bl = UserPreferences.getBool(string, voidParameter.getName());
                ((BoolParameter)voidParameter).setParam(bl);
                continue;
            }
            vlog.error(String.format("Unknown parameter type for parameter %s", voidParameter.getName()), new Object[0]);
        }
        return string2;
    }

    private static void updateConnHistory(String string) {
        String string2 = "ServerDialog";
        if (string != null && !string.isEmpty()) {
            String string3 = UserPreferences.get(string2, "history");
            String string4 = string3 == null ? "" : string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            StringBuffer stringBuffer = new StringBuffer().append(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string5.equals(string) || string5.equals("")) continue;
                stringBuffer.append(',').append(string5);
            }
            UserPreferences.set(string2, "history", stringBuffer.toString());
            UserPreferences.save(string2);
        }
    }
}

