/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class ImageParameters {
    private COSDictionary dictionary;

    public ImageParameters() {
        this.dictionary = new COSDictionary();
    }

    public ImageParameters(COSDictionary params) {
        this.dictionary = params;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    private COSBase getCOSObject(COSName abbreviatedName, COSName name) {
        COSBase retval = this.dictionary.getDictionaryObject(abbreviatedName);
        if (retval == null) {
            retval = this.dictionary.getDictionaryObject(name);
        }
        return retval;
    }

    private int getNumberOrNegativeOne(COSName abbreviatedName, COSName name) {
        int retval = -1;
        COSNumber number = (COSNumber)this.getCOSObject(abbreviatedName, name);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public int getBitsPerComponent() {
        return this.getNumberOrNegativeOne(COSName.BPC, COSName.BITS_PER_COMPONENT);
    }

    public void setBitsPerComponent(int bpc) {
        this.dictionary.setInt(COSName.BPC, bpc);
    }

    public PDColorSpace getColorSpace() throws IOException {
        return this.getColorSpace(null);
    }

    public PDColorSpace getColorSpace(Map colorSpaces) throws IOException {
        COSBase cs = this.getCOSObject(COSName.CS, COSName.COLORSPACE);
        PDColorSpace retval = null;
        if (cs != null) {
            retval = this.createColorSpace(cs, colorSpaces);
        }
        return retval;
    }

    private PDColorSpace createColorSpace(COSBase cs, Map colorSpaces) throws IOException {
        if (cs instanceof COSName) {
            return PDColorSpaceFactory.createColorSpace(this.toLongName(cs), (Map<String, PDColorSpace>)colorSpaces);
        }
        if (cs instanceof COSArray && ((COSArray)cs).size() == 4 && ((COSArray)cs).get(3) instanceof COSString) {
            COSArray srcArray = (COSArray)cs;
            COSBase csType = srcArray.get(0);
            if (COSName.I.equals(csType) || COSName.INDEXED.equals(csType)) {
                COSArray dstArray = new COSArray();
                dstArray.addAll(srcArray);
                dstArray.set(0, COSName.INDEXED);
                dstArray.set(1, this.toLongName(srcArray.get(1)));
                return PDColorSpaceFactory.createColorSpace(dstArray, (Map<String, PDColorSpace>)colorSpaces);
            }
            throw new IOException("Illegal type of inline image color space: " + csType);
        }
        throw new IOException("Illegal type of object for inline image color space: " + cs);
    }

    private COSBase toLongName(COSBase cs) {
        if (COSName.getPDFName("RGB").equals(cs)) {
            return COSName.DEVICERGB;
        }
        if (COSName.getPDFName("CMYK").equals(cs)) {
            return COSName.DEVICECMYK;
        }
        if (COSName.getPDFName("G").equals(cs)) {
            return COSName.DEVICEGRAY;
        }
        return cs;
    }

    public void setColorSpace(PDColorSpace cs) {
        COSBase base = null;
        if (cs != null) {
            base = cs.getCOSObject();
        }
        this.dictionary.setItem(COSName.CS, base);
    }

    public int getHeight() {
        return this.getNumberOrNegativeOne(COSName.H, COSName.HEIGHT);
    }

    public void setHeight(int h) {
        this.dictionary.setInt(COSName.H, h);
    }

    public int getWidth() {
        return this.getNumberOrNegativeOne(COSName.W, COSName.WIDTH);
    }

    public void setWidth(int w) {
        this.dictionary.setInt(COSName.W, w);
    }

    public List getFilters() {
        List<String> retval = null;
        COSBase filters = this.dictionary.getDictionaryObject(new String[]{"Filter", "F"});
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList<String>(name.getName(), (COSBase)name, this.dictionary, COSName.FILTER);
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFilters(List filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.dictionary.setItem("Filter", (COSBase)obj);
    }

    public boolean isStencil() {
        return this.dictionary.getBoolean(COSName.IM, COSName.IMAGE_MASK, false);
    }

    public void setStencil(boolean isStencil) {
        this.dictionary.setBoolean(COSName.IM, isStencil);
    }
}

