/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class SecurityInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/authinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/authinfo")), "/_opendistro/_security", "/_plugins/_security");
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public SecurityInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final boolean verbose = request.paramAsBoolean("verbose", false);
        String authType = request.param("auth_type", "");
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    X509Certificate[] certs = (X509Certificate[])SecurityInfoAction.this.threadContext.getTransient("_opendistro_security_ssl_peer_certificates");
                    User user = (User)SecurityInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    TransportAddress remoteAddress = (TransportAddress)SecurityInfoAction.this.threadContext.getTransient("_opendistro_security_remote_address");
                    Set<String> securityRoles = SecurityInfoAction.this.evaluator.mapRoles(user, remoteAddress);
                    builder.startObject();
                    builder.field("user", user == null ? null : user.toString());
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("user_requested_tenant", user == null ? null : user.getRequestedTenant());
                    builder.field("remote_address", (ToXContent)remoteAddress);
                    builder.field("backend_roles", user == null ? null : user.getRoles());
                    builder.field("custom_attribute_names", user == null ? null : user.getCustomAttributesMap().keySet());
                    builder.field("roles", securityRoles);
                    builder.field("tenants", SecurityInfoAction.this.evaluator.mapTenants(user, securityRoles));
                    builder.field("principal", (String)SecurityInfoAction.this.threadContext.getTransient("_opendistro_security_ssl_principal"));
                    builder.field("peer_certificates", (String)(certs != null && certs.length > 0 ? "" + certs.length : "0"));
                    builder.field("sso_logout_url", (String)SecurityInfoAction.this.threadContext.getTransient("_opendistro_security_sso_logout_url"));
                    if (user != null && verbose) {
                        try {
                            builder.field("size_of_user", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject(user).length()));
                            builder.field("size_of_custom_attributes", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject((Serializable)((Object)user.getCustomAttributesMap())).getBytes(StandardCharsets.UTF_8).length));
                            builder.field("size_of_backendroles", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject((Serializable)((Object)user.getRoles())).getBytes(StandardCharsets.UTF_8).length));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "OpenSearch Security Info Action";
    }
}

