/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.threadpool.ThreadPool;

public abstract class ClusterStateMetadataDependentPrivileges {
    private static final Logger log = LogManager.getLogger(ClusterStateMetadataDependentPrivileges.class);
    private Future<?> updateFuture;

    public synchronized void updateClusterStateMetadataAsync(ClusterService clusterService, ThreadPool threadPool) {
        long currentMetadataVersion = clusterService.state().metadata().version();
        if (currentMetadataVersion <= this.getCurrentlyUsedMetadataVersion()) {
            return;
        }
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = threadPool.generic().submit(() -> {
                int i = 0;
                while (true) {
                    if (i > 5) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    Metadata metadata = clusterService.state().metadata();
                    ClusterStateMetadataDependentPrivileges clusterStateMetadataDependentPrivileges = this;
                    synchronized (clusterStateMetadataDependentPrivileges) {
                        if (metadata.version() <= this.getCurrentlyUsedMetadataVersion()) {
                            return;
                        }
                    }
                    try {
                        log.debug("Updating {} with metadata version {}", (Object)this, (Object)metadata.version());
                        this.updateClusterStateMetadata(metadata);
                    }
                    catch (Exception e) {
                        log.error("Error while updating {}", (Object)this, (Object)e);
                    }
                    finally {
                        clusterStateMetadataDependentPrivileges = this;
                        synchronized (clusterStateMetadataDependentPrivileges) {
                            if (this.updateFuture.isCancelled()) {
                                return;
                            }
                        }
                    }
                    ++i;
                }
            });
        }
    }

    public synchronized void shutdown() {
        if (this.updateFuture != null && !this.updateFuture.isDone()) {
            this.updateFuture.cancel(true);
        }
    }

    protected abstract void updateClusterStateMetadata(Metadata var1);

    protected abstract long getCurrentlyUsedMetadataVersion();
}

