/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.opensaml.integration;

import java.io.IOException;
import java.io.InputStream;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.config.XMLConfigurationException;
import org.opensaml.core.xml.config.XMLConfigurator;
import org.opensaml.xmlsec.config.impl.XMLObjectProviderInitializer;
import org.opensaml.xmlsec.signature.impl.X509CRLBuilder;
import org.opensaml.xmlsec.signature.impl.X509CertificateBuilder;
import org.opensearch.security.opensaml.integration.SecurityX509CRLBuilder;
import org.opensearch.security.opensaml.integration.SecurityX509CertificateBuilder;
import org.w3c.dom.Element;

public class SecurityXMLObjectProviderInitializer
extends XMLObjectProviderInitializer {
    protected static final Logger log = LogManager.getLogger(SecurityXMLObjectProviderInitializer.class);

    public void init() throws InitializationException {
        try {
            SecurityObjectProviderXMLConfigurator configurator = new SecurityObjectProviderXMLConfigurator();
            for (String resource : this.getConfigResources()) {
                if (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                log.debug("Loading XMLObject provider configuration from resource '{}'", (Object)resource);
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
                    if (is != null) {
                        configurator.load(is);
                        continue;
                    }
                    throw new XMLConfigurationException("Resource not found: " + resource);
                }
                catch (IOException e) {
                    throw new XMLConfigurationException("Error loading resource: " + resource, (Throwable)e);
                }
            }
        }
        catch (XMLConfigurationException e) {
            log.error("Problem loading configuration resource: {}", (Object)e.getMessage());
            throw new InitializationException("Problem loading configuration resource", (Throwable)e);
        }
    }

    static final class SecurityObjectProviderXMLConfigurator
    extends XMLConfigurator {
        public static final String X509_CERTIFICATE_BUILDER_CLASS_NAME = X509CertificateBuilder.class.getCanonicalName();
        public static final String X509_CRL_BUILDER_CLASS_NAME = X509CRLBuilder.class.getCanonicalName();

        protected Object createClassInstance(Element configuration) throws XMLConfigurationException {
            String className = StringSupport.trimOrNull((String)configuration.getAttributeNS(null, "className"));
            if (X509_CERTIFICATE_BUILDER_CLASS_NAME.equals(className)) {
                log.trace("Replace instance of {} with {}", (Object)className, (Object)SecurityX509CertificateBuilder.class.getCanonicalName());
                return new SecurityX509CertificateBuilder();
            }
            if (X509_CRL_BUILDER_CLASS_NAME.equals(className)) {
                log.trace("Replace instance of {} with {}", (Object)className, (Object)SecurityX509CRLBuilder.class.getCanonicalName());
                return new SecurityX509CRLBuilder();
            }
            return super.createClassInstance(configuration);
        }
    }
}

