/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.BitBackedSetImpl;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import com.selectivem.collections.ImmutableCompactSubSet;
import com.selectivem.collections.ImmutableCompactSubSetImpl;
import com.selectivem.collections.IndexedImmutableSetImpl;
import java.util.Set;

public class CompactSubSetBuilder<E> {
    private final IndexedImmutableSetImpl<E> elementToIndexMap;
    private final int bitArraySize;

    public CompactSubSetBuilder(Set<E> superSet) {
        this.elementToIndexMap = IndexedImmutableSetImpl.of(superSet);
        this.bitArraySize = BitBackedSetImpl.bitArraySize(this.elementToIndexMap.size());
    }

    public DeduplicatingCompactSubSetBuilder<E> deduplicatingBuilder() {
        return new DeduplicatingCompactSubSetBuilder<E>(this.elementToIndexMap);
    }

    public ImmutableCompactSubSet<E> of(Set<E> set) {
        int lastNonZero;
        long[] bits = new long[this.bitArraySize];
        int size = 0;
        for (E e : set) {
            int index = this.elementToIndexMap.elementToIndex((Object)e);
            if (!BitBackedSetImpl.setBit(bits, index, 0)) continue;
            ++size;
        }
        if (size == 0) {
            return ImmutableCompactSubSetImpl.empty();
        }
        int firstNonZero = BitBackedSetImpl.firstNonZeroIndex(bits);
        if (firstNonZero == (lastNonZero = BitBackedSetImpl.lastNonZeroIndex(bits))) {
            return new BitBackedSetImpl.LongBacked<E>(bits[firstNonZero], size, this.elementToIndexMap, firstNonZero);
        }
        if (firstNonZero != 0 || lastNonZero != bits.length - 1) {
            long[] oldBits = bits;
            bits = new long[lastNonZero - firstNonZero + 1];
            System.arraycopy(oldBits, firstNonZero, bits, 0, bits.length);
        }
        return new BitBackedSetImpl.LongArrayBacked<E>(bits, size, this.elementToIndexMap, firstNonZero);
    }
}

