/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class SubAckPacket {
    private String reasonString;
    private List<UserProperty> userProperties;
    private List<SubAckReasonCode> reasonCodes;

    public String getReasonString() {
        return this.reasonString;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public List<SubAckReasonCode> getReasonCodes() {
        return this.reasonCodes;
    }

    private SubAckPacket() {
    }

    private void nativeAddSubackCode(int reasonCode) {
        if (this.reasonCodes == null) {
            this.reasonCodes = new ArrayList<SubAckReasonCode>();
        }
        this.reasonCodes.add(SubAckReasonCode.getEnumValueFromInteger(reasonCode));
    }

    public static enum SubAckReasonCode {
        GRANTED_QOS_0(0),
        GRANTED_QOS_1(1),
        GRANTED_QOS_2(2),
        UNSPECIFIED_ERROR(128),
        IMPLEMENTATION_SPECIFIC_ERROR(131),
        NOT_AUTHORIZED(135),
        TOPIC_FILTER_INVALID(143),
        PACKET_IDENTIFIER_IN_USE(145),
        QUOTA_EXCEEDED(151),
        SHARED_SUBSCRIPTIONS_NOT_SUPPORTED(158),
        SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(161),
        WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED(162);

        private int reasonCode;
        private static Map<Integer, SubAckReasonCode> enumMapping;

        private SubAckReasonCode(int code) {
            this.reasonCode = code;
        }

        public int getValue() {
            return this.reasonCode;
        }

        public static SubAckReasonCode getEnumValueFromInteger(int value) {
            SubAckReasonCode enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal SubAckReasonCode");
        }

        private static Map<Integer, SubAckReasonCode> buildEnumMapping() {
            return Stream.of(SubAckReasonCode.values()).collect(Collectors.toMap(SubAckReasonCode::getValue, Function.identity()));
        }

        static {
            enumMapping = SubAckReasonCode.buildEnumMapping();
        }
    }
}

