/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetFpgaImageAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ResetFpgaImageAttributeRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ResetFpgaImageAttributeRequest.getter(ResetFpgaImageAttributeRequest::dryRun)).setter(ResetFpgaImageAttributeRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FpgaImageId").getter(ResetFpgaImageAttributeRequest.getter(ResetFpgaImageAttributeRequest::fpgaImageId)).setter(ResetFpgaImageAttributeRequest.setter(Builder::fpgaImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId").unmarshallLocationName("FpgaImageId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(ResetFpgaImageAttributeRequest.getter(ResetFpgaImageAttributeRequest::attributeAsString)).setter(ResetFpgaImageAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("Attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, FPGA_IMAGE_ID_FIELD, ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResetFpgaImageAttributeRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String fpgaImageId;
    private final String attribute;

    private ResetFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String fpgaImageId() {
        return this.fpgaImageId;
    }

    public final ResetFpgaImageAttributeName attribute() {
        return ResetFpgaImageAttributeName.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetFpgaImageAttributeRequest)) {
            return false;
        }
        ResetFpgaImageAttributeRequest other = (ResetFpgaImageAttributeRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.attributeAsString(), other.attributeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResetFpgaImageAttributeRequest").add("DryRun", (Object)this.dryRun()).add("FpgaImageId", (Object)this.fpgaImageId()).add("Attribute", (Object)this.attributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "FpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageId()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("FpgaImageId", FPGA_IMAGE_ID_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetFpgaImageAttributeRequest, T> g) {
        return obj -> g.apply((ResetFpgaImageAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String fpgaImageId;
        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetFpgaImageAttributeRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.fpgaImageId(model.fpgaImageId);
            this.attribute(model.attribute);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResetFpgaImageAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetFpgaImageAttributeRequest build() {
            return new ResetFpgaImageAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetFpgaImageAttributeRequest> {
        public Builder dryRun(Boolean var1);

        public Builder fpgaImageId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(ResetFpgaImageAttributeName var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

