/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedIpv6PoolCidrsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetAssociatedIpv6PoolCidrsResponse> {
    private static final SdkField<List<Ipv6CidrAssociation>> IPV6_CIDR_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrAssociations").getter(GetAssociatedIpv6PoolCidrsResponse.getter(GetAssociatedIpv6PoolCidrsResponse::ipv6CidrAssociations)).setter(GetAssociatedIpv6PoolCidrsResponse.setter(Builder::ipv6CidrAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrAssociationSet").unmarshallLocationName("ipv6CidrAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6CidrAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetAssociatedIpv6PoolCidrsResponse.getter(GetAssociatedIpv6PoolCidrsResponse::nextToken)).setter(GetAssociatedIpv6PoolCidrsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssociatedIpv6PoolCidrsResponse.memberNameToFieldInitializer();
    private final List<Ipv6CidrAssociation> ipv6CidrAssociations;
    private final String nextToken;

    private GetAssociatedIpv6PoolCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrAssociations = builder.ipv6CidrAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpv6CidrAssociations() {
        return this.ipv6CidrAssociations != null && !(this.ipv6CidrAssociations instanceof SdkAutoConstructList);
    }

    public final List<Ipv6CidrAssociation> ipv6CidrAssociations() {
        return this.ipv6CidrAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrAssociations() ? this.ipv6CidrAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedIpv6PoolCidrsResponse)) {
            return false;
        }
        GetAssociatedIpv6PoolCidrsResponse other = (GetAssociatedIpv6PoolCidrsResponse)((Object)obj);
        return this.hasIpv6CidrAssociations() == other.hasIpv6CidrAssociations() && Objects.equals(this.ipv6CidrAssociations(), other.ipv6CidrAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssociatedIpv6PoolCidrsResponse").add("Ipv6CidrAssociations", this.hasIpv6CidrAssociations() ? this.ipv6CidrAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6CidrAssociations": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ipv6CidrAssociationSet", IPV6_CIDR_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedIpv6PoolCidrsResponse, T> g) {
        return obj -> g.apply((GetAssociatedIpv6PoolCidrsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Ipv6CidrAssociation> ipv6CidrAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedIpv6PoolCidrsResponse model) {
            super(model);
            this.ipv6CidrAssociations(model.ipv6CidrAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<Ipv6CidrAssociation.Builder> getIpv6CidrAssociations() {
            List<Ipv6CidrAssociation.Builder> result = Ipv6CidrAssociationSetCopier.copyToBuilder(this.ipv6CidrAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrAssociations(Collection<Ipv6CidrAssociation.BuilderImpl> ipv6CidrAssociations) {
            this.ipv6CidrAssociations = Ipv6CidrAssociationSetCopier.copyFromBuilder(ipv6CidrAssociations);
        }

        @Override
        public final Builder ipv6CidrAssociations(Collection<Ipv6CidrAssociation> ipv6CidrAssociations) {
            this.ipv6CidrAssociations = Ipv6CidrAssociationSetCopier.copy(ipv6CidrAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrAssociations(Ipv6CidrAssociation ... ipv6CidrAssociations) {
            this.ipv6CidrAssociations(Arrays.asList(ipv6CidrAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrAssociations(Consumer<Ipv6CidrAssociation.Builder> ... ipv6CidrAssociations) {
            this.ipv6CidrAssociations(Stream.of(ipv6CidrAssociations).map(c -> (Ipv6CidrAssociation)((Ipv6CidrAssociation.Builder)Ipv6CidrAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAssociatedIpv6PoolCidrsResponse build() {
            return new GetAssociatedIpv6PoolCidrsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedIpv6PoolCidrsResponse> {
        public Builder ipv6CidrAssociations(Collection<Ipv6CidrAssociation> var1);

        public Builder ipv6CidrAssociations(Ipv6CidrAssociation ... var1);

        public Builder ipv6CidrAssociations(Consumer<Ipv6CidrAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

