/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultCacheCleanupExecutor;
import org.gradle.cache.internal.DefaultCacheCoordinator;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.serialize.Serializer;
import org.jspecify.annotations.Nullable;

public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    public static final int CLEANUP_INTERVAL_IN_HOURS = 24;
    private final File dir;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final String displayName;
    protected final File propertiesFile;
    private final File gcFile;
    private final DefaultCacheCleanupExecutor cleanupExecutor;
    private DefaultCacheCoordinator cacheAccess;

    public DefaultPersistentDirectoryStore(File dir, @Nullable String displayName, LockOptions lockOptions, CacheCleanupStrategy cacheCleanupStrategy, FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.dir = dir;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
        this.propertiesFile = new File(dir, "cache.properties");
        this.gcFile = new File(dir, "gc.properties");
        this.displayName = displayName != null ? displayName + " (" + dir + ")" : "cache directory " + dir.getName() + " (" + dir + ")";
        this.cleanupExecutor = new DefaultCacheCleanupExecutor(this, this.gcFile, cacheCleanupStrategy);
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        try {
            FileUtils.forceMkdir((File)this.dir);
            this.cacheAccess = this.createCacheAccess();
            this.cacheAccess.open();
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    private DefaultCacheCoordinator createCacheAccess() {
        return new DefaultCacheCoordinator(this.displayName, this.getLockTarget(), this.lockOptions, this.dir, this.lockManager, this.getInitAction(), this.cleanupExecutor, this.executorFactory);
    }

    private File getLockTarget() {
        return this.dir;
    }

    protected CacheInitializationAction getInitAction() {
        return CacheInitializationAction.NO_INIT_REQUIRED;
    }

    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    @Override
    public Collection<File> getReservedCacheFiles() {
        return Arrays.asList(this.propertiesFile, this.gcFile, DefaultPersistentDirectoryStore.determineLockTargetFile(this.getLockTarget()));
    }

    static File determineLockTargetFile(File target) {
        return new File(target, target.getName() + ".lock");
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public <K, V> IndexedCache<K, V> createIndexedCache(IndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.newCache((IndexedCacheParameters)parameters);
    }

    @Override
    public <K, V> IndexedCache<K, V> createIndexedCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache((IndexedCacheParameters)IndexedCacheParameters.of(name, keyType, valueSerializer));
    }

    @Override
    public <K, V> boolean indexedCacheExists(IndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.cacheExists(parameters);
    }

    @Override
    public <T> T withFileLock(Supplier<? extends T> action) {
        return this.cacheAccess.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cacheAccess.withFileLock(action);
    }

    @Override
    public <T> T useCache(Supplier<? extends T> action) {
        return this.cacheAccess.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cacheAccess.useCache(action);
    }

    @Override
    public void cleanup() {
        this.cacheAccess.cleanup();
    }
}

