#ifndef _GTK_LOCAL_H_
#define _GTK_LOCAL_H_

#include "gtv/xsub.h"
#include "gcore/glaunch.h"
#include "gtk/gtk.h"
#include "cairo.h"

#define _DASH_SIZE 4

typedef void (*ggtk_gpointer_handler_t)(gpointer);

typedef struct {
    gboolean display_cursor;
    int x, y;
    int width;
    int height;
} CursorData;

typedef struct {
    int x, y;
} Point;

typedef struct {
    Point *pts;          /* dynamic array of points */
    size_t n;            /* number of points used */
    size_t cap;          /* capacity of pts */
    double width;
    gboolean dashed;
    gboolean invert;
    double dash_list[_DASH_SIZE];
    double red;
    double green;
    double blue;
    gboolean filled;
    cairo_line_cap_t    cap_style;     /* CAIRO_LINE_CAP_{BUTT,ROUND,SQUARE} */
    cairo_line_join_t   join_style;    /* CAIRO_LINE_JOIN_{MITER,ROUND,BEVEL} */
} Polyline;

typedef struct {
    Polyline *lines;     /* dynamic array of polylines */
    size_t n;            /* number of polylines used */
    size_t cap;          /* capacity of lines */
} PolyStore;

typedef struct {
    GList *surfaces;
    size_t n;            /* number of images used */
    size_t cap;          /* capacity of positions */
    Point *positions;
} ImageStore;

typedef struct _ggtk_env {
    G_env herit;

    /* Widgets */
    GtkWidget *main_widget;
    GtkWidget *drawing_area;

    /* Post-refresh callback */
    ggtk_gpointer_handler_t post_refresh_handler;
    gpointer                post_refresh_handler_data;

    double              line_width;
    gboolean            line_is_dashed;
    double              dash_list[_DASH_SIZE];

    double red;
    double green;
    double blue;
    gboolean invert;

    cairo_line_cap_t    cap_style;     /* CAIRO_LINE_CAP_{BUTT,ROUND,SQUARE} */
    cairo_line_join_t   join_style;    /* CAIRO_LINE_JOIN_{MITER,ROUND,BEVEL} */
    cairo_antialias_t   antialiasing;

    GArray *poly_or_image_store;
    PolyStore polylines_store;
    ImageStore images_store;
    CursorData cursor;
} ggtk_env_t;

typedef struct _ggtk_toolbar_args {
    gtv_toolbar_args_t herit;
    ggtk_env_t *env;
    char *window_name;
} ggtk_toolbar_args_t;

#endif /* _GTK_LOCAL_H_ */

