/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;

public class Nonterminal
extends Term {
    private final Mark mark;
    private final String alias;
    private final String name;

    public Nonterminal(Mark mark, String alias, String name) {
        this.mark = mark;
        this.alias = alias;
        this.name = name;
    }

    public Mark getMark() {
        return this.mark;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public Mark getEffectiveMark() {
        if (this.mark != Mark.NONE) {
            return this.mark;
        }
        Rule definition = this.grammar.getRule(this.name);
        return definition.getMark() == Mark.NONE ? Mark.NODE : definition.getMark();
    }

    public String getEffectiveAlias() {
        return this.alias != null ? this.alias : this.grammar.getRule(this.name).getAlias();
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public String toString() {
        return String.valueOf((Object)this.mark) + this.name + (String)(this.alias != null ? ">" + this.alias : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.mark == null ? 0 : this.mark.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Nonterminal)) {
            return false;
        }
        Nonterminal other = (Nonterminal)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.mark != other.mark) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

