/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.value.item.QNm;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.hash.ASet;

public class QNmSet
extends ASet
implements Iterable<QNm> {
    protected QNm[] keys = new QNm[this.capacity()];
    private int[] hash = new int[this.capacity()];

    public QNmSet() {
        super(2L);
    }

    public final boolean add(QNm key) {
        return this.store(key) > 0;
    }

    public final int put(QNm key) {
        int i = this.store(key);
        return Math.abs(i);
    }

    public final boolean contains(QNm key) {
        return this.index(key) > 0;
    }

    public final int index(QNm key) {
        int b = key.hashCode() & this.capacity() - 1;
        int i = this.buckets[b];
        while (i != 0) {
            if (key.eq(this.keys[i])) {
                return i;
            }
            i = this.next[i];
        }
        return 0;
    }

    private int store(QNm key) {
        int h = key.hashCode();
        int b = h & this.capacity() - 1;
        int i = this.buckets[b];
        while (i != 0) {
            if (this.keys[i].eq(key)) {
                return -i;
            }
            i = this.next[i];
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = h & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.hash[s] = h;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected final int hashCode(int index) {
        return this.hash[index];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copy(this.keys, new QNm[newSize]);
        this.hash = Arrays.copyOf(this.hash, newSize);
    }

    @Override
    public final Iterator<QNm> iterator() {
        return new ArrayIterator<QNm>(this.keys, 1, this.size);
    }

    public final QNm[] keys() {
        return Arrays.copyOfRange(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString(this.keys);
    }
}

