/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xslt;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.expr.Expr;
import org.basex.query.func.xslt.XsltFn;
import org.basex.query.func.xslt.XsltReport;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;

public class XsltTransform
extends XsltFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        try {
            Str result = (Str)this.transform(qc, true);
            return new DBNode(new IOContent(result.string()));
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Item transform(QueryContext qc, boolean simple) throws QueryException {
        IO input = this.read(this.arg(0), qc);
        IO stylesheet = this.read(this.arg(1), qc);
        HashMap<String, String> arguments = this.toOptions(this.arg(2), qc);
        XsltOptions options = this.toOptions(this.arg(3), new XsltOptions(), qc);
        ArrayOutput result = new ArrayOutput();
        PrintStream errPS = System.err;
        ArrayOutput err = new ArrayOutput();
        XsltReport xr = simple ? null : new XsltReport(qc);
        try {
            System.setErr(new PrintStream(err));
            StreamSource ss = stylesheet.streamSource();
            String key = options.get(XsltOptions.CACHE) != false ? ss.getSystemId() : null;
            Templates templates = key != null ? (Templates)MAP.get(key) : null;
            URIResolver ur = qc.context.options.resolver().uriResolver();
            if (templates == null) {
                TransformerFactory tf = TransformerFactory.newInstance();
                if (ur != null) {
                    tf.setURIResolver(ur);
                }
                templates = tf.newTemplates(ss);
                if (key != null) {
                    MAP.put(key, templates);
                }
            }
            Transformer tr = templates.newTransformer();
            if (ur != null) {
                tr.setURIResolver(ur);
            }
            arguments.forEach(tr::setParameter);
            if (simple) {
                tr.transform(input.streamSource(), new StreamResult(result));
                Str str = Str.get(result.finish());
                return str;
            }
            xr.register(tr);
            tr.transform(input.streamSource(), new StreamResult(result));
            xr.addMessage();
        }
        catch (IllegalArgumentException ex) {
            if (simple) {
                throw QueryError.XSLT_ERROR_X.get(this.info, ex);
            }
            xr.addError(Str.get(Util.message(ex)));
        }
        catch (TransformerException | TransformerFactoryConfigurationError ex) {
            Util.debug(ex);
            StringList list = new StringList();
            Consumer<String> add = string -> {
                String normalized;
                String string2 = normalized = string != null ? string.replaceAll("\\s+", " ").trim() : "";
                if (!normalized.isEmpty()) {
                    list.addUnique(normalized);
                }
            };
            for (Throwable th = ex; th != null; th = th.getCause()) {
                add.accept(th.getMessage());
            }
            try {
                add.accept(new String(err.toArray(), Prop.CHARSET));
            }
            catch (Exception e) {
                Util.debug(e);
                add.accept(e.getMessage());
            }
            String error = String.join((CharSequence)"; ", (CharSequence[])((StringList)list.reverse()).finish());
            if (simple) {
                throw QueryError.XSLT_ERROR_X.get(this.info, error);
            }
            xr.addError(Str.get(error));
            xr.addMessage();
        }
        finally {
            System.setErr(errPS);
        }
        xr.addResult(result.finish());
        return xr.finish();
    }

    private IO read(Expr expr, QueryContext qc) throws QueryException {
        Item item = this.toNodeOrAtomItem(expr, false, qc);
        if (item instanceof ANode) {
            ANode node = (ANode)item;
            try {
                Uri base = node.baseURI(this.sc().baseURI(), true, this.info);
                return new IOContent(item.serialize().finish(), Token.string(base.string()));
            }
            catch (QueryIOException ex) {
                throw ex.getCause(this.info);
            }
        }
        Type type = item.type;
        if (type.isStringOrUntyped()) {
            return this.toIO(this.toString(item), true);
        }
        throw QueryError.STRNOD_X_X.get(this.info, type, item);
    }

    public static final class XsltOptions
    extends Options {
        public static final BooleanOption CACHE = new BooleanOption("cache", false);
    }
}

