/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.expr.path.DocTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public class NodeTest
extends Test {
    public static final NodeTest DOCUMENT_NODE = new NodeTest(NodeType.DOCUMENT_NODE);
    public static final NodeTest ELEMENT = new NodeTest(NodeType.ELEMENT){

        @Override
        public String toString(boolean full) {
            return full ? this.type.toString() : "*";
        }
    };
    public static final NodeTest ATTRIBUTE = new NodeTest(NodeType.ATTRIBUTE);
    public static final NodeTest PROCESSING_INSTRUCTION = new NodeTest(NodeType.PROCESSING_INSTRUCTION);
    public static final NodeTest TEXT = new NodeTest(NodeType.TEXT);
    public static final NodeTest COMMENT = new NodeTest(NodeType.COMMENT);
    public static final NodeTest NAMESPACE_NODE = new NodeTest(NodeType.NAMESPACE_NODE);
    public static final NodeTest NODE = new NodeTest(NodeType.NODE){

        @Override
        public boolean matches(ANode node) {
            return true;
        }

        @Override
        public boolean instanceOf(Test test) {
            return false;
        }

        @Override
        public Test intersect(Test test) {
            return test;
        }
    };
    public static final NodeTest FALSE = new NodeTest(NodeType.NODE){

        @Override
        public boolean matches(ANode node) {
            return false;
        }

        @Override
        public boolean instanceOf(Test test) {
            return false;
        }

        @Override
        public Test intersect(Test test) {
            return null;
        }
    };

    NodeTest(NodeType type) {
        super(type);
    }

    public static NodeTest get(NodeType type) {
        return switch (type) {
            case NodeType.TEXT -> TEXT;
            case NodeType.PROCESSING_INSTRUCTION -> PROCESSING_INSTRUCTION;
            case NodeType.ELEMENT -> ELEMENT;
            case NodeType.DOCUMENT_NODE -> DOCUMENT_NODE;
            case NodeType.ATTRIBUTE -> ATTRIBUTE;
            case NodeType.COMMENT -> COMMENT;
            case NodeType.NODE -> NODE;
            case NodeType.NAMESPACE_NODE -> NAMESPACE_NODE;
            default -> throw Util.notExpected();
        };
    }

    @Override
    public final NodeTest copy() {
        return this;
    }

    @Override
    public Test optimize(Data data) {
        return this == FALSE ? null : this;
    }

    @Override
    public boolean matches(ANode node) {
        return node.type == this.type;
    }

    @Override
    public Boolean matches(SeqType seqType) {
        Type tp = seqType.type;
        if (tp.intersect(this.type) == null) {
            return Boolean.FALSE;
        }
        return tp.instanceOf(this.type) ? Boolean.TRUE : null;
    }

    @Override
    public boolean instanceOf(Test test) {
        return (test instanceof NodeTest || test instanceof UnionTest) && super.instanceOf(test);
    }

    @Override
    public Test intersect(Test test) {
        if (test instanceof NodeTest) {
            return this.instanceOf(test) ? this : (test.instanceOf(this) ? test : null);
        }
        if (test instanceof NameTest || test instanceof DocTest) {
            return test.instanceOf(this) ? test : null;
        }
        if (test instanceof UnionTest) {
            return test.intersect(this);
        }
        return null;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public String toString(boolean full) {
        return this.type.toString();
    }
}

