# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Values can be systemAssignedIdentity or userAssignedIdentity."""

    SYSTEM_ASSIGNED_IDENTITY = "systemAssignedIdentity"
    USER_ASSIGNED_IDENTITY = "userAssignedIdentity"
    DELEGATED_RESOURCE_IDENTITY = "delegatedResourceIdentity"


class InfrastructureEncryption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Values are enabled and disabled."""

    ENABLED = "enabled"
    DISABLED = "disabled"


class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the operation refers to the primary or secondary key."""

    PRIMARY = "primary"
    SECONDARY = "secondary"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Kind of the Maps Account."""

    GEN1 = "Gen1"
    GEN2 = "Gen2"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"


class Name(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the SKU, in standard format (such as S0)."""

    S0 = "S0"
    S1 = "S1"
    G2 = "G2"


class SigningKey(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Map account key to use for signing. Picking ``primaryKey`` or ``secondaryKey`` will use the
    Map account Shared Keys, and using ``managedIdentity`` will use the auto-renewed private key to
    sign the SAS.
    """

    PRIMARY_KEY = "primaryKey"
    SECONDARY_KEY = "secondaryKey"
    MANAGED_IDENTITY = "managedIdentity"
